/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.format;

import com.silabs.pti.debugchannel.DebugMessage;
import com.silabs.pti.debugchannel.EventType;
import com.silabs.pti.format.IDebugChannelExportFormat;
import com.silabs.pti.format.IDebugChannelExportOutput;
import com.silabs.pti.format.PrintStreamOutput;
import com.silabs.pti.util.WiresharkUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public class TextFileFormat
implements IDebugChannelExportFormat<PrintStream> {
    @Override
    public IDebugChannelExportOutput<PrintStream> createOutput(File f, boolean append) throws IOException {
        return new PrintStreamOutput(f, append);
    }

    @Override
    public IDebugChannelExportOutput<PrintStream> createStdoutOutput() {
        return new PrintStreamOutput(System.out);
    }

    @Override
    public void writeHeader(PrintStream out) {
    }

    @Override
    public String description() {
        return "Text file format that can be used with wireshark by running through 'text2pcap -q -t %H:%M:%S. <FILENAME>'";
    }

    @Override
    public boolean isUsingRawBytes() {
        return false;
    }

    @Override
    public boolean isUsingDebugMessages() {
        return true;
    }

    @Override
    public boolean formatDebugMessage(PrintStream out, String originator, DebugMessage dm, EventType type) throws IOException {
        if (!type.isPacket()) {
            return false;
        }
        long timeMs = dm.networkTime();
        byte[] contents = dm.contents();
        int[] drops = WiresharkUtil.dropBytesFromBeginningEnd(type);
        if (drops[0] != 0 || drops[1] != 0) {
            if (drops[0] + drops[1] >= contents.length) {
                return false;
            }
            contents = Arrays.copyOfRange(contents, drops[0], contents.length - drops[1]);
        }
        out.println(WiresharkUtil.printText2Pcap(timeMs, contents));
        return true;
    }

    @Override
    public boolean formatRawBytes(PrintStream out, long pcTimeMs, byte[] rawBytes, int offset, int length) {
        return false;
    }

    @Override
    public void writeRawUnframedData(PrintStream out, byte[] rawBytes, int offset, int length) throws IOException {
    }
}

