/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.protocol;

import com.silabs.pti.decode.ISparseFieldEnum;
import com.silabs.pti.protocol.ZWaveRegion;

public enum Protocol implements ISparseFieldEnum
{
    UNKNOWN("Unknown", -1, 0, null),
    CUSTOM("Custom", 0, 2, null),
    EMBER_PHY("EFR32 EmberPHY", 1, 2, null),
    THREAD_ON_RAIL("Thread on RAIL", 2, 2, "IP"),
    BLE("BLE", 3, 3, "BLUETOOTH"),
    CONNECT_ON_RAIL("Connect on RAIL", 4, 2, "CONNECT"),
    ZIGBEE_ON_RAIL("ZigBee on RAIL", 5, 2, "ZIGBEE"),
    ZWAVE_ON_RAIL("Z-Wave on RAIL", 6, -1, "ZWAVE"),
    WISUN("Wi-SUN", 7, 4, "WISUN");

    private final int crcLen;
    private final int id;
    private final String title;
    private final String stackId;

    private Protocol(String title, int id, int crcLen, String stackId) {
        this.crcLen = crcLen;
        this.id = id;
        this.title = title;
        this.stackId = stackId;
    }

    public int crcLen() {
        return this.crcLen;
    }

    public boolean isCrcLengthDynamicallyCalculated() {
        return this.crcLen == -1;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String title() {
        return this.title;
    }

    public String stackId() {
        return this.stackId;
    }

    public boolean isUndetermined() {
        return this == UNKNOWN || this == CUSTOM;
    }

    public static int crcLen(Protocol p, byte[] payload) {
        if (p.isCrcLengthDynamicallyCalculated()) {
            switch (p) {
                case ZWAVE_ON_RAIL: {
                    return ZWaveRegion.calculateZWaveCrcLength(payload);
                }
            }
            return p.crcLen();
        }
        return p.crcLen();
    }

    public static Protocol resolve(int id) {
        switch (id) {
            case 0: {
                return CUSTOM;
            }
            case 1: {
                return EMBER_PHY;
            }
            case 2: {
                return THREAD_ON_RAIL;
            }
            case 3: {
                return BLE;
            }
            case 4: {
                return CONNECT_ON_RAIL;
            }
            case 5: {
                return ZIGBEE_ON_RAIL;
            }
            case 6: {
                return ZWAVE_ON_RAIL;
            }
            case 7: {
                return WISUN;
            }
        }
        return UNKNOWN;
    }
}

