/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.util;

import com.silabs.na.pcap.util.ByteArrayUtil;
import com.silabs.pti.debugchannel.EventType;

public class WiresharkUtil {
    public static byte[] PCAP_DATA_PREFIX = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128, -102};

    public static String printText2Pcap(long time, byte[] data) {
        byte[] prefix = PCAP_DATA_PREFIX;
        long useconds = time % 1000000L;
        long seconds = time / 1000000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        byte[] raw = prefix;
        return String.format("%02d:%02d:%02d.%06d 000000 %s %s", hours, minutes % 60L, seconds % 60L, useconds, ByteArrayUtil.formatByteArray((byte[])raw), ByteArrayUtil.formatByteArray((byte[])data));
    }

    public static int lsbfCrc(byte[] data, int startIndex, int endIndex, int polynom) {
        int crc = 0;
        for (int j = startIndex; j < endIndex && j >= 0 && j < data.length; ++j) {
            byte x = data[j];
            crc ^= x & 0xFF;
            for (int i = 0; i < 8; ++i) {
                if ((crc & 1) != 0) {
                    crc = crc >> 1 ^ polynom;
                    continue;
                }
                crc >>= 1;
            }
        }
        return crc & 0xFFFF;
    }

    public static int[] dropBytesFromBeginningEnd(EventType type) {
        int[] drops = new int[]{0, 0};
        if (!type.hasNoLengthByte()) {
            drops[0] = 1;
        }
        if (type == EventType.TX_350 || type == EventType.TX_250) {
            drops[1] = 1;
        } else if (type == EventType.RX_350 || type == EventType.RX_250) {
            drops[1] = 3;
        } else if (type == EventType.RX_EFR) {
            drops[1] = 5;
            drops[0] = drops[0] + 1;
        } else if (type == EventType.TX_EFR) {
            drops[1] = 3;
            drops[0] = drops[0] + 1;
        }
        return drops;
    }

    public static enum PcapngExportMode {
        NOFCS("nofcs"),
        WISUN_AUTO("wisun-auto"),
        WISUN_RAIL_WISUN("wisun"),
        WISUN_RAIL_CUSTOM("wisun-custom");

        private final String id;

        private PcapngExportMode(String id) {
            this.id = id;
        }

        public static PcapngExportMode resolve(String s) {
            for (PcapngExportMode m : PcapngExportMode.values()) {
                if (!m.id.equals(s)) continue;
                return m;
            }
            return PcapngExportMode.defaultMode();
        }

        public static PcapngExportMode defaultMode() {
            return NOFCS;
        }

        public String id() {
            return this.id;
        }

        public boolean isWisun() {
            return this.id.startsWith("wisun");
        }
    }
}

