/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.api.cryptoprofile.core;

import com.silabs.java.utils.extension.Extension;
import com.silabs.java.utils.extension.IExtensionHandler;
import com.silabs.ss.support.mcu.api.cryptoprofile.core.CryptoProfile;
import com.silabs.ss.support.mcu.api.cryptoprofile.core.CryptoProfileType;
import com.silabs.ss.support.mcu.internal.api.cryptoprofile.extensions.CryptoProfileTypeProviderExtParser;
import com.silabs.ss.support.mcu.internal.api.cryptoprofile.extensions.CryptoProfileTypeProviderExtension;
import com.silabs.ss.support.mcu.internal.cryptoprofile.core.Activator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class CryptoProfileManager {
    private static final String BUNDLE_ID = Activator.id();
    private static final String CRYPTO_PROFILER_PROVIDER_EXTENSION_ID = String.valueOf(BUNDLE_ID) + ".cryptoProfileProvider";
    public static final String NONE_PROFILE_ID = "CryptoProfileManager.None";
    public static final String NONE_PROFILE_NAME = "None";
    private final List<CryptoProfileTypeProviderExtension> providers = new ArrayList<CryptoProfileTypeProviderExtension>();
    private final List<CryptoProfile> profiles = new ArrayList<CryptoProfile>();

    public static final CryptoProfileManager instance() {
        return LazyInstantiator.INSTANCE;
    }

    public static boolean isNoneProfile(CryptoProfile p) {
        return p == null || p.getId().equals(NONE_PROFILE_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CryptoProfile[] getProfiles() {
        List<CryptoProfile> list = this.profiles;
        synchronized (list) {
            if (this.profiles.isEmpty()) {
                List<CryptoProfileTypeProviderExtension> list2 = this.providers;
                synchronized (list2) {
                    HashMap<String, Object> noneProps = new HashMap<String, Object>();
                    noneProps.put("Description", "Use this profile for unlocked secure devices.");
                    this.profiles.add(new CryptoProfile(NONE_PROFILE_NAME, NONE_PROFILE_ID, null, noneProps));
                    for (CryptoProfileTypeProviderExtension provider : this.providers) {
                        if (provider.getProfileTypes() == null) continue;
                        CryptoProfileType[] cryptoProfileTypeArray = provider.getProfileTypes();
                        int n = cryptoProfileTypeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CryptoProfileType profileType = cryptoProfileTypeArray[n2];
                            this.profiles.add(profileType.createProfile());
                            ++n2;
                        }
                    }
                }
            }
            return this.profiles.toArray(new CryptoProfile[this.profiles.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        List<CryptoProfile> list = this.profiles;
        synchronized (list) {
            this.profiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtensionPoints() {
        List data = Extension.instance().extensions(CRYPTO_PROFILER_PROVIDER_EXTENSION_ID, (IExtensionHandler)new CryptoProfileTypeProviderExtParser()).collect(Collectors.toList());
        List<CryptoProfileTypeProviderExtension> list = this.providers;
        synchronized (list) {
            for (CryptoProfileTypeProviderExtension x : data) {
                this.providers.add(x);
            }
        }
    }

    private static class LazyInstantiator {
        private static final CryptoProfileManager INSTANCE = new CryptoProfileManager();

        static {
            INSTANCE.loadExtensionPoints();
        }

        private LazyInstantiator() {
        }
    }
}

