/***************************************************************************//**
 * @file
 * @brief BT Mesh Firmware Update Client
 *******************************************************************************
 * # License
 * <b>Copyright 2023 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 ******************************************************************************/

#ifndef SL_BTMESH_FIRMWARE_UPDATE_CLIENT_H
#define SL_BTMESH_FIRMWARE_UPDATE_CLIENT_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

/***************************************************************************//**
 * @addtogroup btmesh_firmware_update_client BT Mesh Firmware Update Client
 * @{
 ******************************************************************************/

/***************************************************************************//**
 * Handle Firmware Update Client events.
 *
 * This function is called automatically after enabling the component.
 *
 * @param[in] evt  Pointer to incoming event.
 *
 ******************************************************************************/
void sl_btmesh_firmware_update_client_on_event(const sl_btmesh_msg_t *const evt);

/** @} end btmesh_firmware_update_client */

#ifdef __cplusplus
}
#endif // __cplusplus

 #endif // SL_BTMESH_FIRMWARE_UPDATE_CLIENT_H
