/*******************************************************************************
 * @file
 * @brief Blink PWM examples functions
 *******************************************************************************
 * # License
 * <b>Copyright 2025 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc. Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement. This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/
#include "blink_pwm_app.h"
#include "sl_pwm.h"
#include "sl_sleeptimer.h"
#include "FreeRTOS.h"
#include "task.h"
#include "sl_pwm_instances.h"

uint8_t pwm_lut[] = {
  0, 1, 1, 1, 2, 2, 2, 2, 2, 2,
  2, 3, 3, 3, 3, 3, 4, 4, 4, 4,
  5, 5, 5, 5, 6, 6, 6, 7, 7, 7,
  8, 8, 8, 9, 9, 10, 10, 10, 11, 11,
  12, 12, 13, 13, 14, 15, 15, 16, 17, 17,
  18, 19, 19, 20, 21, 22, 23, 23, 24, 25,
  26, 27, 28, 29, 30, 31, 32, 34, 35, 36,
  37, 39, 40, 41, 43, 44, 46, 48, 49, 51,
  53, 54, 56, 58, 60, 62, 64, 66, 68, 71,
  73, 75, 78, 80, 83, 85, 88, 91, 94, 97,
  100,
};

void blink_pwm_init(void)
{
  // Enable PWM output
  sl_pwm_start(&sl_pwm_led0);
}

void blink_pwm_process_action(void)
{
  for (uint8_t i = 0; i < 100; i++) {
    sl_pwm_set_duty_cycle(&sl_pwm_led0, pwm_lut[i]);
    vTaskDelay(pdMS_TO_TICKS(6));
    if (i == 0) {
      vTaskDelay(pdMS_TO_TICKS(190));
    }
  }
  for (uint8_t i = 100; i > 0; i--) {
    sl_pwm_set_duty_cycle(&sl_pwm_led0, pwm_lut[i]);
    vTaskDelay(pdMS_TO_TICKS(6));
    if (i == 100) {
      vTaskDelay(pdMS_TO_TICKS(190));
    }
  }
}
