/***************************************************************************//**
 * @file
 * @brief Pictures for memLCD
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 ******************************************************************************/
#ifndef SL_RAIL_SDK_IMAGES_H
#define SL_RAIL_SDK_IMAGES_H

#pragma pack(1)

typedef struct {
  uint8_t img_x;
  uint8_t img_y;
  uint8_t* image_bits;
} imgType_t;

static const uint8_t silabsLogo_image_bits[] =
{ /*SI Labs*/
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xcf, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0x01, 0x00, 0x00, 0xc0,
  0xff, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xff, 0x3f,
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x1f, 0xfc, 0xff, 0xff, 0xff, 0xff,
  0xf3, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x1f, 0xf8,
  0xff, 0xff, 0xff, 0x7f, 0xfc, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00,
  0xfc, 0xff, 0x1f, 0xf0, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0x7f, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x1f, 0xe0, 0xff, 0xff, 0xff, 0xc3,
  0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x0f, 0xc0,
  0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xff, 0x07, 0xc0, 0xff, 0xff, 0x1f, 0xf8, 0xff, 0xff, 0x03, 0x00,
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x01, 0xc0, 0xff, 0xff, 0x07, 0xfc,
  0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x7f, 0x00, 0x80,
  0xff, 0xff, 0x01, 0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xf8, 0x0f, 0x00, 0x80, 0xff, 0x7f, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x3f, 0x80, 0xff,
  0xff, 0xff, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xc0,
  0xff, 0x0f, 0x80, 0xff, 0xff, 0xff, 0x00, 0xfc, 0xff, 0xff, 0xff, 0xff,
  0x01, 0x00, 0x00, 0xc0, 0xff, 0x03, 0xc0, 0xff, 0xff, 0xff, 0xe0, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0xe0, 0xff, 0x01, 0xc0, 0xff,
  0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xe0,
  0xff, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0x01, 0x00, 0xf0, 0x7f, 0x00, 0x80, 0xff, 0xff, 0xff, 0x0f, 0xfc,
  0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0xf8, 0x3f, 0x00, 0x80, 0xff,
  0xff, 0xff, 0x3f, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0x0f, 0x00, 0xfc,
  0x1f, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0xc0, 0xff, 0xff,
  0xff, 0x0f, 0x00, 0xfe, 0x0f, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 0xff,
  0xff, 0x0f, 0xff, 0xff, 0xff, 0x1f, 0x00, 0xff, 0x07, 0x00, 0x00, 0xf0,
  0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0x1f, 0x80, 0xff,
  0x07, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xf8, 0xff,
  0xff, 0x1f, 0xc0, 0xff, 0x03, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff,
  0xff, 0x00, 0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0x03, 0x00, 0x00, 0x00,
  0x00, 0xfe, 0xff, 0x3f, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x0f, 0xfc, 0xff,
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff,
  0xff, 0x07, 0xfe, 0xff, 0x01, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xf8, 0xff, 0xff, 0x83, 0xff, 0xff, 0x01, 0x00, 0xc0, 0xff,
  0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xe1, 0xff, 0xff,
  0x03, 0x00, 0xf0, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff,
  0xff, 0xf8, 0xff, 0xff, 0x03, 0x00, 0xf8, 0xff, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xff, 0xff, 0x3f, 0xff, 0xff, 0xff, 0x03, 0x00, 0xfe, 0xff,
  0x03, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff,
  0x07, 0x00, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x0f, 0x80, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00,
  0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xc0, 0xff, 0xff,
  0x07, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x3f, 0xc0, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0x00, 0x00, 0x80,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x81, 0xff, 0xff,
  0xff, 0x1f, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x03, 0x3e, 0x9f, 0x7f, 0x7e, 0xe0, 0x07, 0x3e,
  0xcf, 0xff, 0x9f, 0xff, 0xe3, 0x0f, 0xf8, 0xc0, 0x01, 0x3e, 0x9f, 0x7f,
  0x3e, 0xc0, 0x03, 0x3c, 0xce, 0xff, 0x9f, 0xff, 0xe3, 0x0f, 0x70, 0x80,
  0x79, 0x3e, 0x9f, 0x7f, 0x3e, 0xcf, 0xf3, 0x3c, 0xce, 0xff, 0x9f, 0xff,
  0xe3, 0xcf, 0x73, 0x9e, 0x79, 0x3e, 0x9f, 0x7f, 0x3e, 0xcf, 0xf3, 0x3c,
  0xcc, 0xff, 0x9f, 0xff, 0xe3, 0xcf, 0x73, 0x9e, 0xf9, 0x3f, 0x9f, 0x7f,
  0x3e, 0xff, 0xf3, 0x3c, 0xcc, 0xff, 0x9f, 0xff, 0xc9, 0xcf, 0x73, 0xfe,
  0xe1, 0x3f, 0x9f, 0x7f, 0x3e, 0xff, 0xf3, 0x3c, 0xcc, 0xff, 0x9f, 0xff,
  0xc9, 0xcf, 0x73, 0xf8, 0x87, 0x3f, 0x9f, 0x7f, 0x3e, 0xff, 0xf3, 0x3c,
  0xc9, 0xff, 0x9f, 0xff, 0xc9, 0x0f, 0xf8, 0xe1, 0x1f, 0x3e, 0x9f, 0x7f,
  0x3e, 0xff, 0xf3, 0x3c, 0xc9, 0xff, 0x9f, 0xff, 0x9c, 0x0f, 0xf8, 0x87,
  0x7f, 0x3e, 0x9f, 0x7f, 0x3e, 0xff, 0xf3, 0x3c, 0xc3, 0xff, 0x9f, 0xff,
  0x9c, 0xcf, 0xf3, 0x9f, 0x7f, 0x3e, 0x9f, 0x7f, 0x3e, 0xff, 0xf3, 0x3c,
  0xc3, 0xff, 0x9f, 0xff, 0x80, 0xcf, 0xf3, 0x9f, 0x79, 0x3e, 0x9f, 0x7f,
  0x3e, 0xcf, 0xf3, 0x3c, 0xc7, 0xff, 0x9f, 0x7f, 0x80, 0xcf, 0x73, 0x9e,
  0x79, 0x3e, 0x9f, 0x7f, 0x3e, 0xcf, 0xf3, 0x3c, 0xc7, 0xff, 0x9f, 0x7f,
  0x3e, 0xcf, 0x73, 0x9e, 0x01, 0x3e, 0x1f, 0x70, 0x3e, 0xc0, 0x03, 0x3c,
  0xc7, 0xff, 0x1f, 0x70, 0x3e, 0x0f, 0x70, 0x80, 0x03, 0x3f, 0x1f, 0x70,
  0x7e, 0xe0, 0x07, 0x3e, 0xcf, 0xff, 0x1f, 0x70, 0x3e, 0x0f, 0xf8, 0xc0,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

static const imgType_t silabsLogo =
{
  128U,
  63U,
  (uint8_t*)silabsLogo_image_bits
};

// 8x8 Down Arrow
static const uint8_t icon_down_image_bits[] = { 0x1C, 0x1C, 0x1C, 0x5D, 0x3E, 0x1C, 0x08, 0x00 };

imgType_t icon_down =
{
  8U,
  8U,
  (uint8_t*)icon_down_image_bits
};

// + / - 24x8

static const uint8_t icon_plusminus_image_bits[] =
{
  0x00,
  0x18,
  0x18,
  0x7E,
  0x18,
  0x18,
  0x00,
  0x00,
};

imgType_t icon_plusminus =
{
  8U,
  8U,
  (uint8_t*)icon_plusminus_image_bits
};

imgType_t * icons[] =
{
  &icon_down,
  &icon_plusminus,
  /* ... */
};

#pragma pack()

#endif // SL_RAIL_SDK_IMAGES_H
