/***************************************************************************//**
 * @file
 * @brief app_process.h
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 ******************************************************************************/
#ifndef APP_PROCESS_H
#define APP_PROCESS_H

// -----------------------------------------------------------------------------
//                                   Includes
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//                              Macros and Typedefs
// -----------------------------------------------------------------------------
/// Allowed states for the app
typedef enum {
  S_SCHEDULE_TX,      //!< Sending scheduled packets
  S_RESPONSE_DELAY,   //!< Waiting for to start response listening
  S_UNLIMITED_ACCESS, //!< Stay in RX until the next TX
  S_IDLE_OR_RX,       //!< Got to sleep or idle depending on the power manager or go back to RX if unlimited access is selected
  S_TX_DONE,          //!< Sending is successfully done
} state_t;
// -----------------------------------------------------------------------------
//                                Global Variables
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//                          Public Function Declarations
// -----------------------------------------------------------------------------
/**************************************************************************//**
 * The function is used for Application logic.
 *
 * @param[in] rail_handle RAIL handle
 *
 * The function is used for Application logic.
 * It is called infinitely.
 *****************************************************************************/
void app_process_action(void);

/*******************************************************************************
 * Set the next state for the process state machine
 * @param[in] next_state: Which state will the sate machine enter next time
 ******************************************************************************/
void set_next_state(state_t next_state);

#endif  // APP_PROCESS_H
