/***************************************************************************//**
 * @file sl_wisun_network_measurement_gui.h
 * @brief Wi-SUN Network Measurement GUI
 *******************************************************************************
 * # License
 * <b>Copyright 2021 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 ******************************************************************************/
#ifndef SL_WISUN_NETWORK_MEASUREMENT_GUI_H
#define SL_WISUN_NETWORK_MEASUREMENT_GUI_H

#ifdef __cplusplus
extern "C" {
#endif

// -----------------------------------------------------------------------------
//                                   Includes
// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
//                              Macros and Typedefs
// -----------------------------------------------------------------------------
typedef struct sl_wisun_nwm_logo_form_args {
  const char *network_name;
  const char *join_state_str;
  uint32_t join_state;
} sl_wisun_nwm_logo_form_args_t;
// -----------------------------------------------------------------------------
//                                Global Variables
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//                          Public Function Declarations
// -----------------------------------------------------------------------------

/**************************************************************************//**
 * @brief Scroll Text box
 * @details Callback function
 * @param[in] args Arguments
 *****************************************************************************/
void sli_wisun_scroll_txt_box(void *args);

/**************************************************************************//**
 * @brief Scroll optionlist and set selected
 * @details Callback function
 * @param[in] args Arguments
 *****************************************************************************/
void sli_wisun_scroll_optionlist_and_set_select(void *args);

/**************************************************************************//**
 * @brief Network Measurement Main form
 * @details Renderer Main form
 * @param[in] args Arguments
 *****************************************************************************/
void sl_wisun_nwm_main_form(void *args);

/**************************************************************************//**
 * @brief Network Measurement Settings form
 * @details Renderer Settings form
 * @param[in] args Arguments
 *****************************************************************************/
void sli_wisun_settings_form(void *args);

/**************************************************************************//**
 * @brief Network Measurement Logo form
 * @details Renderer Logo form during connection
 * @param[in] args Arguments
 *****************************************************************************/
void sli_wisun_nwm_logo_form(void *args);

/**************************************************************************//**
 * @brief Neighbor select form
 * @details Form renderer
 * @param[in] args Arguments
 *****************************************************************************/
void sli_wisun_neighbors_select_form(void *args);

#ifdef __cplusplus
}
#endif

#endif // SL_WISUN_NETWORK_MEASUREMENT_GUI_H
