/***************************************************************************//**
 * @file sl_wisun_rtt_logger_config.h
 * @brief Wi-SUN RTT Logger component configuration
 *******************************************************************************
 * # License
 * <b>Copyright 2025 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 ******************************************************************************/
#ifndef SL_WISUN_RTT_LOGGER_CONFIG_H
#define SL_WISUN_RTT_LOGGER_CONFIG_H

/**************************************************************************//**
 * @defgroup SL_WISUN_RTT_LOGGER_CONFIG Configurations
 * @ingroup SL_WISUN_RTT_LOGGER_API
 * @{
 *****************************************************************************/

// <<< Use Configuration Wizard in Context Menu >>>

// <h>Wi-SUN RTT Logger configuration

// <o SL_WISUN_RTT_LOGGER_TIMER_REPORT_PERIOD_S> The RTT report period in seconds
// <i> Default: 10
#define SL_WISUN_RTT_LOGGER_TIMER_REPORT_PERIOD_S       10UL

// </h>

// <<< end of configuration section >>>

/** @}*/

#endif // SL_WISUN_RTT_LOGGER_CONFIG_H
