/**************************************************************************//**
 * @file
 * @brief CMSIS Cortex-M Peripheral Access Layer for Silicon Laboratories
 *        microcontroller devices
 *
 * This is a convenience header file for defining the part number on the
 * build command line, instead of specifying the part specific header file.
 *
 * @verbatim
 * Example: Add "-DEFM32G890F128" to your build options, to define part
 *          Add "#include "em_device.h" to your source files

 *
 * @endverbatim
 ******************************************************************************
 * # License
 * <b>Copyright 2025 Silicon Laboratories, Inc. www.silabs.com</b>
 ******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 *****************************************************************************/

#ifndef EM_DEVICE_H
#define EM_DEVICE_H
#if defined(EFR32BG24A010F1024GJ42)
#include "efr32bg24a010f1024gj42.h"

#elif defined(EFR32BG24A010F1024IM40)
#include "efr32bg24a010f1024im40.h"

#elif defined(EFR32BG24A010F1024IM48)
#include "efr32bg24a010f1024im48.h"

#elif defined(EFR32BG24A010F1536IM40)
#include "efr32bg24a010f1536im40.h"

#elif defined(EFR32BG24A010F1536IM48)
#include "efr32bg24a010f1536im48.h"

#elif defined(EFR32BG24A020F1024IM40)
#include "efr32bg24a020f1024im40.h"

#elif defined(EFR32BG24A020F1024IM48)
#include "efr32bg24a020f1024im48.h"

#elif defined(EFR32BG24A020F1536IM40)
#include "efr32bg24a020f1536im40.h"

#elif defined(EFR32BG24A610F1536IM40)
#include "efr32bg24a610f1536im40.h"

#elif defined(EFR32BG24A620F1536IM40)
#include "efr32bg24a620f1536im40.h"

#elif defined(EFR32BG24B010F1024GJ42)
#include "efr32bg24b010f1024gj42.h"

#elif defined(EFR32BG24B010F1536IM40)
#include "efr32bg24b010f1536im40.h"

#elif defined(EFR32BG24B010F1536IM48)
#include "efr32bg24b010f1536im48.h"

#elif defined(EFR32BG24B020F1536IM40)
#include "efr32bg24b020f1536im40.h"

#elif defined(EFR32BG24B110F1536IM48)
#include "efr32bg24b110f1536im48.h"

#elif defined(EFR32BG24B210F1024IM48)
#include "efr32bg24b210f1024im48.h"

#elif defined(EFR32BG24B210F1536IM48)
#include "efr32bg24b210f1536im48.h"

#elif defined(EFR32BG24B220F1024IM48)
#include "efr32bg24b220f1024im48.h"

#elif defined(EFR32BG24B310F1536IJ42)
#include "efr32bg24b310f1536ij42.h"

#elif defined(EFR32BG24B410F1536IJ42)
#include "efr32bg24b410f1536ij42.h"

#elif defined(EFR32BG24B610F1536IM40)
#include "efr32bg24b610f1536im40.h"

#elif defined(EFR32BG24B620F1536IM40)
#include "efr32bg24b620f1536im40.h"

#elif defined(EFR32BG24L010F768IM40)
#include "efr32bg24l010f768im40.h"

#elif defined(EFR32BG24L210F768IM40)
#include "efr32bg24l210f768im40.h"

#else
#error "em_device.h: PART NUMBER undefined"
#endif

#if defined(SL_CATALOG_TRUSTZONE_SECURE_CONFIG_PRESENT) && defined(SL_TRUSTZONE_NONSECURE)
#error "Can't define SL_CATALOG_TRUSTZONE_SECURE_CONFIG_PRESENT and SL_TRUSTZONE_NONSECURE MACRO at the same time."
#endif

#if defined(SL_TRUSTZONE_SECURE) && defined(SL_TRUSTZONE_NONSECURE)
#error "Can't define SL_TRUSTZONE_SECURE and SL_TRUSTZONE_NONSECURE MACRO at the same time."
#endif
#endif /* EM_DEVICE_H */
