/**************************************************************************//**
 * @file
 * @brief SIMG301 DEVINFO definitions
 ******************************************************************************
 * # License
 * <b>Copyright 2025 Silicon Laboratories, Inc. www.silabs.com</b>
 ******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 *****************************************************************************/
#ifndef SIMG301_DEVINFO_DEFINES_H
#define SIMG301_DEVINFO_DEFINES_H

/**************************************************************************//**
* @addtogroup Parts
* @{
******************************************************************************/

/**************************************************************************//**
 * @defgroup SIMG301_DEVINFO_DEFINES DEVINFO_DEFINES
 * @{
 * @brief SIMG301 DEVINFO Definitions.
 *****************************************************************************/

/**************************************************************************//**
 * @addtogroup SIMG301_DEVINFO_DEFINES
 * @{
 * @defgroup SIMG301_DEVINFO_FRAGMENT_INDEX DEVINFO Fragment Index
 * @{
 *****************************************************************************/

/* DEVINFO Fragments Index. */
#define DEVINFO_BASE_FRAGMENT_INDEX    0x00UL
#define DEVINFO_GP_FRAGMENT_INDEX      0x01UL

/** @} End of group SIMG301_DEVINFO_FRAGMENT_INDEX  */

/**************************************************************************//**
 * @addtogroup SIMG301_DEVINFO_DEFINES
 * @{
 * @defgroup SIMG301_DEVINFO_OFFSET DEVINFO Offset values
 * @{
 *****************************************************************************/

/* DEVINFO GP Fragment Offsets. */
#define DEVINFO_GP_TEMPERATURE_OFFSET         0x00UL
#define DEVINFO_GP_HFRCODPLLBAND0_OFFSET      0x04UL
#define DEVINFO_GP_HFRCODPLLBAND1_OFFSET      0x08UL
#define DEVINFO_GP_HFRCODPLLBAND2_OFFSET      0x0CUL
#define DEVINFO_GP_HFRCODPLLBAND3_OFFSET      0x10UL
#define DEVINFO_GP_HFRCODPLLBAND4_OFFSET      0x14UL
#define DEVINFO_GP_HFRCODPLLBAND5_OFFSET      0x18UL
#define DEVINFO_GP_HFRCODPLLBAND6_OFFSET      0x1CUL
#define DEVINFO_GP_HFRCODPLLBAND7_OFFSET      0x20UL
#define DEVINFO_GP_HFRCODPLLBAND8_OFFSET      0x24UL
#define DEVINFO_GP_HFRCODPLLBAND9_OFFSET      0x28UL
#define DEVINFO_GP_HFRCODPLLBAND10_OFFSET     0x2CUL
#define DEVINFO_GP_HFRCOEM23DEFAULT_OFFSET    0x30UL
#define DEVINFO_GP_ADC0CALDATA_OFFSET         0x34UL
#define DEVINFO_GP_ADC0OFFSET_OFFSET          0x38UL
#define DEVINFO_GP_HFRCOEM2340MHZ_OFFSET      0x3CUL

/** @} End of group SIMG301_DEVINFO_OFFSET  */

/**************************************************************************//**
 * @addtogroup SIMG301_DEVINFO_DEFINES
 * @{
 * @defgroup SIMG301_DEVINFO_BitFields DEVINFO Bit Fields
 * @{
 *****************************************************************************/

/**************************************************************************//**
 * Bit fields for DEVINFO GP Fragment
 *****************************************************************************/
/* Bit fields for DEVINFO GP TEMPERATURE */
#define DEVINFO_GP_TEMPERATURE_CALTEMP_SHIFT            16
#define DEVINFO_GP_TEMPERATURE_CALTEMP_MASK             0x0FFF0000UL
#define DEVINFO_GP_TEMPERATURE_EMUTEMPROOM_SHIFT        0
#define DEVINFO_GP_TEMPERATURE_EMUTEMPROOM_MASK         0x000007FFUL

/* Bit fields for DEVINFO GP HFRCODPLLBAND0 */
#define DEVINFO_GP_HFRCODPLLBAND0_TUNING_SHIFT          0
#define DEVINFO_GP_HFRCODPLLBAND0_TUNING_MASK           0x0000003FUL
#define DEVINFO_GP_HFRCODPLLBAND0_FINETUNING_SHIFT      6
#define DEVINFO_GP_HFRCODPLLBAND0_FINETUNING_MASK       0x00000FC0UL
#define DEVINFO_GP_HFRCODPLLBAND0_BANDCOARSE_SHIFT      12
#define DEVINFO_GP_HFRCODPLLBAND0_BANDCOARSE_MASK       0x00007000UL
#define DEVINFO_GP_HFRCODPLLBAND0_BANDFINE_SHIFT        15
#define DEVINFO_GP_HFRCODPLLBAND0_BANDFINE_MASK         0x001F8000UL
#define DEVINFO_GP_HFRCODPLLBAND0_CLKDIV_SHIFT          21
#define DEVINFO_GP_HFRCODPLLBAND0_CLKDIV_MASK           0x00600000UL
#define DEVINFO_GP_HFRCODPLLBAND0_SIGMADELTA_SHIFT      23
#define DEVINFO_GP_HFRCODPLLBAND0_SIGMADELTA_MASK       0x01800000UL
#define DEVINFO_GP_HFRCODPLLBAND0_BIAS_SHIFT            25
#define DEVINFO_GP_HFRCODPLLBAND0_BIAS_MASK             0x0E000000UL
#define DEVINFO_GP_HFRCODPLLBAND0_TEMPCO_SHIFT          28
#define DEVINFO_GP_HFRCODPLLBAND0_TEMPCO_MASK           0xF0000000UL

/* Bit fields for DEVINFO GP HFRCODPLLBAND1 */
#define DEVINFO_GP_HFRCODPLLBAND1_TUNING_SHIFT          0
#define DEVINFO_GP_HFRCODPLLBAND1_TUNING_MASK           0x0000003FUL
#define DEVINFO_GP_HFRCODPLLBAND1_FINETUNING_SHIFT      6
#define DEVINFO_GP_HFRCODPLLBAND1_FINETUNING_MASK       0x00000FC0UL
#define DEVINFO_GP_HFRCODPLLBAND1_BANDCOARSE_SHIFT      12
#define DEVINFO_GP_HFRCODPLLBAND1_BANDCOARSE_MASK       0x00007000UL
#define DEVINFO_GP_HFRCODPLLBAND1_BANDFINE_SHIFT        15
#define DEVINFO_GP_HFRCODPLLBAND1_BANDFINE_MASK         0x001F8000UL
#define DEVINFO_GP_HFRCODPLLBAND1_CLKDIV_SHIFT          21
#define DEVINFO_GP_HFRCODPLLBAND1_CLKDIV_MASK           0x00600000UL
#define DEVINFO_GP_HFRCODPLLBAND1_SIGMADELTA_SHIFT      23
#define DEVINFO_GP_HFRCODPLLBAND1_SIGMADELTA_MASK       0x01800000UL
#define DEVINFO_GP_HFRCODPLLBAND1_BIAS_SHIFT            25
#define DEVINFO_GP_HFRCODPLLBAND1_BIAS_MASK             0x0E000000UL
#define DEVINFO_GP_HFRCODPLLBAND1_TEMPCO_SHIFT          28
#define DEVINFO_GP_HFRCODPLLBAND1_TEMPCO_MASK           0xF0000000UL

/* Bit fields for DEVINFO GP HFRCODPLLBAND2 */
#define DEVINFO_GP_HFRCODPLLBAND2_TUNING_SHIFT          0
#define DEVINFO_GP_HFRCODPLLBAND2_TUNING_MASK           0x0000003FUL
#define DEVINFO_GP_HFRCODPLLBAND2_FINETUNING_SHIFT      6
#define DEVINFO_GP_HFRCODPLLBAND2_FINETUNING_MASK       0x00000FC0UL
#define DEVINFO_GP_HFRCODPLLBAND2_BANDCOARSE_SHIFT      12
#define DEVINFO_GP_HFRCODPLLBAND2_BANDCOARSE_MASK       0x00007000UL
#define DEVINFO_GP_HFRCODPLLBAND2_BANDFINE_SHIFT        15
#define DEVINFO_GP_HFRCODPLLBAND2_BANDFINE_MASK         0x001F8000UL
#define DEVINFO_GP_HFRCODPLLBAND2_CLKDIV_SHIFT          21
#define DEVINFO_GP_HFRCODPLLBAND2_CLKDIV_MASK           0x00600000UL
#define DEVINFO_GP_HFRCODPLLBAND2_SIGMADELTA_SHIFT      23
#define DEVINFO_GP_HFRCODPLLBAND2_SIGMADELTA_MASK       0x01800000UL
#define DEVINFO_GP_HFRCODPLLBAND2_BIAS_SHIFT            25
#define DEVINFO_GP_HFRCODPLLBAND2_BIAS_MASK             0x0E000000UL
#define DEVINFO_GP_HFRCODPLLBAND2_TEMPCO_SHIFT          28
#define DEVINFO_GP_HFRCODPLLBAND2_TEMPCO_MASK           0xF0000000UL

/* Bit fields for DEVINFO GP HFRCODPLLBAND3 */
#define DEVINFO_GP_HFRCODPLLBAND3_TUNING_SHIFT          0
#define DEVINFO_GP_HFRCODPLLBAND3_TUNING_MASK           0x0000003FUL
#define DEVINFO_GP_HFRCODPLLBAND3_FINETUNING_SHIFT      6
#define DEVINFO_GP_HFRCODPLLBAND3_FINETUNING_MASK       0x00000FC0UL
#define DEVINFO_GP_HFRCODPLLBAND3_BANDCOARSE_SHIFT      12
#define DEVINFO_GP_HFRCODPLLBAND3_BANDCOARSE_MASK       0x00007000UL
#define DEVINFO_GP_HFRCODPLLBAND3_BANDFINE_SHIFT        15
#define DEVINFO_GP_HFRCODPLLBAND3_BANDFINE_MASK         0x001F8000UL
#define DEVINFO_GP_HFRCODPLLBAND3_CLKDIV_SHIFT          21
#define DEVINFO_GP_HFRCODPLLBAND3_CLKDIV_MASK           0x00600000UL
#define DEVINFO_GP_HFRCODPLLBAND3_SIGMADELTA_SHIFT      23
#define DEVINFO_GP_HFRCODPLLBAND3_SIGMADELTA_MASK       0x01800000UL
#define DEVINFO_GP_HFRCODPLLBAND3_BIAS_SHIFT            25
#define DEVINFO_GP_HFRCODPLLBAND3_BIAS_MASK             0x0E000000UL
#define DEVINFO_GP_HFRCODPLLBAND3_TEMPCO_SHIFT          28
#define DEVINFO_GP_HFRCODPLLBAND3_TEMPCO_MASK           0xF0000000UL

/* Bit fields for DEVINFO GP HFRCODPLLBAND4 */
#define DEVINFO_GP_HFRCODPLLBAND4_TUNING_SHIFT          0
#define DEVINFO_GP_HFRCODPLLBAND4_TUNING_MASK           0x0000003FUL
#define DEVINFO_GP_HFRCODPLLBAND4_FINETUNING_SHIFT      6
#define DEVINFO_GP_HFRCODPLLBAND4_FINETUNING_MASK       0x00000FC0UL
#define DEVINFO_GP_HFRCODPLLBAND4_BANDCOARSE_SHIFT      12
#define DEVINFO_GP_HFRCODPLLBAND4_BANDCOARSE_MASK       0x00007000UL
#define DEVINFO_GP_HFRCODPLLBAND4_BANDFINE_SHIFT        15
#define DEVINFO_GP_HFRCODPLLBAND4_BANDFINE_MASK         0x001F8000UL
#define DEVINFO_GP_HFRCODPLLBAND4_CLKDIV_SHIFT          21
#define DEVINFO_GP_HFRCODPLLBAND4_CLKDIV_MASK           0x00600000UL
#define DEVINFO_GP_HFRCODPLLBAND4_SIGMADELTA_SHIFT      23
#define DEVINFO_GP_HFRCODPLLBAND4_SIGMADELTA_MASK       0x01800000UL
#define DEVINFO_GP_HFRCODPLLBAND4_BIAS_SHIFT            25
#define DEVINFO_GP_HFRCODPLLBAND4_BIAS_MASK             0x0E000000UL
#define DEVINFO_GP_HFRCODPLLBAND4_TEMPCO_SHIFT          28
#define DEVINFO_GP_HFRCODPLLBAND4_TEMPCO_MASK           0xF0000000UL

/* Bit fields for DEVINFO GP HFRCODPLLBAND5 */
#define DEVINFO_GP_HFRCODPLLBAND5_TUNING_SHIFT          0
#define DEVINFO_GP_HFRCODPLLBAND5_TUNING_MASK           0x0000003FUL
#define DEVINFO_GP_HFRCODPLLBAND5_FINETUNING_SHIFT      6
#define DEVINFO_GP_HFRCODPLLBAND5_FINETUNING_MASK       0x00000FC0UL
#define DEVINFO_GP_HFRCODPLLBAND5_BANDCOARSE_SHIFT      12
#define DEVINFO_GP_HFRCODPLLBAND5_BANDCOARSE_MASK       0x00007000UL
#define DEVINFO_GP_HFRCODPLLBAND5_BANDFINE_SHIFT        15
#define DEVINFO_GP_HFRCODPLLBAND5_BANDFINE_MASK         0x001F8000UL
#define DEVINFO_GP_HFRCODPLLBAND5_CLKDIV_SHIFT          21
#define DEVINFO_GP_HFRCODPLLBAND5_CLKDIV_MASK           0x00600000UL
#define DEVINFO_GP_HFRCODPLLBAND5_SIGMADELTA_SHIFT      23
#define DEVINFO_GP_HFRCODPLLBAND5_SIGMADELTA_MASK       0x01800000UL
#define DEVINFO_GP_HFRCODPLLBAND5_BIAS_SHIFT            25
#define DEVINFO_GP_HFRCODPLLBAND5_BIAS_MASK             0x0E000000UL
#define DEVINFO_GP_HFRCODPLLBAND5_TEMPCO_SHIFT          28
#define DEVINFO_GP_HFRCODPLLBAND5_TEMPCO_MASK           0xF0000000UL

/* Bit fields for DEVINFO GP HFRCODPLLBAND6 */
#define DEVINFO_GP_HFRCODPLLBAND6_TUNING_SHIFT          0
#define DEVINFO_GP_HFRCODPLLBAND6_TUNING_MASK           0x0000003FUL
#define DEVINFO_GP_HFRCODPLLBAND6_FINETUNING_SHIFT      6
#define DEVINFO_GP_HFRCODPLLBAND6_FINETUNING_MASK       0x00000FC0UL
#define DEVINFO_GP_HFRCODPLLBAND6_BANDCOARSE_SHIFT      12
#define DEVINFO_GP_HFRCODPLLBAND6_BANDCOARSE_MASK       0x00007000UL
#define DEVINFO_GP_HFRCODPLLBAND6_BANDFINE_SHIFT        15
#define DEVINFO_GP_HFRCODPLLBAND6_BANDFINE_MASK         0x001F8000UL
#define DEVINFO_GP_HFRCODPLLBAND6_CLKDIV_SHIFT          21
#define DEVINFO_GP_HFRCODPLLBAND6_CLKDIV_MASK           0x00600000UL
#define DEVINFO_GP_HFRCODPLLBAND6_SIGMADELTA_SHIFT      23
#define DEVINFO_GP_HFRCODPLLBAND6_SIGMADELTA_MASK       0x01800000UL
#define DEVINFO_GP_HFRCODPLLBAND6_BIAS_SHIFT            25
#define DEVINFO_GP_HFRCODPLLBAND6_BIAS_MASK             0x0E000000UL
#define DEVINFO_GP_HFRCODPLLBAND6_TEMPCO_SHIFT          28
#define DEVINFO_GP_HFRCODPLLBAND6_TEMPCO_MASK           0xF0000000UL

/* Bit fields for DEVINFO GP HFRCODPLLBAND7 */
#define DEVINFO_GP_HFRCODPLLBAND7_TUNING_SHIFT          0
#define DEVINFO_GP_HFRCODPLLBAND7_TUNING_MASK           0x0000003FUL
#define DEVINFO_GP_HFRCODPLLBAND7_FINETUNING_SHIFT      6
#define DEVINFO_GP_HFRCODPLLBAND7_FINETUNING_MASK       0x00000FC0UL
#define DEVINFO_GP_HFRCODPLLBAND7_BANDCOARSE_SHIFT      12
#define DEVINFO_GP_HFRCODPLLBAND7_BANDCOARSE_MASK       0x00007000UL
#define DEVINFO_GP_HFRCODPLLBAND7_BANDFINE_SHIFT        15
#define DEVINFO_GP_HFRCODPLLBAND7_BANDFINE_MASK         0x001F8000UL
#define DEVINFO_GP_HFRCODPLLBAND7_CLKDIV_SHIFT          21
#define DEVINFO_GP_HFRCODPLLBAND7_CLKDIV_MASK           0x00600000UL
#define DEVINFO_GP_HFRCODPLLBAND7_SIGMADELTA_SHIFT      23
#define DEVINFO_GP_HFRCODPLLBAND7_SIGMADELTA_MASK       0x01800000UL
#define DEVINFO_GP_HFRCODPLLBAND7_BIAS_SHIFT            25
#define DEVINFO_GP_HFRCODPLLBAND7_BIAS_MASK             0x0E000000UL
#define DEVINFO_GP_HFRCODPLLBAND7_TEMPCO_SHIFT          28
#define DEVINFO_GP_HFRCODPLLBAND7_TEMPCO_MASK           0xF0000000UL

/* Bit fields for DEVINFO GP HFRCODPLLBAND8 */
#define DEVINFO_GP_HFRCODPLLBAND8_TUNING_SHIFT          0
#define DEVINFO_GP_HFRCODPLLBAND8_TUNING_MASK           0x0000003FUL
#define DEVINFO_GP_HFRCODPLLBAND8_FINETUNING_SHIFT      6
#define DEVINFO_GP_HFRCODPLLBAND8_FINETUNING_MASK       0x00000FC0UL
#define DEVINFO_GP_HFRCODPLLBAND8_BANDCOARSE_SHIFT      12
#define DEVINFO_GP_HFRCODPLLBAND8_BANDCOARSE_MASK       0x00007000UL
#define DEVINFO_GP_HFRCODPLLBAND8_BANDFINE_SHIFT        15
#define DEVINFO_GP_HFRCODPLLBAND8_BANDFINE_MASK         0x001F8000UL
#define DEVINFO_GP_HFRCODPLLBAND8_CLKDIV_SHIFT          21
#define DEVINFO_GP_HFRCODPLLBAND8_CLKDIV_MASK           0x00600000UL
#define DEVINFO_GP_HFRCODPLLBAND8_SIGMADELTA_SHIFT      23
#define DEVINFO_GP_HFRCODPLLBAND8_SIGMADELTA_MASK       0x01800000UL
#define DEVINFO_GP_HFRCODPLLBAND8_BIAS_SHIFT            25
#define DEVINFO_GP_HFRCODPLLBAND8_BIAS_MASK             0x0E000000UL
#define DEVINFO_GP_HFRCODPLLBAND8_TEMPCO_SHIFT          28
#define DEVINFO_GP_HFRCODPLLBAND8_TEMPCO_MASK           0xF0000000UL

/* Bit fields for DEVINFO GP HFRCODPLLBAND9 */
#define DEVINFO_GP_HFRCODPLLBAND9_TUNING_SHIFT          0
#define DEVINFO_GP_HFRCODPLLBAND9_TUNING_MASK           0x0000003FUL
#define DEVINFO_GP_HFRCODPLLBAND9_FINETUNING_SHIFT      6
#define DEVINFO_GP_HFRCODPLLBAND9_FINETUNING_MASK       0x00000FC0UL
#define DEVINFO_GP_HFRCODPLLBAND9_BANDCOARSE_SHIFT      12
#define DEVINFO_GP_HFRCODPLLBAND9_BANDCOARSE_MASK       0x00007000UL
#define DEVINFO_GP_HFRCODPLLBAND9_BANDFINE_SHIFT        15
#define DEVINFO_GP_HFRCODPLLBAND9_BANDFINE_MASK         0x001F8000UL
#define DEVINFO_GP_HFRCODPLLBAND9_CLKDIV_SHIFT          21
#define DEVINFO_GP_HFRCODPLLBAND9_CLKDIV_MASK           0x00600000UL
#define DEVINFO_GP_HFRCODPLLBAND9_SIGMADELTA_SHIFT      23
#define DEVINFO_GP_HFRCODPLLBAND9_SIGMADELTA_MASK       0x01800000UL
#define DEVINFO_GP_HFRCODPLLBAND9_BIAS_SHIFT            25
#define DEVINFO_GP_HFRCODPLLBAND9_BIAS_MASK             0x0E000000UL
#define DEVINFO_GP_HFRCODPLLBAND9_TEMPCO_SHIFT          28
#define DEVINFO_GP_HFRCODPLLBAND9_TEMPCO_MASK           0xF0000000UL

/* Bit fields for DEVINFO GP HFRCODPLLBAND10 */
#define DEVINFO_GP_HFRCODPLLBAND10_TUNING_SHIFT         0
#define DEVINFO_GP_HFRCODPLLBAND10_TUNING_MASK          0x0000003FUL
#define DEVINFO_GP_HFRCODPLLBAND10_FINETUNING_SHIFT     6
#define DEVINFO_GP_HFRCODPLLBAND10_FINETUNING_MASK      0x00000FC0UL
#define DEVINFO_GP_HFRCODPLLBAND10_BANDCOARSE_SHIFT     12
#define DEVINFO_GP_HFRCODPLLBAND10_BANDCOARSE_MASK      0x00007000UL
#define DEVINFO_GP_HFRCODPLLBAND10_BANDFINE_SHIFT       15
#define DEVINFO_GP_HFRCODPLLBAND10_BANDFINE_MASK        0x001F8000UL
#define DEVINFO_GP_HFRCODPLLBAND10_CLKDIV_SHIFT         21
#define DEVINFO_GP_HFRCODPLLBAND10_CLKDIV_MASK          0x00600000UL
#define DEVINFO_GP_HFRCODPLLBAND10_SIGMADELTA_SHIFT     23
#define DEVINFO_GP_HFRCODPLLBAND10_SIGMADELTA_MASK      0x01800000UL
#define DEVINFO_GP_HFRCODPLLBAND10_BIAS_SHIFT           25
#define DEVINFO_GP_HFRCODPLLBAND10_BIAS_MASK            0x0E000000UL
#define DEVINFO_GP_HFRCODPLLBAND10_TEMPCO_SHIFT         28
#define DEVINFO_GP_HFRCODPLLBAND10_TEMPCO_MASK          0xF0000000UL

/* Bit fields for DEVINFO GP HFRCOEM23DEFAULT */
#define DEVINFO_GP_HFRCOEM23DEFAULT_TUNING_SHIFT        0
#define DEVINFO_GP_HFRCOEM23DEFAULT_TUNING_MASK         0x0000003FUL
#define DEVINFO_GP_HFRCOEM23DEFAULT_FINETUNING_SHIFT    6
#define DEVINFO_GP_HFRCOEM23DEFAULT_FINETUNING_MASK     0x00000FC0UL
#define DEVINFO_GP_HFRCOEM23DEFAULT_BANDCOARSE_SHIFT    12
#define DEVINFO_GP_HFRCOEM23DEFAULT_BANDCOARSE_MASK     0x00007000UL
#define DEVINFO_GP_HFRCOEM23DEFAULT_BANDFINE_SHIFT      15
#define DEVINFO_GP_HFRCOEM23DEFAULT_BANDFINE_MASK       0x001F8000UL
#define DEVINFO_GP_HFRCOEM23DEFAULT_CLKDIV_SHIFT        21
#define DEVINFO_GP_HFRCOEM23DEFAULT_CLKDIV_MASK         0x00600000UL
#define DEVINFO_GP_HFRCOEM23DEFAULT_SIGMADELTA_SHIFT    23
#define DEVINFO_GP_HFRCOEM23DEFAULT_SIGMADELTA_MASK     0x01800000UL
#define DEVINFO_GP_HFRCOEM23DEFAULT_BIAS_SHIFT          25
#define DEVINFO_GP_HFRCOEM23DEFAULT_BIAS_MASK           0x0E000000UL
#define DEVINFO_GP_HFRCOEM23DEFAULT_TEMPCO_SHIFT        28
#define DEVINFO_GP_HFRCOEM23DEFAULT_TEMPCO_MASK         0xF0000000UL

/* Bit fields for DEVINFO GP ADC0CALDATA */
#define DEVINFO_GP_ADC0CALDATA_TRIMVROS0_SHIFT          0
#define DEVINFO_GP_ADC0CALDATA_TRIMVROS0_MASK           0x0000001FUL
#define DEVINFO_GP_ADC0CALDATA_TRIMVROS1_SHIFT          8
#define DEVINFO_GP_ADC0CALDATA_TRIMVROS1_MASK           0x00001F00UL
#define DEVINFO_GP_ADC0CALDATA_TRIMGAIN4X_SHIFT         16
#define DEVINFO_GP_ADC0CALDATA_TRIMGAIN4X_MASK          0x007F0000UL
#define DEVINFO_GP_ADC0CALDATA_TRIMGAIN0x3INT_SHIFT     24
#define DEVINFO_GP_ADC0CALDATA_TRIMGAIN0x3INT_MASK      0x7F000000UL

/* Bit fields for DEVINFO GP ADC0OFFSET */
#define DEVINFO_GP_ADC0OFFSET_TRIMOFF1X_SHIFT           0
#define DEVINFO_GP_ADC0OFFSET_TRIMOFF1X_MASK            0x0000003FUL
#define DEVINFO_GP_ADC0OFFSET_TRIMOFF2X_SHIFT           8
#define DEVINFO_GP_ADC0OFFSET_TRIMOFF2X_MASK            0x00003F00UL
#define DEVINFO_GP_ADC0OFFSET_TRIMOFF4X_SHIFT           16
#define DEVINFO_GP_ADC0OFFSET_TRIMOFF4X_MASK            0x003F0000UL

/* Bit fields for DEVINFO GP HFRCOEM2340MHZ */
#define DEVINFO_GP_HFRCOEM2340MHZ_TUNING_SHIFT          0
#define DEVINFO_GP_HFRCOEM2340MHZ_TUNING_MASK           0x0000003FUL
#define DEVINFO_GP_HFRCOEM2340MHZ_FINETUNING_SHIFT      6
#define DEVINFO_GP_HFRCOEM2340MHZ_FINETUNING_MASK       0x00000FC0UL
#define DEVINFO_GP_HFRCOEM2340MHZ_BANDCOARSE_SHIFT      12
#define DEVINFO_GP_HFRCOEM2340MHZ_BANDCOARSE_MASK       0x00007000UL
#define DEVINFO_GP_HFRCOEM2340MHZ_BANDFINE_SHIFT        15
#define DEVINFO_GP_HFRCOEM2340MHZ_BANDFINE_MASK         0x001F8000UL
#define DEVINFO_GP_HFRCOEM2340MHZ_CLKDIV_SHIFT          21
#define DEVINFO_GP_HFRCOEM2340MHZ_CLKDIV_MASK           0x00600000UL
#define DEVINFO_GP_HFRCOEM2340MHZ_SIGMADELTA_SHIFT      23
#define DEVINFO_GP_HFRCOEM2340MHZ_SIGMADELTA_MASK       0x01800000UL
#define DEVINFO_GP_HFRCOEM2340MHZ_BIAS_SHIFT            25
#define DEVINFO_GP_HFRCOEM2340MHZ_BIAS_MASK             0x0E000000UL
#define DEVINFO_GP_HFRCOEM2340MHZ_TEMPCO_SHIFT          28
#define DEVINFO_GP_HFRCOEM2340MHZ_TEMPCO_MASK           0xF0000000UL

/** @} End of group SIMG301_DEVINFO_BitFields  */
/** @} End of group SIMG301_DEVINFO_DEFINES  */
/** @} End of group Parts */

#endif // SIMG301_DEVINFO_DEFINES_H
