/**************************************************************************//**
 * @file
 * @brief SIMG301 LDMA XBAR channel request soruce definitions
 ******************************************************************************
 * # License
 * <b>Copyright 2025 Silicon Laboratories, Inc. www.silabs.com</b>
 ******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 *****************************************************************************/
#ifndef SIMG301_LDMAXBAR_DEFINES_H
#define SIMG301_LDMAXBAR_DEFINES_H

// Module source selection indices
#define _LDMAXBAR0_CH_REQSEL_SOURCESEL_NONE             0x00000000UL /**< Mode NONE for LDMAXBAR0_CH_REQSEL */
#define _LDMAXBAR0_CH_REQSEL_SOURCESEL_LDMAXBAR0        0x00000001UL /**< Mode LDMAXBAR0 for LDMAXBAR0_CH_REQSEL */
#define _LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER0           0x00000002UL /**< Mode TIMER0 for LDMAXBAR0_CH_REQSEL */
#define _LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER1           0x00000003UL /**< Mode TIMER1 for LDMAXBAR0_CH_REQSEL */
#define _LDMAXBAR0_CH_REQSEL_SOURCESEL_I2C0             0x00000004UL /**< Mode I2C0 for LDMAXBAR0_CH_REQSEL */
#define _LDMAXBAR0_CH_REQSEL_SOURCESEL_I2C1             0x00000005UL /**< Mode I2C1 for LDMAXBAR0_CH_REQSEL */
#define _LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER2           0x00000006UL /**< Mode TIMER2 for LDMAXBAR0_CH_REQSEL */
#define _LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER3           0x00000007UL /**< Mode TIMER3 for LDMAXBAR0_CH_REQSEL */
#define _LDMAXBAR0_CH_REQSEL_SOURCESEL_EUSART1          0x00000008UL /**< Mode EUSART1 for LDMAXBAR0_CH_REQSEL */
#define _LDMAXBAR0_CH_REQSEL_SOURCESEL_EUSART0          0x00000009UL /**< Mode EUSART0 for LDMAXBAR0_CH_REQSEL */
#define _LDMAXBAR0_CH_REQSEL_SOURCESEL_ADC0             0x0000000dUL /**< Mode ADC0 for LDMAXBAR0_CH_REQSEL */
#define _LDMAXBAR0_CH_REQSEL_SOURCESEL_PIXELRZ0         0x0000000eUL /**< Mode PIXELRZ0 for LDMAXBAR0_CH_REQSEL */
#define _LDMAXBAR0_CH_REQSEL_SOURCESEL_EUSART2          0x0000000fUL /**< Mode EUSART2 for LDMAXBAR0_CH_REQSEL */
#define _LDMAXBAR0_CH_REQSEL_SOURCESEL_PIXELRZ1         0x00000010UL /**< Mode PIXELRZ1 for LDMAXBAR0_CH_REQSEL */
#define _LDMAXBAR0_CH_REQSEL_SOURCESEL_I2C2             0x00000011UL /**< Mode I2C2 for LDMAXBAR0_CH_REQSEL */

// Shifted source selection indices
#define LDMAXBAR0_CH_REQSEL_SOURCESEL_NONE              (_LDMAXBAR0_CH_REQSEL_SOURCESEL_NONE << 16)
#define LDMAXBAR0_CH_REQSEL_SOURCESEL_LDMAXBAR0         (_LDMAXBAR0_CH_REQSEL_SOURCESEL_LDMAXBAR0 << 16) /**< Shifted Mode LDMAXBAR0 for LDMAXBAR0_CH_REQSEL */
#define LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER0            (_LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER0 << 16)    /**< Shifted Mode TIMER0 for LDMAXBAR0_CH_REQSEL */
#define LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER1            (_LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER1 << 16)    /**< Shifted Mode TIMER1 for LDMAXBAR0_CH_REQSEL */
#define LDMAXBAR0_CH_REQSEL_SOURCESEL_I2C0              (_LDMAXBAR0_CH_REQSEL_SOURCESEL_I2C0 << 16)      /**< Shifted Mode I2C0 for LDMAXBAR0_CH_REQSEL */
#define LDMAXBAR0_CH_REQSEL_SOURCESEL_I2C1              (_LDMAXBAR0_CH_REQSEL_SOURCESEL_I2C1 << 16)      /**< Shifted Mode I2C1 for LDMAXBAR0_CH_REQSEL */
#define LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER2            (_LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER2 << 16)    /**< Shifted Mode TIMER2 for LDMAXBAR0_CH_REQSEL */
#define LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER3            (_LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER3 << 16)    /**< Shifted Mode TIMER3 for LDMAXBAR0_CH_REQSEL */
#define LDMAXBAR0_CH_REQSEL_SOURCESEL_EUSART1           (_LDMAXBAR0_CH_REQSEL_SOURCESEL_EUSART1 << 16)   /**< Shifted Mode EUSART1 for LDMAXBAR0_CH_REQSEL */
#define LDMAXBAR0_CH_REQSEL_SOURCESEL_EUSART0           (_LDMAXBAR0_CH_REQSEL_SOURCESEL_EUSART0 << 16)   /**< Shifted Mode EUSART0 for LDMAXBAR0_CH_REQSEL */
#define LDMAXBAR0_CH_REQSEL_SOURCESEL_ADC0              (_LDMAXBAR0_CH_REQSEL_SOURCESEL_ADC0 << 16)      /**< Shifted Mode ADC0 for LDMAXBAR0_CH_REQSEL */
#define LDMAXBAR0_CH_REQSEL_SOURCESEL_PIXELRZ0          (_LDMAXBAR0_CH_REQSEL_SOURCESEL_PIXELRZ0 << 16)  /**< Shifted Mode PIXELRZ0 for LDMAXBAR0_CH_REQSEL */
#define LDMAXBAR0_CH_REQSEL_SOURCESEL_EUSART2           (_LDMAXBAR0_CH_REQSEL_SOURCESEL_EUSART2 << 16)   /**< Shifted Mode EUSART2 for LDMAXBAR0_CH_REQSEL */
#define LDMAXBAR0_CH_REQSEL_SOURCESEL_PIXELRZ1          (_LDMAXBAR0_CH_REQSEL_SOURCESEL_PIXELRZ1 << 16)  /**< Shifted Mode PIXELRZ1 for LDMAXBAR0_CH_REQSEL */
#define LDMAXBAR0_CH_REQSEL_SOURCESEL_I2C2              (_LDMAXBAR0_CH_REQSEL_SOURCESEL_I2C2 << 16)      /**< Shifted Mode I2C2 for LDMAXBAR0_CH_REQSEL */

// Module signal selection indices
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_LDMAXBAR0PRSREQ0    0x00000000UL /** Mode LDMAXBAR0PRSREQ0 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_LDMAXBAR0PRSREQ1    0x00000001UL /** Mode LDMAXBAR0PRSREQ1 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0CC0           0x00000000UL /** Mode TIMER0CC0 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0CC1           0x00000001UL /** Mode TIMER0CC1 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0CC2           0x00000002UL /** Mode TIMER0CC2 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0UFOF          0x00000003UL /** Mode TIMER0UFOF for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1CC0           0x00000000UL /** Mode TIMER1CC0 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1CC1           0x00000001UL /** Mode TIMER1CC1 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1CC2           0x00000002UL /** Mode TIMER1CC2 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1UFOF          0x00000003UL /** Mode TIMER1UFOF for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_I2C0RXDATAV         0x00000000UL /** Mode I2C0RXDATAV for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_I2C0TXBL            0x00000001UL /** Mode I2C0TXBL for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_I2C1RXDATAV         0x00000000UL /** Mode I2C1RXDATAV for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_I2C1TXBL            0x00000001UL /** Mode I2C1TXBL for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC0           0x00000000UL /** Mode TIMER2CC0 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC1           0x00000001UL /** Mode TIMER2CC1 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC2           0x00000002UL /** Mode TIMER2CC2 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2UFOF          0x00000003UL /** Mode TIMER2UFOF for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC3           0x00000004UL /** Mode TIMER2CC3 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC4           0x00000005UL /** Mode TIMER2CC4 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC5           0x00000006UL /** Mode TIMER2CC5 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC6           0x00000007UL /** Mode TIMER2CC6 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC0           0x00000000UL /** Mode TIMER3CC0 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC1           0x00000001UL /** Mode TIMER3CC1 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC2           0x00000002UL /** Mode TIMER3CC2 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3UFOF          0x00000003UL /** Mode TIMER3UFOF for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC3           0x00000004UL /** Mode TIMER3CC3 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC4           0x00000005UL /** Mode TIMER3CC4 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC5           0x00000006UL /** Mode TIMER3CC5 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC6           0x00000007UL /** Mode TIMER3CC6 for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART1RXFL         0x00000000UL /** Mode EUSART1RXFL for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART1TXFL         0x00000001UL /** Mode EUSART1TXFL for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART0RXFL         0x00000000UL /** Mode EUSART0RXFL for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART0TXFL         0x00000001UL /** Mode EUSART0TXFL for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_ADC0SCAN            0x00000000UL /** Mode ADC0SCAN for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_PIXELRZ0REQ_TXF     0x00000000UL /** Mode PIXELRZ0REQ_TXF for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART2RXFL         0x00000000UL /** Mode EUSART2RXFL for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART2TXFL         0x00000001UL /** Mode EUSART2TXFL for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_PIXELRZ1REQ_TXF     0x00000000UL /** Mode PIXELRZ1REQ_TXF for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_I2C2RXDATAV         0x00000000UL /** Mode I2C2RXDATAV for LDMAXBAR0_CH_REQSEL**/
#define _LDMAXBAR0_CH_REQSEL_SIGSEL_I2C2TXBL            0x00000001UL /** Mode I2C2TXBL for LDMAXBAR0_CH_REQSEL**/

// Shifted Module signal selection indices
#define LDMAXBAR0_CH_REQSEL_SIGSEL_LDMAXBAR0PRSREQ0     (_LDMAXBAR0_CH_REQSEL_SIGSEL_LDMAXBAR0PRSREQ0 << 0) /** Shifted Mode LDMAXBAR0PRSREQ0 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_LDMAXBAR0PRSREQ1     (_LDMAXBAR0_CH_REQSEL_SIGSEL_LDMAXBAR0PRSREQ1 << 0) /** Shifted Mode LDMAXBAR0PRSREQ1 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0CC0            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0CC0 << 0)        /** Shifted Mode TIMER0CC0 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0CC1            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0CC1 << 0)        /** Shifted Mode TIMER0CC1 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0CC2            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0CC2 << 0)        /** Shifted Mode TIMER0CC2 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0UFOF           (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0UFOF << 0)       /** Shifted Mode TIMER0UFOF for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1CC0            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1CC0 << 0)        /** Shifted Mode TIMER1CC0 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1CC1            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1CC1 << 0)        /** Shifted Mode TIMER1CC1 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1CC2            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1CC2 << 0)        /** Shifted Mode TIMER1CC2 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1UFOF           (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1UFOF << 0)       /** Shifted Mode TIMER1UFOF for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_I2C0RXDATAV          (_LDMAXBAR0_CH_REQSEL_SIGSEL_I2C0RXDATAV << 0)      /** Shifted Mode I2C0RXDATAV for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_I2C0TXBL             (_LDMAXBAR0_CH_REQSEL_SIGSEL_I2C0TXBL << 0)         /** Shifted Mode I2C0TXBL for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_I2C1RXDATAV          (_LDMAXBAR0_CH_REQSEL_SIGSEL_I2C1RXDATAV << 0)      /** Shifted Mode I2C1RXDATAV for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_I2C1TXBL             (_LDMAXBAR0_CH_REQSEL_SIGSEL_I2C1TXBL << 0)         /** Shifted Mode I2C1TXBL for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC0            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC0 << 0)        /** Shifted Mode TIMER2CC0 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC1            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC1 << 0)        /** Shifted Mode TIMER2CC1 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC2            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC2 << 0)        /** Shifted Mode TIMER2CC2 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2UFOF           (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2UFOF << 0)       /** Shifted Mode TIMER2UFOF for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC3            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC3 << 0)        /** Shifted Mode TIMER2CC3 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC4            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC4 << 0)        /** Shifted Mode TIMER2CC4 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC5            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC5 << 0)        /** Shifted Mode TIMER2CC5 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC6            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC6 << 0)        /** Shifted Mode TIMER2CC6 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC0            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC0 << 0)        /** Shifted Mode TIMER3CC0 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC1            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC1 << 0)        /** Shifted Mode TIMER3CC1 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC2            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC2 << 0)        /** Shifted Mode TIMER3CC2 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3UFOF           (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3UFOF << 0)       /** Shifted Mode TIMER3UFOF for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC3            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC3 << 0)        /** Shifted Mode TIMER3CC3 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC4            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC4 << 0)        /** Shifted Mode TIMER3CC4 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC5            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC5 << 0)        /** Shifted Mode TIMER3CC5 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC6            (_LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC6 << 0)        /** Shifted Mode TIMER3CC6 for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART1RXFL          (_LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART1RXFL << 0)      /** Shifted Mode EUSART1RXFL for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART1TXFL          (_LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART1TXFL << 0)      /** Shifted Mode EUSART1TXFL for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART0RXFL          (_LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART0RXFL << 0)      /** Shifted Mode EUSART0RXFL for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART0TXFL          (_LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART0TXFL << 0)      /** Shifted Mode EUSART0TXFL for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_ADC0SCAN             (_LDMAXBAR0_CH_REQSEL_SIGSEL_ADC0SCAN << 0)         /** Shifted Mode ADC0SCAN for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_PIXELRZ0REQ_TXF      (_LDMAXBAR0_CH_REQSEL_SIGSEL_PIXELRZ0REQ_TXF << 0)  /** Shifted Mode PIXELRZ0REQ_TXF for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART2RXFL          (_LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART2RXFL << 0)      /** Shifted Mode EUSART2RXFL for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART2TXFL          (_LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART2TXFL << 0)      /** Shifted Mode EUSART2TXFL for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_PIXELRZ1REQ_TXF      (_LDMAXBAR0_CH_REQSEL_SIGSEL_PIXELRZ1REQ_TXF << 0)  /** Shifted Mode PIXELRZ1REQ_TXF for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_I2C2RXDATAV          (_LDMAXBAR0_CH_REQSEL_SIGSEL_I2C2RXDATAV << 0)      /** Shifted Mode I2C2RXDATAV for LDMAXBAR0_CH_REQSEL**/
#define LDMAXBAR0_CH_REQSEL_SIGSEL_I2C2TXBL             (_LDMAXBAR0_CH_REQSEL_SIGSEL_I2C2TXBL << 0)         /** Shifted Mode I2C2TXBL for LDMAXBAR0_CH_REQSEL**/

#endif // SIMG301_LDMAXBAR_DEFINES_H
