/**************************************************************************//**
 * @file
 * @brief SIMG301 PRS register and bit field definitions
 ******************************************************************************
 * # License
 * <b>Copyright 2025 Silicon Laboratories, Inc. www.silabs.com</b>
 ******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 *****************************************************************************/
#ifndef SIMG301_PRS_H
#define SIMG301_PRS_H
#define PRS_HAS_SET_CLEAR

/**************************************************************************//**
* @addtogroup Parts
* @{
******************************************************************************/
/**************************************************************************//**
 * @defgroup SIMG301_PRS PRS
 * @{
 * @brief SIMG301 PRS Register Declaration.
 *****************************************************************************/

/** PRS ASYNC_CH Register Group Declaration. */
typedef struct prs_async_ch_typedef{
  __IOM uint32_t CTRL;                               /**< Async Channel Control Register                     */
} PRS_ASYNC_CH_TypeDef;

/** PRS SYNC_CH Register Group Declaration. */
typedef struct prs_sync_ch_typedef{
  __IOM uint32_t CTRL;                               /**< Sync Channel Control Register                      */
} PRS_SYNC_CH_TypeDef;

/** PRS Register Declaration. */
typedef struct prs_typedef{
  __IM uint32_t        IPVERSION;                         /**< PRS IPVERSION                                      */
  uint32_t             RESERVED0[1U];                     /**< Reserved for future use                            */
  __IOM uint32_t       ASYNC_SWPULSE;                     /**< Software Pulse Register                            */
  __IOM uint32_t       ASYNC_SWLEVEL;                     /**< Software Level Register                            */
  __IM uint32_t        ASYNC_PEEK;                        /**< Async Channel Values                               */
  __IM uint32_t        SYNC_PEEK;                         /**< Sync Channel Values                                */
  PRS_ASYNC_CH_TypeDef ASYNC_CH[12U];                     /**< Async Channel registers                            */
  uint32_t             RESERVED1[4U];                     /**< Reserved for future use                            */
  PRS_SYNC_CH_TypeDef  SYNC_CH[4U];                       /**< Sync Channel registers                             */
  __IOM uint32_t       CONSUMER_EUSART0_CLK;              /**< CLK consumer register                              */
  __IOM uint32_t       CONSUMER_EUSART0_RX;               /**< RX Consumer register                               */
  __IOM uint32_t       CONSUMER_EUSART0_TRIGGER;          /**< TRIGGER Consumer register                          */
  __IOM uint32_t       CONSUMER_EUSART1_CLK;              /**< CLK consumer register                              */
  __IOM uint32_t       CONSUMER_EUSART1_RX;               /**< RX Consumer register                               */
  __IOM uint32_t       CONSUMER_EUSART1_TRIGGER;          /**< TRIGGER Consumer register                          */
  __IOM uint32_t       CONSUMER_EUSART2_CLK;              /**< CLK consumer register                              */
  __IOM uint32_t       CONSUMER_EUSART2_RX;               /**< RX Consumer register                               */
  __IOM uint32_t       CONSUMER_EUSART2_TRIGGER;          /**< TRIGGER Consumer register                          */
  __IOM uint32_t       CONSUMER_FRC_RXRAW;                /**< RXRAW consumer register                            */
  __IOM uint32_t       CONSUMER_CMU_CALDN;                /**< CALDN consumer register                            */
  __IOM uint32_t       CONSUMER_CMU_CALUP;                /**< CALUP Consumer register                            */
  __IOM uint32_t       CONSUMER_LDMAXBAR0_DMAREQ0;        /**< DMAREQ0 consumer register                          */
  __IOM uint32_t       CONSUMER_LDMAXBAR0_DMAREQ1;        /**< DMAREQ1 Consumer register                          */
  __IOM uint32_t       CONSUMER_LEDDRV0_LEDDRV0ASYNC;     /**< LEDDRV0 consumer register                          */
  __IOM uint32_t       CONSUMER_LEDDRV0_LEDDRV1ASYNC;     /**< LEDDRV1 Consumer register                          */
  __IOM uint32_t       CONSUMER_LETIMER0_CLEAR;           /**< CLEAR consumer register                            */
  __IOM uint32_t       CONSUMER_LETIMER0_START;           /**< START Consumer register                            */
  __IOM uint32_t       CONSUMER_LETIMER0_STOP;            /**< STOP Consumer register                             */
  __IOM uint32_t       CONSUMER_MODEM_DIN;                /**< DIN consumer register                              */
  __IOM uint32_t       CONSUMER_MODEM_PAEN;               /**< PAEN Consumer register                             */
  __IOM uint32_t       CONSUMER_PCNT0_S0IN;               /**< S0IN consumer register                             */
  __IOM uint32_t       CONSUMER_PCNT0_S1IN;               /**< S1IN Consumer register                             */
  __IOM uint32_t       CONSUMER_PIXELRZ0_INASYNC;         /**< IN consumer register                               */
  __IOM uint32_t       CONSUMER_PIXELRZ1_INASYNC;         /**< IN consumer register                               */
  uint32_t             RESERVED2[11U];                    /**< Reserved for future use                            */
  __IOM uint32_t       CONSUMER_RAC_CLR;                  /**< CLR consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_CTIIN0;               /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_CTIIN1;               /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_CTIIN2;               /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_CTIIN3;               /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_FORCETX;              /**< FORCETX Consumer register                          */
  __IOM uint32_t       CONSUMER_RAC_RXDIS;                /**< RXDIS Consumer register                            */
  __IOM uint32_t       CONSUMER_RAC_RXEN;                 /**< RXEN Consumer register                             */
  __IOM uint32_t       CONSUMER_RAC_TXEN;                 /**< TXEN Consumer register                             */
  __IOM uint32_t       CONSUMER_RFTIMER_PULSE;            /**< PULSE consumer register                            */
  __IOM uint32_t       CONSUMER_ADC0_ASYNCSEQ;            /**< ASYNC consumer register                            */
  __IOM uint32_t       CONSUMER_ADC0_SYNCSEQ;             /**< SYNC Consumer register                             */
  __IOM uint32_t       CONSUMER_SEQACC_WAIT0;             /**< WAIT0 consumer register                            */
  __IOM uint32_t       CONSUMER_SEQACC_WAIT1;             /**< WAIT1 Consumer register                            */
  __IOM uint32_t       CONSUMER_SEQACC_WAIT2;             /**< WAIT2 Consumer register                            */
  __IOM uint32_t       CONSUMER_SEQACC_WAIT3;             /**< WAIT3 Consumer register                            */
  __IOM uint32_t       CONSUMER_SETAMPER_TAMPERSRC29;     /**< TAMPERSRC29 consumer register                      */
  __IOM uint32_t       CONSUMER_SETAMPER_TAMPERSRC30;     /**< TAMPERSRC30 Consumer register                      */
  __IOM uint32_t       CONSUMER_SETAMPER_TAMPERSRC31;     /**< TAMPERSRC31 Consumer register                      */
  __IOM uint32_t       CONSUMER_SYSRTC0_IN0;              /**< IN0 consumer register                              */
  __IOM uint32_t       CONSUMER_SYSRTC0_IN1;              /**< IN1 Consumer register                              */
  __IOM uint32_t       CONSUMER_HFXO0_OSCREQ;             /**< OSC consumer register                              */
  __IOM uint32_t       CONSUMER_HFXO0_TIMEOUT;            /**< TIMEOUT Consumer register                          */
  __IOM uint32_t       CONSUMER_CORE_CTIIN0;              /**< CTI consumer register                              */
  __IOM uint32_t       CONSUMER_CORE_CTIIN1;              /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_CORE_CTIIN2;              /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_CORE_CTIIN3;              /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_CORE_M33RXEV;             /**< M33 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_CC0;               /**< CC0 consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_CC1;               /**< CC1 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_CC2;               /**< CC2 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_DTI;               /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_DTIFS1;            /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_DTIFS2;            /**< DTI Consumer register                              */
  uint32_t             RESERVED3[3U];                     /**< Reserved for future use                            */
  __IOM uint32_t       CONSUMER_TIMER1_CC0;               /**< CC0 consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_CC1;               /**< CC1 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_CC2;               /**< CC2 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_DTI;               /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_DTIFS1;            /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_DTIFS2;            /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC0;               /**< CC0 consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC1;               /**< CC1 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC2;               /**< CC2 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC3;               /**< CC3 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC4;               /**< CC4 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC5;               /**< CC5 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC6;               /**< CC6 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_DTI;               /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_DTIFS1;            /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_DTIFS2;            /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC0;               /**< CC0 consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC1;               /**< CC1 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC2;               /**< CC2 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC3;               /**< CC3 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC4;               /**< CC4 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC5;               /**< CC5 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC6;               /**< CC6 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_DTI;               /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_DTIFS1;            /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_DTIFS2;            /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_WDOG0_SRC0;               /**< SRC0 consumer register                             */
  __IOM uint32_t       CONSUMER_WDOG0_SRC1;               /**< SRC1 Consumer register                             */
  __IOM uint32_t       CONSUMER_WDOG1_SRC0;               /**< SRC0 consumer register                             */
  __IOM uint32_t       CONSUMER_WDOG1_SRC1;               /**< SRC1 Consumer register                             */
  uint32_t             RESERVED4[4U];                     /**< Reserved for future use                            */
  __IOM uint32_t       RPURATD4;                          /**< Root Access Type Descriptor Register               */
  uint32_t             RESERVED5[890U];                   /**< Reserved for future use                            */
  __IM uint32_t        IPVERSION_SET;                     /**< PRS IPVERSION                                      */
  uint32_t             RESERVED6[1U];                     /**< Reserved for future use                            */
  __IOM uint32_t       ASYNC_SWPULSE_SET;                 /**< Software Pulse Register                            */
  __IOM uint32_t       ASYNC_SWLEVEL_SET;                 /**< Software Level Register                            */
  __IM uint32_t        ASYNC_PEEK_SET;                    /**< Async Channel Values                               */
  __IM uint32_t        SYNC_PEEK_SET;                     /**< Sync Channel Values                                */
  PRS_ASYNC_CH_TypeDef ASYNC_CH_SET[12U];                 /**< Async Channel registers                            */
  uint32_t             RESERVED7[4U];                     /**< Reserved for future use                            */
  PRS_SYNC_CH_TypeDef  SYNC_CH_SET[4U];                   /**< Sync Channel registers                             */
  __IOM uint32_t       CONSUMER_EUSART0_CLK_SET;          /**< CLK consumer register                              */
  __IOM uint32_t       CONSUMER_EUSART0_RX_SET;           /**< RX Consumer register                               */
  __IOM uint32_t       CONSUMER_EUSART0_TRIGGER_SET;      /**< TRIGGER Consumer register                          */
  __IOM uint32_t       CONSUMER_EUSART1_CLK_SET;          /**< CLK consumer register                              */
  __IOM uint32_t       CONSUMER_EUSART1_RX_SET;           /**< RX Consumer register                               */
  __IOM uint32_t       CONSUMER_EUSART1_TRIGGER_SET;      /**< TRIGGER Consumer register                          */
  __IOM uint32_t       CONSUMER_EUSART2_CLK_SET;          /**< CLK consumer register                              */
  __IOM uint32_t       CONSUMER_EUSART2_RX_SET;           /**< RX Consumer register                               */
  __IOM uint32_t       CONSUMER_EUSART2_TRIGGER_SET;      /**< TRIGGER Consumer register                          */
  __IOM uint32_t       CONSUMER_FRC_RXRAW_SET;            /**< RXRAW consumer register                            */
  __IOM uint32_t       CONSUMER_CMU_CALDN_SET;            /**< CALDN consumer register                            */
  __IOM uint32_t       CONSUMER_CMU_CALUP_SET;            /**< CALUP Consumer register                            */
  __IOM uint32_t       CONSUMER_LDMAXBAR0_DMAREQ0_SET;    /**< DMAREQ0 consumer register                          */
  __IOM uint32_t       CONSUMER_LDMAXBAR0_DMAREQ1_SET;    /**< DMAREQ1 Consumer register                          */
  __IOM uint32_t       CONSUMER_LEDDRV0_LEDDRV0ASYNC_SET; /**< LEDDRV0 consumer register                          */
  __IOM uint32_t       CONSUMER_LEDDRV0_LEDDRV1ASYNC_SET; /**< LEDDRV1 Consumer register                          */
  __IOM uint32_t       CONSUMER_LETIMER0_CLEAR_SET;       /**< CLEAR consumer register                            */
  __IOM uint32_t       CONSUMER_LETIMER0_START_SET;       /**< START Consumer register                            */
  __IOM uint32_t       CONSUMER_LETIMER0_STOP_SET;        /**< STOP Consumer register                             */
  __IOM uint32_t       CONSUMER_MODEM_DIN_SET;            /**< DIN consumer register                              */
  __IOM uint32_t       CONSUMER_MODEM_PAEN_SET;           /**< PAEN Consumer register                             */
  __IOM uint32_t       CONSUMER_PCNT0_S0IN_SET;           /**< S0IN consumer register                             */
  __IOM uint32_t       CONSUMER_PCNT0_S1IN_SET;           /**< S1IN Consumer register                             */
  __IOM uint32_t       CONSUMER_PIXELRZ0_INASYNC_SET;     /**< IN consumer register                               */
  __IOM uint32_t       CONSUMER_PIXELRZ1_INASYNC_SET;     /**< IN consumer register                               */
  uint32_t             RESERVED8[11U];                    /**< Reserved for future use                            */
  __IOM uint32_t       CONSUMER_RAC_CLR_SET;              /**< CLR consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_CTIIN0_SET;           /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_CTIIN1_SET;           /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_CTIIN2_SET;           /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_CTIIN3_SET;           /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_FORCETX_SET;          /**< FORCETX Consumer register                          */
  __IOM uint32_t       CONSUMER_RAC_RXDIS_SET;            /**< RXDIS Consumer register                            */
  __IOM uint32_t       CONSUMER_RAC_RXEN_SET;             /**< RXEN Consumer register                             */
  __IOM uint32_t       CONSUMER_RAC_TXEN_SET;             /**< TXEN Consumer register                             */
  __IOM uint32_t       CONSUMER_RFTIMER_PULSE_SET;        /**< PULSE consumer register                            */
  __IOM uint32_t       CONSUMER_ADC0_ASYNCSEQ_SET;        /**< ASYNC consumer register                            */
  __IOM uint32_t       CONSUMER_ADC0_SYNCSEQ_SET;         /**< SYNC Consumer register                             */
  __IOM uint32_t       CONSUMER_SEQACC_WAIT0_SET;         /**< WAIT0 consumer register                            */
  __IOM uint32_t       CONSUMER_SEQACC_WAIT1_SET;         /**< WAIT1 Consumer register                            */
  __IOM uint32_t       CONSUMER_SEQACC_WAIT2_SET;         /**< WAIT2 Consumer register                            */
  __IOM uint32_t       CONSUMER_SEQACC_WAIT3_SET;         /**< WAIT3 Consumer register                            */
  __IOM uint32_t       CONSUMER_SETAMPER_TAMPERSRC29_SET; /**< TAMPERSRC29 consumer register                      */
  __IOM uint32_t       CONSUMER_SETAMPER_TAMPERSRC30_SET; /**< TAMPERSRC30 Consumer register                      */
  __IOM uint32_t       CONSUMER_SETAMPER_TAMPERSRC31_SET; /**< TAMPERSRC31 Consumer register                      */
  __IOM uint32_t       CONSUMER_SYSRTC0_IN0_SET;          /**< IN0 consumer register                              */
  __IOM uint32_t       CONSUMER_SYSRTC0_IN1_SET;          /**< IN1 Consumer register                              */
  __IOM uint32_t       CONSUMER_HFXO0_OSCREQ_SET;         /**< OSC consumer register                              */
  __IOM uint32_t       CONSUMER_HFXO0_TIMEOUT_SET;        /**< TIMEOUT Consumer register                          */
  __IOM uint32_t       CONSUMER_CORE_CTIIN0_SET;          /**< CTI consumer register                              */
  __IOM uint32_t       CONSUMER_CORE_CTIIN1_SET;          /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_CORE_CTIIN2_SET;          /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_CORE_CTIIN3_SET;          /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_CORE_M33RXEV_SET;         /**< M33 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_CC0_SET;           /**< CC0 consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_CC1_SET;           /**< CC1 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_CC2_SET;           /**< CC2 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_DTI_SET;           /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_DTIFS1_SET;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_DTIFS2_SET;        /**< DTI Consumer register                              */
  uint32_t             RESERVED9[3U];                     /**< Reserved for future use                            */
  __IOM uint32_t       CONSUMER_TIMER1_CC0_SET;           /**< CC0 consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_CC1_SET;           /**< CC1 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_CC2_SET;           /**< CC2 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_DTI_SET;           /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_DTIFS1_SET;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_DTIFS2_SET;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC0_SET;           /**< CC0 consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC1_SET;           /**< CC1 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC2_SET;           /**< CC2 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC3_SET;           /**< CC3 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC4_SET;           /**< CC4 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC5_SET;           /**< CC5 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC6_SET;           /**< CC6 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_DTI_SET;           /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_DTIFS1_SET;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_DTIFS2_SET;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC0_SET;           /**< CC0 consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC1_SET;           /**< CC1 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC2_SET;           /**< CC2 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC3_SET;           /**< CC3 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC4_SET;           /**< CC4 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC5_SET;           /**< CC5 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC6_SET;           /**< CC6 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_DTI_SET;           /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_DTIFS1_SET;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_DTIFS2_SET;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_WDOG0_SRC0_SET;           /**< SRC0 consumer register                             */
  __IOM uint32_t       CONSUMER_WDOG0_SRC1_SET;           /**< SRC1 Consumer register                             */
  __IOM uint32_t       CONSUMER_WDOG1_SRC0_SET;           /**< SRC0 consumer register                             */
  __IOM uint32_t       CONSUMER_WDOG1_SRC1_SET;           /**< SRC1 Consumer register                             */
  uint32_t             RESERVED10[4U];                    /**< Reserved for future use                            */
  __IOM uint32_t       RPURATD4_SET;                      /**< Root Access Type Descriptor Register               */
  uint32_t             RESERVED11[890U];                  /**< Reserved for future use                            */
  __IM uint32_t        IPVERSION_CLR;                     /**< PRS IPVERSION                                      */
  uint32_t             RESERVED12[1U];                    /**< Reserved for future use                            */
  __IOM uint32_t       ASYNC_SWPULSE_CLR;                 /**< Software Pulse Register                            */
  __IOM uint32_t       ASYNC_SWLEVEL_CLR;                 /**< Software Level Register                            */
  __IM uint32_t        ASYNC_PEEK_CLR;                    /**< Async Channel Values                               */
  __IM uint32_t        SYNC_PEEK_CLR;                     /**< Sync Channel Values                                */
  PRS_ASYNC_CH_TypeDef ASYNC_CH_CLR[12U];                 /**< Async Channel registers                            */
  uint32_t             RESERVED13[4U];                    /**< Reserved for future use                            */
  PRS_SYNC_CH_TypeDef  SYNC_CH_CLR[4U];                   /**< Sync Channel registers                             */
  __IOM uint32_t       CONSUMER_EUSART0_CLK_CLR;          /**< CLK consumer register                              */
  __IOM uint32_t       CONSUMER_EUSART0_RX_CLR;           /**< RX Consumer register                               */
  __IOM uint32_t       CONSUMER_EUSART0_TRIGGER_CLR;      /**< TRIGGER Consumer register                          */
  __IOM uint32_t       CONSUMER_EUSART1_CLK_CLR;          /**< CLK consumer register                              */
  __IOM uint32_t       CONSUMER_EUSART1_RX_CLR;           /**< RX Consumer register                               */
  __IOM uint32_t       CONSUMER_EUSART1_TRIGGER_CLR;      /**< TRIGGER Consumer register                          */
  __IOM uint32_t       CONSUMER_EUSART2_CLK_CLR;          /**< CLK consumer register                              */
  __IOM uint32_t       CONSUMER_EUSART2_RX_CLR;           /**< RX Consumer register                               */
  __IOM uint32_t       CONSUMER_EUSART2_TRIGGER_CLR;      /**< TRIGGER Consumer register                          */
  __IOM uint32_t       CONSUMER_FRC_RXRAW_CLR;            /**< RXRAW consumer register                            */
  __IOM uint32_t       CONSUMER_CMU_CALDN_CLR;            /**< CALDN consumer register                            */
  __IOM uint32_t       CONSUMER_CMU_CALUP_CLR;            /**< CALUP Consumer register                            */
  __IOM uint32_t       CONSUMER_LDMAXBAR0_DMAREQ0_CLR;    /**< DMAREQ0 consumer register                          */
  __IOM uint32_t       CONSUMER_LDMAXBAR0_DMAREQ1_CLR;    /**< DMAREQ1 Consumer register                          */
  __IOM uint32_t       CONSUMER_LEDDRV0_LEDDRV0ASYNC_CLR; /**< LEDDRV0 consumer register                          */
  __IOM uint32_t       CONSUMER_LEDDRV0_LEDDRV1ASYNC_CLR; /**< LEDDRV1 Consumer register                          */
  __IOM uint32_t       CONSUMER_LETIMER0_CLEAR_CLR;       /**< CLEAR consumer register                            */
  __IOM uint32_t       CONSUMER_LETIMER0_START_CLR;       /**< START Consumer register                            */
  __IOM uint32_t       CONSUMER_LETIMER0_STOP_CLR;        /**< STOP Consumer register                             */
  __IOM uint32_t       CONSUMER_MODEM_DIN_CLR;            /**< DIN consumer register                              */
  __IOM uint32_t       CONSUMER_MODEM_PAEN_CLR;           /**< PAEN Consumer register                             */
  __IOM uint32_t       CONSUMER_PCNT0_S0IN_CLR;           /**< S0IN consumer register                             */
  __IOM uint32_t       CONSUMER_PCNT0_S1IN_CLR;           /**< S1IN Consumer register                             */
  __IOM uint32_t       CONSUMER_PIXELRZ0_INASYNC_CLR;     /**< IN consumer register                               */
  __IOM uint32_t       CONSUMER_PIXELRZ1_INASYNC_CLR;     /**< IN consumer register                               */
  uint32_t             RESERVED14[11U];                   /**< Reserved for future use                            */
  __IOM uint32_t       CONSUMER_RAC_CLR_CLR;              /**< CLR consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_CTIIN0_CLR;           /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_CTIIN1_CLR;           /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_CTIIN2_CLR;           /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_CTIIN3_CLR;           /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_FORCETX_CLR;          /**< FORCETX Consumer register                          */
  __IOM uint32_t       CONSUMER_RAC_RXDIS_CLR;            /**< RXDIS Consumer register                            */
  __IOM uint32_t       CONSUMER_RAC_RXEN_CLR;             /**< RXEN Consumer register                             */
  __IOM uint32_t       CONSUMER_RAC_TXEN_CLR;             /**< TXEN Consumer register                             */
  __IOM uint32_t       CONSUMER_RFTIMER_PULSE_CLR;        /**< PULSE consumer register                            */
  __IOM uint32_t       CONSUMER_ADC0_ASYNCSEQ_CLR;        /**< ASYNC consumer register                            */
  __IOM uint32_t       CONSUMER_ADC0_SYNCSEQ_CLR;         /**< SYNC Consumer register                             */
  __IOM uint32_t       CONSUMER_SEQACC_WAIT0_CLR;         /**< WAIT0 consumer register                            */
  __IOM uint32_t       CONSUMER_SEQACC_WAIT1_CLR;         /**< WAIT1 Consumer register                            */
  __IOM uint32_t       CONSUMER_SEQACC_WAIT2_CLR;         /**< WAIT2 Consumer register                            */
  __IOM uint32_t       CONSUMER_SEQACC_WAIT3_CLR;         /**< WAIT3 Consumer register                            */
  __IOM uint32_t       CONSUMER_SETAMPER_TAMPERSRC29_CLR; /**< TAMPERSRC29 consumer register                      */
  __IOM uint32_t       CONSUMER_SETAMPER_TAMPERSRC30_CLR; /**< TAMPERSRC30 Consumer register                      */
  __IOM uint32_t       CONSUMER_SETAMPER_TAMPERSRC31_CLR; /**< TAMPERSRC31 Consumer register                      */
  __IOM uint32_t       CONSUMER_SYSRTC0_IN0_CLR;          /**< IN0 consumer register                              */
  __IOM uint32_t       CONSUMER_SYSRTC0_IN1_CLR;          /**< IN1 Consumer register                              */
  __IOM uint32_t       CONSUMER_HFXO0_OSCREQ_CLR;         /**< OSC consumer register                              */
  __IOM uint32_t       CONSUMER_HFXO0_TIMEOUT_CLR;        /**< TIMEOUT Consumer register                          */
  __IOM uint32_t       CONSUMER_CORE_CTIIN0_CLR;          /**< CTI consumer register                              */
  __IOM uint32_t       CONSUMER_CORE_CTIIN1_CLR;          /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_CORE_CTIIN2_CLR;          /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_CORE_CTIIN3_CLR;          /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_CORE_M33RXEV_CLR;         /**< M33 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_CC0_CLR;           /**< CC0 consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_CC1_CLR;           /**< CC1 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_CC2_CLR;           /**< CC2 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_DTI_CLR;           /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_DTIFS1_CLR;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_DTIFS2_CLR;        /**< DTI Consumer register                              */
  uint32_t             RESERVED15[3U];                    /**< Reserved for future use                            */
  __IOM uint32_t       CONSUMER_TIMER1_CC0_CLR;           /**< CC0 consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_CC1_CLR;           /**< CC1 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_CC2_CLR;           /**< CC2 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_DTI_CLR;           /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_DTIFS1_CLR;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_DTIFS2_CLR;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC0_CLR;           /**< CC0 consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC1_CLR;           /**< CC1 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC2_CLR;           /**< CC2 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC3_CLR;           /**< CC3 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC4_CLR;           /**< CC4 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC5_CLR;           /**< CC5 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC6_CLR;           /**< CC6 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_DTI_CLR;           /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_DTIFS1_CLR;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_DTIFS2_CLR;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC0_CLR;           /**< CC0 consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC1_CLR;           /**< CC1 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC2_CLR;           /**< CC2 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC3_CLR;           /**< CC3 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC4_CLR;           /**< CC4 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC5_CLR;           /**< CC5 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC6_CLR;           /**< CC6 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_DTI_CLR;           /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_DTIFS1_CLR;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_DTIFS2_CLR;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_WDOG0_SRC0_CLR;           /**< SRC0 consumer register                             */
  __IOM uint32_t       CONSUMER_WDOG0_SRC1_CLR;           /**< SRC1 Consumer register                             */
  __IOM uint32_t       CONSUMER_WDOG1_SRC0_CLR;           /**< SRC0 consumer register                             */
  __IOM uint32_t       CONSUMER_WDOG1_SRC1_CLR;           /**< SRC1 Consumer register                             */
  uint32_t             RESERVED16[4U];                    /**< Reserved for future use                            */
  __IOM uint32_t       RPURATD4_CLR;                      /**< Root Access Type Descriptor Register               */
  uint32_t             RESERVED17[890U];                  /**< Reserved for future use                            */
  __IM uint32_t        IPVERSION_TGL;                     /**< PRS IPVERSION                                      */
  uint32_t             RESERVED18[1U];                    /**< Reserved for future use                            */
  __IOM uint32_t       ASYNC_SWPULSE_TGL;                 /**< Software Pulse Register                            */
  __IOM uint32_t       ASYNC_SWLEVEL_TGL;                 /**< Software Level Register                            */
  __IM uint32_t        ASYNC_PEEK_TGL;                    /**< Async Channel Values                               */
  __IM uint32_t        SYNC_PEEK_TGL;                     /**< Sync Channel Values                                */
  PRS_ASYNC_CH_TypeDef ASYNC_CH_TGL[12U];                 /**< Async Channel registers                            */
  uint32_t             RESERVED19[4U];                    /**< Reserved for future use                            */
  PRS_SYNC_CH_TypeDef  SYNC_CH_TGL[4U];                   /**< Sync Channel registers                             */
  __IOM uint32_t       CONSUMER_EUSART0_CLK_TGL;          /**< CLK consumer register                              */
  __IOM uint32_t       CONSUMER_EUSART0_RX_TGL;           /**< RX Consumer register                               */
  __IOM uint32_t       CONSUMER_EUSART0_TRIGGER_TGL;      /**< TRIGGER Consumer register                          */
  __IOM uint32_t       CONSUMER_EUSART1_CLK_TGL;          /**< CLK consumer register                              */
  __IOM uint32_t       CONSUMER_EUSART1_RX_TGL;           /**< RX Consumer register                               */
  __IOM uint32_t       CONSUMER_EUSART1_TRIGGER_TGL;      /**< TRIGGER Consumer register                          */
  __IOM uint32_t       CONSUMER_EUSART2_CLK_TGL;          /**< CLK consumer register                              */
  __IOM uint32_t       CONSUMER_EUSART2_RX_TGL;           /**< RX Consumer register                               */
  __IOM uint32_t       CONSUMER_EUSART2_TRIGGER_TGL;      /**< TRIGGER Consumer register                          */
  __IOM uint32_t       CONSUMER_FRC_RXRAW_TGL;            /**< RXRAW consumer register                            */
  __IOM uint32_t       CONSUMER_CMU_CALDN_TGL;            /**< CALDN consumer register                            */
  __IOM uint32_t       CONSUMER_CMU_CALUP_TGL;            /**< CALUP Consumer register                            */
  __IOM uint32_t       CONSUMER_LDMAXBAR0_DMAREQ0_TGL;    /**< DMAREQ0 consumer register                          */
  __IOM uint32_t       CONSUMER_LDMAXBAR0_DMAREQ1_TGL;    /**< DMAREQ1 Consumer register                          */
  __IOM uint32_t       CONSUMER_LEDDRV0_LEDDRV0ASYNC_TGL; /**< LEDDRV0 consumer register                          */
  __IOM uint32_t       CONSUMER_LEDDRV0_LEDDRV1ASYNC_TGL; /**< LEDDRV1 Consumer register                          */
  __IOM uint32_t       CONSUMER_LETIMER0_CLEAR_TGL;       /**< CLEAR consumer register                            */
  __IOM uint32_t       CONSUMER_LETIMER0_START_TGL;       /**< START Consumer register                            */
  __IOM uint32_t       CONSUMER_LETIMER0_STOP_TGL;        /**< STOP Consumer register                             */
  __IOM uint32_t       CONSUMER_MODEM_DIN_TGL;            /**< DIN consumer register                              */
  __IOM uint32_t       CONSUMER_MODEM_PAEN_TGL;           /**< PAEN Consumer register                             */
  __IOM uint32_t       CONSUMER_PCNT0_S0IN_TGL;           /**< S0IN consumer register                             */
  __IOM uint32_t       CONSUMER_PCNT0_S1IN_TGL;           /**< S1IN Consumer register                             */
  __IOM uint32_t       CONSUMER_PIXELRZ0_INASYNC_TGL;     /**< IN consumer register                               */
  __IOM uint32_t       CONSUMER_PIXELRZ1_INASYNC_TGL;     /**< IN consumer register                               */
  uint32_t             RESERVED20[11U];                   /**< Reserved for future use                            */
  __IOM uint32_t       CONSUMER_RAC_CLR_TGL;              /**< CLR consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_CTIIN0_TGL;           /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_CTIIN1_TGL;           /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_CTIIN2_TGL;           /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_CTIIN3_TGL;           /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_RAC_FORCETX_TGL;          /**< FORCETX Consumer register                          */
  __IOM uint32_t       CONSUMER_RAC_RXDIS_TGL;            /**< RXDIS Consumer register                            */
  __IOM uint32_t       CONSUMER_RAC_RXEN_TGL;             /**< RXEN Consumer register                             */
  __IOM uint32_t       CONSUMER_RAC_TXEN_TGL;             /**< TXEN Consumer register                             */
  __IOM uint32_t       CONSUMER_RFTIMER_PULSE_TGL;        /**< PULSE consumer register                            */
  __IOM uint32_t       CONSUMER_ADC0_ASYNCSEQ_TGL;        /**< ASYNC consumer register                            */
  __IOM uint32_t       CONSUMER_ADC0_SYNCSEQ_TGL;         /**< SYNC Consumer register                             */
  __IOM uint32_t       CONSUMER_SEQACC_WAIT0_TGL;         /**< WAIT0 consumer register                            */
  __IOM uint32_t       CONSUMER_SEQACC_WAIT1_TGL;         /**< WAIT1 Consumer register                            */
  __IOM uint32_t       CONSUMER_SEQACC_WAIT2_TGL;         /**< WAIT2 Consumer register                            */
  __IOM uint32_t       CONSUMER_SEQACC_WAIT3_TGL;         /**< WAIT3 Consumer register                            */
  __IOM uint32_t       CONSUMER_SETAMPER_TAMPERSRC29_TGL; /**< TAMPERSRC29 consumer register                      */
  __IOM uint32_t       CONSUMER_SETAMPER_TAMPERSRC30_TGL; /**< TAMPERSRC30 Consumer register                      */
  __IOM uint32_t       CONSUMER_SETAMPER_TAMPERSRC31_TGL; /**< TAMPERSRC31 Consumer register                      */
  __IOM uint32_t       CONSUMER_SYSRTC0_IN0_TGL;          /**< IN0 consumer register                              */
  __IOM uint32_t       CONSUMER_SYSRTC0_IN1_TGL;          /**< IN1 Consumer register                              */
  __IOM uint32_t       CONSUMER_HFXO0_OSCREQ_TGL;         /**< OSC consumer register                              */
  __IOM uint32_t       CONSUMER_HFXO0_TIMEOUT_TGL;        /**< TIMEOUT Consumer register                          */
  __IOM uint32_t       CONSUMER_CORE_CTIIN0_TGL;          /**< CTI consumer register                              */
  __IOM uint32_t       CONSUMER_CORE_CTIIN1_TGL;          /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_CORE_CTIIN2_TGL;          /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_CORE_CTIIN3_TGL;          /**< CTI Consumer register                              */
  __IOM uint32_t       CONSUMER_CORE_M33RXEV_TGL;         /**< M33 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_CC0_TGL;           /**< CC0 consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_CC1_TGL;           /**< CC1 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_CC2_TGL;           /**< CC2 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_DTI_TGL;           /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_DTIFS1_TGL;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER0_DTIFS2_TGL;        /**< DTI Consumer register                              */
  uint32_t             RESERVED21[3U];                    /**< Reserved for future use                            */
  __IOM uint32_t       CONSUMER_TIMER1_CC0_TGL;           /**< CC0 consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_CC1_TGL;           /**< CC1 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_CC2_TGL;           /**< CC2 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_DTI_TGL;           /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_DTIFS1_TGL;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER1_DTIFS2_TGL;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC0_TGL;           /**< CC0 consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC1_TGL;           /**< CC1 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC2_TGL;           /**< CC2 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC3_TGL;           /**< CC3 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC4_TGL;           /**< CC4 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC5_TGL;           /**< CC5 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_CC6_TGL;           /**< CC6 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_DTI_TGL;           /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_DTIFS1_TGL;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER2_DTIFS2_TGL;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC0_TGL;           /**< CC0 consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC1_TGL;           /**< CC1 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC2_TGL;           /**< CC2 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC3_TGL;           /**< CC3 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC4_TGL;           /**< CC4 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC5_TGL;           /**< CC5 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_CC6_TGL;           /**< CC6 Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_DTI_TGL;           /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_DTIFS1_TGL;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_TIMER3_DTIFS2_TGL;        /**< DTI Consumer register                              */
  __IOM uint32_t       CONSUMER_WDOG0_SRC0_TGL;           /**< SRC0 consumer register                             */
  __IOM uint32_t       CONSUMER_WDOG0_SRC1_TGL;           /**< SRC1 Consumer register                             */
  __IOM uint32_t       CONSUMER_WDOG1_SRC0_TGL;           /**< SRC0 consumer register                             */
  __IOM uint32_t       CONSUMER_WDOG1_SRC1_TGL;           /**< SRC1 Consumer register                             */
  uint32_t             RESERVED22[4U];                    /**< Reserved for future use                            */
  __IOM uint32_t       RPURATD4_TGL;                      /**< Root Access Type Descriptor Register               */
} PRS_TypeDef;
/** @} End of group SIMG301_PRS */

/**************************************************************************//**
 * @addtogroup SIMG301_PRS
 * @{
 * @defgroup SIMG301_PRS_BitFields PRS Bit Fields
 * @{
 *****************************************************************************/

/* Bit fields for PRS IPVERSION */
#define _PRS_IPVERSION_RESETVALUE                            0x00000009UL                            /**< Default value for PRS_IPVERSION             */
#define _PRS_IPVERSION_MASK                                  0xFFFFFFFFUL                            /**< Mask for PRS_IPVERSION                      */
#define _PRS_IPVERSION_IPVERSION_SHIFT                       0                                       /**< Shift value for PRS_IPVERSION               */
#define _PRS_IPVERSION_IPVERSION_MASK                        0xFFFFFFFFUL                            /**< Bit mask for PRS_IPVERSION                  */
#define _PRS_IPVERSION_IPVERSION_DEFAULT                     0x00000009UL                            /**< Mode DEFAULT for PRS_IPVERSION              */
#define PRS_IPVERSION_IPVERSION_DEFAULT                      (_PRS_IPVERSION_IPVERSION_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_IPVERSION      */

/* Bit fields for PRS ASYNC_SWPULSE */
#define _PRS_ASYNC_SWPULSE_RESETVALUE                        0x00000000UL                                 /**< Default value for PRS_ASYNC_SWPULSE         */
#define _PRS_ASYNC_SWPULSE_MASK                              0x00000FFFUL                                 /**< Mask for PRS_ASYNC_SWPULSE                  */
#define PRS_ASYNC_SWPULSE_CH0PULSE                           (0x1UL << 0)                                 /**< Channel pulse                               */
#define _PRS_ASYNC_SWPULSE_CH0PULSE_SHIFT                    0                                            /**< Shift value for PRS_CH0PULSE                */
#define _PRS_ASYNC_SWPULSE_CH0PULSE_MASK                     0x1UL                                        /**< Bit mask for PRS_CH0PULSE                   */
#define _PRS_ASYNC_SWPULSE_CH0PULSE_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWPULSE          */
#define PRS_ASYNC_SWPULSE_CH0PULSE_DEFAULT                   (_PRS_ASYNC_SWPULSE_CH0PULSE_DEFAULT << 0)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWPULSE  */
#define PRS_ASYNC_SWPULSE_CH1PULSE                           (0x1UL << 1)                                 /**< Channel pulse                               */
#define _PRS_ASYNC_SWPULSE_CH1PULSE_SHIFT                    1                                            /**< Shift value for PRS_CH1PULSE                */
#define _PRS_ASYNC_SWPULSE_CH1PULSE_MASK                     0x2UL                                        /**< Bit mask for PRS_CH1PULSE                   */
#define _PRS_ASYNC_SWPULSE_CH1PULSE_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWPULSE          */
#define PRS_ASYNC_SWPULSE_CH1PULSE_DEFAULT                   (_PRS_ASYNC_SWPULSE_CH1PULSE_DEFAULT << 1)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWPULSE  */
#define PRS_ASYNC_SWPULSE_CH2PULSE                           (0x1UL << 2)                                 /**< Channel pulse                               */
#define _PRS_ASYNC_SWPULSE_CH2PULSE_SHIFT                    2                                            /**< Shift value for PRS_CH2PULSE                */
#define _PRS_ASYNC_SWPULSE_CH2PULSE_MASK                     0x4UL                                        /**< Bit mask for PRS_CH2PULSE                   */
#define _PRS_ASYNC_SWPULSE_CH2PULSE_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWPULSE          */
#define PRS_ASYNC_SWPULSE_CH2PULSE_DEFAULT                   (_PRS_ASYNC_SWPULSE_CH2PULSE_DEFAULT << 2)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWPULSE  */
#define PRS_ASYNC_SWPULSE_CH3PULSE                           (0x1UL << 3)                                 /**< Channel pulse                               */
#define _PRS_ASYNC_SWPULSE_CH3PULSE_SHIFT                    3                                            /**< Shift value for PRS_CH3PULSE                */
#define _PRS_ASYNC_SWPULSE_CH3PULSE_MASK                     0x8UL                                        /**< Bit mask for PRS_CH3PULSE                   */
#define _PRS_ASYNC_SWPULSE_CH3PULSE_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWPULSE          */
#define PRS_ASYNC_SWPULSE_CH3PULSE_DEFAULT                   (_PRS_ASYNC_SWPULSE_CH3PULSE_DEFAULT << 3)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWPULSE  */
#define PRS_ASYNC_SWPULSE_CH4PULSE                           (0x1UL << 4)                                 /**< Channel pulse                               */
#define _PRS_ASYNC_SWPULSE_CH4PULSE_SHIFT                    4                                            /**< Shift value for PRS_CH4PULSE                */
#define _PRS_ASYNC_SWPULSE_CH4PULSE_MASK                     0x10UL                                       /**< Bit mask for PRS_CH4PULSE                   */
#define _PRS_ASYNC_SWPULSE_CH4PULSE_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWPULSE          */
#define PRS_ASYNC_SWPULSE_CH4PULSE_DEFAULT                   (_PRS_ASYNC_SWPULSE_CH4PULSE_DEFAULT << 4)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWPULSE  */
#define PRS_ASYNC_SWPULSE_CH5PULSE                           (0x1UL << 5)                                 /**< Channel pulse                               */
#define _PRS_ASYNC_SWPULSE_CH5PULSE_SHIFT                    5                                            /**< Shift value for PRS_CH5PULSE                */
#define _PRS_ASYNC_SWPULSE_CH5PULSE_MASK                     0x20UL                                       /**< Bit mask for PRS_CH5PULSE                   */
#define _PRS_ASYNC_SWPULSE_CH5PULSE_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWPULSE          */
#define PRS_ASYNC_SWPULSE_CH5PULSE_DEFAULT                   (_PRS_ASYNC_SWPULSE_CH5PULSE_DEFAULT << 5)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWPULSE  */
#define PRS_ASYNC_SWPULSE_CH6PULSE                           (0x1UL << 6)                                 /**< Channel pulse                               */
#define _PRS_ASYNC_SWPULSE_CH6PULSE_SHIFT                    6                                            /**< Shift value for PRS_CH6PULSE                */
#define _PRS_ASYNC_SWPULSE_CH6PULSE_MASK                     0x40UL                                       /**< Bit mask for PRS_CH6PULSE                   */
#define _PRS_ASYNC_SWPULSE_CH6PULSE_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWPULSE          */
#define PRS_ASYNC_SWPULSE_CH6PULSE_DEFAULT                   (_PRS_ASYNC_SWPULSE_CH6PULSE_DEFAULT << 6)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWPULSE  */
#define PRS_ASYNC_SWPULSE_CH7PULSE                           (0x1UL << 7)                                 /**< Channel pulse                               */
#define _PRS_ASYNC_SWPULSE_CH7PULSE_SHIFT                    7                                            /**< Shift value for PRS_CH7PULSE                */
#define _PRS_ASYNC_SWPULSE_CH7PULSE_MASK                     0x80UL                                       /**< Bit mask for PRS_CH7PULSE                   */
#define _PRS_ASYNC_SWPULSE_CH7PULSE_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWPULSE          */
#define PRS_ASYNC_SWPULSE_CH7PULSE_DEFAULT                   (_PRS_ASYNC_SWPULSE_CH7PULSE_DEFAULT << 7)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWPULSE  */
#define PRS_ASYNC_SWPULSE_CH8PULSE                           (0x1UL << 8)                                 /**< Channel pulse                               */
#define _PRS_ASYNC_SWPULSE_CH8PULSE_SHIFT                    8                                            /**< Shift value for PRS_CH8PULSE                */
#define _PRS_ASYNC_SWPULSE_CH8PULSE_MASK                     0x100UL                                      /**< Bit mask for PRS_CH8PULSE                   */
#define _PRS_ASYNC_SWPULSE_CH8PULSE_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWPULSE          */
#define PRS_ASYNC_SWPULSE_CH8PULSE_DEFAULT                   (_PRS_ASYNC_SWPULSE_CH8PULSE_DEFAULT << 8)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWPULSE  */
#define PRS_ASYNC_SWPULSE_CH9PULSE                           (0x1UL << 9)                                 /**< Channel pulse                               */
#define _PRS_ASYNC_SWPULSE_CH9PULSE_SHIFT                    9                                            /**< Shift value for PRS_CH9PULSE                */
#define _PRS_ASYNC_SWPULSE_CH9PULSE_MASK                     0x200UL                                      /**< Bit mask for PRS_CH9PULSE                   */
#define _PRS_ASYNC_SWPULSE_CH9PULSE_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWPULSE          */
#define PRS_ASYNC_SWPULSE_CH9PULSE_DEFAULT                   (_PRS_ASYNC_SWPULSE_CH9PULSE_DEFAULT << 9)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWPULSE  */
#define PRS_ASYNC_SWPULSE_CH10PULSE                          (0x1UL << 10)                                /**< Channel pulse                               */
#define _PRS_ASYNC_SWPULSE_CH10PULSE_SHIFT                   10                                           /**< Shift value for PRS_CH10PULSE               */
#define _PRS_ASYNC_SWPULSE_CH10PULSE_MASK                    0x400UL                                      /**< Bit mask for PRS_CH10PULSE                  */
#define _PRS_ASYNC_SWPULSE_CH10PULSE_DEFAULT                 0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWPULSE          */
#define PRS_ASYNC_SWPULSE_CH10PULSE_DEFAULT                  (_PRS_ASYNC_SWPULSE_CH10PULSE_DEFAULT << 10) /**< Shifted mode DEFAULT for PRS_ASYNC_SWPULSE  */
#define PRS_ASYNC_SWPULSE_CH11PULSE                          (0x1UL << 11)                                /**< Channel pulse                               */
#define _PRS_ASYNC_SWPULSE_CH11PULSE_SHIFT                   11                                           /**< Shift value for PRS_CH11PULSE               */
#define _PRS_ASYNC_SWPULSE_CH11PULSE_MASK                    0x800UL                                      /**< Bit mask for PRS_CH11PULSE                  */
#define _PRS_ASYNC_SWPULSE_CH11PULSE_DEFAULT                 0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWPULSE          */
#define PRS_ASYNC_SWPULSE_CH11PULSE_DEFAULT                  (_PRS_ASYNC_SWPULSE_CH11PULSE_DEFAULT << 11) /**< Shifted mode DEFAULT for PRS_ASYNC_SWPULSE  */

/* Bit fields for PRS ASYNC_SWLEVEL */
#define _PRS_ASYNC_SWLEVEL_RESETVALUE                        0x00000000UL                                 /**< Default value for PRS_ASYNC_SWLEVEL         */
#define _PRS_ASYNC_SWLEVEL_MASK                              0x00000FFFUL                                 /**< Mask for PRS_ASYNC_SWLEVEL                  */
#define PRS_ASYNC_SWLEVEL_CH0LEVEL                           (0x1UL << 0)                                 /**< Channel Level                               */
#define _PRS_ASYNC_SWLEVEL_CH0LEVEL_SHIFT                    0                                            /**< Shift value for PRS_CH0LEVEL                */
#define _PRS_ASYNC_SWLEVEL_CH0LEVEL_MASK                     0x1UL                                        /**< Bit mask for PRS_CH0LEVEL                   */
#define _PRS_ASYNC_SWLEVEL_CH0LEVEL_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWLEVEL          */
#define PRS_ASYNC_SWLEVEL_CH0LEVEL_DEFAULT                   (_PRS_ASYNC_SWLEVEL_CH0LEVEL_DEFAULT << 0)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWLEVEL  */
#define PRS_ASYNC_SWLEVEL_CH1LEVEL                           (0x1UL << 1)                                 /**< Channel Level                               */
#define _PRS_ASYNC_SWLEVEL_CH1LEVEL_SHIFT                    1                                            /**< Shift value for PRS_CH1LEVEL                */
#define _PRS_ASYNC_SWLEVEL_CH1LEVEL_MASK                     0x2UL                                        /**< Bit mask for PRS_CH1LEVEL                   */
#define _PRS_ASYNC_SWLEVEL_CH1LEVEL_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWLEVEL          */
#define PRS_ASYNC_SWLEVEL_CH1LEVEL_DEFAULT                   (_PRS_ASYNC_SWLEVEL_CH1LEVEL_DEFAULT << 1)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWLEVEL  */
#define PRS_ASYNC_SWLEVEL_CH2LEVEL                           (0x1UL << 2)                                 /**< Channel Level                               */
#define _PRS_ASYNC_SWLEVEL_CH2LEVEL_SHIFT                    2                                            /**< Shift value for PRS_CH2LEVEL                */
#define _PRS_ASYNC_SWLEVEL_CH2LEVEL_MASK                     0x4UL                                        /**< Bit mask for PRS_CH2LEVEL                   */
#define _PRS_ASYNC_SWLEVEL_CH2LEVEL_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWLEVEL          */
#define PRS_ASYNC_SWLEVEL_CH2LEVEL_DEFAULT                   (_PRS_ASYNC_SWLEVEL_CH2LEVEL_DEFAULT << 2)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWLEVEL  */
#define PRS_ASYNC_SWLEVEL_CH3LEVEL                           (0x1UL << 3)                                 /**< Channel Level                               */
#define _PRS_ASYNC_SWLEVEL_CH3LEVEL_SHIFT                    3                                            /**< Shift value for PRS_CH3LEVEL                */
#define _PRS_ASYNC_SWLEVEL_CH3LEVEL_MASK                     0x8UL                                        /**< Bit mask for PRS_CH3LEVEL                   */
#define _PRS_ASYNC_SWLEVEL_CH3LEVEL_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWLEVEL          */
#define PRS_ASYNC_SWLEVEL_CH3LEVEL_DEFAULT                   (_PRS_ASYNC_SWLEVEL_CH3LEVEL_DEFAULT << 3)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWLEVEL  */
#define PRS_ASYNC_SWLEVEL_CH4LEVEL                           (0x1UL << 4)                                 /**< Channel Level                               */
#define _PRS_ASYNC_SWLEVEL_CH4LEVEL_SHIFT                    4                                            /**< Shift value for PRS_CH4LEVEL                */
#define _PRS_ASYNC_SWLEVEL_CH4LEVEL_MASK                     0x10UL                                       /**< Bit mask for PRS_CH4LEVEL                   */
#define _PRS_ASYNC_SWLEVEL_CH4LEVEL_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWLEVEL          */
#define PRS_ASYNC_SWLEVEL_CH4LEVEL_DEFAULT                   (_PRS_ASYNC_SWLEVEL_CH4LEVEL_DEFAULT << 4)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWLEVEL  */
#define PRS_ASYNC_SWLEVEL_CH5LEVEL                           (0x1UL << 5)                                 /**< Channel Level                               */
#define _PRS_ASYNC_SWLEVEL_CH5LEVEL_SHIFT                    5                                            /**< Shift value for PRS_CH5LEVEL                */
#define _PRS_ASYNC_SWLEVEL_CH5LEVEL_MASK                     0x20UL                                       /**< Bit mask for PRS_CH5LEVEL                   */
#define _PRS_ASYNC_SWLEVEL_CH5LEVEL_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWLEVEL          */
#define PRS_ASYNC_SWLEVEL_CH5LEVEL_DEFAULT                   (_PRS_ASYNC_SWLEVEL_CH5LEVEL_DEFAULT << 5)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWLEVEL  */
#define PRS_ASYNC_SWLEVEL_CH6LEVEL                           (0x1UL << 6)                                 /**< Channel Level                               */
#define _PRS_ASYNC_SWLEVEL_CH6LEVEL_SHIFT                    6                                            /**< Shift value for PRS_CH6LEVEL                */
#define _PRS_ASYNC_SWLEVEL_CH6LEVEL_MASK                     0x40UL                                       /**< Bit mask for PRS_CH6LEVEL                   */
#define _PRS_ASYNC_SWLEVEL_CH6LEVEL_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWLEVEL          */
#define PRS_ASYNC_SWLEVEL_CH6LEVEL_DEFAULT                   (_PRS_ASYNC_SWLEVEL_CH6LEVEL_DEFAULT << 6)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWLEVEL  */
#define PRS_ASYNC_SWLEVEL_CH7LEVEL                           (0x1UL << 7)                                 /**< Channel Level                               */
#define _PRS_ASYNC_SWLEVEL_CH7LEVEL_SHIFT                    7                                            /**< Shift value for PRS_CH7LEVEL                */
#define _PRS_ASYNC_SWLEVEL_CH7LEVEL_MASK                     0x80UL                                       /**< Bit mask for PRS_CH7LEVEL                   */
#define _PRS_ASYNC_SWLEVEL_CH7LEVEL_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWLEVEL          */
#define PRS_ASYNC_SWLEVEL_CH7LEVEL_DEFAULT                   (_PRS_ASYNC_SWLEVEL_CH7LEVEL_DEFAULT << 7)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWLEVEL  */
#define PRS_ASYNC_SWLEVEL_CH8LEVEL                           (0x1UL << 8)                                 /**< Channel Level                               */
#define _PRS_ASYNC_SWLEVEL_CH8LEVEL_SHIFT                    8                                            /**< Shift value for PRS_CH8LEVEL                */
#define _PRS_ASYNC_SWLEVEL_CH8LEVEL_MASK                     0x100UL                                      /**< Bit mask for PRS_CH8LEVEL                   */
#define _PRS_ASYNC_SWLEVEL_CH8LEVEL_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWLEVEL          */
#define PRS_ASYNC_SWLEVEL_CH8LEVEL_DEFAULT                   (_PRS_ASYNC_SWLEVEL_CH8LEVEL_DEFAULT << 8)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWLEVEL  */
#define PRS_ASYNC_SWLEVEL_CH9LEVEL                           (0x1UL << 9)                                 /**< Channel Level                               */
#define _PRS_ASYNC_SWLEVEL_CH9LEVEL_SHIFT                    9                                            /**< Shift value for PRS_CH9LEVEL                */
#define _PRS_ASYNC_SWLEVEL_CH9LEVEL_MASK                     0x200UL                                      /**< Bit mask for PRS_CH9LEVEL                   */
#define _PRS_ASYNC_SWLEVEL_CH9LEVEL_DEFAULT                  0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWLEVEL          */
#define PRS_ASYNC_SWLEVEL_CH9LEVEL_DEFAULT                   (_PRS_ASYNC_SWLEVEL_CH9LEVEL_DEFAULT << 9)   /**< Shifted mode DEFAULT for PRS_ASYNC_SWLEVEL  */
#define PRS_ASYNC_SWLEVEL_CH10LEVEL                          (0x1UL << 10)                                /**< Channel Level                               */
#define _PRS_ASYNC_SWLEVEL_CH10LEVEL_SHIFT                   10                                           /**< Shift value for PRS_CH10LEVEL               */
#define _PRS_ASYNC_SWLEVEL_CH10LEVEL_MASK                    0x400UL                                      /**< Bit mask for PRS_CH10LEVEL                  */
#define _PRS_ASYNC_SWLEVEL_CH10LEVEL_DEFAULT                 0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWLEVEL          */
#define PRS_ASYNC_SWLEVEL_CH10LEVEL_DEFAULT                  (_PRS_ASYNC_SWLEVEL_CH10LEVEL_DEFAULT << 10) /**< Shifted mode DEFAULT for PRS_ASYNC_SWLEVEL  */
#define PRS_ASYNC_SWLEVEL_CH11LEVEL                          (0x1UL << 11)                                /**< Channel Level                               */
#define _PRS_ASYNC_SWLEVEL_CH11LEVEL_SHIFT                   11                                           /**< Shift value for PRS_CH11LEVEL               */
#define _PRS_ASYNC_SWLEVEL_CH11LEVEL_MASK                    0x800UL                                      /**< Bit mask for PRS_CH11LEVEL                  */
#define _PRS_ASYNC_SWLEVEL_CH11LEVEL_DEFAULT                 0x00000000UL                                 /**< Mode DEFAULT for PRS_ASYNC_SWLEVEL          */
#define PRS_ASYNC_SWLEVEL_CH11LEVEL_DEFAULT                  (_PRS_ASYNC_SWLEVEL_CH11LEVEL_DEFAULT << 11) /**< Shifted mode DEFAULT for PRS_ASYNC_SWLEVEL  */

/* Bit fields for PRS ASYNC_PEEK */
#define _PRS_ASYNC_PEEK_RESETVALUE                           0x00000000UL                            /**< Default value for PRS_ASYNC_PEEK            */
#define _PRS_ASYNC_PEEK_MASK                                 0x00000FFFUL                            /**< Mask for PRS_ASYNC_PEEK                     */
#define PRS_ASYNC_PEEK_CH0VAL                                (0x1UL << 0)                            /**< Channel 0 Current Value                     */
#define _PRS_ASYNC_PEEK_CH0VAL_SHIFT                         0                                       /**< Shift value for PRS_CH0VAL                  */
#define _PRS_ASYNC_PEEK_CH0VAL_MASK                          0x1UL                                   /**< Bit mask for PRS_CH0VAL                     */
#define _PRS_ASYNC_PEEK_CH0VAL_DEFAULT                       0x00000000UL                            /**< Mode DEFAULT for PRS_ASYNC_PEEK             */
#define PRS_ASYNC_PEEK_CH0VAL_DEFAULT                        (_PRS_ASYNC_PEEK_CH0VAL_DEFAULT << 0)   /**< Shifted mode DEFAULT for PRS_ASYNC_PEEK     */
#define PRS_ASYNC_PEEK_CH1VAL                                (0x1UL << 1)                            /**< Channel 1 Current Value                     */
#define _PRS_ASYNC_PEEK_CH1VAL_SHIFT                         1                                       /**< Shift value for PRS_CH1VAL                  */
#define _PRS_ASYNC_PEEK_CH1VAL_MASK                          0x2UL                                   /**< Bit mask for PRS_CH1VAL                     */
#define _PRS_ASYNC_PEEK_CH1VAL_DEFAULT                       0x00000000UL                            /**< Mode DEFAULT for PRS_ASYNC_PEEK             */
#define PRS_ASYNC_PEEK_CH1VAL_DEFAULT                        (_PRS_ASYNC_PEEK_CH1VAL_DEFAULT << 1)   /**< Shifted mode DEFAULT for PRS_ASYNC_PEEK     */
#define PRS_ASYNC_PEEK_CH2VAL                                (0x1UL << 2)                            /**< Channel 2 Current Value                     */
#define _PRS_ASYNC_PEEK_CH2VAL_SHIFT                         2                                       /**< Shift value for PRS_CH2VAL                  */
#define _PRS_ASYNC_PEEK_CH2VAL_MASK                          0x4UL                                   /**< Bit mask for PRS_CH2VAL                     */
#define _PRS_ASYNC_PEEK_CH2VAL_DEFAULT                       0x00000000UL                            /**< Mode DEFAULT for PRS_ASYNC_PEEK             */
#define PRS_ASYNC_PEEK_CH2VAL_DEFAULT                        (_PRS_ASYNC_PEEK_CH2VAL_DEFAULT << 2)   /**< Shifted mode DEFAULT for PRS_ASYNC_PEEK     */
#define PRS_ASYNC_PEEK_CH3VAL                                (0x1UL << 3)                            /**< Channel 3 Current Value                     */
#define _PRS_ASYNC_PEEK_CH3VAL_SHIFT                         3                                       /**< Shift value for PRS_CH3VAL                  */
#define _PRS_ASYNC_PEEK_CH3VAL_MASK                          0x8UL                                   /**< Bit mask for PRS_CH3VAL                     */
#define _PRS_ASYNC_PEEK_CH3VAL_DEFAULT                       0x00000000UL                            /**< Mode DEFAULT for PRS_ASYNC_PEEK             */
#define PRS_ASYNC_PEEK_CH3VAL_DEFAULT                        (_PRS_ASYNC_PEEK_CH3VAL_DEFAULT << 3)   /**< Shifted mode DEFAULT for PRS_ASYNC_PEEK     */
#define PRS_ASYNC_PEEK_CH4VAL                                (0x1UL << 4)                            /**< Channel 4 Current Value                     */
#define _PRS_ASYNC_PEEK_CH4VAL_SHIFT                         4                                       /**< Shift value for PRS_CH4VAL                  */
#define _PRS_ASYNC_PEEK_CH4VAL_MASK                          0x10UL                                  /**< Bit mask for PRS_CH4VAL                     */
#define _PRS_ASYNC_PEEK_CH4VAL_DEFAULT                       0x00000000UL                            /**< Mode DEFAULT for PRS_ASYNC_PEEK             */
#define PRS_ASYNC_PEEK_CH4VAL_DEFAULT                        (_PRS_ASYNC_PEEK_CH4VAL_DEFAULT << 4)   /**< Shifted mode DEFAULT for PRS_ASYNC_PEEK     */
#define PRS_ASYNC_PEEK_CH5VAL                                (0x1UL << 5)                            /**< Channel 5 Current Value                     */
#define _PRS_ASYNC_PEEK_CH5VAL_SHIFT                         5                                       /**< Shift value for PRS_CH5VAL                  */
#define _PRS_ASYNC_PEEK_CH5VAL_MASK                          0x20UL                                  /**< Bit mask for PRS_CH5VAL                     */
#define _PRS_ASYNC_PEEK_CH5VAL_DEFAULT                       0x00000000UL                            /**< Mode DEFAULT for PRS_ASYNC_PEEK             */
#define PRS_ASYNC_PEEK_CH5VAL_DEFAULT                        (_PRS_ASYNC_PEEK_CH5VAL_DEFAULT << 5)   /**< Shifted mode DEFAULT for PRS_ASYNC_PEEK     */
#define PRS_ASYNC_PEEK_CH6VAL                                (0x1UL << 6)                            /**< Channel 6 Current Value                     */
#define _PRS_ASYNC_PEEK_CH6VAL_SHIFT                         6                                       /**< Shift value for PRS_CH6VAL                  */
#define _PRS_ASYNC_PEEK_CH6VAL_MASK                          0x40UL                                  /**< Bit mask for PRS_CH6VAL                     */
#define _PRS_ASYNC_PEEK_CH6VAL_DEFAULT                       0x00000000UL                            /**< Mode DEFAULT for PRS_ASYNC_PEEK             */
#define PRS_ASYNC_PEEK_CH6VAL_DEFAULT                        (_PRS_ASYNC_PEEK_CH6VAL_DEFAULT << 6)   /**< Shifted mode DEFAULT for PRS_ASYNC_PEEK     */
#define PRS_ASYNC_PEEK_CH7VAL                                (0x1UL << 7)                            /**< Channel 7 Current Value                     */
#define _PRS_ASYNC_PEEK_CH7VAL_SHIFT                         7                                       /**< Shift value for PRS_CH7VAL                  */
#define _PRS_ASYNC_PEEK_CH7VAL_MASK                          0x80UL                                  /**< Bit mask for PRS_CH7VAL                     */
#define _PRS_ASYNC_PEEK_CH7VAL_DEFAULT                       0x00000000UL                            /**< Mode DEFAULT for PRS_ASYNC_PEEK             */
#define PRS_ASYNC_PEEK_CH7VAL_DEFAULT                        (_PRS_ASYNC_PEEK_CH7VAL_DEFAULT << 7)   /**< Shifted mode DEFAULT for PRS_ASYNC_PEEK     */
#define PRS_ASYNC_PEEK_CH8VAL                                (0x1UL << 8)                            /**< Channel 8 Current Value                     */
#define _PRS_ASYNC_PEEK_CH8VAL_SHIFT                         8                                       /**< Shift value for PRS_CH8VAL                  */
#define _PRS_ASYNC_PEEK_CH8VAL_MASK                          0x100UL                                 /**< Bit mask for PRS_CH8VAL                     */
#define _PRS_ASYNC_PEEK_CH8VAL_DEFAULT                       0x00000000UL                            /**< Mode DEFAULT for PRS_ASYNC_PEEK             */
#define PRS_ASYNC_PEEK_CH8VAL_DEFAULT                        (_PRS_ASYNC_PEEK_CH8VAL_DEFAULT << 8)   /**< Shifted mode DEFAULT for PRS_ASYNC_PEEK     */
#define PRS_ASYNC_PEEK_CH9VAL                                (0x1UL << 9)                            /**< Channel 9 Current Value                     */
#define _PRS_ASYNC_PEEK_CH9VAL_SHIFT                         9                                       /**< Shift value for PRS_CH9VAL                  */
#define _PRS_ASYNC_PEEK_CH9VAL_MASK                          0x200UL                                 /**< Bit mask for PRS_CH9VAL                     */
#define _PRS_ASYNC_PEEK_CH9VAL_DEFAULT                       0x00000000UL                            /**< Mode DEFAULT for PRS_ASYNC_PEEK             */
#define PRS_ASYNC_PEEK_CH9VAL_DEFAULT                        (_PRS_ASYNC_PEEK_CH9VAL_DEFAULT << 9)   /**< Shifted mode DEFAULT for PRS_ASYNC_PEEK     */
#define PRS_ASYNC_PEEK_CH10VAL                               (0x1UL << 10)                           /**< Channel 10 Current Value                    */
#define _PRS_ASYNC_PEEK_CH10VAL_SHIFT                        10                                      /**< Shift value for PRS_CH10VAL                 */
#define _PRS_ASYNC_PEEK_CH10VAL_MASK                         0x400UL                                 /**< Bit mask for PRS_CH10VAL                    */
#define _PRS_ASYNC_PEEK_CH10VAL_DEFAULT                      0x00000000UL                            /**< Mode DEFAULT for PRS_ASYNC_PEEK             */
#define PRS_ASYNC_PEEK_CH10VAL_DEFAULT                       (_PRS_ASYNC_PEEK_CH10VAL_DEFAULT << 10) /**< Shifted mode DEFAULT for PRS_ASYNC_PEEK     */
#define PRS_ASYNC_PEEK_CH11VAL                               (0x1UL << 11)                           /**< Channel 11 Current Value                    */
#define _PRS_ASYNC_PEEK_CH11VAL_SHIFT                        11                                      /**< Shift value for PRS_CH11VAL                 */
#define _PRS_ASYNC_PEEK_CH11VAL_MASK                         0x800UL                                 /**< Bit mask for PRS_CH11VAL                    */
#define _PRS_ASYNC_PEEK_CH11VAL_DEFAULT                      0x00000000UL                            /**< Mode DEFAULT for PRS_ASYNC_PEEK             */
#define PRS_ASYNC_PEEK_CH11VAL_DEFAULT                       (_PRS_ASYNC_PEEK_CH11VAL_DEFAULT << 11) /**< Shifted mode DEFAULT for PRS_ASYNC_PEEK     */

/* Bit fields for PRS SYNC_PEEK */
#define _PRS_SYNC_PEEK_RESETVALUE                            0x00000000UL                         /**< Default value for PRS_SYNC_PEEK             */
#define _PRS_SYNC_PEEK_MASK                                  0x0000000FUL                         /**< Mask for PRS_SYNC_PEEK                      */
#define PRS_SYNC_PEEK_CH0VAL                                 (0x1UL << 0)                         /**< Channel Value                               */
#define _PRS_SYNC_PEEK_CH0VAL_SHIFT                          0                                    /**< Shift value for PRS_CH0VAL                  */
#define _PRS_SYNC_PEEK_CH0VAL_MASK                           0x1UL                                /**< Bit mask for PRS_CH0VAL                     */
#define _PRS_SYNC_PEEK_CH0VAL_DEFAULT                        0x00000000UL                         /**< Mode DEFAULT for PRS_SYNC_PEEK              */
#define PRS_SYNC_PEEK_CH0VAL_DEFAULT                         (_PRS_SYNC_PEEK_CH0VAL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_SYNC_PEEK      */
#define PRS_SYNC_PEEK_CH1VAL                                 (0x1UL << 1)                         /**< Channel Value                               */
#define _PRS_SYNC_PEEK_CH1VAL_SHIFT                          1                                    /**< Shift value for PRS_CH1VAL                  */
#define _PRS_SYNC_PEEK_CH1VAL_MASK                           0x2UL                                /**< Bit mask for PRS_CH1VAL                     */
#define _PRS_SYNC_PEEK_CH1VAL_DEFAULT                        0x00000000UL                         /**< Mode DEFAULT for PRS_SYNC_PEEK              */
#define PRS_SYNC_PEEK_CH1VAL_DEFAULT                         (_PRS_SYNC_PEEK_CH1VAL_DEFAULT << 1) /**< Shifted mode DEFAULT for PRS_SYNC_PEEK      */
#define PRS_SYNC_PEEK_CH2VAL                                 (0x1UL << 2)                         /**< Channel Value                               */
#define _PRS_SYNC_PEEK_CH2VAL_SHIFT                          2                                    /**< Shift value for PRS_CH2VAL                  */
#define _PRS_SYNC_PEEK_CH2VAL_MASK                           0x4UL                                /**< Bit mask for PRS_CH2VAL                     */
#define _PRS_SYNC_PEEK_CH2VAL_DEFAULT                        0x00000000UL                         /**< Mode DEFAULT for PRS_SYNC_PEEK              */
#define PRS_SYNC_PEEK_CH2VAL_DEFAULT                         (_PRS_SYNC_PEEK_CH2VAL_DEFAULT << 2) /**< Shifted mode DEFAULT for PRS_SYNC_PEEK      */
#define PRS_SYNC_PEEK_CH3VAL                                 (0x1UL << 3)                         /**< Channel Value                               */
#define _PRS_SYNC_PEEK_CH3VAL_SHIFT                          3                                    /**< Shift value for PRS_CH3VAL                  */
#define _PRS_SYNC_PEEK_CH3VAL_MASK                           0x8UL                                /**< Bit mask for PRS_CH3VAL                     */
#define _PRS_SYNC_PEEK_CH3VAL_DEFAULT                        0x00000000UL                         /**< Mode DEFAULT for PRS_SYNC_PEEK              */
#define PRS_SYNC_PEEK_CH3VAL_DEFAULT                         (_PRS_SYNC_PEEK_CH3VAL_DEFAULT << 3) /**< Shifted mode DEFAULT for PRS_SYNC_PEEK      */

/* Bit fields for PRS ASYNC_CH_CTRL */
#define _PRS_ASYNC_CH_CTRL_RESETVALUE                        0x000C0000UL                                  /**< Default value for PRS_ASYNC_CH_CTRL         */
#define _PRS_ASYNC_CH_CTRL_MASK                              0x0F0F7F07UL                                  /**< Mask for PRS_ASYNC_CH_CTRL                  */
#define _PRS_ASYNC_CH_CTRL_SIGSEL_SHIFT                      0                                             /**< Shift value for PRS_SIGSEL                  */
#define _PRS_ASYNC_CH_CTRL_SIGSEL_MASK                       0x7UL                                         /**< Bit mask for PRS_SIGSEL                     */
#define _PRS_ASYNC_CH_CTRL_SIGSEL_DEFAULT                    0x00000000UL                                  /**< Mode DEFAULT for PRS_ASYNC_CH_CTRL          */
#define _PRS_ASYNC_CH_CTRL_SIGSEL_NONE                       0x00000000UL                                  /**< Mode NONE for PRS_ASYNC_CH_CTRL             */
#define PRS_ASYNC_CH_CTRL_SIGSEL_DEFAULT                     (_PRS_ASYNC_CH_CTRL_SIGSEL_DEFAULT << 0)      /**< Shifted mode DEFAULT for PRS_ASYNC_CH_CTRL  */
#define PRS_ASYNC_CH_CTRL_SIGSEL_NONE                        (_PRS_ASYNC_CH_CTRL_SIGSEL_NONE << 0)         /**< Shifted mode NONE for PRS_ASYNC_CH_CTRL     */
#define _PRS_ASYNC_CH_CTRL_SOURCESEL_SHIFT                   8                                             /**< Shift value for PRS_SOURCESEL               */
#define _PRS_ASYNC_CH_CTRL_SOURCESEL_MASK                    0x7F00UL                                      /**< Bit mask for PRS_SOURCESEL                  */
#define _PRS_ASYNC_CH_CTRL_SOURCESEL_DEFAULT                 0x00000000UL                                  /**< Mode DEFAULT for PRS_ASYNC_CH_CTRL          */
#define PRS_ASYNC_CH_CTRL_SOURCESEL_DEFAULT                  (_PRS_ASYNC_CH_CTRL_SOURCESEL_DEFAULT << 8)   /**< Shifted mode DEFAULT for PRS_ASYNC_CH_CTRL  */
#define _PRS_ASYNC_CH_CTRL_FNSEL_SHIFT                       16                                            /**< Shift value for PRS_FNSEL                   */
#define _PRS_ASYNC_CH_CTRL_FNSEL_MASK                        0xF0000UL                                     /**< Bit mask for PRS_FNSEL                      */
#define _PRS_ASYNC_CH_CTRL_FNSEL_DEFAULT                     0x0000000CUL                                  /**< Mode DEFAULT for PRS_ASYNC_CH_CTRL          */
#define _PRS_ASYNC_CH_CTRL_FNSEL_LOGICAL_ZERO                0x00000000UL                                  /**< Mode LOGICAL_ZERO for PRS_ASYNC_CH_CTRL     */
#define _PRS_ASYNC_CH_CTRL_FNSEL_A_NOR_B                     0x00000001UL                                  /**< Mode A_NOR_B for PRS_ASYNC_CH_CTRL          */
#define _PRS_ASYNC_CH_CTRL_FNSEL_NOT_A_AND_B                 0x00000002UL                                  /**< Mode NOT_A_AND_B for PRS_ASYNC_CH_CTRL      */
#define _PRS_ASYNC_CH_CTRL_FNSEL_NOT_A                       0x00000003UL                                  /**< Mode NOT_A for PRS_ASYNC_CH_CTRL            */
#define _PRS_ASYNC_CH_CTRL_FNSEL_A_AND_NOT_B                 0x00000004UL                                  /**< Mode A_AND_NOT_B for PRS_ASYNC_CH_CTRL      */
#define _PRS_ASYNC_CH_CTRL_FNSEL_NOT_B                       0x00000005UL                                  /**< Mode NOT_B for PRS_ASYNC_CH_CTRL            */
#define _PRS_ASYNC_CH_CTRL_FNSEL_A_XOR_B                     0x00000006UL                                  /**< Mode A_XOR_B for PRS_ASYNC_CH_CTRL          */
#define _PRS_ASYNC_CH_CTRL_FNSEL_A_NAND_B                    0x00000007UL                                  /**< Mode A_NAND_B for PRS_ASYNC_CH_CTRL         */
#define _PRS_ASYNC_CH_CTRL_FNSEL_A_AND_B                     0x00000008UL                                  /**< Mode A_AND_B for PRS_ASYNC_CH_CTRL          */
#define _PRS_ASYNC_CH_CTRL_FNSEL_A_XNOR_B                    0x00000009UL                                  /**< Mode A_XNOR_B for PRS_ASYNC_CH_CTRL         */
#define _PRS_ASYNC_CH_CTRL_FNSEL_B                           0x0000000AUL                                  /**< Mode B for PRS_ASYNC_CH_CTRL                */
#define _PRS_ASYNC_CH_CTRL_FNSEL_NOT_A_OR_B                  0x0000000BUL                                  /**< Mode NOT_A_OR_B for PRS_ASYNC_CH_CTRL       */
#define _PRS_ASYNC_CH_CTRL_FNSEL_A                           0x0000000CUL                                  /**< Mode A for PRS_ASYNC_CH_CTRL                */
#define _PRS_ASYNC_CH_CTRL_FNSEL_A_OR_NOT_B                  0x0000000DUL                                  /**< Mode A_OR_NOT_B for PRS_ASYNC_CH_CTRL       */
#define _PRS_ASYNC_CH_CTRL_FNSEL_A_OR_B                      0x0000000EUL                                  /**< Mode A_OR_B for PRS_ASYNC_CH_CTRL           */
#define _PRS_ASYNC_CH_CTRL_FNSEL_LOGICAL_ONE                 0x0000000FUL                                  /**< Mode LOGICAL_ONE for PRS_ASYNC_CH_CTRL      */
#define PRS_ASYNC_CH_CTRL_FNSEL_DEFAULT                      (_PRS_ASYNC_CH_CTRL_FNSEL_DEFAULT << 16)      /**< Shifted mode DEFAULT for PRS_ASYNC_CH_CTRL  */
#define PRS_ASYNC_CH_CTRL_FNSEL_LOGICAL_ZERO                 (_PRS_ASYNC_CH_CTRL_FNSEL_LOGICAL_ZERO << 16) /**< Shifted mode LOGICAL_ZERO for PRS_ASYNC_CH_CTRL*/
#define PRS_ASYNC_CH_CTRL_FNSEL_A_NOR_B                      (_PRS_ASYNC_CH_CTRL_FNSEL_A_NOR_B << 16)      /**< Shifted mode A_NOR_B for PRS_ASYNC_CH_CTRL  */
#define PRS_ASYNC_CH_CTRL_FNSEL_NOT_A_AND_B                  (_PRS_ASYNC_CH_CTRL_FNSEL_NOT_A_AND_B << 16)  /**< Shifted mode NOT_A_AND_B for PRS_ASYNC_CH_CTRL*/
#define PRS_ASYNC_CH_CTRL_FNSEL_NOT_A                        (_PRS_ASYNC_CH_CTRL_FNSEL_NOT_A << 16)        /**< Shifted mode NOT_A for PRS_ASYNC_CH_CTRL    */
#define PRS_ASYNC_CH_CTRL_FNSEL_A_AND_NOT_B                  (_PRS_ASYNC_CH_CTRL_FNSEL_A_AND_NOT_B << 16)  /**< Shifted mode A_AND_NOT_B for PRS_ASYNC_CH_CTRL*/
#define PRS_ASYNC_CH_CTRL_FNSEL_NOT_B                        (_PRS_ASYNC_CH_CTRL_FNSEL_NOT_B << 16)        /**< Shifted mode NOT_B for PRS_ASYNC_CH_CTRL    */
#define PRS_ASYNC_CH_CTRL_FNSEL_A_XOR_B                      (_PRS_ASYNC_CH_CTRL_FNSEL_A_XOR_B << 16)      /**< Shifted mode A_XOR_B for PRS_ASYNC_CH_CTRL  */
#define PRS_ASYNC_CH_CTRL_FNSEL_A_NAND_B                     (_PRS_ASYNC_CH_CTRL_FNSEL_A_NAND_B << 16)     /**< Shifted mode A_NAND_B for PRS_ASYNC_CH_CTRL */
#define PRS_ASYNC_CH_CTRL_FNSEL_A_AND_B                      (_PRS_ASYNC_CH_CTRL_FNSEL_A_AND_B << 16)      /**< Shifted mode A_AND_B for PRS_ASYNC_CH_CTRL  */
#define PRS_ASYNC_CH_CTRL_FNSEL_A_XNOR_B                     (_PRS_ASYNC_CH_CTRL_FNSEL_A_XNOR_B << 16)     /**< Shifted mode A_XNOR_B for PRS_ASYNC_CH_CTRL */
#define PRS_ASYNC_CH_CTRL_FNSEL_B                            (_PRS_ASYNC_CH_CTRL_FNSEL_B << 16)            /**< Shifted mode B for PRS_ASYNC_CH_CTRL        */
#define PRS_ASYNC_CH_CTRL_FNSEL_NOT_A_OR_B                   (_PRS_ASYNC_CH_CTRL_FNSEL_NOT_A_OR_B << 16)   /**< Shifted mode NOT_A_OR_B for PRS_ASYNC_CH_CTRL*/
#define PRS_ASYNC_CH_CTRL_FNSEL_A                            (_PRS_ASYNC_CH_CTRL_FNSEL_A << 16)            /**< Shifted mode A for PRS_ASYNC_CH_CTRL        */
#define PRS_ASYNC_CH_CTRL_FNSEL_A_OR_NOT_B                   (_PRS_ASYNC_CH_CTRL_FNSEL_A_OR_NOT_B << 16)   /**< Shifted mode A_OR_NOT_B for PRS_ASYNC_CH_CTRL*/
#define PRS_ASYNC_CH_CTRL_FNSEL_A_OR_B                       (_PRS_ASYNC_CH_CTRL_FNSEL_A_OR_B << 16)       /**< Shifted mode A_OR_B for PRS_ASYNC_CH_CTRL   */
#define PRS_ASYNC_CH_CTRL_FNSEL_LOGICAL_ONE                  (_PRS_ASYNC_CH_CTRL_FNSEL_LOGICAL_ONE << 16)  /**< Shifted mode LOGICAL_ONE for PRS_ASYNC_CH_CTRL*/
#define _PRS_ASYNC_CH_CTRL_AUXSEL_SHIFT                      24                                            /**< Shift value for PRS_AUXSEL                  */
#define _PRS_ASYNC_CH_CTRL_AUXSEL_MASK                       0xF000000UL                                   /**< Bit mask for PRS_AUXSEL                     */
#define _PRS_ASYNC_CH_CTRL_AUXSEL_DEFAULT                    0x00000000UL                                  /**< Mode DEFAULT for PRS_ASYNC_CH_CTRL          */
#define PRS_ASYNC_CH_CTRL_AUXSEL_DEFAULT                     (_PRS_ASYNC_CH_CTRL_AUXSEL_DEFAULT << 24)     /**< Shifted mode DEFAULT for PRS_ASYNC_CH_CTRL  */

/* Bit fields for PRS SYNC_CH_CTRL */
#define _PRS_SYNC_CH_CTRL_RESETVALUE                         0x00000000UL                               /**< Default value for PRS_SYNC_CH_CTRL          */
#define _PRS_SYNC_CH_CTRL_MASK                               0x00007F07UL                               /**< Mask for PRS_SYNC_CH_CTRL                   */
#define _PRS_SYNC_CH_CTRL_SIGSEL_SHIFT                       0                                          /**< Shift value for PRS_SIGSEL                  */
#define _PRS_SYNC_CH_CTRL_SIGSEL_MASK                        0x7UL                                      /**< Bit mask for PRS_SIGSEL                     */
#define _PRS_SYNC_CH_CTRL_SIGSEL_DEFAULT                     0x00000000UL                               /**< Mode DEFAULT for PRS_SYNC_CH_CTRL           */
#define _PRS_SYNC_CH_CTRL_SIGSEL_NONE                        0x00000000UL                               /**< Mode NONE for PRS_SYNC_CH_CTRL              */
#define PRS_SYNC_CH_CTRL_SIGSEL_DEFAULT                      (_PRS_SYNC_CH_CTRL_SIGSEL_DEFAULT << 0)    /**< Shifted mode DEFAULT for PRS_SYNC_CH_CTRL   */
#define PRS_SYNC_CH_CTRL_SIGSEL_NONE                         (_PRS_SYNC_CH_CTRL_SIGSEL_NONE << 0)       /**< Shifted mode NONE for PRS_SYNC_CH_CTRL      */
#define _PRS_SYNC_CH_CTRL_SOURCESEL_SHIFT                    8                                          /**< Shift value for PRS_SOURCESEL               */
#define _PRS_SYNC_CH_CTRL_SOURCESEL_MASK                     0x7F00UL                                   /**< Bit mask for PRS_SOURCESEL                  */
#define _PRS_SYNC_CH_CTRL_SOURCESEL_DEFAULT                  0x00000000UL                               /**< Mode DEFAULT for PRS_SYNC_CH_CTRL           */
#define PRS_SYNC_CH_CTRL_SOURCESEL_DEFAULT                   (_PRS_SYNC_CH_CTRL_SOURCESEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_SYNC_CH_CTRL   */

/* Bit fields for PRS CONSUMER_EUSART0_CLK */
#define _PRS_CONSUMER_EUSART0_CLK_RESETVALUE                 0x00000000UL                                    /**< Default value for PRS_CONSUMER_EUSART0_CLK  */
#define _PRS_CONSUMER_EUSART0_CLK_MASK                       0x0000000FUL                                    /**< Mask for PRS_CONSUMER_EUSART0_CLK           */
#define _PRS_CONSUMER_EUSART0_CLK_PRSSEL_SHIFT               0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_EUSART0_CLK_PRSSEL_MASK                0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_EUSART0_CLK_PRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_EUSART0_CLK   */
#define PRS_CONSUMER_EUSART0_CLK_PRSSEL_DEFAULT              (_PRS_CONSUMER_EUSART0_CLK_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_EUSART0_CLK*/

/* Bit fields for PRS CONSUMER_EUSART0_RX */
#define _PRS_CONSUMER_EUSART0_RX_RESETVALUE                  0x00000000UL                                   /**< Default value for PRS_CONSUMER_EUSART0_RX   */
#define _PRS_CONSUMER_EUSART0_RX_MASK                        0x0000000FUL                                   /**< Mask for PRS_CONSUMER_EUSART0_RX            */
#define _PRS_CONSUMER_EUSART0_RX_PRSSEL_SHIFT                0                                              /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_EUSART0_RX_PRSSEL_MASK                 0xFUL                                          /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_EUSART0_RX_PRSSEL_DEFAULT              0x00000000UL                                   /**< Mode DEFAULT for PRS_CONSUMER_EUSART0_RX    */
#define PRS_CONSUMER_EUSART0_RX_PRSSEL_DEFAULT               (_PRS_CONSUMER_EUSART0_RX_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_EUSART0_RX*/

/* Bit fields for PRS CONSUMER_EUSART0_TRIGGER */
#define _PRS_CONSUMER_EUSART0_TRIGGER_RESETVALUE             0x00000000UL                                        /**< Default value for PRS_CONSUMER_EUSART0_TRIGGER*/
#define _PRS_CONSUMER_EUSART0_TRIGGER_MASK                   0x0000000FUL                                        /**< Mask for PRS_CONSUMER_EUSART0_TRIGGER       */
#define _PRS_CONSUMER_EUSART0_TRIGGER_PRSSEL_SHIFT           0                                                   /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_EUSART0_TRIGGER_PRSSEL_MASK            0xFUL                                               /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_EUSART0_TRIGGER_PRSSEL_DEFAULT         0x00000000UL                                        /**< Mode DEFAULT for PRS_CONSUMER_EUSART0_TRIGGER*/
#define PRS_CONSUMER_EUSART0_TRIGGER_PRSSEL_DEFAULT          (_PRS_CONSUMER_EUSART0_TRIGGER_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_EUSART0_TRIGGER*/

/* Bit fields for PRS CONSUMER_EUSART1_CLK */
#define _PRS_CONSUMER_EUSART1_CLK_RESETVALUE                 0x00000000UL                                    /**< Default value for PRS_CONSUMER_EUSART1_CLK  */
#define _PRS_CONSUMER_EUSART1_CLK_MASK                       0x0000000FUL                                    /**< Mask for PRS_CONSUMER_EUSART1_CLK           */
#define _PRS_CONSUMER_EUSART1_CLK_PRSSEL_SHIFT               0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_EUSART1_CLK_PRSSEL_MASK                0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_EUSART1_CLK_PRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_EUSART1_CLK   */
#define PRS_CONSUMER_EUSART1_CLK_PRSSEL_DEFAULT              (_PRS_CONSUMER_EUSART1_CLK_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_EUSART1_CLK*/

/* Bit fields for PRS CONSUMER_EUSART1_RX */
#define _PRS_CONSUMER_EUSART1_RX_RESETVALUE                  0x00000000UL                                   /**< Default value for PRS_CONSUMER_EUSART1_RX   */
#define _PRS_CONSUMER_EUSART1_RX_MASK                        0x0000000FUL                                   /**< Mask for PRS_CONSUMER_EUSART1_RX            */
#define _PRS_CONSUMER_EUSART1_RX_PRSSEL_SHIFT                0                                              /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_EUSART1_RX_PRSSEL_MASK                 0xFUL                                          /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_EUSART1_RX_PRSSEL_DEFAULT              0x00000000UL                                   /**< Mode DEFAULT for PRS_CONSUMER_EUSART1_RX    */
#define PRS_CONSUMER_EUSART1_RX_PRSSEL_DEFAULT               (_PRS_CONSUMER_EUSART1_RX_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_EUSART1_RX*/

/* Bit fields for PRS CONSUMER_EUSART1_TRIGGER */
#define _PRS_CONSUMER_EUSART1_TRIGGER_RESETVALUE             0x00000000UL                                        /**< Default value for PRS_CONSUMER_EUSART1_TRIGGER*/
#define _PRS_CONSUMER_EUSART1_TRIGGER_MASK                   0x0000000FUL                                        /**< Mask for PRS_CONSUMER_EUSART1_TRIGGER       */
#define _PRS_CONSUMER_EUSART1_TRIGGER_PRSSEL_SHIFT           0                                                   /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_EUSART1_TRIGGER_PRSSEL_MASK            0xFUL                                               /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_EUSART1_TRIGGER_PRSSEL_DEFAULT         0x00000000UL                                        /**< Mode DEFAULT for PRS_CONSUMER_EUSART1_TRIGGER*/
#define PRS_CONSUMER_EUSART1_TRIGGER_PRSSEL_DEFAULT          (_PRS_CONSUMER_EUSART1_TRIGGER_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_EUSART1_TRIGGER*/

/* Bit fields for PRS CONSUMER_EUSART2_CLK */
#define _PRS_CONSUMER_EUSART2_CLK_RESETVALUE                 0x00000000UL                                    /**< Default value for PRS_CONSUMER_EUSART2_CLK  */
#define _PRS_CONSUMER_EUSART2_CLK_MASK                       0x0000000FUL                                    /**< Mask for PRS_CONSUMER_EUSART2_CLK           */
#define _PRS_CONSUMER_EUSART2_CLK_PRSSEL_SHIFT               0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_EUSART2_CLK_PRSSEL_MASK                0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_EUSART2_CLK_PRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_EUSART2_CLK   */
#define PRS_CONSUMER_EUSART2_CLK_PRSSEL_DEFAULT              (_PRS_CONSUMER_EUSART2_CLK_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_EUSART2_CLK*/

/* Bit fields for PRS CONSUMER_EUSART2_RX */
#define _PRS_CONSUMER_EUSART2_RX_RESETVALUE                  0x00000000UL                                   /**< Default value for PRS_CONSUMER_EUSART2_RX   */
#define _PRS_CONSUMER_EUSART2_RX_MASK                        0x0000000FUL                                   /**< Mask for PRS_CONSUMER_EUSART2_RX            */
#define _PRS_CONSUMER_EUSART2_RX_PRSSEL_SHIFT                0                                              /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_EUSART2_RX_PRSSEL_MASK                 0xFUL                                          /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_EUSART2_RX_PRSSEL_DEFAULT              0x00000000UL                                   /**< Mode DEFAULT for PRS_CONSUMER_EUSART2_RX    */
#define PRS_CONSUMER_EUSART2_RX_PRSSEL_DEFAULT               (_PRS_CONSUMER_EUSART2_RX_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_EUSART2_RX*/

/* Bit fields for PRS CONSUMER_EUSART2_TRIGGER */
#define _PRS_CONSUMER_EUSART2_TRIGGER_RESETVALUE             0x00000000UL                                        /**< Default value for PRS_CONSUMER_EUSART2_TRIGGER*/
#define _PRS_CONSUMER_EUSART2_TRIGGER_MASK                   0x0000000FUL                                        /**< Mask for PRS_CONSUMER_EUSART2_TRIGGER       */
#define _PRS_CONSUMER_EUSART2_TRIGGER_PRSSEL_SHIFT           0                                                   /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_EUSART2_TRIGGER_PRSSEL_MASK            0xFUL                                               /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_EUSART2_TRIGGER_PRSSEL_DEFAULT         0x00000000UL                                        /**< Mode DEFAULT for PRS_CONSUMER_EUSART2_TRIGGER*/
#define PRS_CONSUMER_EUSART2_TRIGGER_PRSSEL_DEFAULT          (_PRS_CONSUMER_EUSART2_TRIGGER_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_EUSART2_TRIGGER*/

/* Bit fields for PRS CONSUMER_FRC_RXRAW */
#define _PRS_CONSUMER_FRC_RXRAW_RESETVALUE                   0x00000000UL                                  /**< Default value for PRS_CONSUMER_FRC_RXRAW    */
#define _PRS_CONSUMER_FRC_RXRAW_MASK                         0x0000000FUL                                  /**< Mask for PRS_CONSUMER_FRC_RXRAW             */
#define _PRS_CONSUMER_FRC_RXRAW_PRSSEL_SHIFT                 0                                             /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_FRC_RXRAW_PRSSEL_MASK                  0xFUL                                         /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_FRC_RXRAW_PRSSEL_DEFAULT               0x00000000UL                                  /**< Mode DEFAULT for PRS_CONSUMER_FRC_RXRAW     */
#define PRS_CONSUMER_FRC_RXRAW_PRSSEL_DEFAULT                (_PRS_CONSUMER_FRC_RXRAW_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_FRC_RXRAW*/

/* Bit fields for PRS CONSUMER_CMU_CALDN */
#define _PRS_CONSUMER_CMU_CALDN_RESETVALUE                   0x00000000UL                                  /**< Default value for PRS_CONSUMER_CMU_CALDN    */
#define _PRS_CONSUMER_CMU_CALDN_MASK                         0x0000000FUL                                  /**< Mask for PRS_CONSUMER_CMU_CALDN             */
#define _PRS_CONSUMER_CMU_CALDN_PRSSEL_SHIFT                 0                                             /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_CMU_CALDN_PRSSEL_MASK                  0xFUL                                         /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_CMU_CALDN_PRSSEL_DEFAULT               0x00000000UL                                  /**< Mode DEFAULT for PRS_CONSUMER_CMU_CALDN     */
#define PRS_CONSUMER_CMU_CALDN_PRSSEL_DEFAULT                (_PRS_CONSUMER_CMU_CALDN_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_CMU_CALDN*/

/* Bit fields for PRS CONSUMER_CMU_CALUP */
#define _PRS_CONSUMER_CMU_CALUP_RESETVALUE                   0x00000000UL                                  /**< Default value for PRS_CONSUMER_CMU_CALUP    */
#define _PRS_CONSUMER_CMU_CALUP_MASK                         0x0000000FUL                                  /**< Mask for PRS_CONSUMER_CMU_CALUP             */
#define _PRS_CONSUMER_CMU_CALUP_PRSSEL_SHIFT                 0                                             /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_CMU_CALUP_PRSSEL_MASK                  0xFUL                                         /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_CMU_CALUP_PRSSEL_DEFAULT               0x00000000UL                                  /**< Mode DEFAULT for PRS_CONSUMER_CMU_CALUP     */
#define PRS_CONSUMER_CMU_CALUP_PRSSEL_DEFAULT                (_PRS_CONSUMER_CMU_CALUP_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_CMU_CALUP*/

/* Bit fields for PRS CONSUMER_LDMAXBAR0_DMAREQ0 */
#define _PRS_CONSUMER_LDMAXBAR0_DMAREQ0_RESETVALUE           0x00000000UL                                          /**< Default value for PRS_CONSUMER_LDMAXBAR0_DMAREQ0*/
#define _PRS_CONSUMER_LDMAXBAR0_DMAREQ0_MASK                 0x0000000FUL                                          /**< Mask for PRS_CONSUMER_LDMAXBAR0_DMAREQ0     */
#define _PRS_CONSUMER_LDMAXBAR0_DMAREQ0_PRSSEL_SHIFT         0                                                     /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_LDMAXBAR0_DMAREQ0_PRSSEL_MASK          0xFUL                                                 /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_LDMAXBAR0_DMAREQ0_PRSSEL_DEFAULT       0x00000000UL                                          /**< Mode DEFAULT for PRS_CONSUMER_LDMAXBAR0_DMAREQ0*/
#define PRS_CONSUMER_LDMAXBAR0_DMAREQ0_PRSSEL_DEFAULT        (_PRS_CONSUMER_LDMAXBAR0_DMAREQ0_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_LDMAXBAR0_DMAREQ0*/

/* Bit fields for PRS CONSUMER_LDMAXBAR0_DMAREQ1 */
#define _PRS_CONSUMER_LDMAXBAR0_DMAREQ1_RESETVALUE           0x00000000UL                                          /**< Default value for PRS_CONSUMER_LDMAXBAR0_DMAREQ1*/
#define _PRS_CONSUMER_LDMAXBAR0_DMAREQ1_MASK                 0x0000000FUL                                          /**< Mask for PRS_CONSUMER_LDMAXBAR0_DMAREQ1     */
#define _PRS_CONSUMER_LDMAXBAR0_DMAREQ1_PRSSEL_SHIFT         0                                                     /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_LDMAXBAR0_DMAREQ1_PRSSEL_MASK          0xFUL                                                 /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_LDMAXBAR0_DMAREQ1_PRSSEL_DEFAULT       0x00000000UL                                          /**< Mode DEFAULT for PRS_CONSUMER_LDMAXBAR0_DMAREQ1*/
#define PRS_CONSUMER_LDMAXBAR0_DMAREQ1_PRSSEL_DEFAULT        (_PRS_CONSUMER_LDMAXBAR0_DMAREQ1_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_LDMAXBAR0_DMAREQ1*/

/* Bit fields for PRS CONSUMER_LEDDRV0_LEDDRV0ASYNC */
#define _PRS_CONSUMER_LEDDRV0_LEDDRV0ASYNC_RESETVALUE        0x00000000UL                                             /**< Default value for PRS_CONSUMER_LEDDRV0_LEDDRV0ASYNC*/
#define _PRS_CONSUMER_LEDDRV0_LEDDRV0ASYNC_MASK              0x0000000FUL                                             /**< Mask for PRS_CONSUMER_LEDDRV0_LEDDRV0ASYNC  */
#define _PRS_CONSUMER_LEDDRV0_LEDDRV0ASYNC_PRSSEL_SHIFT      0                                                        /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_LEDDRV0_LEDDRV0ASYNC_PRSSEL_MASK       0xFUL                                                    /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_LEDDRV0_LEDDRV0ASYNC_PRSSEL_DEFAULT    0x00000000UL                                             /**< Mode DEFAULT for PRS_CONSUMER_LEDDRV0_LEDDRV0ASYNC*/
#define PRS_CONSUMER_LEDDRV0_LEDDRV0ASYNC_PRSSEL_DEFAULT     (_PRS_CONSUMER_LEDDRV0_LEDDRV0ASYNC_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_LEDDRV0_LEDDRV0ASYNC*/

/* Bit fields for PRS CONSUMER_LEDDRV0_LEDDRV1ASYNC */
#define _PRS_CONSUMER_LEDDRV0_LEDDRV1ASYNC_RESETVALUE        0x00000000UL                                             /**< Default value for PRS_CONSUMER_LEDDRV0_LEDDRV1ASYNC*/
#define _PRS_CONSUMER_LEDDRV0_LEDDRV1ASYNC_MASK              0x0000000FUL                                             /**< Mask for PRS_CONSUMER_LEDDRV0_LEDDRV1ASYNC  */
#define _PRS_CONSUMER_LEDDRV0_LEDDRV1ASYNC_PRSSEL_SHIFT      0                                                        /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_LEDDRV0_LEDDRV1ASYNC_PRSSEL_MASK       0xFUL                                                    /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_LEDDRV0_LEDDRV1ASYNC_PRSSEL_DEFAULT    0x00000000UL                                             /**< Mode DEFAULT for PRS_CONSUMER_LEDDRV0_LEDDRV1ASYNC*/
#define PRS_CONSUMER_LEDDRV0_LEDDRV1ASYNC_PRSSEL_DEFAULT     (_PRS_CONSUMER_LEDDRV0_LEDDRV1ASYNC_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_LEDDRV0_LEDDRV1ASYNC*/

/* Bit fields for PRS CONSUMER_LETIMER0_CLEAR */
#define _PRS_CONSUMER_LETIMER0_CLEAR_RESETVALUE              0x00000000UL                                       /**< Default value for PRS_CONSUMER_LETIMER0_CLEAR*/
#define _PRS_CONSUMER_LETIMER0_CLEAR_MASK                    0x0000000FUL                                       /**< Mask for PRS_CONSUMER_LETIMER0_CLEAR        */
#define _PRS_CONSUMER_LETIMER0_CLEAR_PRSSEL_SHIFT            0                                                  /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_LETIMER0_CLEAR_PRSSEL_MASK             0xFUL                                              /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_LETIMER0_CLEAR_PRSSEL_DEFAULT          0x00000000UL                                       /**< Mode DEFAULT for PRS_CONSUMER_LETIMER0_CLEAR*/
#define PRS_CONSUMER_LETIMER0_CLEAR_PRSSEL_DEFAULT           (_PRS_CONSUMER_LETIMER0_CLEAR_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_LETIMER0_CLEAR*/

/* Bit fields for PRS CONSUMER_LETIMER0_START */
#define _PRS_CONSUMER_LETIMER0_START_RESETVALUE              0x00000000UL                                       /**< Default value for PRS_CONSUMER_LETIMER0_START*/
#define _PRS_CONSUMER_LETIMER0_START_MASK                    0x0000000FUL                                       /**< Mask for PRS_CONSUMER_LETIMER0_START        */
#define _PRS_CONSUMER_LETIMER0_START_PRSSEL_SHIFT            0                                                  /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_LETIMER0_START_PRSSEL_MASK             0xFUL                                              /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_LETIMER0_START_PRSSEL_DEFAULT          0x00000000UL                                       /**< Mode DEFAULT for PRS_CONSUMER_LETIMER0_START*/
#define PRS_CONSUMER_LETIMER0_START_PRSSEL_DEFAULT           (_PRS_CONSUMER_LETIMER0_START_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_LETIMER0_START*/

/* Bit fields for PRS CONSUMER_LETIMER0_STOP */
#define _PRS_CONSUMER_LETIMER0_STOP_RESETVALUE               0x00000000UL                                      /**< Default value for PRS_CONSUMER_LETIMER0_STOP*/
#define _PRS_CONSUMER_LETIMER0_STOP_MASK                     0x0000000FUL                                      /**< Mask for PRS_CONSUMER_LETIMER0_STOP         */
#define _PRS_CONSUMER_LETIMER0_STOP_PRSSEL_SHIFT             0                                                 /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_LETIMER0_STOP_PRSSEL_MASK              0xFUL                                             /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_LETIMER0_STOP_PRSSEL_DEFAULT           0x00000000UL                                      /**< Mode DEFAULT for PRS_CONSUMER_LETIMER0_STOP */
#define PRS_CONSUMER_LETIMER0_STOP_PRSSEL_DEFAULT            (_PRS_CONSUMER_LETIMER0_STOP_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_LETIMER0_STOP*/

/* Bit fields for PRS CONSUMER_MODEM_DIN */
#define _PRS_CONSUMER_MODEM_DIN_RESETVALUE                   0x00000000UL                                  /**< Default value for PRS_CONSUMER_MODEM_DIN    */
#define _PRS_CONSUMER_MODEM_DIN_MASK                         0x0000000FUL                                  /**< Mask for PRS_CONSUMER_MODEM_DIN             */
#define _PRS_CONSUMER_MODEM_DIN_PRSSEL_SHIFT                 0                                             /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_MODEM_DIN_PRSSEL_MASK                  0xFUL                                         /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_MODEM_DIN_PRSSEL_DEFAULT               0x00000000UL                                  /**< Mode DEFAULT for PRS_CONSUMER_MODEM_DIN     */
#define PRS_CONSUMER_MODEM_DIN_PRSSEL_DEFAULT                (_PRS_CONSUMER_MODEM_DIN_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_MODEM_DIN*/

/* Bit fields for PRS CONSUMER_MODEM_PAEN */
#define _PRS_CONSUMER_MODEM_PAEN_RESETVALUE                  0x00000000UL                                   /**< Default value for PRS_CONSUMER_MODEM_PAEN   */
#define _PRS_CONSUMER_MODEM_PAEN_MASK                        0x0000000FUL                                   /**< Mask for PRS_CONSUMER_MODEM_PAEN            */
#define _PRS_CONSUMER_MODEM_PAEN_PRSSEL_SHIFT                0                                              /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_MODEM_PAEN_PRSSEL_MASK                 0xFUL                                          /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_MODEM_PAEN_PRSSEL_DEFAULT              0x00000000UL                                   /**< Mode DEFAULT for PRS_CONSUMER_MODEM_PAEN    */
#define PRS_CONSUMER_MODEM_PAEN_PRSSEL_DEFAULT               (_PRS_CONSUMER_MODEM_PAEN_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_MODEM_PAEN*/

/* Bit fields for PRS CONSUMER_PCNT0_S0IN */
#define _PRS_CONSUMER_PCNT0_S0IN_RESETVALUE                  0x00000000UL                                   /**< Default value for PRS_CONSUMER_PCNT0_S0IN   */
#define _PRS_CONSUMER_PCNT0_S0IN_MASK                        0x0000000FUL                                   /**< Mask for PRS_CONSUMER_PCNT0_S0IN            */
#define _PRS_CONSUMER_PCNT0_S0IN_PRSSEL_SHIFT                0                                              /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_PCNT0_S0IN_PRSSEL_MASK                 0xFUL                                          /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_PCNT0_S0IN_PRSSEL_DEFAULT              0x00000000UL                                   /**< Mode DEFAULT for PRS_CONSUMER_PCNT0_S0IN    */
#define PRS_CONSUMER_PCNT0_S0IN_PRSSEL_DEFAULT               (_PRS_CONSUMER_PCNT0_S0IN_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_PCNT0_S0IN*/

/* Bit fields for PRS CONSUMER_PCNT0_S1IN */
#define _PRS_CONSUMER_PCNT0_S1IN_RESETVALUE                  0x00000000UL                                   /**< Default value for PRS_CONSUMER_PCNT0_S1IN   */
#define _PRS_CONSUMER_PCNT0_S1IN_MASK                        0x0000000FUL                                   /**< Mask for PRS_CONSUMER_PCNT0_S1IN            */
#define _PRS_CONSUMER_PCNT0_S1IN_PRSSEL_SHIFT                0                                              /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_PCNT0_S1IN_PRSSEL_MASK                 0xFUL                                          /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_PCNT0_S1IN_PRSSEL_DEFAULT              0x00000000UL                                   /**< Mode DEFAULT for PRS_CONSUMER_PCNT0_S1IN    */
#define PRS_CONSUMER_PCNT0_S1IN_PRSSEL_DEFAULT               (_PRS_CONSUMER_PCNT0_S1IN_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_PCNT0_S1IN*/

/* Bit fields for PRS CONSUMER_PIXELRZ0_INASYNC */
#define _PRS_CONSUMER_PIXELRZ0_INASYNC_RESETVALUE            0x00000000UL                                         /**< Default value for PRS_CONSUMER_PIXELRZ0_INASYNC*/
#define _PRS_CONSUMER_PIXELRZ0_INASYNC_MASK                  0x0000000FUL                                         /**< Mask for PRS_CONSUMER_PIXELRZ0_INASYNC      */
#define _PRS_CONSUMER_PIXELRZ0_INASYNC_PRSSEL_SHIFT          0                                                    /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_PIXELRZ0_INASYNC_PRSSEL_MASK           0xFUL                                                /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_PIXELRZ0_INASYNC_PRSSEL_DEFAULT        0x00000000UL                                         /**< Mode DEFAULT for PRS_CONSUMER_PIXELRZ0_INASYNC*/
#define PRS_CONSUMER_PIXELRZ0_INASYNC_PRSSEL_DEFAULT         (_PRS_CONSUMER_PIXELRZ0_INASYNC_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_PIXELRZ0_INASYNC*/

/* Bit fields for PRS CONSUMER_PIXELRZ1_INASYNC */
#define _PRS_CONSUMER_PIXELRZ1_INASYNC_RESETVALUE            0x00000000UL                                         /**< Default value for PRS_CONSUMER_PIXELRZ1_INASYNC*/
#define _PRS_CONSUMER_PIXELRZ1_INASYNC_MASK                  0x0000000FUL                                         /**< Mask for PRS_CONSUMER_PIXELRZ1_INASYNC      */
#define _PRS_CONSUMER_PIXELRZ1_INASYNC_PRSSEL_SHIFT          0                                                    /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_PIXELRZ1_INASYNC_PRSSEL_MASK           0xFUL                                                /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_PIXELRZ1_INASYNC_PRSSEL_DEFAULT        0x00000000UL                                         /**< Mode DEFAULT for PRS_CONSUMER_PIXELRZ1_INASYNC*/
#define PRS_CONSUMER_PIXELRZ1_INASYNC_PRSSEL_DEFAULT         (_PRS_CONSUMER_PIXELRZ1_INASYNC_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_PIXELRZ1_INASYNC*/

/* Bit fields for PRS CONSUMER_RAC_CLR */
#define _PRS_CONSUMER_RAC_CLR_RESETVALUE                     0x00000000UL                                /**< Default value for PRS_CONSUMER_RAC_CLR      */
#define _PRS_CONSUMER_RAC_CLR_MASK                           0x0000000FUL                                /**< Mask for PRS_CONSUMER_RAC_CLR               */
#define _PRS_CONSUMER_RAC_CLR_PRSSEL_SHIFT                   0                                           /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_RAC_CLR_PRSSEL_MASK                    0xFUL                                       /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_RAC_CLR_PRSSEL_DEFAULT                 0x00000000UL                                /**< Mode DEFAULT for PRS_CONSUMER_RAC_CLR       */
#define PRS_CONSUMER_RAC_CLR_PRSSEL_DEFAULT                  (_PRS_CONSUMER_RAC_CLR_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_RAC_CLR*/

/* Bit fields for PRS CONSUMER_RAC_CTIIN0 */
#define _PRS_CONSUMER_RAC_CTIIN0_RESETVALUE                  0x00000000UL                                   /**< Default value for PRS_CONSUMER_RAC_CTIIN0   */
#define _PRS_CONSUMER_RAC_CTIIN0_MASK                        0x0000000FUL                                   /**< Mask for PRS_CONSUMER_RAC_CTIIN0            */
#define _PRS_CONSUMER_RAC_CTIIN0_PRSSEL_SHIFT                0                                              /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_RAC_CTIIN0_PRSSEL_MASK                 0xFUL                                          /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_RAC_CTIIN0_PRSSEL_DEFAULT              0x00000000UL                                   /**< Mode DEFAULT for PRS_CONSUMER_RAC_CTIIN0    */
#define PRS_CONSUMER_RAC_CTIIN0_PRSSEL_DEFAULT               (_PRS_CONSUMER_RAC_CTIIN0_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_RAC_CTIIN0*/

/* Bit fields for PRS CONSUMER_RAC_CTIIN1 */
#define _PRS_CONSUMER_RAC_CTIIN1_RESETVALUE                  0x00000000UL                                   /**< Default value for PRS_CONSUMER_RAC_CTIIN1   */
#define _PRS_CONSUMER_RAC_CTIIN1_MASK                        0x0000000FUL                                   /**< Mask for PRS_CONSUMER_RAC_CTIIN1            */
#define _PRS_CONSUMER_RAC_CTIIN1_PRSSEL_SHIFT                0                                              /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_RAC_CTIIN1_PRSSEL_MASK                 0xFUL                                          /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_RAC_CTIIN1_PRSSEL_DEFAULT              0x00000000UL                                   /**< Mode DEFAULT for PRS_CONSUMER_RAC_CTIIN1    */
#define PRS_CONSUMER_RAC_CTIIN1_PRSSEL_DEFAULT               (_PRS_CONSUMER_RAC_CTIIN1_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_RAC_CTIIN1*/

/* Bit fields for PRS CONSUMER_RAC_CTIIN2 */
#define _PRS_CONSUMER_RAC_CTIIN2_RESETVALUE                  0x00000000UL                                   /**< Default value for PRS_CONSUMER_RAC_CTIIN2   */
#define _PRS_CONSUMER_RAC_CTIIN2_MASK                        0x0000000FUL                                   /**< Mask for PRS_CONSUMER_RAC_CTIIN2            */
#define _PRS_CONSUMER_RAC_CTIIN2_PRSSEL_SHIFT                0                                              /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_RAC_CTIIN2_PRSSEL_MASK                 0xFUL                                          /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_RAC_CTIIN2_PRSSEL_DEFAULT              0x00000000UL                                   /**< Mode DEFAULT for PRS_CONSUMER_RAC_CTIIN2    */
#define PRS_CONSUMER_RAC_CTIIN2_PRSSEL_DEFAULT               (_PRS_CONSUMER_RAC_CTIIN2_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_RAC_CTIIN2*/

/* Bit fields for PRS CONSUMER_RAC_CTIIN3 */
#define _PRS_CONSUMER_RAC_CTIIN3_RESETVALUE                  0x00000000UL                                   /**< Default value for PRS_CONSUMER_RAC_CTIIN3   */
#define _PRS_CONSUMER_RAC_CTIIN3_MASK                        0x0000000FUL                                   /**< Mask for PRS_CONSUMER_RAC_CTIIN3            */
#define _PRS_CONSUMER_RAC_CTIIN3_PRSSEL_SHIFT                0                                              /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_RAC_CTIIN3_PRSSEL_MASK                 0xFUL                                          /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_RAC_CTIIN3_PRSSEL_DEFAULT              0x00000000UL                                   /**< Mode DEFAULT for PRS_CONSUMER_RAC_CTIIN3    */
#define PRS_CONSUMER_RAC_CTIIN3_PRSSEL_DEFAULT               (_PRS_CONSUMER_RAC_CTIIN3_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_RAC_CTIIN3*/

/* Bit fields for PRS CONSUMER_RAC_FORCETX */
#define _PRS_CONSUMER_RAC_FORCETX_RESETVALUE                 0x00000000UL                                    /**< Default value for PRS_CONSUMER_RAC_FORCETX  */
#define _PRS_CONSUMER_RAC_FORCETX_MASK                       0x0000000FUL                                    /**< Mask for PRS_CONSUMER_RAC_FORCETX           */
#define _PRS_CONSUMER_RAC_FORCETX_PRSSEL_SHIFT               0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_RAC_FORCETX_PRSSEL_MASK                0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_RAC_FORCETX_PRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_RAC_FORCETX   */
#define PRS_CONSUMER_RAC_FORCETX_PRSSEL_DEFAULT              (_PRS_CONSUMER_RAC_FORCETX_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_RAC_FORCETX*/

/* Bit fields for PRS CONSUMER_RAC_RXDIS */
#define _PRS_CONSUMER_RAC_RXDIS_RESETVALUE                   0x00000000UL                                  /**< Default value for PRS_CONSUMER_RAC_RXDIS    */
#define _PRS_CONSUMER_RAC_RXDIS_MASK                         0x0000000FUL                                  /**< Mask for PRS_CONSUMER_RAC_RXDIS             */
#define _PRS_CONSUMER_RAC_RXDIS_PRSSEL_SHIFT                 0                                             /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_RAC_RXDIS_PRSSEL_MASK                  0xFUL                                         /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_RAC_RXDIS_PRSSEL_DEFAULT               0x00000000UL                                  /**< Mode DEFAULT for PRS_CONSUMER_RAC_RXDIS     */
#define PRS_CONSUMER_RAC_RXDIS_PRSSEL_DEFAULT                (_PRS_CONSUMER_RAC_RXDIS_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_RAC_RXDIS*/

/* Bit fields for PRS CONSUMER_RAC_RXEN */
#define _PRS_CONSUMER_RAC_RXEN_RESETVALUE                    0x00000000UL                                 /**< Default value for PRS_CONSUMER_RAC_RXEN     */
#define _PRS_CONSUMER_RAC_RXEN_MASK                          0x0000000FUL                                 /**< Mask for PRS_CONSUMER_RAC_RXEN              */
#define _PRS_CONSUMER_RAC_RXEN_PRSSEL_SHIFT                  0                                            /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_RAC_RXEN_PRSSEL_MASK                   0xFUL                                        /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_RAC_RXEN_PRSSEL_DEFAULT                0x00000000UL                                 /**< Mode DEFAULT for PRS_CONSUMER_RAC_RXEN      */
#define PRS_CONSUMER_RAC_RXEN_PRSSEL_DEFAULT                 (_PRS_CONSUMER_RAC_RXEN_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_RAC_RXEN*/

/* Bit fields for PRS CONSUMER_RAC_TXEN */
#define _PRS_CONSUMER_RAC_TXEN_RESETVALUE                    0x00000000UL                                 /**< Default value for PRS_CONSUMER_RAC_TXEN     */
#define _PRS_CONSUMER_RAC_TXEN_MASK                          0x0000000FUL                                 /**< Mask for PRS_CONSUMER_RAC_TXEN              */
#define _PRS_CONSUMER_RAC_TXEN_PRSSEL_SHIFT                  0                                            /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_RAC_TXEN_PRSSEL_MASK                   0xFUL                                        /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_RAC_TXEN_PRSSEL_DEFAULT                0x00000000UL                                 /**< Mode DEFAULT for PRS_CONSUMER_RAC_TXEN      */
#define PRS_CONSUMER_RAC_TXEN_PRSSEL_DEFAULT                 (_PRS_CONSUMER_RAC_TXEN_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_RAC_TXEN*/

/* Bit fields for PRS CONSUMER_RFTIMER_PULSE */
#define _PRS_CONSUMER_RFTIMER_PULSE_RESETVALUE               0x00000000UL                                      /**< Default value for PRS_CONSUMER_RFTIMER_PULSE*/
#define _PRS_CONSUMER_RFTIMER_PULSE_MASK                     0x0000000FUL                                      /**< Mask for PRS_CONSUMER_RFTIMER_PULSE         */
#define _PRS_CONSUMER_RFTIMER_PULSE_PRSSEL_SHIFT             0                                                 /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_RFTIMER_PULSE_PRSSEL_MASK              0xFUL                                             /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_RFTIMER_PULSE_PRSSEL_DEFAULT           0x00000000UL                                      /**< Mode DEFAULT for PRS_CONSUMER_RFTIMER_PULSE */
#define PRS_CONSUMER_RFTIMER_PULSE_PRSSEL_DEFAULT            (_PRS_CONSUMER_RFTIMER_PULSE_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_RFTIMER_PULSE*/

/* Bit fields for PRS CONSUMER_ADC0_ASYNCSEQ */
#define _PRS_CONSUMER_ADC0_ASYNCSEQ_RESETVALUE               0x00000000UL                                      /**< Default value for PRS_CONSUMER_ADC0_ASYNCSEQ*/
#define _PRS_CONSUMER_ADC0_ASYNCSEQ_MASK                     0x0000000FUL                                      /**< Mask for PRS_CONSUMER_ADC0_ASYNCSEQ         */
#define _PRS_CONSUMER_ADC0_ASYNCSEQ_PRSSEL_SHIFT             0                                                 /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_ADC0_ASYNCSEQ_PRSSEL_MASK              0xFUL                                             /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_ADC0_ASYNCSEQ_PRSSEL_DEFAULT           0x00000000UL                                      /**< Mode DEFAULT for PRS_CONSUMER_ADC0_ASYNCSEQ */
#define PRS_CONSUMER_ADC0_ASYNCSEQ_PRSSEL_DEFAULT            (_PRS_CONSUMER_ADC0_ASYNCSEQ_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_ADC0_ASYNCSEQ*/

/* Bit fields for PRS CONSUMER_ADC0_SYNCSEQ */
#define _PRS_CONSUMER_ADC0_SYNCSEQ_RESETVALUE                0x00000000UL                                      /**< Default value for PRS_CONSUMER_ADC0_SYNCSEQ */
#define _PRS_CONSUMER_ADC0_SYNCSEQ_MASK                      0x00000300UL                                      /**< Mask for PRS_CONSUMER_ADC0_SYNCSEQ          */
#define _PRS_CONSUMER_ADC0_SYNCSEQ_SPRSSEL_SHIFT             8                                                 /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_ADC0_SYNCSEQ_SPRSSEL_MASK              0x300UL                                           /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_ADC0_SYNCSEQ_SPRSSEL_DEFAULT           0x00000000UL                                      /**< Mode DEFAULT for PRS_CONSUMER_ADC0_SYNCSEQ  */
#define PRS_CONSUMER_ADC0_SYNCSEQ_SPRSSEL_DEFAULT            (_PRS_CONSUMER_ADC0_SYNCSEQ_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_ADC0_SYNCSEQ*/

/* Bit fields for PRS CONSUMER_SEQACC_WAIT0 */
#define _PRS_CONSUMER_SEQACC_WAIT0_RESETVALUE                0x00000000UL                                     /**< Default value for PRS_CONSUMER_SEQACC_WAIT0 */
#define _PRS_CONSUMER_SEQACC_WAIT0_MASK                      0x0000000FUL                                     /**< Mask for PRS_CONSUMER_SEQACC_WAIT0          */
#define _PRS_CONSUMER_SEQACC_WAIT0_PRSSEL_SHIFT              0                                                /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_SEQACC_WAIT0_PRSSEL_MASK               0xFUL                                            /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_SEQACC_WAIT0_PRSSEL_DEFAULT            0x00000000UL                                     /**< Mode DEFAULT for PRS_CONSUMER_SEQACC_WAIT0  */
#define PRS_CONSUMER_SEQACC_WAIT0_PRSSEL_DEFAULT             (_PRS_CONSUMER_SEQACC_WAIT0_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_SEQACC_WAIT0*/

/* Bit fields for PRS CONSUMER_SEQACC_WAIT1 */
#define _PRS_CONSUMER_SEQACC_WAIT1_RESETVALUE                0x00000000UL                                     /**< Default value for PRS_CONSUMER_SEQACC_WAIT1 */
#define _PRS_CONSUMER_SEQACC_WAIT1_MASK                      0x0000000FUL                                     /**< Mask for PRS_CONSUMER_SEQACC_WAIT1          */
#define _PRS_CONSUMER_SEQACC_WAIT1_PRSSEL_SHIFT              0                                                /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_SEQACC_WAIT1_PRSSEL_MASK               0xFUL                                            /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_SEQACC_WAIT1_PRSSEL_DEFAULT            0x00000000UL                                     /**< Mode DEFAULT for PRS_CONSUMER_SEQACC_WAIT1  */
#define PRS_CONSUMER_SEQACC_WAIT1_PRSSEL_DEFAULT             (_PRS_CONSUMER_SEQACC_WAIT1_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_SEQACC_WAIT1*/

/* Bit fields for PRS CONSUMER_SEQACC_WAIT2 */
#define _PRS_CONSUMER_SEQACC_WAIT2_RESETVALUE                0x00000000UL                                     /**< Default value for PRS_CONSUMER_SEQACC_WAIT2 */
#define _PRS_CONSUMER_SEQACC_WAIT2_MASK                      0x0000000FUL                                     /**< Mask for PRS_CONSUMER_SEQACC_WAIT2          */
#define _PRS_CONSUMER_SEQACC_WAIT2_PRSSEL_SHIFT              0                                                /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_SEQACC_WAIT2_PRSSEL_MASK               0xFUL                                            /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_SEQACC_WAIT2_PRSSEL_DEFAULT            0x00000000UL                                     /**< Mode DEFAULT for PRS_CONSUMER_SEQACC_WAIT2  */
#define PRS_CONSUMER_SEQACC_WAIT2_PRSSEL_DEFAULT             (_PRS_CONSUMER_SEQACC_WAIT2_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_SEQACC_WAIT2*/

/* Bit fields for PRS CONSUMER_SEQACC_WAIT3 */
#define _PRS_CONSUMER_SEQACC_WAIT3_RESETVALUE                0x00000000UL                                     /**< Default value for PRS_CONSUMER_SEQACC_WAIT3 */
#define _PRS_CONSUMER_SEQACC_WAIT3_MASK                      0x0000000FUL                                     /**< Mask for PRS_CONSUMER_SEQACC_WAIT3          */
#define _PRS_CONSUMER_SEQACC_WAIT3_PRSSEL_SHIFT              0                                                /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_SEQACC_WAIT3_PRSSEL_MASK               0xFUL                                            /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_SEQACC_WAIT3_PRSSEL_DEFAULT            0x00000000UL                                     /**< Mode DEFAULT for PRS_CONSUMER_SEQACC_WAIT3  */
#define PRS_CONSUMER_SEQACC_WAIT3_PRSSEL_DEFAULT             (_PRS_CONSUMER_SEQACC_WAIT3_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_SEQACC_WAIT3*/

/* Bit fields for PRS CONSUMER_SETAMPER_TAMPERSRC29 */
#define _PRS_CONSUMER_SETAMPER_TAMPERSRC29_RESETVALUE        0x00000000UL                                             /**< Default value for PRS_CONSUMER_SETAMPER_TAMPERSRC29*/
#define _PRS_CONSUMER_SETAMPER_TAMPERSRC29_MASK              0x0000000FUL                                             /**< Mask for PRS_CONSUMER_SETAMPER_TAMPERSRC29  */
#define _PRS_CONSUMER_SETAMPER_TAMPERSRC29_PRSSEL_SHIFT      0                                                        /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_SETAMPER_TAMPERSRC29_PRSSEL_MASK       0xFUL                                                    /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_SETAMPER_TAMPERSRC29_PRSSEL_DEFAULT    0x00000000UL                                             /**< Mode DEFAULT for PRS_CONSUMER_SETAMPER_TAMPERSRC29*/
#define PRS_CONSUMER_SETAMPER_TAMPERSRC29_PRSSEL_DEFAULT     (_PRS_CONSUMER_SETAMPER_TAMPERSRC29_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_SETAMPER_TAMPERSRC29*/

/* Bit fields for PRS CONSUMER_SETAMPER_TAMPERSRC30 */
#define _PRS_CONSUMER_SETAMPER_TAMPERSRC30_RESETVALUE        0x00000000UL                                             /**< Default value for PRS_CONSUMER_SETAMPER_TAMPERSRC30*/
#define _PRS_CONSUMER_SETAMPER_TAMPERSRC30_MASK              0x0000000FUL                                             /**< Mask for PRS_CONSUMER_SETAMPER_TAMPERSRC30  */
#define _PRS_CONSUMER_SETAMPER_TAMPERSRC30_PRSSEL_SHIFT      0                                                        /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_SETAMPER_TAMPERSRC30_PRSSEL_MASK       0xFUL                                                    /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_SETAMPER_TAMPERSRC30_PRSSEL_DEFAULT    0x00000000UL                                             /**< Mode DEFAULT for PRS_CONSUMER_SETAMPER_TAMPERSRC30*/
#define PRS_CONSUMER_SETAMPER_TAMPERSRC30_PRSSEL_DEFAULT     (_PRS_CONSUMER_SETAMPER_TAMPERSRC30_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_SETAMPER_TAMPERSRC30*/

/* Bit fields for PRS CONSUMER_SETAMPER_TAMPERSRC31 */
#define _PRS_CONSUMER_SETAMPER_TAMPERSRC31_RESETVALUE        0x00000000UL                                             /**< Default value for PRS_CONSUMER_SETAMPER_TAMPERSRC31*/
#define _PRS_CONSUMER_SETAMPER_TAMPERSRC31_MASK              0x0000000FUL                                             /**< Mask for PRS_CONSUMER_SETAMPER_TAMPERSRC31  */
#define _PRS_CONSUMER_SETAMPER_TAMPERSRC31_PRSSEL_SHIFT      0                                                        /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_SETAMPER_TAMPERSRC31_PRSSEL_MASK       0xFUL                                                    /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_SETAMPER_TAMPERSRC31_PRSSEL_DEFAULT    0x00000000UL                                             /**< Mode DEFAULT for PRS_CONSUMER_SETAMPER_TAMPERSRC31*/
#define PRS_CONSUMER_SETAMPER_TAMPERSRC31_PRSSEL_DEFAULT     (_PRS_CONSUMER_SETAMPER_TAMPERSRC31_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_SETAMPER_TAMPERSRC31*/

/* Bit fields for PRS CONSUMER_SYSRTC0_IN0 */
#define _PRS_CONSUMER_SYSRTC0_IN0_RESETVALUE                 0x00000000UL                                    /**< Default value for PRS_CONSUMER_SYSRTC0_IN0  */
#define _PRS_CONSUMER_SYSRTC0_IN0_MASK                       0x0000000FUL                                    /**< Mask for PRS_CONSUMER_SYSRTC0_IN0           */
#define _PRS_CONSUMER_SYSRTC0_IN0_PRSSEL_SHIFT               0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_SYSRTC0_IN0_PRSSEL_MASK                0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_SYSRTC0_IN0_PRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_SYSRTC0_IN0   */
#define PRS_CONSUMER_SYSRTC0_IN0_PRSSEL_DEFAULT              (_PRS_CONSUMER_SYSRTC0_IN0_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_SYSRTC0_IN0*/

/* Bit fields for PRS CONSUMER_SYSRTC0_IN1 */
#define _PRS_CONSUMER_SYSRTC0_IN1_RESETVALUE                 0x00000000UL                                    /**< Default value for PRS_CONSUMER_SYSRTC0_IN1  */
#define _PRS_CONSUMER_SYSRTC0_IN1_MASK                       0x0000000FUL                                    /**< Mask for PRS_CONSUMER_SYSRTC0_IN1           */
#define _PRS_CONSUMER_SYSRTC0_IN1_PRSSEL_SHIFT               0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_SYSRTC0_IN1_PRSSEL_MASK                0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_SYSRTC0_IN1_PRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_SYSRTC0_IN1   */
#define PRS_CONSUMER_SYSRTC0_IN1_PRSSEL_DEFAULT              (_PRS_CONSUMER_SYSRTC0_IN1_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_SYSRTC0_IN1*/

/* Bit fields for PRS CONSUMER_HFXO0_OSCREQ */
#define _PRS_CONSUMER_HFXO0_OSCREQ_RESETVALUE                0x00000000UL                                     /**< Default value for PRS_CONSUMER_HFXO0_OSCREQ */
#define _PRS_CONSUMER_HFXO0_OSCREQ_MASK                      0x0000000FUL                                     /**< Mask for PRS_CONSUMER_HFXO0_OSCREQ          */
#define _PRS_CONSUMER_HFXO0_OSCREQ_PRSSEL_SHIFT              0                                                /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_HFXO0_OSCREQ_PRSSEL_MASK               0xFUL                                            /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_HFXO0_OSCREQ_PRSSEL_DEFAULT            0x00000000UL                                     /**< Mode DEFAULT for PRS_CONSUMER_HFXO0_OSCREQ  */
#define PRS_CONSUMER_HFXO0_OSCREQ_PRSSEL_DEFAULT             (_PRS_CONSUMER_HFXO0_OSCREQ_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_HFXO0_OSCREQ*/

/* Bit fields for PRS CONSUMER_HFXO0_TIMEOUT */
#define _PRS_CONSUMER_HFXO0_TIMEOUT_RESETVALUE               0x00000000UL                                      /**< Default value for PRS_CONSUMER_HFXO0_TIMEOUT*/
#define _PRS_CONSUMER_HFXO0_TIMEOUT_MASK                     0x0000000FUL                                      /**< Mask for PRS_CONSUMER_HFXO0_TIMEOUT         */
#define _PRS_CONSUMER_HFXO0_TIMEOUT_PRSSEL_SHIFT             0                                                 /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_HFXO0_TIMEOUT_PRSSEL_MASK              0xFUL                                             /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_HFXO0_TIMEOUT_PRSSEL_DEFAULT           0x00000000UL                                      /**< Mode DEFAULT for PRS_CONSUMER_HFXO0_TIMEOUT */
#define PRS_CONSUMER_HFXO0_TIMEOUT_PRSSEL_DEFAULT            (_PRS_CONSUMER_HFXO0_TIMEOUT_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_HFXO0_TIMEOUT*/

/* Bit fields for PRS CONSUMER_CORE_CTIIN0 */
#define _PRS_CONSUMER_CORE_CTIIN0_RESETVALUE                 0x00000000UL                                    /**< Default value for PRS_CONSUMER_CORE_CTIIN0  */
#define _PRS_CONSUMER_CORE_CTIIN0_MASK                       0x0000000FUL                                    /**< Mask for PRS_CONSUMER_CORE_CTIIN0           */
#define _PRS_CONSUMER_CORE_CTIIN0_PRSSEL_SHIFT               0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_CORE_CTIIN0_PRSSEL_MASK                0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_CORE_CTIIN0_PRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_CORE_CTIIN0   */
#define PRS_CONSUMER_CORE_CTIIN0_PRSSEL_DEFAULT              (_PRS_CONSUMER_CORE_CTIIN0_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_CORE_CTIIN0*/

/* Bit fields for PRS CONSUMER_CORE_CTIIN1 */
#define _PRS_CONSUMER_CORE_CTIIN1_RESETVALUE                 0x00000000UL                                    /**< Default value for PRS_CONSUMER_CORE_CTIIN1  */
#define _PRS_CONSUMER_CORE_CTIIN1_MASK                       0x0000000FUL                                    /**< Mask for PRS_CONSUMER_CORE_CTIIN1           */
#define _PRS_CONSUMER_CORE_CTIIN1_PRSSEL_SHIFT               0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_CORE_CTIIN1_PRSSEL_MASK                0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_CORE_CTIIN1_PRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_CORE_CTIIN1   */
#define PRS_CONSUMER_CORE_CTIIN1_PRSSEL_DEFAULT              (_PRS_CONSUMER_CORE_CTIIN1_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_CORE_CTIIN1*/

/* Bit fields for PRS CONSUMER_CORE_CTIIN2 */
#define _PRS_CONSUMER_CORE_CTIIN2_RESETVALUE                 0x00000000UL                                    /**< Default value for PRS_CONSUMER_CORE_CTIIN2  */
#define _PRS_CONSUMER_CORE_CTIIN2_MASK                       0x0000000FUL                                    /**< Mask for PRS_CONSUMER_CORE_CTIIN2           */
#define _PRS_CONSUMER_CORE_CTIIN2_PRSSEL_SHIFT               0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_CORE_CTIIN2_PRSSEL_MASK                0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_CORE_CTIIN2_PRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_CORE_CTIIN2   */
#define PRS_CONSUMER_CORE_CTIIN2_PRSSEL_DEFAULT              (_PRS_CONSUMER_CORE_CTIIN2_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_CORE_CTIIN2*/

/* Bit fields for PRS CONSUMER_CORE_CTIIN3 */
#define _PRS_CONSUMER_CORE_CTIIN3_RESETVALUE                 0x00000000UL                                    /**< Default value for PRS_CONSUMER_CORE_CTIIN3  */
#define _PRS_CONSUMER_CORE_CTIIN3_MASK                       0x0000000FUL                                    /**< Mask for PRS_CONSUMER_CORE_CTIIN3           */
#define _PRS_CONSUMER_CORE_CTIIN3_PRSSEL_SHIFT               0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_CORE_CTIIN3_PRSSEL_MASK                0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_CORE_CTIIN3_PRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_CORE_CTIIN3   */
#define PRS_CONSUMER_CORE_CTIIN3_PRSSEL_DEFAULT              (_PRS_CONSUMER_CORE_CTIIN3_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_CORE_CTIIN3*/

/* Bit fields for PRS CONSUMER_CORE_M33RXEV */
#define _PRS_CONSUMER_CORE_M33RXEV_RESETVALUE                0x00000000UL                                     /**< Default value for PRS_CONSUMER_CORE_M33RXEV */
#define _PRS_CONSUMER_CORE_M33RXEV_MASK                      0x0000000FUL                                     /**< Mask for PRS_CONSUMER_CORE_M33RXEV          */
#define _PRS_CONSUMER_CORE_M33RXEV_PRSSEL_SHIFT              0                                                /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_CORE_M33RXEV_PRSSEL_MASK               0xFUL                                            /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_CORE_M33RXEV_PRSSEL_DEFAULT            0x00000000UL                                     /**< Mode DEFAULT for PRS_CONSUMER_CORE_M33RXEV  */
#define PRS_CONSUMER_CORE_M33RXEV_PRSSEL_DEFAULT             (_PRS_CONSUMER_CORE_M33RXEV_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_CORE_M33RXEV*/

/* Bit fields for PRS CONSUMER_TIMER0_CC0 */
#define _PRS_CONSUMER_TIMER0_CC0_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER0_CC0   */
#define _PRS_CONSUMER_TIMER0_CC0_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER0_CC0            */
#define _PRS_CONSUMER_TIMER0_CC0_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER0_CC0_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER0_CC0_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER0_CC0    */
#define PRS_CONSUMER_TIMER0_CC0_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER0_CC0_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER0_CC0*/
#define _PRS_CONSUMER_TIMER0_CC0_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER0_CC0_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER0_CC0_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER0_CC0    */
#define PRS_CONSUMER_TIMER0_CC0_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER0_CC0_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER0_CC0*/

/* Bit fields for PRS CONSUMER_TIMER0_CC1 */
#define _PRS_CONSUMER_TIMER0_CC1_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER0_CC1   */
#define _PRS_CONSUMER_TIMER0_CC1_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER0_CC1            */
#define _PRS_CONSUMER_TIMER0_CC1_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER0_CC1_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER0_CC1_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER0_CC1    */
#define PRS_CONSUMER_TIMER0_CC1_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER0_CC1_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER0_CC1*/
#define _PRS_CONSUMER_TIMER0_CC1_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER0_CC1_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER0_CC1_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER0_CC1    */
#define PRS_CONSUMER_TIMER0_CC1_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER0_CC1_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER0_CC1*/

/* Bit fields for PRS CONSUMER_TIMER0_CC2 */
#define _PRS_CONSUMER_TIMER0_CC2_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER0_CC2   */
#define _PRS_CONSUMER_TIMER0_CC2_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER0_CC2            */
#define _PRS_CONSUMER_TIMER0_CC2_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER0_CC2_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER0_CC2_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER0_CC2    */
#define PRS_CONSUMER_TIMER0_CC2_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER0_CC2_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER0_CC2*/
#define _PRS_CONSUMER_TIMER0_CC2_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER0_CC2_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER0_CC2_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER0_CC2    */
#define PRS_CONSUMER_TIMER0_CC2_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER0_CC2_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER0_CC2*/

/* Bit fields for PRS CONSUMER_TIMER0_DTI */
#define _PRS_CONSUMER_TIMER0_DTI_RESETVALUE                  0x00000000UL                                   /**< Default value for PRS_CONSUMER_TIMER0_DTI   */
#define _PRS_CONSUMER_TIMER0_DTI_MASK                        0x0000000FUL                                   /**< Mask for PRS_CONSUMER_TIMER0_DTI            */
#define _PRS_CONSUMER_TIMER0_DTI_PRSSEL_SHIFT                0                                              /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER0_DTI_PRSSEL_MASK                 0xFUL                                          /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER0_DTI_PRSSEL_DEFAULT              0x00000000UL                                   /**< Mode DEFAULT for PRS_CONSUMER_TIMER0_DTI    */
#define PRS_CONSUMER_TIMER0_DTI_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER0_DTI_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER0_DTI*/

/* Bit fields for PRS CONSUMER_TIMER0_DTIFS1 */
#define _PRS_CONSUMER_TIMER0_DTIFS1_RESETVALUE               0x00000000UL                                      /**< Default value for PRS_CONSUMER_TIMER0_DTIFS1*/
#define _PRS_CONSUMER_TIMER0_DTIFS1_MASK                     0x0000000FUL                                      /**< Mask for PRS_CONSUMER_TIMER0_DTIFS1         */
#define _PRS_CONSUMER_TIMER0_DTIFS1_PRSSEL_SHIFT             0                                                 /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER0_DTIFS1_PRSSEL_MASK              0xFUL                                             /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER0_DTIFS1_PRSSEL_DEFAULT           0x00000000UL                                      /**< Mode DEFAULT for PRS_CONSUMER_TIMER0_DTIFS1 */
#define PRS_CONSUMER_TIMER0_DTIFS1_PRSSEL_DEFAULT            (_PRS_CONSUMER_TIMER0_DTIFS1_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER0_DTIFS1*/

/* Bit fields for PRS CONSUMER_TIMER0_DTIFS2 */
#define _PRS_CONSUMER_TIMER0_DTIFS2_RESETVALUE               0x00000000UL                                      /**< Default value for PRS_CONSUMER_TIMER0_DTIFS2*/
#define _PRS_CONSUMER_TIMER0_DTIFS2_MASK                     0x0000000FUL                                      /**< Mask for PRS_CONSUMER_TIMER0_DTIFS2         */
#define _PRS_CONSUMER_TIMER0_DTIFS2_PRSSEL_SHIFT             0                                                 /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER0_DTIFS2_PRSSEL_MASK              0xFUL                                             /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER0_DTIFS2_PRSSEL_DEFAULT           0x00000000UL                                      /**< Mode DEFAULT for PRS_CONSUMER_TIMER0_DTIFS2 */
#define PRS_CONSUMER_TIMER0_DTIFS2_PRSSEL_DEFAULT            (_PRS_CONSUMER_TIMER0_DTIFS2_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER0_DTIFS2*/

/* Bit fields for PRS CONSUMER_TIMER1_CC0 */
#define _PRS_CONSUMER_TIMER1_CC0_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER1_CC0   */
#define _PRS_CONSUMER_TIMER1_CC0_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER1_CC0            */
#define _PRS_CONSUMER_TIMER1_CC0_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER1_CC0_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER1_CC0_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER1_CC0    */
#define PRS_CONSUMER_TIMER1_CC0_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER1_CC0_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER1_CC0*/
#define _PRS_CONSUMER_TIMER1_CC0_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER1_CC0_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER1_CC0_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER1_CC0    */
#define PRS_CONSUMER_TIMER1_CC0_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER1_CC0_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER1_CC0*/

/* Bit fields for PRS CONSUMER_TIMER1_CC1 */
#define _PRS_CONSUMER_TIMER1_CC1_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER1_CC1   */
#define _PRS_CONSUMER_TIMER1_CC1_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER1_CC1            */
#define _PRS_CONSUMER_TIMER1_CC1_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER1_CC1_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER1_CC1_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER1_CC1    */
#define PRS_CONSUMER_TIMER1_CC1_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER1_CC1_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER1_CC1*/
#define _PRS_CONSUMER_TIMER1_CC1_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER1_CC1_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER1_CC1_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER1_CC1    */
#define PRS_CONSUMER_TIMER1_CC1_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER1_CC1_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER1_CC1*/

/* Bit fields for PRS CONSUMER_TIMER1_CC2 */
#define _PRS_CONSUMER_TIMER1_CC2_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER1_CC2   */
#define _PRS_CONSUMER_TIMER1_CC2_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER1_CC2            */
#define _PRS_CONSUMER_TIMER1_CC2_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER1_CC2_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER1_CC2_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER1_CC2    */
#define PRS_CONSUMER_TIMER1_CC2_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER1_CC2_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER1_CC2*/
#define _PRS_CONSUMER_TIMER1_CC2_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER1_CC2_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER1_CC2_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER1_CC2    */
#define PRS_CONSUMER_TIMER1_CC2_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER1_CC2_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER1_CC2*/

/* Bit fields for PRS CONSUMER_TIMER1_DTI */
#define _PRS_CONSUMER_TIMER1_DTI_RESETVALUE                  0x00000000UL                                   /**< Default value for PRS_CONSUMER_TIMER1_DTI   */
#define _PRS_CONSUMER_TIMER1_DTI_MASK                        0x0000000FUL                                   /**< Mask for PRS_CONSUMER_TIMER1_DTI            */
#define _PRS_CONSUMER_TIMER1_DTI_PRSSEL_SHIFT                0                                              /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER1_DTI_PRSSEL_MASK                 0xFUL                                          /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER1_DTI_PRSSEL_DEFAULT              0x00000000UL                                   /**< Mode DEFAULT for PRS_CONSUMER_TIMER1_DTI    */
#define PRS_CONSUMER_TIMER1_DTI_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER1_DTI_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER1_DTI*/

/* Bit fields for PRS CONSUMER_TIMER1_DTIFS1 */
#define _PRS_CONSUMER_TIMER1_DTIFS1_RESETVALUE               0x00000000UL                                      /**< Default value for PRS_CONSUMER_TIMER1_DTIFS1*/
#define _PRS_CONSUMER_TIMER1_DTIFS1_MASK                     0x0000000FUL                                      /**< Mask for PRS_CONSUMER_TIMER1_DTIFS1         */
#define _PRS_CONSUMER_TIMER1_DTIFS1_PRSSEL_SHIFT             0                                                 /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER1_DTIFS1_PRSSEL_MASK              0xFUL                                             /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER1_DTIFS1_PRSSEL_DEFAULT           0x00000000UL                                      /**< Mode DEFAULT for PRS_CONSUMER_TIMER1_DTIFS1 */
#define PRS_CONSUMER_TIMER1_DTIFS1_PRSSEL_DEFAULT            (_PRS_CONSUMER_TIMER1_DTIFS1_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER1_DTIFS1*/

/* Bit fields for PRS CONSUMER_TIMER1_DTIFS2 */
#define _PRS_CONSUMER_TIMER1_DTIFS2_RESETVALUE               0x00000000UL                                      /**< Default value for PRS_CONSUMER_TIMER1_DTIFS2*/
#define _PRS_CONSUMER_TIMER1_DTIFS2_MASK                     0x0000000FUL                                      /**< Mask for PRS_CONSUMER_TIMER1_DTIFS2         */
#define _PRS_CONSUMER_TIMER1_DTIFS2_PRSSEL_SHIFT             0                                                 /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER1_DTIFS2_PRSSEL_MASK              0xFUL                                             /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER1_DTIFS2_PRSSEL_DEFAULT           0x00000000UL                                      /**< Mode DEFAULT for PRS_CONSUMER_TIMER1_DTIFS2 */
#define PRS_CONSUMER_TIMER1_DTIFS2_PRSSEL_DEFAULT            (_PRS_CONSUMER_TIMER1_DTIFS2_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER1_DTIFS2*/

/* Bit fields for PRS CONSUMER_TIMER2_CC0 */
#define _PRS_CONSUMER_TIMER2_CC0_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER2_CC0   */
#define _PRS_CONSUMER_TIMER2_CC0_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER2_CC0            */
#define _PRS_CONSUMER_TIMER2_CC0_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER2_CC0_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER2_CC0_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER2_CC0    */
#define PRS_CONSUMER_TIMER2_CC0_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER2_CC0_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER2_CC0*/
#define _PRS_CONSUMER_TIMER2_CC0_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER2_CC0_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER2_CC0_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER2_CC0    */
#define PRS_CONSUMER_TIMER2_CC0_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER2_CC0_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER2_CC0*/

/* Bit fields for PRS CONSUMER_TIMER2_CC1 */
#define _PRS_CONSUMER_TIMER2_CC1_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER2_CC1   */
#define _PRS_CONSUMER_TIMER2_CC1_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER2_CC1            */
#define _PRS_CONSUMER_TIMER2_CC1_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER2_CC1_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER2_CC1_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER2_CC1    */
#define PRS_CONSUMER_TIMER2_CC1_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER2_CC1_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER2_CC1*/
#define _PRS_CONSUMER_TIMER2_CC1_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER2_CC1_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER2_CC1_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER2_CC1    */
#define PRS_CONSUMER_TIMER2_CC1_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER2_CC1_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER2_CC1*/

/* Bit fields for PRS CONSUMER_TIMER2_CC2 */
#define _PRS_CONSUMER_TIMER2_CC2_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER2_CC2   */
#define _PRS_CONSUMER_TIMER2_CC2_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER2_CC2            */
#define _PRS_CONSUMER_TIMER2_CC2_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER2_CC2_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER2_CC2_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER2_CC2    */
#define PRS_CONSUMER_TIMER2_CC2_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER2_CC2_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER2_CC2*/
#define _PRS_CONSUMER_TIMER2_CC2_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER2_CC2_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER2_CC2_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER2_CC2    */
#define PRS_CONSUMER_TIMER2_CC2_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER2_CC2_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER2_CC2*/

/* Bit fields for PRS CONSUMER_TIMER2_CC3 */
#define _PRS_CONSUMER_TIMER2_CC3_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER2_CC3   */
#define _PRS_CONSUMER_TIMER2_CC3_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER2_CC3            */
#define _PRS_CONSUMER_TIMER2_CC3_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER2_CC3_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER2_CC3_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER2_CC3    */
#define PRS_CONSUMER_TIMER2_CC3_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER2_CC3_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER2_CC3*/
#define _PRS_CONSUMER_TIMER2_CC3_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER2_CC3_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER2_CC3_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER2_CC3    */
#define PRS_CONSUMER_TIMER2_CC3_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER2_CC3_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER2_CC3*/

/* Bit fields for PRS CONSUMER_TIMER2_CC4 */
#define _PRS_CONSUMER_TIMER2_CC4_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER2_CC4   */
#define _PRS_CONSUMER_TIMER2_CC4_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER2_CC4            */
#define _PRS_CONSUMER_TIMER2_CC4_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER2_CC4_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER2_CC4_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER2_CC4    */
#define PRS_CONSUMER_TIMER2_CC4_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER2_CC4_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER2_CC4*/
#define _PRS_CONSUMER_TIMER2_CC4_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER2_CC4_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER2_CC4_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER2_CC4    */
#define PRS_CONSUMER_TIMER2_CC4_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER2_CC4_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER2_CC4*/

/* Bit fields for PRS CONSUMER_TIMER2_CC5 */
#define _PRS_CONSUMER_TIMER2_CC5_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER2_CC5   */
#define _PRS_CONSUMER_TIMER2_CC5_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER2_CC5            */
#define _PRS_CONSUMER_TIMER2_CC5_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER2_CC5_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER2_CC5_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER2_CC5    */
#define PRS_CONSUMER_TIMER2_CC5_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER2_CC5_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER2_CC5*/
#define _PRS_CONSUMER_TIMER2_CC5_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER2_CC5_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER2_CC5_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER2_CC5    */
#define PRS_CONSUMER_TIMER2_CC5_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER2_CC5_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER2_CC5*/

/* Bit fields for PRS CONSUMER_TIMER2_CC6 */
#define _PRS_CONSUMER_TIMER2_CC6_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER2_CC6   */
#define _PRS_CONSUMER_TIMER2_CC6_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER2_CC6            */
#define _PRS_CONSUMER_TIMER2_CC6_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER2_CC6_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER2_CC6_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER2_CC6    */
#define PRS_CONSUMER_TIMER2_CC6_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER2_CC6_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER2_CC6*/
#define _PRS_CONSUMER_TIMER2_CC6_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER2_CC6_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER2_CC6_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER2_CC6    */
#define PRS_CONSUMER_TIMER2_CC6_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER2_CC6_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER2_CC6*/

/* Bit fields for PRS CONSUMER_TIMER2_DTI */
#define _PRS_CONSUMER_TIMER2_DTI_RESETVALUE                  0x00000000UL                                   /**< Default value for PRS_CONSUMER_TIMER2_DTI   */
#define _PRS_CONSUMER_TIMER2_DTI_MASK                        0x0000000FUL                                   /**< Mask for PRS_CONSUMER_TIMER2_DTI            */
#define _PRS_CONSUMER_TIMER2_DTI_PRSSEL_SHIFT                0                                              /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER2_DTI_PRSSEL_MASK                 0xFUL                                          /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER2_DTI_PRSSEL_DEFAULT              0x00000000UL                                   /**< Mode DEFAULT for PRS_CONSUMER_TIMER2_DTI    */
#define PRS_CONSUMER_TIMER2_DTI_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER2_DTI_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER2_DTI*/

/* Bit fields for PRS CONSUMER_TIMER2_DTIFS1 */
#define _PRS_CONSUMER_TIMER2_DTIFS1_RESETVALUE               0x00000000UL                                      /**< Default value for PRS_CONSUMER_TIMER2_DTIFS1*/
#define _PRS_CONSUMER_TIMER2_DTIFS1_MASK                     0x0000000FUL                                      /**< Mask for PRS_CONSUMER_TIMER2_DTIFS1         */
#define _PRS_CONSUMER_TIMER2_DTIFS1_PRSSEL_SHIFT             0                                                 /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER2_DTIFS1_PRSSEL_MASK              0xFUL                                             /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER2_DTIFS1_PRSSEL_DEFAULT           0x00000000UL                                      /**< Mode DEFAULT for PRS_CONSUMER_TIMER2_DTIFS1 */
#define PRS_CONSUMER_TIMER2_DTIFS1_PRSSEL_DEFAULT            (_PRS_CONSUMER_TIMER2_DTIFS1_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER2_DTIFS1*/

/* Bit fields for PRS CONSUMER_TIMER2_DTIFS2 */
#define _PRS_CONSUMER_TIMER2_DTIFS2_RESETVALUE               0x00000000UL                                      /**< Default value for PRS_CONSUMER_TIMER2_DTIFS2*/
#define _PRS_CONSUMER_TIMER2_DTIFS2_MASK                     0x0000000FUL                                      /**< Mask for PRS_CONSUMER_TIMER2_DTIFS2         */
#define _PRS_CONSUMER_TIMER2_DTIFS2_PRSSEL_SHIFT             0                                                 /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER2_DTIFS2_PRSSEL_MASK              0xFUL                                             /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER2_DTIFS2_PRSSEL_DEFAULT           0x00000000UL                                      /**< Mode DEFAULT for PRS_CONSUMER_TIMER2_DTIFS2 */
#define PRS_CONSUMER_TIMER2_DTIFS2_PRSSEL_DEFAULT            (_PRS_CONSUMER_TIMER2_DTIFS2_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER2_DTIFS2*/

/* Bit fields for PRS CONSUMER_TIMER3_CC0 */
#define _PRS_CONSUMER_TIMER3_CC0_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER3_CC0   */
#define _PRS_CONSUMER_TIMER3_CC0_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER3_CC0            */
#define _PRS_CONSUMER_TIMER3_CC0_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER3_CC0_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER3_CC0_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER3_CC0    */
#define PRS_CONSUMER_TIMER3_CC0_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER3_CC0_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER3_CC0*/
#define _PRS_CONSUMER_TIMER3_CC0_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER3_CC0_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER3_CC0_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER3_CC0    */
#define PRS_CONSUMER_TIMER3_CC0_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER3_CC0_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER3_CC0*/

/* Bit fields for PRS CONSUMER_TIMER3_CC1 */
#define _PRS_CONSUMER_TIMER3_CC1_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER3_CC1   */
#define _PRS_CONSUMER_TIMER3_CC1_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER3_CC1            */
#define _PRS_CONSUMER_TIMER3_CC1_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER3_CC1_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER3_CC1_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER3_CC1    */
#define PRS_CONSUMER_TIMER3_CC1_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER3_CC1_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER3_CC1*/
#define _PRS_CONSUMER_TIMER3_CC1_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER3_CC1_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER3_CC1_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER3_CC1    */
#define PRS_CONSUMER_TIMER3_CC1_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER3_CC1_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER3_CC1*/

/* Bit fields for PRS CONSUMER_TIMER3_CC2 */
#define _PRS_CONSUMER_TIMER3_CC2_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER3_CC2   */
#define _PRS_CONSUMER_TIMER3_CC2_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER3_CC2            */
#define _PRS_CONSUMER_TIMER3_CC2_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER3_CC2_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER3_CC2_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER3_CC2    */
#define PRS_CONSUMER_TIMER3_CC2_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER3_CC2_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER3_CC2*/
#define _PRS_CONSUMER_TIMER3_CC2_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER3_CC2_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER3_CC2_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER3_CC2    */
#define PRS_CONSUMER_TIMER3_CC2_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER3_CC2_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER3_CC2*/

/* Bit fields for PRS CONSUMER_TIMER3_CC3 */
#define _PRS_CONSUMER_TIMER3_CC3_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER3_CC3   */
#define _PRS_CONSUMER_TIMER3_CC3_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER3_CC3            */
#define _PRS_CONSUMER_TIMER3_CC3_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER3_CC3_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER3_CC3_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER3_CC3    */
#define PRS_CONSUMER_TIMER3_CC3_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER3_CC3_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER3_CC3*/
#define _PRS_CONSUMER_TIMER3_CC3_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER3_CC3_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER3_CC3_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER3_CC3    */
#define PRS_CONSUMER_TIMER3_CC3_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER3_CC3_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER3_CC3*/

/* Bit fields for PRS CONSUMER_TIMER3_CC4 */
#define _PRS_CONSUMER_TIMER3_CC4_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER3_CC4   */
#define _PRS_CONSUMER_TIMER3_CC4_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER3_CC4            */
#define _PRS_CONSUMER_TIMER3_CC4_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER3_CC4_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER3_CC4_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER3_CC4    */
#define PRS_CONSUMER_TIMER3_CC4_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER3_CC4_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER3_CC4*/
#define _PRS_CONSUMER_TIMER3_CC4_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER3_CC4_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER3_CC4_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER3_CC4    */
#define PRS_CONSUMER_TIMER3_CC4_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER3_CC4_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER3_CC4*/

/* Bit fields for PRS CONSUMER_TIMER3_CC5 */
#define _PRS_CONSUMER_TIMER3_CC5_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER3_CC5   */
#define _PRS_CONSUMER_TIMER3_CC5_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER3_CC5            */
#define _PRS_CONSUMER_TIMER3_CC5_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER3_CC5_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER3_CC5_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER3_CC5    */
#define PRS_CONSUMER_TIMER3_CC5_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER3_CC5_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER3_CC5*/
#define _PRS_CONSUMER_TIMER3_CC5_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER3_CC5_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER3_CC5_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER3_CC5    */
#define PRS_CONSUMER_TIMER3_CC5_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER3_CC5_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER3_CC5*/

/* Bit fields for PRS CONSUMER_TIMER3_CC6 */
#define _PRS_CONSUMER_TIMER3_CC6_RESETVALUE                  0x00000000UL                                    /**< Default value for PRS_CONSUMER_TIMER3_CC6   */
#define _PRS_CONSUMER_TIMER3_CC6_MASK                        0x0000030FUL                                    /**< Mask for PRS_CONSUMER_TIMER3_CC6            */
#define _PRS_CONSUMER_TIMER3_CC6_PRSSEL_SHIFT                0                                               /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER3_CC6_PRSSEL_MASK                 0xFUL                                           /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER3_CC6_PRSSEL_DEFAULT              0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER3_CC6    */
#define PRS_CONSUMER_TIMER3_CC6_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER3_CC6_PRSSEL_DEFAULT << 0)  /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER3_CC6*/
#define _PRS_CONSUMER_TIMER3_CC6_SPRSSEL_SHIFT               8                                               /**< Shift value for PRS_SPRSSEL                 */
#define _PRS_CONSUMER_TIMER3_CC6_SPRSSEL_MASK                0x300UL                                         /**< Bit mask for PRS_SPRSSEL                    */
#define _PRS_CONSUMER_TIMER3_CC6_SPRSSEL_DEFAULT             0x00000000UL                                    /**< Mode DEFAULT for PRS_CONSUMER_TIMER3_CC6    */
#define PRS_CONSUMER_TIMER3_CC6_SPRSSEL_DEFAULT              (_PRS_CONSUMER_TIMER3_CC6_SPRSSEL_DEFAULT << 8) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER3_CC6*/

/* Bit fields for PRS CONSUMER_TIMER3_DTI */
#define _PRS_CONSUMER_TIMER3_DTI_RESETVALUE                  0x00000000UL                                   /**< Default value for PRS_CONSUMER_TIMER3_DTI   */
#define _PRS_CONSUMER_TIMER3_DTI_MASK                        0x0000000FUL                                   /**< Mask for PRS_CONSUMER_TIMER3_DTI            */
#define _PRS_CONSUMER_TIMER3_DTI_PRSSEL_SHIFT                0                                              /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER3_DTI_PRSSEL_MASK                 0xFUL                                          /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER3_DTI_PRSSEL_DEFAULT              0x00000000UL                                   /**< Mode DEFAULT for PRS_CONSUMER_TIMER3_DTI    */
#define PRS_CONSUMER_TIMER3_DTI_PRSSEL_DEFAULT               (_PRS_CONSUMER_TIMER3_DTI_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER3_DTI*/

/* Bit fields for PRS CONSUMER_TIMER3_DTIFS1 */
#define _PRS_CONSUMER_TIMER3_DTIFS1_RESETVALUE               0x00000000UL                                      /**< Default value for PRS_CONSUMER_TIMER3_DTIFS1*/
#define _PRS_CONSUMER_TIMER3_DTIFS1_MASK                     0x0000000FUL                                      /**< Mask for PRS_CONSUMER_TIMER3_DTIFS1         */
#define _PRS_CONSUMER_TIMER3_DTIFS1_PRSSEL_SHIFT             0                                                 /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER3_DTIFS1_PRSSEL_MASK              0xFUL                                             /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER3_DTIFS1_PRSSEL_DEFAULT           0x00000000UL                                      /**< Mode DEFAULT for PRS_CONSUMER_TIMER3_DTIFS1 */
#define PRS_CONSUMER_TIMER3_DTIFS1_PRSSEL_DEFAULT            (_PRS_CONSUMER_TIMER3_DTIFS1_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER3_DTIFS1*/

/* Bit fields for PRS CONSUMER_TIMER3_DTIFS2 */
#define _PRS_CONSUMER_TIMER3_DTIFS2_RESETVALUE               0x00000000UL                                      /**< Default value for PRS_CONSUMER_TIMER3_DTIFS2*/
#define _PRS_CONSUMER_TIMER3_DTIFS2_MASK                     0x0000000FUL                                      /**< Mask for PRS_CONSUMER_TIMER3_DTIFS2         */
#define _PRS_CONSUMER_TIMER3_DTIFS2_PRSSEL_SHIFT             0                                                 /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_TIMER3_DTIFS2_PRSSEL_MASK              0xFUL                                             /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_TIMER3_DTIFS2_PRSSEL_DEFAULT           0x00000000UL                                      /**< Mode DEFAULT for PRS_CONSUMER_TIMER3_DTIFS2 */
#define PRS_CONSUMER_TIMER3_DTIFS2_PRSSEL_DEFAULT            (_PRS_CONSUMER_TIMER3_DTIFS2_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_TIMER3_DTIFS2*/

/* Bit fields for PRS CONSUMER_WDOG0_SRC0 */
#define _PRS_CONSUMER_WDOG0_SRC0_RESETVALUE                  0x00000000UL                                   /**< Default value for PRS_CONSUMER_WDOG0_SRC0   */
#define _PRS_CONSUMER_WDOG0_SRC0_MASK                        0x0000000FUL                                   /**< Mask for PRS_CONSUMER_WDOG0_SRC0            */
#define _PRS_CONSUMER_WDOG0_SRC0_PRSSEL_SHIFT                0                                              /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_WDOG0_SRC0_PRSSEL_MASK                 0xFUL                                          /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_WDOG0_SRC0_PRSSEL_DEFAULT              0x00000000UL                                   /**< Mode DEFAULT for PRS_CONSUMER_WDOG0_SRC0    */
#define PRS_CONSUMER_WDOG0_SRC0_PRSSEL_DEFAULT               (_PRS_CONSUMER_WDOG0_SRC0_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_WDOG0_SRC0*/

/* Bit fields for PRS CONSUMER_WDOG0_SRC1 */
#define _PRS_CONSUMER_WDOG0_SRC1_RESETVALUE                  0x00000000UL                                   /**< Default value for PRS_CONSUMER_WDOG0_SRC1   */
#define _PRS_CONSUMER_WDOG0_SRC1_MASK                        0x0000000FUL                                   /**< Mask for PRS_CONSUMER_WDOG0_SRC1            */
#define _PRS_CONSUMER_WDOG0_SRC1_PRSSEL_SHIFT                0                                              /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_WDOG0_SRC1_PRSSEL_MASK                 0xFUL                                          /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_WDOG0_SRC1_PRSSEL_DEFAULT              0x00000000UL                                   /**< Mode DEFAULT for PRS_CONSUMER_WDOG0_SRC1    */
#define PRS_CONSUMER_WDOG0_SRC1_PRSSEL_DEFAULT               (_PRS_CONSUMER_WDOG0_SRC1_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_WDOG0_SRC1*/

/* Bit fields for PRS CONSUMER_WDOG1_SRC0 */
#define _PRS_CONSUMER_WDOG1_SRC0_RESETVALUE                  0x00000000UL                                   /**< Default value for PRS_CONSUMER_WDOG1_SRC0   */
#define _PRS_CONSUMER_WDOG1_SRC0_MASK                        0x0000000FUL                                   /**< Mask for PRS_CONSUMER_WDOG1_SRC0            */
#define _PRS_CONSUMER_WDOG1_SRC0_PRSSEL_SHIFT                0                                              /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_WDOG1_SRC0_PRSSEL_MASK                 0xFUL                                          /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_WDOG1_SRC0_PRSSEL_DEFAULT              0x00000000UL                                   /**< Mode DEFAULT for PRS_CONSUMER_WDOG1_SRC0    */
#define PRS_CONSUMER_WDOG1_SRC0_PRSSEL_DEFAULT               (_PRS_CONSUMER_WDOG1_SRC0_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_WDOG1_SRC0*/

/* Bit fields for PRS CONSUMER_WDOG1_SRC1 */
#define _PRS_CONSUMER_WDOG1_SRC1_RESETVALUE                  0x00000000UL                                   /**< Default value for PRS_CONSUMER_WDOG1_SRC1   */
#define _PRS_CONSUMER_WDOG1_SRC1_MASK                        0x0000000FUL                                   /**< Mask for PRS_CONSUMER_WDOG1_SRC1            */
#define _PRS_CONSUMER_WDOG1_SRC1_PRSSEL_SHIFT                0                                              /**< Shift value for PRS_PRSSEL                  */
#define _PRS_CONSUMER_WDOG1_SRC1_PRSSEL_MASK                 0xFUL                                          /**< Bit mask for PRS_PRSSEL                     */
#define _PRS_CONSUMER_WDOG1_SRC1_PRSSEL_DEFAULT              0x00000000UL                                   /**< Mode DEFAULT for PRS_CONSUMER_WDOG1_SRC1    */
#define PRS_CONSUMER_WDOG1_SRC1_PRSSEL_DEFAULT               (_PRS_CONSUMER_WDOG1_SRC1_PRSSEL_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_CONSUMER_WDOG1_SRC1*/

/* Bit fields for PRS RPURATD4 */
#define _PRS_RPURATD4_RESETVALUE                             0x00000000UL                               /**< Default value for PRS_RPURATD4              */
#define _PRS_RPURATD4_MASK                                   0x00000001UL                               /**< Mask for PRS_RPURATD4                       */
#define PRS_RPURATD4_RATDWDOG1SRC1                           (0x1UL << 0)                               /**< WDOG1_SRC1 Protection Bit                   */
#define _PRS_RPURATD4_RATDWDOG1SRC1_SHIFT                    0                                          /**< Shift value for PRS_RATDWDOG1SRC1           */
#define _PRS_RPURATD4_RATDWDOG1SRC1_MASK                     0x1UL                                      /**< Bit mask for PRS_RATDWDOG1SRC1              */
#define _PRS_RPURATD4_RATDWDOG1SRC1_DEFAULT                  0x00000000UL                               /**< Mode DEFAULT for PRS_RPURATD4               */
#define PRS_RPURATD4_RATDWDOG1SRC1_DEFAULT                   (_PRS_RPURATD4_RATDWDOG1SRC1_DEFAULT << 0) /**< Shifted mode DEFAULT for PRS_RPURATD4       */

/** @} End of group SIMG301_PRS_BitFields */
/** @} End of group SIMG301_PRS */
/** @} End of group Parts */

#endif // SIMG301_PRS_H
