#ifndef __SILICON_LABS_DMADRV_SIGNALS_S3_H__
#define __SILICON_LABS_DMADRV_SIGNALS_S3_H__

#include "em_device.h"
#include "ecode.h"
#include "sl_enum.h"
#include "sl_hal_ldma.h"

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************//**
 * @addtogroup dmadrv
 * @{
 ******************************************************************************/

#if defined(LDMAXBAR_COUNT) && (LDMAXBAR_COUNT > 0)

/// Maximum length of one DMA transfer.
#define DMADRV_MAX_XFER_COUNT ((int)((_LDMA_CH_CTRL_XFERCNT_MASK >> _LDMA_CH_CTRL_XFERCNT_SHIFT) + 1))

/// Peripherals that can trigger LDMA transfers.
SL_ENUM_GENERIC(DMADRV_PeripheralSignal_t, uint32_t) {
  dmadrvPeripheralSignal_NONE = LDMAXBAR0_CH_REQSEL_SOURCESEL_NONE,                                                          ///< No peripheral selected for DMA triggering.
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_LDMAXBAR0PRSREQ0
  dmadrvPeripheralSignal_LDMAXBAR0_PRSREQ0 = LDMAXBAR0_CH_REQSEL_SIGSEL_LDMAXBAR0PRSREQ0 | LDMAXBAR0_CH_REQSEL_SOURCESEL_LDMAXBAR0,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_LDMAXBAR0PRSREQ1
  dmadrvPeripheralSignal_LDMAXBAR0_PRSREQ1 = LDMAXBAR0_CH_REQSEL_SIGSEL_LDMAXBAR0PRSREQ1 | LDMAXBAR0_CH_REQSEL_SOURCESEL_LDMAXBAR0,
  #endif

  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_I2C0RXDATAV
  dmadrvPeripheralSignal_I2C0_RXDATAV = LDMAXBAR0_CH_REQSEL_SIGSEL_I2C0RXDATAV | LDMAXBAR0_CH_REQSEL_SOURCESEL_I2C0,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_I2C0TXBL
  dmadrvPeripheralSignal_I2C0_TXBL = LDMAXBAR0_CH_REQSEL_SIGSEL_I2C0TXBL | LDMAXBAR0_CH_REQSEL_SOURCESEL_I2C0,
  #endif

  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_I2C1RXDATAV
  dmadrvPeripheralSignal_I2C1_RXDATAV = LDMAXBAR0_CH_REQSEL_SIGSEL_I2C1RXDATAV | LDMAXBAR0_CH_REQSEL_SOURCESEL_I2C1,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_I2C1TXBL
  dmadrvPeripheralSignal_I2C1_TXBL = LDMAXBAR0_CH_REQSEL_SIGSEL_I2C1TXBL | LDMAXBAR0_CH_REQSEL_SOURCESEL_I2C1,
  #endif

  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_I2C2RXDATAV
  dmadrvPeripheralSignal_I2C2_RXDATAV = LDMAXBAR0_CH_REQSEL_SIGSEL_I2C2RXDATAV | LDMAXBAR0_CH_REQSEL_SOURCESEL_I2C2,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_I2C2TXBL
  dmadrvPeripheralSignal_I2C2_TXBL = LDMAXBAR0_CH_REQSEL_SIGSEL_I2C2TXBL | LDMAXBAR0_CH_REQSEL_SOURCESEL_I2C2,
  #endif

  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_AGCRSSI
  dmadrvPeripheralSignal_AGC_RSSI = LDMAXBAR0_CH_REQSEL_SIGSEL_AGCRSSI | LDMAXBAR0_CH_REQSEL_SOURCESEL_AGC,
  #endif

  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_PROTIMERBOF
  dmadrvPeripheralSignal_PROTIMER_BOF = LDMAXBAR0_CH_REQSEL_SIGSEL_PROTIMERBOF | LDMAXBAR0_CH_REQSEL_SOURCESEL_PROTIMER,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_PROTIMERCC0
  dmadrvPeripheralSignal_PROTIMER_CC0 = LDMAXBAR0_CH_REQSEL_SIGSEL_PROTIMERCC0 | LDMAXBAR0_CH_REQSEL_SOURCESEL_PROTIMER,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_PROTIMERCC1
  dmadrvPeripheralSignal_PROTIMER_CC1 = LDMAXBAR0_CH_REQSEL_SIGSEL_PROTIMERCC1 | LDMAXBAR0_CH_REQSEL_SOURCESEL_PROTIMER,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_PROTIMERCC2
  dmadrvPeripheralSignal_PROTIMER_CC2 = LDMAXBAR0_CH_REQSEL_SIGSEL_PROTIMERCC2 | LDMAXBAR0_CH_REQSEL_SOURCESEL_PROTIMER,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_PROTIMERCC3
  dmadrvPeripheralSignal_PROTIMER_CC3 = LDMAXBAR0_CH_REQSEL_SIGSEL_PROTIMERCC3 | LDMAXBAR0_CH_REQSEL_SOURCESEL_PROTIMER,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_PROTIMERCC4
  dmadrvPeripheralSignal_PROTIMER_CC4 = LDMAXBAR0_CH_REQSEL_SIGSEL_PROTIMERCC4 | LDMAXBAR0_CH_REQSEL_SOURCESEL_PROTIMER,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_PROTIMERPOF
  dmadrvPeripheralSignal_PROTIMER_POF = LDMAXBAR0_CH_REQSEL_SIGSEL_PROTIMERPOF | LDMAXBAR0_CH_REQSEL_SOURCESEL_PROTIMER,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_PROTIMERWOF
  dmadrvPeripheralSignal_PROTIMER_WOF = LDMAXBAR0_CH_REQSEL_SIGSEL_PROTIMERWOF | LDMAXBAR0_CH_REQSEL_SOURCESEL_PROTIMER,
  #endif

  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_MODEMDEBUG
  dmadrvPeripheralSignal_MODEM_DEBUG = LDMAXBAR0_CH_REQSEL_SIGSEL_MODEMDEBUG | LDMAXBAR0_CH_REQSEL_SOURCESEL_MODEM,
  #endif

  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0CC0
  dmadrvPeripheralSignal_TIMER0_CC0 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0CC0 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER0,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0CC1
  dmadrvPeripheralSignal_TIMER0_CC1 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0CC1 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER0,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0CC2
  dmadrvPeripheralSignal_TIMER0_CC2 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0CC2 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER0,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0UFOF
  dmadrvPeripheralSignal_TIMER0_UFOF = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER0UFOF | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER0,
  #endif

  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1CC0
  dmadrvPeripheralSignal_TIMER1_CC0 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1CC0 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER1,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1CC1
  dmadrvPeripheralSignal_TIMER1_CC1 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1CC1 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER1,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1CC2
  dmadrvPeripheralSignal_TIMER1_CC2 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1CC2 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER1,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1UFOF
  dmadrvPeripheralSignal_TIMER1_UFOF = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER1UFOF | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER1,
  #endif

  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC0
  dmadrvPeripheralSignal_TIMER2_CC0 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC0 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER2,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC1
  dmadrvPeripheralSignal_TIMER2_CC1 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC1 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER2,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC2
  dmadrvPeripheralSignal_TIMER2_CC2 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC2 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER2,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2UFOF
  dmadrvPeripheralSignal_TIMER2_UFOF = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2UFOF | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER2,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC3
  dmadrvPeripheralSignal_TIMER2_CC3 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC3 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER2,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC4
  dmadrvPeripheralSignal_TIMER2_CC4 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC4 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER2,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC5
  dmadrvPeripheralSignal_TIMER2_CC5 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC5 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER2,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC6
  dmadrvPeripheralSignal_TIMER2_CC6 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER2CC6 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER2,
  #endif

  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC0
  dmadrvPeripheralSignal_TIMER3_CC0 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC0 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER3,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC1
  dmadrvPeripheralSignal_TIMER3_CC1 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC1 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER3,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC2
  dmadrvPeripheralSignal_TIMER3_CC2 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC2 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER3,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3UFOF
  dmadrvPeripheralSignal_TIMER3_UFOF = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3UFOF | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER3,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC3
  dmadrvPeripheralSignal_TIMER3_CC3 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC3 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER3,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC4
  dmadrvPeripheralSignal_TIMER3_CC4 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC4 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER3,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC5
  dmadrvPeripheralSignal_TIMER3_CC5 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC5 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER3,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC6
  dmadrvPeripheralSignal_TIMER3_CC6 = LDMAXBAR0_CH_REQSEL_SIGSEL_TIMER3CC6 | LDMAXBAR0_CH_REQSEL_SOURCESEL_TIMER3,
  #endif

  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART0TXFL
  dmadrvPeripheralSignal_EUSART0_TXBL = LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART0TXFL | LDMAXBAR0_CH_REQSEL_SOURCESEL_EUSART0,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART0RXFL
  dmadrvPeripheralSignal_EUSART0_RXDATAV = LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART0RXFL | LDMAXBAR0_CH_REQSEL_SOURCESEL_EUSART0,
  #endif

  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART1TXFL
  dmadrvPeripheralSignal_EUSART1_TXBL = LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART1TXFL | LDMAXBAR0_CH_REQSEL_SOURCESEL_EUSART1,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART1RXFL
  dmadrvPeripheralSignal_EUSART1_RXDATAV = LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART1RXFL | LDMAXBAR0_CH_REQSEL_SOURCESEL_EUSART1,
  #endif

  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART2TXFL
  dmadrvPeripheralSignal_EUSART2_TXBL = LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART2TXFL | LDMAXBAR0_CH_REQSEL_SOURCESEL_EUSART2,
  #endif
  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART2RXFL
  dmadrvPeripheralSignal_EUSART2_RXDATAV = LDMAXBAR0_CH_REQSEL_SIGSEL_EUSART2RXFL | LDMAXBAR0_CH_REQSEL_SOURCESEL_EUSART2,
  #endif

  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_PIXELRZ0REQ_TXF
  dmadrvPeripheralSignal_PIXELRZ0_TXF = LDMAXBAR0_CH_REQSEL_SIGSEL_PIXELRZ0REQ_TXF | LDMAXBAR0_CH_REQSEL_SOURCESEL_PIXELRZ0,
  #endif

  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_PIXELRZ1REQ_TXF
  dmadrvPeripheralSignal_PIXELRZ1_TXF = LDMAXBAR0_CH_REQSEL_SIGSEL_PIXELRZ1REQ_TXF | LDMAXBAR0_CH_REQSEL_SOURCESEL_PIXELRZ1,
  #endif

  #if defined LDMAXBAR0_CH_REQSEL_SIGSEL_ADC0SCAN
  dmadrvPeripheralSignal_ADC0_SCAN = LDMAXBAR0_CH_REQSEL_SIGSEL_ADC0SCAN | LDMAXBAR0_CH_REQSEL_SOURCESEL_ADC0,
  #endif
};

/// Data size of one LDMA transfer item.
SL_ENUM(DMADRV_DataSize_t) {
  dmadrvDataSize1 = SL_HAL_LDMA_CTRL_SIZE_BYTE, ///< Byte
  dmadrvDataSize2 = SL_HAL_LDMA_CTRL_SIZE_HALF, ///< Halfword
  dmadrvDataSize4 = SL_HAL_LDMA_CTRL_SIZE_WORD  ///< Word
};

#endif /* defined( LDMA_PRESENT ) && ( LDMA_COUNT == 1 ) */

/** @} (end addtogroup dmadrv) */

#ifdef __cplusplus
}
#endif

#endif /* __SILICON_LABS_DMADRV_SIGNALS_S3_H__ */
