/***************************************************************************//**
 * @file
 * @brief BSP options defines
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc.  Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement.  This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

/********************************************************************************************************
 ********************************************************************************************************
 *                                               MODULE
 ********************************************************************************************************
 *******************************************************************************************************/

#ifndef  _BSP_OPT_DEF_H_
#define  _BSP_OPT_DEF_H_

/********************************************************************************************************
 ********************************************************************************************************
 *                                               DEFINES
 ********************************************************************************************************
 *******************************************************************************************************/

/********************************************************************************************************
 *                                           High Frequency Clock Selection
 *******************************************************************************************************/

#define  BSP_HF_CLK_DEFAULT                     0u
#define  BSP_HF_CLK_HFRCO                       1u
#define  BSP_HF_CLK_HFXO                        2u
#define  BSP_HF_CLK_DPLL_48MHZ                  3u

/********************************************************************************************************
 *                                           Low Frequency Clock Selection
 *******************************************************************************************************/

#define  BSP_LF_CLK_DEFAULT                     0u
#define  BSP_LF_CLK_LFRCO                       1u
#define  BSP_LF_CLK_LFXO                        2u
#define  BSP_LF_CLK_ULFRCO                      3u

/********************************************************************************************************
 *                                           EMU DCDC Mode Selection
 *******************************************************************************************************/

#define  BSP_DCDC_BYPASS                        0u
#define  BSP_DCDC_DVDD                          1u
#define  BSP_DCDC_OFF                           2u

/********************************************************************************************************
 ********************************************************************************************************
 *                                             MODULE END
 ********************************************************************************************************
 *******************************************************************************************************/

#endif // End of bsp opt def module include.
