/***************************************************************************//**
 * @file
 * @brief Common - RTOS Prio
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc.  Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement.  This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

/********************************************************************************************************
 ********************************************************************************************************
 *                                               MODULE
 ********************************************************************************************************
 *******************************************************************************************************/

#ifndef  _RTOS_PRIO_H_
#define  _RTOS_PRIO_H_

/********************************************************************************************************
 ********************************************************************************************************
 *                                               INCLUDE FILES
 ********************************************************************************************************
 *******************************************************************************************************/

#include  <rtos_description.h>

/********************************************************************************************************
 ********************************************************************************************************
 *                                                   DEFINES
 ********************************************************************************************************
 *******************************************************************************************************/

/********************************************************************************************************
 *                                           TASK PRIORITIES
 *******************************************************************************************************/

//                                                                 ------------- VERY HIGH PRIORITY TASKS -------------
#ifndef  KERNEL_TICK_TASK_PRIO_DFLT
#define  KERNEL_TICK_TASK_PRIO_DFLT                            4u
#endif

#ifndef  KERNEL_TMR_TASK_PRIO_DFLT
#define  KERNEL_TMR_TASK_PRIO_DFLT                             5u
#endif

#ifndef  KERNEL_STAT_TASK_PRIO_DFLT
#define  KERNEL_STAT_TASK_PRIO_DFLT                            6u
#endif

/********************************************************************************************************
 ********************************************************************************************************
 *                                               MODULE END
 ********************************************************************************************************
 *******************************************************************************************************/

#endif // End of rtos path module include.
