/***************************************************************************//**
 * @file
 * @brief Dot matrix display driver for DISPLAY device driver interface.
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 ******************************************************************************/

#ifndef __DMD_ETM043010EDH6_H__
#define __DMD_ETM043010EDH6_H__

#include "emstatus.h"

#ifdef __cplusplus
extern "C" {
#endif

#define DMD_HORIZONTAL_SIZE         (480)
#define DMD_VERTICAL_SIZE           (272)
#define DMD_DISPLAY_BACKLIGHT_PORT  (gpioPortI)
#define DMD_DISPLAY_BACKLIGHT_PIN   (6)
#define DMD_DISPLAY_ENABLE_PORT     (gpioPortI)
#define DMD_DISPLAY_ENABLE_PIN      (1)

EMSTATUS DMD_startDrawing(void);
EMSTATUS DMD_stopDrawing(void);

#ifdef __cplusplus
}
#endif

#endif /* __DMD_ETM043010EDH6_H__ */
