/**************************************************************************//**
 * @file
 * @brief PRS Signals and Consumers enum definitions
 ******************************************************************************
 * # License
 * <b>Copyright 2025 Silicon Laboratories, Inc. www.silabs.com</b>
 ******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 *****************************************************************************/
#ifndef SL_HAL_PRS_ENUMS_H
#define SL_HAL_PRS_ENUMS_H

#include "em_device.h"

#if defined(PRS_COUNT) && (PRS_COUNT > 0)

#ifdef __cplusplus
extern "C" {
#endif

#include <stddef.h>
#include "sl_enum.h"

/***************************************************************************//**
 * @addtogroup prs
 * @{
 ******************************************************************************/

/*******************************************************************************
 ********************************   ENUMS   ************************************
 ******************************************************************************/

/// Async PRS Signals.
SL_ENUM_GENERIC(sl_hal_prs_async_producer_signal_t, uint32_t)
{
  SL_HAL_PRS_ASYNC_NONE = 0x0,                      /**< No Signal. */
#if defined(PRS_ASYNC_USART0_CS)
  SL_HAL_PRS_ASYNC_USART0_CS = PRS_ASYNC_USART0_CS, /**< USART0 CS Signal. */
#endif
#if defined(PRS_ASYNC_USART0_IRTX)
  SL_HAL_PRS_ASYNC_USART0_IRTX = PRS_ASYNC_USART0_IRTX,        /**< USART0 IRTX Signal. */
#endif
#if defined(PRS_ASYNC_USART0_RTS)
  SL_HAL_PRS_ASYNC_USART0_RTS = PRS_ASYNC_USART0_RTS,        /**< USART0 RTS Signal. */
#endif
#if defined(PRS_ASYNC_USART0_RXDATA)
  SL_HAL_PRS_ASYNC_USART0_RXDATA = PRS_ASYNC_USART0_RXDATA,        /**< USART0 RXDATA Signal. */
#endif
#if defined(PRS_ASYNC_USART0_TX)
  SL_HAL_PRS_ASYNC_USART0_TX = PRS_ASYNC_USART0_TX,        /**< USART0 TX Signal. */
#endif
#if defined(PRS_ASYNC_USART0_TXC)
  SL_HAL_PRS_ASYNC_USART0_TXC = PRS_ASYNC_USART0_TXC,        /**< USART0 TXC Signal. */
#endif
#if defined(PRS_ASYNC_USART1_CS)
  SL_HAL_PRS_ASYNC_USART1_CS = PRS_ASYNC_USART1_CS,        /**< USART1 CS Signal. */
#endif
#if defined(PRS_ASYNC_USART1_IRTX)
  SL_HAL_PRS_ASYNC_USART1_IRTX = PRS_ASYNC_USART1_IRTX,        /**< USART1 IRTX Signal. */
#endif
#if defined(PRS_ASYNC_USART1_RTS)
  SL_HAL_PRS_ASYNC_USART1_RTS = PRS_ASYNC_USART1_RTS,        /**< USART1 RTS Signal. */
#endif
#if defined(PRS_ASYNC_USART1_RXDATA)
  SL_HAL_PRS_ASYNC_USART1_RXDATA = PRS_ASYNC_USART1_RXDATA,        /**< USART1 RXDATA Signal. */
#endif
#if defined(PRS_ASYNC_USART1_TX)
  SL_HAL_PRS_ASYNC_USART1_TX = PRS_ASYNC_USART1_TX,        /**< USART1 TX Signal. */
#endif
#if defined(PRS_ASYNC_USART1_TXC)
  SL_HAL_PRS_ASYNC_USART1_TXC = PRS_ASYNC_USART1_TXC,        /**< USART1 TXC Signal. */
#endif
#if defined(PRS_ASYNC_TIMER0_UF)
  SL_HAL_PRS_ASYNC_TIMER0_UF = PRS_ASYNC_TIMER0_UF,        /**< TIMER0 UF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER0_OF)
  SL_HAL_PRS_ASYNC_TIMER0_OF = PRS_ASYNC_TIMER0_OF,        /**< TIMER0 OF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER0_CC0)
  SL_HAL_PRS_ASYNC_TIMER0_CC0 = PRS_ASYNC_TIMER0_CC0,        /**< TIMER0 CC0 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER0_CC1)
  SL_HAL_PRS_ASYNC_TIMER0_CC1 = PRS_ASYNC_TIMER0_CC1,        /**< TIMER0 CC1 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER0_CC2)
  SL_HAL_PRS_ASYNC_TIMER0_CC2 = PRS_ASYNC_TIMER0_CC2,        /**< TIMER0 CC2 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER1_UF)
  SL_HAL_PRS_ASYNC_TIMER1_UF = PRS_ASYNC_TIMER1_UF,        /**< TIMER1 UF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER1_OF)
  SL_HAL_PRS_ASYNC_TIMER1_OF = PRS_ASYNC_TIMER1_OF,        /**< TIMER1 OF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER1_CC0)
  SL_HAL_PRS_ASYNC_TIMER1_CC0 = PRS_ASYNC_TIMER1_CC0,        /**< TIMER1 CC0 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER1_CC1)
  SL_HAL_PRS_ASYNC_TIMER1_CC1 = PRS_ASYNC_TIMER1_CC1,        /**< TIMER1 CC1 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER1_CC2)
  SL_HAL_PRS_ASYNC_TIMER1_CC2 = PRS_ASYNC_TIMER1_CC2,        /**< TIMER1 CC2 Signal. */
#endif
#if defined(PRS_ASYNC_IADC0_SCANENTRYDONE)
  SL_HAL_PRS_ASYNC_IADC0_SCANENTRYDONE = PRS_ASYNC_IADC0_SCANENTRYDONE,        /**< IADC0 SCANENTRYDONE Signal. */
#endif
#if defined(PRS_ASYNC_IADC0_SCANTABLEDONE)
  SL_HAL_PRS_ASYNC_IADC0_SCANTABLEDONE = PRS_ASYNC_IADC0_SCANTABLEDONE,        /**< IADC0 SCANTABLEDONE Signal. */
#endif
#if defined(PRS_ASYNC_IADC0_SINGLEDONE)
  SL_HAL_PRS_ASYNC_IADC0_SINGLEDONE = PRS_ASYNC_IADC0_SINGLEDONE,        /**< IADC0 SINGLEDONE Signal. */
#endif
#if defined(PRS_ASYNC_LETIMER0_CH0)
  SL_HAL_PRS_ASYNC_LETIMER0_CH0 = PRS_ASYNC_LETIMER0_CH0,        /**< LETIMER0 CH0 Signal. */
#endif
#if defined(PRS_ASYNC_LETIMER0_CH1)
  SL_HAL_PRS_ASYNC_LETIMER0_CH1 = PRS_ASYNC_LETIMER0_CH1,        /**< LETIMER0 CH1 Signal. */
#endif
#if defined(PRS_ASYNC_RTCC_CCV0)
  SL_HAL_PRS_ASYNC_RTCC_CCV0 = PRS_ASYNC_RTCC_CCV0,        /**< RTCC CCV0 Signal. */
#endif
#if defined(PRS_ASYNC_RTCC_CCV1)
  SL_HAL_PRS_ASYNC_RTCC_CCV1 = PRS_ASYNC_RTCC_CCV1,        /**< RTCC CCV1 Signal. */
#endif
#if defined(PRS_ASYNC_RTCC_CCV2)
  SL_HAL_PRS_ASYNC_RTCC_CCV2 = PRS_ASYNC_RTCC_CCV2,        /**< RTCC CCV2 Signal. */
#endif
#if defined(PRS_ASYNC_BURTC_COMP)
  SL_HAL_PRS_ASYNC_BURTC_COMP = PRS_ASYNC_BURTC_COMP,        /**< BURTC COMP Signal. */
#endif
#if defined(PRS_ASYNC_BURTC_OVERFLOW)
  SL_HAL_PRS_ASYNC_BURTC_OVERFLOW = PRS_ASYNC_BURTC_OVERFLOW,        /**< BURTC OVERFLOW Signal. */
#endif
#if defined(PRS_ASYNC_GPIO_PIN0)
  SL_HAL_PRS_ASYNC_GPIO_PIN0 = PRS_ASYNC_GPIO_PIN0,        /**< GPIO PIN0 Signal. */
#endif
#if defined(PRS_ASYNC_GPIO_PIN1)
  SL_HAL_PRS_ASYNC_GPIO_PIN1 = PRS_ASYNC_GPIO_PIN1,        /**< GPIO PIN1 Signal. */
#endif
#if defined(PRS_ASYNC_GPIO_PIN2)
  SL_HAL_PRS_ASYNC_GPIO_PIN2 = PRS_ASYNC_GPIO_PIN2,        /**< GPIO PIN2 Signal. */
#endif
#if defined(PRS_ASYNC_GPIO_PIN3)
  SL_HAL_PRS_ASYNC_GPIO_PIN3 = PRS_ASYNC_GPIO_PIN3,        /**< GPIO PIN3 Signal. */
#endif
#if defined(PRS_ASYNC_GPIO_PIN4)
  SL_HAL_PRS_ASYNC_GPIO_PIN4 = PRS_ASYNC_GPIO_PIN4,        /**< GPIO PIN4 Signal. */
#endif
#if defined(PRS_ASYNC_GPIO_PIN5)
  SL_HAL_PRS_ASYNC_GPIO_PIN5 = PRS_ASYNC_GPIO_PIN5,        /**< GPIO PIN5 Signal. */
#endif
#if defined(PRS_ASYNC_GPIO_PIN6)
  SL_HAL_PRS_ASYNC_GPIO_PIN6 = PRS_ASYNC_GPIO_PIN6,        /**< GPIO PIN6 Signal. */
#endif
#if defined(PRS_ASYNC_GPIO_PIN7)
  SL_HAL_PRS_ASYNC_GPIO_PIN7 = PRS_ASYNC_GPIO_PIN7,        /**< GPIO PIN7 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER2_UF)
  SL_HAL_PRS_ASYNC_TIMER2_UF = PRS_ASYNC_TIMER2_UF,        /**< TIMER2 UF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER2_OF)
  SL_HAL_PRS_ASYNC_TIMER2_OF = PRS_ASYNC_TIMER2_OF,        /**< TIMER2 OF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER2_CC0)
  SL_HAL_PRS_ASYNC_TIMER2_CC0 = PRS_ASYNC_TIMER2_CC0,        /**< TIMER2 CC0 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER2_CC1)
  SL_HAL_PRS_ASYNC_TIMER2_CC1 = PRS_ASYNC_TIMER2_CC1,        /**< TIMER2 CC1 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER2_CC2)
  SL_HAL_PRS_ASYNC_TIMER2_CC2 = PRS_ASYNC_TIMER2_CC2,        /**< TIMER2 CC2 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER3_UF)
  SL_HAL_PRS_ASYNC_TIMER3_UF = PRS_ASYNC_TIMER3_UF,        /**< TIMER3 UF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER3_OF)
  SL_HAL_PRS_ASYNC_TIMER3_OF = PRS_ASYNC_TIMER3_OF,        /**< TIMER3 OF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER3_CC0)
  SL_HAL_PRS_ASYNC_TIMER3_CC0 = PRS_ASYNC_TIMER3_CC0,        /**< TIMER3 CC0 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER3_CC1)
  SL_HAL_PRS_ASYNC_TIMER3_CC1 = PRS_ASYNC_TIMER3_CC1,        /**< TIMER3 CC1 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER3_CC2)
  SL_HAL_PRS_ASYNC_TIMER3_CC2 = PRS_ASYNC_TIMER3_CC2,        /**< TIMER3 CC2 Signal. */
#endif
#if defined(PRS_ASYNC_CORE_CTIOUT0)
  SL_HAL_PRS_ASYNC_CORE_CTIOUT0 = PRS_ASYNC_CORE_CTIOUT0,        /**< CORE CTIOUT0 Signal. */
#endif
#if defined(PRS_ASYNC_CORE_CTIOUT1)
  SL_HAL_PRS_ASYNC_CORE_CTIOUT1 = PRS_ASYNC_CORE_CTIOUT1,        /**< CORE CTIOUT1 Signal. */
#endif
#if defined(PRS_ASYNC_CORE_CTIOUT2)
  SL_HAL_PRS_ASYNC_CORE_CTIOUT2 = PRS_ASYNC_CORE_CTIOUT2,        /**< CORE CTIOUT2 Signal. */
#endif
#if defined(PRS_ASYNC_CORE_CTIOUT3)
  SL_HAL_PRS_ASYNC_CORE_CTIOUT3 = PRS_ASYNC_CORE_CTIOUT3,        /**< CORE CTIOUT3 Signal. */
#endif
#if defined(PRS_ASYNC_CMUL_CLKOUT0)
  SL_HAL_PRS_ASYNC_CMUL_CLKOUT0 = PRS_ASYNC_CMUL_CLKOUT0,        /**< CMUL CLKOUT0 Signal. */
#endif
#if defined(PRS_ASYNC_CMUL_CLKOUT1)
  SL_HAL_PRS_ASYNC_CMUL_CLKOUT1 = PRS_ASYNC_CMUL_CLKOUT1,        /**< CMUL CLKOUT1 Signal. */
#endif
#if defined(PRS_ASYNC_CMUL_CLKOUT2)
  SL_HAL_PRS_ASYNC_CMUL_CLKOUT2 = PRS_ASYNC_CMUL_CLKOUT2,        /**< CMUL CLKOUT2 Signal. */
#endif
#if defined(PRS_ASYNC_PRORTC_CCV0)
  SL_HAL_PRS_ASYNC_PRORTC_CCV0 = PRS_ASYNC_PRORTC_CCV0,        /**< PRORTC CCV0 Signal. */
#endif
#if defined(PRS_ASYNC_PRORTC_CCV1)
  SL_HAL_PRS_ASYNC_PRORTC_CCV1 = PRS_ASYNC_PRORTC_CCV1,        /**< PRORTC CCV1 Signal. */
#endif
#if defined(PRS_ASYNC_PRSL_ASYNCH0)
  SL_HAL_PRS_ASYNC_PRSL_ASYNCH0 = PRS_ASYNC_PRSL_ASYNCH0,        /**< PRSL ASYNCH0 Signal. */
#endif
#if defined(PRS_ASYNC_PRSL_ASYNCH1)
  SL_HAL_PRS_ASYNC_PRSL_ASYNCH1 = PRS_ASYNC_PRSL_ASYNCH1,        /**< PRSL ASYNCH1 Signal. */
#endif
#if defined(PRS_ASYNC_PRSL_ASYNCH2)
  SL_HAL_PRS_ASYNC_PRSL_ASYNCH2 = PRS_ASYNC_PRSL_ASYNCH2,        /**< PRSL ASYNCH2 Signal. */
#endif
#if defined(PRS_ASYNC_PRSL_ASYNCH3)
  SL_HAL_PRS_ASYNC_PRSL_ASYNCH3 = PRS_ASYNC_PRSL_ASYNCH3,        /**< PRSL ASYNCH3 Signal. */
#endif
#if defined(PRS_ASYNC_PRSL_ASYNCH4)
  SL_HAL_PRS_ASYNC_PRSL_ASYNCH4 = PRS_ASYNC_PRSL_ASYNCH4,        /**< PRSL ASYNCH4 Signal. */
#endif
#if defined(PRS_ASYNC_PRSL_ASYNCH5)
  SL_HAL_PRS_ASYNC_PRSL_ASYNCH5 = PRS_ASYNC_PRSL_ASYNCH5,        /**< PRSL ASYNCH5 Signal. */
#endif
#if defined(PRS_ASYNC_PRSL_ASYNCH6)
  SL_HAL_PRS_ASYNC_PRSL_ASYNCH6 = PRS_ASYNC_PRSL_ASYNCH6,        /**< PRSL ASYNCH6 Signal. */
#endif
#if defined(PRS_ASYNC_PRSL_ASYNCH7)
  SL_HAL_PRS_ASYNC_PRSL_ASYNCH7 = PRS_ASYNC_PRSL_ASYNCH7,        /**< PRSL ASYNCH7 Signal. */
#endif
#if defined(PRS_ASYNC_PRS_ASYNCH8)
  SL_HAL_PRS_ASYNC_PRS_ASYNCH8 = PRS_ASYNC_PRS_ASYNCH8,        /**< PRS ASYNCH8 Signal. */
#endif
#if defined(PRS_ASYNC_PRS_ASYNCH9)
  SL_HAL_PRS_ASYNC_PRS_ASYNCH9 = PRS_ASYNC_PRS_ASYNCH9,        /**< PRS ASYNCH9 Signal. */
#endif
#if defined(PRS_ASYNC_PRS_ASYNCH10)
  SL_HAL_PRS_ASYNC_PRS_ASYNCH10 = PRS_ASYNC_PRS_ASYNCH10,        /**< PRS ASYNCH10 Signal. */
#endif
#if defined(PRS_ASYNC_PRS_ASYNCH11)
  SL_HAL_PRS_ASYNC_PRS_ASYNCH11 = PRS_ASYNC_PRS_ASYNCH11,        /**< PRS ASYNCH11 Signal. */
#endif
#if defined(PRS_ASYNC_PDML_PDMDSRPULSE)
  SL_HAL_PRS_ASYNC_PDML_PDMDSRPULSE = PRS_ASYNC_PDML_PDMDSRPULSE,        /**< PDML PDMDSRPULSE Signal. */
#endif
#if defined(PRS_ASYNC_TIMER4_UF)
  SL_HAL_PRS_ASYNC_TIMER4_UF = PRS_ASYNC_TIMER4_UF,        /**< TIMER4 UF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER4_OF)
  SL_HAL_PRS_ASYNC_TIMER4_OF = PRS_ASYNC_TIMER4_OF,        /**< TIMER4 OF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER4_CC0)
  SL_HAL_PRS_ASYNC_TIMER4_CC0 = PRS_ASYNC_TIMER4_CC0,        /**< TIMER4 CC0 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER4_CC1)
  SL_HAL_PRS_ASYNC_TIMER4_CC1 = PRS_ASYNC_TIMER4_CC1,        /**< TIMER4 CC1 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER4_CC2)
  SL_HAL_PRS_ASYNC_TIMER4_CC2 = PRS_ASYNC_TIMER4_CC2,        /**< TIMER4 CC2 Signal. */
#endif
#if defined(PRS_ASYNC_ETAMPDET_TAMPERSRCETAMPDET)
  SL_HAL_PRS_ASYNC_ETAMPDET_TAMPERSRCETAMPDET = PRS_ASYNC_ETAMPDET_TAMPERSRCETAMPDET,        /**< ETAMPDET TAMPERSRCETAMPDET Signal. */
#endif
#if defined(PRS_ASYNC_ACMP0_OUT)
  SL_HAL_PRS_ASYNC_ACMP0_OUT = PRS_ASYNC_ACMP0_OUT,        /**< ACMP0 OUT Signal. */
#endif
#if defined(PRS_ASYNC_EUSART0L_CS)
  SL_HAL_PRS_ASYNC_EUSART0L_CS = PRS_ASYNC_EUSART0L_CS,        /**< EUSART0L CS Signal. */
#endif
#if defined(PRS_ASYNC_EUSART0L_IRDATX)
  SL_HAL_PRS_ASYNC_EUSART0L_IRDATX = PRS_ASYNC_EUSART0L_IRDATX,        /**< EUSART0L IRDATX Signal. */
#endif
#if defined(PRS_ASYNC_EUSART0L_RTS)
  SL_HAL_PRS_ASYNC_EUSART0L_RTS = PRS_ASYNC_EUSART0L_RTS,        /**< EUSART0L RTS Signal. */
#endif
#if defined(PRS_ASYNC_EUSART0L_RXDATAV)
  SL_HAL_PRS_ASYNC_EUSART0L_RXDATAV = PRS_ASYNC_EUSART0L_RXDATAV,        /**< EUSART0L RXDATAV Signal. */
#endif
#if defined(PRS_ASYNC_EUSART0L_TX)
  SL_HAL_PRS_ASYNC_EUSART0L_TX = PRS_ASYNC_EUSART0L_TX,        /**< EUSART0L TX Signal. */
#endif
#if defined(PRS_ASYNC_EUSART0L_TXC)
  SL_HAL_PRS_ASYNC_EUSART0L_TXC = PRS_ASYNC_EUSART0L_TXC,        /**< EUSART0L TXC Signal. */
#endif
#if defined(PRS_ASYNC_EUSART0L_RXFL)
  SL_HAL_PRS_ASYNC_EUSART0L_RXFL = PRS_ASYNC_EUSART0L_RXFL,        /**< EUSART0L RXFL Signal. */
#endif
#if defined(PRS_ASYNC_EUSART0L_TXFL)
  SL_HAL_PRS_ASYNC_EUSART0L_TXFL = PRS_ASYNC_EUSART0L_TXFL,        /**< EUSART0L TXFL Signal. */
#endif
#if defined(PRS_ASYNC_DCDC_MONO70NSANA)
  SL_HAL_PRS_ASYNC_DCDC_MONO70NSANA = PRS_ASYNC_DCDC_MONO70NSANA,        /**< DCDC MONO70NSANA Signal. */
#endif
#if defined(PRS_ASYNC_LFRCO_CALMEAS)
  SL_HAL_PRS_ASYNC_LFRCO_CALMEAS = PRS_ASYNC_LFRCO_CALMEAS,        /**< LFRCO CALMEAS Signal. */
#endif
#if defined(PRS_ASYNC_LFRCO_SDM)
  SL_HAL_PRS_ASYNC_LFRCO_SDM = PRS_ASYNC_LFRCO_SDM,        /**< LFRCO SDM Signal. */
#endif
#if defined(PRS_ASYNC_LFRCO_TCMEAS)
  SL_HAL_PRS_ASYNC_LFRCO_TCMEAS = PRS_ASYNC_LFRCO_TCMEAS,        /**< LFRCO TCMEAS Signal. */
#endif
#if defined(PRS_ASYNC_ACMP1_OUT)
  SL_HAL_PRS_ASYNC_ACMP1_OUT = PRS_ASYNC_ACMP1_OUT,        /**< ACMP1 OUT Signal. */
#endif
#if defined(PRS_ASYNC_VDAC0L_CH0WARM)
  SL_HAL_PRS_ASYNC_VDAC0L_CH0WARM = PRS_ASYNC_VDAC0L_CH0WARM,        /**< VDAC0L CH0WARM Signal. */
#endif
#if defined(PRS_ASYNC_VDAC0L_CH1WARM)
  SL_HAL_PRS_ASYNC_VDAC0L_CH1WARM = PRS_ASYNC_VDAC0L_CH1WARM,        /**< VDAC0L CH1WARM Signal. */
#endif
#if defined(PRS_ASYNC_VDAC0L_CH0DONEASYNC)
  SL_HAL_PRS_ASYNC_VDAC0L_CH0DONEASYNC = PRS_ASYNC_VDAC0L_CH0DONEASYNC,        /**< VDAC0L CH0DONEASYNC Signal. */
#endif
#if defined(PRS_ASYNC_VDAC0L_CH1DONEASYNC)
  SL_HAL_PRS_ASYNC_VDAC0L_CH1DONEASYNC = PRS_ASYNC_VDAC0L_CH1DONEASYNC,        /**< VDAC0L CH1DONEASYNC Signal. */
#endif
#if defined(PRS_ASYNC_VDAC0L_INTERNALTIMEROF)
  SL_HAL_PRS_ASYNC_VDAC0L_INTERNALTIMEROF = PRS_ASYNC_VDAC0L_INTERNALTIMEROF,        /**< VDAC0L INTERNALTIMEROF Signal. */
#endif
#if defined(PRS_ASYNC_VDAC0L_REFRESHTIMEROF)
  SL_HAL_PRS_ASYNC_VDAC0L_REFRESHTIMEROF = PRS_ASYNC_VDAC0L_REFRESHTIMEROF,        /**< VDAC0L REFRESHTIMEROF Signal. */
#endif
#if defined(PRS_ASYNC_PCNT0_DIR)
  SL_HAL_PRS_ASYNC_PCNT0_DIR = PRS_ASYNC_PCNT0_DIR,        /**< PCNT0 DIR Signal. */
#endif
#if defined(PRS_ASYNC_PCNT0_UFOF)
  SL_HAL_PRS_ASYNC_PCNT0_UFOF = PRS_ASYNC_PCNT0_UFOF,        /**< PCNT0 UFOF Signal. */
#endif
#if defined(PRS_ASYNC_SYSRTC0_GRP0OUT0)
  SL_HAL_PRS_ASYNC_SYSRTC0_GRP0OUT0 = PRS_ASYNC_SYSRTC0_GRP0OUT0,        /**< SYSRTC0 GRP0OUT0 Signal. */
#endif
#if defined(PRS_ASYNC_SYSRTC0_GRP0OUT1)
  SL_HAL_PRS_ASYNC_SYSRTC0_GRP0OUT1 = PRS_ASYNC_SYSRTC0_GRP0OUT1,        /**< SYSRTC0 GRP0OUT1 Signal. */
#endif
#if defined(PRS_ASYNC_SYSRTC0_GRP1OUT0)
  SL_HAL_PRS_ASYNC_SYSRTC0_GRP1OUT0 = PRS_ASYNC_SYSRTC0_GRP1OUT0,        /**< SYSRTC0 GRP1OUT0 Signal. */
#endif
#if defined(PRS_ASYNC_SYSRTC0_GRP1OUT1)
  SL_HAL_PRS_ASYNC_SYSRTC0_GRP1OUT1 = PRS_ASYNC_SYSRTC0_GRP1OUT1,        /**< SYSRTC0 GRP1OUT1 Signal. */
#endif
#if defined(PRS_ASYNC_LESENSE_DECOUT0)
  SL_HAL_PRS_ASYNC_LESENSE_DECOUT0 = PRS_ASYNC_LESENSE_DECOUT0,        /**< LESENSE DECOUT0 Signal. */
#endif
#if defined(PRS_ASYNC_LESENSE_DECOUT1)
  SL_HAL_PRS_ASYNC_LESENSE_DECOUT1 = PRS_ASYNC_LESENSE_DECOUT1,        /**< LESENSE DECOUT1 Signal. */
#endif
#if defined(PRS_ASYNC_LESENSE_DECOUT2)
  SL_HAL_PRS_ASYNC_LESENSE_DECOUT2 = PRS_ASYNC_LESENSE_DECOUT2,        /**< LESENSE DECOUT2 Signal. */
#endif
#if defined(PRS_ASYNC_LESENSE_DECCMP)
  SL_HAL_PRS_ASYNC_LESENSE_DECCMP = PRS_ASYNC_LESENSE_DECCMP,        /**< LESENSE DECCMP Signal. */
#endif
#if defined(PRS_ASYNC_HFXO0L_STATUS)
  SL_HAL_PRS_ASYNC_HFXO0L_STATUS = PRS_ASYNC_HFXO0L_STATUS,        /**< HFXO0L STATUS Signal. */
#endif
#if defined(PRS_ASYNC_HFXO0L_STATUS1)
  SL_HAL_PRS_ASYNC_HFXO0L_STATUS1 = PRS_ASYNC_HFXO0L_STATUS1,        /**< HFXO0L STATUS1 Signal. */
#endif
#if defined(PRS_ASYNC_EUSART1L_CS)
  SL_HAL_PRS_ASYNC_EUSART1L_CS = PRS_ASYNC_EUSART1L_CS,        /**< EUSART1L CS Signal. */
#endif
#if defined(PRS_ASYNC_EUSART1L_IRDATX)
  SL_HAL_PRS_ASYNC_EUSART1L_IRDATX = PRS_ASYNC_EUSART1L_IRDATX,        /**< EUSART1L IRDATX Signal. */
#endif
#if defined(PRS_ASYNC_EUSART1L_RTS)
  SL_HAL_PRS_ASYNC_EUSART1L_RTS = PRS_ASYNC_EUSART1L_RTS,        /**< EUSART1L RTS Signal. */
#endif
#if defined(PRS_ASYNC_EUSART1L_RXDATAV)
  SL_HAL_PRS_ASYNC_EUSART1L_RXDATAV = PRS_ASYNC_EUSART1L_RXDATAV,        /**< EUSART1L RXDATAV Signal. */
#endif
#if defined(PRS_ASYNC_EUSART1L_TX)
  SL_HAL_PRS_ASYNC_EUSART1L_TX = PRS_ASYNC_EUSART1L_TX,        /**< EUSART1L TX Signal. */
#endif
#if defined(PRS_ASYNC_EUSART1L_TXC)
  SL_HAL_PRS_ASYNC_EUSART1L_TXC = PRS_ASYNC_EUSART1L_TXC,        /**< EUSART1L TXC Signal. */
#endif
#if defined(PRS_ASYNC_EUSART1L_RXFL)
  SL_HAL_PRS_ASYNC_EUSART1L_RXFL = PRS_ASYNC_EUSART1L_RXFL,        /**< EUSART1L RXFL Signal. */
#endif
#if defined(PRS_ASYNC_EUSART1L_TXFL)
  SL_HAL_PRS_ASYNC_EUSART1L_TXFL = PRS_ASYNC_EUSART1L_TXFL,        /**< EUSART1L TXFL Signal. */
#endif
#if defined(PRS_ASYNC_EUSART2L_CS)
  SL_HAL_PRS_ASYNC_EUSART2L_CS = PRS_ASYNC_EUSART2L_CS,        /**< EUSART2L CS Signal. */
#endif
#if defined(PRS_ASYNC_EUSART2L_IRDATX)
  SL_HAL_PRS_ASYNC_EUSART2L_IRDATX = PRS_ASYNC_EUSART2L_IRDATX,        /**< EUSART2L IRDATX Signal. */
#endif
#if defined(PRS_ASYNC_EUSART2L_RTS)
  SL_HAL_PRS_ASYNC_EUSART2L_RTS = PRS_ASYNC_EUSART2L_RTS,        /**< EUSART2L RTS Signal. */
#endif
#if defined(PRS_ASYNC_EUSART2L_RXDATAV)
  SL_HAL_PRS_ASYNC_EUSART2L_RXDATAV = PRS_ASYNC_EUSART2L_RXDATAV,        /**< EUSART2L RXDATAV Signal. */
#endif
#if defined(PRS_ASYNC_EUSART2L_TX)
  SL_HAL_PRS_ASYNC_EUSART2L_TX = PRS_ASYNC_EUSART2L_TX,        /**< EUSART2L TX Signal. */
#endif
#if defined(PRS_ASYNC_EUSART2L_TXC)
  SL_HAL_PRS_ASYNC_EUSART2L_TXC = PRS_ASYNC_EUSART2L_TXC,        /**< EUSART2L TXC Signal. */
#endif
#if defined(PRS_ASYNC_EUSART2L_RXFL)
  SL_HAL_PRS_ASYNC_EUSART2L_RXFL = PRS_ASYNC_EUSART2L_RXFL,        /**< EUSART2L RXFL Signal. */
#endif
#if defined(PRS_ASYNC_EUSART2L_TXFL)
  SL_HAL_PRS_ASYNC_EUSART2L_TXFL = PRS_ASYNC_EUSART2L_TXFL,        /**< EUSART2L TXFL Signal. */
#endif
#if defined(PRS_ASYNC_VDAC1L_CH1WARM)
  SL_HAL_PRS_ASYNC_VDAC1L_CH1WARM = PRS_ASYNC_VDAC1L_CH1WARM,        /**< VDAC1L CH1WARM Signal. */
#endif
#if defined(PRS_ASYNC_VDAC1L_CH0WARM)
  SL_HAL_PRS_ASYNC_VDAC1L_CH0WARM = PRS_ASYNC_VDAC1L_CH0WARM,        /**< VDAC1L CH0WARM Signal. */
#endif
#if defined(PRS_ASYNC_VDAC1L_CH0DONEASYNC)
  SL_HAL_PRS_ASYNC_VDAC1L_CH0DONEASYNC = PRS_ASYNC_VDAC1L_CH0DONEASYNC,        /**< VDAC1L CH0DONEASYNC Signal. */
#endif
#if defined(PRS_ASYNC_VDAC1L_REFRESHTIMEROF)
  SL_HAL_PRS_ASYNC_VDAC1L_REFRESHTIMEROF = PRS_ASYNC_VDAC1L_REFRESHTIMEROF,        /**< VDAC1L REFRESHTIMEROF Signal. */
#endif
#if defined(PRS_ASYNC_VDAC1L_INTERNALTIMEROF)
  SL_HAL_PRS_ASYNC_VDAC1L_INTERNALTIMEROF = PRS_ASYNC_VDAC1L_INTERNALTIMEROF,        /**< VDAC1L INTERNALTIMEROF Signal. */
#endif
#if defined(PRS_ASYNC_VDAC1L_CH1DONEASYNC)
  SL_HAL_PRS_ASYNC_VDAC1L_CH1DONEASYNC = PRS_ASYNC_VDAC1L_CH1DONEASYNC,        /**< VDAC1L CH1DONEASYNC Signal. */
#endif
#if defined(PRS_ASYNC_TIMER5_UF)
  SL_HAL_PRS_ASYNC_TIMER5_UF = PRS_ASYNC_TIMER5_UF,        /**< TIMER5 UF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER5_OF)
  SL_HAL_PRS_ASYNC_TIMER5_OF = PRS_ASYNC_TIMER5_OF,        /**< TIMER5 OF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER5_CC0)
  SL_HAL_PRS_ASYNC_TIMER5_CC0 = PRS_ASYNC_TIMER5_CC0,        /**< TIMER5 CC0 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER5_CC1)
  SL_HAL_PRS_ASYNC_TIMER5_CC1 = PRS_ASYNC_TIMER5_CC1,        /**< TIMER5 CC1 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER5_CC2)
  SL_HAL_PRS_ASYNC_TIMER5_CC2 = PRS_ASYNC_TIMER5_CC2,        /**< TIMER5 CC2 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER6_UF)
  SL_HAL_PRS_ASYNC_TIMER6_UF = PRS_ASYNC_TIMER6_UF,        /**< TIMER6 UF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER6_OF)
  SL_HAL_PRS_ASYNC_TIMER6_OF = PRS_ASYNC_TIMER6_OF,        /**< TIMER6 OF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER6_CC0)
  SL_HAL_PRS_ASYNC_TIMER6_CC0 = PRS_ASYNC_TIMER6_CC0,        /**< TIMER6 CC0 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER6_CC1)
  SL_HAL_PRS_ASYNC_TIMER6_CC1 = PRS_ASYNC_TIMER6_CC1,        /**< TIMER6 CC1 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER6_CC2)
  SL_HAL_PRS_ASYNC_TIMER6_CC2 = PRS_ASYNC_TIMER6_CC2,        /**< TIMER6 CC2 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER7_UF)
  SL_HAL_PRS_ASYNC_TIMER7_UF = PRS_ASYNC_TIMER7_UF,        /**< TIMER7 UF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER7_OF)
  SL_HAL_PRS_ASYNC_TIMER7_OF = PRS_ASYNC_TIMER7_OF,        /**< TIMER7 OF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER7_CC0)
  SL_HAL_PRS_ASYNC_TIMER7_CC0 = PRS_ASYNC_TIMER7_CC0,        /**< TIMER7 CC0 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER7_CC1)
  SL_HAL_PRS_ASYNC_TIMER7_CC1 = PRS_ASYNC_TIMER7_CC1,        /**< TIMER7 CC1 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER7_CC2)
  SL_HAL_PRS_ASYNC_TIMER7_CC2 = PRS_ASYNC_TIMER7_CC2,        /**< TIMER7 CC2 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER8_UF)
  SL_HAL_PRS_ASYNC_TIMER8_UF = PRS_ASYNC_TIMER8_UF,        /**< TIMER8 UF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER8_OF)
  SL_HAL_PRS_ASYNC_TIMER8_OF = PRS_ASYNC_TIMER8_OF,        /**< TIMER8 OF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER8_CC0)
  SL_HAL_PRS_ASYNC_TIMER8_CC0 = PRS_ASYNC_TIMER8_CC0,        /**< TIMER8 CC0 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER8_CC1)
  SL_HAL_PRS_ASYNC_TIMER8_CC1 = PRS_ASYNC_TIMER8_CC1,        /**< TIMER8 CC1 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER8_CC2)
  SL_HAL_PRS_ASYNC_TIMER8_CC2 = PRS_ASYNC_TIMER8_CC2,        /**< TIMER8 CC2 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER9_UF)
  SL_HAL_PRS_ASYNC_TIMER9_UF = PRS_ASYNC_TIMER9_UF,        /**< TIMER9 UF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER9_OF)
  SL_HAL_PRS_ASYNC_TIMER9_OF = PRS_ASYNC_TIMER9_OF,        /**< TIMER9 OF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER9_CC0)
  SL_HAL_PRS_ASYNC_TIMER9_CC0 = PRS_ASYNC_TIMER9_CC0,        /**< TIMER9 CC0 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER9_CC1)
  SL_HAL_PRS_ASYNC_TIMER9_CC1 = PRS_ASYNC_TIMER9_CC1,        /**< TIMER9 CC1 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER9_CC2)
  SL_HAL_PRS_ASYNC_TIMER9_CC2 = PRS_ASYNC_TIMER9_CC2,        /**< TIMER9 CC2 Signal. */
#endif
#if defined(PRS_ASYNC_USART2_CS)
  SL_HAL_PRS_ASYNC_USART2_CS = PRS_ASYNC_USART2_CS,        /**< USART2 CS Signal. */
#endif
#if defined(PRS_ASYNC_USART2_IRTX)
  SL_HAL_PRS_ASYNC_USART2_IRTX = PRS_ASYNC_USART2_IRTX,        /**< USART2 IRTX Signal. */
#endif
#if defined(PRS_ASYNC_USART2_RTS)
  SL_HAL_PRS_ASYNC_USART2_RTS = PRS_ASYNC_USART2_RTS,        /**< USART2 RTS Signal. */
#endif
#if defined(PRS_ASYNC_USART2_RXDATA)
  SL_HAL_PRS_ASYNC_USART2_RXDATA = PRS_ASYNC_USART2_RXDATA,        /**< USART2 RXDATA Signal. */
#endif
#if defined(PRS_ASYNC_USART2_TX)
  SL_HAL_PRS_ASYNC_USART2_TX = PRS_ASYNC_USART2_TX,        /**< USART2 TX Signal. */
#endif
#if defined(PRS_ASYNC_USART2_TXC)
  SL_HAL_PRS_ASYNC_USART2_TXC = PRS_ASYNC_USART2_TXC,        /**< USART2 TXC Signal. */
#endif
#if defined(PRS_ASYNC_EUSART2_CS)
  SL_HAL_PRS_ASYNC_EUSART2_CS = PRS_ASYNC_EUSART2_CS,        /**< EUSART2 CS Signal. */
#endif
#if defined(PRS_ASYNC_EUSART2_IRDATX)
  SL_HAL_PRS_ASYNC_EUSART2_IRDATX = PRS_ASYNC_EUSART2_IRDATX,        /**< EUSART2 IRDATX Signal. */
#endif
#if defined(PRS_ASYNC_EUSART2_RTS)
  SL_HAL_PRS_ASYNC_EUSART2_RTS = PRS_ASYNC_EUSART2_RTS,        /**< EUSART2 RTS Signal. */
#endif
#if defined(PRS_ASYNC_EUSART2_RXDATAV)
  SL_HAL_PRS_ASYNC_EUSART2_RXDATAV = PRS_ASYNC_EUSART2_RXDATAV,        /**< EUSART2 RXDATAV Signal. */
#endif
#if defined(PRS_ASYNC_EUSART2_RXFL)
  SL_HAL_PRS_ASYNC_EUSART2_RXFL = PRS_ASYNC_EUSART2_RXFL,        /**< EUSART2 RXFL Signal. */
#endif
#if defined(PRS_ASYNC_EUSART2_TX)
  SL_HAL_PRS_ASYNC_EUSART2_TX = PRS_ASYNC_EUSART2_TX,        /**< EUSART2 TX Signal. */
#endif
#if defined(PRS_ASYNC_EUSART2_TXC)
  SL_HAL_PRS_ASYNC_EUSART2_TXC = PRS_ASYNC_EUSART2_TXC,        /**< EUSART2 TXC Signal. */
#endif
#if defined(PRS_ASYNC_EUSART2_TXFL)
  SL_HAL_PRS_ASYNC_EUSART2_TXFL = PRS_ASYNC_EUSART2_TXFL,        /**< EUSART2 TXFL Signal. */
#endif
#if defined(PRS_ASYNC_EUSART3_CS)
  SL_HAL_PRS_ASYNC_EUSART3_CS = PRS_ASYNC_EUSART3_CS,        /**< EUSART3 CS Signal. */
#endif
#if defined(PRS_ASYNC_EUSART3_IRDATX)
  SL_HAL_PRS_ASYNC_EUSART3_IRDATX = PRS_ASYNC_EUSART3_IRDATX,        /**< EUSART3 IRDATX Signal. */
#endif
#if defined(PRS_ASYNC_EUSART3_RTS)
  SL_HAL_PRS_ASYNC_EUSART3_RTS = PRS_ASYNC_EUSART3_RTS,        /**< EUSART3 RTS Signal. */
#endif
#if defined(PRS_ASYNC_EUSART3_RXDATAV)
  SL_HAL_PRS_ASYNC_EUSART3_RXDATAV = PRS_ASYNC_EUSART3_RXDATAV,        /**< EUSART3 RXDATAV Signal. */
#endif
#if defined(PRS_ASYNC_EUSART3_RXFL)
  SL_HAL_PRS_ASYNC_EUSART3_RXFL = PRS_ASYNC_EUSART3_RXFL,        /**< EUSART3 RXFL Signal. */
#endif
#if defined(PRS_ASYNC_EUSART3_TX)
  SL_HAL_PRS_ASYNC_EUSART3_TX = PRS_ASYNC_EUSART3_TX,        /**< EUSART3 TX Signal. */
#endif
#if defined(PRS_ASYNC_EUSART3_TXC)
  SL_HAL_PRS_ASYNC_EUSART3_TXC = PRS_ASYNC_EUSART3_TXC,        /**< EUSART3 TXC Signal. */
#endif
#if defined(PRS_ASYNC_EUSART3_TXFL)
  SL_HAL_PRS_ASYNC_EUSART3_TXFL = PRS_ASYNC_EUSART3_TXFL,        /**< EUSART3 TXFL Signal. */
#endif
#if defined(PRS_ASYNC_BUFC_THR0)
  SL_HAL_PRS_ASYNC_BUFC_THR0 = PRS_ASYNC_BUFC_THR0,        /**< BUFC THR0 Signal. */
#endif
#if defined(PRS_ASYNC_BUFC_THR1)
  SL_HAL_PRS_ASYNC_BUFC_THR1 = PRS_ASYNC_BUFC_THR1,        /**< BUFC THR1 Signal. */
#endif
#if defined(PRS_ASYNC_BUFC_THR2)
  SL_HAL_PRS_ASYNC_BUFC_THR2 = PRS_ASYNC_BUFC_THR2,        /**< BUFC THR2 Signal. */
#endif
#if defined(PRS_ASYNC_BUFC_THR3)
  SL_HAL_PRS_ASYNC_BUFC_THR3 = PRS_ASYNC_BUFC_THR3,        /**< BUFC THR3 Signal. */
#endif
#if defined(PRS_ASYNC_BUFC_CNT0)
  SL_HAL_PRS_ASYNC_BUFC_CNT0 = PRS_ASYNC_BUFC_CNT0,        /**< BUFC CNT0 Signal. */
#endif
#if defined(PRS_ASYNC_BUFC_CNT1)
  SL_HAL_PRS_ASYNC_BUFC_CNT1 = PRS_ASYNC_BUFC_CNT1,        /**< BUFC CNT1 Signal. */
#endif
#if defined(PRS_ASYNC_BUFC_FULL)
  SL_HAL_PRS_ASYNC_BUFC_FULL = PRS_ASYNC_BUFC_FULL,        /**< BUFC FULL Signal. */
#endif
#if defined(PRS_ASYNC_BUFCL_AHBMBUSY)
  SL_HAL_PRS_ASYNC_BUFCL_AHBMBUSY = PRS_ASYNC_BUFCL_AHBMBUSY,        /**< BUFCL AHBMBUSY Signal. */
#endif
#if defined(PRS_ASYNC_BUFCL_HOSTCLKREQ)
  SL_HAL_PRS_ASYNC_BUFCL_HOSTCLKREQ = PRS_ASYNC_BUFCL_HOSTCLKREQ,        /**< BUFCL HOSTCLKREQ Signal. */
#endif
#if defined(PRS_ASYNC_BUFCL_BUFBUSY0)
  SL_HAL_PRS_ASYNC_BUFCL_BUFBUSY0 = PRS_ASYNC_BUFCL_BUFBUSY0,        /**< BUFCL BUFBUSY0 Signal. */
#endif
#if defined(PRS_ASYNC_BUFC_BUFBUSY1)
  SL_HAL_PRS_ASYNC_BUFC_BUFBUSY1 = PRS_ASYNC_BUFC_BUFBUSY1,        /**< BUFC BUFBUSY1 Signal. */
#endif
#if defined(PRS_ASYNC_BUFC_BUFBUSY2)
  SL_HAL_PRS_ASYNC_BUFC_BUFBUSY2 = PRS_ASYNC_BUFC_BUFBUSY2,        /**< BUFC BUFBUSY2 Signal. */
#endif
#if defined(PRS_ASYNC_BUFC_BUFBUSY3)
  SL_HAL_PRS_ASYNC_BUFC_BUFBUSY3 = PRS_ASYNC_BUFC_BUFBUSY3,        /**< BUFC BUFBUSY3 Signal. */
#endif
#if defined(PRS_ASYNC_EUSART3L_CS)
  SL_HAL_PRS_ASYNC_EUSART3L_CS = PRS_ASYNC_EUSART3L_CS,        /**< EUSART3L CS Signal. */
#endif
#if defined(PRS_ASYNC_EUSART3L_IRDATX)
  SL_HAL_PRS_ASYNC_EUSART3L_IRDATX = PRS_ASYNC_EUSART3L_IRDATX,        /**< EUSART3L IRDATX Signal. */
#endif
#if defined(PRS_ASYNC_EUSART3L_RTS)
  SL_HAL_PRS_ASYNC_EUSART3L_RTS = PRS_ASYNC_EUSART3L_RTS,        /**< EUSART3L RTS Signal. */
#endif
#if defined(PRS_ASYNC_EUSART3L_RXDATAV)
  SL_HAL_PRS_ASYNC_EUSART3L_RXDATAV = PRS_ASYNC_EUSART3L_RXDATAV,        /**< EUSART3L RXDATAV Signal. */
#endif
#if defined(PRS_ASYNC_EUSART3L_RXFL)
  SL_HAL_PRS_ASYNC_EUSART3L_RXFL = PRS_ASYNC_EUSART3L_RXFL,        /**< EUSART3L RXFL Signal. */
#endif
#if defined(PRS_ASYNC_EUSART3L_TX)
  SL_HAL_PRS_ASYNC_EUSART3L_TX = PRS_ASYNC_EUSART3L_TX,        /**< EUSART3L TX Signal. */
#endif
#if defined(PRS_ASYNC_EUSART3L_TXC)
  SL_HAL_PRS_ASYNC_EUSART3L_TXC = PRS_ASYNC_EUSART3L_TXC,        /**< EUSART3L TXC Signal. */
#endif
#if defined(PRS_ASYNC_EUSART3L_TXFL)
  SL_HAL_PRS_ASYNC_EUSART3L_TXFL = PRS_ASYNC_EUSART3L_TXFL,        /**< EUSART3L TXFL Signal. */
#endif
#if defined(PRS_ASYNC_EUSART4L_CS)
  SL_HAL_PRS_ASYNC_EUSART4L_CS = PRS_ASYNC_EUSART4L_CS,        /**< EUSART4L CS Signal. */
#endif
#if defined(PRS_ASYNC_EUSART4L_IRDATX)
  SL_HAL_PRS_ASYNC_EUSART4L_IRDATX = PRS_ASYNC_EUSART4L_IRDATX,        /**< EUSART4L IRDATX Signal. */
#endif
#if defined(PRS_ASYNC_EUSART4L_RTS)
  SL_HAL_PRS_ASYNC_EUSART4L_RTS = PRS_ASYNC_EUSART4L_RTS,        /**< EUSART4L RTS Signal. */
#endif
#if defined(PRS_ASYNC_EUSART4L_RXDATAV)
  SL_HAL_PRS_ASYNC_EUSART4L_RXDATAV = PRS_ASYNC_EUSART4L_RXDATAV,        /**< EUSART4L RXDATAV Signal. */
#endif
#if defined(PRS_ASYNC_EUSART4L_RXFL)
  SL_HAL_PRS_ASYNC_EUSART4L_RXFL = PRS_ASYNC_EUSART4L_RXFL,        /**< EUSART4L RXFL Signal. */
#endif
#if defined(PRS_ASYNC_EUSART4L_TX)
  SL_HAL_PRS_ASYNC_EUSART4L_TX = PRS_ASYNC_EUSART4L_TX,        /**< EUSART4L TX Signal. */
#endif
#if defined(PRS_ASYNC_EUSART4L_TXC)
  SL_HAL_PRS_ASYNC_EUSART4L_TXC = PRS_ASYNC_EUSART4L_TXC,        /**< EUSART4L TXC Signal. */
#endif
#if defined(PRS_ASYNC_EUSART4L_TXFL)
  SL_HAL_PRS_ASYNC_EUSART4L_TXFL = PRS_ASYNC_EUSART4L_TXFL,        /**< EUSART4L TXFL Signal. */
#endif
#if defined(PRS_ASYNC_RFFPLL0L_CLKDIGDIV4)
  SL_HAL_PRS_ASYNC_RFFPLL0L_CLKDIGDIV4 = PRS_ASYNC_RFFPLL0L_CLKDIGDIV4,        /**< RFFPLL0L CLKDIGDIV4 Signal. */
#endif
#if defined(PRS_ASYNC_RFFPLL0L_CLKMODEMDIV4)
  SL_HAL_PRS_ASYNC_RFFPLL0L_CLKMODEMDIV4 = PRS_ASYNC_RFFPLL0L_CLKMODEMDIV4,        /**< RFFPLL0L CLKMODEMDIV4 Signal. */
#endif
#if defined(PRS_ASYNC_EUART0_IRDATX)
  SL_HAL_PRS_ASYNC_EUART0_IRDATX = PRS_ASYNC_EUART0_IRDATX,        /**< EUART0 IRDATX Signal. */
#endif
#if defined(PRS_ASYNC_EUART0_RTS)
  SL_HAL_PRS_ASYNC_EUART0_RTS = PRS_ASYNC_EUART0_RTS,        /**< EUART0 RTS Signal. */
#endif
#if defined(PRS_ASYNC_EUART0_TX)
  SL_HAL_PRS_ASYNC_EUART0_TX = PRS_ASYNC_EUART0_TX,        /**< EUART0 TX Signal. */
#endif
#if defined(PRS_ASYNC_EUART0_TXC)
  SL_HAL_PRS_ASYNC_EUART0_TXC = PRS_ASYNC_EUART0_TXC,        /**< EUART0 TXC Signal. */
#endif
#if defined(PRS_ASYNC_EUART0_RXFL)
  SL_HAL_PRS_ASYNC_EUART0_RXFL = PRS_ASYNC_EUART0_RXFL,        /**< EUART0 RXFL Signal. */
#endif
#if defined(PRS_ASYNC_TIMER2L_UF)
  SL_HAL_PRS_ASYNC_TIMER2L_UF = PRS_ASYNC_TIMER2L_UF,        /**< TIMER2L UF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER2L_OF)
  SL_HAL_PRS_ASYNC_TIMER2L_OF = PRS_ASYNC_TIMER2L_OF,        /**< TIMER2L OF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER2L_CC0)
  SL_HAL_PRS_ASYNC_TIMER2L_CC0 = PRS_ASYNC_TIMER2L_CC0,        /**< TIMER2L CC0 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER2L_CC1)
  SL_HAL_PRS_ASYNC_TIMER2L_CC1 = PRS_ASYNC_TIMER2L_CC1,        /**< TIMER2L CC1 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER2L_CC2)
  SL_HAL_PRS_ASYNC_TIMER2L_CC2 = PRS_ASYNC_TIMER2L_CC2,        /**< TIMER2L CC2 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER2L_CC3)
  SL_HAL_PRS_ASYNC_TIMER2L_CC3 = PRS_ASYNC_TIMER2L_CC3,        /**< TIMER2L CC3 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER2L_CC4)
  SL_HAL_PRS_ASYNC_TIMER2L_CC4 = PRS_ASYNC_TIMER2L_CC4,        /**< TIMER2L CC4 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER2L_CC5)
  SL_HAL_PRS_ASYNC_TIMER2L_CC5 = PRS_ASYNC_TIMER2L_CC5,        /**< TIMER2L CC5 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER2_CC6)
  SL_HAL_PRS_ASYNC_TIMER2_CC6 = PRS_ASYNC_TIMER2_CC6,        /**< TIMER2 CC6 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER3L_UF)
  SL_HAL_PRS_ASYNC_TIMER3L_UF = PRS_ASYNC_TIMER3L_UF,        /**< TIMER3L UF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER3L_OF)
  SL_HAL_PRS_ASYNC_TIMER3L_OF = PRS_ASYNC_TIMER3L_OF,        /**< TIMER3L OF Signal. */
#endif
#if defined(PRS_ASYNC_TIMER3L_CC0)
  SL_HAL_PRS_ASYNC_TIMER3L_CC0 = PRS_ASYNC_TIMER3L_CC0,        /**< TIMER3L CC0 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER3L_CC1)
  SL_HAL_PRS_ASYNC_TIMER3L_CC1 = PRS_ASYNC_TIMER3L_CC1,        /**< TIMER3L CC1 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER3L_CC2)
  SL_HAL_PRS_ASYNC_TIMER3L_CC2 = PRS_ASYNC_TIMER3L_CC2,        /**< TIMER3L CC2 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER3L_CC3)
  SL_HAL_PRS_ASYNC_TIMER3L_CC3 = PRS_ASYNC_TIMER3L_CC3,        /**< TIMER3L CC3 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER3L_CC4)
  SL_HAL_PRS_ASYNC_TIMER3L_CC4 = PRS_ASYNC_TIMER3L_CC4,        /**< TIMER3L CC4 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER3L_CC5)
  SL_HAL_PRS_ASYNC_TIMER3L_CC5 = PRS_ASYNC_TIMER3L_CC5,        /**< TIMER3L CC5 Signal. */
#endif
#if defined(PRS_ASYNC_TIMER3_CC6)
  SL_HAL_PRS_ASYNC_TIMER3_CC6 = PRS_ASYNC_TIMER3_CC6,        /**< TIMER3 CC6 Signal. */
#endif
#if defined(PRS_ASYNC_ADC0_SCANENTRYDONE)
  SL_HAL_PRS_ASYNC_ADC0_SCANENTRYDONE = PRS_ASYNC_ADC0_SCANENTRYDONE,        /**< ADC0 SCANENTRYDONE Signal. */
#endif
#if defined(PRS_ASYNC_ADC0_SCANTABLEDONE)
  SL_HAL_PRS_ASYNC_ADC0_SCANTABLEDONE = PRS_ASYNC_ADC0_SCANTABLEDONE,        /**< ADC0 SCANTABLEDONE Signal. */
#endif
#if defined(PRS_ASYNC_ADC0_DEBUG)
  SL_HAL_PRS_ASYNC_ADC0_DEBUG = PRS_ASYNC_ADC0_DEBUG,        /**< ADC0 DEBUG Signal. */
#endif
#if defined(PRS_ASYNC_ADC0_DEBUG1)
  SL_HAL_PRS_ASYNC_ADC0_DEBUG1 = PRS_ASYNC_ADC0_DEBUG1,        /**< ADC0 DEBUG1 Signal. */
#endif
#if defined(PRS_ASYNC_ADC0_DEBUG2)
  SL_HAL_PRS_ASYNC_ADC0_DEBUG2 = PRS_ASYNC_ADC0_DEBUG2,        /**< ADC0 DEBUG2 Signal. */
#endif
#if defined(PRS_ASYNC_ADC0_DEBUG3)
  SL_HAL_PRS_ASYNC_ADC0_DEBUG3 = PRS_ASYNC_ADC0_DEBUG3,        /**< ADC0 DEBUG3 Signal. */
#endif
#if defined(PRS_ASYNC_ADC0_DEBUG4)
  SL_HAL_PRS_ASYNC_ADC0_DEBUG4 = PRS_ASYNC_ADC0_DEBUG4,        /**< ADC0 DEBUG4 Signal. */
#endif
#if defined(PRS_ASYNC_FSRCO_CLKENHV)
  SL_HAL_PRS_ASYNC_FSRCO_CLKENHV = PRS_ASYNC_FSRCO_CLKENHV,        /**< FSRCO CLKENHV Signal. */
#endif
#if defined(PRS_ASYNC_FSRCO_CLKENLV)
  SL_HAL_PRS_ASYNC_FSRCO_CLKENLV = PRS_ASYNC_FSRCO_CLKENLV,        /**< FSRCO CLKENLV Signal. */
#endif
#if defined(PRS_ASYNC_FSRCO_CLKRAWHV)
  SL_HAL_PRS_ASYNC_FSRCO_CLKRAWHV = PRS_ASYNC_FSRCO_CLKRAWHV,        /**< FSRCO CLKRAWHV Signal. */
#endif
#if defined(PRS_ASYNC_FSRCO_CLKRAWLV)
  SL_HAL_PRS_ASYNC_FSRCO_CLKRAWLV = PRS_ASYNC_FSRCO_CLKRAWLV,        /**< FSRCO CLKRAWLV Signal. */
#endif
#if defined(PRS_ASYNC_HFRCO0_CLKPD1RAW)
  SL_HAL_PRS_ASYNC_HFRCO0_CLKPD1RAW = PRS_ASYNC_HFRCO0_CLKPD1RAW,        /**< HFRCO0 CLKPD1RAW Signal. */
#endif
#if defined(PRS_ASYNC_HFRCOEM23_CLKPD1RAW)
  SL_HAL_PRS_ASYNC_HFRCOEM23_CLKPD1RAW = PRS_ASYNC_HFRCOEM23_CLKPD1RAW,        /**< HFRCOEM23 CLKPD1RAW Signal. */
#endif
#if defined(PRS_ASYNC_SOCPLL0_SOCPLLDBG0)
  SL_HAL_PRS_ASYNC_SOCPLL0_SOCPLLDBG0 = PRS_ASYNC_SOCPLL0_SOCPLLDBG0,        /**< SOCPLL0 SOCPLLDBG0 Signal. */
#endif
#if defined(PRS_ASYNC_SOCPLL0_SOCPLLDBG1)
  SL_HAL_PRS_ASYNC_SOCPLL0_SOCPLLDBG1 = PRS_ASYNC_SOCPLL0_SOCPLLDBG1,        /**< SOCPLL0 SOCPLLDBG1 Signal. */
#endif
#if defined(PRS_ASYNC_SOCPLL0_SOCPLLDBG2)
  SL_HAL_PRS_ASYNC_SOCPLL0_SOCPLLDBG2 = PRS_ASYNC_SOCPLL0_SOCPLLDBG2,        /**< SOCPLL0 SOCPLLDBG2 Signal. */
#endif
#if defined(PRS_ASYNC_SOCPLL0_SOCPLLDBG3)
  SL_HAL_PRS_ASYNC_SOCPLL0_SOCPLLDBG3 = PRS_ASYNC_SOCPLL0_SOCPLLDBG3,        /**< SOCPLL0 SOCPLLDBG3 Signal. */
#endif
#if defined(PRS_ASYNC_PIXELRZ0_PIXELDBGSTATE0)
  SL_HAL_PRS_ASYNC_PIXELRZ0_PIXELDBGSTATE0 = PRS_ASYNC_PIXELRZ0_PIXELDBGSTATE0,        /**< PIXELRZ0 PIXELDBGSTATE0 Signal. */
#endif
#if defined(PRS_ASYNC_PIXELRZ0_PIXELDBGSTATE1)
  SL_HAL_PRS_ASYNC_PIXELRZ0_PIXELDBGSTATE1 = PRS_ASYNC_PIXELRZ0_PIXELDBGSTATE1,        /**< PIXELRZ0 PIXELDBGSTATE1 Signal. */
#endif
#if defined(PRS_ASYNC_PIXELRZ0_PIXELDBGSTATE2)
  SL_HAL_PRS_ASYNC_PIXELRZ0_PIXELDBGSTATE2 = PRS_ASYNC_PIXELRZ0_PIXELDBGSTATE2,        /**< PIXELRZ0 PIXELDBGSTATE2 Signal. */
#endif
#if defined(PRS_ASYNC_PIXELRZ0_PIXELDBGSTATE3)
  SL_HAL_PRS_ASYNC_PIXELRZ0_PIXELDBGSTATE3 = PRS_ASYNC_PIXELRZ0_PIXELDBGSTATE3,        /**< PIXELRZ0 PIXELDBGSTATE3 Signal. */
#endif
#if defined(PRS_ASYNC_PIXELRZ1_PIXELDBGSTATE0)
  SL_HAL_PRS_ASYNC_PIXELRZ1_PIXELDBGSTATE0 = PRS_ASYNC_PIXELRZ1_PIXELDBGSTATE0,        /**< PIXELRZ1 PIXELDBGSTATE0 Signal. */
#endif
#if defined(PRS_ASYNC_PIXELRZ1_PIXELDBGSTATE1)
  SL_HAL_PRS_ASYNC_PIXELRZ1_PIXELDBGSTATE1 = PRS_ASYNC_PIXELRZ1_PIXELDBGSTATE1,        /**< PIXELRZ1 PIXELDBGSTATE1 Signal. */
#endif
#if defined(PRS_ASYNC_PIXELRZ1_PIXELDBGSTATE2)
  SL_HAL_PRS_ASYNC_PIXELRZ1_PIXELDBGSTATE2 = PRS_ASYNC_PIXELRZ1_PIXELDBGSTATE2,        /**< PIXELRZ1 PIXELDBGSTATE2 Signal. */
#endif
#if defined(PRS_ASYNC_PIXELRZ1_PIXELDBGSTATE3)
  SL_HAL_PRS_ASYNC_PIXELRZ1_PIXELDBGSTATE3 = PRS_ASYNC_PIXELRZ1_PIXELDBGSTATE3,        /**< PIXELRZ1 PIXELDBGSTATE3 Signal. */
#endif
#if defined(PRS_ASYNC_LEDDRV0_LEDDRVDBG0)
  SL_HAL_PRS_ASYNC_LEDDRV0_LEDDRVDBG0 = PRS_ASYNC_LEDDRV0_LEDDRVDBG0,        /**< LEDDRV0 LEDDRVDBG0 Signal. */
#endif
#if defined(PRS_ASYNC_LEDDRV0_LEDDRVDBG1)
  SL_HAL_PRS_ASYNC_LEDDRV0_LEDDRVDBG1 = PRS_ASYNC_LEDDRV0_LEDDRVDBG1,        /**< LEDDRV0 LEDDRVDBG1 Signal. */
#endif
#if defined(PRS_ASYNC_LEDDRV0_LEDDRVDBG2)
  SL_HAL_PRS_ASYNC_LEDDRV0_LEDDRVDBG2 = PRS_ASYNC_LEDDRV0_LEDDRVDBG2,        /**< LEDDRV0 LEDDRVDBG2 Signal. */
#endif
#if defined(PRS_ASYNC_LEDDRV0_LEDDRVDBG3)
  SL_HAL_PRS_ASYNC_LEDDRV0_LEDDRVDBG3 = PRS_ASYNC_LEDDRV0_LEDDRVDBG3,        /**< LEDDRV0 LEDDRVDBG3 Signal. */
#endif
#if defined(PRS_ASYNC_RPA_RPAAESDONE)
  SL_HAL_PRS_ASYNC_RPA_RPAAESDONE = PRS_ASYNC_RPA_RPAAESDONE,        /**< RPA RPAAESDONE Signal. */
#endif
#if defined(PRS_ASYNC_RPA_RPAAXIDONE)
  SL_HAL_PRS_ASYNC_RPA_RPAAXIDONE = PRS_ASYNC_RPA_RPAAXIDONE,        /**< RPA RPAAXIDONE Signal. */
#endif
#if defined(PRS_ASYNC_RPA_RPACOREDONE)
  SL_HAL_PRS_ASYNC_RPA_RPACOREDONE = PRS_ASYNC_RPA_RPACOREDONE,        /**< RPA RPACOREDONE Signal. */
#endif
#if defined(PRS_ASYNC_RPA_RPAKSUDONE)
  SL_HAL_PRS_ASYNC_RPA_RPAKSUDONE = PRS_ASYNC_RPA_RPAKSUDONE,        /**< RPA RPAKSUDONE Signal. */
#endif
// {ASYNC_SIGNALS}
};

/// Sync PRS Signals.
SL_ENUM_GENERIC(sl_hal_prs_sync_producer_signal_t, uint32_t)
{
  SL_HAL_PRS_SYNC_NONE = 0x0,                     /**< No Signal. */
#if defined(PRS_SYNC_TIMER0_UF)
  SL_HAL_PRS_SYNC_TIMER0_UF = PRS_SYNC_TIMER0_UF, /**< TIMER0 UF Signal. */
#endif
#if defined(PRS_SYNC_TIMER0_OF)
  SL_HAL_PRS_SYNC_TIMER0_OF = PRS_SYNC_TIMER0_OF,        /**< TIMER0 OF Signal. */
#endif
#if defined(PRS_SYNC_TIMER0_CC0)
  SL_HAL_PRS_SYNC_TIMER0_CC0 = PRS_SYNC_TIMER0_CC0,        /**< TIMER0 CC0 Signal. */
#endif
#if defined(PRS_SYNC_TIMER0_CC1)
  SL_HAL_PRS_SYNC_TIMER0_CC1 = PRS_SYNC_TIMER0_CC1,        /**< TIMER0 CC1 Signal. */
#endif
#if defined(PRS_SYNC_TIMER0_CC2)
  SL_HAL_PRS_SYNC_TIMER0_CC2 = PRS_SYNC_TIMER0_CC2,        /**< TIMER0 CC2 Signal. */
#endif
#if defined(PRS_SYNC_TIMER1_UF)
  SL_HAL_PRS_SYNC_TIMER1_UF = PRS_SYNC_TIMER1_UF,        /**< TIMER1 UF Signal. */
#endif
#if defined(PRS_SYNC_TIMER1_OF)
  SL_HAL_PRS_SYNC_TIMER1_OF = PRS_SYNC_TIMER1_OF,        /**< TIMER1 OF Signal. */
#endif
#if defined(PRS_SYNC_TIMER1_CC0)
  SL_HAL_PRS_SYNC_TIMER1_CC0 = PRS_SYNC_TIMER1_CC0,        /**< TIMER1 CC0 Signal. */
#endif
#if defined(PRS_SYNC_TIMER1_CC1)
  SL_HAL_PRS_SYNC_TIMER1_CC1 = PRS_SYNC_TIMER1_CC1,        /**< TIMER1 CC1 Signal. */
#endif
#if defined(PRS_SYNC_TIMER1_CC2)
  SL_HAL_PRS_SYNC_TIMER1_CC2 = PRS_SYNC_TIMER1_CC2,        /**< TIMER1 CC2 Signal. */
#endif
#if defined(PRS_SYNC_IADC0_SCAN_ENTRY_DONE)
  SL_HAL_PRS_SYNC_IADC0_SCANENTRYDONE = PRS_SYNC_IADC0_SCAN_ENTRY_DONE,        /**< IADC0 SCANENTRYDONE Signal. */
#endif
#if defined(PRS_SYNC_IADC0_SCAN_TABLE_DONE)
  SL_HAL_PRS_SYNC_IADC0_SCANTABLEDONE = PRS_SYNC_IADC0_SCAN_TABLE_DONE,        /**< IADC0 SCANTABLEDONE Signal. */
#endif
#if defined(PRS_SYNC_IADC0_SINGLE_DONE)
  SL_HAL_PRS_SYNC_IADC0_SINGLEDONE = PRS_SYNC_IADC0_SINGLE_DONE,        /**< IADC0 SINGLEDONE Signal. */
#endif
#if defined(PRS_SYNC_TIMER2_UF)
  SL_HAL_PRS_SYNC_TIMER2_UF = PRS_SYNC_TIMER2_UF,        /**< TIMER2 UF Signal. */
#endif
#if defined(PRS_SYNC_TIMER2_OF)
  SL_HAL_PRS_SYNC_TIMER2_OF = PRS_SYNC_TIMER2_OF,        /**< TIMER2 OF Signal. */
#endif
#if defined(PRS_SYNC_TIMER2_CC0)
  SL_HAL_PRS_SYNC_TIMER2_CC0 = PRS_SYNC_TIMER2_CC0,        /**< TIMER2 CC0 Signal. */
#endif
#if defined(PRS_SYNC_TIMER2_CC1)
  SL_HAL_PRS_SYNC_TIMER2_CC1 = PRS_SYNC_TIMER2_CC1,        /**< TIMER2 CC1 Signal. */
#endif
#if defined(PRS_SYNC_TIMER2_CC2)
  SL_HAL_PRS_SYNC_TIMER2_CC2 = PRS_SYNC_TIMER2_CC2,        /**< TIMER2 CC2 Signal. */
#endif
#if defined(PRS_SYNC_TIMER3_UF)
  SL_HAL_PRS_SYNC_TIMER3_UF = PRS_SYNC_TIMER3_UF,        /**< TIMER3 UF Signal. */
#endif
#if defined(PRS_SYNC_TIMER3_OF)
  SL_HAL_PRS_SYNC_TIMER3_OF = PRS_SYNC_TIMER3_OF,        /**< TIMER3 OF Signal. */
#endif
#if defined(PRS_SYNC_TIMER3_CC0)
  SL_HAL_PRS_SYNC_TIMER3_CC0 = PRS_SYNC_TIMER3_CC0,        /**< TIMER3 CC0 Signal. */
#endif
#if defined(PRS_SYNC_TIMER3_CC1)
  SL_HAL_PRS_SYNC_TIMER3_CC1 = PRS_SYNC_TIMER3_CC1,        /**< TIMER3 CC1 Signal. */
#endif
#if defined(PRS_SYNC_TIMER3_CC2)
  SL_HAL_PRS_SYNC_TIMER3_CC2 = PRS_SYNC_TIMER3_CC2,        /**< TIMER3 CC2 Signal. */
#endif
#if defined(PRS_SYNC_TIMER4_UF)
  SL_HAL_PRS_SYNC_TIMER4_UF = PRS_SYNC_TIMER4_UF,        /**< TIMER4 UF Signal. */
#endif
#if defined(PRS_SYNC_TIMER4_OF)
  SL_HAL_PRS_SYNC_TIMER4_OF = PRS_SYNC_TIMER4_OF,        /**< TIMER4 OF Signal. */
#endif
#if defined(PRS_SYNC_TIMER4_CC0)
  SL_HAL_PRS_SYNC_TIMER4_CC0 = PRS_SYNC_TIMER4_CC0,        /**< TIMER4 CC0 Signal. */
#endif
#if defined(PRS_SYNC_TIMER4_CC1)
  SL_HAL_PRS_SYNC_TIMER4_CC1 = PRS_SYNC_TIMER4_CC1,        /**< TIMER4 CC1 Signal. */
#endif
#if defined(PRS_SYNC_TIMER4_CC2)
  SL_HAL_PRS_SYNC_TIMER4_CC2 = PRS_SYNC_TIMER4_CC2,        /**< TIMER4 CC2 Signal. */
#endif
#if defined(PRS_SYNC_VDAC0_CH0_DONE_SYNC)
  SL_HAL_PRS_SYNC_VDAC0_CH0DONESYNC = PRS_SYNC_VDAC0_CH0_DONE_SYNC,        /**< VDAC0 CH0DONESYNC Signal. */
#endif
#if defined(PRS_SYNC_VDAC0_CH1_DONE_SYNC)
  SL_HAL_PRS_SYNC_VDAC0_CH1DONESYNC = PRS_SYNC_VDAC0_CH1_DONE_SYNC,        /**< VDAC0 CH1DONESYNC Signal. */
#endif
#if defined(PRS_SYNC_VDAC1_CH0_DONE_SYNC)
  SL_HAL_PRS_SYNC_VDAC1_CH0DONESYNC = PRS_SYNC_VDAC1_CH0_DONE_SYNC,        /**< VDAC1 CH0DONESYNC Signal. */
#endif
#if defined(PRS_SYNC_VDAC1_CH1_DONE_SYNC)
  SL_HAL_PRS_SYNC_VDAC1_CH1DONESYNC = PRS_SYNC_VDAC1_CH1_DONE_SYNC,        /**< VDAC1 CH1DONESYNC Signal. */
#endif
#if defined(PRS_SYNC_TIMER5_UF)
  SL_HAL_PRS_SYNC_TIMER5_UF = PRS_SYNC_TIMER5_UF,        /**< TIMER5 UF Signal. */
#endif
#if defined(PRS_SYNC_TIMER5_OF)
  SL_HAL_PRS_SYNC_TIMER5_OF = PRS_SYNC_TIMER5_OF,        /**< TIMER5 OF Signal. */
#endif
#if defined(PRS_SYNC_TIMER5_CC0)
  SL_HAL_PRS_SYNC_TIMER5_CC0 = PRS_SYNC_TIMER5_CC0,        /**< TIMER5 CC0 Signal. */
#endif
#if defined(PRS_SYNC_TIMER5_CC1)
  SL_HAL_PRS_SYNC_TIMER5_CC1 = PRS_SYNC_TIMER5_CC1,        /**< TIMER5 CC1 Signal. */
#endif
#if defined(PRS_SYNC_TIMER5_CC2)
  SL_HAL_PRS_SYNC_TIMER5_CC2 = PRS_SYNC_TIMER5_CC2,        /**< TIMER5 CC2 Signal. */
#endif
#if defined(PRS_SYNC_TIMER6_UF)
  SL_HAL_PRS_SYNC_TIMER6_UF = PRS_SYNC_TIMER6_UF,        /**< TIMER6 UF Signal. */
#endif
#if defined(PRS_SYNC_TIMER6_OF)
  SL_HAL_PRS_SYNC_TIMER6_OF = PRS_SYNC_TIMER6_OF,        /**< TIMER6 OF Signal. */
#endif
#if defined(PRS_SYNC_TIMER6_CC0)
  SL_HAL_PRS_SYNC_TIMER6_CC0 = PRS_SYNC_TIMER6_CC0,        /**< TIMER6 CC0 Signal. */
#endif
#if defined(PRS_SYNC_TIMER6_CC1)
  SL_HAL_PRS_SYNC_TIMER6_CC1 = PRS_SYNC_TIMER6_CC1,        /**< TIMER6 CC1 Signal. */
#endif
#if defined(PRS_SYNC_TIMER6_CC2)
  SL_HAL_PRS_SYNC_TIMER6_CC2 = PRS_SYNC_TIMER6_CC2,        /**< TIMER6 CC2 Signal. */
#endif
#if defined(PRS_SYNC_TIMER7_UF)
  SL_HAL_PRS_SYNC_TIMER7_UF = PRS_SYNC_TIMER7_UF,        /**< TIMER7 UF Signal. */
#endif
#if defined(PRS_SYNC_TIMER7_OF)
  SL_HAL_PRS_SYNC_TIMER7_OF = PRS_SYNC_TIMER7_OF,        /**< TIMER7 OF Signal. */
#endif
#if defined(PRS_SYNC_TIMER7_CC0)
  SL_HAL_PRS_SYNC_TIMER7_CC0 = PRS_SYNC_TIMER7_CC0,        /**< TIMER7 CC0 Signal. */
#endif
#if defined(PRS_SYNC_TIMER7_CC1)
  SL_HAL_PRS_SYNC_TIMER7_CC1 = PRS_SYNC_TIMER7_CC1,        /**< TIMER7 CC1 Signal. */
#endif
#if defined(PRS_SYNC_TIMER7_CC2)
  SL_HAL_PRS_SYNC_TIMER7_CC2 = PRS_SYNC_TIMER7_CC2,        /**< TIMER7 CC2 Signal. */
#endif
#if defined(PRS_SYNC_TIMER8_UF)
  SL_HAL_PRS_SYNC_TIMER8_UF = PRS_SYNC_TIMER8_UF,        /**< TIMER8 UF Signal. */
#endif
#if defined(PRS_SYNC_TIMER8_OF)
  SL_HAL_PRS_SYNC_TIMER8_OF = PRS_SYNC_TIMER8_OF,        /**< TIMER8 OF Signal. */
#endif
#if defined(PRS_SYNC_TIMER8_CC0)
  SL_HAL_PRS_SYNC_TIMER8_CC0 = PRS_SYNC_TIMER8_CC0,        /**< TIMER8 CC0 Signal. */
#endif
#if defined(PRS_SYNC_TIMER8_CC1)
  SL_HAL_PRS_SYNC_TIMER8_CC1 = PRS_SYNC_TIMER8_CC1,        /**< TIMER8 CC1 Signal. */
#endif
#if defined(PRS_SYNC_TIMER8_CC2)
  SL_HAL_PRS_SYNC_TIMER8_CC2 = PRS_SYNC_TIMER8_CC2,        /**< TIMER8 CC2 Signal. */
#endif
#if defined(PRS_SYNC_TIMER9_UF)
  SL_HAL_PRS_SYNC_TIMER9_UF = PRS_SYNC_TIMER9_UF,        /**< TIMER9 UF Signal. */
#endif
#if defined(PRS_SYNC_TIMER9_OF)
  SL_HAL_PRS_SYNC_TIMER9_OF = PRS_SYNC_TIMER9_OF,        /**< TIMER9 OF Signal. */
#endif
#if defined(PRS_SYNC_TIMER9_CC0)
  SL_HAL_PRS_SYNC_TIMER9_CC0 = PRS_SYNC_TIMER9_CC0,        /**< TIMER9 CC0 Signal. */
#endif
#if defined(PRS_SYNC_TIMER9_CC1)
  SL_HAL_PRS_SYNC_TIMER9_CC1 = PRS_SYNC_TIMER9_CC1,        /**< TIMER9 CC1 Signal. */
#endif
#if defined(PRS_SYNC_TIMER9_CC2)
  SL_HAL_PRS_SYNC_TIMER9_CC2 = PRS_SYNC_TIMER9_CC2,        /**< TIMER9 CC2 Signal. */
#endif
#if defined(PRS_SYNC_TIMER2L_UF)
  SL_HAL_PRS_SYNC_TIMER2L_UF = PRS_SYNC_TIMER2L_UF,        /**< TIMER2L UF Signal. */
#endif
#if defined(PRS_SYNC_TIMER2L_OF)
  SL_HAL_PRS_SYNC_TIMER2L_OF = PRS_SYNC_TIMER2L_OF,        /**< TIMER2L OF Signal. */
#endif
#if defined(PRS_SYNC_TIMER2L_CC0)
  SL_HAL_PRS_SYNC_TIMER2L_CC0 = PRS_SYNC_TIMER2L_CC0,        /**< TIMER2L CC0 Signal. */
#endif
#if defined(PRS_SYNC_TIMER2L_CC1)
  SL_HAL_PRS_SYNC_TIMER2L_CC1 = PRS_SYNC_TIMER2L_CC1,        /**< TIMER2L CC1 Signal. */
#endif
#if defined(PRS_SYNC_TIMER2L_CC2)
  SL_HAL_PRS_SYNC_TIMER2L_CC2 = PRS_SYNC_TIMER2L_CC2,        /**< TIMER2L CC2 Signal. */
#endif
#if defined(PRS_SYNC_TIMER2L_CC3)
  SL_HAL_PRS_SYNC_TIMER2L_CC3 = PRS_SYNC_TIMER2L_CC3,        /**< TIMER2L CC3 Signal. */
#endif
#if defined(PRS_SYNC_TIMER2L_CC4)
  SL_HAL_PRS_SYNC_TIMER2L_CC4 = PRS_SYNC_TIMER2L_CC4,        /**< TIMER2L CC4 Signal. */
#endif
#if defined(PRS_SYNC_TIMER2L_CC5)
  SL_HAL_PRS_SYNC_TIMER2L_CC5 = PRS_SYNC_TIMER2L_CC5,        /**< TIMER2L CC5 Signal. */
#endif
#if defined(PRS_SYNC_TIMER2_CC6)
  SL_HAL_PRS_SYNC_TIMER2_CC6 = PRS_SYNC_TIMER2_CC6,        /**< TIMER2 CC6 Signal. */
#endif
#if defined(PRS_SYNC_TIMER3L_UF)
  SL_HAL_PRS_SYNC_TIMER3L_UF = PRS_SYNC_TIMER3L_UF,        /**< TIMER3L UF Signal. */
#endif
#if defined(PRS_SYNC_TIMER3L_OF)
  SL_HAL_PRS_SYNC_TIMER3L_OF = PRS_SYNC_TIMER3L_OF,        /**< TIMER3L OF Signal. */
#endif
#if defined(PRS_SYNC_TIMER3L_CC0)
  SL_HAL_PRS_SYNC_TIMER3L_CC0 = PRS_SYNC_TIMER3L_CC0,        /**< TIMER3L CC0 Signal. */
#endif
#if defined(PRS_SYNC_TIMER3L_CC1)
  SL_HAL_PRS_SYNC_TIMER3L_CC1 = PRS_SYNC_TIMER3L_CC1,        /**< TIMER3L CC1 Signal. */
#endif
#if defined(PRS_SYNC_TIMER3L_CC2)
  SL_HAL_PRS_SYNC_TIMER3L_CC2 = PRS_SYNC_TIMER3L_CC2,        /**< TIMER3L CC2 Signal. */
#endif
#if defined(PRS_SYNC_TIMER3L_CC3)
  SL_HAL_PRS_SYNC_TIMER3L_CC3 = PRS_SYNC_TIMER3L_CC3,        /**< TIMER3L CC3 Signal. */
#endif
#if defined(PRS_SYNC_TIMER3L_CC4)
  SL_HAL_PRS_SYNC_TIMER3L_CC4 = PRS_SYNC_TIMER3L_CC4,        /**< TIMER3L CC4 Signal. */
#endif
#if defined(PRS_SYNC_TIMER3L_CC5)
  SL_HAL_PRS_SYNC_TIMER3L_CC5 = PRS_SYNC_TIMER3L_CC5,        /**< TIMER3L CC5 Signal. */
#endif
#if defined(PRS_SYNC_TIMER3_CC6)
  SL_HAL_PRS_SYNC_TIMER3_CC6 = PRS_SYNC_TIMER3_CC6,        /**< TIMER3 CC6 Signal. */
#endif
#if defined(PRS_SYNC_ADC0_SCAN_ENTRY_DONE)
  SL_HAL_PRS_SYNC_ADC0_SCANENTRYDONE = PRS_SYNC_ADC0_SCAN_ENTRY_DONE,        /**< ADC0 SCANENTRYDONE Signal. */
#endif
#if defined(PRS_SYNC_ADC0_SCAN_TABLE_DONE)
  SL_HAL_PRS_SYNC_ADC0_SCANTABLEDONE = PRS_SYNC_ADC0_SCAN_TABLE_DONE,        /**< ADC0 SCANTABLEDONE Signal. */
#endif
// {SYNC_SIGNALS}
};

/// PRS Consumers.
SL_ENUM_GENERIC(sl_hal_prs_consumer_event_t, uint32_t)
{
  SL_HAL_PRS_CONSUMER_NONE = 0x0,                                            /**< No PRS consumer */
#if defined(_PRS_CONSUMER_CMU_CALDN_MASK)
  SL_HAL_PRS_CONSUMER_CMU_CALDN = offsetof(PRS_TypeDef, CONSUMER_CMU_CALDN), /**< CMU CALDN consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_CMU_CALUP_MASK)
  SL_HAL_PRS_CONSUMER_CMU_CALUP = offsetof(PRS_TypeDef, CONSUMER_CMU_CALUP),        /**< CMU CALUP Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_EUSART0_CLK_MASK)
  SL_HAL_PRS_CONSUMER_EUSART0_CLK = offsetof(PRS_TypeDef, CONSUMER_EUSART0_CLK),        /**< EUSART0 CLK consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_EUSART0_RX_MASK)
  SL_HAL_PRS_CONSUMER_EUSART0_RX = offsetof(PRS_TypeDef, CONSUMER_EUSART0_RX),        /**< EUSART0 RX Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_EUSART0_TRIGGER_MASK)
  SL_HAL_PRS_CONSUMER_EUSART0_TRIGGER = offsetof(PRS_TypeDef, CONSUMER_EUSART0_TRIGGER),        /**< EUSART0 TRIGGER Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_FRC_RXRAW_MASK)
  SL_HAL_PRS_CONSUMER_FRC_RXRAW = offsetof(PRS_TypeDef, CONSUMER_FRC_RXRAW),        /**< FRC RXRAW consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_IADC0_SCANTRIGGER_MASK)
  SL_HAL_PRS_CONSUMER_IADC0_SCANTRIGGER = offsetof(PRS_TypeDef, CONSUMER_IADC0_SCANTRIGGER),        /**< IADC0 SCANTRIGGER consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_IADC0_SINGLETRIGGER_MASK)
  SL_HAL_PRS_CONSUMER_IADC0_SINGLETRIGGER = offsetof(PRS_TypeDef, CONSUMER_IADC0_SINGLETRIGGER),        /**< IADC0 SINGLETRIGGER Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_LDMAXBAR_DMAREQ0_MASK)
  SL_HAL_PRS_CONSUMER_LDMAXBAR_DMAREQ0 = offsetof(PRS_TypeDef, CONSUMER_LDMAXBAR_DMAREQ0),        /**< LDMAXBAR DMAREQ0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_LDMAXBAR_DMAREQ1_MASK)
  SL_HAL_PRS_CONSUMER_LDMAXBAR_DMAREQ1 = offsetof(PRS_TypeDef, CONSUMER_LDMAXBAR_DMAREQ1),        /**< LDMAXBAR DMAREQ1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_LETIMER0_CLEAR_MASK)
  SL_HAL_PRS_CONSUMER_LETIMER0_CLEAR = offsetof(PRS_TypeDef, CONSUMER_LETIMER0_CLEAR),        /**< LETIMER0 CLEAR consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_LETIMER0_START_MASK)
  SL_HAL_PRS_CONSUMER_LETIMER0_START = offsetof(PRS_TypeDef, CONSUMER_LETIMER0_START),        /**< LETIMER0 START Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_LETIMER0_STOP_MASK)
  SL_HAL_PRS_CONSUMER_LETIMER0_STOP = offsetof(PRS_TypeDef, CONSUMER_LETIMER0_STOP),        /**< LETIMER0 STOP Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_MODEM_DIN_MASK)
  SL_HAL_PRS_CONSUMER_MODEM_DIN = offsetof(PRS_TypeDef, CONSUMER_MODEM_DIN),        /**< MODEM DIN consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_PRORTC_CC0_MASK)
  SL_HAL_PRS_CONSUMER_PRORTC_CC0 = offsetof(PRS_TypeDef, CONSUMER_PRORTC_CC0),        /**< PRORTC CC0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_PRORTC_CC1_MASK)
  SL_HAL_PRS_CONSUMER_PRORTC_CC1 = offsetof(PRS_TypeDef, CONSUMER_PRORTC_CC1),        /**< PRORTC CC1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_RAC_CLR_MASK)
  SL_HAL_PRS_CONSUMER_RAC_CLR = offsetof(PRS_TypeDef, CONSUMER_RAC_CLR),        /**< RAC CLR consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_RAC_CTIIN0_MASK)
  SL_HAL_PRS_CONSUMER_RAC_CTIIN0 = offsetof(PRS_TypeDef, CONSUMER_RAC_CTIIN0),        /**< RAC CTIIN0 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_RAC_CTIIN1_MASK)
  SL_HAL_PRS_CONSUMER_RAC_CTIIN1 = offsetof(PRS_TypeDef, CONSUMER_RAC_CTIIN1),        /**< RAC CTIIN1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_RAC_CTIIN2_MASK)
  SL_HAL_PRS_CONSUMER_RAC_CTIIN2 = offsetof(PRS_TypeDef, CONSUMER_RAC_CTIIN2),        /**< RAC CTIIN2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_RAC_CTIIN3_MASK)
  SL_HAL_PRS_CONSUMER_RAC_CTIIN3 = offsetof(PRS_TypeDef, CONSUMER_RAC_CTIIN3),        /**< RAC CTIIN3 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_RAC_FORCETX_MASK)
  SL_HAL_PRS_CONSUMER_RAC_FORCETX = offsetof(PRS_TypeDef, CONSUMER_RAC_FORCETX),        /**< RAC FORCETX Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_RAC_RXDIS_MASK)
  SL_HAL_PRS_CONSUMER_RAC_RXDIS = offsetof(PRS_TypeDef, CONSUMER_RAC_RXDIS),        /**< RAC RXDIS Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_RAC_RXEN_MASK)
  SL_HAL_PRS_CONSUMER_RAC_RXEN = offsetof(PRS_TypeDef, CONSUMER_RAC_RXEN),        /**< RAC RXEN Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_RAC_SEQ_MASK)
  SL_HAL_PRS_CONSUMER_RAC_SEQ = offsetof(PRS_TypeDef, CONSUMER_RAC_SEQ),        /**< RAC SEQ Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_RAC_TXEN_MASK)
  SL_HAL_PRS_CONSUMER_RAC_TXEN = offsetof(PRS_TypeDef, CONSUMER_RAC_TXEN),        /**< RAC TXEN Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_RTCC_CC0_MASK)
  SL_HAL_PRS_CONSUMER_RTCC_CC0 = offsetof(PRS_TypeDef, CONSUMER_RTCC_CC0),        /**< RTCC CC0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_RTCC_CC1_MASK)
  SL_HAL_PRS_CONSUMER_RTCC_CC1 = offsetof(PRS_TypeDef, CONSUMER_RTCC_CC1),        /**< RTCC CC1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_RTCC_CC2_MASK)
  SL_HAL_PRS_CONSUMER_RTCC_CC2 = offsetof(PRS_TypeDef, CONSUMER_RTCC_CC2),        /**< RTCC CC2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_CORE_CTIIN0_MASK)
  SL_HAL_PRS_CONSUMER_CORE_CTIIN0 = offsetof(PRS_TypeDef, CONSUMER_CORE_CTIIN0),        /**< CORE CTIIN0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_CORE_CTIIN1_MASK)
  SL_HAL_PRS_CONSUMER_CORE_CTIIN1 = offsetof(PRS_TypeDef, CONSUMER_CORE_CTIIN1),        /**< CORE CTIIN1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_CORE_CTIIN2_MASK)
  SL_HAL_PRS_CONSUMER_CORE_CTIIN2 = offsetof(PRS_TypeDef, CONSUMER_CORE_CTIIN2),        /**< CORE CTIIN2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_CORE_CTIIN3_MASK)
  SL_HAL_PRS_CONSUMER_CORE_CTIIN3 = offsetof(PRS_TypeDef, CONSUMER_CORE_CTIIN3),        /**< CORE CTIIN3 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_CORE_M33RXEV_MASK)
  SL_HAL_PRS_CONSUMER_CORE_M33RXEV = offsetof(PRS_TypeDef, CONSUMER_CORE_M33RXEV),        /**< CORE M33RXEV Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER0_CC0_MASK)
  SL_HAL_PRS_CONSUMER_TIMER0_CC0 = offsetof(PRS_TypeDef, CONSUMER_TIMER0_CC0),        /**< TIMER0 CC0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER0_CC1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER0_CC1 = offsetof(PRS_TypeDef, CONSUMER_TIMER0_CC1),        /**< TIMER0 CC1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER0_CC2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER0_CC2 = offsetof(PRS_TypeDef, CONSUMER_TIMER0_CC2),        /**< TIMER0 CC2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER0_DTI_MASK)
  SL_HAL_PRS_CONSUMER_TIMER0_DTI = offsetof(PRS_TypeDef, CONSUMER_TIMER0_DTI),        /**< TIMER0 DTI Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER0_DTIFS1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER0_DTIFS1 = offsetof(PRS_TypeDef, CONSUMER_TIMER0_DTIFS1),        /**< TIMER0 DTIFS1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER0_DTIFS2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER0_DTIFS2 = offsetof(PRS_TypeDef, CONSUMER_TIMER0_DTIFS2),        /**< TIMER0 DTIFS2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER1_CC0_MASK)
  SL_HAL_PRS_CONSUMER_TIMER1_CC0 = offsetof(PRS_TypeDef, CONSUMER_TIMER1_CC0),        /**< TIMER1 CC0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER1_CC1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER1_CC1 = offsetof(PRS_TypeDef, CONSUMER_TIMER1_CC1),        /**< TIMER1 CC1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER1_CC2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER1_CC2 = offsetof(PRS_TypeDef, CONSUMER_TIMER1_CC2),        /**< TIMER1 CC2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER1_DTI_MASK)
  SL_HAL_PRS_CONSUMER_TIMER1_DTI = offsetof(PRS_TypeDef, CONSUMER_TIMER1_DTI),        /**< TIMER1 DTI Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER1_DTIFS1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER1_DTIFS1 = offsetof(PRS_TypeDef, CONSUMER_TIMER1_DTIFS1),        /**< TIMER1 DTIFS1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER1_DTIFS2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER1_DTIFS2 = offsetof(PRS_TypeDef, CONSUMER_TIMER1_DTIFS2),        /**< TIMER1 DTIFS2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER2_CC0_MASK)
  SL_HAL_PRS_CONSUMER_TIMER2_CC0 = offsetof(PRS_TypeDef, CONSUMER_TIMER2_CC0),        /**< TIMER2 CC0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER2_CC1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER2_CC1 = offsetof(PRS_TypeDef, CONSUMER_TIMER2_CC1),        /**< TIMER2 CC1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER2_CC2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER2_CC2 = offsetof(PRS_TypeDef, CONSUMER_TIMER2_CC2),        /**< TIMER2 CC2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER2_DTI_MASK)
  SL_HAL_PRS_CONSUMER_TIMER2_DTI = offsetof(PRS_TypeDef, CONSUMER_TIMER2_DTI),        /**< TIMER2 DTI Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER2_DTIFS1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER2_DTIFS1 = offsetof(PRS_TypeDef, CONSUMER_TIMER2_DTIFS1),        /**< TIMER2 DTIFS1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER2_DTIFS2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER2_DTIFS2 = offsetof(PRS_TypeDef, CONSUMER_TIMER2_DTIFS2),        /**< TIMER2 DTIFS2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER3_CC0_MASK)
  SL_HAL_PRS_CONSUMER_TIMER3_CC0 = offsetof(PRS_TypeDef, CONSUMER_TIMER3_CC0),        /**< TIMER3 CC0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER3_CC1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER3_CC1 = offsetof(PRS_TypeDef, CONSUMER_TIMER3_CC1),        /**< TIMER3 CC1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER3_CC2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER3_CC2 = offsetof(PRS_TypeDef, CONSUMER_TIMER3_CC2),        /**< TIMER3 CC2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER3_DTI_MASK)
  SL_HAL_PRS_CONSUMER_TIMER3_DTI = offsetof(PRS_TypeDef, CONSUMER_TIMER3_DTI),        /**< TIMER3 DTI Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER3_DTIFS1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER3_DTIFS1 = offsetof(PRS_TypeDef, CONSUMER_TIMER3_DTIFS1),        /**< TIMER3 DTIFS1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER3_DTIFS2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER3_DTIFS2 = offsetof(PRS_TypeDef, CONSUMER_TIMER3_DTIFS2),        /**< TIMER3 DTIFS2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER4_CC0_MASK)
  SL_HAL_PRS_CONSUMER_TIMER4_CC0 = offsetof(PRS_TypeDef, CONSUMER_TIMER4_CC0),        /**< TIMER4 CC0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER4_CC1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER4_CC1 = offsetof(PRS_TypeDef, CONSUMER_TIMER4_CC1),        /**< TIMER4 CC1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER4_CC2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER4_CC2 = offsetof(PRS_TypeDef, CONSUMER_TIMER4_CC2),        /**< TIMER4 CC2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER4_DTI_MASK)
  SL_HAL_PRS_CONSUMER_TIMER4_DTI = offsetof(PRS_TypeDef, CONSUMER_TIMER4_DTI),        /**< TIMER4 DTI Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER4_DTIFS1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER4_DTIFS1 = offsetof(PRS_TypeDef, CONSUMER_TIMER4_DTIFS1),        /**< TIMER4 DTIFS1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER4_DTIFS2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER4_DTIFS2 = offsetof(PRS_TypeDef, CONSUMER_TIMER4_DTIFS2),        /**< TIMER4 DTIFS2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_USART0_CLK_MASK)
  SL_HAL_PRS_CONSUMER_USART0_CLK = offsetof(PRS_TypeDef, CONSUMER_USART0_CLK),        /**< USART0 CLK consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_USART0_IR_MASK)
  SL_HAL_PRS_CONSUMER_USART0_IR = offsetof(PRS_TypeDef, CONSUMER_USART0_IR),        /**< USART0 IR Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_USART0_RX_MASK)
  SL_HAL_PRS_CONSUMER_USART0_RX = offsetof(PRS_TypeDef, CONSUMER_USART0_RX),        /**< USART0 RX Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_USART0_TRIGGER_MASK)
  SL_HAL_PRS_CONSUMER_USART0_TRIGGER = offsetof(PRS_TypeDef, CONSUMER_USART0_TRIGGER),        /**< USART0 TRIGGER Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_USART1_CLK_MASK)
  SL_HAL_PRS_CONSUMER_USART1_CLK = offsetof(PRS_TypeDef, CONSUMER_USART1_CLK),        /**< USART1 CLK consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_USART1_IR_MASK)
  SL_HAL_PRS_CONSUMER_USART1_IR = offsetof(PRS_TypeDef, CONSUMER_USART1_IR),        /**< USART1 IR Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_USART1_RX_MASK)
  SL_HAL_PRS_CONSUMER_USART1_RX = offsetof(PRS_TypeDef, CONSUMER_USART1_RX),        /**< USART1 RX Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_USART1_TRIGGER_MASK)
  SL_HAL_PRS_CONSUMER_USART1_TRIGGER = offsetof(PRS_TypeDef, CONSUMER_USART1_TRIGGER),        /**< USART1 TRIGGER Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_WDOG0_SRC0_MASK)
  SL_HAL_PRS_CONSUMER_WDOG0_SRC0 = offsetof(PRS_TypeDef, CONSUMER_WDOG0_SRC0),        /**< WDOG0 SRC0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_WDOG0_SRC1_MASK)
  SL_HAL_PRS_CONSUMER_WDOG0_SRC1 = offsetof(PRS_TypeDef, CONSUMER_WDOG0_SRC1),        /**< WDOG0 SRC1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_EUSART1_CLK_MASK)
  SL_HAL_PRS_CONSUMER_EUSART1_CLK = offsetof(PRS_TypeDef, CONSUMER_EUSART1_CLK),        /**< EUSART1 CLK consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_EUSART1_RX_MASK)
  SL_HAL_PRS_CONSUMER_EUSART1_RX = offsetof(PRS_TypeDef, CONSUMER_EUSART1_RX),        /**< EUSART1 RX Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_EUSART1_TRIGGER_MASK)
  SL_HAL_PRS_CONSUMER_EUSART1_TRIGGER = offsetof(PRS_TypeDef, CONSUMER_EUSART1_TRIGGER),        /**< EUSART1 TRIGGER Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_EUSART2_CLK_MASK)
  SL_HAL_PRS_CONSUMER_EUSART2_CLK = offsetof(PRS_TypeDef, CONSUMER_EUSART2_CLK),        /**< EUSART2 CLK consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_EUSART2_RX_MASK)
  SL_HAL_PRS_CONSUMER_EUSART2_RX = offsetof(PRS_TypeDef, CONSUMER_EUSART2_RX),        /**< EUSART2 RX Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_EUSART2_TRIGGER_MASK)
  SL_HAL_PRS_CONSUMER_EUSART2_TRIGGER = offsetof(PRS_TypeDef, CONSUMER_EUSART2_TRIGGER),        /**< EUSART2 TRIGGER Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_LESENSE_START_MASK)
  SL_HAL_PRS_CONSUMER_LESENSE_START = offsetof(PRS_TypeDef, CONSUMER_LESENSE_START),        /**< LESENSE START Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_PCNT0_S0IN_MASK)
  SL_HAL_PRS_CONSUMER_PCNT0_S0IN = offsetof(PRS_TypeDef, CONSUMER_PCNT0_S0IN),        /**< PCNT0 S0IN consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_PCNT0_S1IN_MASK)
  SL_HAL_PRS_CONSUMER_PCNT0_S1IN = offsetof(PRS_TypeDef, CONSUMER_PCNT0_S1IN),        /**< PCNT0 S1IN Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_SETAMPER_TAMPERSRC25_MASK)
  SL_HAL_PRS_CONSUMER_SETAMPER_TAMPERSRC25 = offsetof(PRS_TypeDef, CONSUMER_SETAMPER_TAMPERSRC25),        /**< SETAMPER TAMPERSRC25 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_SETAMPER_TAMPERSRC26_MASK)
  SL_HAL_PRS_CONSUMER_SETAMPER_TAMPERSRC26 = offsetof(PRS_TypeDef, CONSUMER_SETAMPER_TAMPERSRC26),        /**< SETAMPER TAMPERSRC26 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_SETAMPER_TAMPERSRC27_MASK)
  SL_HAL_PRS_CONSUMER_SETAMPER_TAMPERSRC27 = offsetof(PRS_TypeDef, CONSUMER_SETAMPER_TAMPERSRC27),        /**< SETAMPER TAMPERSRC27 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_SETAMPER_TAMPERSRC28_MASK)
  SL_HAL_PRS_CONSUMER_SETAMPER_TAMPERSRC28 = offsetof(PRS_TypeDef, CONSUMER_SETAMPER_TAMPERSRC28),        /**< SETAMPER TAMPERSRC28 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_SETAMPER_TAMPERSRC29_MASK)
  SL_HAL_PRS_CONSUMER_SETAMPER_TAMPERSRC29 = offsetof(PRS_TypeDef, CONSUMER_SETAMPER_TAMPERSRC29),        /**< SETAMPER TAMPERSRC29 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_SETAMPER_TAMPERSRC30_MASK)
  SL_HAL_PRS_CONSUMER_SETAMPER_TAMPERSRC30 = offsetof(PRS_TypeDef, CONSUMER_SETAMPER_TAMPERSRC30),        /**< SETAMPER TAMPERSRC30 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_SETAMPER_TAMPERSRC31_MASK)
  SL_HAL_PRS_CONSUMER_SETAMPER_TAMPERSRC31 = offsetof(PRS_TypeDef, CONSUMER_SETAMPER_TAMPERSRC31),        /**< SETAMPER TAMPERSRC31 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_SYSRTC0_IN0_MASK)
  SL_HAL_PRS_CONSUMER_SYSRTC0_IN0 = offsetof(PRS_TypeDef, CONSUMER_SYSRTC0_IN0),        /**< SYSRTC0 IN0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_SYSRTC0_IN1_MASK)
  SL_HAL_PRS_CONSUMER_SYSRTC0_IN1 = offsetof(PRS_TypeDef, CONSUMER_SYSRTC0_IN1),        /**< SYSRTC0 IN1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_HFXO0_OSCREQ_MASK)
  SL_HAL_PRS_CONSUMER_HFXO0_OSCREQ = offsetof(PRS_TypeDef, CONSUMER_HFXO0_OSCREQ),        /**< HFXO0 OSCREQ consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_HFXO0_TIMEOUT_MASK)
  SL_HAL_PRS_CONSUMER_HFXO0_TIMEOUT = offsetof(PRS_TypeDef, CONSUMER_HFXO0_TIMEOUT),        /**< HFXO0 TIMEOUT Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_VDAC0_ASYNCTRIGCH0_MASK)
  SL_HAL_PRS_CONSUMER_VDAC0_ASYNCTRIGCH0 = offsetof(PRS_TypeDef, CONSUMER_VDAC0_ASYNCTRIGCH0),        /**< VDAC0 ASYNCTRIGCH0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_VDAC0_ASYNCTRIGCH1_MASK)
  SL_HAL_PRS_CONSUMER_VDAC0_ASYNCTRIGCH1 = offsetof(PRS_TypeDef, CONSUMER_VDAC0_ASYNCTRIGCH1),        /**< VDAC0 ASYNCTRIGCH1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_VDAC0_SYNCTRIGCH0_MASK)
  SL_HAL_PRS_CONSUMER_VDAC0_SYNCTRIGCH0 = offsetof(PRS_TypeDef, CONSUMER_VDAC0_SYNCTRIGCH0),        /**< VDAC0 SYNCTRIGCH0 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_VDAC0_SYNCTRIGCH1_MASK)
  SL_HAL_PRS_CONSUMER_VDAC0_SYNCTRIGCH1 = offsetof(PRS_TypeDef, CONSUMER_VDAC0_SYNCTRIGCH1),        /**< VDAC0 SYNCTRIGCH1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_WDOG1_SRC0_MASK)
  SL_HAL_PRS_CONSUMER_WDOG1_SRC0 = offsetof(PRS_TypeDef, CONSUMER_WDOG1_SRC0),        /**< WDOG1 SRC0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_WDOG1_SRC1_MASK)
  SL_HAL_PRS_CONSUMER_WDOG1_SRC1 = offsetof(PRS_TypeDef, CONSUMER_WDOG1_SRC1),        /**< WDOG1 SRC1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_EUSART3_CLK_MASK)
  SL_HAL_PRS_CONSUMER_EUSART3_CLK = offsetof(PRS_TypeDef, CONSUMER_EUSART3_CLK),        /**< EUSART3 CLK consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_EUSART3_RX_MASK)
  SL_HAL_PRS_CONSUMER_EUSART3_RX = offsetof(PRS_TypeDef, CONSUMER_EUSART3_RX),        /**< EUSART3 RX Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_EUSART3_TRIGGER_MASK)
  SL_HAL_PRS_CONSUMER_EUSART3_TRIGGER = offsetof(PRS_TypeDef, CONSUMER_EUSART3_TRIGGER),        /**< EUSART3 TRIGGER Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_MODEM_PAEN_MASK)
  SL_HAL_PRS_CONSUMER_MODEM_PAEN = offsetof(PRS_TypeDef, CONSUMER_MODEM_PAEN),        /**< MODEM PAEN Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER5_CC0_MASK)
  SL_HAL_PRS_CONSUMER_TIMER5_CC0 = offsetof(PRS_TypeDef, CONSUMER_TIMER5_CC0),        /**< TIMER5 CC0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER5_CC1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER5_CC1 = offsetof(PRS_TypeDef, CONSUMER_TIMER5_CC1),        /**< TIMER5 CC1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER5_CC2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER5_CC2 = offsetof(PRS_TypeDef, CONSUMER_TIMER5_CC2),        /**< TIMER5 CC2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER5_DTI_MASK)
  SL_HAL_PRS_CONSUMER_TIMER5_DTI = offsetof(PRS_TypeDef, CONSUMER_TIMER5_DTI),        /**< TIMER5 DTI Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER5_DTIFS1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER5_DTIFS1 = offsetof(PRS_TypeDef, CONSUMER_TIMER5_DTIFS1),        /**< TIMER5 DTIFS1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER5_DTIFS2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER5_DTIFS2 = offsetof(PRS_TypeDef, CONSUMER_TIMER5_DTIFS2),        /**< TIMER5 DTIFS2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER6_CC0_MASK)
  SL_HAL_PRS_CONSUMER_TIMER6_CC0 = offsetof(PRS_TypeDef, CONSUMER_TIMER6_CC0),        /**< TIMER6 CC0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER6_CC1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER6_CC1 = offsetof(PRS_TypeDef, CONSUMER_TIMER6_CC1),        /**< TIMER6 CC1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER6_CC2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER6_CC2 = offsetof(PRS_TypeDef, CONSUMER_TIMER6_CC2),        /**< TIMER6 CC2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER6_DTI_MASK)
  SL_HAL_PRS_CONSUMER_TIMER6_DTI = offsetof(PRS_TypeDef, CONSUMER_TIMER6_DTI),        /**< TIMER6 DTI Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER6_DTIFS1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER6_DTIFS1 = offsetof(PRS_TypeDef, CONSUMER_TIMER6_DTIFS1),        /**< TIMER6 DTIFS1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER6_DTIFS2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER6_DTIFS2 = offsetof(PRS_TypeDef, CONSUMER_TIMER6_DTIFS2),        /**< TIMER6 DTIFS2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER7_CC0_MASK)
  SL_HAL_PRS_CONSUMER_TIMER7_CC0 = offsetof(PRS_TypeDef, CONSUMER_TIMER7_CC0),        /**< TIMER7 CC0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER7_CC1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER7_CC1 = offsetof(PRS_TypeDef, CONSUMER_TIMER7_CC1),        /**< TIMER7 CC1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER7_CC2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER7_CC2 = offsetof(PRS_TypeDef, CONSUMER_TIMER7_CC2),        /**< TIMER7 CC2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER7_DTI_MASK)
  SL_HAL_PRS_CONSUMER_TIMER7_DTI = offsetof(PRS_TypeDef, CONSUMER_TIMER7_DTI),        /**< TIMER7 DTI Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER7_DTIFS1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER7_DTIFS1 = offsetof(PRS_TypeDef, CONSUMER_TIMER7_DTIFS1),        /**< TIMER7 DTIFS1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER7_DTIFS2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER7_DTIFS2 = offsetof(PRS_TypeDef, CONSUMER_TIMER7_DTIFS2),        /**< TIMER7 DTIFS2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER8_CC0_MASK)
  SL_HAL_PRS_CONSUMER_TIMER8_CC0 = offsetof(PRS_TypeDef, CONSUMER_TIMER8_CC0),        /**< TIMER8 CC0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER8_CC1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER8_CC1 = offsetof(PRS_TypeDef, CONSUMER_TIMER8_CC1),        /**< TIMER8 CC1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER8_CC2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER8_CC2 = offsetof(PRS_TypeDef, CONSUMER_TIMER8_CC2),        /**< TIMER8 CC2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER8_DTI_MASK)
  SL_HAL_PRS_CONSUMER_TIMER8_DTI = offsetof(PRS_TypeDef, CONSUMER_TIMER8_DTI),        /**< TIMER8 DTI Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER8_DTIFS1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER8_DTIFS1 = offsetof(PRS_TypeDef, CONSUMER_TIMER8_DTIFS1),        /**< TIMER8 DTIFS1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER8_DTIFS2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER8_DTIFS2 = offsetof(PRS_TypeDef, CONSUMER_TIMER8_DTIFS2),        /**< TIMER8 DTIFS2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER9_CC0_MASK)
  SL_HAL_PRS_CONSUMER_TIMER9_CC0 = offsetof(PRS_TypeDef, CONSUMER_TIMER9_CC0),        /**< TIMER9 CC0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER9_CC1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER9_CC1 = offsetof(PRS_TypeDef, CONSUMER_TIMER9_CC1),        /**< TIMER9 CC1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER9_CC2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER9_CC2 = offsetof(PRS_TypeDef, CONSUMER_TIMER9_CC2),        /**< TIMER9 CC2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER9_DTI_MASK)
  SL_HAL_PRS_CONSUMER_TIMER9_DTI = offsetof(PRS_TypeDef, CONSUMER_TIMER9_DTI),        /**< TIMER9 DTI Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER9_DTIFS1_MASK)
  SL_HAL_PRS_CONSUMER_TIMER9_DTIFS1 = offsetof(PRS_TypeDef, CONSUMER_TIMER9_DTIFS1),        /**< TIMER9 DTIFS1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER9_DTIFS2_MASK)
  SL_HAL_PRS_CONSUMER_TIMER9_DTIFS2 = offsetof(PRS_TypeDef, CONSUMER_TIMER9_DTIFS2),        /**< TIMER9 DTIFS2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_USART2_CLK_MASK)
  SL_HAL_PRS_CONSUMER_USART2_CLK = offsetof(PRS_TypeDef, CONSUMER_USART2_CLK),        /**< USART2 CLK consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_USART2_IR_MASK)
  SL_HAL_PRS_CONSUMER_USART2_IR = offsetof(PRS_TypeDef, CONSUMER_USART2_IR),        /**< USART2 IR Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_USART2_RX_MASK)
  SL_HAL_PRS_CONSUMER_USART2_RX = offsetof(PRS_TypeDef, CONSUMER_USART2_RX),        /**< USART2 RX Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_USART2_TRIGGER_MASK)
  SL_HAL_PRS_CONSUMER_USART2_TRIGGER = offsetof(PRS_TypeDef, CONSUMER_USART2_TRIGGER),        /**< USART2 TRIGGER Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_VDAC1_ASYNCTRIGCH0_MASK)
  SL_HAL_PRS_CONSUMER_VDAC1_ASYNCTRIGCH0 = offsetof(PRS_TypeDef, CONSUMER_VDAC1_ASYNCTRIGCH0),        /**< VDAC1 ASYNCTRIGCH0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_VDAC1_ASYNCTRIGCH1_MASK)
  SL_HAL_PRS_CONSUMER_VDAC1_ASYNCTRIGCH1 = offsetof(PRS_TypeDef, CONSUMER_VDAC1_ASYNCTRIGCH1),        /**< VDAC1 ASYNCTRIGCH1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_VDAC1_SYNCTRIGCH0_MASK)
  SL_HAL_PRS_CONSUMER_VDAC1_SYNCTRIGCH0 = offsetof(PRS_TypeDef, CONSUMER_VDAC1_SYNCTRIGCH0),        /**< VDAC1 SYNCTRIGCH0 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_VDAC1_SYNCTRIGCH1_MASK)
  SL_HAL_PRS_CONSUMER_VDAC1_SYNCTRIGCH1 = offsetof(PRS_TypeDef, CONSUMER_VDAC1_SYNCTRIGCH1),        /**< VDAC1 SYNCTRIGCH1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_SE_TAMPERSRC0_MASK)
  SL_HAL_PRS_CONSUMER_SE_TAMPERSRC0 = offsetof(PRS_TypeDef, CONSUMER_SE_TAMPERSRC0),        /**< SE TAMPERSRC0 TAMPERSRC0 Consumer Selection consumer. */
#endif
#if defined(_PRS_CONSUMER_SE_TAMPERSRC1_MASK)
  SL_HAL_PRS_CONSUMER_SE_TAMPERSRC1 = offsetof(PRS_TypeDef, CONSUMER_SE_TAMPERSRC1),        /**< SE TAMPERSRC1 TAMPERSRC1 Consumer Selection consumer. */
#endif
#if defined(_PRS_CONSUMER_SE_TAMPERSRC2_MASK)
  SL_HAL_PRS_CONSUMER_SE_TAMPERSRC2 = offsetof(PRS_TypeDef, CONSUMER_SE_TAMPERSRC2),        /**< SE TAMPERSRC2 TAMPERSRC2 Consumer Selection consumer. */
#endif
#if defined(_PRS_CONSUMER_SE_TAMPERSRC3_MASK)
  SL_HAL_PRS_CONSUMER_SE_TAMPERSRC3 = offsetof(PRS_TypeDef, CONSUMER_SE_TAMPERSRC3),        /**< SE TAMPERSRC3 TAMPERSRC3 Consumer Selection consumer. */
#endif
#if defined(_PRS_CONSUMER_SE_TAMPERSRC4_MASK)
  SL_HAL_PRS_CONSUMER_SE_TAMPERSRC4 = offsetof(PRS_TypeDef, CONSUMER_SE_TAMPERSRC4),        /**< SE TAMPERSRC4 TAMPERSRC4 Consumer Selection consumer. */
#endif
#if defined(_PRS_CONSUMER_SE_TAMPERSRC5_MASK)
  SL_HAL_PRS_CONSUMER_SE_TAMPERSRC5 = offsetof(PRS_TypeDef, CONSUMER_SE_TAMPERSRC5),        /**< SE TAMPERSRC5 TAMPERSRC5 Consumer Selection consumer. */
#endif
#if defined(_PRS_CONSUMER_SE_TAMPERSRC6_MASK)
  SL_HAL_PRS_CONSUMER_SE_TAMPERSRC6 = offsetof(PRS_TypeDef, CONSUMER_SE_TAMPERSRC6),        /**< SE TAMPERSRC6 TAMPERSRC6 Consumer Selection consumer. */
#endif
#if defined(_PRS_CONSUMER_SE_TAMPERSRC7_MASK)
  SL_HAL_PRS_CONSUMER_SE_TAMPERSRC7 = offsetof(PRS_TypeDef, CONSUMER_SE_TAMPERSRC7),        /**< SE TAMPERSRC7 TAMPERSRC7 Consumer Selection consumer. */
#endif
#if defined(_PRS_CONSUMER_EUSART4_CLK_MASK)
  SL_HAL_PRS_CONSUMER_EUSART4_CLK = offsetof(PRS_TypeDef, CONSUMER_EUSART4_CLK),        /**< EUSART4 CLK consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_EUSART4_RX_MASK)
  SL_HAL_PRS_CONSUMER_EUSART4_RX = offsetof(PRS_TypeDef, CONSUMER_EUSART4_RX),        /**< EUSART4 RX Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_EUSART4_TRIGGER_MASK)
  SL_HAL_PRS_CONSUMER_EUSART4_TRIGGER = offsetof(PRS_TypeDef, CONSUMER_EUSART4_TRIGGER),        /**< EUSART4 TRIGGER Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_LESENSE_DECIN0_MASK)
  SL_HAL_PRS_CONSUMER_LESENSE_DECIN0 = offsetof(PRS_TypeDef, CONSUMER_LESENSE_DECIN0),        /**< LESENSE DECIN0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_LESENSE_DECIN1_MASK)
  SL_HAL_PRS_CONSUMER_LESENSE_DECIN1 = offsetof(PRS_TypeDef, CONSUMER_LESENSE_DECIN1),        /**< LESENSE DECIN1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_LESENSE_DECIN2_MASK)
  SL_HAL_PRS_CONSUMER_LESENSE_DECIN2 = offsetof(PRS_TypeDef, CONSUMER_LESENSE_DECIN2),        /**< LESENSE DECIN2 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_LESENSE_DECIN3_MASK)
  SL_HAL_PRS_CONSUMER_LESENSE_DECIN3 = offsetof(PRS_TypeDef, CONSUMER_LESENSE_DECIN3),        /**< LESENSE DECIN3 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_EUART0_RX_MASK)
  SL_HAL_PRS_CONSUMER_EUART0_RX = offsetof(PRS_TypeDef, CONSUMER_EUART0_RX),        /**< RX RX consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_EUART0_TRIGGER_MASK)
  SL_HAL_PRS_CONSUMER_EUART0_TRIGGER = offsetof(PRS_TypeDef, CONSUMER_EUART0_TRIGGER),        /**< TRIGGER TRIGGER Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_LDMAXBAR0_DMAREQ0_MASK)
  SL_HAL_PRS_CONSUMER_LDMAXBAR0_DMAREQ0 = offsetof(PRS_TypeDef, CONSUMER_LDMAXBAR0_DMAREQ0),        /**< LDMAXBAR0 DMAREQ0 consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_LDMAXBAR0_DMAREQ1_MASK)
  SL_HAL_PRS_CONSUMER_LDMAXBAR0_DMAREQ1 = offsetof(PRS_TypeDef, CONSUMER_LDMAXBAR0_DMAREQ1),        /**< LDMAXBAR0 DMAREQ1 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_LEDDRV0_LEDDRV0ASYNC_MASK)
  SL_HAL_PRS_CONSUMER_LEDDRV0_LEDDRV0ASYNC = offsetof(PRS_TypeDef, CONSUMER_LEDDRV0_LEDDRV0ASYNC),        /**< LEDDRV0 LEDDRV0ASYNC consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_LEDDRV0_LEDDRV1ASYNC_MASK)
  SL_HAL_PRS_CONSUMER_LEDDRV0_LEDDRV1ASYNC = offsetof(PRS_TypeDef, CONSUMER_LEDDRV0_LEDDRV1ASYNC),        /**< LEDDRV0 LEDDRV1ASYNC Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_PIXELRZ0_INASYNC_MASK)
  SL_HAL_PRS_CONSUMER_PIXELRZ0_INASYNC = offsetof(PRS_TypeDef, CONSUMER_PIXELRZ0_INASYNC),        /**< PIXELRZ0 INASYNC consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_PIXELRZ1_INASYNC_MASK)
  SL_HAL_PRS_CONSUMER_PIXELRZ1_INASYNC = offsetof(PRS_TypeDef, CONSUMER_PIXELRZ1_INASYNC),        /**< PIXELRZ1 INASYNC consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_ADC0_ASYNCSEQ_MASK)
  SL_HAL_PRS_CONSUMER_ADC0_ASYNCSEQ = offsetof(PRS_TypeDef, CONSUMER_ADC0_ASYNCSEQ),        /**< ADC0 ASYNCSEQ consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_ADC0_SYNCSEQ_MASK)
  SL_HAL_PRS_CONSUMER_ADC0_SYNCSEQ = offsetof(PRS_TypeDef, CONSUMER_ADC0_SYNCSEQ),        /**< ADC0 SYNCSEQ Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER2_CC3_MASK)
  SL_HAL_PRS_CONSUMER_TIMER2_CC3 = offsetof(PRS_TypeDef, CONSUMER_TIMER2_CC3),        /**< TIMER2 CC3 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER2_CC4_MASK)
  SL_HAL_PRS_CONSUMER_TIMER2_CC4 = offsetof(PRS_TypeDef, CONSUMER_TIMER2_CC4),        /**< TIMER2 CC4 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER2_CC5_MASK)
  SL_HAL_PRS_CONSUMER_TIMER2_CC5 = offsetof(PRS_TypeDef, CONSUMER_TIMER2_CC5),        /**< TIMER2 CC5 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER2_CC6_MASK)
  SL_HAL_PRS_CONSUMER_TIMER2_CC6 = offsetof(PRS_TypeDef, CONSUMER_TIMER2_CC6),        /**< TIMER2 CC6 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER3_CC3_MASK)
  SL_HAL_PRS_CONSUMER_TIMER3_CC3 = offsetof(PRS_TypeDef, CONSUMER_TIMER3_CC3),        /**< TIMER3 CC3 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER3_CC4_MASK)
  SL_HAL_PRS_CONSUMER_TIMER3_CC4 = offsetof(PRS_TypeDef, CONSUMER_TIMER3_CC4),        /**< TIMER3 CC4 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER3_CC5_MASK)
  SL_HAL_PRS_CONSUMER_TIMER3_CC5 = offsetof(PRS_TypeDef, CONSUMER_TIMER3_CC5),        /**< TIMER3 CC5 Consumer consumer. */
#endif
#if defined(_PRS_CONSUMER_TIMER3_CC6_MASK)
  SL_HAL_PRS_CONSUMER_TIMER3_CC6 = offsetof(PRS_TypeDef, CONSUMER_TIMER3_CC6),        /**< TIMER3 CC6 Consumer consumer. */
#endif
// {CONSUMERS}
};

/** @} (end addtogroup prs) */

#ifdef __cplusplus
}
#endif

#endif // defined(PRS_COUNT) && (PRS_COUNT > 0)
#endif // SL_HAL_PRS_ENUMS_H
