#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Mon Aug 12 15:50:54 2024 by generateDS.py version 2.12d.
#
# Command line options:
#   ('-o', '..\\..\\model_instance\\base\\Bindings.py')
#   ('--super', 'Bindings')
#   ('-s', '..\\..\\model_instance\\base\\Template.py')
#   ('--subclass-suffix', '')
#   ('--external-encoding', 'ascii')
#   ('-m', '')
#   ('-f', '')
#   ('--silence', '')
#
# Command line arguments:
#   .\model_instance.xsd
#
# Command line:
#   ..\..\generateDS\generateDS.py -o "..\..\model_instance\base\Bindings.py" --super="Bindings" -s "..\..\model_instance\base\Template.py" --subclass-suffix --external-encoding="ascii" -m -f --silence .\model_instance.xsd
#
# Current working directory (os.getcwd()):
#   model_instance
#

import sys
import getopt
import re as re_
import base64
import datetime as datetime_

from pycalcmodel.py2_and_3_compatibility import *

etree_ = None
Verbose_import_ = False
(
    XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class features(GeneratedsSuper):
    """Defines a list of all features used to define the feature variables
    used in all act_logic attributes."""
    subclass = None
    superclass = None
    def __init__(self, feature=None):
        self.original_tagname_ = None
        if feature is None:
            self.feature = []
        else:
            self.feature = feature
    def factory(*args_, **kwargs_):
        if features.subclass:
            return features.subclass(*args_, **kwargs_)
        else:
            return features(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_feature(self): return self.feature
    def set_feature(self, feature): self.feature = feature
    def add_feature(self, value): self.feature.append(value)
    def insert_feature(self, index, value): self.feature[index] = value
    featureProp = property(get_feature, set_feature)
    def hasContent_(self):
        if (
            self.feature
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='features', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='features')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='features', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='features'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='features', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for feature_ in self.feature:
            feature_.export(outfile, level, namespace_, name_='feature', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='features'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('feature=[\n')
        level += 1
        for feature_ in self.feature:
            showIndent(outfile, level)
            outfile.write('model_.featureType(\n')
            feature_.exportLiteral(outfile, level, name_='featureType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'feature':
            obj_ = featureType.factory()
            obj_.build(child_)
            self.feature.append(obj_)
            obj_.original_tagname_ = 'feature'
# end class features


class var_overrides(GeneratedsSuper):
    """An optional override value for this output. This value is used
    during the calculations to override what would be normally
    calculated. So it can be viewed as an "input" to the calculator.
    When present, it will force the var_values above."""
    subclass = None
    superclass = None
    def __init__(self, value=None):
        self.original_tagname_ = None
        if value is None:
            self.value = []
        else:
            self.value = value
    def factory(*args_, **kwargs_):
        if var_overrides.subclass:
            return var_overrides.subclass(*args_, **kwargs_)
        else:
            return var_overrides(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def add_value(self, value): self.value.append(value)
    def insert_value(self, index, value): self.value[index] = value
    valueProp = property(get_value, set_value)
    def hasContent_(self):
        if (
            self.value
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='var_overrides', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='var_overrides')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='var_overrides', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='var_overrides'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='var_overrides', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for value_ in self.value:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(value_), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='var_overrides'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('value=[\n')
        level += 1
        for value_ in self.value:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(value_))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value.append(value_)
# end class var_overrides


class overrides(GeneratedsSuper):
    """An optional override value for this output. This value is used
    during the calculations to override what would be normally
    calculated. This override can be viewed as an "input" to the
    calculator. When present, it will force the var_values output in
    the instance file."""
    subclass = None
    superclass = None
    def __init__(self, value=None):
        self.original_tagname_ = None
        if value is None:
            self.value = []
        else:
            self.value = value
    def factory(*args_, **kwargs_):
        if overrides.subclass:
            return overrides.subclass(*args_, **kwargs_)
        else:
            return overrides(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def add_value(self, value): self.value.append(value)
    def insert_value(self, index, value): self.value[index] = value
    valueProp = property(get_value, set_value)
    def hasContent_(self):
        if (
            self.value
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='overrides', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='overrides')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='overrides', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='overrides'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='overrides', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for value_ in self.value:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(value_), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='overrides'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('value=[\n')
        level += 1
        for value_ in self.value:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(value_))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value.append(value_)
# end class overrides


class defaults(GeneratedsSuper):
    """The default value(s) to assign to the profile input variable."""
    subclass = None
    superclass = None
    def __init__(self, value=None):
        self.original_tagname_ = None
        if value is None:
            self.value = []
        else:
            self.value = value
    def factory(*args_, **kwargs_):
        if defaults.subclass:
            return defaults.subclass(*args_, **kwargs_)
        else:
            return defaults(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def add_value(self, value): self.value.append(value)
    def insert_value(self, index, value): self.value[index] = value
    valueProp = property(get_value, set_value)
    def hasContent_(self):
        if (
            self.value
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='defaults', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='defaults')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='defaults', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='defaults'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='defaults', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for value_ in self.value:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(value_), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='defaults'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('value=[\n')
        level += 1
        for value_ in self.value:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(value_))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value.append(value_)
# end class defaults


class var_values(GeneratedsSuper):
    """Contains the variable's value."""
    subclass = None
    superclass = None
    def __init__(self, value=None):
        self.original_tagname_ = None
        if value is None:
            self.value = []
        else:
            self.value = value
    def factory(*args_, **kwargs_):
        if var_values.subclass:
            return var_values.subclass(*args_, **kwargs_)
        else:
            return var_values(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def add_value(self, value): self.value.append(value)
    def insert_value(self, index, value): self.value[index] = value
    valueProp = property(get_value, set_value)
    def hasContent_(self):
        if (
            self.value
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='var_values', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='var_values')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='var_values', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='var_values'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='var_values', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for value_ in self.value:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(value_), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='var_values'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('value=[\n')
        level += 1
        for value_ in self.value:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(value_))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value.append(value_)
# end class var_values


class values(GeneratedsSuper):
    """The value(s) to assign to the profile variable."""
    subclass = None
    superclass = None
    def __init__(self, value=None):
        self.original_tagname_ = None
        if value is None:
            self.value = []
        else:
            self.value = value
    def factory(*args_, **kwargs_):
        if values.subclass:
            return values.subclass(*args_, **kwargs_)
        else:
            return values(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def add_value(self, value): self.value.append(value)
    def insert_value(self, index, value): self.value[index] = value
    valueProp = property(get_value, set_value)
    def hasContent_(self):
        if (
            self.value
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='values', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='values')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='values', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='values'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='values', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for value_ in self.value:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(value_), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='values'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('value=[\n')
        level += 1
        for value_ in self.value:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(value_))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value.append(value_)
# end class values


class model(GeneratedsSuper):
    """The collection of optional phy initialization, single profile
    instance, and related model variables. This file can be used in
    two steps. First to generate a file to assign the profile inputs
    directly or from a tracked phy. Second to capture the results of
    the profile calculations.The party family. Combined with the
    part_revision to define the calculator variables.The part
    revision. The overall calculator version string for the model
    instance.The version of the model_instance.xsd.A plain text
    description of the model instance.Indicates the calculations
    have run with the profile inputs. If true, see
    result_code.Optional result code to mark the success of the
    calculation run.Optional message to capture a calculator
    exception from invalid profile inputs.Optional timestamp to mark
    the time processed.(e.g. IC, Simulation, FPGA, etc...) Defaults
    to 'IC", if not provided."""
    subclass = None
    superclass = None
    def __init__(self, part_family=None, part_revision=None, calc_version=None, xsd_version=None, desc=None, processed=None, result_code=None, error_message=None, timestamp=None, target='IC', phys=None, profiles=None, variables=None, features=None, logs=None):
        self.original_tagname_ = None
        self.part_family = _cast(None, part_family)
        self.part_revision = _cast(None, part_revision)
        self.calc_version = _cast(None, calc_version)
        self.xsd_version = _cast(None, xsd_version)
        self.desc = _cast(None, desc)
        self.processed = _cast(bool, processed)
        self.result_code = _cast(int, result_code)
        self.error_message = _cast(None, error_message)
        if isinstance(timestamp, basestring):
            initvalue_ = datetime_.datetime.strptime(timestamp, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = timestamp
        self.timestamp = initvalue_
        self.target = _cast(None, target)
        self.phys = phys
        self.profiles = profiles
        self.variables = variables
        self.features = features
        self.logs = logs
    def factory(*args_, **kwargs_):
        if model.subclass:
            return model.subclass(*args_, **kwargs_)
        else:
            return model(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_phys(self): return self.phys
    def set_phys(self, phys): self.phys = phys
    physProp = property(get_phys, set_phys)
    def get_profiles(self): return self.profiles
    def set_profiles(self, profiles): self.profiles = profiles
    profilesProp = property(get_profiles, set_profiles)
    def get_variables(self): return self.variables
    def set_variables(self, variables): self.variables = variables
    variablesProp = property(get_variables, set_variables)
    def get_features(self): return self.features
    def set_features(self, features): self.features = features
    featuresProp = property(get_features, set_features)
    def get_logs(self): return self.logs
    def set_logs(self, logs): self.logs = logs
    logsProp = property(get_logs, set_logs)
    def get_part_family(self): return self.part_family
    def set_part_family(self, part_family): self.part_family = part_family
    part_familyProp = property(get_part_family, set_part_family)
    def get_part_revision(self): return self.part_revision
    def set_part_revision(self, part_revision): self.part_revision = part_revision
    part_revisionProp = property(get_part_revision, set_part_revision)
    def get_calc_version(self): return self.calc_version
    def set_calc_version(self, calc_version): self.calc_version = calc_version
    calc_versionProp = property(get_calc_version, set_calc_version)
    def get_xsd_version(self): return self.xsd_version
    def set_xsd_version(self, xsd_version): self.xsd_version = xsd_version
    xsd_versionProp = property(get_xsd_version, set_xsd_version)
    def get_desc(self): return self.desc
    def set_desc(self, desc): self.desc = desc
    descProp = property(get_desc, set_desc)
    def get_processed(self): return self.processed
    def set_processed(self, processed): self.processed = processed
    processedProp = property(get_processed, set_processed)
    def get_result_code(self): return self.result_code
    def set_result_code(self, result_code): self.result_code = result_code
    result_codeProp = property(get_result_code, set_result_code)
    def get_error_message(self): return self.error_message
    def set_error_message(self, error_message): self.error_message = error_message
    error_messageProp = property(get_error_message, set_error_message)
    def get_timestamp(self): return self.timestamp
    def set_timestamp(self, timestamp): self.timestamp = timestamp
    timestampProp = property(get_timestamp, set_timestamp)
    def get_target(self): return self.target
    def set_target(self, target): self.target = target
    targetProp = property(get_target, set_target)
    def hasContent_(self):
        if (
            self.phys is not None or
            self.profiles is not None or
            self.variables is not None or
            self.features is not None or
            self.logs is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='model', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='model')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='model', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='model'):
        if self.part_family is not None and 'part_family' not in already_processed:
            already_processed.add('part_family')
            outfile.write(' part_family=%s' % (self.gds_format_string(quote_attrib(self.part_family), input_name='part_family'), ))
        if self.part_revision is not None and 'part_revision' not in already_processed:
            already_processed.add('part_revision')
            outfile.write(' part_revision=%s' % (self.gds_format_string(quote_attrib(self.part_revision), input_name='part_revision'), ))
        if self.calc_version is not None and 'calc_version' not in already_processed:
            already_processed.add('calc_version')
            outfile.write(' calc_version=%s' % (self.gds_format_string(quote_attrib(self.calc_version), input_name='calc_version'), ))
        if self.xsd_version is not None and 'xsd_version' not in already_processed:
            already_processed.add('xsd_version')
            outfile.write(' xsd_version=%s' % (self.gds_format_string(quote_attrib(self.xsd_version), input_name='xsd_version'), ))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(' desc=%s' % (self.gds_format_string(quote_attrib(self.desc), input_name='desc'), ))
        if self.processed is not None and 'processed' not in already_processed:
            already_processed.add('processed')
            outfile.write(' processed="%s"' % self.gds_format_boolean(self.processed, input_name='processed'))
        if self.result_code is not None and 'result_code' not in already_processed:
            already_processed.add('result_code')
            outfile.write(' result_code="%s"' % self.gds_format_integer(self.result_code, input_name='result_code'))
        if self.error_message is not None and 'error_message' not in already_processed:
            already_processed.add('error_message')
            outfile.write(' error_message=%s' % (self.gds_format_string(quote_attrib(self.error_message), input_name='error_message'), ))
        if self.timestamp is not None and 'timestamp' not in already_processed:
            already_processed.add('timestamp')
            outfile.write(' timestamp="%s"' % self.gds_format_datetime(self.timestamp, input_name='timestamp'))
        if self.target is not None and 'target' not in already_processed:
            already_processed.add('target')
            outfile.write(' target=%s' % (self.gds_format_string(quote_attrib(self.target), input_name='target'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='model', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.phys is not None:
            self.phys.export(outfile, level, namespace_, name_='phys', pretty_print=pretty_print)
        if self.profiles is not None:
            self.profiles.export(outfile, level, namespace_, name_='profiles', pretty_print=pretty_print)
        if self.variables is not None:
            self.variables.export(outfile, level, namespace_, name_='variables', pretty_print=pretty_print)
        if self.features is not None:
            self.features.export(outfile, level, namespace_, name_='features', pretty_print=pretty_print)
        if self.logs is not None:
            self.logs.export(outfile, level, namespace_, name_='logs', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='model'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.part_family is not None and 'part_family' not in already_processed:
            already_processed.add('part_family')
            showIndent(outfile, level)
            outfile.write('part_family="%s",\n' % (self.part_family,))
        if self.part_revision is not None and 'part_revision' not in already_processed:
            already_processed.add('part_revision')
            showIndent(outfile, level)
            outfile.write('part_revision="%s",\n' % (self.part_revision,))
        if self.calc_version is not None and 'calc_version' not in already_processed:
            already_processed.add('calc_version')
            showIndent(outfile, level)
            outfile.write('calc_version="%s",\n' % (self.calc_version,))
        if self.xsd_version is not None and 'xsd_version' not in already_processed:
            already_processed.add('xsd_version')
            showIndent(outfile, level)
            outfile.write('xsd_version="%s",\n' % (self.xsd_version,))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            showIndent(outfile, level)
            outfile.write('desc="%s",\n' % (self.desc,))
        if self.processed is not None and 'processed' not in already_processed:
            already_processed.add('processed')
            showIndent(outfile, level)
            outfile.write('processed=%s,\n' % (self.processed,))
        if self.result_code is not None and 'result_code' not in already_processed:
            already_processed.add('result_code')
            showIndent(outfile, level)
            outfile.write('result_code=%d,\n' % (self.result_code,))
        if self.error_message is not None and 'error_message' not in already_processed:
            already_processed.add('error_message')
            showIndent(outfile, level)
            outfile.write('error_message="%s",\n' % (self.error_message,))
        if self.timestamp is not None and 'timestamp' not in already_processed:
            already_processed.add('timestamp')
            showIndent(outfile, level)
            outfile.write('timestamp=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.timestamp, input_name='timestamp'))
        if self.target is not None and 'target' not in already_processed:
            already_processed.add('target')
            showIndent(outfile, level)
            outfile.write('target="%s",\n' % (self.target,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.phys is not None:
            showIndent(outfile, level)
            outfile.write('phys=model_.physType(\n')
            self.phys.exportLiteral(outfile, level, name_='phys')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.profiles is not None:
            showIndent(outfile, level)
            outfile.write('profiles=model_.profilesType(\n')
            self.profiles.exportLiteral(outfile, level, name_='profiles')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.variables is not None:
            showIndent(outfile, level)
            outfile.write('variables=model_.variablesType(\n')
            self.variables.exportLiteral(outfile, level, name_='variables')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.features is not None:
            showIndent(outfile, level)
            outfile.write('features=model_.features(\n')
            self.features.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.logs is not None:
            showIndent(outfile, level)
            outfile.write('logs=model_.logsType(\n')
            self.logs.exportLiteral(outfile, level, name_='logs')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('part_family', node)
        if value is not None and 'part_family' not in already_processed:
            already_processed.add('part_family')
            self.part_family = value
        value = find_attr_value_('part_revision', node)
        if value is not None and 'part_revision' not in already_processed:
            already_processed.add('part_revision')
            self.part_revision = value
        value = find_attr_value_('calc_version', node)
        if value is not None and 'calc_version' not in already_processed:
            already_processed.add('calc_version')
            self.calc_version = value
        value = find_attr_value_('xsd_version', node)
        if value is not None and 'xsd_version' not in already_processed:
            already_processed.add('xsd_version')
            self.xsd_version = value
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
        value = find_attr_value_('processed', node)
        if value is not None and 'processed' not in already_processed:
            already_processed.add('processed')
            if value in ('true', '1'):
                self.processed = True
            elif value in ('false', '0'):
                self.processed = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('result_code', node)
        if value is not None and 'result_code' not in already_processed:
            already_processed.add('result_code')
            try:
                self.result_code = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('error_message', node)
        if value is not None and 'error_message' not in already_processed:
            already_processed.add('error_message')
            self.error_message = value
        value = find_attr_value_('timestamp', node)
        if value is not None and 'timestamp' not in already_processed:
            already_processed.add('timestamp')
            try:
                self.timestamp = self.gds_parse_datetime(value)
            except ValueError as exp:
                raise ValueError('Bad date-time attribute (timestamp): %s' % exp)
        value = find_attr_value_('target', node)
        if value is not None and 'target' not in already_processed:
            already_processed.add('target')
            self.target = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'phys':
            obj_ = physType.factory()
            obj_.build(child_)
            self.phys = obj_
            obj_.original_tagname_ = 'phys'
        elif nodeName_ == 'profiles':
            obj_ = profilesType.factory()
            obj_.build(child_)
            self.profiles = obj_
            obj_.original_tagname_ = 'profiles'
        elif nodeName_ == 'variables':
            obj_ = variablesType.factory()
            obj_.build(child_)
            self.variables = obj_
            obj_.original_tagname_ = 'variables'
        elif nodeName_ == 'features':
            obj_ = features.factory()
            obj_.build(child_)
            self.features = obj_
            obj_.original_tagname_ = 'features'
        elif nodeName_ == 'logs':
            obj_ = logsType.factory()
            obj_.build(child_)
            self.logs = obj_
            obj_.original_tagname_ = 'logs'
# end class model


class featureType(GeneratedsSuper):
    """The feature name. This name will be combined with a 'feature_'
    prefix to form the feature variable name used in the act_logic
    attributes.A plain text description of the feature.The Boolean
    value of the feature."""
    subclass = None
    superclass = None
    def __init__(self, name=None, desc=None, value=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.desc = _cast(None, desc)
        self.value = _cast(bool, value)
    def factory(*args_, **kwargs_):
        if featureType.subclass:
            return featureType.subclass(*args_, **kwargs_)
        else:
            return featureType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_desc(self): return self.desc
    def set_desc(self, desc): self.desc = desc
    descProp = property(get_desc, set_desc)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    valueProp = property(get_value, set_value)
    def validate_nameType(self, value):
        # Validate type nameType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='featureType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='featureType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='featureType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='featureType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (quote_attrib(self.name), ))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(' desc=%s' % (self.gds_format_string(quote_attrib(self.desc), input_name='desc'), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value="%s"' % self.gds_format_boolean(self.value, input_name='value'))
    def exportChildren(self, outfile, level, namespace_='', name_='featureType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='featureType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            showIndent(outfile, level)
            outfile.write('desc="%s",\n' % (self.desc,))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % (self.value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
            self.validate_nameType(self.name)    # validate type nameType
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            if value in ('true', '1'):
                self.value = True
            elif value in ('false', '0'):
                self.value = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class featureType


class physType(GeneratedsSuper):
    """Contains an optional phy used to initialize the profile."""
    subclass = None
    superclass = None
    def __init__(self, phy=None):
        self.original_tagname_ = None
        self.phy = phy
    def factory(*args_, **kwargs_):
        if physType.subclass:
            return physType.subclass(*args_, **kwargs_)
        else:
            return physType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_phy(self): return self.phy
    def set_phy(self, phy): self.phy = phy
    phyProp = property(get_phy, set_phy)
    def hasContent_(self):
        if (
            self.phy is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='physType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='physType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='physType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='physType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='physType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.phy is not None:
            self.phy.export(outfile, level, namespace_, name_='phy', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='physType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.phy is not None:
            showIndent(outfile, level)
            outfile.write('phy=model_.phyType(\n')
            self.phy.exportLiteral(outfile, level, name_='phy')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'phy':
            obj_ = phyType.factory()
            obj_.build(child_)
            self.phy = obj_
            obj_.original_tagname_ = 'phy'
# end class physType


class phyType(GeneratedsSuper):
    """A phy is a collection of preconfigured values for direct use by the
    user. Internally maps to a profile name and version. For the
    model instance, this optional member indicates the exact phy
    values were assigned to the profile with no modifications.The
    phy name. The name to display in the GUI.A plain text
    description of the phy.The name used to collect a group of
    similar phys.The profile name to pass the phy input values.The
    Boolean expression of feature_NAME variables with logical AND
    (double ampersands), OR (double pipes), and/or NOT (exclamation)
    operators. Use parenthesis to group. An empty string defaults to
    true.User definable hastagsWhether this is a precaclaulted PHY,
    and thus not neededin to run calcaultions againUnique ID used as
    an alternative to phy name."""
    subclass = None
    superclass = None
    def __init__(self, name=None, readable_name=None, desc=None, group_name=None, profile_name=None, act_logic=None, tags=None, locked=False, guid=None, profile_inputs=None, profile_outputs=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.readable_name = _cast(None, readable_name)
        self.desc = _cast(None, desc)
        self.group_name = _cast(None, group_name)
        self.profile_name = _cast(None, profile_name)
        self.act_logic = _cast(None, act_logic)
        self.tags = _cast(None, tags)
        self.locked = _cast(bool, locked)
        self.guid = _cast(None, guid)
        self.profile_inputs = profile_inputs
        self.profile_outputs = profile_outputs
    def factory(*args_, **kwargs_):
        if phyType.subclass:
            return phyType.subclass(*args_, **kwargs_)
        else:
            return phyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_profile_inputs(self): return self.profile_inputs
    def set_profile_inputs(self, profile_inputs): self.profile_inputs = profile_inputs
    profile_inputsProp = property(get_profile_inputs, set_profile_inputs)
    def get_profile_outputs(self): return self.profile_outputs
    def set_profile_outputs(self, profile_outputs): self.profile_outputs = profile_outputs
    profile_outputsProp = property(get_profile_outputs, set_profile_outputs)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_readable_name(self): return self.readable_name
    def set_readable_name(self, readable_name): self.readable_name = readable_name
    readable_nameProp = property(get_readable_name, set_readable_name)
    def get_desc(self): return self.desc
    def set_desc(self, desc): self.desc = desc
    descProp = property(get_desc, set_desc)
    def get_group_name(self): return self.group_name
    def set_group_name(self, group_name): self.group_name = group_name
    group_nameProp = property(get_group_name, set_group_name)
    def get_profile_name(self): return self.profile_name
    def set_profile_name(self, profile_name): self.profile_name = profile_name
    profile_nameProp = property(get_profile_name, set_profile_name)
    def get_act_logic(self): return self.act_logic
    def set_act_logic(self, act_logic): self.act_logic = act_logic
    act_logicProp = property(get_act_logic, set_act_logic)
    def get_tags(self): return self.tags
    def set_tags(self, tags): self.tags = tags
    tagsProp = property(get_tags, set_tags)
    def get_locked(self): return self.locked
    def set_locked(self, locked): self.locked = locked
    lockedProp = property(get_locked, set_locked)
    def get_guid(self): return self.guid
    def set_guid(self, guid): self.guid = guid
    guidProp = property(get_guid, set_guid)
    def validate_nameType(self, value):
        # Validate type nameType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.profile_inputs is not None or
            self.profile_outputs is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='phyType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='phyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='phyType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='phyType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (quote_attrib(self.name), ))
        if self.readable_name is not None and 'readable_name' not in already_processed:
            already_processed.add('readable_name')
            outfile.write(' readable_name=%s' % (self.gds_format_string(quote_attrib(self.readable_name), input_name='readable_name'), ))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(' desc=%s' % (self.gds_format_string(quote_attrib(self.desc), input_name='desc'), ))
        if self.group_name is not None and 'group_name' not in already_processed:
            already_processed.add('group_name')
            outfile.write(' group_name=%s' % (quote_attrib(self.group_name), ))
        if self.profile_name is not None and 'profile_name' not in already_processed:
            already_processed.add('profile_name')
            outfile.write(' profile_name=%s' % (quote_attrib(self.profile_name), ))
        if self.act_logic is not None and 'act_logic' not in already_processed:
            already_processed.add('act_logic')
            outfile.write(' act_logic=%s' % (self.gds_format_string(quote_attrib(self.act_logic), input_name='act_logic'), ))
        if self.tags is not None and 'tags' not in already_processed:
            already_processed.add('tags')
            outfile.write(' tags=%s' % (self.gds_format_string(quote_attrib(self.tags), input_name='tags'), ))
        if self.locked is not None and 'locked' not in already_processed:
            already_processed.add('locked')
            outfile.write(' locked="%s"' % self.gds_format_boolean(self.locked, input_name='locked'))
        if self.guid is not None and 'guid' not in already_processed:
            already_processed.add('guid')
            outfile.write(' guid=%s' % (self.gds_format_string(quote_attrib(self.guid), input_name='guid'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='phyType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.profile_inputs is not None:
            self.profile_inputs.export(outfile, level, namespace_, name_='profile_inputs', pretty_print=pretty_print)
        if self.profile_outputs is not None:
            self.profile_outputs.export(outfile, level, namespace_, name_='profile_outputs', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='phyType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.readable_name is not None and 'readable_name' not in already_processed:
            already_processed.add('readable_name')
            showIndent(outfile, level)
            outfile.write('readable_name="%s",\n' % (self.readable_name,))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            showIndent(outfile, level)
            outfile.write('desc="%s",\n' % (self.desc,))
        if self.group_name is not None and 'group_name' not in already_processed:
            already_processed.add('group_name')
            showIndent(outfile, level)
            outfile.write('group_name="%s",\n' % (self.group_name,))
        if self.profile_name is not None and 'profile_name' not in already_processed:
            already_processed.add('profile_name')
            showIndent(outfile, level)
            outfile.write('profile_name="%s",\n' % (self.profile_name,))
        if self.act_logic is not None and 'act_logic' not in already_processed:
            already_processed.add('act_logic')
            showIndent(outfile, level)
            outfile.write('act_logic="%s",\n' % (self.act_logic,))
        if self.tags is not None and 'tags' not in already_processed:
            already_processed.add('tags')
            showIndent(outfile, level)
            outfile.write('tags="%s",\n' % (self.tags,))
        if self.locked is not None and 'locked' not in already_processed:
            already_processed.add('locked')
            showIndent(outfile, level)
            outfile.write('locked=%s,\n' % (self.locked,))
        if self.guid is not None and 'guid' not in already_processed:
            already_processed.add('guid')
            showIndent(outfile, level)
            outfile.write('guid="%s",\n' % (self.guid,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.profile_inputs is not None:
            showIndent(outfile, level)
            outfile.write('profile_inputs=model_.profile_inputsType(\n')
            self.profile_inputs.exportLiteral(outfile, level, name_='profile_inputs')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.profile_outputs is not None:
            showIndent(outfile, level)
            outfile.write('profile_outputs=model_.profile_outputsType(\n')
            self.profile_outputs.exportLiteral(outfile, level, name_='profile_outputs')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
            self.validate_nameType(self.name)    # validate type nameType
        value = find_attr_value_('readable_name', node)
        if value is not None and 'readable_name' not in already_processed:
            already_processed.add('readable_name')
            self.readable_name = value
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
        value = find_attr_value_('group_name', node)
        if value is not None and 'group_name' not in already_processed:
            already_processed.add('group_name')
            self.group_name = value
            self.validate_nameType(self.group_name)    # validate type nameType
        value = find_attr_value_('profile_name', node)
        if value is not None and 'profile_name' not in already_processed:
            already_processed.add('profile_name')
            self.profile_name = value
            self.validate_nameType(self.profile_name)    # validate type nameType
        value = find_attr_value_('act_logic', node)
        if value is not None and 'act_logic' not in already_processed:
            already_processed.add('act_logic')
            self.act_logic = value
        value = find_attr_value_('tags', node)
        if value is not None and 'tags' not in already_processed:
            already_processed.add('tags')
            self.tags = value
        value = find_attr_value_('locked', node)
        if value is not None and 'locked' not in already_processed:
            already_processed.add('locked')
            if value in ('true', '1'):
                self.locked = True
            elif value in ('false', '0'):
                self.locked = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('guid', node)
        if value is not None and 'guid' not in already_processed:
            already_processed.add('guid')
            self.guid = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'profile_inputs':
            obj_ = profile_inputsType.factory()
            obj_.build(child_)
            self.profile_inputs = obj_
            obj_.original_tagname_ = 'profile_inputs'
        elif nodeName_ == 'profile_outputs':
            obj_ = profile_outputsType.factory()
            obj_.build(child_)
            self.profile_outputs = obj_
            obj_.original_tagname_ = 'profile_outputs'
# end class phyType


class profile_inputsType(GeneratedsSuper):
    """The collection of input variables. Specify the name and the value.
    These inputs are NOT exposed to user for modification."""
    subclass = None
    superclass = None
    def __init__(self, profile_input=None):
        self.original_tagname_ = None
        if profile_input is None:
            self.profile_input = []
        else:
            self.profile_input = profile_input
    def factory(*args_, **kwargs_):
        if profile_inputsType.subclass:
            return profile_inputsType.subclass(*args_, **kwargs_)
        else:
            return profile_inputsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_profile_input(self): return self.profile_input
    def set_profile_input(self, profile_input): self.profile_input = profile_input
    def add_profile_input(self, value): self.profile_input.append(value)
    def insert_profile_input(self, index, value): self.profile_input[index] = value
    profile_inputProp = property(get_profile_input, set_profile_input)
    def hasContent_(self):
        if (
            self.profile_input
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='profile_inputsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='profile_inputsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='profile_inputsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='profile_inputsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='profile_inputsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for profile_input_ in self.profile_input:
            profile_input_.export(outfile, level, namespace_, name_='profile_input', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='profile_inputsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('profile_input=[\n')
        level += 1
        for profile_input_ in self.profile_input:
            showIndent(outfile, level)
            outfile.write('model_.profile_inputType(\n')
            profile_input_.exportLiteral(outfile, level, name_='profile_inputType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'profile_input':
            obj_ = profile_inputType.factory()
            obj_.build(child_)
            self.profile_input.append(obj_)
            obj_.original_tagname_ = 'profile_input'
# end class profile_inputsType


class profile_inputType(GeneratedsSuper):
    """An input variable name, where the variable must have an forced
    value.Specifies if this input has array of data."""
    subclass = None
    superclass = None
    def __init__(self, is_array=None, readable_name=None, var_name=None, category=None, values=None):
        self.original_tagname_ = None
        self.is_array = _cast(bool, is_array)
        self.readable_name = readable_name
        self.var_name = var_name
        self.category = category
        self.values = values
    def factory(*args_, **kwargs_):
        if profile_inputType.subclass:
            return profile_inputType.subclass(*args_, **kwargs_)
        else:
            return profile_inputType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_readable_name(self): return self.readable_name
    def set_readable_name(self, readable_name): self.readable_name = readable_name
    readable_nameProp = property(get_readable_name, set_readable_name)
    def get_var_name(self): return self.var_name
    def set_var_name(self, var_name): self.var_name = var_name
    var_nameProp = property(get_var_name, set_var_name)
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    categoryProp = property(get_category, set_category)
    def get_values(self): return self.values
    def set_values(self, values): self.values = values
    valuesProp = property(get_values, set_values)
    def get_is_array(self): return self.is_array
    def set_is_array(self, is_array): self.is_array = is_array
    is_arrayProp = property(get_is_array, set_is_array)
    def hasContent_(self):
        if (
            self.readable_name is not None or
            self.var_name is not None or
            self.category is not None or
            self.values is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='profile_inputType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='profile_inputType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='profile_inputType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='profile_inputType'):
        if self.is_array is not None and 'is_array' not in already_processed:
            already_processed.add('is_array')
            outfile.write(' is_array="%s"' % self.gds_format_boolean(self.is_array, input_name='is_array'))
    def exportChildren(self, outfile, level, namespace_='', name_='profile_inputType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.readable_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreadable_name>%s</%sreadable_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.readable_name), input_name='readable_name'), namespace_, eol_))
        if self.var_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svar_name>%s</%svar_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.var_name), input_name='var_name'), namespace_, eol_))
        if self.category is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scategory>%s</%scategory>%s' % (namespace_, self.gds_format_string(quote_xml(self.category), input_name='category'), namespace_, eol_))
        if self.values is not None:
            self.values.export(outfile, level, namespace_, name_='values', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='profile_inputType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.is_array is not None and 'is_array' not in already_processed:
            already_processed.add('is_array')
            showIndent(outfile, level)
            outfile.write('is_array=%s,\n' % (self.is_array,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.readable_name is not None:
            showIndent(outfile, level)
            outfile.write('readable_name=%s,\n' % quote_python(self.readable_name))
        if self.var_name is not None:
            showIndent(outfile, level)
            outfile.write('var_name=%s,\n' % quote_python(self.var_name))
        if self.category is not None:
            showIndent(outfile, level)
            outfile.write('category=%s,\n' % quote_python(self.category))
        if self.values is not None:
            showIndent(outfile, level)
            outfile.write('values=model_.values(\n')
            self.values.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('is_array', node)
        if value is not None and 'is_array' not in already_processed:
            already_processed.add('is_array')
            if value in ('true', '1'):
                self.is_array = True
            elif value in ('false', '0'):
                self.is_array = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'readable_name':
            readable_name_ = child_.text
            readable_name_ = self.gds_validate_string(readable_name_, node, 'readable_name')
            self.readable_name = readable_name_
        elif nodeName_ == 'var_name':
            var_name_ = child_.text
            var_name_ = self.gds_validate_string(var_name_, node, 'var_name')
            self.var_name = var_name_
        elif nodeName_ == 'category':
            category_ = child_.text
            category_ = self.gds_validate_string(category_, node, 'category')
            self.category = category_
        elif nodeName_ == 'values':
            obj_ = values.factory()
            obj_.build(child_)
            self.values = obj_
            obj_.original_tagname_ = 'values'
# end class profile_inputType


class profile_outputsType(GeneratedsSuper):
    """The collection of profile output override values. Specify the name
    and override value. The override inputs are NOT exposed to the
    user for modification."""
    subclass = None
    superclass = None
    def __init__(self, profile_output=None):
        self.original_tagname_ = None
        if profile_output is None:
            self.profile_output = []
        else:
            self.profile_output = profile_output
    def factory(*args_, **kwargs_):
        if profile_outputsType.subclass:
            return profile_outputsType.subclass(*args_, **kwargs_)
        else:
            return profile_outputsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_profile_output(self): return self.profile_output
    def set_profile_output(self, profile_output): self.profile_output = profile_output
    def add_profile_output(self, value): self.profile_output.append(value)
    def insert_profile_output(self, index, value): self.profile_output[index] = value
    profile_outputProp = property(get_profile_output, set_profile_output)
    def hasContent_(self):
        if (
            self.profile_output
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='profile_outputsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='profile_outputsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='profile_outputsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='profile_outputsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='profile_outputsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for profile_output_ in self.profile_output:
            profile_output_.export(outfile, level, namespace_, name_='profile_output', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='profile_outputsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('profile_output=[\n')
        level += 1
        for profile_output_ in self.profile_output:
            showIndent(outfile, level)
            outfile.write('model_.profile_outputType(\n')
            profile_output_.exportLiteral(outfile, level, name_='profile_outputType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'profile_output':
            obj_ = profile_outputType.factory()
            obj_.build(child_)
            self.profile_output.append(obj_)
            obj_.original_tagname_ = 'profile_output'
# end class profile_outputsType


class profile_outputType(GeneratedsSuper):
    """An output variable name, where the calculated output value is
    overridden. This can be viewed as an input to the
    calculatorSpecifies if this output has array of data."""
    subclass = None
    superclass = None
    def __init__(self, is_array=None, readable_name=None, category=None, var_name=None, overrides=None, groups=None):
        self.original_tagname_ = None
        self.is_array = _cast(bool, is_array)
        self.readable_name = readable_name
        self.category = category
        self.var_name = var_name
        self.overrides = overrides
        self.groups = groups
    def factory(*args_, **kwargs_):
        if profile_outputType.subclass:
            return profile_outputType.subclass(*args_, **kwargs_)
        else:
            return profile_outputType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_readable_name(self): return self.readable_name
    def set_readable_name(self, readable_name): self.readable_name = readable_name
    readable_nameProp = property(get_readable_name, set_readable_name)
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    categoryProp = property(get_category, set_category)
    def get_var_name(self): return self.var_name
    def set_var_name(self, var_name): self.var_name = var_name
    var_nameProp = property(get_var_name, set_var_name)
    def get_overrides(self): return self.overrides
    def set_overrides(self, overrides): self.overrides = overrides
    overridesProp = property(get_overrides, set_overrides)
    def get_groups(self): return self.groups
    def set_groups(self, groups): self.groups = groups
    groupsProp = property(get_groups, set_groups)
    def get_is_array(self): return self.is_array
    def set_is_array(self, is_array): self.is_array = is_array
    is_arrayProp = property(get_is_array, set_is_array)
    def hasContent_(self):
        if (
            self.readable_name is not None or
            self.category is not None or
            self.var_name is not None or
            self.overrides is not None or
            self.groups is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='profile_outputType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='profile_outputType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='profile_outputType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='profile_outputType'):
        if self.is_array is not None and 'is_array' not in already_processed:
            already_processed.add('is_array')
            outfile.write(' is_array="%s"' % self.gds_format_boolean(self.is_array, input_name='is_array'))
    def exportChildren(self, outfile, level, namespace_='', name_='profile_outputType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.readable_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreadable_name>%s</%sreadable_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.readable_name), input_name='readable_name'), namespace_, eol_))
        if self.category is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scategory>%s</%scategory>%s' % (namespace_, self.gds_format_string(quote_xml(self.category), input_name='category'), namespace_, eol_))
        if self.var_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svar_name>%s</%svar_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.var_name), input_name='var_name'), namespace_, eol_))
        if self.overrides is not None:
            self.overrides.export(outfile, level, namespace_, name_='overrides', pretty_print=pretty_print)
        if self.groups is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgroups>%s</%sgroups>%s' % (namespace_, self.gds_format_string(quote_xml(self.groups), input_name='groups'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='profile_outputType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.is_array is not None and 'is_array' not in already_processed:
            already_processed.add('is_array')
            showIndent(outfile, level)
            outfile.write('is_array=%s,\n' % (self.is_array,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.readable_name is not None:
            showIndent(outfile, level)
            outfile.write('readable_name=%s,\n' % quote_python(self.readable_name))
        if self.category is not None:
            showIndent(outfile, level)
            outfile.write('category=%s,\n' % quote_python(self.category))
        if self.var_name is not None:
            showIndent(outfile, level)
            outfile.write('var_name=%s,\n' % quote_python(self.var_name))
        if self.overrides is not None:
            showIndent(outfile, level)
            outfile.write('overrides=model_.overrides(\n')
            self.overrides.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.groups is not None:
            showIndent(outfile, level)
            outfile.write('groups=%s,\n' % quote_python(self.groups))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('is_array', node)
        if value is not None and 'is_array' not in already_processed:
            already_processed.add('is_array')
            if value in ('true', '1'):
                self.is_array = True
            elif value in ('false', '0'):
                self.is_array = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'readable_name':
            readable_name_ = child_.text
            readable_name_ = self.gds_validate_string(readable_name_, node, 'readable_name')
            self.readable_name = readable_name_
        elif nodeName_ == 'category':
            category_ = child_.text
            category_ = self.gds_validate_string(category_, node, 'category')
            self.category = category_
        elif nodeName_ == 'var_name':
            var_name_ = child_.text
            var_name_ = self.gds_validate_string(var_name_, node, 'var_name')
            self.var_name = var_name_
        elif nodeName_ == 'overrides':
            obj_ = overrides.factory()
            obj_.build(child_)
            self.overrides = obj_
            obj_.original_tagname_ = 'overrides'
        elif nodeName_ == 'groups':
            groups_ = child_.text
            groups_ = self.gds_validate_string(groups_, node, 'groups')
            self.groups = groups_
# end class profile_outputType


class profilesType(GeneratedsSuper):
    """Contains a single instance of the profile selected for this
    instance."""
    subclass = None
    superclass = None
    def __init__(self, profile=None):
        self.original_tagname_ = None
        self.profile = profile
    def factory(*args_, **kwargs_):
        if profilesType.subclass:
            return profilesType.subclass(*args_, **kwargs_)
        else:
            return profilesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_profile(self): return self.profile
    def set_profile(self, profile): self.profile = profile
    profileProp = property(get_profile, set_profile)
    def hasContent_(self):
        if (
            self.profile is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='profilesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='profilesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='profilesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='profilesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='profilesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.profile is not None:
            self.profile.export(outfile, level, namespace_, name_='profile', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='profilesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.profile is not None:
            showIndent(outfile, level)
            outfile.write('profile=model_.profileType(\n')
            self.profile.exportLiteral(outfile, level, name_='profile')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'profile':
            obj_ = profileType.factory()
            obj_.build(child_)
            self.profile = obj_
            obj_.original_tagname_ = 'profile'
# end class profilesType


class profileType(GeneratedsSuper):
    """A profile defines one or more input variables with defaults, any
    internal variables to be forced, and the corresponding
    calculated output variables.The name of the calculation or
    configuration represented by this profile.The name to display in
    the GUI.Used to organize profiles for display.A plain text
    description of the profile. Explain what happens here. What is
    computed.Indicates this is the default profile to display to the
    user.The Boolean expression of feature_NAME variables with
    logical AND (double ampersands), OR (double pipes), and/or NOT
    (exclamation) operators. Use parenthesis to group. An empty
    string defaults to true."""
    subclass = None
    superclass = None
    def __init__(self, name=None, readable_name=None, category=None, desc=None, default=None, act_logic=None, inputs=None, forces=None, outputs=None, default_phys=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.readable_name = _cast(None, readable_name)
        self.category = _cast(None, category)
        self.desc = _cast(None, desc)
        self.default = _cast(bool, default)
        self.act_logic = _cast(None, act_logic)
        self.inputs = inputs
        self.forces = forces
        self.outputs = outputs
        self.default_phys = default_phys
    def factory(*args_, **kwargs_):
        if profileType.subclass:
            return profileType.subclass(*args_, **kwargs_)
        else:
            return profileType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_inputs(self): return self.inputs
    def set_inputs(self, inputs): self.inputs = inputs
    inputsProp = property(get_inputs, set_inputs)
    def get_forces(self): return self.forces
    def set_forces(self, forces): self.forces = forces
    forcesProp = property(get_forces, set_forces)
    def get_outputs(self): return self.outputs
    def set_outputs(self, outputs): self.outputs = outputs
    outputsProp = property(get_outputs, set_outputs)
    def get_default_phys(self): return self.default_phys
    def set_default_phys(self, default_phys): self.default_phys = default_phys
    default_physProp = property(get_default_phys, set_default_phys)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_readable_name(self): return self.readable_name
    def set_readable_name(self, readable_name): self.readable_name = readable_name
    readable_nameProp = property(get_readable_name, set_readable_name)
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    categoryProp = property(get_category, set_category)
    def get_desc(self): return self.desc
    def set_desc(self, desc): self.desc = desc
    descProp = property(get_desc, set_desc)
    def get_default(self): return self.default
    def set_default(self, default): self.default = default
    defaultProp = property(get_default, set_default)
    def get_act_logic(self): return self.act_logic
    def set_act_logic(self, act_logic): self.act_logic = act_logic
    act_logicProp = property(get_act_logic, set_act_logic)
    def validate_nameType(self, value):
        # Validate type nameType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.inputs is not None or
            self.forces is not None or
            self.outputs is not None or
            self.default_phys is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='profileType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='profileType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='profileType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='profileType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (quote_attrib(self.name), ))
        if self.readable_name is not None and 'readable_name' not in already_processed:
            already_processed.add('readable_name')
            outfile.write(' readable_name=%s' % (self.gds_format_string(quote_attrib(self.readable_name), input_name='readable_name'), ))
        if self.category is not None and 'category' not in already_processed:
            already_processed.add('category')
            outfile.write(' category=%s' % (self.gds_format_string(quote_attrib(self.category), input_name='category'), ))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(' desc=%s' % (self.gds_format_string(quote_attrib(self.desc), input_name='desc'), ))
        if self.default is not None and 'default' not in already_processed:
            already_processed.add('default')
            outfile.write(' default="%s"' % self.gds_format_boolean(self.default, input_name='default'))
        if self.act_logic is not None and 'act_logic' not in already_processed:
            already_processed.add('act_logic')
            outfile.write(' act_logic=%s' % (self.gds_format_string(quote_attrib(self.act_logic), input_name='act_logic'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='profileType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.inputs is not None:
            self.inputs.export(outfile, level, namespace_, name_='inputs', pretty_print=pretty_print)
        if self.forces is not None:
            self.forces.export(outfile, level, namespace_, name_='forces', pretty_print=pretty_print)
        if self.outputs is not None:
            self.outputs.export(outfile, level, namespace_, name_='outputs', pretty_print=pretty_print)
        if self.default_phys is not None:
            self.default_phys.export(outfile, level, namespace_, name_='default_phys', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='profileType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.readable_name is not None and 'readable_name' not in already_processed:
            already_processed.add('readable_name')
            showIndent(outfile, level)
            outfile.write('readable_name="%s",\n' % (self.readable_name,))
        if self.category is not None and 'category' not in already_processed:
            already_processed.add('category')
            showIndent(outfile, level)
            outfile.write('category="%s",\n' % (self.category,))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            showIndent(outfile, level)
            outfile.write('desc="%s",\n' % (self.desc,))
        if self.default is not None and 'default' not in already_processed:
            already_processed.add('default')
            showIndent(outfile, level)
            outfile.write('default=%s,\n' % (self.default,))
        if self.act_logic is not None and 'act_logic' not in already_processed:
            already_processed.add('act_logic')
            showIndent(outfile, level)
            outfile.write('act_logic="%s",\n' % (self.act_logic,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.inputs is not None:
            showIndent(outfile, level)
            outfile.write('inputs=model_.inputsType(\n')
            self.inputs.exportLiteral(outfile, level, name_='inputs')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.forces is not None:
            showIndent(outfile, level)
            outfile.write('forces=model_.forcesType(\n')
            self.forces.exportLiteral(outfile, level, name_='forces')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.outputs is not None:
            showIndent(outfile, level)
            outfile.write('outputs=model_.outputsType(\n')
            self.outputs.exportLiteral(outfile, level, name_='outputs')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.default_phys is not None:
            showIndent(outfile, level)
            outfile.write('default_phys=model_.default_physType(\n')
            self.default_phys.exportLiteral(outfile, level, name_='default_phys')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
            self.validate_nameType(self.name)    # validate type nameType
        value = find_attr_value_('readable_name', node)
        if value is not None and 'readable_name' not in already_processed:
            already_processed.add('readable_name')
            self.readable_name = value
        value = find_attr_value_('category', node)
        if value is not None and 'category' not in already_processed:
            already_processed.add('category')
            self.category = value
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
        value = find_attr_value_('default', node)
        if value is not None and 'default' not in already_processed:
            already_processed.add('default')
            if value in ('true', '1'):
                self.default = True
            elif value in ('false', '0'):
                self.default = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('act_logic', node)
        if value is not None and 'act_logic' not in already_processed:
            already_processed.add('act_logic')
            self.act_logic = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'inputs':
            obj_ = inputsType.factory()
            obj_.build(child_)
            self.inputs = obj_
            obj_.original_tagname_ = 'inputs'
        elif nodeName_ == 'forces':
            obj_ = forcesType.factory()
            obj_.build(child_)
            self.forces = obj_
            obj_.original_tagname_ = 'forces'
        elif nodeName_ == 'outputs':
            obj_ = outputsType.factory()
            obj_.build(child_)
            self.outputs = obj_
            obj_.original_tagname_ = 'outputs'
        elif nodeName_ == 'default_phys':
            obj_ = default_physType.factory()
            obj_.build(child_)
            self.default_phys = obj_
            obj_.original_tagname_ = 'default_phys'
# end class profileType


class inputsType(GeneratedsSuper):
    """The collection of input variables. Specify the name and the default
    value. Exposed to user for modification."""
    subclass = None
    superclass = None
    def __init__(self, input=None):
        self.original_tagname_ = None
        if input is None:
            self.input = []
        else:
            self.input = input
    def factory(*args_, **kwargs_):
        if inputsType.subclass:
            return inputsType.subclass(*args_, **kwargs_)
        else:
            return inputsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_input(self): return self.input
    def set_input(self, input): self.input = input
    def add_input(self, value): self.input.append(value)
    def insert_input(self, index, value): self.input[index] = value
    inputProp = property(get_input, set_input)
    def hasContent_(self):
        if (
            self.input
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='inputsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='inputsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='inputsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='inputsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='inputsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for input_ in self.input:
            input_.export(outfile, level, namespace_, name_='input', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='inputsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('input=[\n')
        level += 1
        for input_ in self.input:
            showIndent(outfile, level)
            outfile.write('model_.inputType1(\n')
            input_.exportLiteral(outfile, level, name_='inputType1')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'input':
            obj_ = inputType1.factory()
            obj_.build(child_)
            self.input.append(obj_)
            obj_.original_tagname_ = 'input'
# end class inputsType


class inputType1(GeneratedsSuper):
    """An input variable name, where the variable must have an forced
    value.Specifies if this input has array of data.Describes the
    purpose of this input variable.An optional minimum value,
    inclusive.An optional maximum value, inclusive.Specifies the
    number of fractional digits to display for a float or fixed
    point value.Boolean that defines this input as deprecatedType of
    visibility applicable to a GUIDefine the units multiplier when
    shown on the GUI."""
    subclass = None
    superclass = None
    def __init__(self, is_array=None, input_type=None, value_limit_min=None, value_limit_max=None, fractional_digits=None, deprecated=None, default_visiblity=None, units_multiplier=None, readable_name=None, category=None, var_name=None, var_values=None, defaults=None):
        self.original_tagname_ = None
        self.is_array = _cast(bool, is_array)
        self.input_type = _cast(None, input_type)
        self.value_limit_min = _cast(None, value_limit_min)
        self.value_limit_max = _cast(None, value_limit_max)
        self.fractional_digits = _cast(int, fractional_digits)
        self.deprecated = _cast(bool, deprecated)
        self.default_visiblity = _cast(None, default_visiblity)
        self.units_multiplier = _cast(None, units_multiplier)
        self.readable_name = readable_name
        self.category = category
        self.var_name = var_name
        self.var_values = var_values
        self.defaults = defaults
    def factory(*args_, **kwargs_):
        if inputType1.subclass:
            return inputType1.subclass(*args_, **kwargs_)
        else:
            return inputType1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_readable_name(self): return self.readable_name
    def set_readable_name(self, readable_name): self.readable_name = readable_name
    readable_nameProp = property(get_readable_name, set_readable_name)
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    categoryProp = property(get_category, set_category)
    def get_var_name(self): return self.var_name
    def set_var_name(self, var_name): self.var_name = var_name
    var_nameProp = property(get_var_name, set_var_name)
    def get_var_values(self): return self.var_values
    def set_var_values(self, var_values): self.var_values = var_values
    var_valuesProp = property(get_var_values, set_var_values)
    def get_defaults(self): return self.defaults
    def set_defaults(self, defaults): self.defaults = defaults
    defaultsProp = property(get_defaults, set_defaults)
    def get_is_array(self): return self.is_array
    def set_is_array(self, is_array): self.is_array = is_array
    is_arrayProp = property(get_is_array, set_is_array)
    def get_input_type(self): return self.input_type
    def set_input_type(self, input_type): self.input_type = input_type
    input_typeProp = property(get_input_type, set_input_type)
    def get_value_limit_min(self): return self.value_limit_min
    def set_value_limit_min(self, value_limit_min): self.value_limit_min = value_limit_min
    value_limit_minProp = property(get_value_limit_min, set_value_limit_min)
    def get_value_limit_max(self): return self.value_limit_max
    def set_value_limit_max(self, value_limit_max): self.value_limit_max = value_limit_max
    value_limit_maxProp = property(get_value_limit_max, set_value_limit_max)
    def get_fractional_digits(self): return self.fractional_digits
    def set_fractional_digits(self, fractional_digits): self.fractional_digits = fractional_digits
    fractional_digitsProp = property(get_fractional_digits, set_fractional_digits)
    def get_deprecated(self): return self.deprecated
    def set_deprecated(self, deprecated): self.deprecated = deprecated
    deprecatedProp = property(get_deprecated, set_deprecated)
    def get_default_visiblity(self): return self.default_visiblity
    def set_default_visiblity(self, default_visiblity): self.default_visiblity = default_visiblity
    default_visiblityProp = property(get_default_visiblity, set_default_visiblity)
    def get_units_multiplier(self): return self.units_multiplier
    def set_units_multiplier(self, units_multiplier): self.units_multiplier = units_multiplier
    units_multiplierProp = property(get_units_multiplier, set_units_multiplier)
    def validate_inputType(self, value):
        # Validate type inputType, a restriction on xs:string.
        pass
    def validate_visibilityType(self, value):
        # Validate type visibilityType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.readable_name is not None or
            self.category is not None or
            self.var_name is not None or
            self.var_values is not None or
            self.defaults is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='inputType1', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='inputType1')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='inputType1', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='inputType1'):
        if self.is_array is not None and 'is_array' not in already_processed:
            already_processed.add('is_array')
            outfile.write(' is_array="%s"' % self.gds_format_boolean(self.is_array, input_name='is_array'))
        if self.input_type is not None and 'input_type' not in already_processed:
            already_processed.add('input_type')
            outfile.write(' input_type=%s' % (quote_attrib(self.input_type), ))
        if self.value_limit_min is not None and 'value_limit_min' not in already_processed:
            already_processed.add('value_limit_min')
            outfile.write(' value_limit_min=%s' % (self.gds_format_string(quote_attrib(self.value_limit_min), input_name='value_limit_min'), ))
        if self.value_limit_max is not None and 'value_limit_max' not in already_processed:
            already_processed.add('value_limit_max')
            outfile.write(' value_limit_max=%s' % (self.gds_format_string(quote_attrib(self.value_limit_max), input_name='value_limit_max'), ))
        if self.fractional_digits is not None and 'fractional_digits' not in already_processed:
            already_processed.add('fractional_digits')
            outfile.write(' fractional_digits="%s"' % self.gds_format_integer(self.fractional_digits, input_name='fractional_digits'))
        if self.deprecated is not None and 'deprecated' not in already_processed:
            already_processed.add('deprecated')
            outfile.write(' deprecated="%s"' % self.gds_format_boolean(self.deprecated, input_name='deprecated'))
        if self.default_visiblity is not None and 'default_visiblity' not in already_processed:
            already_processed.add('default_visiblity')
            outfile.write(' default_visiblity=%s' % (quote_attrib(self.default_visiblity), ))
        if self.units_multiplier is not None and 'units_multiplier' not in already_processed:
            already_processed.add('units_multiplier')
            outfile.write(' units_multiplier=%s' % (self.gds_format_string(quote_attrib(self.units_multiplier), input_name='units_multiplier'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='inputType1', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.readable_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreadable_name>%s</%sreadable_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.readable_name), input_name='readable_name'), namespace_, eol_))
        if self.category is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scategory>%s</%scategory>%s' % (namespace_, self.gds_format_string(quote_xml(self.category), input_name='category'), namespace_, eol_))
        if self.var_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svar_name>%s</%svar_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.var_name), input_name='var_name'), namespace_, eol_))
        if self.var_values is not None:
            self.var_values.export(outfile, level, namespace_, name_='var_values', pretty_print=pretty_print)
        if self.defaults is not None:
            self.defaults.export(outfile, level, namespace_, name_='defaults', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='inputType1'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.is_array is not None and 'is_array' not in already_processed:
            already_processed.add('is_array')
            showIndent(outfile, level)
            outfile.write('is_array=%s,\n' % (self.is_array,))
        if self.input_type is not None and 'input_type' not in already_processed:
            already_processed.add('input_type')
            showIndent(outfile, level)
            outfile.write('input_type="%s",\n' % (self.input_type,))
        if self.value_limit_min is not None and 'value_limit_min' not in already_processed:
            already_processed.add('value_limit_min')
            showIndent(outfile, level)
            outfile.write('value_limit_min="%s",\n' % (self.value_limit_min,))
        if self.value_limit_max is not None and 'value_limit_max' not in already_processed:
            already_processed.add('value_limit_max')
            showIndent(outfile, level)
            outfile.write('value_limit_max="%s",\n' % (self.value_limit_max,))
        if self.fractional_digits is not None and 'fractional_digits' not in already_processed:
            already_processed.add('fractional_digits')
            showIndent(outfile, level)
            outfile.write('fractional_digits=%d,\n' % (self.fractional_digits,))
        if self.deprecated is not None and 'deprecated' not in already_processed:
            already_processed.add('deprecated')
            showIndent(outfile, level)
            outfile.write('deprecated=%s,\n' % (self.deprecated,))
        if self.default_visiblity is not None and 'default_visiblity' not in already_processed:
            already_processed.add('default_visiblity')
            showIndent(outfile, level)
            outfile.write('default_visiblity="%s",\n' % (self.default_visiblity,))
        if self.units_multiplier is not None and 'units_multiplier' not in already_processed:
            already_processed.add('units_multiplier')
            showIndent(outfile, level)
            outfile.write('units_multiplier="%s",\n' % (self.units_multiplier,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.readable_name is not None:
            showIndent(outfile, level)
            outfile.write('readable_name=%s,\n' % quote_python(self.readable_name))
        if self.category is not None:
            showIndent(outfile, level)
            outfile.write('category=%s,\n' % quote_python(self.category))
        if self.var_name is not None:
            showIndent(outfile, level)
            outfile.write('var_name=%s,\n' % quote_python(self.var_name))
        if self.var_values is not None:
            showIndent(outfile, level)
            outfile.write('var_values=model_.var_values(\n')
            self.var_values.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.defaults is not None:
            showIndent(outfile, level)
            outfile.write('defaults=model_.defaults(\n')
            self.defaults.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('is_array', node)
        if value is not None and 'is_array' not in already_processed:
            already_processed.add('is_array')
            if value in ('true', '1'):
                self.is_array = True
            elif value in ('false', '0'):
                self.is_array = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('input_type', node)
        if value is not None and 'input_type' not in already_processed:
            already_processed.add('input_type')
            self.input_type = value
            self.validate_inputType(self.input_type)    # validate type inputType
        value = find_attr_value_('value_limit_min', node)
        if value is not None and 'value_limit_min' not in already_processed:
            already_processed.add('value_limit_min')
            self.value_limit_min = value
        value = find_attr_value_('value_limit_max', node)
        if value is not None and 'value_limit_max' not in already_processed:
            already_processed.add('value_limit_max')
            self.value_limit_max = value
        value = find_attr_value_('fractional_digits', node)
        if value is not None and 'fractional_digits' not in already_processed:
            already_processed.add('fractional_digits')
            try:
                self.fractional_digits = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.fractional_digits < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('deprecated', node)
        if value is not None and 'deprecated' not in already_processed:
            already_processed.add('deprecated')
            if value in ('true', '1'):
                self.deprecated = True
            elif value in ('false', '0'):
                self.deprecated = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('default_visiblity', node)
        if value is not None and 'default_visiblity' not in already_processed:
            already_processed.add('default_visiblity')
            self.default_visiblity = value
            self.validate_visibilityType(self.default_visiblity)    # validate type visibilityType
        value = find_attr_value_('units_multiplier', node)
        if value is not None and 'units_multiplier' not in already_processed:
            already_processed.add('units_multiplier')
            self.units_multiplier = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'readable_name':
            readable_name_ = child_.text
            readable_name_ = self.gds_validate_string(readable_name_, node, 'readable_name')
            self.readable_name = readable_name_
        elif nodeName_ == 'category':
            category_ = child_.text
            category_ = self.gds_validate_string(category_, node, 'category')
            self.category = category_
        elif nodeName_ == 'var_name':
            var_name_ = child_.text
            var_name_ = self.gds_validate_string(var_name_, node, 'var_name')
            self.var_name = var_name_
        elif nodeName_ == 'var_values':
            obj_ = var_values.factory()
            obj_.build(child_)
            self.var_values = obj_
            obj_.original_tagname_ = 'var_values'
        elif nodeName_ == 'defaults':
            obj_ = defaults.factory()
            obj_.build(child_)
            self.defaults = obj_
            obj_.original_tagname_ = 'defaults'
# end class inputType1


class forcesType(GeneratedsSuper):
    """A collection of internal variables to be forced to a default. These
    variables are not exposed to the user."""
    subclass = None
    superclass = None
    def __init__(self, force=None):
        self.original_tagname_ = None
        if force is None:
            self.force = []
        else:
            self.force = force
    def factory(*args_, **kwargs_):
        if forcesType.subclass:
            return forcesType.subclass(*args_, **kwargs_)
        else:
            return forcesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_force(self): return self.force
    def set_force(self, force): self.force = force
    def add_force(self, value): self.force.append(value)
    def insert_force(self, index, value): self.force[index] = value
    forceProp = property(get_force, set_force)
    def hasContent_(self):
        if (
            self.force
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='forcesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='forcesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='forcesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='forcesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='forcesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for force_ in self.force:
            force_.export(outfile, level, namespace_, name_='force', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='forcesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('force=[\n')
        level += 1
        for force_ in self.force:
            showIndent(outfile, level)
            outfile.write('model_.forceType(\n')
            force_.exportLiteral(outfile, level, name_='forceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'force':
            obj_ = forceType.factory()
            obj_.build(child_)
            self.force.append(obj_)
            obj_.original_tagname_ = 'force'
# end class forcesType


class forceType(GeneratedsSuper):
    """An internal variable that is NOT exposed to the user can be forced
    to a default value that overrides the calculated value.Specifies
    if this force has array of data."""
    subclass = None
    superclass = None
    def __init__(self, is_array=None, var_name=None, values=None):
        self.original_tagname_ = None
        self.is_array = _cast(bool, is_array)
        self.var_name = var_name
        self.values = values
    def factory(*args_, **kwargs_):
        if forceType.subclass:
            return forceType.subclass(*args_, **kwargs_)
        else:
            return forceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_var_name(self): return self.var_name
    def set_var_name(self, var_name): self.var_name = var_name
    var_nameProp = property(get_var_name, set_var_name)
    def get_values(self): return self.values
    def set_values(self, values): self.values = values
    valuesProp = property(get_values, set_values)
    def get_is_array(self): return self.is_array
    def set_is_array(self, is_array): self.is_array = is_array
    is_arrayProp = property(get_is_array, set_is_array)
    def hasContent_(self):
        if (
            self.var_name is not None or
            self.values is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='forceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='forceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='forceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='forceType'):
        if self.is_array is not None and 'is_array' not in already_processed:
            already_processed.add('is_array')
            outfile.write(' is_array="%s"' % self.gds_format_boolean(self.is_array, input_name='is_array'))
    def exportChildren(self, outfile, level, namespace_='', name_='forceType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.var_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svar_name>%s</%svar_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.var_name), input_name='var_name'), namespace_, eol_))
        if self.values is not None:
            self.values.export(outfile, level, namespace_, name_='values', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='forceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.is_array is not None and 'is_array' not in already_processed:
            already_processed.add('is_array')
            showIndent(outfile, level)
            outfile.write('is_array=%s,\n' % (self.is_array,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.var_name is not None:
            showIndent(outfile, level)
            outfile.write('var_name=%s,\n' % quote_python(self.var_name))
        if self.values is not None:
            showIndent(outfile, level)
            outfile.write('values=model_.values(\n')
            self.values.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('is_array', node)
        if value is not None and 'is_array' not in already_processed:
            already_processed.add('is_array')
            if value in ('true', '1'):
                self.is_array = True
            elif value in ('false', '0'):
                self.is_array = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'var_name':
            var_name_ = child_.text
            var_name_ = self.gds_validate_string(var_name_, node, 'var_name')
            self.var_name = var_name_
        elif nodeName_ == 'values':
            obj_ = values.factory()
            obj_.build(child_)
            self.values = obj_
            obj_.original_tagname_ = 'values'
# end class forceType


class outputsType(GeneratedsSuper):
    """The collection of output variables. These variables will be assigned
    values during execution of this profile."""
    subclass = None
    superclass = None
    def __init__(self, output=None):
        self.original_tagname_ = None
        if output is None:
            self.output = []
        else:
            self.output = output
    def factory(*args_, **kwargs_):
        if outputsType.subclass:
            return outputsType.subclass(*args_, **kwargs_)
        else:
            return outputsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_output(self): return self.output
    def set_output(self, output): self.output = output
    def add_output(self, value): self.output.append(value)
    def insert_output(self, index, value): self.output[index] = value
    outputProp = property(get_output, set_output)
    def hasContent_(self):
        if (
            self.output
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='outputsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='outputsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='outputsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='outputsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='outputsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for output_ in self.output:
            output_.export(outfile, level, namespace_, name_='output', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='outputsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('output=[\n')
        level += 1
        for output_ in self.output:
            showIndent(outfile, level)
            outfile.write('model_.outputType2(\n')
            output_.exportLiteral(outfile, level, name_='outputType2')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'output':
            obj_ = outputType2.factory()
            obj_.build(child_)
            self.output.append(obj_)
            obj_.original_tagname_ = 'output'
# end class outputsType


class outputType2(GeneratedsSuper):
    """An output calculated during execution of the profile calculations.
    The variable may contain a svd_mapping attribute to allow
    register assignment. Use the output_type attribute to determine
    the type of this profile output.Specifies if this output has
    array of data.Describes the purpose of this output variable.An
    optional minimum value, inclusive.An optional maximum value,
    inclusive.Specifies the number of fractional digits to display
    for a float or fixed point value."""
    subclass = None
    superclass = None
    def __init__(self, is_array=None, output_type=None, value_limit_min=None, value_limit_max=None, fractional_digits=None, readable_name=None, category=None, var_name=None, var_values=None, var_overrides=None, groups=None):
        self.original_tagname_ = None
        self.is_array = _cast(bool, is_array)
        self.output_type = _cast(None, output_type)
        self.value_limit_min = _cast(None, value_limit_min)
        self.value_limit_max = _cast(None, value_limit_max)
        self.fractional_digits = _cast(int, fractional_digits)
        self.readable_name = readable_name
        self.category = category
        self.var_name = var_name
        self.var_values = var_values
        self.var_overrides = var_overrides
        self.groups = groups
    def factory(*args_, **kwargs_):
        if outputType2.subclass:
            return outputType2.subclass(*args_, **kwargs_)
        else:
            return outputType2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_readable_name(self): return self.readable_name
    def set_readable_name(self, readable_name): self.readable_name = readable_name
    readable_nameProp = property(get_readable_name, set_readable_name)
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    categoryProp = property(get_category, set_category)
    def get_var_name(self): return self.var_name
    def set_var_name(self, var_name): self.var_name = var_name
    var_nameProp = property(get_var_name, set_var_name)
    def get_var_values(self): return self.var_values
    def set_var_values(self, var_values): self.var_values = var_values
    var_valuesProp = property(get_var_values, set_var_values)
    def get_var_overrides(self): return self.var_overrides
    def set_var_overrides(self, var_overrides): self.var_overrides = var_overrides
    var_overridesProp = property(get_var_overrides, set_var_overrides)
    def get_groups(self): return self.groups
    def set_groups(self, groups): self.groups = groups
    groupsProp = property(get_groups, set_groups)
    def get_is_array(self): return self.is_array
    def set_is_array(self, is_array): self.is_array = is_array
    is_arrayProp = property(get_is_array, set_is_array)
    def get_output_type(self): return self.output_type
    def set_output_type(self, output_type): self.output_type = output_type
    output_typeProp = property(get_output_type, set_output_type)
    def get_value_limit_min(self): return self.value_limit_min
    def set_value_limit_min(self, value_limit_min): self.value_limit_min = value_limit_min
    value_limit_minProp = property(get_value_limit_min, set_value_limit_min)
    def get_value_limit_max(self): return self.value_limit_max
    def set_value_limit_max(self, value_limit_max): self.value_limit_max = value_limit_max
    value_limit_maxProp = property(get_value_limit_max, set_value_limit_max)
    def get_fractional_digits(self): return self.fractional_digits
    def set_fractional_digits(self, fractional_digits): self.fractional_digits = fractional_digits
    fractional_digitsProp = property(get_fractional_digits, set_fractional_digits)
    def validate_outputType(self, value):
        # Validate type outputType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.readable_name is not None or
            self.category is not None or
            self.var_name is not None or
            self.var_values is not None or
            self.var_overrides is not None or
            self.groups is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='outputType2', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='outputType2')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='outputType2', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='outputType2'):
        if self.is_array is not None and 'is_array' not in already_processed:
            already_processed.add('is_array')
            outfile.write(' is_array="%s"' % self.gds_format_boolean(self.is_array, input_name='is_array'))
        if self.output_type is not None and 'output_type' not in already_processed:
            already_processed.add('output_type')
            outfile.write(' output_type=%s' % (quote_attrib(self.output_type), ))
        if self.value_limit_min is not None and 'value_limit_min' not in already_processed:
            already_processed.add('value_limit_min')
            outfile.write(' value_limit_min=%s' % (self.gds_format_string(quote_attrib(self.value_limit_min), input_name='value_limit_min'), ))
        if self.value_limit_max is not None and 'value_limit_max' not in already_processed:
            already_processed.add('value_limit_max')
            outfile.write(' value_limit_max=%s' % (self.gds_format_string(quote_attrib(self.value_limit_max), input_name='value_limit_max'), ))
        if self.fractional_digits is not None and 'fractional_digits' not in already_processed:
            already_processed.add('fractional_digits')
            outfile.write(' fractional_digits="%s"' % self.gds_format_integer(self.fractional_digits, input_name='fractional_digits'))
    def exportChildren(self, outfile, level, namespace_='', name_='outputType2', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.readable_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreadable_name>%s</%sreadable_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.readable_name), input_name='readable_name'), namespace_, eol_))
        if self.category is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scategory>%s</%scategory>%s' % (namespace_, self.gds_format_string(quote_xml(self.category), input_name='category'), namespace_, eol_))
        if self.var_name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svar_name>%s</%svar_name>%s' % (namespace_, self.gds_format_string(quote_xml(self.var_name), input_name='var_name'), namespace_, eol_))
        if self.var_values is not None:
            self.var_values.export(outfile, level, namespace_, name_='var_values', pretty_print=pretty_print)
        if self.var_overrides is not None:
            self.var_overrides.export(outfile, level, namespace_, name_='var_overrides', pretty_print=pretty_print)
        if self.groups is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgroups>%s</%sgroups>%s' % (namespace_, self.gds_format_string(quote_xml(self.groups), input_name='groups'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='outputType2'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.is_array is not None and 'is_array' not in already_processed:
            already_processed.add('is_array')
            showIndent(outfile, level)
            outfile.write('is_array=%s,\n' % (self.is_array,))
        if self.output_type is not None and 'output_type' not in already_processed:
            already_processed.add('output_type')
            showIndent(outfile, level)
            outfile.write('output_type="%s",\n' % (self.output_type,))
        if self.value_limit_min is not None and 'value_limit_min' not in already_processed:
            already_processed.add('value_limit_min')
            showIndent(outfile, level)
            outfile.write('value_limit_min="%s",\n' % (self.value_limit_min,))
        if self.value_limit_max is not None and 'value_limit_max' not in already_processed:
            already_processed.add('value_limit_max')
            showIndent(outfile, level)
            outfile.write('value_limit_max="%s",\n' % (self.value_limit_max,))
        if self.fractional_digits is not None and 'fractional_digits' not in already_processed:
            already_processed.add('fractional_digits')
            showIndent(outfile, level)
            outfile.write('fractional_digits=%d,\n' % (self.fractional_digits,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.readable_name is not None:
            showIndent(outfile, level)
            outfile.write('readable_name=%s,\n' % quote_python(self.readable_name))
        if self.category is not None:
            showIndent(outfile, level)
            outfile.write('category=%s,\n' % quote_python(self.category))
        if self.var_name is not None:
            showIndent(outfile, level)
            outfile.write('var_name=%s,\n' % quote_python(self.var_name))
        if self.var_values is not None:
            showIndent(outfile, level)
            outfile.write('var_values=model_.var_values(\n')
            self.var_values.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.var_overrides is not None:
            showIndent(outfile, level)
            outfile.write('var_overrides=model_.var_overrides(\n')
            self.var_overrides.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.groups is not None:
            showIndent(outfile, level)
            outfile.write('groups=%s,\n' % quote_python(self.groups))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('is_array', node)
        if value is not None and 'is_array' not in already_processed:
            already_processed.add('is_array')
            if value in ('true', '1'):
                self.is_array = True
            elif value in ('false', '0'):
                self.is_array = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('output_type', node)
        if value is not None and 'output_type' not in already_processed:
            already_processed.add('output_type')
            self.output_type = value
            self.validate_outputType(self.output_type)    # validate type outputType
        value = find_attr_value_('value_limit_min', node)
        if value is not None and 'value_limit_min' not in already_processed:
            already_processed.add('value_limit_min')
            self.value_limit_min = value
        value = find_attr_value_('value_limit_max', node)
        if value is not None and 'value_limit_max' not in already_processed:
            already_processed.add('value_limit_max')
            self.value_limit_max = value
        value = find_attr_value_('fractional_digits', node)
        if value is not None and 'fractional_digits' not in already_processed:
            already_processed.add('fractional_digits')
            try:
                self.fractional_digits = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.fractional_digits < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'readable_name':
            readable_name_ = child_.text
            readable_name_ = self.gds_validate_string(readable_name_, node, 'readable_name')
            self.readable_name = readable_name_
        elif nodeName_ == 'category':
            category_ = child_.text
            category_ = self.gds_validate_string(category_, node, 'category')
            self.category = category_
        elif nodeName_ == 'var_name':
            var_name_ = child_.text
            var_name_ = self.gds_validate_string(var_name_, node, 'var_name')
            self.var_name = var_name_
        elif nodeName_ == 'var_values':
            obj_ = var_values.factory()
            obj_.build(child_)
            self.var_values = obj_
            obj_.original_tagname_ = 'var_values'
        elif nodeName_ == 'var_overrides':
            obj_ = var_overrides.factory()
            obj_.build(child_)
            self.var_overrides = obj_
            obj_.original_tagname_ = 'var_overrides'
        elif nodeName_ == 'groups':
            groups_ = child_.text
            groups_ = self.gds_validate_string(groups_, node, 'groups')
            self.groups = groups_
# end class outputType2


class default_physType(GeneratedsSuper):
    """Contains at least one default phy."""
    subclass = None
    superclass = None
    def __init__(self, default_phy=None):
        self.original_tagname_ = None
        if default_phy is None:
            self.default_phy = []
        else:
            self.default_phy = default_phy
    def factory(*args_, **kwargs_):
        if default_physType.subclass:
            return default_physType.subclass(*args_, **kwargs_)
        else:
            return default_physType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_default_phy(self): return self.default_phy
    def set_default_phy(self, default_phy): self.default_phy = default_phy
    def add_default_phy(self, value): self.default_phy.append(value)
    def insert_default_phy(self, index, value): self.default_phy[index] = value
    default_phyProp = property(get_default_phy, set_default_phy)
    def hasContent_(self):
        if (
            self.default_phy
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='default_physType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='default_physType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='default_physType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='default_physType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='default_physType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for default_phy_ in self.default_phy:
            default_phy_.export(outfile, level, namespace_, name_='default_phy', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='default_physType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('default_phy=[\n')
        level += 1
        for default_phy_ in self.default_phy:
            showIndent(outfile, level)
            outfile.write('model_.default_phyType(\n')
            default_phy_.exportLiteral(outfile, level, name_='default_phyType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'default_phy':
            obj_ = default_phyType.factory()
            obj_.build(child_)
            self.default_phy.append(obj_)
            obj_.original_tagname_ = 'default_phy'
# end class default_physType


class default_phyType(GeneratedsSuper):
    """The default phy to use for this profile. Use the phy's act_logic
    attribute to ensure that the proper default is selected based on
    the feature variable values.The phy name."""
    subclass = None
    superclass = None
    def __init__(self, phy_name=None):
        self.original_tagname_ = None
        self.phy_name = _cast(None, phy_name)
    def factory(*args_, **kwargs_):
        if default_phyType.subclass:
            return default_phyType.subclass(*args_, **kwargs_)
        else:
            return default_phyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_phy_name(self): return self.phy_name
    def set_phy_name(self, phy_name): self.phy_name = phy_name
    phy_nameProp = property(get_phy_name, set_phy_name)
    def validate_nameType(self, value):
        # Validate type nameType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='default_phyType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='default_phyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='default_phyType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='default_phyType'):
        if self.phy_name is not None and 'phy_name' not in already_processed:
            already_processed.add('phy_name')
            outfile.write(' phy_name=%s' % (quote_attrib(self.phy_name), ))
    def exportChildren(self, outfile, level, namespace_='', name_='default_phyType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='default_phyType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.phy_name is not None and 'phy_name' not in already_processed:
            already_processed.add('phy_name')
            showIndent(outfile, level)
            outfile.write('phy_name="%s",\n' % (self.phy_name,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('phy_name', node)
        if value is not None and 'phy_name' not in already_processed:
            already_processed.add('phy_name')
            self.phy_name = value
            self.validate_nameType(self.phy_name)    # validate type nameType
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class default_phyType


class variablesType(GeneratedsSuper):
    """Collection of all variables in the model. These variables serve as
    direct inputs and outputs to defined profiles. Some variables
    may only be used internally in intermediate stages."""
    subclass = None
    superclass = None
    def __init__(self, variable=None):
        self.original_tagname_ = None
        if variable is None:
            self.variable = []
        else:
            self.variable = variable
    def factory(*args_, **kwargs_):
        if variablesType.subclass:
            return variablesType.subclass(*args_, **kwargs_)
        else:
            return variablesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_variable(self): return self.variable
    def set_variable(self, variable): self.variable = variable
    def add_variable(self, value): self.variable.append(value)
    def insert_variable(self, index, value): self.variable[index] = value
    variableProp = property(get_variable, set_variable)
    def hasContent_(self):
        if (
            self.variable
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='variablesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='variablesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='variablesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='variablesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='variablesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for variable_ in self.variable:
            variable_.export(outfile, level, namespace_, name_='variable', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='variablesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('variable=[\n')
        level += 1
        for variable_ in self.variable:
            showIndent(outfile, level)
            outfile.write('model_.variableType(\n')
            variable_.exportLiteral(outfile, level, name_='variableType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'variable':
            obj_ = variableType.factory()
            obj_.build(child_)
            self.variable.append(obj_)
            obj_.original_tagname_ = 'variable'
# end class variablesType


class variableType(GeneratedsSuper):
    """A working variable that represents an initial input, an intermediate
    value used in one of the calculation stages, or a final
    output.The variable name. If a variable is referenced in a
    profile, then this name will match the var_name in the profile
    section.The variable type.Specifies if this variable has array
    of data.Specify how to display the variable value.A plain text
    description of the variable.Denotes that this variable can be
    forced. Defaults to true. As the value_actual usage is
    deprecated, this attribute will be set to false for actual
    variables created for the reverse calculation flow. Specify this
    variable maps directly to a CMSIS SVD register using
    peripheral.register.field notation.Define the units.Used for
    register or field types, do explicitly tag registers that are
    "don't cares", or "not needed", when in a specific mode."""
    subclass = None
    superclass = None
    def __init__(self, name=None, type_=None, is_array=None, format=None, desc=None, forceable=None, svd_mapping=None, units=None, value_do_not_care=False, enum=None, values=None, access_read=None, access_write=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.type_ = _cast(None, type_)
        self.is_array = _cast(bool, is_array)
        self.format = _cast(None, format)
        self.desc = _cast(None, desc)
        self.forceable = _cast(bool, forceable)
        self.svd_mapping = _cast(None, svd_mapping)
        self.units = _cast(None, units)
        self.value_do_not_care = _cast(bool, value_do_not_care)
        self.enum = enum
        self.values = values
        self.access_read = access_read
        self.access_write = access_write
    def factory(*args_, **kwargs_):
        if variableType.subclass:
            return variableType.subclass(*args_, **kwargs_)
        else:
            return variableType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_enum(self): return self.enum
    def set_enum(self, enum): self.enum = enum
    enumProp = property(get_enum, set_enum)
    def get_values(self): return self.values
    def set_values(self, values): self.values = values
    valuesProp = property(get_values, set_values)
    def get_access_read(self): return self.access_read
    def set_access_read(self, access_read): self.access_read = access_read
    access_readProp = property(get_access_read, set_access_read)
    def get_access_write(self): return self.access_write
    def set_access_write(self, access_write): self.access_write = access_write
    access_writeProp = property(get_access_write, set_access_write)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    typeProp = property(get_type, set_type)
    def get_is_array(self): return self.is_array
    def set_is_array(self, is_array): self.is_array = is_array
    is_arrayProp = property(get_is_array, set_is_array)
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    formatProp = property(get_format, set_format)
    def get_desc(self): return self.desc
    def set_desc(self, desc): self.desc = desc
    descProp = property(get_desc, set_desc)
    def get_forceable(self): return self.forceable
    def set_forceable(self, forceable): self.forceable = forceable
    forceableProp = property(get_forceable, set_forceable)
    def get_svd_mapping(self): return self.svd_mapping
    def set_svd_mapping(self, svd_mapping): self.svd_mapping = svd_mapping
    svd_mappingProp = property(get_svd_mapping, set_svd_mapping)
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    unitsProp = property(get_units, set_units)
    def get_value_do_not_care(self): return self.value_do_not_care
    def set_value_do_not_care(self, value_do_not_care): self.value_do_not_care = value_do_not_care
    value_do_not_careProp = property(get_value_do_not_care, set_value_do_not_care)
    def validate_nameType(self, value):
        # Validate type nameType, a restriction on xs:string.
        pass
    def validate_typeType(self, value):
        # Validate type typeType, a restriction on varType.
        pass
    def validate_formatType(self, value):
        # Validate type formatType, a restriction on xs:string.
        pass
    def validate_svdType(self, value):
        # Validate type svdType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.enum is not None or
            self.values is not None or
            self.access_read is not None or
            self.access_write is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='variableType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='variableType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='variableType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='variableType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (quote_attrib(self.name), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        if self.is_array is not None and 'is_array' not in already_processed:
            already_processed.add('is_array')
            outfile.write(' is_array="%s"' % self.gds_format_boolean(self.is_array, input_name='is_array'))
        if self.format is not None and 'format' not in already_processed:
            already_processed.add('format')
            outfile.write(' format=%s' % (quote_attrib(self.format), ))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(' desc=%s' % (self.gds_format_string(quote_attrib(self.desc), input_name='desc'), ))
        if self.forceable is not None and 'forceable' not in already_processed:
            already_processed.add('forceable')
            outfile.write(' forceable="%s"' % self.gds_format_boolean(self.forceable, input_name='forceable'))
        if self.svd_mapping is not None and 'svd_mapping' not in already_processed:
            already_processed.add('svd_mapping')
            outfile.write(' svd_mapping=%s' % (quote_attrib(self.svd_mapping), ))
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            outfile.write(' units=%s' % (self.gds_format_string(quote_attrib(self.units), input_name='units'), ))
        if self.value_do_not_care is not None and 'value_do_not_care' not in already_processed:
            already_processed.add('value_do_not_care')
            outfile.write(' value_do_not_care="%s"' % self.gds_format_boolean(self.value_do_not_care, input_name='value_do_not_care'))
    def exportChildren(self, outfile, level, namespace_='', name_='variableType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.enum is not None:
            self.enum.export(outfile, level, namespace_, name_='enum', pretty_print=pretty_print)
        if self.values is not None:
            self.values.export(outfile, level, namespace_, name_='values', pretty_print=pretty_print)
        if self.access_read is not None:
            self.access_read.export(outfile, level, namespace_, name_='access_read', pretty_print=pretty_print)
        if self.access_write is not None:
            self.access_write.export(outfile, level, namespace_, name_='access_write', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='variableType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
        if self.is_array is not None and 'is_array' not in already_processed:
            already_processed.add('is_array')
            showIndent(outfile, level)
            outfile.write('is_array=%s,\n' % (self.is_array,))
        if self.format is not None and 'format' not in already_processed:
            already_processed.add('format')
            showIndent(outfile, level)
            outfile.write('format="%s",\n' % (self.format,))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            showIndent(outfile, level)
            outfile.write('desc="%s",\n' % (self.desc,))
        if self.forceable is not None and 'forceable' not in already_processed:
            already_processed.add('forceable')
            showIndent(outfile, level)
            outfile.write('forceable=%s,\n' % (self.forceable,))
        if self.svd_mapping is not None and 'svd_mapping' not in already_processed:
            already_processed.add('svd_mapping')
            showIndent(outfile, level)
            outfile.write('svd_mapping="%s",\n' % (self.svd_mapping,))
        if self.units is not None and 'units' not in already_processed:
            already_processed.add('units')
            showIndent(outfile, level)
            outfile.write('units="%s",\n' % (self.units,))
        if self.value_do_not_care is not None and 'value_do_not_care' not in already_processed:
            already_processed.add('value_do_not_care')
            showIndent(outfile, level)
            outfile.write('value_do_not_care=%s,\n' % (self.value_do_not_care,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.enum is not None:
            showIndent(outfile, level)
            outfile.write('enum=model_.enumType(\n')
            self.enum.exportLiteral(outfile, level, name_='enum')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.values is not None:
            showIndent(outfile, level)
            outfile.write('values=model_.valuesType(\n')
            self.values.exportLiteral(outfile, level, name_='values')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.access_read is not None:
            showIndent(outfile, level)
            outfile.write('access_read=model_.access_readType(\n')
            self.access_read.exportLiteral(outfile, level, name_='access_read')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.access_write is not None:
            showIndent(outfile, level)
            outfile.write('access_write=model_.access_writeType(\n')
            self.access_write.exportLiteral(outfile, level, name_='access_write')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
            self.validate_nameType(self.name)    # validate type nameType
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.validate_typeType(self.type_)    # validate type typeType
        value = find_attr_value_('is_array', node)
        if value is not None and 'is_array' not in already_processed:
            already_processed.add('is_array')
            if value in ('true', '1'):
                self.is_array = True
            elif value in ('false', '0'):
                self.is_array = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('format', node)
        if value is not None and 'format' not in already_processed:
            already_processed.add('format')
            self.format = value
            self.validate_formatType(self.format)    # validate type formatType
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
        value = find_attr_value_('forceable', node)
        if value is not None and 'forceable' not in already_processed:
            already_processed.add('forceable')
            if value in ('true', '1'):
                self.forceable = True
            elif value in ('false', '0'):
                self.forceable = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('svd_mapping', node)
        if value is not None and 'svd_mapping' not in already_processed:
            already_processed.add('svd_mapping')
            self.svd_mapping = value
            self.validate_svdType(self.svd_mapping)    # validate type svdType
        value = find_attr_value_('units', node)
        if value is not None and 'units' not in already_processed:
            already_processed.add('units')
            self.units = value
        value = find_attr_value_('value_do_not_care', node)
        if value is not None and 'value_do_not_care' not in already_processed:
            already_processed.add('value_do_not_care')
            if value in ('true', '1'):
                self.value_do_not_care = True
            elif value in ('false', '0'):
                self.value_do_not_care = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'enum':
            obj_ = enumType.factory()
            obj_.build(child_)
            self.enum = obj_
            obj_.original_tagname_ = 'enum'
        elif nodeName_ == 'values':
            obj_ = valuesType.factory()
            obj_.build(child_)
            self.values = obj_
            obj_.original_tagname_ = 'values'
        elif nodeName_ == 'access_read':
            obj_ = access_readType.factory()
            obj_.build(child_)
            self.access_read = obj_
            obj_.original_tagname_ = 'access_read'
        elif nodeName_ == 'access_write':
            obj_ = access_writeType.factory()
            obj_.build(child_)
            self.access_write = obj_
            obj_.original_tagname_ = 'access_write'
# end class variableType


class enumType(GeneratedsSuper):
    """Defines an enum class name and members.The name of the enum.A plain
    text description of the enum."""
    subclass = None
    superclass = None
    def __init__(self, name=None, desc=None, members=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.desc = _cast(None, desc)
        self.members = members
    def factory(*args_, **kwargs_):
        if enumType.subclass:
            return enumType.subclass(*args_, **kwargs_)
        else:
            return enumType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_members(self): return self.members
    def set_members(self, members): self.members = members
    membersProp = property(get_members, set_members)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_desc(self): return self.desc
    def set_desc(self, desc): self.desc = desc
    descProp = property(get_desc, set_desc)
    def validate_nameType(self, value):
        # Validate type nameType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.members is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='enumType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='enumType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='enumType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='enumType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (quote_attrib(self.name), ))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(' desc=%s' % (self.gds_format_string(quote_attrib(self.desc), input_name='desc'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='enumType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.members is not None:
            self.members.export(outfile, level, namespace_, name_='members', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='enumType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            showIndent(outfile, level)
            outfile.write('desc="%s",\n' % (self.desc,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.members is not None:
            showIndent(outfile, level)
            outfile.write('members=model_.membersType(\n')
            self.members.exportLiteral(outfile, level, name_='members')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
            self.validate_nameType(self.name)    # validate type nameType
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'members':
            obj_ = membersType.factory()
            obj_.build(child_)
            self.members = obj_
            obj_.original_tagname_ = 'members'
# end class enumType


class membersType(GeneratedsSuper):
    """A collection of members."""
    subclass = None
    superclass = None
    def __init__(self, member=None):
        self.original_tagname_ = None
        if member is None:
            self.member = []
        else:
            self.member = member
    def factory(*args_, **kwargs_):
        if membersType.subclass:
            return membersType.subclass(*args_, **kwargs_)
        else:
            return membersType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_member(self): return self.member
    def set_member(self, member): self.member = member
    def add_member(self, value): self.member.append(value)
    def insert_member(self, index, value): self.member[index] = value
    memberProp = property(get_member, set_member)
    def hasContent_(self):
        if (
            self.member
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='membersType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='membersType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='membersType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='membersType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='membersType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for member_ in self.member:
            member_.export(outfile, level, namespace_, name_='member', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='membersType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('member=[\n')
        level += 1
        for member_ in self.member:
            showIndent(outfile, level)
            outfile.write('model_.memberType(\n')
            member_.exportLiteral(outfile, level, name_='memberType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'member':
            obj_ = memberType.factory()
            obj_.build(child_)
            self.member.append(obj_)
            obj_.original_tagname_ = 'member'
# end class membersType


class memberType(GeneratedsSuper):
    """The string name.The integer value.A plain text description of the
    enum member."""
    subclass = None
    superclass = None
    def __init__(self, name=None, value=None, desc=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.value = _cast(int, value)
        self.desc = _cast(None, desc)
    def factory(*args_, **kwargs_):
        if memberType.subclass:
            return memberType.subclass(*args_, **kwargs_)
        else:
            return memberType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    valueProp = property(get_value, set_value)
    def get_desc(self): return self.desc
    def set_desc(self, desc): self.desc = desc
    descProp = property(get_desc, set_desc)
    def validate_nameType(self, value):
        # Validate type nameType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='memberType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='memberType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='memberType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='memberType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (quote_attrib(self.name), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value="%s"' % self.gds_format_integer(self.value, input_name='value'))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(' desc=%s' % (self.gds_format_string(quote_attrib(self.desc), input_name='desc'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='memberType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='memberType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            showIndent(outfile, level)
            outfile.write('value=%d,\n' % (self.value,))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            showIndent(outfile, level)
            outfile.write('desc="%s",\n' % (self.desc,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
            self.validate_nameType(self.name)    # validate type nameType
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            try:
                self.value = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class memberType


class valuesType(GeneratedsSuper):
    """The values here are a snapshot of the variable model. Internal
    variables NOT defined in the profile may have no values defined.
    If this variable is a profile input or force, it must have a
    forced value before the calculations run. If this variable is a
    profile output, it must have a calculated value after the
    processed flag is True."""
    subclass = None
    superclass = None
    def __init__(self, calculated=None, forced=None):
        self.original_tagname_ = None
        self.calculated = calculated
        self.forced = forced
    def factory(*args_, **kwargs_):
        if valuesType.subclass:
            return valuesType.subclass(*args_, **kwargs_)
        else:
            return valuesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_calculated(self): return self.calculated
    def set_calculated(self, calculated): self.calculated = calculated
    calculatedProp = property(get_calculated, set_calculated)
    def get_forced(self): return self.forced
    def set_forced(self, forced): self.forced = forced
    forcedProp = property(get_forced, set_forced)
    def hasContent_(self):
        if (
            self.calculated is not None or
            self.forced is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='valuesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='valuesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='valuesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='valuesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='valuesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.calculated is not None:
            self.calculated.export(outfile, level, namespace_, name_='calculated', pretty_print=pretty_print)
        if self.forced is not None:
            self.forced.export(outfile, level, namespace_, name_='forced', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='valuesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.calculated is not None:
            showIndent(outfile, level)
            outfile.write('calculated=model_.calculatedType(\n')
            self.calculated.exportLiteral(outfile, level, name_='calculated')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.forced is not None:
            showIndent(outfile, level)
            outfile.write('forced=model_.forcedType(\n')
            self.forced.exportLiteral(outfile, level, name_='forced')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'calculated':
            obj_ = calculatedType.factory()
            obj_.build(child_)
            self.calculated = obj_
            obj_.original_tagname_ = 'calculated'
        elif nodeName_ == 'forced':
            obj_ = forcedType.factory()
            obj_.build(child_)
            self.forced = obj_
            obj_.original_tagname_ = 'forced'
# end class valuesType


class calculatedType(GeneratedsSuper):
    """The calculated value of the variable from an internal stage. Can be
    overridden with the forced value."""
    subclass = None
    superclass = None
    def __init__(self, value=None):
        self.original_tagname_ = None
        if value is None:
            self.value = []
        else:
            self.value = value
    def factory(*args_, **kwargs_):
        if calculatedType.subclass:
            return calculatedType.subclass(*args_, **kwargs_)
        else:
            return calculatedType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def add_value(self, value): self.value.append(value)
    def insert_value(self, index, value): self.value[index] = value
    valueProp = property(get_value, set_value)
    def hasContent_(self):
        if (
            self.value
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='calculatedType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='calculatedType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='calculatedType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='calculatedType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='calculatedType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for value_ in self.value:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(value_), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='calculatedType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('value=[\n')
        level += 1
        for value_ in self.value:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(value_))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value.append(value_)
# end class calculatedType


class forcedType(GeneratedsSuper):
    """The forced value to use in place of the calculated value. or to
    specify input for the start of a calculation stage. A profile
    input variable is assigned to this value. Can be compared
    against the default value in the profile. A profile force
    variable is also assigned here."""
    subclass = None
    superclass = None
    def __init__(self, value=None):
        self.original_tagname_ = None
        if value is None:
            self.value = []
        else:
            self.value = value
    def factory(*args_, **kwargs_):
        if forcedType.subclass:
            return forcedType.subclass(*args_, **kwargs_)
        else:
            return forcedType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def add_value(self, value): self.value.append(value)
    def insert_value(self, index, value): self.value[index] = value
    valueProp = property(get_value, set_value)
    def hasContent_(self):
        if (
            self.value
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='forcedType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='forcedType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='forcedType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='forcedType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='forcedType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for value_ in self.value:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(value_), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='forcedType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('value=[\n')
        level += 1
        for value_ in self.value:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(value_))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value.append(value_)
# end class forcedType


class access_readType(GeneratedsSuper):
    """Logs getter functions that read the variable value."""
    subclass = None
    superclass = None
    def __init__(self, name=None):
        self.original_tagname_ = None
        if name is None:
            self.name = []
        else:
            self.name = name
    def factory(*args_, **kwargs_):
        if access_readType.subclass:
            return access_readType.subclass(*args_, **kwargs_)
        else:
            return access_readType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def add_name(self, value): self.name.append(value)
    def insert_name(self, index, value): self.name[index] = value
    nameProp = property(get_name, set_name)
    def hasContent_(self):
        if (
            self.name
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='access_readType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='access_readType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='access_readType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='access_readType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='access_readType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for name_ in self.name:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(name_), input_name='name'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='access_readType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('name=[\n')
        level += 1
        for name_ in self.name:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(name_))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name.append(name_)
# end class access_readType


class access_writeType(GeneratedsSuper):
    """Logs setter function that wrote the variable value. If this name is
    set and the variable value is attempted to be set, then an
    exception is thrown, that this value is already set."""
    subclass = None
    superclass = None
    def __init__(self, name=None):
        self.original_tagname_ = None
        self.name = name
    def factory(*args_, **kwargs_):
        if access_writeType.subclass:
            return access_writeType.subclass(*args_, **kwargs_)
        else:
            return access_writeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def hasContent_(self):
        if (
            self.name is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='access_writeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='access_writeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='access_writeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='access_writeType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='access_writeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name), input_name='name'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='access_writeType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
# end class access_writeType


class logsType(GeneratedsSuper):
    """Array of log messages generated by radio configurator during
    calculation"""
    subclass = None
    superclass = None
    def __init__(self, log=None):
        self.original_tagname_ = None
        if log is None:
            self.log = []
        else:
            self.log = log
    def factory(*args_, **kwargs_):
        if logsType.subclass:
            return logsType.subclass(*args_, **kwargs_)
        else:
            return logsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_log(self): return self.log
    def set_log(self, log): self.log = log
    def add_log(self, value): self.log.append(value)
    def insert_log(self, index, value): self.log[index] = value
    logProp = property(get_log, set_log)
    def hasContent_(self):
        if (
            self.log
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='logsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='logsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='logsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='logsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='logsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for log_ in self.log:
            log_.export(outfile, level, namespace_, name_='log', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='logsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('log=[\n')
        level += 1
        for log_ in self.log:
            showIndent(outfile, level)
            outfile.write('model_.logType3(\n')
            log_.exportLiteral(outfile, level, name_='logType3')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'log':
            obj_ = logType3.factory()
            obj_.build(child_)
            self.log.append(obj_)
            obj_.original_tagname_ = 'log'
# end class logsType


class logType3(GeneratedsSuper):
    """Free form log text.Log type (e.g. error, warning, information)"""
    subclass = None
    superclass = None
    def __init__(self, type_=None, valueOf_=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if logType3.subclass:
            return logType3.subclass(*args_, **kwargs_)
        else:
            return logType3(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    typeProp = property(get_type, set_type)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_typeType4(self, value):
        # Validate type typeType4, a restriction on logType.
        pass
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='logType3', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='logType3')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespace_='', name_='logType3', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='logType3'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
    def exportChildren(self, outfile, level, namespace_='', name_='logType3', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='logType3'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.validate_typeType4(self.type_)    # validate type typeType4
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class logType3


GDSClassesMapping = {
    'feature': featureType,
    'phys': physType,
    'profiles': profilesType,
    'variables': variablesType,
    'logs': logsType,
    'phy': phyType,
    'profile_inputs': profile_inputsType,
    'profile_outputs': profile_outputsType,
    'profile_input': profile_inputType,
    'profile_output': profile_outputType,
    'profile': profileType,
    'inputs': inputsType,
    'forces': forcesType,
    'outputs': outputsType,
    'default_phys': default_physType,
    'input': inputType1,
    'force': forceType,
    'output': outputType2,
    'default_phy': default_phyType,
    'variable': variableType,
    'enum': enumType,
    'values': valuesType,
    'access_read': access_readType,
    'access_write': access_writeType,
    'members': membersType,
    'member': memberType,
    'calculated': calculatedType,
    'forced': forcedType,
    'log': logType3,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'features'
        rootClass = features
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     if not silence:
##         sys.stdout.write('<?xml version="1.0" ?>\n')
##         rootObj.export(
##             sys.stdout, 0, name_=rootTag,
##             namespacedef_='',
##             pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'features'
        rootClass = features
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
##     if not silence:
##         content = etree_.tostring(
##             rootElement, pretty_print=True,
##             xml_declaration=True, encoding="utf-8")
##         sys.stdout.write(content)
##         sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'features'
        rootClass = features
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     if not silence:
##         sys.stdout.write('<?xml version="1.0" ?>\n')
##         rootObj.export(
##             sys.stdout, 0, name_=rootTag,
##             namespacedef_='')
    return rootObj


def parseLiteral(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'features'
        rootClass = features
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     if not silence:
##         sys.stdout.write('#from Bindings import *\n\n')
##         sys.stdout.write('import Bindings as model_\n\n')
##         sys.stdout.write('rootObj = model_.rootClass(\n')
##         rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
##         sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "access_readType",
    "access_writeType",
    "calculatedType",
    "default_phyType",
    "default_physType",
    "defaults",
    "enumType",
    "featureType",
    "features",
    "forceType",
    "forcedType",
    "forcesType",
    "inputType1",
    "inputsType",
    "logType3",
    "logsType",
    "memberType",
    "membersType",
    "model",
    "outputType2",
    "outputsType",
    "overrides",
    "phyType",
    "physType",
    "profileType",
    "profile_inputType",
    "profile_inputsType",
    "profile_outputType",
    "profile_outputsType",
    "profilesType",
    "values",
    "valuesType",
    "var_overrides",
    "var_values",
    "variableType",
    "variablesType"
]
