#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Wed Mar 21 14:49:56 2018 by generateDS.py version 2.12d.
#
# Command line options:
#   ('-o', '..\\Bindings.py')
#   ('--super', 'Bindings')
#   ('-s', '..\\Template.py')
#   ('--subclass-suffix', '')
#   ('--member-specs', 'list')
#   ('-m', '')
#   ('-f', '')
#   ('--silence', '')
#
# Command line arguments:
#   .\CMSIS-SVD_Schema_1_0.xsd
#
# Command line:
#   generateDS_custom.py -o "..\Bindings.py" --super="Bindings" -s "..\Template.py" --subclass-suffix --member-specs="list" -m -f --silence .\CMSIS-SVD_Schema_1_0.xsd
#
# Current working directory (os.getcwd()):
#   xsd
#

import sys
import getopt
import re as re_
import base64
import datetime as datetime_

if sys.version_info[0] > 2:
    basestring = str

etree_ = None
Verbose_import_ = False
(
    XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    if inStr is None:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class writeConstraintType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('writeAsRead', 'xs:boolean', 0),
        MemberSpec_('useEnumeratedValues', 'xs:boolean', 0),
        MemberSpec_('range', 'rangeType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, writeAsRead=None, useEnumeratedValues=None, range=None):
        self.original_tagname_ = None
        self.writeAsRead = writeAsRead
        self.useEnumeratedValues = useEnumeratedValues
        if range is None:
            self.range = rangeType()
        else:
            self.range = range
    def factory(*args_, **kwargs_):
        if writeConstraintType.subclass:
            return writeConstraintType.subclass(*args_, **kwargs_)
        else:
            return writeConstraintType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_writeAsRead(self): return self.writeAsRead
    def set_writeAsRead(self, writeAsRead): self.writeAsRead = writeAsRead
    writeAsReadProp = property(get_writeAsRead, set_writeAsRead)
    def get_useEnumeratedValues(self): return self.useEnumeratedValues
    def set_useEnumeratedValues(self, useEnumeratedValues): self.useEnumeratedValues = useEnumeratedValues
    useEnumeratedValuesProp = property(get_useEnumeratedValues, set_useEnumeratedValues)
    def get_range(self): return self.range
    def set_range(self, range): self.range = range
    rangeProp = property(get_range, set_range)
    def hasContent_(self):
        if (
            self.writeAsRead is not None or
            self.useEnumeratedValues is not None or
            self.range is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='writeConstraintType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='writeConstraintType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='writeConstraintType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='writeConstraintType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='writeConstraintType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.writeAsRead is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%swriteAsRead>%s</%swriteAsRead>%s' % (namespace_, self.gds_format_boolean(self.writeAsRead, input_name='writeAsRead'), namespace_, eol_))
        if self.useEnumeratedValues is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suseEnumeratedValues>%s</%suseEnumeratedValues>%s' % (namespace_, self.gds_format_boolean(self.useEnumeratedValues, input_name='useEnumeratedValues'), namespace_, eol_))
        if self.range is not None:
            self.range.export(outfile, level, namespace_, name_='range', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='writeConstraintType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.writeAsRead is not None:
            showIndent(outfile, level)
            outfile.write('writeAsRead=%s,\n' % self.writeAsRead)
        if self.useEnumeratedValues is not None:
            showIndent(outfile, level)
            outfile.write('useEnumeratedValues=%s,\n' % self.useEnumeratedValues)
        if self.range is not None:
            showIndent(outfile, level)
            outfile.write('range=model_.rangeType(\n')
            self.range.exportLiteral(outfile, level, name_='range')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'writeAsRead':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'writeAsRead')
            self.writeAsRead = ival_
        elif nodeName_ == 'useEnumeratedValues':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'useEnumeratedValues')
            self.useEnumeratedValues = ival_
        elif nodeName_ == 'range':
            obj_ = rangeType.factory()
            obj_.build(child_)
            self.range = obj_
            obj_.original_tagname_ = 'range'
# end class writeConstraintType


class addressBlockType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('offset', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('size', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('usage', ['usageType', 'xs:token'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, offset=None, size=None, usage=None):
        self.original_tagname_ = None
        self.offset = offset
        self.size = size
        self.usage = usage
    def factory(*args_, **kwargs_):
        if addressBlockType.subclass:
            return addressBlockType.subclass(*args_, **kwargs_)
        else:
            return addressBlockType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_offset(self): return self.offset
    def set_offset(self, offset): self.offset = offset
    offsetProp = property(get_offset, set_offset)
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    sizeProp = property(get_size, set_size)
    def get_usage(self): return self.usage
    def set_usage(self, usage): self.usage = usage
    usageProp = property(get_usage, set_usage)
    def validate_scaledNonNegativeInteger(self, value):
        # Validate type scaledNonNegativeInteger, a restriction on xs:string.
        pass
    def validate_usageType(self, value):
        # Validate type usageType, a restriction on xs:token.
        pass
    def hasContent_(self):
        if (
            self.offset is not None or
            self.size is not None or
            self.usage is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='addressBlockType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='addressBlockType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='addressBlockType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='addressBlockType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='addressBlockType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.offset is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soffset>%s</%soffset>%s' % (namespace_, self.gds_format_string(quote_xml(self.offset), input_name='offset'), namespace_, eol_))
        if self.size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespace_, self.gds_format_string(quote_xml(self.size), input_name='size'), namespace_, eol_))
        if self.usage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susage>%s</%susage>%s' % (namespace_, self.gds_format_string(quote_xml(self.usage), input_name='usage'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='addressBlockType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.offset is not None:
            showIndent(outfile, level)
            outfile.write('offset=%s,\n' % quote_python(self.offset))
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%s,\n' % quote_python(self.size))
        if self.usage is not None:
            showIndent(outfile, level)
            outfile.write('usage=%s,\n' % quote_python(self.usage))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'offset':
            offset_ = child_.text
            offset_ = self.gds_validate_string(offset_, node, 'offset')
            self.offset = offset_
            self.validate_scaledNonNegativeInteger(self.offset)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'size':
            size_ = child_.text
            size_ = self.gds_validate_string(size_, node, 'size')
            self.size = size_
            self.validate_scaledNonNegativeInteger(self.size)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'usage':
            usage_ = child_.text
            usage_ = re_.sub(String_cleanup_pat_, " ", usage_).strip()
            usage_ = self.gds_validate_string(usage_, node, 'usage')
            self.usage = usage_
            self.validate_usageType(self.usage)    # validate type usageType
# end class addressBlockType


class interruptType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('value', 'xs:integer', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, value=None):
        self.original_tagname_ = None
        self.name = name
        self.value = value
    def factory(*args_, **kwargs_):
        if interruptType.subclass:
            return interruptType.subclass(*args_, **kwargs_)
        else:
            return interruptType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    valueProp = property(get_value, set_value)
    def hasContent_(self):
        if (
            self.name is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='interruptType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='interruptType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='interruptType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='interruptType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='interruptType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name), input_name='name'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_integer(self.value, input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='interruptType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%d,\n' % self.value)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'value':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'value')
            self.value = ival_
# end class interruptType


class device(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('schemaVersion', 'xs:decimal', 0),
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('version', 'xs:string', 0),
        MemberSpec_('description', 'xs:string', 0),
        MemberSpec_('addressUnitBits', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('width', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('size', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('access', ['accessType', 'xs:token'], 0),
        MemberSpec_('resetValue', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('resetMask', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('peripherals', 'peripheralsType', 0),
        MemberSpec_('vendorExtensions', 'vendorExtensionsType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, schemaVersion=None, name=None, version=None, description=None, addressUnitBits=None, width=None, size=None, access=None, resetValue=None, resetMask=None, peripherals=None, vendorExtensions=None):
        self.original_tagname_ = None
        self.schemaVersion = _cast(float, schemaVersion)
        self.name = name
        self.version = version
        self.description = description
        self.addressUnitBits = addressUnitBits
        self.width = width
        self.size = size
        self.access = access
        self.resetValue = resetValue
        self.resetMask = resetMask
        if peripherals is None:
            self.peripherals = peripheralsType()
        else:
            self.peripherals = peripherals
        if vendorExtensions is None:
            self.vendorExtensions = vendorExtensionsType()
        else:
            self.vendorExtensions = vendorExtensions
    def factory(*args_, **kwargs_):
        if device.subclass:
            return device.subclass(*args_, **kwargs_)
        else:
            return device(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    versionProp = property(get_version, set_version)
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    descriptionProp = property(get_description, set_description)
    def get_addressUnitBits(self): return self.addressUnitBits
    def set_addressUnitBits(self, addressUnitBits): self.addressUnitBits = addressUnitBits
    addressUnitBitsProp = property(get_addressUnitBits, set_addressUnitBits)
    def get_width(self): return self.width
    def set_width(self, width): self.width = width
    widthProp = property(get_width, set_width)
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    sizeProp = property(get_size, set_size)
    def get_access(self): return self.access
    def set_access(self, access): self.access = access
    accessProp = property(get_access, set_access)
    def get_resetValue(self): return self.resetValue
    def set_resetValue(self, resetValue): self.resetValue = resetValue
    resetValueProp = property(get_resetValue, set_resetValue)
    def get_resetMask(self): return self.resetMask
    def set_resetMask(self, resetMask): self.resetMask = resetMask
    resetMaskProp = property(get_resetMask, set_resetMask)
    def get_peripherals(self): return self.peripherals
    def set_peripherals(self, peripherals): self.peripherals = peripherals
    peripheralsProp = property(get_peripherals, set_peripherals)
    def get_vendorExtensions(self): return self.vendorExtensions
    def set_vendorExtensions(self, vendorExtensions): self.vendorExtensions = vendorExtensions
    vendorExtensionsProp = property(get_vendorExtensions, set_vendorExtensions)
    def get_schemaVersion(self): return self.schemaVersion
    def set_schemaVersion(self, schemaVersion): self.schemaVersion = schemaVersion
    schemaVersionProp = property(get_schemaVersion, set_schemaVersion)
    def validate_scaledNonNegativeInteger(self, value):
        # Validate type scaledNonNegativeInteger, a restriction on xs:string.
        pass
    def validate_accessType(self, value):
        # Validate type accessType, a restriction on xs:token.
        pass
    def hasContent_(self):
        if (
            self.name is not None or
            self.version is not None or
            self.description is not None or
            self.addressUnitBits is not None or
            self.width is not None or
            self.size is not None or
            self.access is not None or
            self.resetValue is not None or
            self.resetMask is not None or
            self.peripherals is not None or
            self.vendorExtensions is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='device', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='device')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='device', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='device'):
        if self.schemaVersion is not None and 'schemaVersion' not in already_processed:
            already_processed.add('schemaVersion')
            outfile.write(' schemaVersion="%s"' % self.gds_format_float(self.schemaVersion, input_name='schemaVersion'))
    def exportChildren(self, outfile, level, namespace_='', name_='device', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name), input_name='name'), namespace_, eol_))
        if self.version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespace_, self.gds_format_string(quote_xml(self.version), input_name='version'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description), input_name='description'), namespace_, eol_))
        if self.addressUnitBits is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddressUnitBits>%s</%saddressUnitBits>%s' % (namespace_, self.gds_format_string(quote_xml(self.addressUnitBits), input_name='addressUnitBits'), namespace_, eol_))
        if self.width is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%swidth>%s</%swidth>%s' % (namespace_, self.gds_format_string(quote_xml(self.width), input_name='width'), namespace_, eol_))
        if self.size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespace_, self.gds_format_string(quote_xml(self.size), input_name='size'), namespace_, eol_))
        if self.access is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saccess>%s</%saccess>%s' % (namespace_, self.gds_format_string(quote_xml(self.access), input_name='access'), namespace_, eol_))
        if self.resetValue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresetValue>%s</%sresetValue>%s' % (namespace_, self.gds_format_string(quote_xml(self.resetValue), input_name='resetValue'), namespace_, eol_))
        if self.resetMask is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresetMask>%s</%sresetMask>%s' % (namespace_, self.gds_format_string(quote_xml(self.resetMask), input_name='resetMask'), namespace_, eol_))
        if self.peripherals is not None:
            self.peripherals.export(outfile, level, namespace_, name_='peripherals', pretty_print=pretty_print)
        if self.vendorExtensions is not None:
            self.vendorExtensions.export(outfile, level, namespace_, name_='vendorExtensions', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='device'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.schemaVersion is not None and 'schemaVersion' not in already_processed:
            already_processed.add('schemaVersion')
            showIndent(outfile, level)
            outfile.write('schemaVersion=%f,\n' % (self.schemaVersion,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=%s,\n' % quote_python(self.version))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description))
        if self.addressUnitBits is not None:
            showIndent(outfile, level)
            outfile.write('addressUnitBits=%s,\n' % quote_python(self.addressUnitBits))
        if self.width is not None:
            showIndent(outfile, level)
            outfile.write('width=%s,\n' % quote_python(self.width))
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%s,\n' % quote_python(self.size))
        if self.access is not None:
            showIndent(outfile, level)
            outfile.write('access=%s,\n' % quote_python(self.access))
        if self.resetValue is not None:
            showIndent(outfile, level)
            outfile.write('resetValue=%s,\n' % quote_python(self.resetValue))
        if self.resetMask is not None:
            showIndent(outfile, level)
            outfile.write('resetMask=%s,\n' % quote_python(self.resetMask))
        if self.peripherals is not None:
            showIndent(outfile, level)
            outfile.write('peripherals=model_.peripheralsType(\n')
            self.peripherals.exportLiteral(outfile, level, name_='peripherals')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vendorExtensions is not None:
            showIndent(outfile, level)
            outfile.write('vendorExtensions=model_.vendorExtensionsType(\n')
            self.vendorExtensions.exportLiteral(outfile, level, name_='vendorExtensions')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('schemaVersion', node)
        if value is not None and 'schemaVersion' not in already_processed:
            already_processed.add('schemaVersion')
            try:
                self.schemaVersion = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (schemaVersion): %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'version':
            version_ = child_.text
            version_ = self.gds_validate_string(version_, node, 'version')
            self.version = version_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'addressUnitBits':
            addressUnitBits_ = child_.text
            addressUnitBits_ = self.gds_validate_string(addressUnitBits_, node, 'addressUnitBits')
            self.addressUnitBits = addressUnitBits_
            self.validate_scaledNonNegativeInteger(self.addressUnitBits)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'width':
            width_ = child_.text
            width_ = self.gds_validate_string(width_, node, 'width')
            self.width = width_
            self.validate_scaledNonNegativeInteger(self.width)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'size':
            size_ = child_.text
            size_ = self.gds_validate_string(size_, node, 'size')
            self.size = size_
            self.validate_scaledNonNegativeInteger(self.size)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'access':
            access_ = child_.text
            access_ = re_.sub(String_cleanup_pat_, " ", access_).strip()
            access_ = self.gds_validate_string(access_, node, 'access')
            self.access = access_
            self.validate_accessType(self.access)    # validate type accessType
        elif nodeName_ == 'resetValue':
            resetValue_ = child_.text
            resetValue_ = self.gds_validate_string(resetValue_, node, 'resetValue')
            self.resetValue = resetValue_
            self.validate_scaledNonNegativeInteger(self.resetValue)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'resetMask':
            resetMask_ = child_.text
            resetMask_ = self.gds_validate_string(resetMask_, node, 'resetMask')
            self.resetMask = resetMask_
            self.validate_scaledNonNegativeInteger(self.resetMask)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'peripherals':
            obj_ = peripheralsType.factory()
            obj_.build(child_)
            self.peripherals = obj_
            obj_.original_tagname_ = 'peripherals'
        elif nodeName_ == 'vendorExtensions':
            obj_ = vendorExtensionsType.factory()
            obj_.build(child_)
            self.vendorExtensions = obj_
            obj_.original_tagname_ = 'vendorExtensions'
# end class device


class rangeType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('minimum', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('maximum', ['scaledNonNegativeInteger', 'xs:string'], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, minimum=None, maximum=None):
        self.original_tagname_ = None
        self.minimum = minimum
        self.maximum = maximum
    def factory(*args_, **kwargs_):
        if rangeType.subclass:
            return rangeType.subclass(*args_, **kwargs_)
        else:
            return rangeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_minimum(self): return self.minimum
    def set_minimum(self, minimum): self.minimum = minimum
    minimumProp = property(get_minimum, set_minimum)
    def get_maximum(self): return self.maximum
    def set_maximum(self, maximum): self.maximum = maximum
    maximumProp = property(get_maximum, set_maximum)
    def validate_scaledNonNegativeInteger(self, value):
        # Validate type scaledNonNegativeInteger, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.minimum is not None or
            self.maximum is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='rangeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='rangeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='rangeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='rangeType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='rangeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.minimum is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sminimum>%s</%sminimum>%s' % (namespace_, self.gds_format_string(quote_xml(self.minimum), input_name='minimum'), namespace_, eol_))
        if self.maximum is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smaximum>%s</%smaximum>%s' % (namespace_, self.gds_format_string(quote_xml(self.maximum), input_name='maximum'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='rangeType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.minimum is not None:
            showIndent(outfile, level)
            outfile.write('minimum=%s,\n' % quote_python(self.minimum))
        if self.maximum is not None:
            showIndent(outfile, level)
            outfile.write('maximum=%s,\n' % quote_python(self.maximum))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'minimum':
            minimum_ = child_.text
            minimum_ = self.gds_validate_string(minimum_, node, 'minimum')
            self.minimum = minimum_
            self.validate_scaledNonNegativeInteger(self.minimum)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'maximum':
            maximum_ = child_.text
            maximum_ = self.gds_validate_string(maximum_, node, 'maximum')
            self.maximum = maximum_
            self.validate_scaledNonNegativeInteger(self.maximum)    # validate type scaledNonNegativeInteger
# end class rangeType


class peripheralsType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('peripheral', 'peripheralType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, peripheral=None):
        self.original_tagname_ = None
        if peripheral is None:
            self.peripheral = []
        else:
            self.peripheral = peripheral
    def factory(*args_, **kwargs_):
        if peripheralsType.subclass:
            return peripheralsType.subclass(*args_, **kwargs_)
        else:
            return peripheralsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_peripheral(self): return self.peripheral
    def set_peripheral(self, peripheral): self.peripheral = peripheral
    def add_peripheral(self, value): self.peripheral.append(value)
    def insert_peripheral(self, index, value): self.peripheral[index] = value
    peripheralProp = property(get_peripheral, set_peripheral)
    def hasContent_(self):
        if (
            self.peripheral
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='peripheralsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='peripheralsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='peripheralsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='peripheralsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='peripheralsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for peripheral_ in self.peripheral:
            peripheral_.export(outfile, level, namespace_, name_='peripheral', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='peripheralsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('peripheral=[\n')
        level += 1
        for peripheral_ in self.peripheral:
            showIndent(outfile, level)
            outfile.write('model_.peripheralType(\n')
            peripheral_.exportLiteral(outfile, level, name_='peripheralType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'peripheral':
            obj_ = peripheralType.factory()
            obj_.build(child_)
            self.peripheral.append(obj_)
            obj_.original_tagname_ = 'peripheral'
# end class peripheralsType


class peripheralType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('derivedFrom', 'xs:Name', 0),
        MemberSpec_('name', 'xs:Name', 0),
        MemberSpec_('version', 'xs:string', 0),
        MemberSpec_('description', 'xs:string', 0),
        MemberSpec_('groupName', 'xs:string', 0),
        MemberSpec_('prependToName', 'xs:string', 0),
        MemberSpec_('appendToName', 'xs:string', 0),
        MemberSpec_('disableCondition', 'xs:string', 0),
        MemberSpec_('baseAddress', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('size', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('access', ['accessType', 'xs:token'], 0),
        MemberSpec_('resetValue', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('resetMask', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('addressBlock', 'addressBlockType', 1),
        MemberSpec_('interrupt', 'interruptType', 1),
        MemberSpec_('registers', 'registersType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, derivedFrom=None, name=None, version=None, description=None, groupName=None, prependToName=None, appendToName=None, disableCondition=None, baseAddress=None, size=None, access=None, resetValue=None, resetMask=None, addressBlock=None, interrupt=None, registers=None):
        self.original_tagname_ = None
        self.derivedFrom = _cast(None, derivedFrom)
        self.name = name
        self.version = version
        self.description = description
        self.groupName = groupName
        self.prependToName = prependToName
        self.appendToName = appendToName
        self.disableCondition = disableCondition
        self.baseAddress = baseAddress
        self.size = size
        self.access = access
        self.resetValue = resetValue
        self.resetMask = resetMask
        if addressBlock is None:
            self.addressBlock = []
        else:
            self.addressBlock = addressBlock
        if interrupt is None:
            self.interrupt = []
        else:
            self.interrupt = interrupt
        if registers is None:
            self.registers = registersType()
        else:
            self.registers = registers
    def factory(*args_, **kwargs_):
        if peripheralType.subclass:
            return peripheralType.subclass(*args_, **kwargs_)
        else:
            return peripheralType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    versionProp = property(get_version, set_version)
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    descriptionProp = property(get_description, set_description)
    def get_groupName(self): return self.groupName
    def set_groupName(self, groupName): self.groupName = groupName
    groupNameProp = property(get_groupName, set_groupName)
    def get_prependToName(self): return self.prependToName
    def set_prependToName(self, prependToName): self.prependToName = prependToName
    prependToNameProp = property(get_prependToName, set_prependToName)
    def get_appendToName(self): return self.appendToName
    def set_appendToName(self, appendToName): self.appendToName = appendToName
    appendToNameProp = property(get_appendToName, set_appendToName)
    def get_disableCondition(self): return self.disableCondition
    def set_disableCondition(self, disableCondition): self.disableCondition = disableCondition
    disableConditionProp = property(get_disableCondition, set_disableCondition)
    def get_baseAddress(self): return self.baseAddress
    def set_baseAddress(self, baseAddress): self.baseAddress = baseAddress
    baseAddressProp = property(get_baseAddress, set_baseAddress)
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    sizeProp = property(get_size, set_size)
    def get_access(self): return self.access
    def set_access(self, access): self.access = access
    accessProp = property(get_access, set_access)
    def get_resetValue(self): return self.resetValue
    def set_resetValue(self, resetValue): self.resetValue = resetValue
    resetValueProp = property(get_resetValue, set_resetValue)
    def get_resetMask(self): return self.resetMask
    def set_resetMask(self, resetMask): self.resetMask = resetMask
    resetMaskProp = property(get_resetMask, set_resetMask)
    def get_addressBlock(self): return self.addressBlock
    def set_addressBlock(self, addressBlock): self.addressBlock = addressBlock
    def add_addressBlock(self, value): self.addressBlock.append(value)
    def insert_addressBlock(self, index, value): self.addressBlock[index] = value
    addressBlockProp = property(get_addressBlock, set_addressBlock)
    def get_interrupt(self): return self.interrupt
    def set_interrupt(self, interrupt): self.interrupt = interrupt
    def add_interrupt(self, value): self.interrupt.append(value)
    def insert_interrupt(self, index, value): self.interrupt[index] = value
    interruptProp = property(get_interrupt, set_interrupt)
    def get_registers(self): return self.registers
    def set_registers(self, registers): self.registers = registers
    registersProp = property(get_registers, set_registers)
    def get_derivedFrom(self): return self.derivedFrom
    def set_derivedFrom(self, derivedFrom): self.derivedFrom = derivedFrom
    derivedFromProp = property(get_derivedFrom, set_derivedFrom)
    def validate_scaledNonNegativeInteger(self, value):
        # Validate type scaledNonNegativeInteger, a restriction on xs:string.
        pass
    def validate_accessType(self, value):
        # Validate type accessType, a restriction on xs:token.
        pass
    def hasContent_(self):
        if (
            self.name is not None or
            self.version is not None or
            self.description is not None or
            self.groupName is not None or
            self.prependToName is not None or
            self.appendToName is not None or
            self.disableCondition is not None or
            self.baseAddress is not None or
            self.size is not None or
            self.access is not None or
            self.resetValue is not None or
            self.resetMask is not None or
            self.addressBlock or
            self.interrupt or
            self.registers is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='peripheralType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='peripheralType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='peripheralType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='peripheralType'):
        if self.derivedFrom is not None and 'derivedFrom' not in already_processed:
            already_processed.add('derivedFrom')
            outfile.write(' derivedFrom=%s' % (self.gds_format_string(quote_attrib(self.derivedFrom), input_name='derivedFrom'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='peripheralType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name), input_name='name'), namespace_, eol_))
        if self.version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespace_, self.gds_format_string(quote_xml(self.version), input_name='version'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description), input_name='description'), namespace_, eol_))
        if self.groupName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgroupName>%s</%sgroupName>%s' % (namespace_, self.gds_format_string(quote_xml(self.groupName), input_name='groupName'), namespace_, eol_))
        if self.prependToName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprependToName>%s</%sprependToName>%s' % (namespace_, self.gds_format_string(quote_xml(self.prependToName), input_name='prependToName'), namespace_, eol_))
        if self.appendToName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sappendToName>%s</%sappendToName>%s' % (namespace_, self.gds_format_string(quote_xml(self.appendToName), input_name='appendToName'), namespace_, eol_))
        if self.disableCondition is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisableCondition>%s</%sdisableCondition>%s' % (namespace_, self.gds_format_string(quote_xml(self.disableCondition), input_name='disableCondition'), namespace_, eol_))
        if self.baseAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseAddress>%s</%sbaseAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseAddress), input_name='baseAddress'), namespace_, eol_))
        if self.size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespace_, self.gds_format_string(quote_xml(self.size), input_name='size'), namespace_, eol_))
        if self.access is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saccess>%s</%saccess>%s' % (namespace_, self.gds_format_string(quote_xml(self.access), input_name='access'), namespace_, eol_))
        if self.resetValue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresetValue>%s</%sresetValue>%s' % (namespace_, self.gds_format_string(quote_xml(self.resetValue), input_name='resetValue'), namespace_, eol_))
        if self.resetMask is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresetMask>%s</%sresetMask>%s' % (namespace_, self.gds_format_string(quote_xml(self.resetMask), input_name='resetMask'), namespace_, eol_))
        for addressBlock_ in self.addressBlock:
            addressBlock_.export(outfile, level, namespace_, name_='addressBlock', pretty_print=pretty_print)
        for interrupt_ in self.interrupt:
            interrupt_.export(outfile, level, namespace_, name_='interrupt', pretty_print=pretty_print)
        if self.registers is not None:
            self.registers.export(outfile, level, namespace_, name_='registers', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='peripheralType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.derivedFrom is not None and 'derivedFrom' not in already_processed:
            already_processed.add('derivedFrom')
            showIndent(outfile, level)
            outfile.write('derivedFrom="%s",\n' % (self.derivedFrom,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=%s,\n' % quote_python(self.version))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description))
        if self.groupName is not None:
            showIndent(outfile, level)
            outfile.write('groupName=%s,\n' % quote_python(self.groupName))
        if self.prependToName is not None:
            showIndent(outfile, level)
            outfile.write('prependToName=%s,\n' % quote_python(self.prependToName))
        if self.appendToName is not None:
            showIndent(outfile, level)
            outfile.write('appendToName=%s,\n' % quote_python(self.appendToName))
        if self.disableCondition is not None:
            showIndent(outfile, level)
            outfile.write('disableCondition=%s,\n' % quote_python(self.disableCondition))
        if self.baseAddress is not None:
            showIndent(outfile, level)
            outfile.write('baseAddress=%s,\n' % quote_python(self.baseAddress))
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%s,\n' % quote_python(self.size))
        if self.access is not None:
            showIndent(outfile, level)
            outfile.write('access=%s,\n' % quote_python(self.access))
        if self.resetValue is not None:
            showIndent(outfile, level)
            outfile.write('resetValue=%s,\n' % quote_python(self.resetValue))
        if self.resetMask is not None:
            showIndent(outfile, level)
            outfile.write('resetMask=%s,\n' % quote_python(self.resetMask))
        showIndent(outfile, level)
        outfile.write('addressBlock=[\n')
        level += 1
        for addressBlock_ in self.addressBlock:
            showIndent(outfile, level)
            outfile.write('model_.addressBlockType(\n')
            addressBlock_.exportLiteral(outfile, level, name_='addressBlockType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('interrupt=[\n')
        level += 1
        for interrupt_ in self.interrupt:
            showIndent(outfile, level)
            outfile.write('model_.interruptType(\n')
            interrupt_.exportLiteral(outfile, level, name_='interruptType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.registers is not None:
            showIndent(outfile, level)
            outfile.write('registers=model_.registersType(\n')
            self.registers.exportLiteral(outfile, level, name_='registers')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('derivedFrom', node)
        if value is not None and 'derivedFrom' not in already_processed:
            already_processed.add('derivedFrom')
            self.derivedFrom = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'version':
            version_ = child_.text
            version_ = self.gds_validate_string(version_, node, 'version')
            self.version = version_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'groupName':
            groupName_ = child_.text
            groupName_ = self.gds_validate_string(groupName_, node, 'groupName')
            self.groupName = groupName_
        elif nodeName_ == 'prependToName':
            prependToName_ = child_.text
            prependToName_ = self.gds_validate_string(prependToName_, node, 'prependToName')
            self.prependToName = prependToName_
        elif nodeName_ == 'appendToName':
            appendToName_ = child_.text
            appendToName_ = self.gds_validate_string(appendToName_, node, 'appendToName')
            self.appendToName = appendToName_
        elif nodeName_ == 'disableCondition':
            disableCondition_ = child_.text
            disableCondition_ = self.gds_validate_string(disableCondition_, node, 'disableCondition')
            self.disableCondition = disableCondition_
        elif nodeName_ == 'baseAddress':
            baseAddress_ = child_.text
            baseAddress_ = self.gds_validate_string(baseAddress_, node, 'baseAddress')
            self.baseAddress = baseAddress_
            self.validate_scaledNonNegativeInteger(self.baseAddress)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'size':
            size_ = child_.text
            size_ = self.gds_validate_string(size_, node, 'size')
            self.size = size_
            self.validate_scaledNonNegativeInteger(self.size)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'access':
            access_ = child_.text
            access_ = re_.sub(String_cleanup_pat_, " ", access_).strip()
            access_ = self.gds_validate_string(access_, node, 'access')
            self.access = access_
            self.validate_accessType(self.access)    # validate type accessType
        elif nodeName_ == 'resetValue':
            resetValue_ = child_.text
            resetValue_ = self.gds_validate_string(resetValue_, node, 'resetValue')
            self.resetValue = resetValue_
            self.validate_scaledNonNegativeInteger(self.resetValue)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'resetMask':
            resetMask_ = child_.text
            resetMask_ = self.gds_validate_string(resetMask_, node, 'resetMask')
            self.resetMask = resetMask_
            self.validate_scaledNonNegativeInteger(self.resetMask)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'addressBlock':
            obj_ = addressBlockType.factory()
            obj_.build(child_)
            self.addressBlock.append(obj_)
            obj_.original_tagname_ = 'addressBlock'
        elif nodeName_ == 'interrupt':
            obj_ = interruptType.factory()
            obj_.build(child_)
            self.interrupt.append(obj_)
            obj_.original_tagname_ = 'interrupt'
        elif nodeName_ == 'registers':
            obj_ = registersType.factory()
            obj_.build(child_)
            self.registers = obj_
            obj_.original_tagname_ = 'registers'
# end class peripheralType


class registersType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('register', 'registerType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, register=None):
        self.original_tagname_ = None
        if register is None:
            self.register = []
        else:
            self.register = register
    def factory(*args_, **kwargs_):
        if registersType.subclass:
            return registersType.subclass(*args_, **kwargs_)
        else:
            return registersType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_register(self): return self.register
    def set_register(self, register): self.register = register
    def add_register(self, value): self.register.append(value)
    def insert_register(self, index, value): self.register[index] = value
    registerProp = property(get_register, set_register)
    def hasContent_(self):
        if (
            self.register
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='registersType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='registersType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='registersType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='registersType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='registersType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for register_ in self.register:
            register_.export(outfile, level, namespace_, name_='register', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='registersType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('register=[\n')
        level += 1
        for register_ in self.register:
            showIndent(outfile, level)
            outfile.write('model_.registerType(\n')
            register_.exportLiteral(outfile, level, name_='registerType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'register':
            obj_ = registerType.factory()
            obj_.build(child_)
            self.register.append(obj_)
            obj_.original_tagname_ = 'register'
# end class registersType


class registerType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('derivedFrom', 'xs:Name', 0),
        MemberSpec_('dim', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('dimIncrement', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('dimIndex', ['dimIndexType', 'xs:string'], 0),
        MemberSpec_('name', ['registerNameType', 'xs:string'], 0),
        MemberSpec_('displayName', 'xs:string', 0),
        MemberSpec_('description', 'xs:string', 0),
        MemberSpec_('alternateGroup', 'xs:Name', 0),
        MemberSpec_('addressOffset', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('size', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('access', ['accessType', 'xs:token'], 0),
        MemberSpec_('resetValue', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('resetMask', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('modifiedWriteValues', ['modifiedWriteValuesType', 'xs:token'], 0),
        MemberSpec_('writeConstraint', 'writeConstraintType', 0),
        MemberSpec_('readAction', ['readActionType', 'xs:token'], 0),
        MemberSpec_('fields', 'fieldsType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, derivedFrom=None, dim=None, dimIncrement=None, dimIndex=None, name=None, displayName=None, description=None, alternateGroup=None, addressOffset=None, size=None, access=None, resetValue=None, resetMask=None, modifiedWriteValues=None, writeConstraint=None, readAction=None, fields=None):
        self.original_tagname_ = None
        self.derivedFrom = _cast(None, derivedFrom)
        self.dim = dim
        self.dimIncrement = dimIncrement
        self.dimIndex = dimIndex
        self.name = name
        self.displayName = displayName
        self.description = description
        self.alternateGroup = alternateGroup
        self.addressOffset = addressOffset
        self.size = size
        self.access = access
        self.resetValue = resetValue
        self.resetMask = resetMask
        self.modifiedWriteValues = modifiedWriteValues
        if writeConstraint is None:
            self.writeConstraint = writeConstraintType()
        else:
            self.writeConstraint = writeConstraint
        self.readAction = readAction
        if fields is None:
            self.fields = fieldsType()
        else:
            self.fields = fields
    def factory(*args_, **kwargs_):
        if registerType.subclass:
            return registerType.subclass(*args_, **kwargs_)
        else:
            return registerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_dim(self): return self.dim
    def set_dim(self, dim): self.dim = dim
    dimProp = property(get_dim, set_dim)
    def get_dimIncrement(self): return self.dimIncrement
    def set_dimIncrement(self, dimIncrement): self.dimIncrement = dimIncrement
    dimIncrementProp = property(get_dimIncrement, set_dimIncrement)
    def get_dimIndex(self): return self.dimIndex
    def set_dimIndex(self, dimIndex): self.dimIndex = dimIndex
    dimIndexProp = property(get_dimIndex, set_dimIndex)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    displayNameProp = property(get_displayName, set_displayName)
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    descriptionProp = property(get_description, set_description)
    def get_alternateGroup(self): return self.alternateGroup
    def set_alternateGroup(self, alternateGroup): self.alternateGroup = alternateGroup
    alternateGroupProp = property(get_alternateGroup, set_alternateGroup)
    def get_addressOffset(self): return self.addressOffset
    def set_addressOffset(self, addressOffset): self.addressOffset = addressOffset
    addressOffsetProp = property(get_addressOffset, set_addressOffset)
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    sizeProp = property(get_size, set_size)
    def get_access(self): return self.access
    def set_access(self, access): self.access = access
    accessProp = property(get_access, set_access)
    def get_resetValue(self): return self.resetValue
    def set_resetValue(self, resetValue): self.resetValue = resetValue
    resetValueProp = property(get_resetValue, set_resetValue)
    def get_resetMask(self): return self.resetMask
    def set_resetMask(self, resetMask): self.resetMask = resetMask
    resetMaskProp = property(get_resetMask, set_resetMask)
    def get_modifiedWriteValues(self): return self.modifiedWriteValues
    def set_modifiedWriteValues(self, modifiedWriteValues): self.modifiedWriteValues = modifiedWriteValues
    modifiedWriteValuesProp = property(get_modifiedWriteValues, set_modifiedWriteValues)
    def get_writeConstraint(self): return self.writeConstraint
    def set_writeConstraint(self, writeConstraint): self.writeConstraint = writeConstraint
    writeConstraintProp = property(get_writeConstraint, set_writeConstraint)
    def get_readAction(self): return self.readAction
    def set_readAction(self, readAction): self.readAction = readAction
    readActionProp = property(get_readAction, set_readAction)
    def get_fields(self): return self.fields
    def set_fields(self, fields): self.fields = fields
    fieldsProp = property(get_fields, set_fields)
    def get_derivedFrom(self): return self.derivedFrom
    def set_derivedFrom(self, derivedFrom): self.derivedFrom = derivedFrom
    derivedFromProp = property(get_derivedFrom, set_derivedFrom)
    def validate_scaledNonNegativeInteger(self, value):
        # Validate type scaledNonNegativeInteger, a restriction on xs:string.
        pass
    def validate_dimIndexType(self, value):
        # Validate type dimIndexType, a restriction on xs:string.
        pass
    def validate_registerNameType(self, value):
        # Validate type registerNameType, a restriction on xs:string.
        pass
    def validate_accessType(self, value):
        # Validate type accessType, a restriction on xs:token.
        pass
    def validate_modifiedWriteValuesType(self, value):
        # Validate type modifiedWriteValuesType, a restriction on xs:token.
        pass
    def validate_readActionType(self, value):
        # Validate type readActionType, a restriction on xs:token.
        pass
    def hasContent_(self):
        if (
            self.dim is not None or
            self.dimIncrement is not None or
            self.dimIndex is not None or
            self.name is not None or
            self.displayName is not None or
            self.description is not None or
            self.alternateGroup is not None or
            self.addressOffset is not None or
            self.size is not None or
            self.access is not None or
            self.resetValue is not None or
            self.resetMask is not None or
            self.modifiedWriteValues is not None or
            self.writeConstraint is not None or
            self.readAction is not None or
            self.fields is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='registerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='registerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='registerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='registerType'):
        if self.derivedFrom is not None and 'derivedFrom' not in already_processed:
            already_processed.add('derivedFrom')
            outfile.write(' derivedFrom=%s' % (self.gds_format_string(quote_attrib(self.derivedFrom), input_name='derivedFrom'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='registerType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.dim is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdim>%s</%sdim>%s' % (namespace_, self.gds_format_string(quote_xml(self.dim), input_name='dim'), namespace_, eol_))
        if self.dimIncrement is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdimIncrement>%s</%sdimIncrement>%s' % (namespace_, self.gds_format_string(quote_xml(self.dimIncrement), input_name='dimIncrement'), namespace_, eol_))
        if self.dimIndex is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdimIndex>%s</%sdimIndex>%s' % (namespace_, self.gds_format_string(quote_xml(self.dimIndex), input_name='dimIndex'), namespace_, eol_))
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name), input_name='name'), namespace_, eol_))
        if self.displayName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespace_, self.gds_format_string(quote_xml(self.displayName), input_name='displayName'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description), input_name='description'), namespace_, eol_))
        if self.alternateGroup is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%salternateGroup>%s</%salternateGroup>%s' % (namespace_, self.gds_format_string(quote_xml(self.alternateGroup), input_name='alternateGroup'), namespace_, eol_))
        if self.addressOffset is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddressOffset>%s</%saddressOffset>%s' % (namespace_, self.gds_format_string(quote_xml(self.addressOffset), input_name='addressOffset'), namespace_, eol_))
        if self.size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespace_, self.gds_format_string(quote_xml(self.size), input_name='size'), namespace_, eol_))
        if self.access is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saccess>%s</%saccess>%s' % (namespace_, self.gds_format_string(quote_xml(self.access), input_name='access'), namespace_, eol_))
        if self.resetValue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresetValue>%s</%sresetValue>%s' % (namespace_, self.gds_format_string(quote_xml(self.resetValue), input_name='resetValue'), namespace_, eol_))
        if self.resetMask is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresetMask>%s</%sresetMask>%s' % (namespace_, self.gds_format_string(quote_xml(self.resetMask), input_name='resetMask'), namespace_, eol_))
        if self.modifiedWriteValues is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodifiedWriteValues>%s</%smodifiedWriteValues>%s' % (namespace_, self.gds_format_string(quote_xml(self.modifiedWriteValues), input_name='modifiedWriteValues'), namespace_, eol_))
        if self.writeConstraint is not None:
            self.writeConstraint.export(outfile, level, namespace_, name_='writeConstraint', pretty_print=pretty_print)
        if self.readAction is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreadAction>%s</%sreadAction>%s' % (namespace_, self.gds_format_string(quote_xml(self.readAction), input_name='readAction'), namespace_, eol_))
        if self.fields is not None:
            self.fields.export(outfile, level, namespace_, name_='fields', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='registerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.derivedFrom is not None and 'derivedFrom' not in already_processed:
            already_processed.add('derivedFrom')
            showIndent(outfile, level)
            outfile.write('derivedFrom="%s",\n' % (self.derivedFrom,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.dim is not None:
            showIndent(outfile, level)
            outfile.write('dim=%s,\n' % quote_python(self.dim))
        if self.dimIncrement is not None:
            showIndent(outfile, level)
            outfile.write('dimIncrement=%s,\n' % quote_python(self.dimIncrement))
        if self.dimIndex is not None:
            showIndent(outfile, level)
            outfile.write('dimIndex=%s,\n' % quote_python(self.dimIndex))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name))
        if self.displayName is not None:
            showIndent(outfile, level)
            outfile.write('displayName=%s,\n' % quote_python(self.displayName))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description))
        if self.alternateGroup is not None:
            showIndent(outfile, level)
            outfile.write('alternateGroup=%s,\n' % quote_python(self.alternateGroup))
        if self.addressOffset is not None:
            showIndent(outfile, level)
            outfile.write('addressOffset=%s,\n' % quote_python(self.addressOffset))
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%s,\n' % quote_python(self.size))
        if self.access is not None:
            showIndent(outfile, level)
            outfile.write('access=%s,\n' % quote_python(self.access))
        if self.resetValue is not None:
            showIndent(outfile, level)
            outfile.write('resetValue=%s,\n' % quote_python(self.resetValue))
        if self.resetMask is not None:
            showIndent(outfile, level)
            outfile.write('resetMask=%s,\n' % quote_python(self.resetMask))
        if self.modifiedWriteValues is not None:
            showIndent(outfile, level)
            outfile.write('modifiedWriteValues=%s,\n' % quote_python(self.modifiedWriteValues))
        if self.writeConstraint is not None:
            showIndent(outfile, level)
            outfile.write('writeConstraint=model_.writeConstraintType(\n')
            self.writeConstraint.exportLiteral(outfile, level, name_='writeConstraint')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.readAction is not None:
            showIndent(outfile, level)
            outfile.write('readAction=%s,\n' % quote_python(self.readAction))
        if self.fields is not None:
            showIndent(outfile, level)
            outfile.write('fields=model_.fieldsType(\n')
            self.fields.exportLiteral(outfile, level, name_='fields')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('derivedFrom', node)
        if value is not None and 'derivedFrom' not in already_processed:
            already_processed.add('derivedFrom')
            self.derivedFrom = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'dim':
            dim_ = child_.text
            dim_ = self.gds_validate_string(dim_, node, 'dim')
            self.dim = dim_
            self.validate_scaledNonNegativeInteger(self.dim)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'dimIncrement':
            dimIncrement_ = child_.text
            dimIncrement_ = self.gds_validate_string(dimIncrement_, node, 'dimIncrement')
            self.dimIncrement = dimIncrement_
            self.validate_scaledNonNegativeInteger(self.dimIncrement)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'dimIndex':
            dimIndex_ = child_.text
            dimIndex_ = self.gds_validate_string(dimIndex_, node, 'dimIndex')
            self.dimIndex = dimIndex_
            self.validate_dimIndexType(self.dimIndex)    # validate type dimIndexType
        elif nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
            self.validate_registerNameType(self.name)    # validate type registerNameType
        elif nodeName_ == 'displayName':
            displayName_ = child_.text
            displayName_ = self.gds_validate_string(displayName_, node, 'displayName')
            self.displayName = displayName_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'alternateGroup':
            alternateGroup_ = child_.text
            alternateGroup_ = self.gds_validate_string(alternateGroup_, node, 'alternateGroup')
            self.alternateGroup = alternateGroup_
        elif nodeName_ == 'addressOffset':
            addressOffset_ = child_.text
            addressOffset_ = self.gds_validate_string(addressOffset_, node, 'addressOffset')
            self.addressOffset = addressOffset_
            self.validate_scaledNonNegativeInteger(self.addressOffset)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'size':
            size_ = child_.text
            size_ = self.gds_validate_string(size_, node, 'size')
            self.size = size_
            self.validate_scaledNonNegativeInteger(self.size)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'access':
            access_ = child_.text
            access_ = re_.sub(String_cleanup_pat_, " ", access_).strip()
            access_ = self.gds_validate_string(access_, node, 'access')
            self.access = access_
            self.validate_accessType(self.access)    # validate type accessType
        elif nodeName_ == 'resetValue':
            resetValue_ = child_.text
            resetValue_ = self.gds_validate_string(resetValue_, node, 'resetValue')
            self.resetValue = resetValue_
            self.validate_scaledNonNegativeInteger(self.resetValue)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'resetMask':
            resetMask_ = child_.text
            resetMask_ = self.gds_validate_string(resetMask_, node, 'resetMask')
            self.resetMask = resetMask_
            self.validate_scaledNonNegativeInteger(self.resetMask)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'modifiedWriteValues':
            modifiedWriteValues_ = child_.text
            modifiedWriteValues_ = re_.sub(String_cleanup_pat_, " ", modifiedWriteValues_).strip()
            modifiedWriteValues_ = self.gds_validate_string(modifiedWriteValues_, node, 'modifiedWriteValues')
            self.modifiedWriteValues = modifiedWriteValues_
            self.validate_modifiedWriteValuesType(self.modifiedWriteValues)    # validate type modifiedWriteValuesType
        elif nodeName_ == 'writeConstraint':
            obj_ = writeConstraintType.factory()
            obj_.build(child_)
            self.writeConstraint = obj_
            obj_.original_tagname_ = 'writeConstraint'
        elif nodeName_ == 'readAction':
            readAction_ = child_.text
            readAction_ = re_.sub(String_cleanup_pat_, " ", readAction_).strip()
            readAction_ = self.gds_validate_string(readAction_, node, 'readAction')
            self.readAction = readAction_
            self.validate_readActionType(self.readAction)    # validate type readActionType
        elif nodeName_ == 'fields':
            obj_ = fieldsType.factory()
            obj_.build(child_)
            self.fields = obj_
            obj_.original_tagname_ = 'fields'
# end class registerType


class fieldsType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('field', 'fieldType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, field=None):
        self.original_tagname_ = None
        if field is None:
            self.field = []
        else:
            self.field = field
    def factory(*args_, **kwargs_):
        if fieldsType.subclass:
            return fieldsType.subclass(*args_, **kwargs_)
        else:
            return fieldsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_field(self): return self.field
    def set_field(self, field): self.field = field
    def add_field(self, value): self.field.append(value)
    def insert_field(self, index, value): self.field[index] = value
    fieldProp = property(get_field, set_field)
    def hasContent_(self):
        if (
            self.field
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='fieldsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fieldsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='fieldsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='fieldsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='fieldsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for field_ in self.field:
            field_.export(outfile, level, namespace_, name_='field', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='fieldsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('field=[\n')
        level += 1
        for field_ in self.field:
            showIndent(outfile, level)
            outfile.write('model_.fieldType(\n')
            field_.exportLiteral(outfile, level, name_='fieldType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'field':
            obj_ = fieldType.factory()
            obj_.build(child_)
            self.field.append(obj_)
            obj_.original_tagname_ = 'field'
# end class fieldsType


class fieldType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('derivedFrom', 'xs:Name', 0),
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('description', 'xs:string', 0),
        MemberSpec_('lsb', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('msb', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('bitOffset', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('bitWidth', ['scaledNonNegativeInteger', 'xs:string'], 0),
        MemberSpec_('bitRange', ['bitRangeType', 'xs:token'], 0),
        MemberSpec_('access', ['accessType', 'xs:token'], 0),
        MemberSpec_('modifiedWriteValues', ['modifiedWriteValuesType', 'xs:token'], 0),
        MemberSpec_('writeConstraint', 'writeConstraintType', 0),
        MemberSpec_('readAction', ['readActionType', 'xs:token'], 0),
        MemberSpec_('enumeratedValues', 'enumeratedValuesType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, derivedFrom=None, name=None, description=None, lsb=None, msb=None, bitOffset=None, bitWidth=None, bitRange=None, access=None, modifiedWriteValues=None, writeConstraint=None, readAction=None, enumeratedValues=None):
        self.original_tagname_ = None
        self.derivedFrom = _cast(None, derivedFrom)
        self.name = name
        self.description = description
        self.lsb = lsb
        self.msb = msb
        self.bitOffset = bitOffset
        self.bitWidth = bitWidth
        self.bitRange = bitRange
        self.access = access
        self.modifiedWriteValues = modifiedWriteValues
        if writeConstraint is None:
            self.writeConstraint = writeConstraintType()
        else:
            self.writeConstraint = writeConstraint
        self.readAction = readAction
        if enumeratedValues is None:
            self.enumeratedValues = []
        else:
            self.enumeratedValues = enumeratedValues
    def factory(*args_, **kwargs_):
        if fieldType.subclass:
            return fieldType.subclass(*args_, **kwargs_)
        else:
            return fieldType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    descriptionProp = property(get_description, set_description)
    def get_lsb(self): return self.lsb
    def set_lsb(self, lsb): self.lsb = lsb
    lsbProp = property(get_lsb, set_lsb)
    def get_msb(self): return self.msb
    def set_msb(self, msb): self.msb = msb
    msbProp = property(get_msb, set_msb)
    def get_bitOffset(self): return self.bitOffset
    def set_bitOffset(self, bitOffset): self.bitOffset = bitOffset
    bitOffsetProp = property(get_bitOffset, set_bitOffset)
    def get_bitWidth(self): return self.bitWidth
    def set_bitWidth(self, bitWidth): self.bitWidth = bitWidth
    bitWidthProp = property(get_bitWidth, set_bitWidth)
    def get_bitRange(self): return self.bitRange
    def set_bitRange(self, bitRange): self.bitRange = bitRange
    bitRangeProp = property(get_bitRange, set_bitRange)
    def get_access(self): return self.access
    def set_access(self, access): self.access = access
    accessProp = property(get_access, set_access)
    def get_modifiedWriteValues(self): return self.modifiedWriteValues
    def set_modifiedWriteValues(self, modifiedWriteValues): self.modifiedWriteValues = modifiedWriteValues
    modifiedWriteValuesProp = property(get_modifiedWriteValues, set_modifiedWriteValues)
    def get_writeConstraint(self): return self.writeConstraint
    def set_writeConstraint(self, writeConstraint): self.writeConstraint = writeConstraint
    writeConstraintProp = property(get_writeConstraint, set_writeConstraint)
    def get_readAction(self): return self.readAction
    def set_readAction(self, readAction): self.readAction = readAction
    readActionProp = property(get_readAction, set_readAction)
    def get_enumeratedValues(self): return self.enumeratedValues
    def set_enumeratedValues(self, enumeratedValues): self.enumeratedValues = enumeratedValues
    def add_enumeratedValues(self, value): self.enumeratedValues.append(value)
    def insert_enumeratedValues(self, index, value): self.enumeratedValues[index] = value
    enumeratedValuesProp = property(get_enumeratedValues, set_enumeratedValues)
    def get_derivedFrom(self): return self.derivedFrom
    def set_derivedFrom(self, derivedFrom): self.derivedFrom = derivedFrom
    derivedFromProp = property(get_derivedFrom, set_derivedFrom)
    def validate_scaledNonNegativeInteger(self, value):
        # Validate type scaledNonNegativeInteger, a restriction on xs:string.
        pass
    def validate_bitRangeType(self, value):
        # Validate type bitRangeType, a restriction on xs:token.
        pass
    def validate_accessType(self, value):
        # Validate type accessType, a restriction on xs:token.
        pass
    def validate_modifiedWriteValuesType(self, value):
        # Validate type modifiedWriteValuesType, a restriction on xs:token.
        pass
    def validate_readActionType(self, value):
        # Validate type readActionType, a restriction on xs:token.
        pass
    def hasContent_(self):
        if (
            self.name is not None or
            self.description is not None or
            self.lsb is not None or
            self.msb is not None or
            self.bitOffset is not None or
            self.bitWidth is not None or
            self.bitRange is not None or
            self.access is not None or
            self.modifiedWriteValues is not None or
            self.writeConstraint is not None or
            self.readAction is not None or
            self.enumeratedValues
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='fieldType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fieldType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='fieldType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='fieldType'):
        if self.derivedFrom is not None and 'derivedFrom' not in already_processed:
            already_processed.add('derivedFrom')
            outfile.write(' derivedFrom=%s' % (self.gds_format_string(quote_attrib(self.derivedFrom), input_name='derivedFrom'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='fieldType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name), input_name='name'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description), input_name='description'), namespace_, eol_))
        if self.lsb is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slsb>%s</%slsb>%s' % (namespace_, self.gds_format_string(quote_xml(self.lsb), input_name='lsb'), namespace_, eol_))
        if self.msb is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smsb>%s</%smsb>%s' % (namespace_, self.gds_format_string(quote_xml(self.msb), input_name='msb'), namespace_, eol_))
        if self.bitOffset is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbitOffset>%s</%sbitOffset>%s' % (namespace_, self.gds_format_string(quote_xml(self.bitOffset), input_name='bitOffset'), namespace_, eol_))
        if self.bitWidth is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbitWidth>%s</%sbitWidth>%s' % (namespace_, self.gds_format_string(quote_xml(self.bitWidth), input_name='bitWidth'), namespace_, eol_))
        if self.bitRange is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbitRange>%s</%sbitRange>%s' % (namespace_, self.gds_format_string(quote_xml(self.bitRange), input_name='bitRange'), namespace_, eol_))
        if self.access is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saccess>%s</%saccess>%s' % (namespace_, self.gds_format_string(quote_xml(self.access), input_name='access'), namespace_, eol_))
        if self.modifiedWriteValues is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smodifiedWriteValues>%s</%smodifiedWriteValues>%s' % (namespace_, self.gds_format_string(quote_xml(self.modifiedWriteValues), input_name='modifiedWriteValues'), namespace_, eol_))
        if self.writeConstraint is not None:
            self.writeConstraint.export(outfile, level, namespace_, name_='writeConstraint', pretty_print=pretty_print)
        if self.readAction is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreadAction>%s</%sreadAction>%s' % (namespace_, self.gds_format_string(quote_xml(self.readAction), input_name='readAction'), namespace_, eol_))
        for enumeratedValues_ in self.enumeratedValues:
            enumeratedValues_.export(outfile, level, namespace_, name_='enumeratedValues', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='fieldType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.derivedFrom is not None and 'derivedFrom' not in already_processed:
            already_processed.add('derivedFrom')
            showIndent(outfile, level)
            outfile.write('derivedFrom="%s",\n' % (self.derivedFrom,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description))
        if self.lsb is not None:
            showIndent(outfile, level)
            outfile.write('lsb=%s,\n' % quote_python(self.lsb))
        if self.msb is not None:
            showIndent(outfile, level)
            outfile.write('msb=%s,\n' % quote_python(self.msb))
        if self.bitOffset is not None:
            showIndent(outfile, level)
            outfile.write('bitOffset=%s,\n' % quote_python(self.bitOffset))
        if self.bitWidth is not None:
            showIndent(outfile, level)
            outfile.write('bitWidth=%s,\n' % quote_python(self.bitWidth))
        if self.bitRange is not None:
            showIndent(outfile, level)
            outfile.write('bitRange=%s,\n' % quote_python(self.bitRange))
        if self.access is not None:
            showIndent(outfile, level)
            outfile.write('access=%s,\n' % quote_python(self.access))
        if self.modifiedWriteValues is not None:
            showIndent(outfile, level)
            outfile.write('modifiedWriteValues=%s,\n' % quote_python(self.modifiedWriteValues))
        if self.writeConstraint is not None:
            showIndent(outfile, level)
            outfile.write('writeConstraint=model_.writeConstraintType(\n')
            self.writeConstraint.exportLiteral(outfile, level, name_='writeConstraint')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.readAction is not None:
            showIndent(outfile, level)
            outfile.write('readAction=%s,\n' % quote_python(self.readAction))
        showIndent(outfile, level)
        outfile.write('enumeratedValues=[\n')
        level += 1
        for enumeratedValues_ in self.enumeratedValues:
            showIndent(outfile, level)
            outfile.write('model_.enumeratedValuesType(\n')
            enumeratedValues_.exportLiteral(outfile, level, name_='enumeratedValuesType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('derivedFrom', node)
        if value is not None and 'derivedFrom' not in already_processed:
            already_processed.add('derivedFrom')
            self.derivedFrom = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'lsb':
            lsb_ = child_.text
            lsb_ = self.gds_validate_string(lsb_, node, 'lsb')
            self.lsb = lsb_
            self.validate_scaledNonNegativeInteger(self.lsb)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'msb':
            msb_ = child_.text
            msb_ = self.gds_validate_string(msb_, node, 'msb')
            self.msb = msb_
            self.validate_scaledNonNegativeInteger(self.msb)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'bitOffset':
            bitOffset_ = child_.text
            bitOffset_ = self.gds_validate_string(bitOffset_, node, 'bitOffset')
            self.bitOffset = bitOffset_
            self.validate_scaledNonNegativeInteger(self.bitOffset)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'bitWidth':
            bitWidth_ = child_.text
            bitWidth_ = self.gds_validate_string(bitWidth_, node, 'bitWidth')
            self.bitWidth = bitWidth_
            self.validate_scaledNonNegativeInteger(self.bitWidth)    # validate type scaledNonNegativeInteger
        elif nodeName_ == 'bitRange':
            bitRange_ = child_.text
            bitRange_ = re_.sub(String_cleanup_pat_, " ", bitRange_).strip()
            bitRange_ = self.gds_validate_string(bitRange_, node, 'bitRange')
            self.bitRange = bitRange_
            self.validate_bitRangeType(self.bitRange)    # validate type bitRangeType
        elif nodeName_ == 'access':
            access_ = child_.text
            access_ = re_.sub(String_cleanup_pat_, " ", access_).strip()
            access_ = self.gds_validate_string(access_, node, 'access')
            self.access = access_
            self.validate_accessType(self.access)    # validate type accessType
        elif nodeName_ == 'modifiedWriteValues':
            modifiedWriteValues_ = child_.text
            modifiedWriteValues_ = re_.sub(String_cleanup_pat_, " ", modifiedWriteValues_).strip()
            modifiedWriteValues_ = self.gds_validate_string(modifiedWriteValues_, node, 'modifiedWriteValues')
            self.modifiedWriteValues = modifiedWriteValues_
            self.validate_modifiedWriteValuesType(self.modifiedWriteValues)    # validate type modifiedWriteValuesType
        elif nodeName_ == 'writeConstraint':
            obj_ = writeConstraintType.factory()
            obj_.build(child_)
            self.writeConstraint = obj_
            obj_.original_tagname_ = 'writeConstraint'
        elif nodeName_ == 'readAction':
            readAction_ = child_.text
            readAction_ = re_.sub(String_cleanup_pat_, " ", readAction_).strip()
            readAction_ = self.gds_validate_string(readAction_, node, 'readAction')
            self.readAction = readAction_
            self.validate_readActionType(self.readAction)    # validate type readActionType
        elif nodeName_ == 'enumeratedValues':
            obj_ = enumeratedValuesType.factory()
            obj_.build(child_)
            self.enumeratedValues.append(obj_)
            obj_.original_tagname_ = 'enumeratedValues'
# end class fieldType


class enumeratedValuesType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('derivedFrom', 'xs:Name', 0),
        MemberSpec_('name', 'xs:Name', 0),
        MemberSpec_('usage', ['enumUsageType', 'xs:token'], 0),
        MemberSpec_('enumeratedValue', 'enumeratedValueType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, derivedFrom=None, name=None, usage=None, enumeratedValue=None):
        self.original_tagname_ = None
        self.derivedFrom = _cast(None, derivedFrom)
        self.name = name
        self.usage = usage
        if enumeratedValue is None:
            self.enumeratedValue = []
        else:
            self.enumeratedValue = enumeratedValue
    def factory(*args_, **kwargs_):
        if enumeratedValuesType.subclass:
            return enumeratedValuesType.subclass(*args_, **kwargs_)
        else:
            return enumeratedValuesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_usage(self): return self.usage
    def set_usage(self, usage): self.usage = usage
    usageProp = property(get_usage, set_usage)
    def get_enumeratedValue(self): return self.enumeratedValue
    def set_enumeratedValue(self, enumeratedValue): self.enumeratedValue = enumeratedValue
    def add_enumeratedValue(self, value): self.enumeratedValue.append(value)
    def insert_enumeratedValue(self, index, value): self.enumeratedValue[index] = value
    enumeratedValueProp = property(get_enumeratedValue, set_enumeratedValue)
    def get_derivedFrom(self): return self.derivedFrom
    def set_derivedFrom(self, derivedFrom): self.derivedFrom = derivedFrom
    derivedFromProp = property(get_derivedFrom, set_derivedFrom)
    def validate_enumUsageType(self, value):
        # Validate type enumUsageType, a restriction on xs:token.
        pass
    def hasContent_(self):
        if (
            self.name is not None or
            self.usage is not None or
            self.enumeratedValue
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='enumeratedValuesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='enumeratedValuesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='enumeratedValuesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='enumeratedValuesType'):
        if self.derivedFrom is not None and 'derivedFrom' not in already_processed:
            already_processed.add('derivedFrom')
            outfile.write(' derivedFrom=%s' % (self.gds_format_string(quote_attrib(self.derivedFrom), input_name='derivedFrom'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='enumeratedValuesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name), input_name='name'), namespace_, eol_))
        if self.usage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susage>%s</%susage>%s' % (namespace_, self.gds_format_string(quote_xml(self.usage), input_name='usage'), namespace_, eol_))
        for enumeratedValue_ in self.enumeratedValue:
            enumeratedValue_.export(outfile, level, namespace_, name_='enumeratedValue', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='enumeratedValuesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.derivedFrom is not None and 'derivedFrom' not in already_processed:
            already_processed.add('derivedFrom')
            showIndent(outfile, level)
            outfile.write('derivedFrom="%s",\n' % (self.derivedFrom,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name))
        if self.usage is not None:
            showIndent(outfile, level)
            outfile.write('usage=%s,\n' % quote_python(self.usage))
        showIndent(outfile, level)
        outfile.write('enumeratedValue=[\n')
        level += 1
        for enumeratedValue_ in self.enumeratedValue:
            showIndent(outfile, level)
            outfile.write('model_.enumeratedValueType(\n')
            enumeratedValue_.exportLiteral(outfile, level, name_='enumeratedValueType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('derivedFrom', node)
        if value is not None and 'derivedFrom' not in already_processed:
            already_processed.add('derivedFrom')
            self.derivedFrom = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'usage':
            usage_ = child_.text
            usage_ = re_.sub(String_cleanup_pat_, " ", usage_).strip()
            usage_ = self.gds_validate_string(usage_, node, 'usage')
            self.usage = usage_
            self.validate_enumUsageType(self.usage)    # validate type enumUsageType
        elif nodeName_ == 'enumeratedValue':
            obj_ = enumeratedValueType.factory()
            obj_.build(child_)
            self.enumeratedValue.append(obj_)
            obj_.original_tagname_ = 'enumeratedValue'
# end class enumeratedValuesType


class enumeratedValueType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('description', 'xs:string', 0),
        MemberSpec_('value', ['enumeratedValueDataType', 'xs:string'], 0),
        MemberSpec_('isDefault', 'xs:boolean', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, description=None, value=None, isDefault=None):
        self.original_tagname_ = None
        self.name = name
        self.description = description
        self.value = value
        self.isDefault = isDefault
    def factory(*args_, **kwargs_):
        if enumeratedValueType.subclass:
            return enumeratedValueType.subclass(*args_, **kwargs_)
        else:
            return enumeratedValueType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    descriptionProp = property(get_description, set_description)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    valueProp = property(get_value, set_value)
    def get_isDefault(self): return self.isDefault
    def set_isDefault(self, isDefault): self.isDefault = isDefault
    isDefaultProp = property(get_isDefault, set_isDefault)
    def validate_enumeratedValueDataType(self, value):
        # Validate type enumeratedValueDataType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.name is not None or
            self.description is not None or
            self.value is not None or
            self.isDefault is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='enumeratedValueType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='enumeratedValueType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='enumeratedValueType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='enumeratedValueType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='enumeratedValueType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name), input_name='name'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description), input_name='description'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value), input_name='value'), namespace_, eol_))
        if self.isDefault is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sisDefault>%s</%sisDefault>%s' % (namespace_, self.gds_format_boolean(self.isDefault, input_name='isDefault'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='enumeratedValueType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value))
        if self.isDefault is not None:
            showIndent(outfile, level)
            outfile.write('isDefault=%s,\n' % self.isDefault)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
            self.validate_enumeratedValueDataType(self.value)    # validate type enumeratedValueDataType
        elif nodeName_ == 'isDefault':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'isDefault')
            self.isDefault = ival_
# end class enumeratedValueType


class vendorExtensionsType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('', 'xs:string', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, anytypeobjs_=None):
        self.original_tagname_ = None
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if vendorExtensionsType.subclass:
            return vendorExtensionsType.subclass(*args_, **kwargs_)
        else:
            return vendorExtensionsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def hasContent_(self):
        if (
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='vendorExtensionsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='vendorExtensionsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='vendorExtensionsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='vendorExtensionsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='vendorExtensionsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='vendorExtensionsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'vendorExtensionsType')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
# end class vendorExtensionsType


GDSClassesMapping = {
    'field': fieldType,
    'writeConstraint': writeConstraintType,
    'addressBlock': addressBlockType,
    'fields': fieldsType,
    'peripheral': peripheralType,
    'register': registerType,
    'vendorExtensions': vendorExtensionsType,
    'enumeratedValues': enumeratedValuesType,
    'interrupt': interruptType,
    'range': rangeType,
    'registers': registersType,
    'peripherals': peripheralsType,
    'enumeratedValue': enumeratedValueType,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName=None, silence=False, xml_string=None):
    if inFileName is not None:
        doc = parsexml_(inFileName)
        rootNode = doc.getroot()
    elif xml_string is not None:
        rootNode = etree_.fromstring(xml_string)
    else:
        raise Exception('Nothing to load supplied.')

    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'writeConstraintType'
        rootClass = writeConstraintType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     if not silence:
##         sys.stdout.write('<?xml version="1.0" ?>\n')
##         rootObj.export(
##             sys.stdout, 0, name_=rootTag,
##             namespacedef_='',
##             pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'writeConstraintType'
        rootClass = writeConstraintType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
##     if not silence:
##         content = etree_.tostring(
##             rootElement, pretty_print=True,
##             xml_declaration=True, encoding="utf-8")
##         sys.stdout.write(content)
##         sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'writeConstraintType'
        rootClass = writeConstraintType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     if not silence:
##         sys.stdout.write('<?xml version="1.0" ?>\n')
##         rootObj.export(
##             sys.stdout, 0, name_=rootTag,
##             namespacedef_='')
    return rootObj


def parseLiteral(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'writeConstraintType'
        rootClass = writeConstraintType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     if not silence:
##         sys.stdout.write('#from Bindings import *\n\n')
##         sys.stdout.write('import Bindings as model_\n\n')
##         sys.stdout.write('rootObj = model_.rootClass(\n')
##         rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
##         sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "addressBlockType",
    "device",
    "enumeratedValueType",
    "enumeratedValuesType",
    "fieldType",
    "fieldsType",
    "interruptType",
    "peripheralType",
    "peripheralsType",
    "rangeType",
    "registerType",
    "registersType",
    "vendorExtensionsType",
    "writeConstraintType"
]
