from pyradioconfig.parts.ocelot.calculators.calc_global import CALC_Global_ocelot
from pycalcmodel.core.variable import ModelVariableFormat
from py_2_and_3_compatibility import *

class Calc_Global_Bobcat(CALC_Global_ocelot):

    def buildVariables(self, model):

        # Build variables from the Ocelot calculations
        super().buildVariables(model)

        #Add variables for Bobcat

        self._add_ADQUAL_regs(model)
        self._add_ADFSM0_regs(model)
        self._add_ADCTRL_regs(model)
        self._add_ADPC_regs(model)
        self._add_CHFCTRL_regs(model)

    def _add_common_regs(self, model):
        super()._add_common_regs(model)
        self._addModelRegister(model, 'MODEM.AFC.DISAFCCTE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFSWCTRL.CHFSWTIME', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'AGC.CTRL0.FENOTCHMODESEL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT0.FENOTCHATTNSEL1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT0.FENOTCHATTNSEL2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT0.FENOTCHCAPCRSE1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT0.FENOTCHCAPCRSE2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT0.FENOTCHCAPFINE1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT0.FENOTCHCAPFINE2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT0.FENOTCHEN1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT0.FENOTCHEN2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT0.FENOTCHRATTNEN1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT0.FENOTCHRATTNEN2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT10.FENOTCHATTNSEL21', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT10.FENOTCHATTNSEL22', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT10.FENOTCHCAPCRSE21', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT10.FENOTCHCAPCRSE22', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT10.FENOTCHCAPFINE21', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT10.FENOTCHCAPFINE22', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT10.FENOTCHEN21', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT10.FENOTCHEN22', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT10.FENOTCHRATTNEN21', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT10.FENOTCHRATTNEN22', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT11.FENOTCHATTNSEL23', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT11.FENOTCHATTNSEL24', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT11.FENOTCHCAPCRSE23', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT11.FENOTCHCAPCRSE24', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT11.FENOTCHCAPFINE23', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT11.FENOTCHCAPFINE24', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT11.FENOTCHEN23', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT11.FENOTCHEN24', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT11.FENOTCHRATTNEN23', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT11.FENOTCHRATTNEN24', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT1.FENOTCHATTNSEL3', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT1.FENOTCHATTNSEL4', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT1.FENOTCHCAPCRSE3', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT1.FENOTCHCAPCRSE4', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT1.FENOTCHCAPFINE3', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT1.FENOTCHCAPFINE4', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT1.FENOTCHEN3', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT1.FENOTCHEN4', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT1.FENOTCHRATTNEN3', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT1.FENOTCHRATTNEN4', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT2.FENOTCHATTNSEL5', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT2.FENOTCHATTNSEL6', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT2.FENOTCHCAPCRSE5', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT2.FENOTCHCAPCRSE6', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT2.FENOTCHCAPFINE5', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT2.FENOTCHCAPFINE6', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT2.FENOTCHEN5', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT2.FENOTCHEN6', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT2.FENOTCHRATTNEN5', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT2.FENOTCHRATTNEN6', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT3.FENOTCHATTNSEL7', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT3.FENOTCHATTNSEL8', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT3.FENOTCHCAPCRSE7', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT3.FENOTCHCAPCRSE8', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT3.FENOTCHCAPFINE7', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT3.FENOTCHCAPFINE8', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT3.FENOTCHEN7', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT3.FENOTCHEN8', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT3.FENOTCHRATTNEN7', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT3.FENOTCHRATTNEN8', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT4.FENOTCHATTNSEL10', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT4.FENOTCHATTNSEL9', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT4.FENOTCHCAPCRSE10', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT4.FENOTCHCAPCRSE9', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT4.FENOTCHCAPFINE10', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT4.FENOTCHCAPFINE9', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT4.FENOTCHEN10', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT4.FENOTCHEN9', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT4.FENOTCHRATTNEN10', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT4.FENOTCHRATTNEN9', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT5.FENOTCHATTNSEL11', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT5.FENOTCHATTNSEL12', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT5.FENOTCHCAPCRSE11', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT5.FENOTCHCAPCRSE12', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT5.FENOTCHCAPFINE11', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT5.FENOTCHCAPFINE12', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT5.FENOTCHEN11', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT5.FENOTCHEN12', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT5.FENOTCHRATTNEN11', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT5.FENOTCHRATTNEN12', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT6.FENOTCHATTNSEL13', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT6.FENOTCHATTNSEL14', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT6.FENOTCHCAPCRSE13', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT6.FENOTCHCAPCRSE14', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT6.FENOTCHCAPFINE13', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT6.FENOTCHCAPFINE14', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT6.FENOTCHEN13', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT6.FENOTCHEN14', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT6.FENOTCHRATTNEN13', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT6.FENOTCHRATTNEN14', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT7.FENOTCHATTNSEL15', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT7.FENOTCHATTNSEL16', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT7.FENOTCHCAPCRSE15', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT7.FENOTCHCAPCRSE16', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT7.FENOTCHCAPFINE15', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT7.FENOTCHCAPFINE16', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT7.FENOTCHEN15', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT7.FENOTCHEN16', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT7.FENOTCHRATTNEN15', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT7.FENOTCHRATTNEN16', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT8.FENOTCHATTNSEL17', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT8.FENOTCHATTNSEL18', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT8.FENOTCHCAPCRSE17', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT8.FENOTCHCAPCRSE18', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT8.FENOTCHCAPFINE17', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT8.FENOTCHCAPFINE18', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT8.FENOTCHEN17', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT8.FENOTCHEN18', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT8.FENOTCHRATTNEN17', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT8.FENOTCHRATTNEN18', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT9.FENOTCHATTNSEL19', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT9.FENOTCHATTNSEL20', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT9.FENOTCHCAPCRSE19', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT9.FENOTCHCAPCRSE20', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT9.FENOTCHCAPFINE19', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT9.FENOTCHCAPFINE20', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT9.FENOTCHEN19', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT9.FENOTCHEN20', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT9.FENOTCHRATTNEN19', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHATT9.FENOTCHRATTNEN20', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT0.FENOTCHATTNSEL1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT0.FENOTCHATTNSEL2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT0.FENOTCHCAPCRSE1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT0.FENOTCHCAPCRSE2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT0.FENOTCHCAPFINE1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT0.FENOTCHCAPFINE2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT0.FENOTCHEN1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT0.FENOTCHEN2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT0.FENOTCHRATTNEN1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT0.FENOTCHRATTNEN2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT10.FENOTCHATTNSEL21', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT10.FENOTCHATTNSEL22', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT10.FENOTCHCAPCRSE21', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT10.FENOTCHCAPCRSE22', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT10.FENOTCHCAPFINE21', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT10.FENOTCHCAPFINE22', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT10.FENOTCHEN21', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT10.FENOTCHEN22', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT10.FENOTCHRATTNEN21', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT10.FENOTCHRATTNEN22', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT11.FENOTCHATTNSEL23', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT11.FENOTCHATTNSEL24', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT11.FENOTCHCAPCRSE23', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT11.FENOTCHCAPCRSE24', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT11.FENOTCHCAPFINE23', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT11.FENOTCHCAPFINE24', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT11.FENOTCHEN23', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT11.FENOTCHEN24', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT11.FENOTCHRATTNEN23', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT11.FENOTCHRATTNEN24', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT1.FENOTCHATTNSEL3', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT1.FENOTCHATTNSEL4', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT1.FENOTCHCAPCRSE3', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT1.FENOTCHCAPCRSE4', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT1.FENOTCHCAPFINE3', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT1.FENOTCHCAPFINE4', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT1.FENOTCHEN3', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT1.FENOTCHEN4', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT1.FENOTCHRATTNEN3', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT1.FENOTCHRATTNEN4', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT2.FENOTCHATTNSEL5', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT2.FENOTCHATTNSEL6', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT2.FENOTCHCAPCRSE5', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT2.FENOTCHCAPCRSE6', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT2.FENOTCHCAPFINE5', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT2.FENOTCHCAPFINE6', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT2.FENOTCHEN5', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT2.FENOTCHEN6', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT2.FENOTCHRATTNEN5', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT2.FENOTCHRATTNEN6', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT3.FENOTCHATTNSEL7', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT3.FENOTCHATTNSEL8', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT3.FENOTCHCAPCRSE7', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT3.FENOTCHCAPCRSE8', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT3.FENOTCHCAPFINE7', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT3.FENOTCHCAPFINE8', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT3.FENOTCHEN7', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT3.FENOTCHEN8', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT3.FENOTCHRATTNEN7', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT3.FENOTCHRATTNEN8', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT4.FENOTCHATTNSEL10', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT4.FENOTCHATTNSEL9', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT4.FENOTCHCAPCRSE10', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT4.FENOTCHCAPCRSE9', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT4.FENOTCHCAPFINE10', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT4.FENOTCHCAPFINE9', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT4.FENOTCHEN10', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT4.FENOTCHEN9', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT4.FENOTCHRATTNEN10', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT4.FENOTCHRATTNEN9', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT5.FENOTCHATTNSEL11', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT5.FENOTCHATTNSEL12', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT5.FENOTCHCAPCRSE11', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT5.FENOTCHCAPCRSE12', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT5.FENOTCHCAPFINE11', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT5.FENOTCHCAPFINE12', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT5.FENOTCHEN11', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT5.FENOTCHEN12', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT5.FENOTCHRATTNEN11', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT5.FENOTCHRATTNEN12', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT6.FENOTCHATTNSEL13', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT6.FENOTCHATTNSEL14', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT6.FENOTCHCAPCRSE13', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT6.FENOTCHCAPCRSE14', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT6.FENOTCHCAPFINE13', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT6.FENOTCHCAPFINE14', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT6.FENOTCHEN13', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT6.FENOTCHEN14', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT6.FENOTCHRATTNEN13', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT6.FENOTCHRATTNEN14', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT7.FENOTCHATTNSEL15', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT7.FENOTCHATTNSEL16', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT7.FENOTCHCAPCRSE15', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT7.FENOTCHCAPCRSE16', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT7.FENOTCHCAPFINE15', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT7.FENOTCHCAPFINE16', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT7.FENOTCHEN15', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT7.FENOTCHEN16', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT7.FENOTCHRATTNEN15', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT7.FENOTCHRATTNEN16', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT8.FENOTCHATTNSEL17', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT8.FENOTCHATTNSEL18', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT8.FENOTCHCAPCRSE17', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT8.FENOTCHCAPCRSE18', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT8.FENOTCHCAPFINE17', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT8.FENOTCHCAPFINE18', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT8.FENOTCHEN17', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT8.FENOTCHEN18', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT8.FENOTCHRATTNEN17', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT8.FENOTCHRATTNEN18', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT9.FENOTCHATTNSEL19', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT9.FENOTCHATTNSEL20', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT9.FENOTCHCAPCRSE19', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT9.FENOTCHCAPCRSE20', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT9.FENOTCHCAPFINE19', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT9.FENOTCHCAPFINE20', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT9.FENOTCHEN19', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT9.FENOTCHEN20', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT9.FENOTCHRATTNEN19', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.FENOTCHFILT9.FENOTCHRATTNEN20', int, ModelVariableFormat.HEX)
        #self._addModelRegister(model, 'AGC.PNRFATT0.LNAMIXRFATT1', int, ModelVariableFormat.HEX)
        #self._addModelRegister(model, 'AGC.PNRFATT0.LNAMIXRFATT2', int, ModelVariableFormat.HEX)
        #self._addModelRegister(model, 'AGC.PNRFATT0.LNAMIXRFATT3', int, ModelVariableFormat.HEX)
        #self._addModelRegister(model, 'AGC.PNRFATT1.LNAMIXRFATT4', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT1.LNAMIXRFATT5', int, ModelVariableFormat.HEX)
        #self._addModelRegister(model, 'AGC.PNRFATT1.LNAMIXRFATT6', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT2.LNAMIXRFATT7', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT2.LNAMIXRFATT8', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT2.LNAMIXRFATT9', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT3.LNAMIXRFATT10', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT3.LNAMIXRFATT11', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT3.LNAMIXRFATT12', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT4.LNAMIXRFATT13', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT4.LNAMIXRFATT14', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT4.LNAMIXRFATT15', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT5.LNAMIXRFATT16', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT5.LNAMIXRFATT17', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT5.LNAMIXRFATT18', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT6.LNAMIXRFATT19', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT6.LNAMIXRFATT20', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT6.LNAMIXRFATT21', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT7.LNAMIXRFATT22', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT7.LNAMIXRFATT23', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT7.LNAMIXRFATT24', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT0.LNAMIXRFATT1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT0.LNAMIXRFATT2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT0.LNAMIXRFATT3', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT1.LNAMIXRFATT4', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT1.LNAMIXRFATT5', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT1.LNAMIXRFATT6', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT2.LNAMIXRFATT7', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT2.LNAMIXRFATT8', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT2.LNAMIXRFATT9', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT3.LNAMIXRFATT10', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT3.LNAMIXRFATT11', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT3.LNAMIXRFATT12', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT4.LNAMIXRFATT13', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT4.LNAMIXRFATT14', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT4.LNAMIXRFATT15', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT5.LNAMIXRFATT16', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT5.LNAMIXRFATT17', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT5.LNAMIXRFATT18', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT6.LNAMIXRFATT19', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT6.LNAMIXRFATT20', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT6.LNAMIXRFATT21', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT7.LNAMIXRFATT22', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT7.LNAMIXRFATT23', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFFILT7.LNAMIXRFATT24', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'RAC.SYLOEN.SYLODIVRLOADCCLKSEL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXTRIM0.LNAMIXCAPSEL0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXTRIM1.LNAMIXCAPSEL1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RFPATHEN0.SYLODIVRLO02G4EN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RFPATHEN1.SYLODIVRLO12G4EN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYLOEN.SYLODIVRLOADCCLK2G4EN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYLOEN.SYLODIVTLO0DBM2G4AUXEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYLOEN.SYLODIVTLO0DBM2G4EN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYLOEN.SYLODIVTLO20DBM2G4AUXEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYLOEN.SYLODIVTLO20DBM2G4EN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TXPOWER.TX0DBMPOWER', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TXPOWER.TX0DBMSELSLICE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PACTRL.TXPASELSLICE', int, ModelVariableFormat.HEX)

    def _add_dig_ramp_en_reg_field(self, model):
        pass

    def _add_SYNTH_DSMCTRL_regs(self, model):
        self._addModelRegister(model, 'SYNTH.DSMCTRLRX.DEMMODERX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'SYNTH.DSMCTRLRX.DITHERDACRX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'SYNTH.DSMCTRLRX.DITHERDSMINPUTRX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'SYNTH.DSMCTRLRX.DITHERDSMOUTPUTRX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'SYNTH.DSMCTRLRX.DSMMODERX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'SYNTH.DSMCTRLRX.LSBFORCERX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'SYNTH.DSMCTRLRX.MASHORDERRX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'SYNTH.DSMCTRLTX.DITHERDACTX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'SYNTH.DSMCTRLTX.DITHERDSMOUTPUTTX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'SYNTH.DSMCTRLTX.DEMMODETX', int, ModelVariableFormat.HEX)

    def _add_RAC_SYTRIM_regs(self, model):
        self._addModelRegister(model, 'RAC.SYTRIM1.SYLODIVLDOTRIMNDIORX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYTRIM0.SYCHPSRCENRX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYTRIM0.SYCHPLEVPSRCRX', int, ModelVariableFormat.HEX)
        pass

    def _add_RAC_RXTX_SY_regs(self, model):
        pass

    def _add_RAC_SYMMDCTRL_SYMMDMODE_regs(self, model):
        self._addModelRegister(model, 'RAC.SYMMDCTRL.SYMMDMODERX', int, ModelVariableFormat.HEX)
        pass

    def __add_RAC_SYEN_regs(self, model):
        self._addModelRegister(model, 'RAC.SYEN.SYCHPLPENRX', int, ModelVariableFormat.HEX)
        pass

    def _add_RAC_RX_LNAMIXENRFPKDLOTHRESH_regs(self, model):
        pass

    def _add_RAC_SYNTHCTRL_MMDPOWERBALANCEDISABLE_regs(self, model):
        pass

    def _add_etsctrl_regs(self, model):
        pass

    def _add_antswctrl_regs(self, model):
        self._addModelRegister(model, 'MODEM.ANTSWCTRL.ANTSWRST', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ANTSWCTRL.CFGANTPATTEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ANTSWCTRL.ANTSWENABLE', int, ModelVariableFormat.HEX)

    def _add_antswstart_regs(self, model):
        pass

    def _add_antswend_regs(self, model):
        pass

    def _add_cfgantpatt_regs(self, model):
        pass

    def _add_OOKSHAPING_regs(self, model):
        pass

    def _add_IFADCPLLDCO_regs(self, model):
        self._addModelRegister(model, 'RAC.IFADCPLLDCO.IFADCPLLDCOENABLE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLDCO.IFADCPLLDCOMSBCURRENT', int, ModelVariableFormat.HEX)

    def _add_IFADCPLLEN_regs(self, model):
        self._addModelRegister(model, 'RAC.IFADCPLLEN.IFADCPLLENBBDET', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLEN.IFADCPLLENBBXLDET', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLEN.IFADCPLLENBBXMDET', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLEN.IFADCPLLENCFDET', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLEN.IFADCPLLENROTDET', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLEN.IFADCPLLSERIEREGENABLE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLEN.IFADCPLLSHUNTREGENABLE', int, ModelVariableFormat.HEX)

    def _add_IFADCTRIM1_regs(self, model):
        pass

    def _add_PATRIM3_regs(self, model):
        pass

    def _add_SYDIVCTRL_regs(self, model):
        pass

    def _add_SYNTHENCTRL_regs(self, model):
        pass

    def _add_TXRAMP_regs(self, model):
        self._addModelRegister(model, 'RAC.TXRAMP.TXPHASEDIGITAL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TXRAMP.TXANARAMPDRVEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TXRAMP.TXUNMUTEENDRVFF', int, ModelVariableFormat.HEX)

    def _add_ADQUAL_regs(self, model):
        self._addModelRegister(model, 'MODEM.ADQUAL8.ADBAAGCTHR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADQUAL8.ADBAMODE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADQUAL8.ADBACORRTHR2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADQUAL7.ADBARSSITHR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADQUAL7.ADBARSSIDIFF', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADQUAL6.ADBACORRTHR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADQUAL6.ADBACORRDIFF', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADQUAL5.ADDIRECTCORR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADQUAL4.ADAGCGRTHR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADQUAL4.ADRSSIGRTHR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADQUAL4.ADGRMODE', int, ModelVariableFormat.HEX)

    def _add_ADFSM0_regs(self, model):
        self._addModelRegister(model, 'MODEM.ADFSM0.ADSTATREAD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADFSM0.ADSTAT1SEL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADFSM0.ADSTAT2SEL', int, ModelVariableFormat.HEX)

    def _add_ADCTRL_regs(self, model):
        self._addModelRegister(model, 'MODEM.ADCTRL2.ADCTRL2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADCTRL1.ADCTRL1', int, ModelVariableFormat.HEX)

    def _add_ADPC_regs(self, model):
        self._addModelRegister(model, 'MODEM.ADPC1.ADPCEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC1.ADPCWNDSIZECHIP', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC1.ADPCCORROFFSETCHIP', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC1.ADPCTIMINGBAUDS', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC1.ADPCWNDCNT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC2.ADPCCORRSAMPLES', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC2.ADENCORR32', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC2.ADPCSIGAMPTHR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC2.ADPCWNDCNTRST', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC2.ADPCPRETIMINGBAUDS', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC3.ADBBSSEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC3.ADBBSSFILTLENGTH', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC3.ADBBSSAMPMANT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC3.ADBBSSAMPEXP', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC3.ADBBSSAVGEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC3.ADBBSSAVGPER', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC3.ADBBSSAVGWAIT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC3.ADBBSSAVGFREEZE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC3.ADBBSSSELWRDATA', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC4.ADBBSSAMPLUT0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC4.ADBBSSAMPLUT1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC4.ADBBSSAMPLUT2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC4.ADBBSSAMPLUT3', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC5.ADBBSSAMPLUT4', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC5.ADBBSSAMPLUT5', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC5.ADBBSSAMPLUT6', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC5.ADBBSSAMPLUT7', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC6.ADBBSSAMPLUT8', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC6.ADBBSSAMPLUT9', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC6.ADBBSSAMPLUT10', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC6.ADBBSSAMPLUT11', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC7.ADBBSSAMPLUT12', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC7.ADBBSSAMPLUT13', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC7.ADBBSSAMPLUT14', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC7.ADBBSSAMPLUT15', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC8.ADPCOSR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC8.ADPCANTSAMPOFFSET', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC8.ADPCANTSAMPSWITCHWAIT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC8.ADPCANTSAMPBUF', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC8.ADPCANTSAMPWRITE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC8.ADPCANTSAMPSWITCH', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC9.ADBBSSAMPTHR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC9.ADBBSSAMPAVGLIM', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC9.ADBBSSSYNCEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC9.ADBBSSUPTHR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC9.ADBBSSDNTHR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC10.ADBBSSAMPJUMP', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC10.ADBBSSCHANGEEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC10.ADBBSSCHGUPTHR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ADPC10.ADBBSSCHGDNTHR', int, ModelVariableFormat.HEX)

    def _add_CHFCTRL_regs(self, model):
        self._addModelRegister(model, 'MODEM.CHFCTRL.CHFSWSEL', int, ModelVariableFormat.HEX)

