from pycalcmodel.core.output import ModelOutput, ModelOutputType


def build_modem_regs_panther(model,profile):

    # These were extracted from Panther register model. Only writeable registers that are new (do not exist in EFR90nm) are listed here.
    # Must have a corresponding _addModelRegister entry in pyradioconfig/parts/panther/calculators/calc_global.py buildAdditionalPantherVariables
    # MCUW_RADIO_CFG-734 Panther: PHY/MAC Design requests more registers added (all MODEM, AGC, etc.) with re-writes of reset values

    # AGC peripheral has 133 writeable fields in total

    # All Panther PHY cfg files show 133 AGC field writes

    # Except _EN_EN and _IEN_

    # Note that 39 Panther AGC fields were explicitly omitted as they exist on EFR90nm.
    # HOWEVER, those fields may not have been added to the Radio Configurator in the EFR90nm era.
    # Thus they will need to be manually added here:

    # An error such as
    # AttributeError: 'ModelOutputOverrideContainer' object has no attribute 'AGC_CTRL1_RSSIPERIOD'
    # indicates a line below needs to be uncommented (enabled)

    # AGC.CTRL0.PWRTARGET
    # AGC.CTRL0.MODE
    # AGC.CTRL0.RSSISHIFT
    # AGC.CTRL0.DISCFLOOPADJ
    # AGC.CTRL0.AGCCLKUNDIVREQ
    # AGC.CTRL0.DISRESETCHPWR
    # AGC.CTRL1.RSSIPERIOD
    # AGC.CTRL1.SUBPERIOD
    # AGC.CTRL1.SUBNUM
    # AGC.CTRL1.SUBDEN
    # AGC.CTRL1.SUBINT
    # AGC.CTRL2.DMASEL
    # AGC.RSSISTEPTHR.POSSTEPTHR
    # AGC.RSSISTEPTHR.NEGSTEPTHR
    # AGC.MANGAIN.MANGAINIFPGA
    # AGC.MANGAIN.MANGAINEN
    # AGC.IF.RSSIVALID
    # AGC.IF.CCA
    # AGC.IF.RSSIPOSSTEP
    # AGC.IF.RSSINEGSTEP
    # AGC.IF.RSSIDONE
    # AGC.IEN.RSSIVALID
    # AGC.IEN.CCA
    # AGC.IEN.RSSIPOSSTEP
    # AGC.IEN.RSSINEGSTEP
    # AGC.IEN.RSSIDONE
    # AGC.CMD.RSSISTART
    # AGC.GAINSTEPLIM.CFLOOPSTEPMAX
    # AGC.CTRL0.ENRSSIRESET
    # AGC.RSSISTEPTHR.STEPPER
    # AGC.RSSISTEPTHR.DEMODRESTARTPER
    # AGC.RSSISTEPTHR.DEMODRESTARTTHR
    # AGC.LBT.CCARSSIPERIOD
    # AGC.LBT.ENCCARSSIPERIOD
    # AGC.LBT.ENCCAGAINREDUCED
    # AGC.LBT.ENCCARSSIMAX
    # AGC.IF.SHORTRSSIPOSSTEP
    # AGC.IEN.SHORTRSSIPOSSTEP
    # AGC.MIRRORIF.IFMIRRORCLEAR

    # This function is too big for Jython, so had to split it up into multiple functions
    build_modem_regs_panther_lynx_common_part1(model, profile)
    build_modem_regs_panther_lynx_common_part2(model, profile)
    # Panther-specific. Not in Lynx.
    if model.part_family.lower() in ["panther"]:
        build_modem_regs_panther_only(model, profile)

def build_modem_regs_panther_lynx_common_part1(model, profile):
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL0_PWRTARGET, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL0.PWRTARGET'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL0_MODE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL0.MODE'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL0_DISCFLOOPADJ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL0.DISCFLOOPADJ'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL0_DISRESETCHPWR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL0.DISRESETCHPWR'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL0_ADCATTENMODE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL0.ADCATTENMODE'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL0_ADCATTENCODE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL0.ADCATTENCODE'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL0_ENRSSIRESET, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL0.ENRSSIRESET'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL0_DSADISCFLOOP, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL0.DSADISCFLOOP'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL0_DISPNGAINUP, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL0.DISPNGAINUP'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL0_DISPNDWNCOMP, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL0.DISPNDWNCOMP'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL0_AGCRST, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL0.AGCRST'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL1_RSSIPERIOD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL1.RSSIPERIOD'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL1_PWRPERIOD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL1.PWRPERIOD'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL1_SUBPERIOD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL1.SUBPERIOD'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL1_SUBNUM, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL1.SUBNUM'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL1_SUBDEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL1.SUBDEN'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL1_SUBINT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL1.SUBINT'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL2_DMASEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL2.DMASEL'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL2_SAFEMODE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL2.SAFEMODE'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL2_SAFEMODETHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL2.SAFEMODETHD'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL2_REHICNTTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL2.REHICNTTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL2_RELOTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL2.RELOTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL2_RELBYCHPWR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL2.RELBYCHPWR'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL2_RELTARGETPWR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL2.RELTARGETPWR'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL2_PRSDEBUGEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL2.PRSDEBUGEN'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL2_DISRFPKD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL2.DISRFPKD'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL3_IFPKDDEB, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL3.IFPKDDEB'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL3_IFPKDDEBTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL3.IFPKDDEBTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL3_IFPKDDEBPRD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL3.IFPKDDEBPRD'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL3_IFPKDDEBRST, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL3.IFPKDDEBRST'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL3_RFPKDDEB, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL3.RFPKDDEB'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL3_RFPKDDEBTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL3.RFPKDDEBTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL3_RFPKDDEBPRD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL3.RFPKDDEBPRD'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL3_RFPKDDEBRST, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL3.RFPKDDEBRST'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_RSSISTEPTHR_POSSTEPTHR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.RSSISTEPTHR.POSSTEPTHR'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_RSSISTEPTHR_NEGSTEPTHR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.RSSISTEPTHR.NEGSTEPTHR'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_RSSISTEPTHR_STEPPER, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.RSSISTEPTHR.STEPPER'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_RSSISTEPTHR_DEMODRESTARTPER, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.RSSISTEPTHR.DEMODRESTARTPER'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_RSSISTEPTHR_DEMODRESTARTTHR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.RSSISTEPTHR.DEMODRESTARTTHR'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_RSSISTEPTHR_RSSIFAST, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.RSSISTEPTHR.RSSIFAST'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_MANGAIN_MANGAINEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.MANGAIN.MANGAINEN'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_MANGAIN_MANGAINIFPGA, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.MANGAIN.MANGAINIFPGA'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_MANGAIN_MANGAINLNA, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.MANGAIN.MANGAINLNA'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_MANGAIN_MANGAINPN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.MANGAIN.MANGAINPN'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_MANGAIN_MANRFLATRST, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.MANGAIN.MANRFLATRST'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_MANGAIN_MANIFLOLATRST, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.MANGAIN.MANIFLOLATRST'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_MANGAIN_MANIFHILATRST, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.MANGAIN.MANIFHILATRST'           ))
    # profile.outputs.append(ModelOutput(model.vars.AGC_CMD_RSSISTART, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CMD.RSSISTART'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_GAINRANGE_LNAINDEXBORDER, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.GAINRANGE.LNAINDEXBORDER'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_GAINRANGE_PGAINDEXBORDER, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.GAINRANGE.PGAINDEXBORDER'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_GAINRANGE_GAININCSTEP, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.GAINRANGE.GAININCSTEP'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_GAINRANGE_PNGAINSTEP, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.GAINRANGE.PNGAINSTEP'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_GAINRANGE_LATCHEDHISTEP, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.GAINRANGE.LATCHEDHISTEP'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_GAINRANGE_HIPWRTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.GAINRANGE.HIPWRTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_GAINRANGE_BOOSTLNA, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.GAINRANGE.BOOSTLNA'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_GAINRANGE_LNABWADJ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.GAINRANGE.LNABWADJ'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_AGCPERIOD_PERIODHI, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.AGCPERIOD.PERIODHI'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_AGCPERIOD_PERIODLO, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.AGCPERIOD.PERIODLO'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_AGCPERIOD_MAXHICNTTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.AGCPERIOD.MAXHICNTTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_AGCPERIOD_SETTLETIMEIF, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.AGCPERIOD.SETTLETIMEIF'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_AGCPERIOD_SETTLETIMERF, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.AGCPERIOD.SETTLETIMERF'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_HICNTREGION_HICNTREGION0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.HICNTREGION.HICNTREGION0'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_HICNTREGION_HICNTREGION1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.HICNTREGION.HICNTREGION1'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_HICNTREGION_HICNTREGION2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.HICNTREGION.HICNTREGION2'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_HICNTREGION_HICNTREGION3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.HICNTREGION.HICNTREGION3'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_HICNTREGION_HICNTREGION4, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.HICNTREGION.HICNTREGION4'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_STEPDWN_STEPDWN0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.STEPDWN.STEPDWN0'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_STEPDWN_STEPDWN1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.STEPDWN.STEPDWN1'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_STEPDWN_STEPDWN2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.STEPDWN.STEPDWN2'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_STEPDWN_STEPDWN3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.STEPDWN.STEPDWN3'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_STEPDWN_STEPDWN4, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.STEPDWN.STEPDWN4'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_STEPDWN_STEPDWN5, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.STEPDWN.STEPDWN5'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_GAINSTEPLIM_CFLOOPSTEPMAX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.GAINSTEPLIM.CFLOOPSTEPMAX'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_GAINSTEPLIM_CFLOOPDEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.GAINSTEPLIM.CFLOOPDEL'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_GAINSTEPLIM_HYST, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.GAINSTEPLIM.HYST'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_GAINSTEPLIM_MAXPWRVAR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.GAINSTEPLIM.MAXPWRVAR'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_GAINSTEPLIM_TRANRSTAGC, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.GAINSTEPLIM.TRANRSTAGC'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT0_LNAMIXRFATT1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT0.LNAMIXRFATT1'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT0_LNAMIXRFATT2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT0.LNAMIXRFATT2'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT0_LNAMIXRFATT3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT0.LNAMIXRFATT3'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT0_LNAMIXRFATT4, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT0.LNAMIXRFATT4'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT0_LNAMIXRFATT5, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT0.LNAMIXRFATT5'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT1_LNAMIXRFATT6, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT1.LNAMIXRFATT6'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT1_LNAMIXRFATT7, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT1.LNAMIXRFATT7'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT1_LNAMIXRFATT8, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT1.LNAMIXRFATT8'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT1_LNAMIXRFATT9, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT1.LNAMIXRFATT9'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT1_LNAMIXRFATT10, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT1.LNAMIXRFATT10'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT2_LNAMIXRFATT11, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT2.LNAMIXRFATT11'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT2_LNAMIXRFATT12, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT2.LNAMIXRFATT12'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT2_LNAMIXRFATT13, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT2.LNAMIXRFATT13'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT2_LNAMIXRFATT14, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT2.LNAMIXRFATT14'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_LNAMIXCODE0_LNAMIXSLICE1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.LNAMIXCODE0.LNAMIXSLICE1'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_LNAMIXCODE0_LNAMIXSLICE2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.LNAMIXCODE0.LNAMIXSLICE2'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_LNAMIXCODE0_LNAMIXSLICE3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.LNAMIXCODE0.LNAMIXSLICE3'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_LNAMIXCODE0_LNAMIXSLICE4, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.LNAMIXCODE0.LNAMIXSLICE4'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_LNAMIXCODE0_LNAMIXSLICE5, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.LNAMIXCODE0.LNAMIXSLICE5'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_LNAMIXCODE1_LNAMIXSLICE6, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.LNAMIXCODE1.LNAMIXSLICE6'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_LNAMIXCODE1_LNAMIXSLICE7, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.LNAMIXCODE1.LNAMIXSLICE7'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_LNAMIXCODE1_LNAMIXSLICE8, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.LNAMIXCODE1.LNAMIXSLICE8'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_LNAMIXCODE1_LNAMIXSLICE9, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.LNAMIXCODE1.LNAMIXSLICE9'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_LNAMIXCODE1_LNAMIXSLICE10, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.LNAMIXCODE1.LNAMIXSLICE10'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PGACODE0_PGAGAIN1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PGACODE0.PGAGAIN1'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PGACODE0_PGAGAIN2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PGACODE0.PGAGAIN2'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PGACODE0_PGAGAIN3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PGACODE0.PGAGAIN3'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PGACODE0_PGAGAIN4, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PGACODE0.PGAGAIN4'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PGACODE0_PGAGAIN5, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PGACODE0.PGAGAIN5'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PGACODE0_PGAGAIN6, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PGACODE0.PGAGAIN6'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PGACODE0_PGAGAIN7, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PGACODE0.PGAGAIN7'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PGACODE0_PGAGAIN8, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PGACODE0.PGAGAIN8'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PGACODE1_PGAGAIN9, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PGACODE1.PGAGAIN9'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PGACODE1_PGAGAIN10, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PGACODE1.PGAGAIN10'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_PGACODE1_PGAGAIN11, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PGACODE1.PGAGAIN11'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_LBT_CCARSSIPERIOD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.LBT.CCARSSIPERIOD'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_LBT_ENCCARSSIPERIOD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.LBT.ENCCARSSIPERIOD'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_LBT_ENCCAGAINREDUCED, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.LBT.ENCCAGAINREDUCED'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_LBT_ENCCARSSIMAX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.LBT.ENCCARSSIMAX'           ))
    profile.outputs.append(ModelOutput(model.vars.FRC_AUTOCG_AUTOCGEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FRC.AUTOCG.AUTOCGEN'           ))
    profile.outputs.append(ModelOutput(model.vars.FRC_CONVRAMADDR_CONVRAMADDR, '', ModelOutputType.SVD_REG_FIELD, readable_name='FRC.CONVRAMADDR.CONVRAMADDR'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_MIXCTRL_ANAMIXMODE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.MIXCTRL.ANAMIXMODE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_MIXCTRL_DIGIQSWAPEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.MIXCTRL.DIGIQSWAPEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL0_FDM0DIFFDIS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL0.FDM0DIFFDIS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL0_MAPFSK, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL0.MAPFSK'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL0_CODING, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL0.CODING'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL0_MODFORMAT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL0.MODFORMAT'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL0_DUALCORROPTDIS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL0.DUALCORROPTDIS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL0_OOKASYNCPIN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL0.OOKASYNCPIN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL0_DSSSLEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL0.DSSSLEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL0_DSSSSHIFTS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL0.DSSSSHIFTS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL0_DSSSDOUBLE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL0.DSSSDOUBLE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL0_DETDIS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL0.DETDIS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL0_DIFFENCMODE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL0.DIFFENCMODE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL0_SHAPING, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL0.SHAPING'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL0_DEMODRAWDATASEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL0.DEMODRAWDATASEL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL0_FRAMEDETDEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL0.FRAMEDETDEL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL1_SYNCBITS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL1.SYNCBITS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL1_SYNCERRORS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL1.SYNCERRORS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL1_DUALSYNC, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL1.DUALSYNC'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL1_TXSYNC, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL1.TXSYNC'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL1_SYNCDATA, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL1.SYNCDATA'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL1_SYNC1INV, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL1.SYNC1INV'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL1_COMPMODE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL1.COMPMODE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL1_RESYNCPER, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL1.RESYNCPER'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL1_PHASEDEMOD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL1.PHASEDEMOD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL1_FREQOFFESTPER, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL1.FREQOFFESTPER'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL1_FREQOFFESTLIM, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL1.FREQOFFESTLIM'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL2_SQITHRESH, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL2.SQITHRESH'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL2_RXFRCDIS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL2.RXFRCDIS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL2_RXPINMODE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL2.RXPINMODE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL2_TXPINMODE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL2.TXPINMODE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL2_DATAFILTER, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL2.DATAFILTER'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL2_BRDIVA, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL2.BRDIVA'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL2_BRDIVB, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL2.BRDIVB'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL2_DEVMULA, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL2.DEVMULA'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL2_DEVMULB, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL2.DEVMULB'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL2_RATESELMODE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL2.RATESELMODE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL2_DEVWEIGHTDIS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL2.DEVWEIGHTDIS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL2_DMASEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL2.DMASEL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL3_PRSDINEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL3.PRSDINEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL3_RAMTESTEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL3.RAMTESTEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL3_TSAMPMODE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL3.TSAMPMODE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL3_TSAMPDEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL3.TSAMPDEL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL3_TSAMPLIM, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL3.TSAMPLIM'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL4_ISICOMP, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL4.ISICOMP'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL4_DEVOFFCOMP, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL4.DEVOFFCOMP'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL4_PREDISTGAIN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL4.PREDISTGAIN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL4_PREDISTDEB, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL4.PREDISTDEB'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL4_PREDISTAVG, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL4.PREDISTAVG'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL4_PREDISTRST, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL4.PREDISTRST'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL4_PHASECLICKFILT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL4.PHASECLICKFILT'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL4_SOFTDSSSMODE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL4.SOFTDSSSMODE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL4_ADCSATLEVEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL4.ADCSATLEVEL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL4_ADCSATDENS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL4.ADCSATDENS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL4_OFFSETPHASEMASKING, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL4.OFFSETPHASEMASKING'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL4_OFFSETPHASESCALING, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL4.OFFSETPHASESCALING'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL4_CLKUNDIVREQ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL4.CLKUNDIVREQ'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_BRCALEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.BRCALEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_BRCALMODE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.BRCALMODE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_BRCALAVG, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.BRCALAVG'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_DETDEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.DETDEL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_TDEDGE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.TDEDGE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_TREDGE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.TREDGE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_DEMODRAWDATASEL2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.DEMODRAWDATASEL2'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_RESYNCBAUDTRANS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.RESYNCBAUDTRANS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_RESYNCLIMIT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.RESYNCLIMIT'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_CODINGB, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.CODINGB'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_RXRESTARTUPONRSSI, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.RXRESTARTUPONRSSI'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_RXRESTARTUPONSHORTRSSI, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.RXRESTARTUPONSHORTRSSI'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_RXBRCALCDIS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.RXBRCALCDIS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_DEMODRESTARTALL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.DEMODRESTARTALL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_TXBR_TXBRNUM, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.TXBR.TXBRNUM'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_TXBR_TXBRDEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.TXBR.TXBRDEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_RXBR_RXBRNUM, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.RXBR.RXBRNUM'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_RXBR_RXBRDEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.RXBR.RXBRDEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_RXBR_RXBRINT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.RXBR.RXBRINT'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CF_DEC0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CF.DEC0'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CF_DEC1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CF.DEC1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CF_DEC2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CF.DEC2'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CF_CFOSR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CF.CFOSR'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CF_DEC1GAIN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CF.DEC1GAIN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CF_ADCBITORDERI, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CF.ADCBITORDERI'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CF_ADCBITORDERQ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CF.ADCBITORDERQ'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PRE_BASE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.PRE.BASE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PRE_BASEBITS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.PRE.BASEBITS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PRE_PRESYMB4FSK, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.PRE.PRESYMB4FSK'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PRE_PREERRORS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.PRE.PREERRORS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PRE_DSSSPRE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.PRE.DSSSPRE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PRE_SYNCSYMB4FSK, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.PRE.SYNCSYMB4FSK'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PRE_TXBASES, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.PRE.TXBASES'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SYNC0_SYNC0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SYNC0.SYNC0'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SYNC1_SYNC1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SYNC1.SYNC1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_TIMING_TIMTHRESH, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.TIMING.TIMTHRESH'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_TIMING_TIMINGBASES, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.TIMING.TIMINGBASES'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_TIMING_ADDTIMSEQ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.TIMING.ADDTIMSEQ'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_TIMING_TIMSEQINVEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.TIMING.TIMSEQINVEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_TIMING_TIMSEQSYNC, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.TIMING.TIMSEQSYNC'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_TIMING_FDM0THRESH, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.TIMING.FDM0THRESH'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_TIMING_OFFSUBNUM, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.TIMING.OFFSUBNUM'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_TIMING_OFFSUBDEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.TIMING.OFFSUBDEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_TIMING_TSAGCDEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.TIMING.TSAGCDEL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_TIMING_FASTRESYNC, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.TIMING.FASTRESYNC'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSSS0_DSSS0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSSS0.DSSS0'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_MODINDEX_MODINDEXM, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.MODINDEX.MODINDEXM'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_MODINDEX_MODINDEXE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.MODINDEX.MODINDEXE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_MODINDEX_FREQGAINE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.MODINDEX.FREQGAINE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_MODINDEX_FREQGAINM, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.MODINDEX.FREQGAINM'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_AFC_AFCSCALEM, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.AFC.AFCSCALEM'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_AFC_AFCSCALEE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.AFC.AFCSCALEE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_AFC_AFCRXMODE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.AFC.AFCRXMODE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_AFC_AFCTXMODE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.AFC.AFCTXMODE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_AFC_AFCRXCLR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.AFC.AFCRXCLR'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_AFC_AFCDEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.AFC.AFCDEL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_AFC_AFCAVGPER, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.AFC.AFCAVGPER'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_AFC_AFCLIMRESET, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.AFC.AFCLIMRESET'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_AFC_AFCONESHOT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.AFC.AFCONESHOT'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_AFC_AFCENINTCOMP, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.AFC.AFCENINTCOMP'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_AFC_AFCDSAFREQOFFEST, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.AFC.AFCDSAFREQOFFEST'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_AFC_AFCDELDET, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.AFC.AFCDELDET'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_AFCADJLIM_AFCADJLIM, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.AFCADJLIM.AFCADJLIM'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING0_COEFF0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING0.COEFF0'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING0_COEFF1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING0.COEFF1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING0_COEFF2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING0.COEFF2'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING0_COEFF3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING0.COEFF3'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING1_COEFF4, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING1.COEFF4'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING1_COEFF5, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING1.COEFF5'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING1_COEFF6, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING1.COEFF6'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING1_COEFF7, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING1.COEFF7'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING2_COEFF8, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING2.COEFF8'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING2_COEFF9, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING2.COEFF9'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING2_COEFF10, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING2.COEFF10'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING2_COEFF11, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING2.COEFF11'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING3_COEFF12, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING3.COEFF12'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING3_COEFF13, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING3.COEFF13'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING3_COEFF14, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING3.COEFF14'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING3_COEFF15, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING3.COEFF15'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING4_COEFF16, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING4.COEFF16'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING4_COEFF17, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING4.COEFF17'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING4_COEFF18, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING4.COEFF18'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING4_COEFF19, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING4.COEFF19'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING5_COEFF22, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING5.COEFF22'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING5_COEFF23, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING5.COEFF23'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DCCOMP_DCESTIEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DCCOMP.DCESTIEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DCCOMP_DCCOMPEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DCCOMP.DCCOMPEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DCCOMP_DCRSTEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DCCOMP.DCRSTEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DCCOMP_DCCOMPFREEZE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DCCOMP.DCCOMPFREEZE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DCCOMP_DCCOMPGEAR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DCCOMP.DCCOMPGEAR'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DCCOMP_DCLIMIT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DCCOMP.DCLIMIT'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DCCOMPFILTINIT_DCCOMPINITVALI, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DCCOMPFILTINIT.DCCOMPINITVALI'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DCCOMPFILTINIT_DCCOMPINITVALQ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DCCOMPFILTINIT.DCCOMPINITVALQ'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DCCOMPFILTINIT_DCCOMPINIT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DCCOMPFILTINIT.DCCOMPINIT'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SRCCHF_SRCRATIO1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SRCCHF.SRCRATIO1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SRCCHF_SRCENABLE1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SRCCHF.SRCENABLE1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SRCCHF_SRCRATIO2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SRCCHF.SRCRATIO2'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SRCCHF_SRCENABLE2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SRCCHF.SRCENABLE2'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SRCCHF_BWSEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SRCCHF.BWSEL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SRCCHF_INTOSR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SRCCHF.INTOSR'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD0_SPIKETHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD0.SPIKETHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD0_UNMODTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD0.UNMODTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD0_FDEVMINTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD0.FDEVMINTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD0_FDEVMAXTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD0.FDEVMAXTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD1_POWABSTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD1.POWABSTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD1_POWRELTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD1.POWRELTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD1_DSARSTCNT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD1.DSARSTCNT'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD1_RSSIJMPTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD1.RSSIJMPTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD1_FREQLATDLY, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD1.FREQLATDLY'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD1_PWRFLTBYP, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD1.PWRFLTBYP'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD1_AMPFLTBYP, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD1.AMPFLTBYP'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD1_PWRDETDIS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD1.PWRDETDIS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD1_FREQSCALE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD1.FREQSCALE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSACTRL_DSAMODE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSACTRL.DSAMODE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSACTRL_ARRTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSACTRL.ARRTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSACTRL_ARRTOLERTHD0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSACTRL.ARRTOLERTHD0'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSACTRL_ARRTOLERTHD1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSACTRL.ARRTOLERTHD1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSACTRL_SCHPRD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSACTRL.SCHPRD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSACTRL_FREQAVGSYM, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSACTRL.FREQAVGSYM'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSACTRL_TRANRSTDSA, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSACTRL.TRANRSTDSA'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSACTRL_DSARSTON, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSACTRL.DSARSTON'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSACTRL_GAINREDUCDLY, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSACTRL.GAINREDUCDLY'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSACTRL_LOWDUTY, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSACTRL.LOWDUTY'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSACTRL_RESTORE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSACTRL.RESTORE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSACTRL_AGCBAUDEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSACTRL.AGCBAUDEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSACTRL_AMPJUPTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSACTRL.AMPJUPTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VITERBIDEMOD_VTDEMODEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VITERBIDEMOD.VTDEMODEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VITERBIDEMOD_HARDDECISION, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VITERBIDEMOD.HARDDECISION'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VITERBIDEMOD_VITERBIKSI1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VITERBIDEMOD.VITERBIKSI1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VITERBIDEMOD_VITERBIKSI2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VITERBIDEMOD.VITERBIKSI2'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VITERBIDEMOD_VITERBIKSI3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VITERBIDEMOD.VITERBIKSI3'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VITERBIDEMOD_SYNTHAFC, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VITERBIDEMOD.SYNTHAFC'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VITERBIDEMOD_CORRCYCLE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VITERBIDEMOD.CORRCYCLE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VITERBIDEMOD_CORRSTPSIZE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VITERBIDEMOD.CORRSTPSIZE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VITERBIDEMOD_DISDEMODOF, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VITERBIDEMOD.DISDEMODOF'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTCORRCFG0_EXPECTPATT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VTCORRCFG0.EXPECTPATT'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DIGMIXCTRL_DIGMIXFREQ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DIGMIXCTRL.DIGMIXFREQ'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DIGMIXCTRL_DIGMIXMODE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DIGMIXCTRL.DIGMIXMODE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DIGMIXCTRL_MIXERCONJ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DIGMIXCTRL.MIXERCONJ'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTCORRCFG1_CORRSHFTLEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VTCORRCFG1.CORRSHFTLEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTCORRCFG1_VTFRQLIM, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VTCORRCFG1.VTFRQLIM'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTCORRCFG1_EXPSYNCLEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VTCORRCFG1.EXPSYNCLEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTCORRCFG1_BUFFHEAD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VTCORRCFG1.BUFFHEAD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTCORRCFG1_EXPECTHT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VTCORRCFG1.EXPECTHT'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTTRACK_FREQTRACKMODE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VTTRACK.FREQTRACKMODE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTTRACK_TIMTRACKTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VTTRACK.TIMTRACKTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTTRACK_TIMEACQUTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VTTRACK.TIMEACQUTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTTRACK_TIMCHK, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VTTRACK.TIMCHK'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTTRACK_TIMEOUTMODE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VTTRACK.TIMEOUTMODE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTTRACK_TIMGEAR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VTTRACK.TIMGEAR'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTTRACK_FREQBIAS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VTTRACK.FREQBIAS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTTRACK_HIPWRTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VTTRACK.HIPWRTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_AUTOCG_AUTOCGEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.AUTOCG.AUTOCGEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CGCLKSTOP_FORCEOFF, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CGCLKSTOP.FORCEOFF'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD2_POWABSTHDLOG, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD2.POWABSTHDLOG'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD2_JUMPDETEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD2.JUMPDETEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD2_FDADJTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD2.FDADJTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD2_PMDETPASSTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD2.PMDETPASSTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD2_FREQESTTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD2.FREQESTTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD2_INTERFERDET, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD2.INTERFERDET'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD2_PMDETFORCE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD2.PMDETFORCE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DIRECTMODE_DMENABLE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DIRECTMODE.DMENABLE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DIRECTMODE_SYNCASYNC, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DIRECTMODE.SYNCASYNC'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DIRECTMODE_SYNCPREAM, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DIRECTMODE.SYNCPREAM'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DIRECTMODE_CLKWIDTH, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DIRECTMODE.CLKWIDTH'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE_LRCORRTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE.LRCORRTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE_LRCORRSCHWIN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE.LRCORRSCHWIN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE_LRBLE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE.LRBLE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE_LRTIMCORRTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE.LRTIMCORRTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE_LRBLEDSA, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE.LRBLEDSA'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE_LRDEC, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE.LRDEC'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE1_LRSS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE1.LRSS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE1_LRTIMEOUTTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE1.LRTIMEOUTTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE1_CHPWRACCUDEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE1.CHPWRACCUDEL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE1_HYSVAL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE1.HYSVAL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE1_AVGWIN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE1.AVGWIN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE1_LRSPIKETHADD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE1.LRSPIKETHADD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE1_LOGICBASEDPUGATE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE1.LOGICBASEDPUGATE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE1_LOGICBASEDLRDEMODGATE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE1.LOGICBASEDLRDEMODGATE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE2_LRCHPWRTH1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE2.LRCHPWRTH1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE2_LRCHPWRTH2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE2.LRCHPWRTH2'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE2_LRCHPWRTH3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE2.LRCHPWRTH3'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE2_LRCHPWRTH4, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE2.LRCHPWRTH4'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE3_LRCHPWRTH5, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE3.LRCHPWRTH5'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE3_LRCHPWRTH6, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE3.LRCHPWRTH6'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE3_LRCHPWRTH7, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE3.LRCHPWRTH7'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE3_LRCHPWRTH8, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE3.LRCHPWRTH8'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE4_LRCHPWRTH9, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE4.LRCHPWRTH9'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE4_LRCHPWRTH10, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE4.LRCHPWRTH10'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE4_LRCHPWRSH1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE4.LRCHPWRSH1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE4_LRCHPWRSH2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE4.LRCHPWRSH2'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE4_LRCHPWRSH3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE4.LRCHPWRSH3'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE4_LRCHPWRSH4, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE4.LRCHPWRSH4'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE5_LRCHPWRSH5, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE5.LRCHPWRSH5'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE5_LRCHPWRSH6, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE5.LRCHPWRSH6'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE5_LRCHPWRSH7, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE5.LRCHPWRSH7'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE5_LRCHPWRSH8, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE5.LRCHPWRSH8'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE5_LRCHPWRSH9, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE5.LRCHPWRSH9'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE5_LRCHPWRSH10, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE5.LRCHPWRSH10'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE5_LRCHPWRSH11, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE5.LRCHPWRSH11'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE6_LRCHPWRSPIKETH, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE6.LRCHPWRSPIKETH'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE6_LRSPIKETHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE6.LRSPIKETHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE6_LRCHPWRTH11, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE6.LRCHPWRTH11'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE6_LRCHPWRSH12, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE6.LRCHPWRSH12'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LRFRC_CI500, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LRFRC.CI500'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LRFRC_FRCACKTIMETHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LRFRC.FRCACKTIMETHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD3_SPIKETHDLO, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD3.SPIKETHDLO'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD3_UNMODTHDLO, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD3.UNMODTHDLO'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD3_FDEVMINTHDLO, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD3.FDEVMINTHDLO'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD3_FDEVMAXTHDLO, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD3.FDEVMAXTHDLO'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD4_POWABSTHDLO, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD4.POWABSTHDLO'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD4_ARRTOLERTHD0LO, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD4.ARRTOLERTHD0LO'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD4_ARRTOLERTHD1LO, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD4.ARRTOLERTHD1LO'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DSATHD4_SWTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DSATHD4.SWTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTBLETIMING_VTBLETIMINGSEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VTBLETIMING.VTBLETIMINGSEL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTBLETIMING_TIMINGDELAY, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VTBLETIMING.TIMINGDELAY'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTBLETIMING_FLENOFF, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VTBLETIMING.FLENOFF'           ))

def build_modem_regs_panther_lynx_common_part2(model, profile):
    # MSW: this is write-only... do not touch it!
    # profile.outputs.append(ModelOutput(model.vars.MODEM_CMD_PRESTOP, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CMD.PRESTOP'           ))
    # profile.outputs.append(ModelOutput(model.vars.MODEM_CMD_AFCTXLOCK, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CMD.AFCTXLOCK'           ))
    # profile.outputs.append(ModelOutput(model.vars.MODEM_CMD_AFCTXCLEAR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CMD.AFCTXCLEAR'           ))
    # profile.outputs.append(ModelOutput(model.vars.MODEM_CMD_AFCRXCLEAR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CMD.AFCRXCLEAR'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_BLEIQDSA_BLEIQDSAEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.BLEIQDSA.BLEIQDSAEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_BLEIQDSA_BLEIQDSATH, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.BLEIQDSA.BLEIQDSATH'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_BLEIQDSA_BLEIQDSAIIRCOEFPWR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.BLEIQDSA.BLEIQDSAIIRCOEFPWR'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_BLEIQDSA_BLEIQDSADIFFTH1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.BLEIQDSA.BLEIQDSADIFFTH1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_BLEIQDSAEXT1_FREQSCALEIQDSA, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.BLEIQDSAEXT1.FREQSCALEIQDSA'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_BLEIQDSAEXT1_CHPWRFIRAVGEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.BLEIQDSAEXT1.CHPWRFIRAVGEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_BLEIQDSAEXT1_CHPWRFIRAVGVAL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.BLEIQDSAEXT1.CHPWRFIRAVGVAL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_BLEIQDSAEXT1_CORRIIRAVGMULFACT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.BLEIQDSAEXT1.CORRIIRAVGMULFACT'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_BLEIQDSAEXT1_BLEIQDSAADDRBIAS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.BLEIQDSAEXT1.BLEIQDSAADDRBIAS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_BLEIQDSAEXT1_BLEIQDSATHCOMB, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.BLEIQDSAEXT1.BLEIQDSATHCOMB'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_BLEIQDSAEXT1_MAXCORRCNTIQDSA, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.BLEIQDSAEXT1.MAXCORRCNTIQDSA'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_BLEIQDSAEXT1_IIRRST, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.BLEIQDSAEXT1.IIRRST'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SYNCPROPERTIES_SYNCCORRCLR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SYNCPROPERTIES.SYNCCORRCLR'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SYNCPROPERTIES_SYNCSECPEAKTH, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SYNCPROPERTIES.SYNCSECPEAKTH'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DIGIGAINCTRL_DIGIGAINEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DIGIGAINCTRL.DIGIGAINEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DIGIGAINCTRL_DIGIGAINSEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DIGIGAINCTRL.DIGIGAINSEL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DIGIGAINCTRL_DIGIGAINDOUBLE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DIGIGAINCTRL.DIGIGAINDOUBLE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DIGIGAINCTRL_DIGIGAINHALF, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DIGIGAINCTRL.DIGIGAINHALF'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_DIGIGAINCTRL_DEC0GAIN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DIGIGAINCTRL.DEC0GAIN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PADEBUG_MANPACLKAMPCTRL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.PADEBUG.MANPACLKAMPCTRL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PADEBUG_ENMANPACLKAMPCTRL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.PADEBUG.ENMANPACLKAMPCTRL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PADEBUG_ENMANPAPOWER, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.PADEBUG.ENMANPAPOWER'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PADEBUG_ENMANPASELSLICE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.PADEBUG.ENMANPASELSLICE'           ))
    profile.outputs.append(ModelOutput(model.vars.RAC_IFADCDBG_IFADCENADC, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.IFADCDBG.IFADCENADC'           ))
    profile.outputs.append(ModelOutput(model.vars.RAC_IFADCDBG_IFADCENSIDETONE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.IFADCDBG.IFADCENSIDETONE'           ))
    profile.outputs.append(ModelOutput(model.vars.RAC_IFADCDBG_IFADCENREFBUF, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.IFADCDBG.IFADCENREFBUF'           ))
    profile.outputs.append(ModelOutput(model.vars.RAC_IFADCDBG_IFADCENCLK, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.IFADCDBG.IFADCENCLK'           ))
    profile.outputs.append(ModelOutput(model.vars.RAC_LNAMIXEN_LNAMIXENLDO, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.LNAMIXEN.LNAMIXENLDO'           ))
    # Not in Ocelot.
    if model.part_family.lower() in ["panther", "lynx", "leopard", "lion"]:
        profile.outputs.append(ModelOutput(model.vars.RAC_LNAMIXTRIM0_LNAMIXLOWCUR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.LNAMIXTRIM0.LNAMIXLOWCUR'           ))
        profile.outputs.append(ModelOutput(model.vars.RAC_PGACTRL_LNAMIXRFPKDTHRESHSEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.PGACTRL.LNAMIXRFPKDTHRESHSEL'           ))
    profile.outputs.append(ModelOutput(model.vars.RAC_PGACTRL_PGAENLATCHI, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.PGACTRL.PGAENLATCHI'           ))
    profile.outputs.append(ModelOutput(model.vars.RAC_PGACTRL_PGAENLATCHQ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.PGACTRL.PGAENLATCHQ'           ))
    profile.outputs.append(ModelOutput(model.vars.RAC_PGACTRL_PGATHRPKDHISEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.PGACTRL.PGATHRPKDHISEL'           ))
    profile.outputs.append(ModelOutput(model.vars.RAC_PGACTRL_PGATHRPKDLOSEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.PGACTRL.PGATHRPKDLOSEL'           ))
    profile.outputs.append(ModelOutput(model.vars.RAC_VCOCTRL_VCOAMPLITUDE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.VCOCTRL.VCOAMPLITUDE'           ))
    profile.outputs.append(ModelOutput(model.vars.RAC_VCOCTRL_VCODETAMPLITUDE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.VCOCTRL.VCODETAMPLITUDE'           ))
    # profile.outputs.append(ModelOutput(model.vars.RFCRC_CTRL_BITREVERSE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RFCRC.CTRL.BITREVERSE'           ))
    # profile.outputs.append(ModelOutput(model.vars.RFCRC_CTRL_BITSPERWORD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RFCRC.CTRL.BITSPERWORD'           ))
    # profile.outputs.append(ModelOutput(model.vars.RFCRC_CTRL_BYTEREVERSE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RFCRC.CTRL.BYTEREVERSE'           ))
    # profile.outputs.append(ModelOutput(model.vars.RFCRC_CTRL_CRCWIDTH, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RFCRC.CTRL.CRCWIDTH'           ))
    # profile.outputs.append(ModelOutput(model.vars.RFCRC_CTRL_INPUTBITORDER, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RFCRC.CTRL.INPUTBITORDER'           ))
    profile.outputs.append(ModelOutput(model.vars.RFCRC_CTRL_INPUTINV, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RFCRC.CTRL.INPUTINV'           ))
    # profile.outputs.append(ModelOutput(model.vars.RFCRC_CTRL_OUTPUTINV, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RFCRC.CTRL.OUTPUTINV'           ))
    # profile.outputs.append(ModelOutput(model.vars.RFCRC_CTRL_PADCRCINPUT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RFCRC.CTRL.PADCRCINPUT'           ))
    # profile.outputs.append(ModelOutput(model.vars.RFCRC_INIT_INIT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RFCRC.INIT.INIT'           ))
    # profile.outputs.append(ModelOutput(model.vars.RFCRC_POLY_POLY, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RFCRC.POLY.POLY'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_CHSP_CHSP, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.CHSP.CHSP'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_DIVCTRL_LODIVFREQCTRL, '',   ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.DIVCTRL.LODIVFREQCTRL'     ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_FREQ_FREQ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.FREQ.FREQ'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_CTRL_LOCKTHRESHOLD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.CTRL.LOCKTHRESHOLD'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_IFFREQ_IFFREQ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.IFFREQ.IFFREQ'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_IFFREQ_LOSIDE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.IFFREQ.LOSIDE'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LOCNTCTRL_ENABLE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LOCNTCTRL.ENABLE'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LOCNTCTRL_NUMCYCLE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='YNTH.LOCNTCTRL.NUMCYCLE'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL1CAL_OP1BWCAL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL1CAL.OP1BWCAL'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL1CAL_OP1COMPCAL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL1CAL.OP1COMPCAL'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL1CAL_RZVALCAL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL1CAL.RZVALCAL'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL1CAL_RPVALCAL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL1CAL.RPVALCAL'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL1CAL_RFBVALCAL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL1CAL.RFBVALCAL'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL1RX_OP1BWRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL1RX.OP1BWRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL1RX_OP1COMPRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL1RX.OP1COMPRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL1RX_RZVALRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL1RX.RZVALRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL1RX_RPVALRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL1RX.RPVALRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL1RX_RFBVALRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL1RX.RFBVALRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2RX_LPFSWENRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2RX.LPFSWENRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2RX_LPFINCAPRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2RX.LPFINCAPRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2RX_LPFGNDSWENRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2RX.LPFGNDSWENRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2RX_CASELRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2RX.CASELRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2RX_CAVALRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2RX.CAVALRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2RX_CFBSELRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2RX.CFBSELRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2RX_CZSELRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2RX.CZSELRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2RX_CZVALRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2RX.CZVALRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2RX_MODESELRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2RX.MODESELRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2RX_VCMLVLRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2RX.VCMLVLRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL1TX_OP1BWTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL1TX.OP1BWTX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL1TX_OP1COMPTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.IFFREQ.IFFREQ'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL1TX_RZVALTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL1TX.OP1COMPTX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL1TX_RPVALTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL1TX.RPVALTX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL1TX_RFBVALTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL1TX.RFBVALTX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2TX_LPFSWENTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2TX.LPFSWENTX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2TX_LPFINCAPTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2TX.LPFINCAPTX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2TX_LPFGNDSWENTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2TX.LPFGNDSWENTX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2TX_CASELTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2TX.CASELTX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2TX_CAVALTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2TX.CAVALTX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2TX_CFBSELTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2TX.CFBSELTX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2TX_CZSELTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2TX.CZSELTX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2TX_CZVALTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2TX.CZVALTX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2TX_MODESELTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2TX.MODESELTX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_LPFCTRL2TX_VCMLVLTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.LPFCTRL2TX.VCMLVLTX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_DSMCTRLRX_DEMMODERX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.DSMCTRLRX.DEMMODERX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_DSMCTRLRX_DITHERDACRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.DSMCTRLRX.DITHERDACRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_DSMCTRLRX_DITHERDSMINPUTRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.DSMCTRLRX.DITHERDSMINPUTRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_DSMCTRLRX_DITHERDSMOUTPUTRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.DSMCTRLRX.DITHERDSMOUTPUTRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_DSMCTRLRX_DSMMODERX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.DSMCTRLRX.DSMMODERX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_DSMCTRLRX_LSBFORCERX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.DSMCTRLRX.LSBFORCERX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_DSMCTRLRX_MASHORDERRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.DSMCTRLRX.MASHORDERRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_DSMCTRLRX_REQORDERRX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.DSMCTRLRX.REQORDERRX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_DSMCTRLTX_DEMMODETX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.DSMCTRLTX.DEMMODETX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_DSMCTRLTX_DITHERDACTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.DSMCTRLTX.DITHERDACTX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_DSMCTRLTX_DITHERDSMINPUTTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.DSMCTRLTX.DITHERDSMINPUTTX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_DSMCTRLTX_DITHERDSMOUTPUTTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.DSMCTRLTX.DITHERDSMOUTPUTTX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_DSMCTRLTX_DSMMODETX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.DSMCTRLTX.DSMMODETX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_DSMCTRLTX_LSBFORCETX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.DSMCTRLTX.LSBFORCETX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_DSMCTRLTX_MASHORDERTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.DSMCTRLTX.MASHORDERTX'           ))
    profile.outputs.append(ModelOutput(model.vars.SYNTH_DSMCTRLTX_REQORDERTX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SYNTH.DSMCTRLTX.REQORDERTX'           ))
    # Not in Ocelot.
    if model.part_family.lower() in ["panther", "lynx", "leopard", "lion"]:
        profile.outputs.append(ModelOutput(model.vars.RAC_SYNTHCTRL_MMDPOWERBALANCEDISABLE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.SYNTHCTRL.MMDPOWERBALANCEDISABLE'           ))
    profile.outputs.append(ModelOutput(model.vars.RAC_SYNTHREGCTRL_MMDLDOVREFTRIM, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.SYNTHREGCTRL.MMDLDOVREFTRIM'           ))

def build_modem_regs_panther_only(model, profile):
    profile.outputs.append(ModelOutput(model.vars.AGC_STATUS0_ADCINDEX, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.STATUS0.ADCINDEX'))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL0_AGCCLKUNDIVREQ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.CTRL0.AGCCLKUNDIVREQ'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_DSSSCTD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.DSSSCTD'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_BBSS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.BBSS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_POEPER, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.POEPER'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_FOEPREAVG, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.FOEPREAVG'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_LINCORR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.LINCORR'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_PRSDEBUG, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.PRSDEBUG'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_XINGDEBUG, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.XINGDEBUG'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_TDREW, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.TDREW'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_PREBASES, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.PREBASES'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_PSTIMABORT0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.PSTIMABORT0'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_PSTIMABORT1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.PSTIMABORT1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_PSTIMABORT2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.PSTIMABORT2'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_PSTIMABORT3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.PSTIMABORT3'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_ARW, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.ARW'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_TIMTHRESHGAIN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.TIMTHRESHGAIN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_CPLXCORREN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.CPLXCORREN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_DSSS3SYMBOLSYNCEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.DSSS3SYMBOLSYNCEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CF_RESYNCRESETTIMING, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CF.RESYNCRESETTIMING'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CF_RESYNCBYPASS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CF.RESYNCBYPASS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING4_COEFF20, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING4.COEFF20'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING4_COEFF21, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING4.COEFF21'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING5_COEFF24, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING5.COEFF24'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING5_COEFF25, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING5.COEFF25'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING5_COEFF26, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING5.COEFF26'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING5_COEFF27, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING5.COEFF27'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING5_COEFF28, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING5.COEFF28'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING5_COEFF29, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING5.COEFF29'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING6_COEFF30, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING6.COEFF30'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING6_COEFF31, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING6.COEFF31'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING6_COEFF32, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING6.COEFF32'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING6_COEFF33, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING6.COEFF33'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING6_COEFF34, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING6.COEFF34'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING6_COEFF35, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING6.COEFF35'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING6_COEFF36, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING6.COEFF36'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING6_COEFF37, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING6.COEFF37'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING6_COEFF38, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING6.COEFF38'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING6_COEFF39, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING6.COEFF39'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_INTAFC_FOEPREAVG0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.INTAFC.FOEPREAVG0'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_INTAFC_FOEPREAVG1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.INTAFC.FOEPREAVG1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_INTAFC_FOEPREAVG2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.INTAFC.FOEPREAVG2'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_INTAFC_FOEPREAVG3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.INTAFC.FOEPREAVG3'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_INTAFC_FOEPREAVG4, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.INTAFC.FOEPREAVG4'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_INTAFC_FOEPREAVG5, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.INTAFC.FOEPREAVG5'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_INTAFC_FOEPREAVG6, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.INTAFC.FOEPREAVG6'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_INTAFC_FOEPREAVG7, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.INTAFC.FOEPREAVG7'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE_LRCORRTHDDYNEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE.LRCORRTHDDYNEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH0_COHDYNAMICBBSSEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH0.COHDYNAMICBBSSEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH0_COHDYNAMICSYNCTHRESH, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH0.COHDYNAMICSYNCTHRESH'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH0_COHDYNAMICPRETHRESH, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH0.COHDYNAMICPRETHRESH'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH0_COHDYNAMICPRETHRESHSEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH0.COHDYNAMICPRETHRESHSEL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH0_COHCHPWRTH0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH0.COHCHPWRTH0'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH0_COHCHPWRTH1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH0.COHCHPWRTH1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH0_COHCHPWRTH2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH0.COHCHPWRTH2'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH1_SYNCTHRESH0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH1.SYNCTHRESH0'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH1_SYNCTHRESH1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH1.SYNCTHRESH1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH1_SYNCTHRESH2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH1.SYNCTHRESH2'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH1_SYNCTHRESH3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH1.SYNCTHRESH3'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH2_SYNCTHRESHDELTA0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH2.SYNCTHRESHDELTA0'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH2_SYNCTHRESHDELTA1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH2.SYNCTHRESHDELTA1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH2_SYNCTHRESHDELTA2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH2.SYNCTHRESHDELTA2'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH2_SYNCTHRESHDELTA3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH2.SYNCTHRESHDELTA3'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH2_DSAPEAKCHPWRTH, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH2.DSAPEAKCHPWRTH'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH2_FIXEDCDTHFORIIR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH2.FIXEDCDTHFORIIR'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_COHDSAEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.COHDSAEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_COHDSAADDWNDSIZE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.COHDSAADDWNDSIZE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_CDSS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.CDSS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_DSAPEAKCHKEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.DSAPEAKCHKEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_DSAPEAKINDLEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.DSAPEAKINDLEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_DSAPEAKCHPWREN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.DSAPEAKCHPWREN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_LOGICBASEDCOHDEMODGATE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.LOGICBASEDCOHDEMODGATE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_DYNIIRCOEFOPTION, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.DYNIIRCOEFOPTION'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_ONEPEAKQUALEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.ONEPEAKQUALEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_PEAKCHKTIMOUT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.PEAKCHKTIMOUT'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_COHDSADETDIS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.COHDSADETDIS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PADEBUG_MANPAAMPCTRL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.PADEBUG.MANPAAMPCTRL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PADEBUG_ENMANPAAMPCTRL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.PADEBUG.ENMANPAAMPCTRL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PADEBUG_ENMANPATRIMPASLICE0DBM, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.PADEBUG.ENMANPATRIMPASLICE0DBM'           ))

    profile.outputs.append(ModelOutput(model.vars.RAC_IFADCTRIM_IFADCOTAST1CURRENT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.IFADCTRIM.IFADCOTAST1CURRENT'           ))
    profile.outputs.append(ModelOutput(model.vars.RAC_IFADCTRIM_IFADCOTAST2CURRENT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.IFADCTRIM.IFADCOTAST2CURRENT'           ))
