from pycalcmodel.core.output import ModelOutput, ModelOutputType
from pyradioconfig.calculator_model_framework.interfaces.itarget import ITarget

# Regex fields to match registers used for OFDM in concurrent mode
# To be used in concurrent_phy decorators
concurrent_ofdm_regfield_list = [
    '(?!AGC_ANTDIV_GAINMODE)(AGC_.*)',  # (?!REG1)(REG2) matches REG2 and not REG1
    'FEFILT1_*',
    'SUNOFDM_*',
    'TXFRONT_*',
    'RAC_PGACTRL_PGABWMODE']

def build_modem_regs_sol_only(model, profile):

    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_INTOSR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.INTOSR'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_DEC2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.DEC2'           ))
        
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CF_DEC0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CF.DEC0'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CF_DEC1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CF.DEC1'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DIGIGAINCTRL_DEC1GAIN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DIGIGAINCTRL.DEC1GAIN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DIGIGAINCTRL_BBSS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DIGIGAINCTRL.BBSS'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CF_ADCBITORDERI, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CF.ADCBITORDERI'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CF_ADCBITORDERQ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CF.ADCBITORDERQ'           ))    
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_SRC_SRCRATIO, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.SRC.SRCRATIO'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_SRC_SRCENABLE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.SRC.SRCENABLE'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_SRC_SRCSRD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.SRC.SRCSRD'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_SRC_UPGAPS, '', ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.SRC.UPGAPS'))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DIGIGAINCTRL_DIGIGAINEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DIGIGAINCTRL.DIGIGAINEN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DIGIGAINCTRL_DIGIGAIN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DIGIGAINCTRL.DIGIGAIN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DIGIGAINCTRL_DEC0GAIN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DIGIGAINCTRL.DEC0GAIN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE00_SET0COEFF0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE00.SET0COEFF0'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE00_SET0COEFF1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE00.SET0COEFF1'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE00_SET0COEFF2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE00.SET0COEFF2'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE01_SET0COEFF3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE01.SET0COEFF3'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE01_SET0COEFF4, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE01.SET0COEFF4'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE02_SET0COEFF5, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE02.SET0COEFF5'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE02_SET0COEFF6, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE02.SET0COEFF6'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE03_SET0COEFF7, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE03.SET0COEFF7'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE03_SET0COEFF8, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE03.SET0COEFF8'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE04_SET0COEFF9, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE04.SET0COEFF9'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE04_SET0COEFF10, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE04.SET0COEFF10'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE05_SET0COEFF11, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE05.SET0COEFF11'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE05_SET0COEFF12, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE05.SET0COEFF12'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE06_SET0COEFF13, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE06.SET0COEFF13'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE06_SET0COEFF14, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE06.SET0COEFF14'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE10_SET1COEFF0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE10.SET1COEFF0'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE10_SET1COEFF1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE10.SET1COEFF1'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE10_SET1COEFF2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE10.SET1COEFF2'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE11_SET1COEFF3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE11.SET1COEFF3'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE11_SET1COEFF4, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE11.SET1COEFF4'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE12_SET1COEFF5, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE12.SET1COEFF5'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE12_SET1COEFF6, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE12.SET1COEFF6'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE13_SET1COEFF7, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE13.SET1COEFF7'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE13_SET1COEFF8, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE13.SET1COEFF8'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE14_SET1COEFF9, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE14.SET1COEFF9'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE14_SET1COEFF10, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE14.SET1COEFF10'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE15_SET1COEFF11, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE15.SET1COEFF11'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE15_SET1COEFF12, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE15.SET1COEFF12'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE16_SET1COEFF13, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE16.SET1COEFF13'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCOE16_SET1COEFF14, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCOE16.SET1COEFF14'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCTRL_FWSWCOEFFEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCTRL.FWSWCOEFFEN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCTRL_FWSELCOEFF, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCTRL.FWSELCOEFF'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCTRL_SWCOEFFEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.CHFCTRL.SWCOEFFEN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_CHFCTRL_CHFLATENCY, '', ModelOutputType.SVD_REG_FIELD,readable_name='FEFILT0.CHFCTRL.CHFLATENCY'))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DIGMIXCTRL_DIGMIXFREQ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DIGMIXCTRL.DIGMIXFREQ'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DIGMIXCTRL_MIXERCONJ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DIGMIXCTRL.MIXERCONJ'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DIGMIXCTRL_DIGMIXFBENABLE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DIGMIXCTRL.DIGMIXFBENABLE'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DIGMIXCTRL_DIGIQSWAPEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DIGMIXCTRL.DIGIQSWAPEN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DCCOMP_DCGAINGEAREN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DCCOMP.DCGAINGEAREN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DCCOMP_DCGAINGEAR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DCCOMP.DCGAINGEAR'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DCCOMP_DCGAINGEARSMPS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DCCOMP.DCGAINGEARSMPS'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DCCOMP_DCESTIEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DCCOMP.DCESTIEN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DCCOMP_DCCOMPEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DCCOMP.DCCOMPEN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DCCOMP_DCRSTEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DCCOMP.DCRSTEN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DCCOMP_DCCOMPFREEZE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DCCOMP.DCCOMPFREEZE'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DCCOMP_DCCOMPGEAR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DCCOMP.DCCOMPGEAR'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DCCOMP_DCLIMIT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DCCOMP.DCLIMIT'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DCCOMPFILTINIT_DCCOMPINITVALI, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DCCOMPFILTINIT.DCCOMPINITVALI'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DCCOMPFILTINIT_DCCOMPINITVALQ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DCCOMPFILTINIT.DCCOMPINITVALQ'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT0_DCCOMPFILTINIT_DCCOMPINIT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT0.DCCOMPFILTINIT.DCCOMPINIT'           ))

    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CF_DEC0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CF.DEC0'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CF_DEC1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CF.DEC1'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DIGIGAINCTRL_DEC1GAIN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DIGIGAINCTRL.DEC1GAIN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DIGIGAINCTRL_BBSS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DIGIGAINCTRL.BBSS'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CF_ADCBITORDERI, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CF.ADCBITORDERI'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CF_ADCBITORDERQ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CF.ADCBITORDERQ'           ))    
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_SRC_SRCRATIO, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.SRC.SRCRATIO'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_SRC_SRCENABLE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.SRC.SRCENABLE'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_SRC_SRCSRD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.SRC.SRCSRD'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_SRC_UPGAPS, '', ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.SRC.UPGAPS'))

    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DIGIGAINCTRL_DIGIGAINEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DIGIGAINCTRL.DIGIGAINEN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DIGIGAINCTRL_DIGIGAIN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DIGIGAINCTRL.DIGIGAIN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DIGIGAINCTRL_DEC0GAIN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DIGIGAINCTRL.DEC0GAIN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE00_SET0COEFF0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE00.SET0COEFF0'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE00_SET0COEFF1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE00.SET0COEFF1'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE00_SET0COEFF2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE00.SET0COEFF2'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE01_SET0COEFF3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE01.SET0COEFF3'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE01_SET0COEFF4, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE01.SET0COEFF4'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE02_SET0COEFF5, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE02.SET0COEFF5'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE02_SET0COEFF6, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE02.SET0COEFF6'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE03_SET0COEFF7, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE03.SET0COEFF7'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE03_SET0COEFF8, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE03.SET0COEFF8'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE04_SET0COEFF9, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE04.SET0COEFF9'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE04_SET0COEFF10, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE04.SET0COEFF10'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE05_SET0COEFF11, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE05.SET0COEFF11'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE05_SET0COEFF12, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE05.SET0COEFF12'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE06_SET0COEFF13, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE06.SET0COEFF13'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE06_SET0COEFF14, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE06.SET0COEFF14'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE10_SET1COEFF0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE10.SET1COEFF0'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE10_SET1COEFF1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE10.SET1COEFF1'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE10_SET1COEFF2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE10.SET1COEFF2'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE11_SET1COEFF3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE11.SET1COEFF3'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE11_SET1COEFF4, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE11.SET1COEFF4'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE12_SET1COEFF5, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE12.SET1COEFF5'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE12_SET1COEFF6, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE12.SET1COEFF6'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE13_SET1COEFF7, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE13.SET1COEFF7'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE13_SET1COEFF8, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE13.SET1COEFF8'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE14_SET1COEFF9, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE14.SET1COEFF9'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE14_SET1COEFF10, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE14.SET1COEFF10'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE15_SET1COEFF11, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE15.SET1COEFF11'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE15_SET1COEFF12, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE15.SET1COEFF12'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE16_SET1COEFF13, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE16.SET1COEFF13'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCOE16_SET1COEFF14, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCOE16.SET1COEFF14'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCTRL_FWSWCOEFFEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCTRL.FWSWCOEFFEN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCTRL_FWSELCOEFF, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCTRL.FWSELCOEFF'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCTRL_SWCOEFFEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.CHFCTRL.SWCOEFFEN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_CHFCTRL_CHFLATENCY, '', ModelOutputType.SVD_REG_FIELD,readable_name='FEFILT1.CHFCTRL.CHFLATENCY'))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DIGMIXCTRL_DIGMIXFREQ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DIGMIXCTRL.DIGMIXFREQ'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DIGMIXCTRL_MIXERCONJ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DIGMIXCTRL.MIXERCONJ'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DIGMIXCTRL_DIGMIXFBENABLE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DIGMIXCTRL.DIGMIXFBENABLE'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DIGMIXCTRL_DIGIQSWAPEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DIGMIXCTRL.DIGIQSWAPEN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DCCOMP_DCGAINGEAREN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DCCOMP.DCGAINGEAREN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DCCOMP_DCGAINGEAR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DCCOMP.DCGAINGEAR'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DCCOMP_DCGAINGEARSMPS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DCCOMP.DCGAINGEARSMPS'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DCCOMP_DCESTIEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DCCOMP.DCESTIEN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DCCOMP_DCCOMPEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DCCOMP.DCCOMPEN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DCCOMP_DCRSTEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DCCOMP.DCRSTEN'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DCCOMP_DCCOMPFREEZE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DCCOMP.DCCOMPFREEZE'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DCCOMP_DCCOMPGEAR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DCCOMP.DCCOMPGEAR'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DCCOMP_DCLIMIT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DCCOMP.DCLIMIT'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DCCOMPFILTINIT_DCCOMPINITVALI, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DCCOMPFILTINIT.DCCOMPINITVALI'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DCCOMPFILTINIT_DCCOMPINITVALQ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DCCOMPFILTINIT.DCCOMPINITVALQ'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_DCCOMPFILTINIT_DCCOMPINIT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.DCCOMPFILTINIT.DCCOMPINIT'           ))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_RSSIFILT_RSSIFILTEN, '', ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.RSSIFILT.RSSIFILTEN'))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_RSSIFILT_RSSIFILTCOEF0, '', ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.RSSIFILT.RSSIFILTCOEFF0'))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_RSSIFILT_RSSIFILTCOEF1, '', ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.RSSIFILT.RSSIFILTCOEFF1'))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_RSSIFILT_RSSIFILTCOEF2, '', ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.RSSIFILT.RSSIFILTCOEFF2'))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_RSSIFILT_RSSIFILTCOEF3, '', ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.RSSIFILT.RSSIFILTCOEFF3'))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_RSSIFILT_RSSIFILTCOEF4, '', ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.RSSIFILT.RSSIFILTCOEFF4'))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_RSSIFILT_RSSIFILTCOEF5, '', ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.RSSIFILT.RSSIFILTCOEFF5'))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_RSSIFILT_RSSIFILTCOEF6, '', ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.RSSIFILT.RSSIFILTCOEFF6'))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_RSSIFILT_RSSIFILTCOEF7, '', ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.RSSIFILT.RSSIFILTCOEFF7'))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_RSSIFILT_RSSIFILTGAIN, '', ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.RSSIFILT.RSSIFILTGAIN'))
    profile.outputs.append(ModelOutput(model.vars.FEFILT1_RSSIFILT_RSSIFILTDEC, '', ModelOutputType.SVD_REG_FIELD, readable_name='FEFILT1.RSSIFILT.RSSIFILTDEC'))

    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT1COEF01_COEFF0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT1COEF01.COEFF0'           ))
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT1COEF01_COEFF1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT1COEF01.COEFF1'           ))                          
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT1COEF23_COEFF2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT1COEF23.COEFF2'           ))                          
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT1COEF23_COEFF3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT1COEF23.COEFF3'           ))                          
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT1COEF45_COEFF4, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT1COEF45.COEFF4'           ))                          
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT1COEF45_COEFF5, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT1COEF45.COEFF5'           ))                          
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT1COEF67_COEFF6, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT1COEF67.COEFF6'           ))                          
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT1COEF67_COEFF7, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT1COEF67.COEFF7'           ))                          
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT1COEF89_COEFF8, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT1COEF89.COEFF8'           ))                          
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT1COEF89_COEFF9, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT1COEF89.COEFF9'           ))                          
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT1COEF1011_COEFF10, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT1COEF1011.COEFF10'           ))                       
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT1COEF1011_COEFF11, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT1COEF1011.COEFF11'           ))                       
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT1COEF1213_COEFF12, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT1COEF1213.COEFF12'           ))                       
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT1COEF1213_COEFF13, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT1COEF1213.COEFF13'           ))                       
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT1COEF1415_COEFF14, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT1COEF1415.COEFF14'           ))                       
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT1COEF1415_COEFF15, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT1COEF1415.COEFF15'           ))                       
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT1CFG_RATIO, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT1CFG.RATIO'           ))                              
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT1CFG_GAINSHIFT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT1CFG.GAINSHIFT'           ))                          
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT2CFG_RATIO, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT2CFG.RATIO'           ))                              
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_INT2CFG_GAINSHIFT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.INT2CFG.GAINSHIFT'           ))                          
    profile.outputs.append(ModelOutput(model.vars.TXFRONT_SRCCFG_RATIO, '',         ModelOutputType.SVD_REG_FIELD, readable_name='TXFRONT.SRCCFG.RATIO'           ))                               
    profile.outputs.append(ModelOutput(model.vars.RAC_TXOFDM_TXENBBREG, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.TXOFDM.TXENBBREG'           ))                               
    profile.outputs.append(ModelOutput(model.vars.RAC_TXOFDM_TXENMIX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.TXOFDM.TXENMIX'           ))
    profile.outputs.append(ModelOutput(model.vars.RAC_TXMIX_TXSELMIXCTUNE, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.TXMIX.TXSELMIXCTUNE'))
    profile.outputs.append(ModelOutput(model.vars.RAC_TXMIX_TXSELMIXGMSLICEI, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.TXMIX.TXSELMIXGMSLICEI'))
    profile.outputs.append(ModelOutput(model.vars.RAC_TXMIX_TXSELMIXGMSLICEQ, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.TXMIX.TXSELMIXGMSLICEQ'))
    profile.outputs.append(ModelOutput(model.vars.RAC_TXMIX_TXSELMIXRLOAD, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.TXMIX.TXSELMIXRLOAD'))
    profile.outputs.append(ModelOutput(model.vars.RAC_TXMIX_TXSELMIXBAND, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.TXMIX.TXSELMIXBAND'))
    profile.outputs.append(ModelOutput(model.vars.RAC_TXMIX_TXMIXCAPPULLDOWN, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.TXMIX.TXMIXCAPPULLDOWN'))
    profile.outputs.append(ModelOutput(model.vars.RAC_SOFTMCTRL_TXMODSEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.SOFTMCTRL.TXMODSEL'           ))
    profile.outputs.append(ModelOutput(model.vars.RAC_SOFTMCTRL_CLKEN, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.SOFTMCTRL.CLKEN'))
    profile.outputs.append(ModelOutput(model.vars.RAC_RX_FEFILTOUTPUTSEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.RX.FEFILTOUTPUTSEL'           ))
    profile.outputs.append(ModelOutput(model.vars.RAC_PATRIM6_TXTRIMBBREGFB, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.PATRIM6.TXTRIMBBREGFB'))
    profile.outputs.append(ModelOutput(model.vars.RAC_PATRIM6_TXTRIMFILGAIN, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.PATRIM6.TXTRIMFILGAIN'))
    profile.outputs.append(ModelOutput(model.vars.RAC_PATRIM6_TXTRIMFILRES, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.PATRIM6.TXTRIMFILRES'))
    profile.outputs.append(ModelOutput(model.vars.AGC_SETTLINGINDCTRL_EN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.SETTLINGINDCTRL.EN'           )) 

    profile.outputs.append(ModelOutput(model.vars.MODEM_PHDMODANTDIV_ANTDECRSTBYP, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.PHDMODANTDIV.ANTDECRSTBYP'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHDMODANTDIV_RECHKCORREN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.PHDMODANTDIV.RECHKCORREN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHDMODANTDIV_SKIPTHDSEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.PHDMODANTDIV.SKIPTHDSEL'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_SETTLINGINDCTRL_POSTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.SETTLINGINDCTRL.POSTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_SETTLINGINDCTRL_NEGTHD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.SETTLINGINDCTRL.NEGTHD'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_SETTLINGINDPER_SETTLEDPERIOD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.SETTLINGINDPER.SETTLEDPERIOD'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_SETTLINGINDPER_DELAYPERIOD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.SETTLINGINDPER.DELAYPERIOD'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_COLLDETCTRL_MATAP, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.COLLDETCTRL.MATAP'))
    profile.outputs.append(ModelOutput(model.vars.AGC_COLLDETCTRL_MACOMPENSEL, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.COLLDETCTRL.MACOMPENSEL'))
    profile.outputs.append(ModelOutput(model.vars.AGC_COLLDETCTRL_OVRTHDSEL, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.COLLDETCTRL.OVRTHDSEL'))
    profile.outputs.append(ModelOutput(model.vars.AGC_COLLDETCTRL_RSSIINSEL, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.COLLDETCTRL.RSSIINSEL'))
    profile.outputs.append(ModelOutput(model.vars.AGC_COLLDETCTRL_INPUTSEL, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.COLLDETCTRL.INPUTSEL'))
    profile.outputs.append(ModelOutput(model.vars.AGC_COLLDETTHD_MATHRESHOLD, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.COLLDETTHD.MATHRESHOLD'))
    profile.outputs.append(ModelOutput(model.vars.AGC_COLLDETTHD_OVRTHRESHOLD, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.COLLDETTHD.OVRTHRESHOLD'))

    # RFFPLL Configuration
    profile.outputs.append(ModelOutput(model.vars.RFFPLL0_RFFPLLCTRL1_DIVXADCSEL, '', ModelOutputType.SVD_REG_FIELD, readable_name='RFFPLL0.RFFPLLCTRL1.DIVXADCSEL'))
    if model.target == ITarget.SIM_str:
        #These fields are owned by RAIL, but are written by the calculator for RTL sim and wired FPGA as RAIL is not running
        profile.outputs.append(ModelOutput(model.vars.RFFPLL0_RFFPLLCTRL1_DIVXDACSEL, '', ModelOutputType.SVD_REG_FIELD, readable_name='RFFPLL0.RFFPLLCTRL1.DIVXDACSEL'))
        profile.outputs.append(ModelOutput(model.vars.RFFPLL0_RFFPLLCTRL1_DIVX, '', ModelOutputType.SVD_REG_FIELD, readable_name='RFFPLL0.RFFPLLCTRL1.DIVX'))
        profile.outputs.append(ModelOutput(model.vars.RFFPLL0_RFFPLLCTRL1_DIVY, '', ModelOutputType.SVD_REG_FIELD, readable_name='RFFPLL0.RFFPLLCTRL1.DIVY'))
        profile.outputs.append(ModelOutput(model.vars.RFFPLL0_RFFPLLCTRL1_DIVN, '', ModelOutputType.SVD_REG_FIELD, readable_name='RFFPLL0.RFFPLLCTRL1.DIVN'))
        profile.outputs.append(ModelOutput(model.vars.RFFPLL0_RFFPLLCTRL1_DIVXMODEMSEL, '', ModelOutputType.SVD_REG_FIELD, readable_name='RFFPLL0.RFFPLLCTRL1.DIVXMODEMSEL'))

    # SEQ Peripheral - MODEMINFO register
    profile.outputs.append(ModelOutput(model.vars.SEQ_MODEMINFO_LEGACY_EN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SEQ.MODEMINFO.LEGACY_EN'           ))
    profile.outputs.append(ModelOutput(model.vars.SEQ_MODEMINFO_DSA_VITERBI_EN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SEQ.MODEMINFO.DSA_VITERBI_EN'           ))
    profile.outputs.append(ModelOutput(model.vars.SEQ_MODEMINFO_TRECS_EN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SEQ.MODEMINFO.TRECS_EN'           ))
    profile.outputs.append(ModelOutput(model.vars.SEQ_MODEMINFO_BCR_EN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SEQ.MODEMINFO.BCR_EN'           ))
    profile.outputs.append(ModelOutput(model.vars.SEQ_MODEMINFO_COHERENT_EN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SEQ.MODEMINFO.COHERENT_EN'           ))
    profile.outputs.append(ModelOutput(model.vars.SEQ_MODEMINFO_HARDMODEM_SPARE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SEQ.MODEMINFO.HARDMODEM_SPARE'           ))
    profile.outputs.append(ModelOutput(model.vars.SEQ_MODEMINFO_SOFTMODEM_DEMOD_EN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SEQ.MODEMINFO.SOFTMODEM_DEMOD_EN'           ))
    profile.outputs.append(ModelOutput(model.vars.SEQ_MODEMINFO_SOFTMODEM_MOD_EN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SEQ.MODEMINFO.SOFTMODEM_MOD_EN'           ))
    profile.outputs.append(ModelOutput(model.vars.SEQ_MODEMINFO_SOFTMODEM_SPARE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='SEQ.MODEMINFO.SOFTMODEM_SPARE'           ))

    ### Defining SoftModem Regs

    #CW Peripheral
    profile.outputs.append(ModelOutput(model.vars.CW_VREGS_MAJORVERSION, '', ModelOutputType.SVD_REG_FIELD, readable_name='CW.VREGS.MAJORVERSION'))
    profile.outputs.append(ModelOutput(model.vars.CW_VREGS_MINORVERSION, '', ModelOutputType.SVD_REG_FIELD, readable_name='CW.VREGS.MINORVERSION'))
    profile.outputs.append(ModelOutput(model.vars.CW_CFG1_MODULATION, '', ModelOutputType.SVD_REG_FIELD, readable_name='CW.CFG1.MODULATION'))
    profile.outputs.append(ModelOutput(model.vars.CW_CFG1_NFFTLOG2, '', ModelOutputType.SVD_REG_FIELD, readable_name='CW.CFG1.NFFTLOG2'))
    profile.outputs.append(ModelOutput(model.vars.CW_CFG1_DUALPATH, '', ModelOutputType.SVD_REG_FIELD, readable_name='CW.CFG1.DUALPATH'))
    profile.outputs.append(ModelOutput(model.vars.CW_CFG1_FFTANALYZE, '', ModelOutputType.SVD_REG_FIELD, readable_name='CW.CFG1.FFTANALYZE'))
    profile.outputs.append(ModelOutput(model.vars.CW_CFG1_SIGTYPE, '', ModelOutputType.SVD_REG_FIELD, readable_name='CW.CFG1.SIGTYPE'))
    profile.outputs.append(ModelOutput(model.vars.CW_CFG2_FREQ, '', ModelOutputType.SVD_REG_FIELD, readable_name='CW.CFG2.FREQ'))
    profile.outputs.append(ModelOutput(model.vars.CW_CFG2_AMP, '', ModelOutputType.SVD_REG_FIELD, readable_name='CW.CFG2.AMP'))
    profile.outputs.append(ModelOutput(model.vars.CW_CFG3_XTALFREQ, '', ModelOutputType.SVD_REG_FIELD, readable_name='CW.CFG3.XTALFREQ'))

    #SUNOFDM Peripheral
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_VREGS_MAJORVERSION, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.VREGS.MAJORVERSION'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_VREGS_MINORVERSION, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.VREGS.MINORVERSION'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_CFG1_MODULATION, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.CFG1.MODULATION'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_CFG1_OFDMOPTION, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.CFG1.OFDMOPTION'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_CFG1_INTERLEAVING, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.CFG1.INTERLEAVING'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_CFG1_MACFCSTYPE, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.CFG1.MACFCSTYPE'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_CFG1_XTALFREQ, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.CFG1.XTALFREQ'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_CFG2_NBSTF, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.CFG2.NBSTF'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_RXCFG1_EXTFREQUPPER, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.RXCFG1.EXTFREQUPPER'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_RXCFG1_EXTFREQLOWER, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.RXCFG1.EXTFREQLOWER'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_RXCFG1_DUALPHR, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.RXCFG1.DUALPHR'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_RXCFG1_COARSEFREQ, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.RXCFG1.COARSEFREQ'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_RXCFG1_EXTCOARSEFREQ, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.RXCFG1.EXTCOARSEFREQ'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_RXCFG1_GIRECOMB, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.RXCFG1.GIRECOMB'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_RXCFG1_PSDU_CE_MODE, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.RXCFG1.PSDU_CE_MODE'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_RXCFG1_PHR_CE_MODE, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.RXCFG1.PHR_CE_MODE'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_RXCFG1_FRCMAXSPEED, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.RXCFG1.FRCMAXSPEED'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_RXCFG2_RSSISETPOINT, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.RXCFG2.RSSISETPOINT'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_COLLDET_COLLDETTHR, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.COLLDET.COLLDETTHR'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_AFC_AFCMIXERRATIOGAIN, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.AFC.AFCMIXERRATIOGAIN'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_AFC_AFCMIXERRATIOATT, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.AFC.AFCMIXERRATIOATT'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_AFC_AFCCORRECTION, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.AFC.AFCCORRECTION'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXCFG1_TXROTATERAMP, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXCFG1.TXROTATERAMP'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXCFG1_TXHCSERRORS, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXCFG1.TXHCSERRORS'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXCFG1_TXFCSERRORS, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXCFG1.TXFCSERRORS'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXCFG1_TXFCSBYP, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXCFG1.TXFCSBYP'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_ANT_ANTSEL, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.ANT.ANTSEL'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDET_PDETCORRELWIDTH, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDET.PDETCORRELWIDTH'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDET_PDETCF, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDET.PDETCF'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDET_PDETEXCLUDECW, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDET.PDETEXCLUDECW'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDET_PDETTHRGAIN, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDET.PDETTHRGAIN'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDET_PDETTHRATT, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDET.PDETTHRATT'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDET_PDETCWTHRGAIN, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDET.PDETCWTHRGAIN'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDET_PDETCWTHRATT, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDET.PDETCWTHRATT'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCFG_NTAPS, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCFG.NTAPS'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCFG_SYMMETRIC, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCFG.SYMMETRIC'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCFG_INTERP, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCFG.INTERP'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCFG_DECIM, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCFG.DECIM'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCFG_NSHIFT, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCFG.NSHIFT'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCFG_SKIPFIRST, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCFG.SKIPFIRST'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCOEFF0_COEFF0, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCOEFF0.COEFF0'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCOEFF0_COEFF1, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCOEFF0.COEFF1'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCOEFF1_COEFF2, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCOEFF1.COEFF2'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCOEFF1_COEFF3, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCOEFF1.COEFF3'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCOEFF2_COEFF4, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCOEFF2.COEFF4'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCOEFF2_COEFF5, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCOEFF2.COEFF5'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCOEFF3_COEFF6, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCOEFF3.COEFF6'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCOEFF3_COEFF7, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCOEFF3.COEFF7'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCOEFF4_COEFF8, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCOEFF4.COEFF8'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCOEFF4_COEFF9, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCOEFF4.COEFF9'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCOEFF5_COEFF10, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCOEFF5.COEFF10'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCOEFF5_COEFF11, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCOEFF5.COEFF11'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCOEFF6_COEFF12, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCOEFF6.COEFF12'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCOEFF6_COEFF13, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCOEFF6.COEFF13'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCOEFF7_COEFF14, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCOEFF7.COEFF14'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_DECFILTCOEFF7_COEFF15, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.DECFILTCOEFF7.COEFF15'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCFG_NTAPS, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCFG.NTAPS'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCFG_SYMMETRIC, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCFG.SYAMMETRIC'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCFG_INTERP, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCFG.INTERP'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCFG_DECIM, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCFG.DEC1M'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCFG_NSHIFT, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCFG.NSHIFT'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCFG_SKIPFIRST, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCFG.SKIPFIRST'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCOEFF0_COEFF0, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCOEFF0.COEFF0'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCOEFF0_COEFF1, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCOEFF0.COEFF1'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCOEFF1_COEFF2, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCOEFF1.COEFF2'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCOEFF1_COEFF3, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCOEFF1.COEFF3'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCOEFF2_COEFF4, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCOEFF2.COEFF4'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCOEFF2_COEFF5, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCOEFF2.COEFF5'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCOEFF3_COEFF6, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCOEFF3.COEFF6'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCOEFF3_COEFF7, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCOEFF3.COEFF7'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCOEFF4_COEFF8, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCOEFF4.COEFF8'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCOEFF4_COEFF9, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCOEFF4.COEFF9'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCOEFF5_COEFF10, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCOEFF5.COEFF10'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCOEFF5_COEFF11, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCOEFF5.COEFF11'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCOEFF6_COEFF12, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCOEFF6.COEFF12'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCOEFF6_COEFF13, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCOEFF6.COEFF13'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCOEFF7_COEFF14, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCOEFF7.COEFF14'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PDETFILTCOEFF7_COEFF15, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PDETFILTCOEFF7.COEFF15'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCFG_NTAPS, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCFG.NTAPS'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCFG_SYMMETRIC, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCFG.SYAMMETRIC'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCFG_INTERP, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCFG.INTERP'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCFG_DECIM, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCFG.DEC1M'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCFG_NSHIFT, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCFG.NSHIFT'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCFG_SKIPFIRST, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCFG.SKIPFIRST'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCOEFF0_COEFF0, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCOEFF0.COEFF0'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCOEFF0_COEFF1, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCOEFF0.COEFF1'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCOEFF1_COEFF2, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCOEFF1.COEFF2'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCOEFF1_COEFF3, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCOEFF1.COEFF3'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCOEFF2_COEFF4, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCOEFF2.COEFF4'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCOEFF2_COEFF5, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCOEFF2.COEFF5'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCOEFF3_COEFF6, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCOEFF3.COEFF6'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCOEFF3_COEFF7, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCOEFF3.COEFF7'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCOEFF4_COEFF8, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCOEFF4.COEFF8'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCOEFF4_COEFF9, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCOEFF4.COEFF9'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCOEFF5_COEFF10, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCOEFF5.COEFF10'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCOEFF5_COEFF11, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCOEFF5.COEFF11'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCOEFF6_COEFF12, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCOEFF6.COEFF12'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCOEFF6_COEFF13, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCOEFF6.COEFF13'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCOEFF7_COEFF14, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCOEFF7.COEFF14'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_TXFILTCOEFF7_COEFF15, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.TXFILTCOEFF7.COEFF15'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PAPR_ENPAPR, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PAPR.ENPAPR'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PAPR_GAINSAT, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PAPR.GAINSAT'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PAPR_GAINATT, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PAPR.GAINATT'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_ANTDIVDLY_AGCRELDLY, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.ANTDIVDLY.AGCRELDLY'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_ANTDIVDLY_AGCCONVDLY, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.ANTDIVDLY.AGCCONVDLY'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_ANTDIVDLY_SETTLINGTIME, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.ANTDIVDLY.SETTLINGTIME'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_ANTDIVDLY_ANTICPSWITCH, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.ANTDIVDLY.ANTICPSWITCH'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_ANTDIVDLY2_AGCCONVDLYRED, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.ANTDIVDLY2.AGCCONVDLYRED'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PREEMPH_PREEMPHEN, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PREEMPH.PREEMPHEN'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PREEMPH_PREEMPHSTFEN, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PREEMPH.PREEMPHSTFEN'))
    profile.outputs.append(ModelOutput(model.vars.SUNOFDM_PREEMPH_MCSTABLE, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PREEMPH.MCSTABLE'))
    for i in range(52):
        profile.outputs.append(ModelOutput(getattr(model.vars, "SUNOFDM_PREEMPHCOGR%d_COEFF%d" % (i//4, i)), '',
                                           ModelOutputType.SVD_REG_FIELD, readable_name='SUNOFDM.PREEMPHCOGR%d.COEFF%d' % (i//4, i)))

    #SUNOQPSK Peripheral
    profile.outputs.append(ModelOutput(model.vars.SUNOQPSK_VREGS_MAJORVERSION, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOQPSK.VREGS.MAJORVERSION'))
    profile.outputs.append(ModelOutput(model.vars.SUNOQPSK_VREGS_MINORVERSION, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOQPSK.VREGS.MINORVERSION'))
    profile.outputs.append(ModelOutput(model.vars.SUNOQPSK_CFG1_MODULATION, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOQPSK.CFG1.MODULATION'))
    profile.outputs.append(ModelOutput(model.vars.SUNOQPSK_CFG1_CHIPRATE, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOQPSK.CFG1.CHIPRATE'))
    profile.outputs.append(ModelOutput(model.vars.SUNOQPSK_CFG1_BANDFREQMHZ, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOQPSK.CFG1.BANDFREQMHZ'))
    profile.outputs.append(ModelOutput(model.vars.SUNOQPSK_CFG2_MACFCSTYPE, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOQPSK.CFG2.MACFCSTYPE'))
    profile.outputs.append(ModelOutput(model.vars.SUNOQPSK_CFG2_XTALFREQ, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNOQPSK.CFG2.XTALFREQ'))

    #LEGOQPSK Peripheral
    profile.outputs.append(ModelOutput(model.vars.LEGOQPSK_VREGS_MAJORVERSION, '', ModelOutputType.SVD_REG_FIELD, readable_name='LEGOQPSK.VREGS.MAJORVERSION'))
    profile.outputs.append(ModelOutput(model.vars.LEGOQPSK_VREGS_MINORVERSION, '', ModelOutputType.SVD_REG_FIELD, readable_name='LEGOQPSK.VREGS.MINORVERSION'))
    profile.outputs.append(ModelOutput(model.vars.LEGOQPSK_CFG1_MODULATION, '', ModelOutputType.SVD_REG_FIELD, readable_name='LEGOQPSK.CFG1.MODULATION'))
    profile.outputs.append(ModelOutput(model.vars.LEGOQPSK_CFG1_CHIPRATE, '', ModelOutputType.SVD_REG_FIELD, readable_name='LEGOQPSK.CFG1.CHIPRATE'))
    profile.outputs.append(ModelOutput(model.vars.LEGOQPSK_CFG1_BANDFREQMHZ, '', ModelOutputType.SVD_REG_FIELD, readable_name='LEGOQPSK.CFG1.BANDFREQMHZ'))
    profile.outputs.append(ModelOutput(model.vars.LEGOQPSK_CFG2_XTALFREQ, '', ModelOutputType.SVD_REG_FIELD, readable_name='LEGOQPSK.CFG2.XTALFREQ'))

    #SUNFSK Peripheral
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_VREGS_MAJORVERSION, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.VREGS.MAJORVERSION'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_VREGS_MINORVERSION, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.VREGS.MINORVERSION'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG1_MODULATION, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG1.MODULATION'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG1_FECSEL, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG1.FECSEL'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG1_PHYSUNFSKSFD, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG1.PHYSUNFSKSFD'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG1_FSKPREAMBLELENGTH, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG1.FSKPREAMBLELENGTH'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG1_MODSCHEME, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG1.MODSCHEME'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG1_BT, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG1.BT'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG1_MODINDEX, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG1.MODINDEX'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG3_OSR, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG3.OSR'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG2_VEQEN, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG2.VEQEN'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG2_KSI1, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG2.KSI1'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG2_KSI2, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG2.KSI2'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG2_KSI3, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG2.KSI3'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG3_KSI3W, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG3.KSI3W'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG3_PHASESCALE, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG3.PHASESCALE'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG4_PREAMBLECOSTTHD, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG4.PREAMBLECOSTTHD'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG4_PREAMBLECNTWIN, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG4.PREAMBLECNTWIN'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG4_PREAMBLECNTTHD, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG4.PREAMBLECNTTHD'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG5_PREAMBLELEN, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG5.PREAMBLELEN'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG5_PREAMBLEERRORS, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG5.PREAMBLEERRORS'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG5_PREAMBLETIMEOUT, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG5.PREAMBLETIMEOUT'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG6_PREAMBLEPATT, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG6.PREAMBLEPATT'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG7_PREAMBLEFREQLIM, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG7.PREAMBLEFREQLIM'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG7_PREAMBLECOSTMAX, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG7.PREAMBLECOSTMAX'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG8_SFD1, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG8.SFD1'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG9_SFD2, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG9.SFD2'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG10_SFDLEN, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG10.SFDLEN'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG10_SFDCOSTTHD, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG10.SFDCOSTTHD'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG11_SFDTIMEOUT, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG11.SFDTIMEOUT'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG11_SFDERRORS, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG11.SFDERRORS'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG11_TIMINGTRACKGEAR, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG11.TIMINGTRACKGEAR'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG12_TIMINGTRACKSYMB, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG12.TIMINGTRACKSYMB'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG12_TIMINGMINTRANS, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG12.TIMINGMINTRANS'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG12_REALTIMESEARCH, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG12.REALTIMESEARCH'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG12_NBSYMBBATCH, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG12.NBSYMBBATCH'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG13_CHFILTERSWEN, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG13.CHFILTSWEN'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG13_AFCMODE, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG13.AFCMODE'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG13_AFCSCALE, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG13.AFCSCALE'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG14_AFCADJLIM, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG14.AFCADJLIM'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG15_AFCADJPERIOD, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG15.AFCADJPERIOD'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG15_AFCCOSTTHD, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG15.AFCCOSTTHD'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG15_XTALFREQ, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG15.XTALFREQ'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_CFG16_MODE, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.CFG16.MODE'))

    profile.outputs.append(ModelOutput(model.vars.SUNFSK_COLLDET_COLLDET, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.COLLDET.COLLDET'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_COLLDET_COLLDETTHR, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.COLLDET.COLLDETTHR'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_AFC_AFCCORRECTION, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.AFC.AFCCORRECTION'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_AFC_AFCMIXERRATIOATT, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.AFC.AFCMIXERRATIOATT'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_AFC_AFCMIXERRATIOGAIN, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.AFC.AFCMIXERRATIOGAIN'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_TXCFG1_TXHCSERRORS, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.TXCFG1.TXHCSERRORS'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_TXCFG1_TXFCSERRORS, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.TXCFG1.TXFCSERRORS'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_ANT_ANTDIV, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.ANT.ANTDIV'))
    profile.outputs.append(ModelOutput(model.vars.SUNFSK_ANT_ANTSEL, '', ModelOutputType.SVD_REG_FIELD, readable_name='SUNFSK.ANT.ANTSEL'))

    # FRC Spare
    profile.outputs.append(ModelOutput(model.vars.FRC_SPARE_SPARE, '', ModelOutputType.SVD_REG_FIELD, readable_name='FRC.SPARE.SPARE'))

    #SMCTRL
    profile.outputs.append(ModelOutput(model.vars.SMCTRL_TXDONE_TXDONE, '', ModelOutputType.SVD_REG_FIELD, readable_name='SMCTRL.TXDONE.TXDONE'))

    # Add SPARE register for ECO fix for DEC1 gain log2 calculation
    profile.outputs.append(ModelOutput(model.vars.MODEM_SPARE_SPARE, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SPARE.SPARE'))
