from pyradioconfig.parts.lynx.calculators.calc_radio import CALC_Radio_lynx


class calc_radio_leopard(CALC_Radio_lynx):

    def calc_lpfbwrx_reg(self, model):
        """
        calculate frequency synthesizer's LPF bandwidth for TX and write to register

        Args:
            model (ModelRoot) : Data model to read and write variables from
        """

        pll_bandwidth_rx = model.vars.pll_bandwidth_rx.value

        if pll_bandwidth_rx == model.vars.pll_bandwidth_rx.var_enum.BW_100KHz:
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_OP1BWRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_OP1COMPRX , 7)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_RZVALRX , 8)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_RPVALRX , 6)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_RFBVALRX , 0)

            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_LPFSWENRX , 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_LPFGNDSWENRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CASELRX , 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CAVALRX , 22)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CFBSELRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CZSELRX , 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CZVALRX , 254)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_MODESELRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_VCMLVLRX , 0)

            self._reg_write(model.vars.SYNTH_DSMCTRLRX_REQORDERRX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_MASHORDERRX , 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DEMMODERX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_LSBFORCERX , 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DSMMODERX , 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DITHERDACRX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DITHERDSMOUTPUTRX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DITHERDSMINPUTRX , 0)
        if pll_bandwidth_rx == model.vars.pll_bandwidth_rx.var_enum.BW_150KHz:
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_OP1BWRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_OP1COMPRX , 7)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_RZVALRX , 8)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_RPVALRX , 6)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_RFBVALRX , 0)

            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_LPFSWENRX , 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_LPFGNDSWENRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CASELRX , 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CAVALRX , 22)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CFBSELRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CZSELRX , 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CZVALRX , 254)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_MODESELRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_VCMLVLRX , 0)

            self._reg_write(model.vars.SYNTH_DSMCTRLRX_REQORDERRX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_MASHORDERRX , 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DEMMODERX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_LSBFORCERX , 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DSMMODERX , 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DITHERDACRX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DITHERDSMOUTPUTRX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DITHERDSMINPUTRX , 0)
        if pll_bandwidth_rx == model.vars.pll_bandwidth_rx.var_enum.BW_200KHz:
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_OP1BWRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_OP1COMPRX , 7)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_RZVALRX , 12)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_RPVALRX , 7)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_RFBVALRX , 0)

            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_LPFSWENRX , 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_LPFGNDSWENRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CASELRX , 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CAVALRX , 22)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CFBSELRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CZSELRX , 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CZVALRX , 254)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_MODESELRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_VCMLVLRX , 0)

            self._reg_write(model.vars.SYNTH_DSMCTRLRX_REQORDERRX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_MASHORDERRX , 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DEMMODERX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_LSBFORCERX , 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DSMMODERX , 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DITHERDACRX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DITHERDSMOUTPUTRX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DITHERDSMINPUTRX , 0)
        if pll_bandwidth_rx == model.vars.pll_bandwidth_rx.var_enum.BW_250KHz:
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_OP1BWRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_OP1COMPRX , 7)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_RZVALRX , 13)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_RPVALRX , 7)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_RFBVALRX , 0)

            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_LPFSWENRX , 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_LPFGNDSWENRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CASELRX , 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CAVALRX , 16)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CFBSELRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CZSELRX , 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CZVALRX , 229)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_MODESELRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_VCMLVLRX , 0)

            self._reg_write(model.vars.SYNTH_DSMCTRLRX_REQORDERRX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_MASHORDERRX , 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DEMMODERX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_LSBFORCERX , 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DSMMODERX , 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DITHERDACRX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DITHERDSMOUTPUTRX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DITHERDSMINPUTRX , 0)
        if pll_bandwidth_rx == model.vars.pll_bandwidth_rx.var_enum.BW_300KHz:
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_OP1BWRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_OP1COMPRX , 7)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_RZVALRX , 14)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_RPVALRX , 7)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_RFBVALRX , 0)

            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_LPFSWENRX , 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_LPFGNDSWENRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CASELRX , 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CAVALRX , 16)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CFBSELRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CZSELRX , 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CZVALRX , 128)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_MODESELRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_VCMLVLRX , 0)

            self._reg_write(model.vars.SYNTH_DSMCTRLRX_REQORDERRX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_MASHORDERRX , 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DEMMODERX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_LSBFORCERX , 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DSMMODERX , 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DITHERDACRX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DITHERDSMOUTPUTRX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DITHERDSMINPUTRX , 0)
        if pll_bandwidth_rx == model.vars.pll_bandwidth_rx.var_enum.FASTSWITCH:
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_OP1BWRX , 5)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_OP1COMPRX , 13)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_RZVALRX , 3)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_RPVALRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL1RX_RFBVALRX , 0)

            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_LPFSWENRX , 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_LPFGNDSWENRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CASELRX , 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CAVALRX , 8)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CFBSELRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CZSELRX , 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_CZVALRX , 70)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_MODESELRX , 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2RX_VCMLVLRX , 0)

            self._reg_write(model.vars.SYNTH_DSMCTRLRX_REQORDERRX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_MASHORDERRX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DEMMODERX , 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_LSBFORCERX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DSMMODERX , 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DITHERDACRX , 3)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DITHERDSMOUTPUTRX , 7)
            self._reg_write(model.vars.SYNTH_DSMCTRLRX_DITHERDSMINPUTRX , 1)

    def calc_lpfbwtx_reg(self, model):
        """
        calculate frequency synthesizer's LPF bandwidth for TX and write to register

        Args:
            model (ModelRoot) : Data model to read and write variables from
        """

        pll_bandwidth_tx = model.vars.pll_bandwidth_tx.value

        if pll_bandwidth_tx == model.vars.pll_bandwidth_tx.var_enum.BW_750KHz:
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_OP1BWTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_OP1COMPTX, 13)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RZVALTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RPVALTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RFBVALTX, 0)

            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_LPFSWENTX, 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_LPFGNDSWENTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CASELTX, 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CAVALTX, 15)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CFBSELTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CZSELTX, 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CZVALTX, 126)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_MODESELTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_VCMLVLTX, 0)

            self._reg_write(model.vars.SYNTH_DSMCTRLTX_REQORDERTX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_MASHORDERTX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DEMMODETX, 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_LSBFORCETX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DSMMODETX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDACTX, 3)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDSMOUTPUTTX, 3)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDSMINPUTTX, 1)
        elif pll_bandwidth_tx == model.vars.pll_bandwidth_tx.var_enum.BW_1000KHz:
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_OP1BWTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_OP1COMPTX, 13)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RZVALTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RPVALTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RFBVALTX, 0)

            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_LPFSWENTX, 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_LPFGNDSWENTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CASELTX, 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CAVALTX, 15)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CFBSELTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CZSELTX, 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CZVALTX, 126)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_MODESELTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_VCMLVLTX, 0)

            self._reg_write(model.vars.SYNTH_DSMCTRLTX_REQORDERTX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_MASHORDERTX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DEMMODETX, 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_LSBFORCETX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DSMMODETX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDACTX, 3)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDSMOUTPUTTX, 3)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDSMINPUTTX, 1)

        elif pll_bandwidth_tx == model.vars.pll_bandwidth_tx.var_enum.BW_1200KHz:
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_OP1BWTX, 2)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_OP1COMPTX, 13)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RZVALTX, 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RPVALTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RFBVALTX, 0)

            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_LPFSWENTX, 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_LPFGNDSWENTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CASELTX, 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CAVALTX, 12)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CFBSELTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CZSELTX, 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CZVALTX, 102)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_MODESELTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_VCMLVLTX, 0)

            self._reg_write(model.vars.SYNTH_DSMCTRLTX_REQORDERTX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_MASHORDERTX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DEMMODETX, 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_LSBFORCETX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DSMMODETX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDACTX, 3)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDSMOUTPUTTX, 3)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDSMINPUTTX, 1)

        elif pll_bandwidth_tx == model.vars.pll_bandwidth_tx.var_enum.BW_1500KHz:
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_OP1BWTX, 5)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_OP1COMPTX, 13)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RZVALTX, 3)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RPVALTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RFBVALTX, 0)

            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_LPFSWENTX, 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_LPFGNDSWENTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CASELTX, 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CAVALTX, 8)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CFBSELTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CZSELTX, 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CZVALTX, 70)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_MODESELTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_VCMLVLTX, 0)

            self._reg_write(model.vars.SYNTH_DSMCTRLTX_REQORDERTX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_MASHORDERTX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DEMMODETX, 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_LSBFORCETX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DSMMODETX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDACTX, 3)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDSMOUTPUTTX, 3)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDSMINPUTTX, 1)
        elif pll_bandwidth_tx == model.vars.pll_bandwidth_tx.var_enum.BW_2000KHz:
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_OP1BWTX, 8)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_OP1COMPTX, 13)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RZVALTX, 6)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RPVALTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RFBVALTX, 0)

            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_LPFSWENTX, 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_LPFGNDSWENTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CASELTX, 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CAVALTX, 6)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CFBSELTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CZSELTX, 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CZVALTX, 40)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_MODESELTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_VCMLVLTX, 0)

            self._reg_write(model.vars.SYNTH_DSMCTRLTX_REQORDERTX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_MASHORDERTX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DEMMODETX, 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_LSBFORCETX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DSMMODETX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDACTX, 3)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDSMOUTPUTTX, 3)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDSMINPUTTX, 1)

        elif pll_bandwidth_tx == model.vars.pll_bandwidth_tx.var_enum.BW_2500KHz:
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_OP1BWTX, 11)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_OP1COMPTX, 14)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RZVALTX, 9)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RPVALTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RFBVALTX, 0)

            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_LPFSWENTX, 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_LPFGNDSWENTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CASELTX, 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CAVALTX, 4)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CFBSELTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CZSELTX, 1)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CZVALTX, 22)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_MODESELTX, 0)
            self._reg_write(model.vars.SYNTH_LPFCTRL2TX_VCMLVLTX, 0)

            self._reg_write(model.vars.SYNTH_DSMCTRLTX_REQORDERTX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_MASHORDERTX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DEMMODETX, 1)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_LSBFORCETX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DSMMODETX, 0)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDACTX, 3)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDSMOUTPUTTX, 3)
            self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDSMINPUTTX, 1)
        elif pll_bandwidth_tx == model.vars.pll_bandwidth_tx.var_enum.BW_3000KHz:
           self._reg_write(model.vars.SYNTH_LPFCTRL1TX_OP1BWTX, 15)
           self._reg_write(model.vars.SYNTH_LPFCTRL1TX_OP1COMPTX, 15)
           self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RZVALTX, 11)
           self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RPVALTX, 0)
           self._reg_write(model.vars.SYNTH_LPFCTRL1TX_RFBVALTX, 0)

           self._reg_write(model.vars.SYNTH_LPFCTRL2TX_LPFSWENTX, 1)
           self._reg_write(model.vars.SYNTH_LPFCTRL2TX_LPFGNDSWENTX, 0)
           self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CASELTX, 1)
           self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CAVALTX, 2)
           self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CFBSELTX, 0)
           self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CZSELTX, 1)
           self._reg_write(model.vars.SYNTH_LPFCTRL2TX_CZVALTX, 6)
           self._reg_write(model.vars.SYNTH_LPFCTRL2TX_MODESELTX, 0)
           self._reg_write(model.vars.SYNTH_LPFCTRL2TX_VCMLVLTX, 0)

           self._reg_write(model.vars.SYNTH_DSMCTRLTX_REQORDERTX, 0)
           self._reg_write(model.vars.SYNTH_DSMCTRLTX_MASHORDERTX, 0)
           self._reg_write(model.vars.SYNTH_DSMCTRLTX_DEMMODETX, 1)
           self._reg_write(model.vars.SYNTH_DSMCTRLTX_LSBFORCETX, 0)
           self._reg_write(model.vars.SYNTH_DSMCTRLTX_DSMMODETX, 0)
           self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDACTX, 3)
           self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDSMOUTPUTTX, 3)
           self._reg_write(model.vars.SYNTH_DSMCTRLTX_DITHERDSMINPUTTX, 1)