from pyradioconfig.parts.lynx.calculators.calc_global import CALC_Global_lynx
from pycalcmodel.core.variable import ModelVariableFormat
from py_2_and_3_compatibility import *
from pycalcmodel.core.variable import ModelVariableFormat, CreateModelVariableEnum

class CALC_Global_ocelot(CALC_Global_lynx):

    def buildVariables(self, model):

        # Build variables from the Lynx calculations
        super().buildVariables(model)

        #Add variables for Ocelot
        self._addModelVariable(model,  'lock_bwsel'            , float,   ModelVariableFormat.DECIMAL, units='Hz', desc='reduced bwsel after oneshot AFC. ')
        self._addModelVariable(model,  'datapath_delay_samp', int, ModelVariableFormat.DECIMAL)
        self._addModelVariable(model,  'afc_scale_tx'          ,  float,  ModelVariableFormat.DECIMAL)
        self._addModelVariable(model,  'targetmin_osr', int, ModelVariableFormat.DECIMAL)
        self._addModelVariable(model,  'targetmax_osr', int, ModelVariableFormat.DECIMAL)
        self._addModelVariable(model,  'demod_bandwidth_hz', int, ModelVariableFormat.DECIMAL)
        self._addModelVariable(model,  'lock_bandwidth_hz', int, ModelVariableFormat.DECIMAL)
        self._addModelVariable(model, 'bcr_demod_en', int, ModelVariableFormat.DECIMAL)

        self._addModelVariable(model, 'ppnd_0', int, ModelVariableFormat.DECIMAL)
        self._addModelVariable(model, 'ppnd_1', int, ModelVariableFormat.DECIMAL)
        self._addModelVariable(model, 'ppnd_2', int, ModelVariableFormat.DECIMAL)
        self._addModelVariable(model, 'ppnd_3', int, ModelVariableFormat.DECIMAL)
        self._addModelVariable(model, 'ksi3wb', int, ModelVariableFormat.DECIMAL)

        # new actual variables for Ocelot
        self._addModelActual(model,    'syncbits'               , int,     ModelVariableFormat.DECIMAL)
        self._addModelActual(model,    'afc_scale_tx'               , float,     ModelVariableFormat.DECIMAL)
        self._addModelActual(model,    'lock_bandwidth'            , int,     ModelVariableFormat.DECIMAL)
        self._addModelActual(model,    'subfrac'              , float,   ModelVariableFormat.DECIMAL)

        self._addModelVariable(model,    'deviation_tol_ppm', int,         ModelVariableFormat.DECIMAL, units='ppm',  desc='Maximum deviation offset expected')
        self._addModelVariable(model, 'tx_preamble_length', int, ModelVariableFormat.DECIMAL, units='bits', desc='Preamble length to TX')
        # Owner: Rossano Pantaleoni
        # Jira Link: https://jira.silabs.com/browse/MCUW_RADIO_CFG-2231
        member_data = [
            ['INTERNAL', 0, 'Internal compensation only'],
            ['ONE_SHOT', 2, 'AFC One Shot mode, AFC occurs at DSA detection and internal compensation always active'],
        ]
        model.vars.afc_run_mode.var_enum = CreateModelVariableEnum(
            'AfcRunMode',
            'List of supported AFC Run Modes',
            member_data)

        # These were extracted from Lynx register model and identified as new (and non-existent in the Panther map)

        # TODO: decide if all of these really belong in the calculator. For instance: enables, interrupt enables, etc.
        # TODO: do we really want the calculator to explicitly re-write these to their reset/default values a la MCUW_RADIO_CFG-734?


        # Must have a corresponding ModelVariableContainer entry in pyradioconfig/parts/common/profiles/ocelot_regs.py build_modem_regs_ocelot.
        # MCUW_RADIO_CFG-734 Panther: PHY/MAC Design requests more registers added (all MODEM, AGC, etc.) with re-writes of reset values

        # Any registers here are new in Ocelot (and are read-write; read-only and write-only are omitted) and do not exist in Lynx

        # Right now, these are all writen here without specific details if these are PTE-owned, RAIL-owned, or otherwise
        # now-to-be-written by Radio Configurator. Other groups may weigh in if any fields should be removed from RC.

        # Add register groups
        self._add_MODEM_RXRESTART(model)
        self._add_RAC_RX_LNAMIXENRFPKDLOTHRESH_regs(model)
        self._add_RAC_SYTRIM_regs(model)
        self._add_RAC_RXTX_SY_regs(model)
        self._add_RAC_SYMMDCTRL_SYMMDMODE_regs(model)
        self._add_RAC_SYEN_regs(model)
        self._add_OOKSHAPING_regs(model)
        self._add_IFADCPLLDCO_regs(model)
        self._add_IFADCPLLEN_regs(model)
        self._add_IFADCTRIM1_regs(model)
        self._add_PATRIM3_regs(model)
        self._add_SYDIVCTRL_regs(model)
        self._add_SYNTHENCTRL_regs(model)
        self._add_TXRAMP_regs(model)
        self._add_dig_ramp_en_reg_field(model)
        self._add_REALTIMECFE_EXTENSCHBYP_field(model)
        self._add_RFPKDTHD_reg(model)
        self._add_AGC_LNABOOST_reg(model)
        self._add_ADCPLL_regs(model)

    def _add_common_regs(self, model):
        super()._add_common_regs(model)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.BCRDEMODEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.RAWSYN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.PH0SIZE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.LOCKUPBYP', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.RAWFASTMA', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.SPIKEREMOV', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.RAWFLTSEL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.PREATH', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.SKIPSYN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.PMPATTERN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.NONSTDPK', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.SLICERFAST', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.DETECTORSEL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.PHSRCSEL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.BBPMDETEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.CONSCHKBYP', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.INVRXBIT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.MANCHPH', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.PULCORRBYP', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.DIRECTMODE', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.BCRDEMODOOK.OOKFRZEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODOOK.RAWGAIN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODOOK.MAFREQDWN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODOOK.SQUELCLKEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODOOK.BWPK', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODOOK.DECAYSWAL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODOOK.DECAY', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODOOK.ATTACK', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODOOK.SQUELCH', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODOOK.RAWNDEC', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODOOK.BCRDEMODOOK', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODOOK.PKTRUNK', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.BCRCTRL0.BCRNCOFF', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRCTRL0.BCRALIGN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRCTRL0.DISTOGG', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRCTRL0.CRSLOW', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRCTRL0.CRFAST', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRCTRL0.BCRERRRSTEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRCTRL0.BCRFBBYP', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.BCRCTRL1.CRGAIN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRCTRL1.CGAINX2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRCTRL1.RXNCOCOMP', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRCTRL1.RXCOMPLAT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRCTRL1.ESCMIDPT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRCTRL1.DISMIDPT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRCTRL1.BCROSR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRCTRL1.ESTOSREN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRCTRL1.BCRSWSYCW', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRCTRL1.PHCOMP2FSK', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRCTRL1.SLICEFBBYP', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.BCRDEMODAFC0.LARGEFREQERR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODAFC0.AFCGAINOVRFLW', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODAFC0.EN2TBEST', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODAFC0.ENAFCCLKSW', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.BCRDEMODAFC1.LGWAIT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODAFC1.SHWAIT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODAFC1.GEARSW', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODAFC1.AFCMAEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODAFC1.ENFZPMEND', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODAFC1.NONFRZEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODAFC1.ONESHOTWAITCNT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODAFC1.ONESHOTAFCEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODAFC1.SKIPPMDET', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODAFC1.ENAFCFRZ', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODAFC1.ENAFC', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODAFC1.ENFBPLL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODAFC1.HALFPHCOMP', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODAFC1.PMRSTEN', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.BCRDEMOD4FSK0.THD4GFSK', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMOD4FSK0.CODE4GFSK', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMOD4FSK0.PHCOMPBYP', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMOD4FSK0.EN4GFSK', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.BCRDEMOD4FSK1.PHCOMP4FSK0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMOD4FSK1.PHCOMP4FSK1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMOD4FSK1.S2PMAP', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.BCRDEMODANT.SKIP2PHTHD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODANT.ANWAIT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODANT.AGCGAINUPB', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODANT.SKIP2PH', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODANT.BYP1P5', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODANT.ANT2PMTHD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODANT.SWANTTIMER', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODANT.BCRDEMODANTDIV', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.BCRDEMODRSSI.RSSIARRTHD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODRSSI.MUTERSSICNT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODRSSI.RSSIMATAP', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.BCRDEMODARR0.SCHPRDLO', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR0.SCHPRDHI', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR0.ARRRSTEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR0.ARRTOLER', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR0.DIFF0RSTEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR0.PHSPIKETHD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR0.ARRDETTHD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR0.SCHFRZEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR0.EYEXESTEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR0.EYEXESTFAST', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR0.ARRDETSRC', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR0.ARRDETEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR0.ARRQPM', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR0.EYEQUALEN', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.BCRDEMODARR1.ARREYEQUAL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR1.EYEOPENTHD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR1.CFEQUALTHD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR1.SYMBWMAX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR1.SYMBWMIN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR1.BCRCFESRC', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR1.ENCFEQUAL', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.DCCOMP.DCGAINGEAREN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.DCCOMP.DCGAINGEAR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.DCCOMP.DCGAINGEARSMPS', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.VTBLETIMING.DISDEMODOF', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.AFCADJRX.AFCSCALEM', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.AFCADJRX.AFCSCALEE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.AFCADJTX.AFCSCALEM', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.AFCADJTX.AFCSCALEE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.TRECSCFG.TRECSOSR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.TRECSCFG.PMOFFSET', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE00.SET0COEFF0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE00.SET0COEFF1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE00.SET0COEFF2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE01.SET0COEFF3', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE01.SET0COEFF4', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE02.SET0COEFF5', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE02.SET0COEFF6', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE03.SET0COEFF7', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE03.SET0COEFF8', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE04.SET0COEFF9', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE04.SET0COEFF10', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE05.SET0COEFF11', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE05.SET0COEFF12', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE06.SET0COEFF13', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE06.SET0COEFF14', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE10.SET1COEFF0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE10.SET1COEFF1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE10.SET1COEFF2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE11.SET1COEFF3', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE11.SET1COEFF4', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE12.SET1COEFF5', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE12.SET1COEFF6', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE13.SET1COEFF7', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE13.SET1COEFF8', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE14.SET1COEFF9', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE14.SET1COEFF10', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE15.SET1COEFF11', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE15.SET1COEFF12', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE16.SET1COEFF13', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCOE16.SET1COEFF14', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCTRL.FWSWCOEFFEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCTRL.FWSELCOEFF', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CHFCTRL.SWCOEFFEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.FRMSCHTIME.FRMSCHTIME', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.FRMSCHTIME.PMENDSCHEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.FRMSCHTIME.PMRSTSYCNEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.FRMSCHTIME.DSARSTSYCNEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXDEBUG.LNAMIXDISMXR0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXTRIM0.LNAMIXLNA0CAPSEL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXTRIM0.LNAMIXMXRBIAS0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXTRIM0.LNAMIXVOUT0ADJ', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXTRIM2.LNAMIXCURCTRL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXTRIM2.LNAMIXHIGHCUR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXTRIM2.LNAMIXLNARESADJ', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXTRIM2.LNAMIXNCASADJ', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXTRIM2.LNAMIXPCASADJ', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXTRIM2.LNAMIXTRIMVREG', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXTRIM3.LNAMIXIBIASADJN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXTRIM3.LNAMIXIBIASADJP', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXTRIM3.LNAMIXIBIASRANGEADJN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXTRIM3.LNAMIXIBIASRANGEADJP', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXTRIM4.LNAMIXRFPKDBWSEL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXCAL.LNAMIXCALPMOSEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXCAL.LNAMIXCALNMOSEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXCAL.LNAMIXENIRCAL0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXCAL.LNAMIXIRCAL0AMP', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXEN.LNAMIXENAMP0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXEN.LNAMIXENAMP1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXEN.LNAMIXENBIAS', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM0.TXTRIMLPAVMID', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM1.TXTRIMXPAVNB', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM2.TXTRIMCLKGENDUTYN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM2.TXTRIMCLKGENDUTYP', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM1.TXTRIMXPAVPB', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM1.TXTRIMHPAVMID', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM1.TXTRIMHPAVNCAS', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM1.TXTRIMHPAVPCAS', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM2.TXTRIMCLKGENNOVFALL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM2.TXTRIMCLKGENNOVRISE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM2.TXTRIMDRVEDGENN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM2.TXTRIMDRVEDGENP', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM2.TXTRIMDRVEDGEPN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM2.TXTRIMDRVEDGEPP', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM3.TXTRIMDREGBLEEDAUTO', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM3.TXTRIMOREGBLEEDAUTO', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM3.TXTRIMDREGFB', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM3.TXTRIMOREGFB', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM3.TXTRIMDREGPSR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM3.TXTRIMOREGPSR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM3.TXTRIMOREGSLICES', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM3.TXTRIMDREGMOREBW', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM3.TXTRIMOREGMOREBW', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM5.TXTRIMXPAVNS', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PATRIM5.TXTRIMXPAVPS', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TXPOWER.TXSTRIPE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TXPOWER.TXSLICE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PADEBUG0.TXOREGBYPASS', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PADEBUG0.TXDREGBYPASS', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PADEBUG0.TXRREGBYPASS', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PADEBUG0.TXPDNVDDPA', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TXOGNDPKD.TXPKDOGNDRESET', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TXPOWER.TXDRVSLICE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RFPATHEN0.LNAMIXEN0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RFPATHEN0.LNAMIXRFATTDCEN0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RFPATHEN0.LNAMIXRFPKDENRF0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RFPATHEN0.SYLODIVRLO0SUBGEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RFPATHEN1.LNAMIXEN1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RFPATHEN1.LNAMIXRFATTDCEN1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RFPATHEN1.LNAMIXRFPKDENRF1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RFPATHEN1.SYLODIVRLO1SUBGEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TX.TXENOREGBLEED', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RFPATHEN0.TXENHPA0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RFPATHEN1.TXENHPA1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TX.TXENDREG', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TX.TXENOREG', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RFPATHEN0.TXENLPA0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RFPATHEN1.TXENLPA1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TX.TXENCLKGEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TX.TXENPKDOGND', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TX.TXENRREG', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RFPATHEN0.TXENVMIDHPA0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RFPATHEN1.TXENVMIDHPA1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RFPATHEN0.TXENVMIDLPA0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RFPATHEN1.TXENVMIDLPA1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TX.TXENRAMPCLK', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TX.TXMODESE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYTRIM1.SYLODIVSELOUTINVADC', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYTRIM1.SYLODIVTLOTRIMDELAY', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYLOEN.SYLODIVEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYLOEN.SYLODIVLDOBIASEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYLOEN.SYLODIVLDOEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYLOEN.SYLODIVTLOSUBGAUXEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYLOEN.SYLODIVTLOSUBGEN', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'AGC.AGCPERIOD0.PERIODHI', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.AGCPERIOD1.PERIODLOW', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.AGCPERIOD0.MAXHICNTTHD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.AGCPERIOD0.SETTLETIMEIF', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.AGCPERIOD0.SETTLETIMERF', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.HICNTREGION0.HICNTREGION0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.HICNTREGION0.HICNTREGION1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.HICNTREGION0.HICNTREGION2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.HICNTREGION0.HICNTREGION3', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.HICNTREGION1.HICNTREGION4', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.GAINSTEPLIM0.CFLOOPDEL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.GAINSTEPLIM0.CFLOOPSTEPMAX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.GAINSTEPLIM0.HYST', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.GAINSTEPLIM0.MAXPWRVAR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.GAINSTEPLIM0.TRANRSTAGC', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.GAINSTEPLIM1.LNAINDEXMAX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.GAINSTEPLIM1.PGAINDEXMAX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.GAINSTEPLIM1.PNINDEXMAX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT10.LNAMIXRFATT21', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT10.LNAMIXRFATT22', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT1.LNAMIXRFATT3', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT1.LNAMIXRFATT4', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT2.LNAMIXRFATT5', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT2.LNAMIXRFATT6', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT3.LNAMIXRFATT7', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT3.LNAMIXRFATT8', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT4.LNAMIXRFATT10', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT4.LNAMIXRFATT9', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT5.LNAMIXRFATT11', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT5.LNAMIXRFATT12', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT6.LNAMIXRFATT13', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT6.LNAMIXRFATT14', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT7.LNAMIXRFATT15', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT7.LNAMIXRFATT16', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT8.LNAMIXRFATT17', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT8.LNAMIXRFATT18', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT9.LNAMIXRFATT19', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT9.LNAMIXRFATT20', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATTALT.LNAMIXRFATTALT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.PNRFATT11.LNAMIXRFATT23', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.ANTDIV.GAINMODE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.ANTDIV.DEBOUNCECNTTHD', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.LONGRANGE1.PREFILTLEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PREFILTCOEFF.PREFILTCOEFF', long, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.COH3.COHDSACMPLX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SYNCPROPERTIES.STATICSYNCTHRESHEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SYNCPROPERTIES.STATICSYNCTHRESH', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.COH0.COHCHPWRLOCK', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.COH0.COHCHPWRRESTART', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.PRE.PREWNDERRORS', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CTRL3.TIMINGBASESGAIN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CTRL6.TXDBPSKINV', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.CTRL6.TXDBPSKRAMPEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ANARAMPCTRL.VMIDCTRL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.ANARAMPCTRL.MUTEDLY', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.PHDMODANTDIV.ANTWAIT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHDMODANTDIV.SKIP2ANT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHDMODANTDIV.SKIPCORRTHD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHDMODANTDIV.SKIPRSSITHD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHANTDECSION.RSSICORR0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHANTDECSION.RSSICORR1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHANTDECSION.RSSICORR2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHANTDECSION.RSSICORR3', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHANTDECSION.RSSIANDDIVTHD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHANTDECSION.CORRANDDIVTHD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHDMODCTRL.PMDETEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHDMODCTRL.PMDETTHD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHDMODCTRL.REMODEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHDMODCTRL.REMODOSR', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHDMODCTRL.REMODDWN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHDMODCTRL.PMTIMLOSEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHDMODCTRL.PMTIMLOSTHD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHDMODCTRL.RSSIFLTBYP', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.STATUS0.RFPKDLOWLAT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.STATUS0.RFPKDHILAT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.STATUS1.RFPKDLOWLATCNT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.STATUS2.RFPKDHILATCNT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.CTRL6.DUALRFPKDDEC', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.CTRL6.ENDUALRFPKD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.CTRL0.CFLOOPNFADJ', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.DUALRFPKDTHD0.RFPKDLOWTHD0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.DUALRFPKDTHD0.RFPKDLOWTHD1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.DUALRFPKDTHD1.RFPKDHITHD0', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.DUALRFPKDTHD1.RFPKDHITHD1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.CTRL5.SEQPNUPALLOW', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.CTRL5.SEQRFPKDEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.CTRL6.GAINDETTHD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.CTRL7.SUBDEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.CTRL7.SUBINT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.CTRL7.SUBNUM', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.CTRL7.SUBPERIOD', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.CHFLATENCYCTRL.CHFLATENCY', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHDMODCTRL.REMODOUTSEL', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.AFC.AFCGEAR', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.VTCORRCFG1.VITERBIKSI3WB', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.VTCORRCFG1.KSI3SWENABLE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODKSI.BCRKSI1', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODKSI.BCRKSI2', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODKSI.BCRKSI3', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.BCRDEMODPMEXP.BCRCFECOSTTHD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODPMEXP.BCRPHSCALE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODPMEXP.BCRCFESCHWIN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODPMEXP.BCRPMACQWIN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODPMEXP.BCRPMEXP', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.BCRDEMODCTRL.MANCHDLY', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.PHDMODCTRL.BCRTRECSCONC', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHDMODCTRL.BCRLEGACYCONC', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.BCRDEMODOOK.ABPK', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODOOK.NOISEFLEST', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMOD4FSK1.FDEVCOMPEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMOD4FSK1.FDEVCOMPRATIO', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODRSSI.PRWOFFSET', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR1.KSICOMPEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR2.RAWDCHKALWAYON', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.BCRDEMODARR2.CONSYMOL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.PHDMODCTRL.BCRDETECTOR', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'MODEM.SQ.SQEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SQ.SQTIMOUT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SQEXT.SQSTG2TIMOUT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SQEXT.SQSTG3TIMOUT', int, ModelVariableFormat.HEX)

        self._addModelRegister(model, 'SYNTH.LPFCTR1TX.RFBVALTX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'FRC.TRAILTXDATACTRL.POSTAMBLEEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'FRC.CTRL.SKIPRXSUPSTATEWHITEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'FRC.CTRL.SKIPTXTRAILDATAWHITEN', int, ModelVariableFormat.HEX)

    def _add_dig_ramp_en_reg_field(self, model):
        self._addModelRegister(model, 'SEQ.MISC.DIG_RAMP_EN', int, ModelVariableFormat.HEX)

    def _add_REALTIMECFE_EXTENSCHBYP_field(self, model):
        self._addModelRegister(model, 'MODEM.REALTIMCFE.EXTENSCHBYP', int, ModelVariableFormat.HEX)

    def _add_IFADCTRIM1_regs(self, model):
        self._addModelRegister(model, 'RAC.IFADCTRIM1.IFADCENSUBGMODE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCTRIM1.IFADCENXOBYPASS', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCTRIM1.IFADCTZ', int, ModelVariableFormat.HEX)

    def _add_RAC_PGACTRL(self, model):
        self._addModelRegister(model, 'RAC.PGACTRL.LNAMIXRFPKDTHRESHSEL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PGACTRL.PGABWMODE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PGACTRL.PGAENBIAS', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PGACTRL.PGAENGHZ', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PGACTRL.PGAENHYST', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PGACTRL.PGAENLATCHI', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PGACTRL.PGAENLATCHQ', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PGACTRL.PGAENLDOLOAD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PGACTRL.PGAENOFFD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PGACTRL.PGAENPGAI', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PGACTRL.PGAENPGAQ', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PGACTRL.PGAENPKD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PGACTRL.PGAENRCMOUT', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PGACTRL.PGAENSUBG', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PGACTRL.PGATHRPKDHISEL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.PGACTRL.PGATHRPKDLOSEL', int, ModelVariableFormat.HEX)

    def _add_MODEM_RXRESTART(self, model):
        self._addModelRegister(model, 'MODEM.RXRESTART.FLTRSTEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.RXRESTART.ANTSWRSTFLTTDIS', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.RXRESTART.RXRESTARTB4PREDET', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.RXRESTART.RXRESTARTMATAP', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.RXRESTART.RXRESTARTMALATCHSEL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.RXRESTART.RXRESTARTMACOMPENSEL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.RXRESTART.RXRESTARTMATHRESHOLD', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.RXRESTART.RXRESTARTUPONMARSSI', int, ModelVariableFormat.HEX)

    def _add_RAC_RX_LNAMIXENRFPKDLOTHRESH_regs(self, model):
        self._addModelRegister(model, 'RAC.RX.LNAMIXENRFPKDLOTHRESH', int, ModelVariableFormat.HEX)

    def _add_RAC_SYTRIM_regs(self, model):
        self._addModelRegister(model, 'RAC.SYTRIM0.SYCHPCURRRX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYTRIM0.SYCHPCURRTX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYTRIM0.SYCHPLEVPSRCRX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYTRIM0.SYCHPLEVPSRCTX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYTRIM0.SYCHPSRCENRX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYTRIM0.SYCHPSRCENTX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYTRIM1.SYLODIVLDOTRIMCORERX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYTRIM1.SYLODIVLDOTRIMCORETX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYTRIM1.SYLODIVLDOTRIMNDIORX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYTRIM1.SYLODIVLDOTRIMNDIOTX', int, ModelVariableFormat.HEX)

    def _add_RAC_RXTX_SY_regs(self, model):
        self._addModelRegister(model, 'RAC.RX.SYCHPBIASTRIMBUFRX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TX.SYCHPBIASTRIMBUFTX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RX.SYPFDCHPLPENRX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TX.SYPFDCHPLPENTX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RX.SYPFDFPWENRX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TX.SYPFDFPWENTX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.RX.LNAMIXLDOLOWCUR', int, ModelVariableFormat.HEX)

    def _add_RAC_SYMMDCTRL_SYMMDMODE_regs(self, model):
        self._addModelRegister(model, 'RAC.SYMMDCTRL.SYMMDMODERX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYMMDCTRL.SYMMDMODETX', int, ModelVariableFormat.HEX)

    def _add_RAC_SYEN_regs(self, model):
        self._addModelRegister(model, 'RAC.SYEN.SYCHPLPENRX', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.SYEN.SYCHPLPENTX', int, ModelVariableFormat.HEX)

    def _add_OOKSHAPING_regs(self, model):
        self._addModelRegister(model, 'MODEM.OOKSHAPING.OOKSHAPINGEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.OOKSHAPING.OOKSHAPINGSTEP', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.OOKSHAPING.OOKSHAPINGLUTSIZE', int, ModelVariableFormat.HEX)

    def _add_IFADCPLLDCO_regs(self, model):
        self._addModelRegister(model, 'RAC.IFADCPLLDCO.IFADCPLLDCOBIASHALF', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLDCO.IFADCPLLDCOENABLE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLDCO.IFADCPLLDCOFILTER', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLDCO.IFADCPLLDCOFULLRATE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLDCO.IFADCPLLDCOMSBCURRENT', int, ModelVariableFormat.HEX)

    def _add_IFADCPLLEN_regs(self, model):
        self._addModelRegister(model, 'RAC.IFADCPLLEN.IFADCPLLENBBDET', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLEN.IFADCPLLENBBXLDET', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLEN.IFADCPLLENBBXMDET', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLEN.IFADCPLLENCFDET', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLEN.IFADCPLLENROTDET', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLEN.IFADCPLLSERIEREGENABLE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLEN.IFADCPLLSHUNTREGENABLE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLEN.IFADCPLLENXOBYP', int, ModelVariableFormat.HEX)

    def _add_PATRIM3_regs(self, model):
        self._addModelRegister(model, 'RAC.PATRIM3.TXTRIMDREGBLEED', int, ModelVariableFormat.HEX)

    def _add_SYDIVCTRL_regs(self, model):
        self._addModelRegister(model, 'RAC.SYDIVCTRL.SYLODIVRADCDIV', int, ModelVariableFormat.HEX)

    def _add_SYNTHENCTRL_regs(self, model):
        self._addModelRegister(model, 'RAC.SYNTHENCTRL.MMDPOWERBALANCEDISABLE', int, ModelVariableFormat.HEX)

    def _add_TXRAMP_regs(self, model):
        self._addModelRegister(model, 'RAC.TXRAMP.TXPHASEDIGITAL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TXRAMP.TXANARAMPDRVEN', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TXRAMP.TXUNMUTEENDRVFF', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.TXRAMP.TXMODEPHASEFLIP', int, ModelVariableFormat.HEX)

    def _add_bitrate_variable(self, model):
        # For Ocelot+ the bitrate variable in the calculator represents net bitrate before coding
        self._addModelVariable(model, 'bitrate', int, ModelVariableFormat.DECIMAL, units='bps',
                               desc='Bit rate before any coding')

    def _add_SHAPING_regs(self, model):
        self._addModelRegister(model, 'MODEM.SHAPING2.COEFF9', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING2.COEFF10', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING2.COEFF11', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING3.COEFF12', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING3.COEFF13', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING3.COEFF14', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING3.COEFF15', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING4.COEFF16', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING4.COEFF17', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING4.COEFF18', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING4.COEFF19', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING5.COEFF20', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING5.COEFF21', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING5.COEFF22', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING5.COEFF23', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING6.COEFF24', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING6.COEFF25', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING6.COEFF26', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING6.COEFF27', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING7.COEFF28', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING7.COEFF29', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING7.COEFF30', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING7.COEFF31', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING8.COEFF32', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING8.COEFF33', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING8.COEFF34', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING8.COEFF35', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING9.COEFF36', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING9.COEFF37', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING9.COEFF38', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING9.COEFF39', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING10.COEFF40', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING10.COEFF41', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING10.COEFF42', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING10.COEFF43', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING11.COEFF44', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING11.COEFF45', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING11.COEFF46', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING11.COEFF47', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING12.COEFF48', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING12.COEFF49', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING12.COEFF50', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING12.COEFF51', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING13.COEFF52', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING13.COEFF53', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING13.COEFF54', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING13.COEFF55', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING14.COEFF56', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING14.COEFF57', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING14.COEFF58', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING14.COEFF59', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING15.COEFF60', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING15.COEFF61', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING15.COEFF62', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'MODEM.SHAPING15.COEFF63', int, ModelVariableFormat.HEX)

    def _add_RFPKDTHD_reg(self, model):
        self._addModelRegister(model, 'RAC.LNAMIXTRIM4.LNAMIXRFPKDTHRESHSELHI', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.LNAMIXTRIM4.LNAMIXRFPKDTHRESHSELLO', int, ModelVariableFormat.HEX)

    def _add_ADCPLL_regs(self, model):
        self._addModelRegister(model, 'RAC.IFADCPLLCTRL.IFADCPLLLDCNIB', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLCTRL.IFADCPLLLDFNIB', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLCTRL.IFADCPLLLDMNIB', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLCTRL.IFADCPLLRDNIBBLE', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLREG.IFADCPLLSERIEREGFILTER', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLREG.IFADCPLLSERIEREGVCTRL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLREG.IFADCPLLSHUNTREGICTRL', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'RAC.IFADCPLLREG.IFADCPLLSHUNTREGVCTRL', int, ModelVariableFormat.HEX)

    def _add_AGC_LNABOOST_reg(self, model):
        self._addModelRegister(model, 'AGC.LNABOOST.BOOSTLNA', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.LNABOOST.LNABWADJBOOST', int, ModelVariableFormat.HEX)
        self._addModelRegister(model, 'AGC.LNABOOST.LNABWADJ', int, ModelVariableFormat.HEX)