from pyradioconfig.protected_fields.base_protected_fields import ProtectedFieldsBase


class ProtectedFieldsRainier(ProtectedFieldsBase):

    """
    PTE has two types of protected fields
    1) cal
    2) set and forget

    For radio configurator,
    1) Protect all PTE cal fields (do not write)
    2) Ensure set and forget fields are same as PTE if radio configurator is also programming the values

    For rail_script,
    1) protect all PTE cal fields
    2) Protect set and forget field, if register contains pte cal field or radio configurator writes to the field

    """

    PTE_PROTECTED_FIELD_DICT = {
        'RAC_PREREGTRIM_PREREGTRIMVTRMINITEMPCO': 'cal',
        'RAC_PREREGTRIM_PREREGTRIMVTRMINIVOLTAGE': 'cal',
        'RAC_PREREGTRIM_PREREGTRIMVREG': 'cal',
        'RAC_VTRTRIM_VTRTRIMTC': 'cal',
        'RAC_VTRTRIM_VTRTRIMVREF': 'cal',
        'RAC_VTRTRIM_VTRTRIMIBIAS': 'cal',
        'RAC_VTRTRIM_VTRTRIMVREFVTR': 'cal',
        'RAC_CLKMULTCTRL_CLKMULTTRIMVREG1': 'cal',
        'RAC_CLKMULTCTRL_CLKMULTTRIMVREF2': 'cal',
        'RAC_CLKMULTEN1_CLKMULTILOADREG2': 0x5,
        'RAC_CLKMULTEN1_CLKMULTDRVAMPSEL': 0x3,
        'RAC_AUXADCCAL_AUXADCTSENSESELCURR': 'cal',
        'RAC_ADCTRIM0_ADCLDOSERIESAMPLVL': 'cal',
        'RAC_ADCTRIM0_ADCSIDETONEAMP': 'cal',
        'RAC_ADCCTRL0_ADCLDOSHUNTAMPLVL1': 'cal',
        'RAC_ADCCTRL0_ADCTUNERC': 'cal',
        'AGC_CTRL8_RSSISHIFTP': 'cal',
        'RAC_LNAMIXTRIM0_LNAMIXMXRBIAS1': 'cal',
        'RAC_LNAMIXTRIM0_LNAMIXIBIAS1TRIM': 'cal',
        'RAC_LNAMIXTRIM0_LNAMIXENREGVHIGH': 0x1,
        'RAC_LNAMIXTRIM0_LNAMIXTRIMVREG': 'cal',
        'RAC_LNAMIXTRIM1_LNAMIXRFPKDCALCMHI': 'cal',
        'RAC_LNAMIXTRIM1_LNAMIXRFPKDCALCMLO': 'cal',
        'RAC_SYTRIM0_SYDTCRDACTRIM1': 'cal',
        'RAC_SYTRIM1_SYTDCREGTRIMTEMPCON': 0x1,
        'RAC_SYTRIM1_SYTDCREGTRIMTEMPCOP': 0x7,
        'RAC_SYTRIM1_SYDTCRDACTRIM': 'cal',
        'RAC_SYTRIM1_SYDSMDACREGTRIMVREF': 'cal',
        'RAC_SYTRIM2_SYMMDREGTRIMVREGOFFS': 'cal',
        'RAC_SYTRIM2_SYMMDREGTRIMVREF': 'cal',
        'RAC_SYTRIM3_SYVCOREGTRIMVREGTX': 'cal',
        'RAC_SYTRIM3_SYTDCREGTRIMVREGTX': 'cal',
        'RAC_SYTRIM3_SYTDCREGTRIMVREG': 'cal',
        'RAC_SYTRIM3_SYVCOREGTRIMVREG': 'cal',
        'RAC_SYTRIM3_SYVCOTRIMR': 'cal',
        'RAC_SYTRIM3_SYVCOREGTRIMVREF': 'cal',
        'RAC_SYLOTRIM0_SYLODIVREGTRIMVREGOFFS': 'cal',
        'RAC_SYLOTRIM0_SYLODIVREGTRIMVREF': 'cal',
        'SYNTH_VCOGAIN_VCOKVFINE': 'cal',
        'SYNTH_LMSOVERRIDE_PLMSOVERRIDEVAL': 'cal',
        'RAC_TX0DBMTRIM0_TX0DBMTRIMVREFREGPA': 'cal',
        'RAC_TX0DBMTRIM1_TX0DBMTRIMVREFREGPREDRV': 'cal',
        'RAC_TX0DBMTRIM1_TX0DBMTRIMDUTYCYP': 'cal',
        'RAC_TX0DBMTRIM1_TX0DBMTRIMRFBREGPA': 'cal',
        'RAC_TX0DBMTRIM1_TX0DBMTRIMPBIASPA': 'cal',
        'RAC_TX0DBMTRIM1_TX0DBMTRIMNBIASPA': 'cal',
        'RAC_TX0DBMTRIM1_TX0DBMTRIMDUTYCYN': 'cal',
        'RAC_TX10DBMTRIM1_TX10DBMTRIMDUTYP': 'cal',
        'RAC_TX10DBMTRIM1_TX10DBMTRIMBIASP': 'cal',
        'RAC_TX10DBMTRIM1_TX10DBMTRIMDUTYN': 'cal',
        'RAC_TX10DBMTRIM1_TX10DBMTRIMBIASN': 'cal',
        'RAC_TX10DBMTRIM2_TX10DBMTRIMPAREGVREF': 'cal',
        'RAC_TX10DBMTRIM2_TX10DBMTRIMPAREG': 'cal',
        'RAC_TX10DBMTRIM2_TX10DBMTRIMPREDRVREGVREF': 'cal',
        'RAC_TX10DBMTRIM2_TX10DBMTRIMPREDRVREG': 'cal',
        'RAC_TX10DBMTRIM2_TX10DBMTRIMPREDRVCAP': 'cal',
        'RAC_TX10DBMTRIM2_TX10DBMTRIMLOINTVDDAPREDRV': 'cal',
        'RAC_MIXDACTRIM_MIXDACTRIMVREGDIGVREF': 'cal',
        'RAC_MIXDACTRIM_MIXDACTRIMVREGDIG': 'cal',
        'RAC_MIXDACTRIM_MIXDACTRIMVREGCOREVREF': 'cal',
        'RAC_MIXDACTRIM_MIXDACTRIMVREGCORE': 'cal',
        'MODEM_IRCALCOEFWR0_CIVWEN': 0x1,
        'MODEM_IRCALCOEFWR0_CIVWD': 'cal',
        'MODEM_IRCALCOEFWR0_CRVWEN': 0x1,
        'MODEM_IRCALCOEFWR0_CRVWD': 'cal',
        'MODEM_IRCALCOEFWR1_CIVWEN': 0x1,
        'MODEM_IRCALCOEFWR1_CIVWD': 'cal',
        'MODEM_IRCALCOEFWR1_CRVWEN': 0x1,
        'MODEM_IRCALCOEFWR1_CRVWD': 'cal',
        'MODEM_IRCAL_IRCORREN': 0x1,
        'MODEM_IRCAL_MUISHF': 0x0,
        'MODEM_IRCAL_MURSHF': 0x0,
        'MODEM_IRCAL_IRCALEN': 0x1,
        'MODEM_TXCORRPTE_TXDCQ': 0x0,
        'MODEM_TXCORRPTE_TXDCI': 0x0,
        'MODEM_TXCORRPTE_TXPHSIMB': 'cal',
        'MODEM_TXCORRPTE_TXGAINIMB': 'cal',
        'MODEM_TXCORRPTE_TXIQIMBEN': 0x1,
        'AGC_TIACODE2_TIACAPFB1': 'cal',
        'AGC_TIACODE2_TIACAPFB2': 'cal',
        'AGC_TIACODE2_TIACAPFB3': 'cal',
        'AGC_TIACODE2_TIACAPFB4': 'cal',
        'AGC_TIACODE3_TIACAPFB5': 'cal',
        'AGC_TIACODE3_TIACAPFB6': 'cal',
        'AGC_TIACODE3_TIACAPFB7': 'cal',
        'AGC_TIACODE3_TIACAPFB8': 'cal',
        'AGC_TIACODE4_TIACAPFB9': 'cal',
        'AGC_TIACODE4_TIACAPFB10': 'cal',
        'AGC_TIACODE4_TIACAPFB11': 'cal',
        'RAC_TIATRIM0_TIATRIMVREF': 'cal',
        'RAC_TIATRIM0_TIATRIMVREG': 'cal',
        'RAC_TIACTRL0_TIASETVCM': 'cal',

        # : These are enable bits that RAIL Team has requested that calculator do not touch
        'RAC_CLKMULTEN0_CLKMULTENREG1IBIAS': 'cal',
        'RAC_CLKMULTEN0_CLKMULTENREG1': 'cal',
        'RAC_CLKMULTEN0_CLKMULTENREG1REPLICA': 'cal',
        'RAC_CLKMULTEN0_CLKMULTENREG2': 'cal',
        'RAC_CLKMULTEN0_CLKMULTENDRVP': 'cal',
        'RAC_CLKMULTEN0_CLKMULTENDRVIRCAL': 'cal',
        'RAC_CLKMULTEN0_CLKMULTENDRVTEST': 'cal',
        'RAC_CLKMULTEN0_CLKMULTENDRVADC': 'cal',
        'RAC_CLKMULTEN0_CLKMULTENDRVDAC': 'cal',
        'RAC_CLKMULTEN0_CLKMULTDISICO': 'cal',
        'RAC_CLKMULTEN0_CLKMULTENBBDET': 'cal',
        'RAC_CLKMULTEN0_CLKMULTENBBXLDET': 'cal',
        'RAC_CLKMULTEN0_CLKMULTENBBXMDET': 'cal',
        'RAC_CLKMULTEN0_CLKMULTENCFDET': 'cal',
        'RAC_CLKMULTEN0_CLKMULTENFBDIV': 'cal',
        'RAC_CLKMULTEN0_CLKMULTENREFDIV': 'cal',
        'RAC_CLKMULTEN0_CLKMULTENROTDET': 'cal',
        'RAC_CLKMULTCTRL_CLKMULTRESETPHFRQDET': 'cal',
        'RAC_ADCCTRL0_ADCCTRLRESERVEDLV': 'cal',
    }

    # : List of fields found in PTE, but allow radio configurator to override the value
    PTE_PROTECTED_FIELD_EXCEPTIONS = [
    ]

    # : List of fields protected by RAIL
    RAIL_PROTECTED_FIELDS = [
        'RAC_CLKMULTEN0_CLKMULTENREG1IBIAS',
        'RAC_CLKMULTEN0_CLKMULTENREG1',
        'RAC_CLKMULTEN0_CLKMULTENREG1REPLICA',
        'RAC_CLKMULTEN0_CLKMULTENREG2',
        'RAC_CLKMULTEN0_CLKMULTENDRVP',
        'RAC_CLKMULTEN0_CLKMULTENDRVIRCAL',
        'RAC_CLKMULTEN0_CLKMULTENDRVTEST',
        'RAC_CLKMULTEN0_CLKMULTENDRVADC',
        'RAC_CLKMULTEN0_CLKMULTENDRVDAC',
        'RAC_CLKMULTEN0_CLKMULTDISICO',
        'RAC_CLKMULTEN0_CLKMULTENBBDET',
        'RAC_CLKMULTEN0_CLKMULTENBBXLDET',
        'RAC_CLKMULTEN0_CLKMULTENBBXMDET',
        'RAC_CLKMULTEN0_CLKMULTENCFDET',
        'RAC_CLKMULTEN0_CLKMULTENFBDIV',
        'RAC_CLKMULTEN0_CLKMULTENREFDIV',
        'RAC_CLKMULTEN0_CLKMULTENROTDET',
        'RAC_CLKMULTEN1_CLKMULTILOADREG2',
        'RAC_CLKMULTEN1_CLKMULTDRVAMPSEL',
        'RAC_CLKMULTCTRL_CLKMULTRESETPHFRQDET',
        'RAC_TIAEN_TIAENLATCHI',
        'RAC_TIAEN_TIAENLATCHQ',
        'AGC_CTRL0_RSSISHIFT',
        'AGC_CTRL1_CCATHRSH',
        'FRC_RXCTRL_BUFRESTORERXABORTED',
        'FRC_RXCTRL_BUFRESTOREFRAMEERROR',
        'FRC_RXCTRL_BUFCLEAR',
        'FRC_RXCTRL_TRACKABFRAME',
        'FRC_RXCTRL_ACCEPTBLOCKERRORS',
        'FRC_RXCTRL_ACCEPTCRCERRORS',
        'FRC_RXCTRL_STORECRC',
        'MODEM_IRCALCOEF_CIV',
        'MODEM_IRCALCOEF_CRV',
        'MODEM_IRCAL_MURSHF',
        'MODEM_IRCAL_MUISHF',
        'SYNTH_VCDACCTRL_VCDACVAL',
        'SYNTH_VCOGAIN_VCOKVCOARSE',
    ]

    # : List of fields that are found in PTE list, but does not need to be protected by RAIL
    RAIL_PROTECTED_FIELD_EXCEPTIONS = [
    ]