/***************************************************************************//**
 * @file
 * @brief Header file for RAIL antenna functionality
 *******************************************************************************
 * # License
 * <b>Copyright 2024 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 ******************************************************************************/

#ifndef __RAILAPP_ANTENNA_H__
#define __RAILAPP_ANTENNA_H__

#include "sl_rail_types.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
  RAILAPP_ANTENNA_0 = SL_RAIL_RX_OPTION_ANTENNA_0,
  RAILAPP_ANTENNA_1 = SL_RAIL_RX_OPTION_ANTENNA_1,
  RAILAPP_ANTENNA_AUTO = SL_RAIL_RX_OPTION_ANTENNA_AUTO,
} RAILAPP_AntennaSel_t;

void RAILAPP_SetRfPath(sl_rail_antenna_sel_t rfPath);

#ifdef __cplusplus
}
#endif

#endif
