/*
 *    Copyright (c) 2017, The OpenThread Authors.
 *    All rights reserved.
 *
 *    Redistribution and use in source and binary forms, with or without
 *    modification, are permitted provided that the following conditions are met:
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *    3. Neither the name of the copyright holder nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 *    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 *    AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *    ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 *    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 *    CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *    ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *    POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @file
 * This file includes definitions for time functions.
 */

#include "otbr_time.hpp"
#include "cmsis_os2.h"

namespace otbr {

namespace Clock {
Milliseconds now(void)
{
    return (Milliseconds)(NowMicroSec() / 1000);
}

Microseconds NowMicroSec(void)
{
#ifdef SL_OTBR_TIME_USE_OT_TIMER
    return Microseconds(otPlatTimeGet());
#else
    static uint32_t tickL = 0;
    static uint32_t tickH = 0;
    uint32_t        tick;
    uint64_t        tick64;
    Microseconds    us;

    tick = osKernelGetTickCount();
    if (tick < tickL)
    {
        tickH++;
    }
    tickL  = tick;
    tick64 = (uint64_t)(((uint64_t)tickH << 32) | tickL);
    us     = (Microseconds)((tick64 * 1000000) / osKernelGetTickFreq());
    return us;
#endif
}
}; // namespace Clock

} // namespace otbr
