/***************************************************************************//**
 * @file sl_wisun_alliance_certificates.h
 * @brief Certificates for Wi-SUN FAN certification
 *******************************************************************************
 * # License
 * <b>Copyright 2022 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 ******************************************************************************/

#ifndef SL_WISUN_ALLIANCE_CERTIFICATES_H
#define SL_WISUN_ALLIANCE_CERTIFICATES_H

#include <stdint.h>

const uint8_t GLOBALSIGN_ROOT_CERT[] = {
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIICIDCCAcagAwIBAgIBATAKBggqhkjOPQQDAjB1MQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2lnbiBudi1zYTEaMBgGA1UECxMRRm9yIFRlc3QgVXNlIE9ubHkxLzAtBgNVBAMTJkdsb2JhbFNpZ24gV2ktU1VOIEZBTiBFQ0MgVGVzdCBSb290IENBMCAXDTE4MDcxODAwMDAwMFoYDzk5OTkxMjMxMjM1OTU5WjB1MQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2lnbiBudi1zYTEaMBgGA1UECxMRRm9yIFRlc3QgVXNlIE9ubHkxLzAtBgNVBAMTJkdsb2JhbFNpZ24gV2ktU1VOIEZBTiBFQ0MgVGVzdCBSb290IENBMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEp5HbQNUb1bW4LnUfs77YXysSp+fXXomez+pnzXIb4FJP94knwauyoMd99BsmW/fK/yHzk6Rs4FmaT5m7eRpll6NFMEMwDgYDVR0PAQH/BAQDAgIEMBIGA1UdEwEB/wQIMAYBAf8CAQIwHQYDVR0OBBYEFD0qd4ApGSsRSUwEnFv9fIyYnH+SMAoGCCqGSM49BAMCA0gAMEUCIQDjD8vQ8PbGY+MCP5e4PW0O0ValmtnVg4DXoGYRz+tioQIgGpHT7NmOHtEg4HRGBJe60OcyxFjpDsp/R2pGArN9iuE=\r\n"
    "-----END CERTIFICATE-----"
};

const uint8_t GLOBALSIGN_MCA_CERT[] = {
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIICTzCCAfSgAwIBAgIEGAcYATAKBggqhkjOPQQDAjB1MQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2lnbiBudi1zYTEaMBgGA1UECxMRRm9yIFRlc3QgVXNlIE9ubHkxLzAtBgNVBAMTJkdsb2JhbFNpZ24gV2ktU1VOIEZBTiBFQ0MgVGVzdCBSb290IENBMCAXDTE4MDcxODAwMDAwMFoYDzk5OTkxMjMxMjM1OTU5WjB/MQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2lnbiBudi1zYTEaMBgGA1UECxMRRm9yIFRlc3QgVXNlIE9ubHkxOTA3BgNVBAMTMEdsb2JhbFNpZ24gV2ktU1VOIEZBTiBFQ0MgVGVzdCBNYW51ZmFjdHVyZXIgQ0EgMTBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABELV4UWWmobdLAWUmawJqMV6/IbCTwEyAAuuj3zhYunZsLFJq7oThLf8S8l8+L19ActTDTcE40dRamCjtgpyG7ejZjBkMA4GA1UdDwEB/wQEAwICBDASBgNVHRMBAf8ECDAGAQH/AgEBMB0GA1UdDgQWBBSB8SepzJmMBati+8zAm50esXEhqzAfBgNVHSMEGDAWgBQ9KneAKRkrEUlMBJxb/XyMmJx/kjAKBggqhkjOPQQDAgNJADBGAiEAyDZk9pKX8O3xYIURThYWG3dcS2kOIdKuP2tJ4nwMG4UCIQCzRPcY8jAjLqThArsBK+Sc8kKdRCayEfN0cJyGVTjGmw==\r\n"
    "-----END CERTIFICATE-----"
};

const uint8_t GLOBALSIGN_MICA_CERT[] = {
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIICXjCCAgOgAwIBAgIEGAcYAjAKBggqhkjOPQQDAjB/MQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2lnbiBudi1zYTEaMBgGA1UECxMRRm9yIFRlc3QgVXNlIE9ubHkxOTA3BgNVBAMTMEdsb2JhbFNpZ24gV2ktU1VOIEZBTiBFQ0MgVGVzdCBNYW51ZmFjdHVyZXIgQ0EgMTAgFw0xODA3MTgwMDAwMDBaGA85OTk5MTIzMTIzNTk1OVowgYMxCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWduIG52LXNhMRowGAYDVQQLExFGb3IgVGVzdCBVc2UgT25seTE9MDsGA1UEAxM0R2xvYmFsU2lnbiBXaS1TVU4gRkFOIEVDQyBUZXN0IFN1Yi1NYW51ZmFjdHVyZXIgQ0EgMTBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABEtsbzInynM0ddFwhBMlrZF/b8QJOS8rR6Ji4aSq8fIjK+9cyMPTwnxaCSZUvj+IjqM1fcossLTcvQJTGr8ZiRajZjBkMA4GA1UdDwEB/wQEAwICBDASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBQ3ttkOUJkFBUV3L09XhhFkvRu9vDAfBgNVHSMEGDAWgBSB8SepzJmMBati+8zAm50esXEhqzAKBggqhkjOPQQDAgNJADBGAiEAv3SUEAVVEVbu5LIAP9IC7bgM3nZFLXsCCqK/NvifL+8CIQC0IkpgzHopVq84LtxKr8gnIp8rnsIRUTL53Go2LbQ3PQ==\r\n"
    "-----END CERTIFICATE-----"
};

const uint8_t GLOBALSIGN_DEVICE_CERT[] = {
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIICODCCAd+gAwIBAgIQAcAliTzJKZZXGgmlUAXX6jAKBggqhkjOPQQDAjCBgzELMAkGA1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExGjAYBgNVBAsTEUZvciBUZXN0IFVzZSBPbmx5MT0wOwYDVQQDEzRHbG9iYWxTaWduIFdpLVNVTiBGQU4gRUNDIFRlc3QgU3ViLU1hbnVmYWN0dXJlciBDQSAxMCAXDTIzMDcxOTA2NDkwMFoYDzk5OTkxMjMxMjM1OTU5WjAAMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAENwJYsGqpD0dLSe+Kgy8Lr6JWRvCfSoQ8z+eEDtjpKIXyiYJWiSiGGOJOJu4vWJUHLS6ljuvXLv0x5TKLvzMYCKOBtDCBsTAxBgNVHREBAf8EJzAloCMGCCsGAQUFBwgEoBcwFQYJKwYBBAGCt0ECBAgxMjM0NTY3ODAOBgNVHQ8BAf8EBAMCB4AwHgYDVR0lBBcwFQYJKwYBBAGC5CUBBggrBgEFBQcDAjAdBgNVHQ4EFgQUDVFeOa+KCgKMxQyzo7kToU1XBwowDAYDVR0TAQH/BAIwADAfBgNVHSMEGDAWgBQ3ttkOUJkFBUV3L09XhhFkvRu9vDAKBggqhkjOPQQDAgNHADBEAiArw8zWcMbzYoDgrE6nPOty9nWUuE27Bj1tWW+UAW3k4AIgXF1cOWYGFtkvHHVB0GtGhjUG74zpuZ2hYO1NVBpXzmA=\r\n"
    "-----END CERTIFICATE-----"
};

const uint8_t GLOBALSIGN_DEVICE_KEY[] = {
    "-----BEGIN PRIVATE KEY-----\r\n"
    "MIGHAgEAMBMGByqGSM49AgEGCCqGSM49AwEHBG0wawIBAQQgPNZx9hXT3Da4AgZTV0AbU4YJBwxeZA0loawCbQ/EqaKhRANCAAQ3AliwaqkPR0tJ74qDLwuvolZG8J9KhDzP54QO2OkohfKJglaJKIYY4k4m7i9YlQctLqWO69cu/THlMou/MxgI\r\n"
    "-----END PRIVATE KEY-----"
};

const uint8_t WISEKEY_ROOT_CERT[] = {
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIIB4TCCAYigAwIBAgIEUNvhVjAKBggqhkjOPQQDAjBRMQswCQYDVQQGEwJDSDEQMA4GA1UECgwHV0lTZUtleTEkMCIGA1UEAwwbV0lTZUtleSBXaVNVTiBSb290IDIwMjEwMjExMQowCAYDVQQFEwExMCAXDTIxMDIxMjAwMzA0N1oYDzk5OTkxMjMxMjM1OTU5WjBRMQswCQYDVQQGEwJDSDEQMA4GA1UECgwHV0lTZUtleTEkMCIGA1UEAwwbV0lTZUtleSBXaVNVTiBSb290IDIwMjEwMjExMQowCAYDVQQFEwExMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEYkxjJ3qNGLbbHZFJN/nM62XM+dS6F4SLBtuGeLCPiL9asvMxntr8NYMRZyr887dC6k+OldJOf+eMGg9caRpMJaNMMEowDwYDVR0TAQH/BAUwAwEB/zAUBgNVHSABAf8ECjAIMAYGBFUdIAAwDgYDVR0PAQH/BAQDAgEGMBEGA1UdDgQKBAhJVH7jDHAAnTAKBggqhkjOPQQDAgNHADBEAiAxjZjxXqQllKX1k63gr6MW8voGCcIGB5geIbZuTv1bsAIgDajKaMJVdmPo9w0/QX5Ybxb58/luR+oMi34V+HBMCEc=\r\n"
    "-----END CERTIFICATE-----"
};

const uint8_t WISEKEY_MCA_CERT[] = {
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIIB9jCCAZ2gAwIBAgIEGNO7GzAKBggqhkjOPQQDAjBRMQswCQYDVQQGEwJDSDEQMA4GA1UECgwHV0lTZUtleTEkMCIGA1UEAwwbV0lTZUtleSBXaVNVTiBSb290IDIwMjEwMjExMQowCAYDVQQFEwExMCAXDTIxMDIxMjAxMDUwMloYDzk5OTkxMjMxMjM1OTU5WjBIMQswCQYDVQQGEwJDSDEQMA4GA1UECgwHV0lTZUtleTEbMBkGA1UEAwwSV2lTVU4gTUNBIDIwMjEwMjExMQowCAYDVQQFEwEyMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAE63SiAdB48/cF7HXFf+he4fkHsViCKFmA+MRaDq++6scvcvw6v+CB09f33blbqevs0U34Ye9NjrGtHvRLNlIiwqNqMGgwEgYDVR0TAQH/BAgwBgEB/wIBATATBgNVHSMEDDAKgAhJVH7jDHAAnTAaBgNVHSABAf8EEDAOMAwGCisGAQQBguQlAQEwDgYDVR0PAQH/BAQDAgIEMBEGA1UdDgQKBAhN0Gt6xVF2MzAKBggqhkjOPQQDAgNHADBEAiBhM2L6DhbCrxfBGeYENQpVAiJ5FNFaohLPQ3Zwp9UbtAIge6U17XtCStkMaibYRbNq5aSh+H1gsOrFkqU7e1bsZ4M=\r\n"
    "-----END CERTIFICATE-----"
};

const uint8_t WISEKEY_MICA_CERT[] = {
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIIB7zCCAZWgAwIBAgIEVPqn5zAKBggqhkjOPQQDAjBIMQswCQYDVQQGEwJDSDEQMA4GA1UECgwHV0lTZUtleTEbMBkGA1UEAwwSV2lTVU4gTUNBIDIwMjEwMjExMQowCAYDVQQFEwEyMCAXDTIxMDIxMjAxMjcwOVoYDzk5OTkxMjMxMjM1OTU5WjBJMQswCQYDVQQGEwJDSDEQMA4GA1UECgwHV0lTZUtleTEcMBoGA1UEAwwTV2lTVU4gTUlDQSAyMDIxMDIxMTEKMAgGA1UEBRMBMzBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABJ0g9pXvlCDkVclUVc7w9KXBK0iyjruiU7YnlWg3ZUiXw3MotIKd0gM2OPpzUp7I3u4NnJYrZggnQJpkyQYpSfijajBoMBIGA1UdEwEB/wQIMAYBAf8CAQAwEwYDVR0jBAwwCoAITdBresVRdjMwGgYDVR0gAQH/BBAwDjAMBgorBgEEAYLkJQEBMA4GA1UdDwEB/wQEAwICBDARBgNVHQ4ECgQISP7nvtFWv9UwCgYIKoZIzj0EAwIDSAAwRQIgdJBbQiCF5+hKSUP6NpoKfjWmcym+TcL1wG6GGKfBEG4CIQDZer5G2+D3lpNoGVZO68JOxZXtWcYkNj39u5bfKJPSUg==\r\n"
    "-----END CERTIFICATE-----"
};

const uint8_t WISEKEY_DEVICE_CERT[] = {
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIIBtzCCAV2gAwIBAgIEWH2J0zAKBggqhkjOPQQDAjBJMQswCQYDVQQGEwJDSDEQMA4GA1UECgwHV0lTZUtleTEcMBoGA1UEAwwTV2lTVU4gTUlDQSAyMDIxMDIxMTEKMAgGA1UEBRMBMzAgFw0yMzAyMTQxNTIwMzJaGA85OTk5MTIzMTIzNTk1OVowADBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABKBiDu7uCtqO+GnGFICSZJmOLa4zfYdrPdQQld8edcg0SaysFd2DX+mvZRKqybSblMNcy1M3416EfIkV4rqx2wajejB4MBMGA1UdIwQMMAqACEj+577RVr/VMB4GA1UdJQQXMBUGCCsGAQUFBwMCBgkrBgEEAYLkJQEwDgYDVR0PAQH/BAQDAgOIMDEGA1UdEQEB/wQnMCWgIwYIKwYBBQUHCASgFzAVBgkrBgEEAYK3QQEECIQuFP/+2L0lMAoGCCqGSM49BAMCA0gAMEUCIQD0GiVQ3ms8mnBlXOBpX1qSbH1JlaCpGn1aNvl8dwVVnQIgUA57+HW7sXHsMkaeKFKwRZvXFVpEiBMF1mUrqyzXkuc=\r\n"
    "-----END CERTIFICATE-----"
};

const uint8_t WISEKEY_DEVICE_KEY[] = {
    "-----BEGIN PRIVATE KEY-----\r\n"
    "MIGHAgEAMBMGByqGSM49AgEGCCqGSM49AwEHBG0wawIBAQQgmo3UKB9gYYVQXCEgppIlXYc5wI8YVl4iOwwg1koE8mehRANCAASgYg7u7grajvhpxhSAkmSZji2uM32Haz3UEJXfHnXINEmsrBXdg1/pr2USqsm0m5TDXMtTN+NehHyJFeK6sdsG\r\n"
    "-----END PRIVATE KEY-----"
};

const uint8_t WISEKEY_BR_CERT[] = {
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIIBtTCCAV2gAwIBAgIEH0pK0TAKBggqhkjOPQQDAjBJMQswCQYDVQQGEwJDSDEQMA4GA1UECgwHV0lTZUtleTEcMBoGA1UEAwwTV2lTVU4gTUlDQSAyMDIxMDIxMTEKMAgGA1UEBRMBMzAgFw0yMzAyMTUwNjQwMjFaGA85OTk5MTIzMTIzNTk1OVowADBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABN4DRfakrO4qyeMCJLaaziX0pkclwaGj97ZOvfqQKDQMRmKXq+ogWJLLcBkhKwFpG0aCE6CLS1/9KFS0QzxGSoqjejB4MBMGA1UdIwQMMAqACEj+577RVr/VMB4GA1UdJQQXMBUGCCsGAQUFBwMBBgkrBgEEAYLkJQEwDgYDVR0PAQH/BAQDAgOIMDEGA1UdEQEB/wQnMCWgIwYIKwYBBQUHCASgFzAVBgkrBgEEAYK3QQIECJD9n//+7p7bMAoGCCqGSM49BAMCA0YAMEMCHwtxGf3xj9w1sXbf9HY67+hrzMzkcM7v2kRF2BGLaLMCIAg+LU4DNNnVtiQsMnl4E8Q7k+9h8HMIhbF/sIYTCVfZ\r\n"
    "-----END CERTIFICATE-----"
};

const uint8_t WISEKEY_BR_KEY[] = {
    "-----BEGIN PRIVATE KEY-----\r\n"
    "MIGHAgEAMBMGByqGSM49AgEGCCqGSM49AwEHBG0wawIBAQQg7vFOYrrZdz3T6LUfJ5BklTw8IlpIjvT7aAG4MglPDvKhRANCAATeA0X2pKzuKsnjAiS2ms4l9KZHJcGho/e2Tr36kCg0DEZil6vqIFiSy3AZISsBaRtGghOgi0tf/ShUtEM8RkqK\r\n"
    "-----END PRIVATE KEY-----"
};

const uint8_t WISUN_ROOT_CERT[] = {
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIIBojCCAUmgAwIBAgIFAPf29t8wCgYIKoZIzj0EAwIwMTEOMAwGA1UECgwFV2lTVU4xEzARBgNVBAMMCldpU1VOIFJvb3QxCjAIBgNVBAUTATEwIBcNMTcwNzA0MjEwNDAyWhgPOTk5OTEyMzEyMzU5NTlaMDExDjAMBgNVBAoMBVdpU1VOMRMwEQYDVQQDDApXaVNVTiBSb290MQowCAYDVQQFEwExMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEVrJidrjt1nWFVA/VOA/1XKARMBv9t+9XbnErRKJhwudMEUguImA6Ns5TS6o6wDDGjYF6JzO1htL1+MTNFkId+KNMMEowDwYDVR0TAQH/BAUwAwEB/zARBgNVHQ4ECgQIQP089aoIBgswDgYDVR0PAQH/BAQDAgEGMBQGA1UdIAEB/wQKMAgwBgYEVR0gADAKBggqhkjOPQQDAgNHADBEAiBYqSiYL0Tu8D/zzU8TajVkzKMw6qkku+UIezPn2Tv6rAIgP5+YwqTLC9QTfuz2/XN6Ta5Hd4zgyLSvc1BXm94r06k=\r\n"
    "-----END CERTIFICATE-----"
};

const uint8_t WISUN_DEVICE_CERT[] = {
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIIBoTCCAUegAwIBAgIEDnpQ4DAKBggqhkjOPQQDAjAxMQ4wDAYDVQQKDAVXaVNVTjETMBEGA1UEAwwKV2lTVU4gUm9vdDEKMAgGA1UEBRMBMTAgFw0yMDEwMTkxMjU0MTVaGA85OTk5MTIzMTIzNTk1OVowADBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABPxiIsSFZ+hZyc1zXwIJ/BkFk6vkX/ES0DGtPF0hMa3m+IbHtJ4S+yLjRqjUFtiT+hddjZ9vnmjBrADP4jOm1eajfDB6MBMGA1UdIwQMMAqACED9PPWqCAYLMA4GA1UdDwEB/wQEAwIDiDAwBgNVHREBAf8EJjAkoCIGCCsGAQUFBwgEoBYwFAYHKwYBBAEqAgQJNDQwMDYyMjA2MCEGA1UdJQEB/wQXMBUGCSsGAQQBguQlAQYIKwYBBQUHAwIwCgYIKoZIzj0EAwIDSAAwRQIhAI7E5SvsunNbiEYCgsBCuE+DrSUeLmoxqviD/3AoyG4IAiAOuxqlnC7NwvJam08NDL2IsvKCfv55jYZ+6N7irn2Txw==\r\n"
    "-----END CERTIFICATE-----"
};

const uint8_t WISUN_DEVICE_KEY[] = {
    "-----BEGIN PRIVATE KEY-----\r\n"
    "MIGHAgEAMBMGByqGSM49AgEGCCqGSM49AwEHBG0wawIBAQQg70ivhK5pop2ebhBIA+VmVkn4u//w4Ty6pOD9lmLlgOqhRANCAAT8YiLEhWfoWcnNc18CCfwZBZOr5F/xEtAxrTxdITGt5viGx7SeEvsi40ao1BbYk/oXXY2fb55owawAz+IzptXm\r\n"
    "-----END PRIVATE KEY-----"
};

const uint8_t WISUN_BR_CERT[] = {
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIIBnDCCAUGgAwIBAgIESmUozDAKBggqhkjOPQQDAjAxMQ4wDAYDVQQKDAVXaVNVTjETMBEGA1UEAwwKV2lTVU4gUm9vdDEKMAgGA1UEBRMBMTAgFw0xNzA4MjEwMDA0MjBaGA85OTk5MTIzMTIzNTk1OVowADBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABEcZ97gqqNcjNLKzMlnRbl7XWlNFZ1+42QsCBAWEAR8g9nRo9KiTnq//DdLcT8VlafcK82gf3GMjf3nNUy1jbCOjdjB0MBMGA1UdIwQMMAqACED9PPWqCAYLMA4GA1UdDwEB/wQEAwIDiDAqBgNVHREBAf8EIDAeoBwGCCsGAQUFBwgEoBAwDgYIKwYBBAEJAQMEAgIiMCEGA1UdJQEB/wQXMBUGCSsGAQQBguQlAQYIKwYBBQUHAwEwCgYIKoZIzj0EAwIDSQAwRgIhAMeYoELP41Sre9ZQdotZAJLnOCcLyd5Q98OIRieX4JeBAiEAvXfGcPH4OxN5WNop7gF5BKjqnWpgdHvrsUK1kQNbKPI=\r\n"
    "-----END CERTIFICATE-----"
};

const uint8_t WISUN_BR_KEY[] = {
    "-----BEGIN PRIVATE KEY-----\r\n"
    "MIGHAgEAMBMGByqGSM49AgEGCCqGSM49AwEHBG0wawIBAQQgOEY66Wi9AgjQpcBx0kQRwE7auj6CjWQnstUoiUxMpGuhRANCAARHGfe4KqjXIzSyszJZ0W5e11pTRWdfuNkLAgQFhAEfIPZ0aPSok56v/w3S3E/FZWn3CvNoH9xjI395zVMtY2wj\r\n"
    "-----END PRIVATE KEY-----"
};

#endif /* SL_WISUN_ALLIANCE_CERTIFICATES_H */
