/**
 * @file
 * SPDX-License-Identifier: BSD-3-Clause
 * SPDX-FileCopyrightText: 2025 Z-Wave-Alliance <https://z-wavealliance.org/>
 * @note !!! THIS FILE IS AUTOGENERATED BY `generate_configurations.py` !!! DO NOT MODIFY !!!
 */

#ifndef _ZW_LOG_CONFIG_H_
#define _ZW_LOG_CONFIG_H_

/**
 * \defgroup configuration Configuration
 * Configuration
 *
 * \addtogroup configuration
 * @{
 */
/**
 * \defgroup general General
 * General
 *
 * \addtogroup general
 * @{
 */

/**
 * Size of the log buffer <1..255:1>
 *
 * Size (in bytes) of the buffer reserved for log messages
 */
#if !defined(ZW_LOG_BUFFER_SIZE)
#define ZW_LOG_BUFFER_SIZE  96
#endif /* !defined(ZW_LOG_BUFFER_SIZE) */

/**
 * Display log level
 *
 * If enabled, log messages will be prefixed with their level
 */
#if !defined(ZW_LOG_DISPLAY_LEVEL)
#define ZW_LOG_DISPLAY_LEVEL  1
#endif /* !defined(ZW_LOG_DISPLAY_LEVEL) */

/**
 * Display log source component
 *
 * If enabled, log messages will be prefixed with the ID of their originating component
 */
#if !defined(ZW_LOG_DISPLAY_COMPONENT)
#define ZW_LOG_DISPLAY_COMPONENT  0
#endif /* !defined(ZW_LOG_DISPLAY_COMPONENT) */

/**@}*/ /* \addtogroup general */

/**
 * \defgroup output_channels Output channels
 * Output channels
 *
 * \addtogroup output_channels
 * @{
 */

/**
 * Output channel for Debug messages
 *
 * stdout, stderr, or an empty string for no output
 */
#if !defined(ZW_LOG_CHANNEL_DEBUG)
#define ZW_LOG_CHANNEL_DEBUG  ""
#endif /* !defined(ZW_LOG_CHANNEL_DEBUG) */

/**
 * Output channel for Info messages
 *
 * stdout, stderr, or an empty string for no output
 */
#if !defined(ZW_LOG_CHANNEL_INFO)
#define ZW_LOG_CHANNEL_INFO  "stdout"
#endif /* !defined(ZW_LOG_CHANNEL_INFO) */

/**
 * Output channel for Warning messages
 *
 * stdout, stderr, or an empty string for no output
 */
#if !defined(ZW_LOG_CHANNEL_WARNING)
#define ZW_LOG_CHANNEL_WARNING  ""
#endif /* !defined(ZW_LOG_CHANNEL_WARNING) */

/**
 * Output channel for Error messages
 *
 * stdout, stderr, or an empty string for no output
 */
#if !defined(ZW_LOG_CHANNEL_ERROR)
#define ZW_LOG_CHANNEL_ERROR  "stderr"
#endif /* !defined(ZW_LOG_CHANNEL_ERROR) */

/**@}*/ /* \addtogroup output_channels */

/**
 * \defgroup components Component filtering
 * Component filtering
 *
 * \addtogroup components
 * @{
 */

/**
 * Application
 *
 * If enabled, log messages from the application will be displayed
 */
#if !defined(ZW_LOG_ENABLE_APP)
#define ZW_LOG_ENABLE_APP  1
#endif /* !defined(ZW_LOG_ENABLE_APP) */

/**
 * Hardware
 *
 * If enabled, log messages from the platform hardware layer will be displayed
 */
#if !defined(ZW_LOG_ENABLE_HW)
#define ZW_LOG_ENABLE_HW  0
#endif /* !defined(ZW_LOG_ENABLE_HW) */

/**
 * CC Association
 *
 * If enabled, log messages from the Association command class will be displayed
 */
#if !defined(ZW_LOG_ENABLE_CC_ASSOCIATION)
#define ZW_LOG_ENABLE_CC_ASSOCIATION  0
#endif /* !defined(ZW_LOG_ENABLE_CC_ASSOCIATION) */

/**
 * CC Battery
 *
 * If enabled, log messages from the Battery command class will be displayed
 */
#if !defined(ZW_LOG_ENABLE_CC_BATTERY)
#define ZW_LOG_ENABLE_CC_BATTERY  0
#endif /* !defined(ZW_LOG_ENABLE_CC_BATTERY) */

/**
 * CC Binary Switch
 *
 * If enabled, log messages from the Binary Switch command class will be displayed
 */
#if !defined(ZW_LOG_ENABLE_CC_BINARY_SWITCH)
#define ZW_LOG_ENABLE_CC_BINARY_SWITCH  0
#endif /* !defined(ZW_LOG_ENABLE_CC_BINARY_SWITCH) */

/**
 * CC Central Scene
 *
 * If enabled, log messages from the Central Scene command class will be displayed
 */
#if !defined(ZW_LOG_ENABLE_CC_CENTRAL_SCENE)
#define ZW_LOG_ENABLE_CC_CENTRAL_SCENE  0
#endif /* !defined(ZW_LOG_ENABLE_CC_CENTRAL_SCENE) */

/**
 * CC Color Switch
 *
 * If enabled, log messages from the Color Switch command class will be displayed
 */
#if !defined(ZW_LOG_ENABLE_CC_COLOR_SWITCH)
#define ZW_LOG_ENABLE_CC_COLOR_SWITCH  0
#endif /* !defined(ZW_LOG_ENABLE_CC_COLOR_SWITCH) */

/**
 * CC Door Lock
 *
 * If enabled, log messages from the Door Lock command class will be displayed
 */
#if !defined(ZW_LOG_ENABLE_CC_DOOR_LOCK)
#define ZW_LOG_ENABLE_CC_DOOR_LOCK  0
#endif /* !defined(ZW_LOG_ENABLE_CC_DOOR_LOCK) */

/**
 * CC Firmware Update
 *
 * If enabled, log messages from the Firmware Update command class will be displayed
 */
#if !defined(ZW_LOG_ENABLE_CC_FIRMWARE_UPDATE)
#define ZW_LOG_ENABLE_CC_FIRMWARE_UPDATE  0
#endif /* !defined(ZW_LOG_ENABLE_CC_FIRMWARE_UPDATE) */

/**
 * CC Indicator
 *
 * If enabled, log messages from the Indicator command class will be displayed
 */
#if !defined(ZW_LOG_ENABLE_CC_INDICATOR)
#define ZW_LOG_ENABLE_CC_INDICATOR  0
#endif /* !defined(ZW_LOG_ENABLE_CC_INDICATOR) */

/**
 * CC Multi Channel
 *
 * If enabled, log messages from the Multi Channel command class will be displayed
 */
#if !defined(ZW_LOG_ENABLE_CC_MULTI_CHANNEL)
#define ZW_LOG_ENABLE_CC_MULTI_CHANNEL  0
#endif /* !defined(ZW_LOG_ENABLE_CC_MULTI_CHANNEL) */

/**
 * CC Multilevel Switch
 *
 * If enabled, log messages from the Multilevel Switch command class will be displayed
 */
#if !defined(ZW_LOG_ENABLE_CC_MULTILEVEL_SWITCH)
#define ZW_LOG_ENABLE_CC_MULTILEVEL_SWITCH  0
#endif /* !defined(ZW_LOG_ENABLE_CC_MULTILEVEL_SWITCH) */

/**
 * CC Notification
 *
 * If enabled, log messages from the Notification command class will be displayed
 */
#if !defined(ZW_LOG_ENABLE_CC_NOTIFICATION)
#define ZW_LOG_ENABLE_CC_NOTIFICATION  0
#endif /* !defined(ZW_LOG_ENABLE_CC_NOTIFICATION) */

/**
 * CC User Code
 *
 * If enabled, log messages from the User Code command class will be displayed
 */
#if !defined(ZW_LOG_ENABLE_CC_USER_CODE)
#define ZW_LOG_ENABLE_CC_USER_CODE  0
#endif /* !defined(ZW_LOG_ENABLE_CC_USER_CODE) */

/**
 * CC User Credential
 *
 * If enabled, log messages from the User Credential command class will be displayed
 */
#if !defined(ZW_LOG_ENABLE_CC_USER_CREDENTIAL)
#define ZW_LOG_ENABLE_CC_USER_CREDENTIAL  0
#endif /* !defined(ZW_LOG_ENABLE_CC_USER_CREDENTIAL) */

/**
 * CC Version
 *
 * If enabled, log messages from the Version command class will be displayed
 */
#if !defined(ZW_LOG_ENABLE_CC_VERSION)
#define ZW_LOG_ENABLE_CC_VERSION  0
#endif /* !defined(ZW_LOG_ENABLE_CC_VERSION) */

/**
 * CC Wake Up
 *
 * If enabled, log messages from the Wake Up command class will be displayed
 */
#if !defined(ZW_LOG_ENABLE_CC_WAKE_UP)
#define ZW_LOG_ENABLE_CC_WAKE_UP  0
#endif /* !defined(ZW_LOG_ENABLE_CC_WAKE_UP) */

/**
 * CC Z-Wave Plus Info
 *
 * If enabled, log messages from the Z-Wave Plus Info command class will be displayed
 */
#if !defined(ZW_LOG_ENABLE_CC_ZWAVE_PLUS_INFO)
#define ZW_LOG_ENABLE_CC_ZWAVE_PLUS_INFO  0
#endif /* !defined(ZW_LOG_ENABLE_CC_ZWAVE_PLUS_INFO) */

/**
 * ZAF Actuator
 *
 * If enabled, log messages from the ZAF Actuator will be displayed
 */
#if !defined(ZW_LOG_ENABLE_ZAF_ACTUATOR)
#define ZW_LOG_ENABLE_ZAF_ACTUATOR  0
#endif /* !defined(ZW_LOG_ENABLE_ZAF_ACTUATOR) */

/**
 * ZAF App Timer
 *
 * If enabled, log messages from the ZAF App Timer will be displayed
 */
#if !defined(ZW_LOG_ENABLE_ZAF_APP_TIMER)
#define ZW_LOG_ENABLE_ZAF_APP_TIMER  0
#endif /* !defined(ZW_LOG_ENABLE_ZAF_APP_TIMER) */

/**
 * ZAF Command Publisher
 *
 * If enabled, log messages from the ZAF Command Publisher will be displayed
 */
#if !defined(ZW_LOG_ENABLE_ZAF_CMD_PUBLISHER)
#define ZW_LOG_ENABLE_ZAF_CMD_PUBLISHER  0
#endif /* !defined(ZW_LOG_ENABLE_ZAF_CMD_PUBLISHER) */

/**
 * ZAF Common
 *
 * If enabled, log messages from the ZAF Common will be displayed
 */
#if !defined(ZW_LOG_ENABLE_ZAF_COMMON)
#define ZW_LOG_ENABLE_ZAF_COMMON  0
#endif /* !defined(ZW_LOG_ENABLE_ZAF_COMMON) */

/**
 * ZAF Event Distributor
 *
 * If enabled, log messages from the ZAF Event Distributor will be displayed
 */
#if !defined(ZW_LOG_ENABLE_ZAF_EVENT_DISTRIBUTOR)
#define ZW_LOG_ENABLE_ZAF_EVENT_DISTRIBUTOR  0
#endif /* !defined(ZW_LOG_ENABLE_ZAF_EVENT_DISTRIBUTOR) */

/**
 * ZAF NVM
 *
 * If enabled, log messages from the ZAF NVM will be displayed
 */
#if !defined(ZW_LOG_ENABLE_ZAF_NVM)
#define ZW_LOG_ENABLE_ZAF_NVM  0
#endif /* !defined(ZW_LOG_ENABLE_ZAF_NVM) */

/**
 * ZAF Transport
 *
 * If enabled, log messages from the ZAF Transport will be displayed
 */
#if !defined(ZW_LOG_ENABLE_ZAF_TRANSPORT)
#define ZW_LOG_ENABLE_ZAF_TRANSPORT  0
#endif /* !defined(ZW_LOG_ENABLE_ZAF_TRANSPORT) */

/**
 * ZAF TSE
 *
 * If enabled, log messages from the ZAF TSE will be displayed
 */
#if !defined(ZW_LOG_ENABLE_ZAF_TSE)
#define ZW_LOG_ENABLE_ZAF_TSE  0
#endif /* !defined(ZW_LOG_ENABLE_ZAF_TSE) */

/**@}*/ /* \addtogroup components */

/**@}*/ /* \addtogroup configuration */
#endif /* _ZW_LOG_CONFIG_H_ */
