/***************************************************************************//**
 * @file
 * @brief app_button_handler.h
 *******************************************************************************
 * # License
 * <b>Copyright 2024 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 ******************************************************************************/

#ifndef __APP_BUTTON_HANDLER_H__
#define __APP_BUTTON_HANDLER_H__

#ifdef __cplusplus
extern "C" {
#endif

// -----------------------------------------------------------------------------
//                                   Includes
// -----------------------------------------------------------------------------
#include <zaf_event_distributor_soc.h>
#include "app_button_press.h"
#include "sl_component_catalog.h"
// -----------------------------------------------------------------------------
//                              Macros and Typedefs
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//                                Global Variables
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//                          Public Function Declarations
// -----------------------------------------------------------------------------

bool app_event_enqueue(uint8_t app_event);
bool app_cc_event_enqueue(uint16_t command_class, uint8_t cc_event, void *cc_data);

#ifdef SL_CATALOG_ZW_SLEEPING_DEVICE_PRESENT
void app_button_press_stay_awake_until_release(void);
#endif

#ifdef __cplusplus
}
#endif

#endif //__APP_BUTTON_HANDLER_H__
