/**
 *
 * @file
 * @brief ADC utility functions
 *
 * @copyright 2018 Silicon Laboratories Inc.
 *
 */

#include "ADC.h"
#include <em_cmu.h>
#include "sl_clock_manager.h"
#include <assert.h> 

#if defined(IADC_COUNT) && (IADC_COUNT > 0)

#include <em_iadc.h>

static void ADC_Input_Select(IADC_PosInput_t input)
{
  IADC_InitSingle_t initSingle   = IADC_INITSINGLE_DEFAULT;
  IADC_SingleInput_t singleInput = IADC_SINGLEINPUT_DEFAULT;
  singleInput.negInput = iadcNegInputGnd;
  singleInput.posInput = input; // the positive input (avdd) is scaled down by 4
  IADC_initSingle(IADC0, &initSingle, &singleInput);
}

uint32_t ADC_Measure_VSupply(void)
{
  uint32_t sampleAVDD;

  // Measure AVDD (battery supply voltage level)
  ADC_Input_Select(iadcPosInputAvdd);
  IADC_command(IADC0, iadcCmdStartSingle);
  while (IADC0->SINGLEFIFOSTAT == 0);
  sampleAVDD = IADC_pullSingleFifoData(IADC0);

  // Convert to mV (1.21V ref and 12 bit resolution).
  // Also we scale the sample up by 4 since the input was scaled down by 4
  sampleAVDD = ((sampleAVDD * 1210) / 4095) * 4;

  return sampleAVDD;
}

void ADC_Enable(void)
{
  /*800 sereis has only 1.21 reference volatge therefore we need to scale down the input voltage by 4*/
  IADC_Init_t init               = IADC_INIT_DEFAULT;
  IADC_AllConfigs_t allConfigs   = IADC_ALLCONFIGS_DEFAULT;
  
  __attribute__((unused)) sl_status_t clock_status = SL_STATUS_OK;

  clock_status = sl_clock_manager_enable_bus_clock(SL_BUS_CLOCK_IADC0);
  assert(clock_status == SL_STATUS_OK);

  IADC_init(IADC0, &init, &allConfigs);
}

void ADC_Disable(void)
{
  __attribute__((unused)) sl_status_t clock_status = SL_STATUS_OK;

  IADC_reset(IADC0);
  // Disable IADC clock
  clock_status = sl_clock_manager_disable_bus_clock(SL_BUS_CLOCK_IADC0);
  assert(clock_status == SL_STATUS_OK);
}

#endif /* defined(IADC_COUNT) && (IADC_COUNT > 0) */
