// File: ezsp-enum-decode.c
//
// *** Generated file. Do not edit! ***
//
// Description: Convert an enumerated value into a human-readable string.
//
// Copyright 2007 by Ember Corporation. All rights reserved.                *80*

#include PLATFORM_HEADER
#include "stack/include/sl_zigbee_types.h"
#include "ezsp-enum.h"

const char *decode_sl_zigbee_ezsp_config_id_t(uint8_t value)
{
  switch (value) {
    case SL_ZIGBEE_EZSP_CONFIG_PACKET_BUFFER_HEAP_SIZE: return "SL_ZIGBEE_EZSP_CONFIG_PACKET_BUFFER_HEAP_SIZE";
    case SL_ZIGBEE_EZSP_CONFIG_NEIGHBOR_TABLE_SIZE: return "SL_ZIGBEE_EZSP_CONFIG_NEIGHBOR_TABLE_SIZE";
    case SL_ZIGBEE_EZSP_CONFIG_APS_UNICAST_MESSAGE_COUNT: return "SL_ZIGBEE_EZSP_CONFIG_APS_UNICAST_MESSAGE_COUNT";
    case SL_ZIGBEE_EZSP_CONFIG_BINDING_TABLE_SIZE: return "SL_ZIGBEE_EZSP_CONFIG_BINDING_TABLE_SIZE";
    case SL_ZIGBEE_EZSP_CONFIG_ADDRESS_TABLE_SIZE: return "SL_ZIGBEE_EZSP_CONFIG_ADDRESS_TABLE_SIZE";
    case SL_ZIGBEE_EZSP_CONFIG_MULTICAST_TABLE_SIZE: return "SL_ZIGBEE_EZSP_CONFIG_MULTICAST_TABLE_SIZE";
    case SL_ZIGBEE_EZSP_CONFIG_ROUTE_TABLE_SIZE: return "SL_ZIGBEE_EZSP_CONFIG_ROUTE_TABLE_SIZE";
    case SL_ZIGBEE_EZSP_CONFIG_DISCOVERY_TABLE_SIZE: return "SL_ZIGBEE_EZSP_CONFIG_DISCOVERY_TABLE_SIZE";
    case SL_ZIGBEE_EZSP_CONFIG_STACK_PROFILE: return "SL_ZIGBEE_EZSP_CONFIG_STACK_PROFILE";
    case SL_ZIGBEE_EZSP_CONFIG_SECURITY_LEVEL: return "SL_ZIGBEE_EZSP_CONFIG_SECURITY_LEVEL";
    case SL_ZIGBEE_EZSP_CONFIG_MAX_HOPS: return "SL_ZIGBEE_EZSP_CONFIG_MAX_HOPS";
    case SL_ZIGBEE_EZSP_CONFIG_MAX_END_DEVICE_CHILDREN: return "SL_ZIGBEE_EZSP_CONFIG_MAX_END_DEVICE_CHILDREN";
    case SL_ZIGBEE_EZSP_CONFIG_INDIRECT_TRANSMISSION_TIMEOUT: return "SL_ZIGBEE_EZSP_CONFIG_INDIRECT_TRANSMISSION_TIMEOUT";
    case SL_ZIGBEE_EZSP_CONFIG_END_DEVICE_POLL_TIMEOUT: return "SL_ZIGBEE_EZSP_CONFIG_END_DEVICE_POLL_TIMEOUT";
    case SL_ZIGBEE_EZSP_CONFIG_TX_POWER_MODE: return "SL_ZIGBEE_EZSP_CONFIG_TX_POWER_MODE";
    case SL_ZIGBEE_EZSP_CONFIG_DISABLE_RELAY: return "SL_ZIGBEE_EZSP_CONFIG_DISABLE_RELAY";
    case SL_ZIGBEE_EZSP_CONFIG_TRUST_CENTER_ADDRESS_CACHE_SIZE: return "SL_ZIGBEE_EZSP_CONFIG_TRUST_CENTER_ADDRESS_CACHE_SIZE";
    case SL_ZIGBEE_EZSP_CONFIG_SOURCE_ROUTE_TABLE_SIZE: return "SL_ZIGBEE_EZSP_CONFIG_SOURCE_ROUTE_TABLE_SIZE";
    case SL_ZIGBEE_EZSP_CONFIG_FRAGMENT_WINDOW_SIZE: return "SL_ZIGBEE_EZSP_CONFIG_FRAGMENT_WINDOW_SIZE";
    case SL_ZIGBEE_EZSP_CONFIG_FRAGMENT_DELAY_MS: return "SL_ZIGBEE_EZSP_CONFIG_FRAGMENT_DELAY_MS";
    case SL_ZIGBEE_EZSP_CONFIG_KEY_TABLE_SIZE: return "SL_ZIGBEE_EZSP_CONFIG_KEY_TABLE_SIZE";
    case SL_ZIGBEE_EZSP_CONFIG_APS_ACK_TIMEOUT: return "SL_ZIGBEE_EZSP_CONFIG_APS_ACK_TIMEOUT";
    case SL_ZIGBEE_EZSP_CONFIG_BEACON_JITTER_DURATION: return "SL_ZIGBEE_EZSP_CONFIG_BEACON_JITTER_DURATION";
    case SL_ZIGBEE_EZSP_CONFIG_PAN_ID_CONFLICT_REPORT_THRESHOLD: return "SL_ZIGBEE_EZSP_CONFIG_PAN_ID_CONFLICT_REPORT_THRESHOLD";
    case SL_ZIGBEE_EZSP_CONFIG_REQUEST_KEY_TIMEOUT: return "SL_ZIGBEE_EZSP_CONFIG_REQUEST_KEY_TIMEOUT";
    case SL_ZIGBEE_EZSP_CONFIG_CERTIFICATE_TABLE_SIZE: return "SL_ZIGBEE_EZSP_CONFIG_CERTIFICATE_TABLE_SIZE";
    case SL_ZIGBEE_EZSP_CONFIG_APPLICATION_ZDO_FLAGS: return "SL_ZIGBEE_EZSP_CONFIG_APPLICATION_ZDO_FLAGS";
    case SL_ZIGBEE_EZSP_CONFIG_BROADCAST_TABLE_SIZE: return "SL_ZIGBEE_EZSP_CONFIG_BROADCAST_TABLE_SIZE";
    case SL_ZIGBEE_EZSP_CONFIG_MAC_FILTER_TABLE_SIZE: return "SL_ZIGBEE_EZSP_CONFIG_MAC_FILTER_TABLE_SIZE";
    case SL_ZIGBEE_EZSP_CONFIG_SUPPORTED_NETWORKS: return "SL_ZIGBEE_EZSP_CONFIG_SUPPORTED_NETWORKS";
    case SL_ZIGBEE_EZSP_CONFIG_SEND_MULTICASTS_TO_SLEEPY_ADDRESS: return "SL_ZIGBEE_EZSP_CONFIG_SEND_MULTICASTS_TO_SLEEPY_ADDRESS";
    case SL_ZIGBEE_EZSP_CONFIG_ZLL_GROUP_ADDRESSES: return "SL_ZIGBEE_EZSP_CONFIG_ZLL_GROUP_ADDRESSES";
    case SL_ZIGBEE_EZSP_CONFIG_ZLL_RSSI_THRESHOLD: return "SL_ZIGBEE_EZSP_CONFIG_ZLL_RSSI_THRESHOLD";
    case SL_ZIGBEE_EZSP_CONFIG_MTORR_FLOW_CONTROL: return "SL_ZIGBEE_EZSP_CONFIG_MTORR_FLOW_CONTROL";
    case SL_ZIGBEE_EZSP_CONFIG_RETRY_QUEUE_SIZE: return "SL_ZIGBEE_EZSP_CONFIG_RETRY_QUEUE_SIZE";
    case SL_ZIGBEE_EZSP_CONFIG_NEW_BROADCAST_ENTRY_THRESHOLD: return "SL_ZIGBEE_EZSP_CONFIG_NEW_BROADCAST_ENTRY_THRESHOLD";
    case SL_ZIGBEE_EZSP_CONFIG_TRANSIENT_KEY_TIMEOUT_S: return "SL_ZIGBEE_EZSP_CONFIG_TRANSIENT_KEY_TIMEOUT_S";
    case SL_ZIGBEE_EZSP_CONFIG_BROADCAST_MIN_ACKS_NEEDED: return "SL_ZIGBEE_EZSP_CONFIG_BROADCAST_MIN_ACKS_NEEDED";
    case SL_ZIGBEE_EZSP_CONFIG_TC_REJOINS_USING_WELL_KNOWN_KEY_TIMEOUT_S: return "SL_ZIGBEE_EZSP_CONFIG_TC_REJOINS_USING_WELL_KNOWN_KEY_TIMEOUT_S";
    case SL_ZIGBEE_EZSP_CONFIG_CTUNE_VALUE: return "SL_ZIGBEE_EZSP_CONFIG_CTUNE_VALUE";
    case SL_ZIGBEE_EZSP_CONFIG_ASSUME_TC_CONCENTRATOR_TYPE: return "SL_ZIGBEE_EZSP_CONFIG_ASSUME_TC_CONCENTRATOR_TYPE";
    case SL_ZIGBEE_EZSP_CONFIG_GP_PROXY_TABLE_SIZE: return "SL_ZIGBEE_EZSP_CONFIG_GP_PROXY_TABLE_SIZE";
    case SL_ZIGBEE_EZSP_CONFIG_GP_SINK_TABLE_SIZE: return "SL_ZIGBEE_EZSP_CONFIG_GP_SINK_TABLE_SIZE";
    case SL_ZIGBEE_EZSP_CONFIG_END_DEVICE_CONFIGURATION: return "SL_ZIGBEE_EZSP_CONFIG_END_DEVICE_CONFIGURATION";
  }
  return "*** Not enumerated. ***";
}

const char *decode_sl_zigbee_ezsp_value_id_t(uint8_t value)
{
  switch (value) {
    case SL_ZIGBEE_EZSP_VALUE_TOKEN_STACK_NODE_DATA: return "SL_ZIGBEE_EZSP_VALUE_TOKEN_STACK_NODE_DATA";
    case SL_ZIGBEE_EZSP_VALUE_MAC_PASSTHROUGH_FLAGS: return "SL_ZIGBEE_EZSP_VALUE_MAC_PASSTHROUGH_FLAGS";
    case SL_ZIGBEE_EZSP_VALUE_EMBERNET_PASSTHROUGH_SOURCE_ADDRESS: return "SL_ZIGBEE_EZSP_VALUE_EMBERNET_PASSTHROUGH_SOURCE_ADDRESS";
    case SL_ZIGBEE_EZSP_VALUE_BUFFER_HEAP_FREE_SIZE: return "SL_ZIGBEE_EZSP_VALUE_BUFFER_HEAP_FREE_SIZE";
    case SL_ZIGBEE_EZSP_VALUE_UART_SYNCH_CALLBACKS: return "SL_ZIGBEE_EZSP_VALUE_UART_SYNCH_CALLBACKS";
    case SL_ZIGBEE_EZSP_VALUE_MAXIMUM_INCOMING_TRANSFER_SIZE: return "SL_ZIGBEE_EZSP_VALUE_MAXIMUM_INCOMING_TRANSFER_SIZE";
    case SL_ZIGBEE_EZSP_VALUE_MAXIMUM_OUTGOING_TRANSFER_SIZE: return "SL_ZIGBEE_EZSP_VALUE_MAXIMUM_OUTGOING_TRANSFER_SIZE";
    case SL_ZIGBEE_EZSP_VALUE_STACK_TOKEN_WRITING: return "SL_ZIGBEE_EZSP_VALUE_STACK_TOKEN_WRITING";
    case SL_ZIGBEE_EZSP_VALUE_STACK_IS_PERFORMING_REJOIN: return "SL_ZIGBEE_EZSP_VALUE_STACK_IS_PERFORMING_REJOIN";
    case SL_ZIGBEE_EZSP_VALUE_MAC_FILTER_LIST: return "SL_ZIGBEE_EZSP_VALUE_MAC_FILTER_LIST";
    case SL_ZIGBEE_EZSP_VALUE_EXTENDED_SECURITY_BITMASK: return "SL_ZIGBEE_EZSP_VALUE_EXTENDED_SECURITY_BITMASK";
    case SL_ZIGBEE_EZSP_VALUE_NODE_SHORT_ID: return "SL_ZIGBEE_EZSP_VALUE_NODE_SHORT_ID";
    case SL_ZIGBEE_EZSP_VALUE_DESCRIPTOR_CAPABILITY: return "SL_ZIGBEE_EZSP_VALUE_DESCRIPTOR_CAPABILITY";
    case SL_ZIGBEE_EZSP_VALUE_STACK_DEVICE_REQUEST_SEQUENCE_NUMBER: return "SL_ZIGBEE_EZSP_VALUE_STACK_DEVICE_REQUEST_SEQUENCE_NUMBER";
    case SL_ZIGBEE_EZSP_VALUE_RADIO_HOLD_OFF: return "SL_ZIGBEE_EZSP_VALUE_RADIO_HOLD_OFF";
    case SL_ZIGBEE_EZSP_VALUE_ENDPOINT_FLAGS: return "SL_ZIGBEE_EZSP_VALUE_ENDPOINT_FLAGS";
    case SL_ZIGBEE_EZSP_VALUE_MFG_SECURITY_CONFIG: return "SL_ZIGBEE_EZSP_VALUE_MFG_SECURITY_CONFIG";
    case SL_ZIGBEE_EZSP_VALUE_VERSION_INFO: return "SL_ZIGBEE_EZSP_VALUE_VERSION_INFO";
    case SL_ZIGBEE_EZSP_VALUE_LAST_REJOIN_REASON: return "SL_ZIGBEE_EZSP_VALUE_LAST_REJOIN_REASON";
    case SL_ZIGBEE_EZSP_VALUE_NEXT_ZIGBEE_SEQUENCE_NUMBER: return "SL_ZIGBEE_EZSP_VALUE_NEXT_ZIGBEE_SEQUENCE_NUMBER";
    case SL_ZIGBEE_EZSP_VALUE_CCA_THRESHOLD: return "SL_ZIGBEE_EZSP_VALUE_CCA_THRESHOLD";
    case SL_ZIGBEE_EZSP_VALUE_SET_COUNTER_THRESHOLD: return "SL_ZIGBEE_EZSP_VALUE_SET_COUNTER_THRESHOLD";
    case SL_ZIGBEE_EZSP_VALUE_RESET_COUNTER_THRESHOLDS: return "SL_ZIGBEE_EZSP_VALUE_RESET_COUNTER_THRESHOLDS";
    case SL_ZIGBEE_EZSP_VALUE_CLEAR_COUNTERS: return "SL_ZIGBEE_EZSP_VALUE_CLEAR_COUNTERS";
    case SL_ZIGBEE_EZSP_VALUE_CERTIFICATE_283K1: return "SL_ZIGBEE_EZSP_VALUE_CERTIFICATE_283K1";
    case SL_ZIGBEE_EZSP_VALUE_PUBLIC_KEY_283K1: return "SL_ZIGBEE_EZSP_VALUE_PUBLIC_KEY_283K1";
    case SL_ZIGBEE_EZSP_VALUE_PRIVATE_KEY_283K1: return "SL_ZIGBEE_EZSP_VALUE_PRIVATE_KEY_283K1";
    case SL_ZIGBEE_EZSP_VALUE_NWK_FRAME_COUNTER: return "SL_ZIGBEE_EZSP_VALUE_NWK_FRAME_COUNTER";
    case SL_ZIGBEE_EZSP_VALUE_APS_FRAME_COUNTER: return "SL_ZIGBEE_EZSP_VALUE_APS_FRAME_COUNTER";
    case SL_ZIGBEE_EZSP_VALUE_RETRY_DEVICE_TYPE: return "SL_ZIGBEE_EZSP_VALUE_RETRY_DEVICE_TYPE";
    case SL_ZIGBEE_EZSP_VALUE_ENABLE_R21_BEHAVIOR: return "SL_ZIGBEE_EZSP_VALUE_ENABLE_R21_BEHAVIOR";
    case SL_ZIGBEE_EZSP_VALUE_ANTENNA_MODE: return "SL_ZIGBEE_EZSP_VALUE_ANTENNA_MODE";
    case SL_ZIGBEE_EZSP_VALUE_ENABLE_PTA: return "SL_ZIGBEE_EZSP_VALUE_ENABLE_PTA";
    case SL_ZIGBEE_EZSP_VALUE_PTA_OPTIONS: return "SL_ZIGBEE_EZSP_VALUE_PTA_OPTIONS";
    case SL_ZIGBEE_EZSP_VALUE_MFGLIB_OPTIONS: return "SL_ZIGBEE_EZSP_VALUE_MFGLIB_OPTIONS";
    case SL_ZIGBEE_EZSP_VALUE_USE_NEGOTIATED_POWER_BY_LPD: return "SL_ZIGBEE_EZSP_VALUE_USE_NEGOTIATED_POWER_BY_LPD";
    case SL_ZIGBEE_EZSP_VALUE_PTA_PWM_OPTIONS: return "SL_ZIGBEE_EZSP_VALUE_PTA_PWM_OPTIONS";
    case SL_ZIGBEE_EZSP_VALUE_PTA_DIRECTIONAL_PRIORITY_PULSE_WIDTH: return "SL_ZIGBEE_EZSP_VALUE_PTA_DIRECTIONAL_PRIORITY_PULSE_WIDTH";
    case SL_ZIGBEE_EZSP_VALUE_PTA_PHY_SELECT_TIMEOUT: return "SL_ZIGBEE_EZSP_VALUE_PTA_PHY_SELECT_TIMEOUT";
    case SL_ZIGBEE_EZSP_VALUE_ANTENNA_RX_MODE: return "SL_ZIGBEE_EZSP_VALUE_ANTENNA_RX_MODE";
    case SL_ZIGBEE_EZSP_VALUE_NWK_KEY_TIMEOUT: return "SL_ZIGBEE_EZSP_VALUE_NWK_KEY_TIMEOUT";
    case SL_ZIGBEE_EZSP_VALUE_FORCE_TX_AFTER_FAILED_CCA_ATTEMPTS: return "SL_ZIGBEE_EZSP_VALUE_FORCE_TX_AFTER_FAILED_CCA_ATTEMPTS";
    case SL_ZIGBEE_EZSP_VALUE_TRANSIENT_KEY_TIMEOUT_S: return "SL_ZIGBEE_EZSP_VALUE_TRANSIENT_KEY_TIMEOUT_S";
    case SL_ZIGBEE_EZSP_VALUE_COULOMB_COUNTER_USAGE: return "SL_ZIGBEE_EZSP_VALUE_COULOMB_COUNTER_USAGE";
    case SL_ZIGBEE_EZSP_VALUE_MAX_BEACONS_TO_STORE: return "SL_ZIGBEE_EZSP_VALUE_MAX_BEACONS_TO_STORE";
    case SL_ZIGBEE_EZSP_VALUE_END_DEVICE_TIMEOUT_OPTIONS_MASK: return "SL_ZIGBEE_EZSP_VALUE_END_DEVICE_TIMEOUT_OPTIONS_MASK";
    case SL_ZIGBEE_EZSP_VALUE_END_DEVICE_KEEP_ALIVE_SUPPORT_MODE: return "SL_ZIGBEE_EZSP_VALUE_END_DEVICE_KEEP_ALIVE_SUPPORT_MODE";
    case SL_ZIGBEE_EZSP_VALUE_ACTIVE_RADIO_CONFIG: return "SL_ZIGBEE_EZSP_VALUE_ACTIVE_RADIO_CONFIG";
    case SL_ZIGBEE_EZSP_VALUE_NWK_OPEN_DURATION: return "SL_ZIGBEE_EZSP_VALUE_NWK_OPEN_DURATION";
    case SL_ZIGBEE_EZSP_VALUE_TRANSIENT_DEVICE_TIMEOUT: return "SL_ZIGBEE_EZSP_VALUE_TRANSIENT_DEVICE_TIMEOUT";
    case SL_ZIGBEE_EZSP_VALUE_KEY_STORAGE_VERSION: return "SL_ZIGBEE_EZSP_VALUE_KEY_STORAGE_VERSION";
    case SL_ZIGBEE_EZSP_VALUE_DELAYED_JOIN_ACTIVATION: return "SL_ZIGBEE_EZSP_VALUE_DELAYED_JOIN_ACTIVATION";
    case SL_ZIGBEE_EZSP_VALUE_MAX_NWK_RETRIES: return "SL_ZIGBEE_EZSP_VALUE_MAX_NWK_RETRIES";
    case SL_ZIGBEE_EZSP_VALUE_REJOIN_MODE: return "SL_ZIGBEE_EZSP_VALUE_REJOIN_MODE";
    case SL_ZIGBEE_EZSP_VALUE_JOIN_USE_INSTALL_CODE_ENABLE: return "SL_ZIGBEE_EZSP_VALUE_JOIN_USE_INSTALL_CODE_ENABLE";
  }
  return "*** Not enumerated. ***";
}

const char *decode_sl_zigbee_ezsp_extended_value_id_t(uint8_t value)
{
  switch (value) {
    case SL_ZIGBEE_EZSP_EXTENDED_VALUE_ENDPOINT_FLAGS: return "SL_ZIGBEE_EZSP_EXTENDED_VALUE_ENDPOINT_FLAGS";
    case SL_ZIGBEE_EZSP_EXTENDED_VALUE_LAST_LEAVE_REASON: return "SL_ZIGBEE_EZSP_EXTENDED_VALUE_LAST_LEAVE_REASON";
    case SL_ZIGBEE_EZSP_EXTENDED_VALUE_GET_SOURCE_ROUTE_OVERHEAD: return "SL_ZIGBEE_EZSP_EXTENDED_VALUE_GET_SOURCE_ROUTE_OVERHEAD";
    case SL_ZIGBEE_EZSP_EXTENDED_VALUE_MEMORY_USAGE_DATA: return "SL_ZIGBEE_EZSP_EXTENDED_VALUE_MEMORY_USAGE_DATA";
  }
  return "*** Not enumerated. ***";
}

const char *decode_sl_zigbee_ezsp_endpoint_flags_t(uint16_t value)
{
  switch (value) {
    case SL_ZIGBEE_EZSP_ENDPOINT_DISABLED: return "SL_ZIGBEE_EZSP_ENDPOINT_DISABLED";
    case SL_ZIGBEE_EZSP_ENDPOINT_ENABLED: return "SL_ZIGBEE_EZSP_ENDPOINT_ENABLED";
  }
  return "*** Not enumerated. ***";
}

const char *decode_sl_zigbee_ezsp_policy_id_t(uint8_t value)
{
  switch (value) {
    case SL_ZIGBEE_EZSP_TRUST_CENTER_POLICY: return "SL_ZIGBEE_EZSP_TRUST_CENTER_POLICY";
    case SL_ZIGBEE_EZSP_BINDING_MODIFICATION_POLICY: return "SL_ZIGBEE_EZSP_BINDING_MODIFICATION_POLICY";
    case SL_ZIGBEE_EZSP_UNICAST_REPLIES_POLICY: return "SL_ZIGBEE_EZSP_UNICAST_REPLIES_POLICY";
    case SL_ZIGBEE_EZSP_POLL_HANDLER_POLICY: return "SL_ZIGBEE_EZSP_POLL_HANDLER_POLICY";
    case SL_ZIGBEE_EZSP_MESSAGE_CONTENTS_IN_CALLBACK_POLICY: return "SL_ZIGBEE_EZSP_MESSAGE_CONTENTS_IN_CALLBACK_POLICY";
    case SL_ZIGBEE_EZSP_TC_KEY_REQUEST_POLICY: return "SL_ZIGBEE_EZSP_TC_KEY_REQUEST_POLICY";
    case SL_ZIGBEE_EZSP_APP_KEY_REQUEST_POLICY: return "SL_ZIGBEE_EZSP_APP_KEY_REQUEST_POLICY";
    case SL_ZIGBEE_EZSP_PACKET_VALIDATE_LIBRARY_POLICY: return "SL_ZIGBEE_EZSP_PACKET_VALIDATE_LIBRARY_POLICY";
    case SL_ZIGBEE_EZSP_ZLL_POLICY: return "SL_ZIGBEE_EZSP_ZLL_POLICY";
    case SL_ZIGBEE_EZSP_TC_REJOINS_USING_WELL_KNOWN_KEY_POLICY: return "SL_ZIGBEE_EZSP_TC_REJOINS_USING_WELL_KNOWN_KEY_POLICY";
  }
  return "*** Not enumerated. ***";
}

const char *decode_sl_zigbee_ezsp_decision_bitmask_t(uint16_t value)
{
  switch (value) {
    case SL_ZIGBEE_EZSP_DECISION_BITMASK_DEFAULT_CONFIGURATION: return "SL_ZIGBEE_EZSP_DECISION_BITMASK_DEFAULT_CONFIGURATION";
    case SL_ZIGBEE_EZSP_DECISION_ALLOW_JOINS: return "SL_ZIGBEE_EZSP_DECISION_ALLOW_JOINS";
    case SL_ZIGBEE_EZSP_DECISION_ALLOW_UNSECURED_REJOINS: return "SL_ZIGBEE_EZSP_DECISION_ALLOW_UNSECURED_REJOINS";
    case SL_ZIGBEE_EZSP_DECISION_SEND_KEY_IN_CLEAR: return "SL_ZIGBEE_EZSP_DECISION_SEND_KEY_IN_CLEAR";
    case SL_ZIGBEE_EZSP_DECISION_IGNORE_UNSECURED_REJOINS: return "SL_ZIGBEE_EZSP_DECISION_IGNORE_UNSECURED_REJOINS";
    case SL_ZIGBEE_EZSP_DECISION_JOINS_USE_INSTALL_CODE_KEY: return "SL_ZIGBEE_EZSP_DECISION_JOINS_USE_INSTALL_CODE_KEY";
    case SL_ZIGBEE_EZSP_DECISION_DEFER_JOINS: return "SL_ZIGBEE_EZSP_DECISION_DEFER_JOINS";
  }
  return "*** Not enumerated. ***";
}

const char *decode_sl_zigbee_ezsp_decision_id_t(uint8_t value)
{
  switch (value) {
    case SL_ZIGBEE_EZSP_DISALLOW_BINDING_MODIFICATION: return "SL_ZIGBEE_EZSP_DISALLOW_BINDING_MODIFICATION";
    case SL_ZIGBEE_EZSP_ALLOW_BINDING_MODIFICATION: return "SL_ZIGBEE_EZSP_ALLOW_BINDING_MODIFICATION";
    case SL_ZIGBEE_EZSP_CHECK_BINDING_MODIFICATIONS_ARE_VALID_ENDPOINT_CLUSTERS: return "SL_ZIGBEE_EZSP_CHECK_BINDING_MODIFICATIONS_ARE_VALID_ENDPOINT_CLUSTERS";
    case SL_ZIGBEE_EZSP_HOST_WILL_NOT_SUPPLY_REPLY: return "SL_ZIGBEE_EZSP_HOST_WILL_NOT_SUPPLY_REPLY";
    case SL_ZIGBEE_EZSP_HOST_WILL_SUPPLY_REPLY: return "SL_ZIGBEE_EZSP_HOST_WILL_SUPPLY_REPLY";
    case SL_ZIGBEE_EZSP_POLL_HANDLER_IGNORE: return "SL_ZIGBEE_EZSP_POLL_HANDLER_IGNORE";
    case SL_ZIGBEE_EZSP_POLL_HANDLER_CALLBACK: return "SL_ZIGBEE_EZSP_POLL_HANDLER_CALLBACK";
    case SL_ZIGBEE_EZSP_MESSAGE_TAG_ONLY_IN_CALLBACK: return "SL_ZIGBEE_EZSP_MESSAGE_TAG_ONLY_IN_CALLBACK";
    case SL_ZIGBEE_EZSP_MESSAGE_TAG_AND_CONTENTS_IN_CALLBACK: return "SL_ZIGBEE_EZSP_MESSAGE_TAG_AND_CONTENTS_IN_CALLBACK";
    case SL_ZIGBEE_EZSP_DENY_TC_KEY_REQUESTS: return "SL_ZIGBEE_EZSP_DENY_TC_KEY_REQUESTS";
    case SL_ZIGBEE_EZSP_ALLOW_TC_KEY_REQUESTS_AND_SEND_CURRENT_KEY: return "SL_ZIGBEE_EZSP_ALLOW_TC_KEY_REQUESTS_AND_SEND_CURRENT_KEY";
    case SL_ZIGBEE_EZSP_ALLOW_TC_KEY_REQUEST_AND_GENERATE_NEW_KEY: return "SL_ZIGBEE_EZSP_ALLOW_TC_KEY_REQUEST_AND_GENERATE_NEW_KEY";
    case SL_ZIGBEE_EZSP_DENY_APP_KEY_REQUESTS: return "SL_ZIGBEE_EZSP_DENY_APP_KEY_REQUESTS";
    case SL_ZIGBEE_EZSP_ALLOW_APP_KEY_REQUESTS: return "SL_ZIGBEE_EZSP_ALLOW_APP_KEY_REQUESTS";
    case SL_ZIGBEE_EZSP_PACKET_VALIDATE_LIBRARY_CHECKS_ENABLED: return "SL_ZIGBEE_EZSP_PACKET_VALIDATE_LIBRARY_CHECKS_ENABLED";
    case SL_ZIGBEE_EZSP_PACKET_VALIDATE_LIBRARY_CHECKS_DISABLED: return "SL_ZIGBEE_EZSP_PACKET_VALIDATE_LIBRARY_CHECKS_DISABLED";
  }
  return "*** Not enumerated. ***";
}

const char *decode_sl_zigbee_ezsp_mfg_token_id_t(uint8_t value)
{
  switch (value) {
    case SL_ZIGBEE_EZSP_MFG_CUSTOM_VERSION: return "SL_ZIGBEE_EZSP_MFG_CUSTOM_VERSION";
    case SL_ZIGBEE_EZSP_MFG_STRING: return "SL_ZIGBEE_EZSP_MFG_STRING";
    case SL_ZIGBEE_EZSP_MFG_BOARD_NAME: return "SL_ZIGBEE_EZSP_MFG_BOARD_NAME";
    case SL_ZIGBEE_EZSP_MFG_MANUF_ID: return "SL_ZIGBEE_EZSP_MFG_MANUF_ID";
    case SL_ZIGBEE_EZSP_MFG_PHY_CONFIG: return "SL_ZIGBEE_EZSP_MFG_PHY_CONFIG";
    case SL_ZIGBEE_EZSP_MFG_BOOTLOAD_AES_KEY: return "SL_ZIGBEE_EZSP_MFG_BOOTLOAD_AES_KEY";
    case SL_ZIGBEE_EZSP_MFG_ASH_CONFIG: return "SL_ZIGBEE_EZSP_MFG_ASH_CONFIG";
    case SL_ZIGBEE_EZSP_MFG_SL_ZIGBEE_EZSP_STORAGE: return "SL_ZIGBEE_EZSP_MFG_SL_ZIGBEE_EZSP_STORAGE";
    case SL_ZIGBEE_EZSP_STACK_CAL_DATA: return "SL_ZIGBEE_EZSP_STACK_CAL_DATA";
    case SL_ZIGBEE_EZSP_MFG_CBKE_DATA: return "SL_ZIGBEE_EZSP_MFG_CBKE_DATA";
    case SL_ZIGBEE_EZSP_MFG_INSTALLATION_CODE: return "SL_ZIGBEE_EZSP_MFG_INSTALLATION_CODE";
    case SL_ZIGBEE_EZSP_STACK_CAL_FILTER: return "SL_ZIGBEE_EZSP_STACK_CAL_FILTER";
    case SL_ZIGBEE_EZSP_MFG_CUSTOM_EUI_64: return "SL_ZIGBEE_EZSP_MFG_CUSTOM_EUI_64";
    case SL_ZIGBEE_EZSP_MFG_CTUNE: return "SL_ZIGBEE_EZSP_MFG_CTUNE";
  }
  return "*** Not enumerated. ***";
}

const char *decode_sl_zigbee_ezsp_status_t(uint8_t value)
{
  switch (value) {
    case SL_ZIGBEE_EZSP_SUCCESS: return "SL_ZIGBEE_EZSP_SUCCESS";
    case SL_ZIGBEE_EZSP_SPI_ERR_FATAL: return "SL_ZIGBEE_EZSP_SPI_ERR_FATAL";
    case SL_ZIGBEE_EZSP_SPI_ERR_NCP_RESET: return "SL_ZIGBEE_EZSP_SPI_ERR_NCP_RESET";
    case SL_ZIGBEE_EZSP_SPI_ERR_OVERSIZED_SL_ZIGBEE_EZSP_FRAME: return "SL_ZIGBEE_EZSP_SPI_ERR_OVERSIZED_SL_ZIGBEE_EZSP_FRAME";
    case SL_ZIGBEE_EZSP_SPI_ERR_ABORTED_TRANSACTION: return "SL_ZIGBEE_EZSP_SPI_ERR_ABORTED_TRANSACTION";
    case SL_ZIGBEE_EZSP_SPI_ERR_MISSING_FRAME_TERMINATOR: return "SL_ZIGBEE_EZSP_SPI_ERR_MISSING_FRAME_TERMINATOR";
    case SL_ZIGBEE_EZSP_SPI_ERR_WAIT_SECTION_TIMEOUT: return "SL_ZIGBEE_EZSP_SPI_ERR_WAIT_SECTION_TIMEOUT";
    case SL_ZIGBEE_EZSP_SPI_ERR_NO_FRAME_TERMINATOR: return "SL_ZIGBEE_EZSP_SPI_ERR_NO_FRAME_TERMINATOR";
    case SL_ZIGBEE_EZSP_SPI_ERR_SL_ZIGBEE_EZSP_COMMAND_OVERSIZED: return "SL_ZIGBEE_EZSP_SPI_ERR_SL_ZIGBEE_EZSP_COMMAND_OVERSIZED";
    case SL_ZIGBEE_EZSP_SPI_ERR_SL_ZIGBEE_EZSP_RESPONSE_OVERSIZED: return "SL_ZIGBEE_EZSP_SPI_ERR_SL_ZIGBEE_EZSP_RESPONSE_OVERSIZED";
    case SL_ZIGBEE_EZSP_SPI_WAITING_FOR_RESPONSE: return "SL_ZIGBEE_EZSP_SPI_WAITING_FOR_RESPONSE";
    case SL_ZIGBEE_EZSP_SPI_ERR_HANDSHAKE_TIMEOUT: return "SL_ZIGBEE_EZSP_SPI_ERR_HANDSHAKE_TIMEOUT";
    case SL_ZIGBEE_EZSP_SPI_ERR_STARTUP_TIMEOUT: return "SL_ZIGBEE_EZSP_SPI_ERR_STARTUP_TIMEOUT";
    case SL_ZIGBEE_EZSP_SPI_ERR_STARTUP_FAIL: return "SL_ZIGBEE_EZSP_SPI_ERR_STARTUP_FAIL";
    case SL_ZIGBEE_EZSP_SPI_ERR_UNSUPPORTED_SPI_COMMAND: return "SL_ZIGBEE_EZSP_SPI_ERR_UNSUPPORTED_SPI_COMMAND";
    case SL_ZIGBEE_EZSP_ASH_IN_PROGRESS: return "SL_ZIGBEE_EZSP_ASH_IN_PROGRESS";
    case SL_ZIGBEE_EZSP_HOST_FATAL_ERROR: return "SL_ZIGBEE_EZSP_HOST_FATAL_ERROR";
    case SL_ZIGBEE_EZSP_ASH_NCP_FATAL_ERROR: return "SL_ZIGBEE_EZSP_ASH_NCP_FATAL_ERROR";
    case SL_ZIGBEE_EZSP_DATA_FRAME_TOO_LONG: return "SL_ZIGBEE_EZSP_DATA_FRAME_TOO_LONG";
    case SL_ZIGBEE_EZSP_DATA_FRAME_TOO_SHORT: return "SL_ZIGBEE_EZSP_DATA_FRAME_TOO_SHORT";
    case SL_ZIGBEE_EZSP_NO_TX_SPACE: return "SL_ZIGBEE_EZSP_NO_TX_SPACE";
    case SL_ZIGBEE_EZSP_NO_RX_SPACE: return "SL_ZIGBEE_EZSP_NO_RX_SPACE";
    case SL_ZIGBEE_EZSP_NO_RX_DATA: return "SL_ZIGBEE_EZSP_NO_RX_DATA";
    case SL_ZIGBEE_EZSP_NOT_CONNECTED: return "SL_ZIGBEE_EZSP_NOT_CONNECTED";
    case SL_ZIGBEE_EZSP_ERROR_VERSION_NOT_SET: return "SL_ZIGBEE_EZSP_ERROR_VERSION_NOT_SET";
    case SL_ZIGBEE_EZSP_ERROR_INVALID_FRAME_ID: return "SL_ZIGBEE_EZSP_ERROR_INVALID_FRAME_ID";
    case SL_ZIGBEE_EZSP_ERROR_WRONG_DIRECTION: return "SL_ZIGBEE_EZSP_ERROR_WRONG_DIRECTION";
    case SL_ZIGBEE_EZSP_ERROR_TRUNCATED: return "SL_ZIGBEE_EZSP_ERROR_TRUNCATED";
    case SL_ZIGBEE_EZSP_ERROR_OVERFLOW: return "SL_ZIGBEE_EZSP_ERROR_OVERFLOW";
    case SL_ZIGBEE_EZSP_ERROR_OUT_OF_MEMORY: return "SL_ZIGBEE_EZSP_ERROR_OUT_OF_MEMORY";
    case SL_ZIGBEE_EZSP_ERROR_INVALID_VALUE: return "SL_ZIGBEE_EZSP_ERROR_INVALID_VALUE";
    case SL_ZIGBEE_EZSP_ERROR_INVALID_ID: return "SL_ZIGBEE_EZSP_ERROR_INVALID_ID";
    case SL_ZIGBEE_EZSP_ERROR_INVALID_CALL: return "SL_ZIGBEE_EZSP_ERROR_INVALID_CALL";
    case SL_ZIGBEE_EZSP_ERROR_NO_RESPONSE: return "SL_ZIGBEE_EZSP_ERROR_NO_RESPONSE";
    case SL_ZIGBEE_EZSP_ERROR_COMMAND_TOO_LONG: return "SL_ZIGBEE_EZSP_ERROR_COMMAND_TOO_LONG";
    case SL_ZIGBEE_EZSP_ERROR_QUEUE_FULL: return "SL_ZIGBEE_EZSP_ERROR_QUEUE_FULL";
    case SL_ZIGBEE_EZSP_ERROR_COMMAND_FILTERED: return "SL_ZIGBEE_EZSP_ERROR_COMMAND_FILTERED";
    case SL_ZIGBEE_EZSP_ERROR_SECURITY_KEY_ALREADY_SET: return "SL_ZIGBEE_EZSP_ERROR_SECURITY_KEY_ALREADY_SET";
    case SL_ZIGBEE_EZSP_ERROR_SECURITY_TYPE_INVALID: return "SL_ZIGBEE_EZSP_ERROR_SECURITY_TYPE_INVALID";
    case SL_ZIGBEE_EZSP_ERROR_SECURITY_PARAMETERS_INVALID: return "SL_ZIGBEE_EZSP_ERROR_SECURITY_PARAMETERS_INVALID";
    case SL_ZIGBEE_EZSP_ERROR_SECURITY_PARAMETERS_ALREADY_SET: return "SL_ZIGBEE_EZSP_ERROR_SECURITY_PARAMETERS_ALREADY_SET";
    case SL_ZIGBEE_EZSP_ERROR_SECURITY_KEY_NOT_SET: return "SL_ZIGBEE_EZSP_ERROR_SECURITY_KEY_NOT_SET";
    case SL_ZIGBEE_EZSP_ERROR_SECURITY_PARAMETERS_NOT_SET: return "SL_ZIGBEE_EZSP_ERROR_SECURITY_PARAMETERS_NOT_SET";
    case SL_ZIGBEE_EZSP_ERROR_UNSUPPORTED_CONTROL: return "SL_ZIGBEE_EZSP_ERROR_UNSUPPORTED_CONTROL";
    case SL_ZIGBEE_EZSP_ERROR_UNSECURE_FRAME: return "SL_ZIGBEE_EZSP_ERROR_UNSECURE_FRAME";
    case SL_ZIGBEE_EZSP_ASH_ERROR_VERSION: return "SL_ZIGBEE_EZSP_ASH_ERROR_VERSION";
    case SL_ZIGBEE_EZSP_ASH_ERROR_TIMEOUTS: return "SL_ZIGBEE_EZSP_ASH_ERROR_TIMEOUTS";
    case SL_ZIGBEE_EZSP_ASH_ERROR_RESET_FAIL: return "SL_ZIGBEE_EZSP_ASH_ERROR_RESET_FAIL";
    case SL_ZIGBEE_EZSP_ASH_ERROR_NCP_RESET: return "SL_ZIGBEE_EZSP_ASH_ERROR_NCP_RESET";
    case SL_ZIGBEE_EZSP_ERROR_SERIAL_INIT: return "SL_ZIGBEE_EZSP_ERROR_SERIAL_INIT";
    case SL_ZIGBEE_EZSP_ASH_ERROR_NCP_TYPE: return "SL_ZIGBEE_EZSP_ASH_ERROR_NCP_TYPE";
    case SL_ZIGBEE_EZSP_ASH_ERROR_RESET_METHOD: return "SL_ZIGBEE_EZSP_ASH_ERROR_RESET_METHOD";
    case SL_ZIGBEE_EZSP_ASH_ERROR_XON_XOFF: return "SL_ZIGBEE_EZSP_ASH_ERROR_XON_XOFF";
    case SL_ZIGBEE_EZSP_ASH_STARTED: return "SL_ZIGBEE_EZSP_ASH_STARTED";
    case SL_ZIGBEE_EZSP_ASH_CONNECTED: return "SL_ZIGBEE_EZSP_ASH_CONNECTED";
    case SL_ZIGBEE_EZSP_ASH_DISCONNECTED: return "SL_ZIGBEE_EZSP_ASH_DISCONNECTED";
    case SL_ZIGBEE_EZSP_ASH_ACK_TIMEOUT: return "SL_ZIGBEE_EZSP_ASH_ACK_TIMEOUT";
    case SL_ZIGBEE_EZSP_ASH_CANCELLED: return "SL_ZIGBEE_EZSP_ASH_CANCELLED";
    case SL_ZIGBEE_EZSP_ASH_OUT_OF_SEQUENCE: return "SL_ZIGBEE_EZSP_ASH_OUT_OF_SEQUENCE";
    case SL_ZIGBEE_EZSP_ASH_BAD_CRC: return "SL_ZIGBEE_EZSP_ASH_BAD_CRC";
    case SL_ZIGBEE_EZSP_ASH_COMM_ERROR: return "SL_ZIGBEE_EZSP_ASH_COMM_ERROR";
    case SL_ZIGBEE_EZSP_ASH_BAD_ACKNUM: return "SL_ZIGBEE_EZSP_ASH_BAD_ACKNUM";
    case SL_ZIGBEE_EZSP_ASH_TOO_SHORT: return "SL_ZIGBEE_EZSP_ASH_TOO_SHORT";
    case SL_ZIGBEE_EZSP_ASH_TOO_LONG: return "SL_ZIGBEE_EZSP_ASH_TOO_LONG";
    case SL_ZIGBEE_EZSP_ASH_BAD_CONTROL: return "SL_ZIGBEE_EZSP_ASH_BAD_CONTROL";
    case SL_ZIGBEE_EZSP_ASH_BAD_LENGTH: return "SL_ZIGBEE_EZSP_ASH_BAD_LENGTH";
    case SL_ZIGBEE_EZSP_ASH_ACK_RECEIVED: return "SL_ZIGBEE_EZSP_ASH_ACK_RECEIVED";
    case SL_ZIGBEE_EZSP_ASH_ACK_SENT: return "SL_ZIGBEE_EZSP_ASH_ACK_SENT";
    case SL_ZIGBEE_EZSP_ASH_NAK_RECEIVED: return "SL_ZIGBEE_EZSP_ASH_NAK_RECEIVED";
    case SL_ZIGBEE_EZSP_ASH_NAK_SENT: return "SL_ZIGBEE_EZSP_ASH_NAK_SENT";
    case SL_ZIGBEE_EZSP_ASH_RST_RECEIVED: return "SL_ZIGBEE_EZSP_ASH_RST_RECEIVED";
    case SL_ZIGBEE_EZSP_ASH_RST_SENT: return "SL_ZIGBEE_EZSP_ASH_RST_SENT";
    case SL_ZIGBEE_EZSP_ASH_STATUS: return "SL_ZIGBEE_EZSP_ASH_STATUS";
    case SL_ZIGBEE_EZSP_ASH_TX: return "SL_ZIGBEE_EZSP_ASH_TX";
    case SL_ZIGBEE_EZSP_ASH_RX: return "SL_ZIGBEE_EZSP_ASH_RX";
    case SL_ZIGBEE_EZSP_CPC_ERROR_INIT: return "SL_ZIGBEE_EZSP_CPC_ERROR_INIT";
    case SL_ZIGBEE_EZSP_NO_ERROR: return "SL_ZIGBEE_EZSP_NO_ERROR";
  }
  return "*** Not enumerated. ***";
}

const char *decode_sl_zigbee_ezsp_network_scan_type_t(uint8_t value)
{
  switch (value) {
    case SL_ZIGBEE_EZSP_ENERGY_SCAN: return "SL_ZIGBEE_EZSP_ENERGY_SCAN";
    case SL_ZIGBEE_EZSP_ACTIVE_SCAN: return "SL_ZIGBEE_EZSP_ACTIVE_SCAN";
  }
  return "*** Not enumerated. ***";
}

const char *decode_sl_zigbee_ezsp_zll_network_operation_t(uint8_t value)
{
  switch (value) {
    case SL_ZIGBEE_EZSP_ZLL_FORM_NETWORK: return "SL_ZIGBEE_EZSP_ZLL_FORM_NETWORK";
    case SL_ZIGBEE_EZSP_ZLL_JOIN_TARGET: return "SL_ZIGBEE_EZSP_ZLL_JOIN_TARGET";
  }
  return "*** Not enumerated. ***";
}

const char *decodeFrameId(uint16_t value)
{
  switch (value) {
// Configuration Frames
    case SL_ZIGBEE_EZSP_VERSION: return "SL_ZIGBEE_EZSP_VERSION";
    case SL_ZIGBEE_EZSP_GET_CONFIGURATION_VALUE: return "SL_ZIGBEE_EZSP_GET_CONFIGURATION_VALUE";
    case SL_ZIGBEE_EZSP_SET_CONFIGURATION_VALUE: return "SL_ZIGBEE_EZSP_SET_CONFIGURATION_VALUE";
    case SL_ZIGBEE_EZSP_READ_ATTRIBUTE: return "SL_ZIGBEE_EZSP_READ_ATTRIBUTE";
    case SL_ZIGBEE_EZSP_WRITE_ATTRIBUTE: return "SL_ZIGBEE_EZSP_WRITE_ATTRIBUTE";
    case SL_ZIGBEE_EZSP_ADD_ENDPOINT: return "SL_ZIGBEE_EZSP_ADD_ENDPOINT";
    case SL_ZIGBEE_EZSP_SET_POLICY: return "SL_ZIGBEE_EZSP_SET_POLICY";
    case SL_ZIGBEE_EZSP_GET_POLICY: return "SL_ZIGBEE_EZSP_GET_POLICY";
    case SL_ZIGBEE_EZSP_SEND_PAN_ID_UPDATE: return "SL_ZIGBEE_EZSP_SEND_PAN_ID_UPDATE";
    case SL_ZIGBEE_EZSP_GET_VALUE: return "SL_ZIGBEE_EZSP_GET_VALUE";
    case SL_ZIGBEE_EZSP_GET_EXTENDED_VALUE: return "SL_ZIGBEE_EZSP_GET_EXTENDED_VALUE";
    case SL_ZIGBEE_EZSP_SET_VALUE: return "SL_ZIGBEE_EZSP_SET_VALUE";
    case SL_ZIGBEE_EZSP_SET_PASSIVE_ACK_CONFIG: return "SL_ZIGBEE_EZSP_SET_PASSIVE_ACK_CONFIG";
    case SL_ZIGBEE_EZSP_SET_PENDING_NETWORK_UPDATE_PAN_ID: return "SL_ZIGBEE_EZSP_SET_PENDING_NETWORK_UPDATE_PAN_ID";
    case SL_ZIGBEE_EZSP_GET_ENDPOINT: return "SL_ZIGBEE_EZSP_GET_ENDPOINT";
    case SL_ZIGBEE_EZSP_GET_ENDPOINT_COUNT: return "SL_ZIGBEE_EZSP_GET_ENDPOINT_COUNT";
    case SL_ZIGBEE_EZSP_GET_ENDPOINT_DESCRIPTION: return "SL_ZIGBEE_EZSP_GET_ENDPOINT_DESCRIPTION";
    case SL_ZIGBEE_EZSP_GET_ENDPOINT_CLUSTER: return "SL_ZIGBEE_EZSP_GET_ENDPOINT_CLUSTER";

// Utilities Frames
    case SL_ZIGBEE_EZSP_NOP: return "SL_ZIGBEE_EZSP_NOP";
    case SL_ZIGBEE_EZSP_ECHO: return "SL_ZIGBEE_EZSP_ECHO";
    case SL_ZIGBEE_EZSP_INVALID_COMMAND: return "SL_ZIGBEE_EZSP_INVALID_COMMAND";
    case SL_ZIGBEE_EZSP_CALLBACK: return "SL_ZIGBEE_EZSP_CALLBACK";
    case SL_ZIGBEE_EZSP_NO_CALLBACKS: return "SL_ZIGBEE_EZSP_NO_CALLBACKS";
    case SL_ZIGBEE_EZSP_SET_TOKEN: return "SL_ZIGBEE_EZSP_SET_TOKEN";
    case SL_ZIGBEE_EZSP_GET_TOKEN: return "SL_ZIGBEE_EZSP_GET_TOKEN";
    case SL_ZIGBEE_EZSP_GET_MFG_TOKEN: return "SL_ZIGBEE_EZSP_GET_MFG_TOKEN";
    case SL_ZIGBEE_EZSP_SET_MFG_TOKEN: return "SL_ZIGBEE_EZSP_SET_MFG_TOKEN";
    case SL_ZIGBEE_EZSP_STACK_TOKEN_CHANGED_HANDLER: return "SL_ZIGBEE_EZSP_STACK_TOKEN_CHANGED_HANDLER";
    case SL_ZIGBEE_EZSP_GET_RANDOM_NUMBER: return "SL_ZIGBEE_EZSP_GET_RANDOM_NUMBER";
    case SL_ZIGBEE_EZSP_SET_TIMER: return "SL_ZIGBEE_EZSP_SET_TIMER";
    case SL_ZIGBEE_EZSP_GET_TIMER: return "SL_ZIGBEE_EZSP_GET_TIMER";
    case SL_ZIGBEE_EZSP_TIMER_HANDLER: return "SL_ZIGBEE_EZSP_TIMER_HANDLER";
    case SL_ZIGBEE_EZSP_DEBUG_WRITE: return "SL_ZIGBEE_EZSP_DEBUG_WRITE";
    case SL_ZIGBEE_EZSP_READ_AND_CLEAR_COUNTERS: return "SL_ZIGBEE_EZSP_READ_AND_CLEAR_COUNTERS";
    case SL_ZIGBEE_EZSP_READ_COUNTERS: return "SL_ZIGBEE_EZSP_READ_COUNTERS";
    case SL_ZIGBEE_EZSP_COUNTER_ROLLOVER_HANDLER: return "SL_ZIGBEE_EZSP_COUNTER_ROLLOVER_HANDLER";
    case SL_ZIGBEE_EZSP_MUX_INVALID_RX_HANDLER: return "SL_ZIGBEE_EZSP_MUX_INVALID_RX_HANDLER";
    case SL_ZIGBEE_EZSP_DELAY_TEST: return "SL_ZIGBEE_EZSP_DELAY_TEST";
    case SL_ZIGBEE_EZSP_GET_LIBRARY_STATUS: return "SL_ZIGBEE_EZSP_GET_LIBRARY_STATUS";
    case SL_ZIGBEE_EZSP_GET_XNCP_INFO: return "SL_ZIGBEE_EZSP_GET_XNCP_INFO";
    case SL_ZIGBEE_EZSP_CUSTOM_FRAME: return "SL_ZIGBEE_EZSP_CUSTOM_FRAME";
    case SL_ZIGBEE_EZSP_CUSTOM_FRAME_HANDLER: return "SL_ZIGBEE_EZSP_CUSTOM_FRAME_HANDLER";
    case SL_ZIGBEE_EZSP_GET_EUI64: return "SL_ZIGBEE_EZSP_GET_EUI64";
    case SL_ZIGBEE_EZSP_GET_NODE_ID: return "SL_ZIGBEE_EZSP_GET_NODE_ID";
    case SL_ZIGBEE_EZSP_GET_PHY_INTERFACE_COUNT: return "SL_ZIGBEE_EZSP_GET_PHY_INTERFACE_COUNT";
    case SL_ZIGBEE_EZSP_GET_TRUE_RANDOM_ENTROPY_SOURCE: return "SL_ZIGBEE_EZSP_GET_TRUE_RANDOM_ENTROPY_SOURCE";
    case SL_ZIGBEE_EZSP_SETUP_DELAYED_JOIN: return "SL_ZIGBEE_EZSP_SETUP_DELAYED_JOIN";
    case SL_ZIGBEE_EZSP_RADIO_GET_SCHEDULER_PRIORITIES: return "SL_ZIGBEE_EZSP_RADIO_GET_SCHEDULER_PRIORITIES";
    case SL_ZIGBEE_EZSP_RADIO_SET_SCHEDULER_PRIORITIES: return "SL_ZIGBEE_EZSP_RADIO_SET_SCHEDULER_PRIORITIES";
    case SL_ZIGBEE_EZSP_RADIO_GET_SCHEDULER_SLIPTIME: return "SL_ZIGBEE_EZSP_RADIO_GET_SCHEDULER_SLIPTIME";
    case SL_ZIGBEE_EZSP_RADIO_SET_SCHEDULER_SLIPTIME: return "SL_ZIGBEE_EZSP_RADIO_SET_SCHEDULER_SLIPTIME";
    case SL_ZIGBEE_EZSP_COUNTER_REQUIRES_PHY_INDEX: return "SL_ZIGBEE_EZSP_COUNTER_REQUIRES_PHY_INDEX";
    case SL_ZIGBEE_EZSP_COUNTER_REQUIRES_DESTINATION_NODE_ID: return "SL_ZIGBEE_EZSP_COUNTER_REQUIRES_DESTINATION_NODE_ID";

// Networking Frames
    case SL_ZIGBEE_EZSP_SET_MANUFACTURER_CODE: return "SL_ZIGBEE_EZSP_SET_MANUFACTURER_CODE";
    case SL_ZIGBEE_EZSP_GET_MANUFACTURER_CODE: return "SL_ZIGBEE_EZSP_GET_MANUFACTURER_CODE";
    case SL_ZIGBEE_EZSP_SET_POWER_DESCRIPTOR: return "SL_ZIGBEE_EZSP_SET_POWER_DESCRIPTOR";
    case SL_ZIGBEE_EZSP_NETWORK_INIT: return "SL_ZIGBEE_EZSP_NETWORK_INIT";
    case SL_ZIGBEE_EZSP_NETWORK_STATE: return "SL_ZIGBEE_EZSP_NETWORK_STATE";
    case SL_ZIGBEE_EZSP_STACK_STATUS_HANDLER: return "SL_ZIGBEE_EZSP_STACK_STATUS_HANDLER";
    case SL_ZIGBEE_EZSP_START_SCAN: return "SL_ZIGBEE_EZSP_START_SCAN";
    case SL_ZIGBEE_EZSP_ENERGY_SCAN_RESULT_HANDLER: return "SL_ZIGBEE_EZSP_ENERGY_SCAN_RESULT_HANDLER";
    case SL_ZIGBEE_EZSP_NETWORK_FOUND_HANDLER: return "SL_ZIGBEE_EZSP_NETWORK_FOUND_HANDLER";
    case SL_ZIGBEE_EZSP_SCAN_COMPLETE_HANDLER: return "SL_ZIGBEE_EZSP_SCAN_COMPLETE_HANDLER";
    case SL_ZIGBEE_EZSP_UNUSED_PAN_ID_FOUND_HANDLER: return "SL_ZIGBEE_EZSP_UNUSED_PAN_ID_FOUND_HANDLER";
    case SL_ZIGBEE_EZSP_FIND_UNUSED_PAN_ID: return "SL_ZIGBEE_EZSP_FIND_UNUSED_PAN_ID";
    case SL_ZIGBEE_EZSP_STOP_SCAN: return "SL_ZIGBEE_EZSP_STOP_SCAN";
    case SL_ZIGBEE_EZSP_FORM_NETWORK: return "SL_ZIGBEE_EZSP_FORM_NETWORK";
    case SL_ZIGBEE_EZSP_JOIN_NETWORK: return "SL_ZIGBEE_EZSP_JOIN_NETWORK";
    case SL_ZIGBEE_EZSP_JOIN_NETWORK_DIRECTLY: return "SL_ZIGBEE_EZSP_JOIN_NETWORK_DIRECTLY";
    case SL_ZIGBEE_EZSP_LEAVE_NETWORK: return "SL_ZIGBEE_EZSP_LEAVE_NETWORK";
    case SL_ZIGBEE_EZSP_FIND_AND_REJOIN_NETWORK: return "SL_ZIGBEE_EZSP_FIND_AND_REJOIN_NETWORK";
    case SL_ZIGBEE_EZSP_PERMIT_JOINING: return "SL_ZIGBEE_EZSP_PERMIT_JOINING";
    case SL_ZIGBEE_EZSP_CHILD_JOIN_HANDLER: return "SL_ZIGBEE_EZSP_CHILD_JOIN_HANDLER";
    case SL_ZIGBEE_EZSP_ENERGY_SCAN_REQUEST: return "SL_ZIGBEE_EZSP_ENERGY_SCAN_REQUEST";
    case SL_ZIGBEE_EZSP_GET_NETWORK_PARAMETERS: return "SL_ZIGBEE_EZSP_GET_NETWORK_PARAMETERS";
    case SL_ZIGBEE_EZSP_GET_RADIO_PARAMETERS: return "SL_ZIGBEE_EZSP_GET_RADIO_PARAMETERS";
    case SL_ZIGBEE_EZSP_GET_PARENT_CHILD_PARAMETERS: return "SL_ZIGBEE_EZSP_GET_PARENT_CHILD_PARAMETERS";
    case SL_ZIGBEE_EZSP_ROUTER_CHILD_COUNT: return "SL_ZIGBEE_EZSP_ROUTER_CHILD_COUNT";
    case SL_ZIGBEE_EZSP_MAX_CHILD_COUNT: return "SL_ZIGBEE_EZSP_MAX_CHILD_COUNT";
    case SL_ZIGBEE_EZSP_MAX_ROUTER_CHILD_COUNT: return "SL_ZIGBEE_EZSP_MAX_ROUTER_CHILD_COUNT";
    case SL_ZIGBEE_EZSP_GET_PARENT_INCOMING_NWK_FRAME_COUNTER: return "SL_ZIGBEE_EZSP_GET_PARENT_INCOMING_NWK_FRAME_COUNTER";
    case SL_ZIGBEE_EZSP_SET_PARENT_INCOMING_NWK_FRAME_COUNTER: return "SL_ZIGBEE_EZSP_SET_PARENT_INCOMING_NWK_FRAME_COUNTER";
    case SL_ZIGBEE_EZSP_CURRENT_STACK_TASKS: return "SL_ZIGBEE_EZSP_CURRENT_STACK_TASKS";
    case SL_ZIGBEE_EZSP_OK_TO_NAP: return "SL_ZIGBEE_EZSP_OK_TO_NAP";
    case SL_ZIGBEE_EZSP_PARENT_TOKEN_SET: return "SL_ZIGBEE_EZSP_PARENT_TOKEN_SET";
    case SL_ZIGBEE_EZSP_OK_TO_HIBERNATE: return "SL_ZIGBEE_EZSP_OK_TO_HIBERNATE";
    case SL_ZIGBEE_EZSP_OK_TO_LONG_POLL: return "SL_ZIGBEE_EZSP_OK_TO_LONG_POLL";
    case SL_ZIGBEE_EZSP_STACK_POWER_DOWN: return "SL_ZIGBEE_EZSP_STACK_POWER_DOWN";
    case SL_ZIGBEE_EZSP_STACK_POWER_UP: return "SL_ZIGBEE_EZSP_STACK_POWER_UP";
    case SL_ZIGBEE_EZSP_GET_CHILD_DATA: return "SL_ZIGBEE_EZSP_GET_CHILD_DATA";
    case SL_ZIGBEE_EZSP_SET_CHILD_DATA: return "SL_ZIGBEE_EZSP_SET_CHILD_DATA";
    case SL_ZIGBEE_EZSP_CHILD_ID: return "SL_ZIGBEE_EZSP_CHILD_ID";
    case SL_ZIGBEE_EZSP_CHILD_POWER: return "SL_ZIGBEE_EZSP_CHILD_POWER";
    case SL_ZIGBEE_EZSP_SET_CHILD_POWER: return "SL_ZIGBEE_EZSP_SET_CHILD_POWER";
    case SL_ZIGBEE_EZSP_CHILD_INDEX: return "SL_ZIGBEE_EZSP_CHILD_INDEX";
    case SL_ZIGBEE_EZSP_GET_SOURCE_ROUTE_TABLE_TOTAL_SIZE: return "SL_ZIGBEE_EZSP_GET_SOURCE_ROUTE_TABLE_TOTAL_SIZE";
    case SL_ZIGBEE_EZSP_GET_SOURCE_ROUTE_TABLE_FILLED_SIZE: return "SL_ZIGBEE_EZSP_GET_SOURCE_ROUTE_TABLE_FILLED_SIZE";
    case SL_ZIGBEE_EZSP_GET_SOURCE_ROUTE_TABLE_ENTRY: return "SL_ZIGBEE_EZSP_GET_SOURCE_ROUTE_TABLE_ENTRY";
    case SL_ZIGBEE_EZSP_GET_NEIGHBOR: return "SL_ZIGBEE_EZSP_GET_NEIGHBOR";
    case SL_ZIGBEE_EZSP_GET_NEIGHBOR_FRAME_COUNTER: return "SL_ZIGBEE_EZSP_GET_NEIGHBOR_FRAME_COUNTER";
    case SL_ZIGBEE_EZSP_SET_NEIGHBOR_FRAME_COUNTER: return "SL_ZIGBEE_EZSP_SET_NEIGHBOR_FRAME_COUNTER";
    case SL_ZIGBEE_EZSP_SET_ROUTING_SHORTCUT_THRESHOLD: return "SL_ZIGBEE_EZSP_SET_ROUTING_SHORTCUT_THRESHOLD";
    case SL_ZIGBEE_EZSP_GET_ROUTING_SHORTCUT_THRESHOLD: return "SL_ZIGBEE_EZSP_GET_ROUTING_SHORTCUT_THRESHOLD";
    case SL_ZIGBEE_EZSP_NEIGHBOR_COUNT: return "SL_ZIGBEE_EZSP_NEIGHBOR_COUNT";
    case SL_ZIGBEE_EZSP_GET_ROUTE_TABLE_ENTRY: return "SL_ZIGBEE_EZSP_GET_ROUTE_TABLE_ENTRY";
    case SL_ZIGBEE_EZSP_SET_RADIO_POWER: return "SL_ZIGBEE_EZSP_SET_RADIO_POWER";
    case SL_ZIGBEE_EZSP_SET_RADIO_CHANNEL: return "SL_ZIGBEE_EZSP_SET_RADIO_CHANNEL";
    case SL_ZIGBEE_EZSP_GET_RADIO_CHANNEL: return "SL_ZIGBEE_EZSP_GET_RADIO_CHANNEL";
    case SL_ZIGBEE_EZSP_SET_RADIO_IEEE802154_CCA_MODE: return "SL_ZIGBEE_EZSP_SET_RADIO_IEEE802154_CCA_MODE";
    case SL_ZIGBEE_EZSP_SET_CONCENTRATOR: return "SL_ZIGBEE_EZSP_SET_CONCENTRATOR";
    case SL_ZIGBEE_EZSP_CONCENTRATOR_START_DISCOVERY: return "SL_ZIGBEE_EZSP_CONCENTRATOR_START_DISCOVERY";
    case SL_ZIGBEE_EZSP_CONCENTRATOR_STOP_DISCOVERY: return "SL_ZIGBEE_EZSP_CONCENTRATOR_STOP_DISCOVERY";
    case SL_ZIGBEE_EZSP_CONCENTRATOR_NOTE_ROUTE_ERROR: return "SL_ZIGBEE_EZSP_CONCENTRATOR_NOTE_ROUTE_ERROR";
    case SL_ZIGBEE_EZSP_SET_BROKEN_ROUTE_ERROR_CODE: return "SL_ZIGBEE_EZSP_SET_BROKEN_ROUTE_ERROR_CODE";
    case SL_ZIGBEE_EZSP_MULTI_PHY_START: return "SL_ZIGBEE_EZSP_MULTI_PHY_START";
    case SL_ZIGBEE_EZSP_MULTI_PHY_STOP: return "SL_ZIGBEE_EZSP_MULTI_PHY_STOP";
    case SL_ZIGBEE_EZSP_MULTI_PHY_SET_RADIO_POWER: return "SL_ZIGBEE_EZSP_MULTI_PHY_SET_RADIO_POWER";
    case SL_ZIGBEE_EZSP_SEND_LINK_POWER_DELTA_REQUEST: return "SL_ZIGBEE_EZSP_SEND_LINK_POWER_DELTA_REQUEST";
    case SL_ZIGBEE_EZSP_MULTI_PHY_SET_RADIO_CHANNEL: return "SL_ZIGBEE_EZSP_MULTI_PHY_SET_RADIO_CHANNEL";
    case SL_ZIGBEE_EZSP_GET_DUTY_CYCLE_STATE: return "SL_ZIGBEE_EZSP_GET_DUTY_CYCLE_STATE";
    case SL_ZIGBEE_EZSP_SET_DUTY_CYCLE_LIMITS_IN_STACK: return "SL_ZIGBEE_EZSP_SET_DUTY_CYCLE_LIMITS_IN_STACK";
    case SL_ZIGBEE_EZSP_GET_DUTY_CYCLE_LIMITS: return "SL_ZIGBEE_EZSP_GET_DUTY_CYCLE_LIMITS";
    case SL_ZIGBEE_EZSP_GET_CURRENT_DUTY_CYCLE: return "SL_ZIGBEE_EZSP_GET_CURRENT_DUTY_CYCLE";
    case SL_ZIGBEE_EZSP_DUTY_CYCLE_HANDLER: return "SL_ZIGBEE_EZSP_DUTY_CYCLE_HANDLER";
    case SL_ZIGBEE_EZSP_SET_NUM_BEACONS_TO_STORE: return "SL_ZIGBEE_EZSP_SET_NUM_BEACONS_TO_STORE";
    case SL_ZIGBEE_EZSP_GET_STORED_BEACON: return "SL_ZIGBEE_EZSP_GET_STORED_BEACON";
    case SL_ZIGBEE_EZSP_GET_NUM_STORED_BEACONS: return "SL_ZIGBEE_EZSP_GET_NUM_STORED_BEACONS";
    case SL_ZIGBEE_EZSP_CLEAR_STORED_BEACONS: return "SL_ZIGBEE_EZSP_CLEAR_STORED_BEACONS";
    case SL_ZIGBEE_EZSP_SET_LOGICAL_AND_RADIO_CHANNEL: return "SL_ZIGBEE_EZSP_SET_LOGICAL_AND_RADIO_CHANNEL";
    case SL_ZIGBEE_EZSP_SLEEPY_TO_SLEEPY_NETWORK_START: return "SL_ZIGBEE_EZSP_SLEEPY_TO_SLEEPY_NETWORK_START";
    case SL_ZIGBEE_EZSP_SEND_ZIGBEE_LEAVE: return "SL_ZIGBEE_EZSP_SEND_ZIGBEE_LEAVE";
    case SL_ZIGBEE_EZSP_GET_PERMIT_JOINING: return "SL_ZIGBEE_EZSP_GET_PERMIT_JOINING";
    case SL_ZIGBEE_EZSP_GET_EXTENDED_PAN_ID: return "SL_ZIGBEE_EZSP_GET_EXTENDED_PAN_ID";
    case SL_ZIGBEE_EZSP_GET_CURRENT_NETWORK: return "SL_ZIGBEE_EZSP_GET_CURRENT_NETWORK";
    case SL_ZIGBEE_EZSP_SET_INITIAL_NEIGHBOR_OUTGOING_COST: return "SL_ZIGBEE_EZSP_SET_INITIAL_NEIGHBOR_OUTGOING_COST";
    case SL_ZIGBEE_EZSP_GET_INITIAL_NEIGHBOR_OUTGOING_COST: return "SL_ZIGBEE_EZSP_GET_INITIAL_NEIGHBOR_OUTGOING_COST";
    case SL_ZIGBEE_EZSP_RESET_REJOINING_NEIGHBORS_FRAME_COUNTER: return "SL_ZIGBEE_EZSP_RESET_REJOINING_NEIGHBORS_FRAME_COUNTER";
    case SL_ZIGBEE_EZSP_IS_RESET_REJOINING_NEIGHBORS_FRAME_COUNTER_ENABLED: return "SL_ZIGBEE_EZSP_IS_RESET_REJOINING_NEIGHBORS_FRAME_COUNTER_ENABLED";

// Binding Frames
    case SL_ZIGBEE_EZSP_CLEAR_BINDING_TABLE: return "SL_ZIGBEE_EZSP_CLEAR_BINDING_TABLE";
    case SL_ZIGBEE_EZSP_SET_BINDING: return "SL_ZIGBEE_EZSP_SET_BINDING";
    case SL_ZIGBEE_EZSP_GET_BINDING: return "SL_ZIGBEE_EZSP_GET_BINDING";
    case SL_ZIGBEE_EZSP_DELETE_BINDING: return "SL_ZIGBEE_EZSP_DELETE_BINDING";
    case SL_ZIGBEE_EZSP_BINDING_IS_ACTIVE: return "SL_ZIGBEE_EZSP_BINDING_IS_ACTIVE";
    case SL_ZIGBEE_EZSP_GET_BINDING_REMOTE_NODE_ID: return "SL_ZIGBEE_EZSP_GET_BINDING_REMOTE_NODE_ID";
    case SL_ZIGBEE_EZSP_SET_BINDING_REMOTE_NODE_ID: return "SL_ZIGBEE_EZSP_SET_BINDING_REMOTE_NODE_ID";
    case SL_ZIGBEE_EZSP_REMOTE_SET_BINDING_HANDLER: return "SL_ZIGBEE_EZSP_REMOTE_SET_BINDING_HANDLER";
    case SL_ZIGBEE_EZSP_REMOTE_DELETE_BINDING_HANDLER: return "SL_ZIGBEE_EZSP_REMOTE_DELETE_BINDING_HANDLER";

// Messaging Frames
    case SL_ZIGBEE_EZSP_MAXIMUM_PAYLOAD_LENGTH: return "SL_ZIGBEE_EZSP_MAXIMUM_PAYLOAD_LENGTH";
    case SL_ZIGBEE_EZSP_SEND_UNICAST: return "SL_ZIGBEE_EZSP_SEND_UNICAST";
    case SL_ZIGBEE_EZSP_SEND_BROADCAST: return "SL_ZIGBEE_EZSP_SEND_BROADCAST";
    case SL_ZIGBEE_EZSP_PROXY_NEXT_BROADCAST_FROM_LONG: return "SL_ZIGBEE_EZSP_PROXY_NEXT_BROADCAST_FROM_LONG";
    case SL_ZIGBEE_EZSP_SEND_MULTICAST: return "SL_ZIGBEE_EZSP_SEND_MULTICAST";
    case SL_ZIGBEE_EZSP_SEND_REPLY: return "SL_ZIGBEE_EZSP_SEND_REPLY";
    case SL_ZIGBEE_EZSP_MESSAGE_SENT_HANDLER: return "SL_ZIGBEE_EZSP_MESSAGE_SENT_HANDLER";
    case SL_ZIGBEE_EZSP_SEND_MANY_TO_ONE_ROUTE_REQUEST: return "SL_ZIGBEE_EZSP_SEND_MANY_TO_ONE_ROUTE_REQUEST";
    case SL_ZIGBEE_EZSP_POLL_FOR_DATA: return "SL_ZIGBEE_EZSP_POLL_FOR_DATA";
    case SL_ZIGBEE_EZSP_POLL_COMPLETE_HANDLER: return "SL_ZIGBEE_EZSP_POLL_COMPLETE_HANDLER";
    case SL_ZIGBEE_EZSP_SET_MESSAGE_FLAG: return "SL_ZIGBEE_EZSP_SET_MESSAGE_FLAG";
    case SL_ZIGBEE_EZSP_CLEAR_MESSAGE_FLAG: return "SL_ZIGBEE_EZSP_CLEAR_MESSAGE_FLAG";
    case SL_ZIGBEE_EZSP_POLL_HANDLER: return "SL_ZIGBEE_EZSP_POLL_HANDLER";
    case SL_ZIGBEE_EZSP_ADD_CHILD: return "SL_ZIGBEE_EZSP_ADD_CHILD";
    case SL_ZIGBEE_EZSP_REMOVE_CHILD: return "SL_ZIGBEE_EZSP_REMOVE_CHILD";
    case SL_ZIGBEE_EZSP_REMOVE_NEIGHBOR: return "SL_ZIGBEE_EZSP_REMOVE_NEIGHBOR";
    case SL_ZIGBEE_EZSP_INCOMING_MESSAGE_HANDLER: return "SL_ZIGBEE_EZSP_INCOMING_MESSAGE_HANDLER";
    case SL_ZIGBEE_EZSP_SET_SOURCE_ROUTE_DISCOVERY_MODE: return "SL_ZIGBEE_EZSP_SET_SOURCE_ROUTE_DISCOVERY_MODE";
    case SL_ZIGBEE_EZSP_INCOMING_MANY_TO_ONE_ROUTE_REQUEST_HANDLER: return "SL_ZIGBEE_EZSP_INCOMING_MANY_TO_ONE_ROUTE_REQUEST_HANDLER";
    case SL_ZIGBEE_EZSP_INCOMING_ROUTE_ERROR_HANDLER: return "SL_ZIGBEE_EZSP_INCOMING_ROUTE_ERROR_HANDLER";
    case SL_ZIGBEE_EZSP_INCOMING_NETWORK_STATUS_HANDLER: return "SL_ZIGBEE_EZSP_INCOMING_NETWORK_STATUS_HANDLER";
    case SL_ZIGBEE_EZSP_INCOMING_ROUTE_RECORD_HANDLER: return "SL_ZIGBEE_EZSP_INCOMING_ROUTE_RECORD_HANDLER";
    case SL_ZIGBEE_EZSP_SET_SOURCE_ROUTE: return "SL_ZIGBEE_EZSP_SET_SOURCE_ROUTE";
    case SL_ZIGBEE_EZSP_UNICAST_CURRENT_NETWORK_KEY: return "SL_ZIGBEE_EZSP_UNICAST_CURRENT_NETWORK_KEY";
    case SL_ZIGBEE_EZSP_ADDRESS_TABLE_ENTRY_IS_ACTIVE: return "SL_ZIGBEE_EZSP_ADDRESS_TABLE_ENTRY_IS_ACTIVE";
    case SL_ZIGBEE_EZSP_SET_ADDRESS_TABLE_INFO: return "SL_ZIGBEE_EZSP_SET_ADDRESS_TABLE_INFO";
    case SL_ZIGBEE_EZSP_GET_ADDRESS_TABLE_INFO: return "SL_ZIGBEE_EZSP_GET_ADDRESS_TABLE_INFO";
    case SL_ZIGBEE_EZSP_SET_EXTENDED_TIMEOUT: return "SL_ZIGBEE_EZSP_SET_EXTENDED_TIMEOUT";
    case SL_ZIGBEE_EZSP_GET_EXTENDED_TIMEOUT: return "SL_ZIGBEE_EZSP_GET_EXTENDED_TIMEOUT";
    case SL_ZIGBEE_EZSP_REPLACE_ADDRESS_TABLE_ENTRY: return "SL_ZIGBEE_EZSP_REPLACE_ADDRESS_TABLE_ENTRY";
    case SL_ZIGBEE_EZSP_LOOKUP_NODE_ID_BY_EUI64: return "SL_ZIGBEE_EZSP_LOOKUP_NODE_ID_BY_EUI64";
    case SL_ZIGBEE_EZSP_LOOKUP_EUI64_BY_NODE_ID: return "SL_ZIGBEE_EZSP_LOOKUP_EUI64_BY_NODE_ID";
    case SL_ZIGBEE_EZSP_GET_MULTICAST_TABLE_ENTRY: return "SL_ZIGBEE_EZSP_GET_MULTICAST_TABLE_ENTRY";
    case SL_ZIGBEE_EZSP_SET_MULTICAST_TABLE_ENTRY: return "SL_ZIGBEE_EZSP_SET_MULTICAST_TABLE_ENTRY";
    case SL_ZIGBEE_EZSP_ID_CONFLICT_HANDLER: return "SL_ZIGBEE_EZSP_ID_CONFLICT_HANDLER";
    case SL_ZIGBEE_EZSP_WRITE_NODE_DATA: return "SL_ZIGBEE_EZSP_WRITE_NODE_DATA";
    case SL_ZIGBEE_EZSP_SEND_RAW_MESSAGE: return "SL_ZIGBEE_EZSP_SEND_RAW_MESSAGE";
    case SL_ZIGBEE_EZSP_MAC_PASSTHROUGH_MESSAGE_HANDLER: return "SL_ZIGBEE_EZSP_MAC_PASSTHROUGH_MESSAGE_HANDLER";
    case SL_ZIGBEE_EZSP_MAC_FILTER_MATCH_MESSAGE_HANDLER: return "SL_ZIGBEE_EZSP_MAC_FILTER_MATCH_MESSAGE_HANDLER";
    case SL_ZIGBEE_EZSP_RAW_TRANSMIT_COMPLETE_HANDLER: return "SL_ZIGBEE_EZSP_RAW_TRANSMIT_COMPLETE_HANDLER";
    case SL_ZIGBEE_EZSP_SET_MAC_POLL_FAILURE_WAIT_TIME: return "SL_ZIGBEE_EZSP_SET_MAC_POLL_FAILURE_WAIT_TIME";
    case SL_ZIGBEE_EZSP_GET_MAX_MAC_RETRIES: return "SL_ZIGBEE_EZSP_GET_MAX_MAC_RETRIES";
    case SL_ZIGBEE_EZSP_SET_BEACON_CLASSIFICATION_PARAMS: return "SL_ZIGBEE_EZSP_SET_BEACON_CLASSIFICATION_PARAMS";
    case SL_ZIGBEE_EZSP_GET_BEACON_CLASSIFICATION_PARAMS: return "SL_ZIGBEE_EZSP_GET_BEACON_CLASSIFICATION_PARAMS";
    case SL_ZIGBEE_EZSP_PENDING_ACKED_MESSAGES: return "SL_ZIGBEE_EZSP_PENDING_ACKED_MESSAGES";
    case SL_ZIGBEE_EZSP_RESCHEDULE_LINK_STATUS_MSG: return "SL_ZIGBEE_EZSP_RESCHEDULE_LINK_STATUS_MSG";
    case SL_ZIGBEE_EZSP_SET_NWK_UPDATE_ID: return "SL_ZIGBEE_EZSP_SET_NWK_UPDATE_ID";

// Security Frames
    case SL_ZIGBEE_EZSP_SET_INITIAL_SECURITY_STATE: return "SL_ZIGBEE_EZSP_SET_INITIAL_SECURITY_STATE";
    case SL_ZIGBEE_EZSP_GET_CURRENT_SECURITY_STATE: return "SL_ZIGBEE_EZSP_GET_CURRENT_SECURITY_STATE";
    case SL_ZIGBEE_EZSP_SEC_MAN_EXPORT_KEY: return "SL_ZIGBEE_EZSP_SEC_MAN_EXPORT_KEY";
    case SL_ZIGBEE_EZSP_SEC_MAN_IMPORT_KEY: return "SL_ZIGBEE_EZSP_SEC_MAN_IMPORT_KEY";
    case SL_ZIGBEE_EZSP_SWITCH_NETWORK_KEY_HANDLER: return "SL_ZIGBEE_EZSP_SWITCH_NETWORK_KEY_HANDLER";
    case SL_ZIGBEE_EZSP_FIND_KEY_TABLE_ENTRY: return "SL_ZIGBEE_EZSP_FIND_KEY_TABLE_ENTRY";
    case SL_ZIGBEE_EZSP_SEND_TRUST_CENTER_LINK_KEY: return "SL_ZIGBEE_EZSP_SEND_TRUST_CENTER_LINK_KEY";
    case SL_ZIGBEE_EZSP_ERASE_KEY_TABLE_ENTRY: return "SL_ZIGBEE_EZSP_ERASE_KEY_TABLE_ENTRY";
    case SL_ZIGBEE_EZSP_CLEAR_KEY_TABLE: return "SL_ZIGBEE_EZSP_CLEAR_KEY_TABLE";
    case SL_ZIGBEE_EZSP_REQUEST_LINK_KEY: return "SL_ZIGBEE_EZSP_REQUEST_LINK_KEY";
    case SL_ZIGBEE_EZSP_UPDATE_TC_LINK_KEY: return "SL_ZIGBEE_EZSP_UPDATE_TC_LINK_KEY";
    case SL_ZIGBEE_EZSP_ZIGBEE_KEY_ESTABLISHMENT_HANDLER: return "SL_ZIGBEE_EZSP_ZIGBEE_KEY_ESTABLISHMENT_HANDLER";
    case SL_ZIGBEE_EZSP_CLEAR_TRANSIENT_LINK_KEYS: return "SL_ZIGBEE_EZSP_CLEAR_TRANSIENT_LINK_KEYS";
    case SL_ZIGBEE_EZSP_SEC_MAN_GET_NETWORK_KEY_INFO: return "SL_ZIGBEE_EZSP_SEC_MAN_GET_NETWORK_KEY_INFO";
    case SL_ZIGBEE_EZSP_SEC_MAN_GET_APS_KEY_INFO: return "SL_ZIGBEE_EZSP_SEC_MAN_GET_APS_KEY_INFO";
    case SL_ZIGBEE_EZSP_SEC_MAN_IMPORT_LINK_KEY: return "SL_ZIGBEE_EZSP_SEC_MAN_IMPORT_LINK_KEY";
    case SL_ZIGBEE_EZSP_SEC_MAN_EXPORT_LINK_KEY_BY_INDEX: return "SL_ZIGBEE_EZSP_SEC_MAN_EXPORT_LINK_KEY_BY_INDEX";
    case SL_ZIGBEE_EZSP_SEC_MAN_EXPORT_LINK_KEY_BY_EUI: return "SL_ZIGBEE_EZSP_SEC_MAN_EXPORT_LINK_KEY_BY_EUI";
    case SL_ZIGBEE_EZSP_SEC_MAN_CHECK_KEY_CONTEXT: return "SL_ZIGBEE_EZSP_SEC_MAN_CHECK_KEY_CONTEXT";
    case SL_ZIGBEE_EZSP_SEC_MAN_IMPORT_TRANSIENT_KEY: return "SL_ZIGBEE_EZSP_SEC_MAN_IMPORT_TRANSIENT_KEY";
    case SL_ZIGBEE_EZSP_SEC_MAN_EXPORT_TRANSIENT_KEY_BY_INDEX: return "SL_ZIGBEE_EZSP_SEC_MAN_EXPORT_TRANSIENT_KEY_BY_INDEX";
    case SL_ZIGBEE_EZSP_SEC_MAN_EXPORT_TRANSIENT_KEY_BY_EUI: return "SL_ZIGBEE_EZSP_SEC_MAN_EXPORT_TRANSIENT_KEY_BY_EUI";
    case SL_ZIGBEE_EZSP_SET_INCOMING_TC_LINK_KEY_FRAME_COUNTER: return "SL_ZIGBEE_EZSP_SET_INCOMING_TC_LINK_KEY_FRAME_COUNTER";
    case SL_ZIGBEE_EZSP_APS_CRYPT_MESSAGE: return "SL_ZIGBEE_EZSP_APS_CRYPT_MESSAGE";

// Trust Center Frames
    case SL_ZIGBEE_EZSP_TRUST_CENTER_POST_JOIN_HANDLER: return "SL_ZIGBEE_EZSP_TRUST_CENTER_POST_JOIN_HANDLER";
    case SL_ZIGBEE_EZSP_BROADCAST_NEXT_NETWORK_KEY: return "SL_ZIGBEE_EZSP_BROADCAST_NEXT_NETWORK_KEY";
    case SL_ZIGBEE_EZSP_BROADCAST_NETWORK_KEY_SWITCH: return "SL_ZIGBEE_EZSP_BROADCAST_NETWORK_KEY_SWITCH";
    case SL_ZIGBEE_EZSP_AES_MMO_HASH: return "SL_ZIGBEE_EZSP_AES_MMO_HASH";
    case SL_ZIGBEE_EZSP_REMOVE_DEVICE: return "SL_ZIGBEE_EZSP_REMOVE_DEVICE";
    case SL_ZIGBEE_EZSP_UNICAST_NWK_KEY_UPDATE: return "SL_ZIGBEE_EZSP_UNICAST_NWK_KEY_UPDATE";

// Certificate Based Key Exchange (CBKE) Frames
    case SL_ZIGBEE_EZSP_GENERATE_CBKE_KEYS: return "SL_ZIGBEE_EZSP_GENERATE_CBKE_KEYS";
    case SL_ZIGBEE_EZSP_GENERATE_CBKE_KEYS_HANDLER: return "SL_ZIGBEE_EZSP_GENERATE_CBKE_KEYS_HANDLER";
    case SL_ZIGBEE_EZSP_CALCULATE_SMACS: return "SL_ZIGBEE_EZSP_CALCULATE_SMACS";
    case SL_ZIGBEE_EZSP_CALCULATE_SMACS_HANDLER: return "SL_ZIGBEE_EZSP_CALCULATE_SMACS_HANDLER";
    case SL_ZIGBEE_EZSP_GENERATE_CBKE_KEYS_283K1: return "SL_ZIGBEE_EZSP_GENERATE_CBKE_KEYS_283K1";
    case SL_ZIGBEE_EZSP_GENERATE_CBKE_KEYS_283K1_HANDLER: return "SL_ZIGBEE_EZSP_GENERATE_CBKE_KEYS_283K1_HANDLER";
    case SL_ZIGBEE_EZSP_CALCULATE_SMACS_283K1: return "SL_ZIGBEE_EZSP_CALCULATE_SMACS_283K1";
    case SL_ZIGBEE_EZSP_CALCULATE_SMACS_283K1_HANDLER: return "SL_ZIGBEE_EZSP_CALCULATE_SMACS_283K1_HANDLER";
    case SL_ZIGBEE_EZSP_CLEAR_TEMPORARY_DATA_MAYBE_STORE_LINK_KEY: return "SL_ZIGBEE_EZSP_CLEAR_TEMPORARY_DATA_MAYBE_STORE_LINK_KEY";
    case SL_ZIGBEE_EZSP_CLEAR_TEMPORARY_DATA_MAYBE_STORE_LINK_KEY_283K1: return "SL_ZIGBEE_EZSP_CLEAR_TEMPORARY_DATA_MAYBE_STORE_LINK_KEY_283K1";
    case SL_ZIGBEE_EZSP_GET_CERTIFICATE: return "SL_ZIGBEE_EZSP_GET_CERTIFICATE";
    case SL_ZIGBEE_EZSP_GET_CERTIFICATE_283K1: return "SL_ZIGBEE_EZSP_GET_CERTIFICATE_283K1";
    case SL_ZIGBEE_EZSP_DSA_SIGN: return "SL_ZIGBEE_EZSP_DSA_SIGN";
    case SL_ZIGBEE_EZSP_DSA_SIGN_HANDLER: return "SL_ZIGBEE_EZSP_DSA_SIGN_HANDLER";
    case SL_ZIGBEE_EZSP_DSA_VERIFY: return "SL_ZIGBEE_EZSP_DSA_VERIFY";
    case SL_ZIGBEE_EZSP_DSA_VERIFY_HANDLER: return "SL_ZIGBEE_EZSP_DSA_VERIFY_HANDLER";
    case SL_ZIGBEE_EZSP_DSA_VERIFY_283K1: return "SL_ZIGBEE_EZSP_DSA_VERIFY_283K1";
    case SL_ZIGBEE_EZSP_SET_PREINSTALLED_CBKE_DATA: return "SL_ZIGBEE_EZSP_SET_PREINSTALLED_CBKE_DATA";
    case SL_ZIGBEE_EZSP_SAVE_PREINSTALLED_CBKE_DATA_283K1: return "SL_ZIGBEE_EZSP_SAVE_PREINSTALLED_CBKE_DATA_283K1";

// Mfglib Frames
    case SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_START: return "SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_START";
    case SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_END: return "SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_END";
    case SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_START_TONE: return "SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_START_TONE";
    case SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_STOP_TONE: return "SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_STOP_TONE";
    case SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_START_STREAM: return "SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_START_STREAM";
    case SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_STOP_STREAM: return "SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_STOP_STREAM";
    case SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_SEND_PACKET: return "SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_SEND_PACKET";
    case SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_SET_CHANNEL: return "SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_SET_CHANNEL";
    case SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_GET_CHANNEL: return "SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_GET_CHANNEL";
    case SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_SET_POWER: return "SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_SET_POWER";
    case SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_GET_POWER: return "SL_ZIGBEE_EZSP_MFGLIB_INTERNAL_GET_POWER";
    case SL_ZIGBEE_EZSP_MFGLIB_RX_HANDLER: return "SL_ZIGBEE_EZSP_MFGLIB_RX_HANDLER";

// Bootloader Frames
    case SL_ZIGBEE_EZSP_LAUNCH_STANDALONE_BOOTLOADER: return "SL_ZIGBEE_EZSP_LAUNCH_STANDALONE_BOOTLOADER";
    case SL_ZIGBEE_EZSP_SEND_BOOTLOAD_MESSAGE: return "SL_ZIGBEE_EZSP_SEND_BOOTLOAD_MESSAGE";
    case SL_ZIGBEE_EZSP_GET_STANDALONE_BOOTLOADER_VERSION_PLAT_MICRO_PHY: return "SL_ZIGBEE_EZSP_GET_STANDALONE_BOOTLOADER_VERSION_PLAT_MICRO_PHY";
    case SL_ZIGBEE_EZSP_INCOMING_BOOTLOAD_MESSAGE_HANDLER: return "SL_ZIGBEE_EZSP_INCOMING_BOOTLOAD_MESSAGE_HANDLER";
    case SL_ZIGBEE_EZSP_BOOTLOAD_TRANSMIT_COMPLETE_HANDLER: return "SL_ZIGBEE_EZSP_BOOTLOAD_TRANSMIT_COMPLETE_HANDLER";
    case SL_ZIGBEE_EZSP_AES_ENCRYPT: return "SL_ZIGBEE_EZSP_AES_ENCRYPT";
    case SL_ZIGBEE_EZSP_INCOMING_MFG_TEST_MESSAGE_HANDLER: return "SL_ZIGBEE_EZSP_INCOMING_MFG_TEST_MESSAGE_HANDLER";
    case SL_ZIGBEE_EZSP_MFG_TEST_SET_PACKET_MODE: return "SL_ZIGBEE_EZSP_MFG_TEST_SET_PACKET_MODE";
    case SL_ZIGBEE_EZSP_MFG_TEST_SEND_REBOOT_COMMAND: return "SL_ZIGBEE_EZSP_MFG_TEST_SEND_REBOOT_COMMAND";
    case SL_ZIGBEE_EZSP_MFG_TEST_SEND_EUI64: return "SL_ZIGBEE_EZSP_MFG_TEST_SEND_EUI64";
    case SL_ZIGBEE_EZSP_MFG_TEST_SEND_MANUFACTURING_STRING: return "SL_ZIGBEE_EZSP_MFG_TEST_SEND_MANUFACTURING_STRING";
    case SL_ZIGBEE_EZSP_MFG_TEST_SEND_RADIO_PARAMETERS: return "SL_ZIGBEE_EZSP_MFG_TEST_SEND_RADIO_PARAMETERS";
    case SL_ZIGBEE_EZSP_MFG_TEST_SEND_COMMAND: return "SL_ZIGBEE_EZSP_MFG_TEST_SEND_COMMAND";

// ZLL Frames
    case SL_ZIGBEE_EZSP_ZLL_NETWORK_OPS: return "SL_ZIGBEE_EZSP_ZLL_NETWORK_OPS";
    case SL_ZIGBEE_EZSP_ZLL_SET_INITIAL_SECURITY_STATE: return "SL_ZIGBEE_EZSP_ZLL_SET_INITIAL_SECURITY_STATE";
    case SL_ZIGBEE_EZSP_ZLL_SET_SECURITY_STATE_WITHOUT_KEY: return "SL_ZIGBEE_EZSP_ZLL_SET_SECURITY_STATE_WITHOUT_KEY";
    case SL_ZIGBEE_EZSP_ZLL_START_SCAN: return "SL_ZIGBEE_EZSP_ZLL_START_SCAN";
    case SL_ZIGBEE_EZSP_ZLL_SET_RX_ON_WHEN_IDLE: return "SL_ZIGBEE_EZSP_ZLL_SET_RX_ON_WHEN_IDLE";
    case SL_ZIGBEE_EZSP_ZLL_NETWORK_FOUND_HANDLER: return "SL_ZIGBEE_EZSP_ZLL_NETWORK_FOUND_HANDLER";
    case SL_ZIGBEE_EZSP_ZLL_SCAN_COMPLETE_HANDLER: return "SL_ZIGBEE_EZSP_ZLL_SCAN_COMPLETE_HANDLER";
    case SL_ZIGBEE_EZSP_ZLL_ADDRESS_ASSIGNMENT_HANDLER: return "SL_ZIGBEE_EZSP_ZLL_ADDRESS_ASSIGNMENT_HANDLER";
    case SL_ZIGBEE_EZSP_ZLL_TOUCH_LINK_TARGET_HANDLER: return "SL_ZIGBEE_EZSP_ZLL_TOUCH_LINK_TARGET_HANDLER";
    case SL_ZIGBEE_EZSP_ZLL_GET_TOKENS: return "SL_ZIGBEE_EZSP_ZLL_GET_TOKENS";
    case SL_ZIGBEE_EZSP_ZLL_SET_DATA_TOKEN: return "SL_ZIGBEE_EZSP_ZLL_SET_DATA_TOKEN";
    case SL_ZIGBEE_EZSP_ZLL_SET_NON_ZLL_NETWORK: return "SL_ZIGBEE_EZSP_ZLL_SET_NON_ZLL_NETWORK";
    case SL_ZIGBEE_EZSP_IS_ZLL_NETWORK: return "SL_ZIGBEE_EZSP_IS_ZLL_NETWORK";
    case SL_ZIGBEE_EZSP_ZLL_SET_RADIO_IDLE_MODE: return "SL_ZIGBEE_EZSP_ZLL_SET_RADIO_IDLE_MODE";
    case SL_ZIGBEE_EZSP_ZLL_GET_RADIO_IDLE_MODE: return "SL_ZIGBEE_EZSP_ZLL_GET_RADIO_IDLE_MODE";
    case SL_ZIGBEE_EZSP_SET_ZLL_NODE_TYPE: return "SL_ZIGBEE_EZSP_SET_ZLL_NODE_TYPE";
    case SL_ZIGBEE_EZSP_SET_ZLL_ADDITIONAL_STATE: return "SL_ZIGBEE_EZSP_SET_ZLL_ADDITIONAL_STATE";
    case SL_ZIGBEE_EZSP_ZLL_OPERATION_IN_PROGRESS: return "SL_ZIGBEE_EZSP_ZLL_OPERATION_IN_PROGRESS";
    case SL_ZIGBEE_EZSP_ZLL_RX_ON_WHEN_IDLE_GET_ACTIVE: return "SL_ZIGBEE_EZSP_ZLL_RX_ON_WHEN_IDLE_GET_ACTIVE";
    case SL_ZIGBEE_EZSP_ZLL_SCANNING_COMPLETE: return "SL_ZIGBEE_EZSP_ZLL_SCANNING_COMPLETE";
    case SL_ZIGBEE_EZSP_GET_ZLL_PRIMARY_CHANNEL_MASK: return "SL_ZIGBEE_EZSP_GET_ZLL_PRIMARY_CHANNEL_MASK";
    case SL_ZIGBEE_EZSP_GET_ZLL_SECONDARY_CHANNEL_MASK: return "SL_ZIGBEE_EZSP_GET_ZLL_SECONDARY_CHANNEL_MASK";
    case SL_ZIGBEE_EZSP_SET_ZLL_PRIMARY_CHANNEL_MASK: return "SL_ZIGBEE_EZSP_SET_ZLL_PRIMARY_CHANNEL_MASK";
    case SL_ZIGBEE_EZSP_SET_ZLL_SECONDARY_CHANNEL_MASK: return "SL_ZIGBEE_EZSP_SET_ZLL_SECONDARY_CHANNEL_MASK";
    case SL_ZIGBEE_EZSP_ZLL_CLEAR_TOKENS: return "SL_ZIGBEE_EZSP_ZLL_CLEAR_TOKENS";

// Green Power Frames
    case SL_ZIGBEE_EZSP_GP_PROXY_TABLE_PROCESS_GP_PAIRING: return "SL_ZIGBEE_EZSP_GP_PROXY_TABLE_PROCESS_GP_PAIRING";
    case SL_ZIGBEE_EZSP_D_GP_SEND: return "SL_ZIGBEE_EZSP_D_GP_SEND";
    case SL_ZIGBEE_EZSP_D_GP_SENT_HANDLER: return "SL_ZIGBEE_EZSP_D_GP_SENT_HANDLER";
    case SL_ZIGBEE_EZSP_GPEP_INCOMING_MESSAGE_HANDLER: return "SL_ZIGBEE_EZSP_GPEP_INCOMING_MESSAGE_HANDLER";
    case SL_ZIGBEE_EZSP_GP_PROXY_TABLE_GET_ENTRY: return "SL_ZIGBEE_EZSP_GP_PROXY_TABLE_GET_ENTRY";
    case SL_ZIGBEE_EZSP_GP_PROXY_TABLE_LOOKUP: return "SL_ZIGBEE_EZSP_GP_PROXY_TABLE_LOOKUP";
    case SL_ZIGBEE_EZSP_GP_PROXY_TABLE_REMOVE_ENTRY: return "SL_ZIGBEE_EZSP_GP_PROXY_TABLE_REMOVE_ENTRY";
    case SL_ZIGBEE_EZSP_GP_CLEAR_PROXY_TABLE: return "SL_ZIGBEE_EZSP_GP_CLEAR_PROXY_TABLE";
    case SL_ZIGBEE_EZSP_GP_SINK_TABLE_GET_ENTRY: return "SL_ZIGBEE_EZSP_GP_SINK_TABLE_GET_ENTRY";
    case SL_ZIGBEE_EZSP_GP_SINK_TABLE_LOOKUP: return "SL_ZIGBEE_EZSP_GP_SINK_TABLE_LOOKUP";
    case SL_ZIGBEE_EZSP_GP_SINK_TABLE_SET_ENTRY: return "SL_ZIGBEE_EZSP_GP_SINK_TABLE_SET_ENTRY";
    case SL_ZIGBEE_EZSP_GP_SINK_TABLE_REMOVE_ENTRY: return "SL_ZIGBEE_EZSP_GP_SINK_TABLE_REMOVE_ENTRY";
    case SL_ZIGBEE_EZSP_GP_SINK_TABLE_FIND_OR_ALLOCATE_ENTRY: return "SL_ZIGBEE_EZSP_GP_SINK_TABLE_FIND_OR_ALLOCATE_ENTRY";
    case SL_ZIGBEE_EZSP_GP_SINK_TABLE_CLEAR_ALL: return "SL_ZIGBEE_EZSP_GP_SINK_TABLE_CLEAR_ALL";
    case SL_ZIGBEE_EZSP_GP_SINK_TABLE_INIT: return "SL_ZIGBEE_EZSP_GP_SINK_TABLE_INIT";
    case SL_ZIGBEE_EZSP_GP_SINK_TABLE_SET_SECURITY_FRAME_COUNTER: return "SL_ZIGBEE_EZSP_GP_SINK_TABLE_SET_SECURITY_FRAME_COUNTER";
    case SL_ZIGBEE_EZSP_GP_SINK_COMMISSION: return "SL_ZIGBEE_EZSP_GP_SINK_COMMISSION";
    case SL_ZIGBEE_EZSP_GP_TRANSLATION_TABLE_CLEAR: return "SL_ZIGBEE_EZSP_GP_TRANSLATION_TABLE_CLEAR";
    case SL_ZIGBEE_EZSP_GP_SINK_TABLE_GET_NUMBER_OF_ACTIVE_ENTRIES: return "SL_ZIGBEE_EZSP_GP_SINK_TABLE_GET_NUMBER_OF_ACTIVE_ENTRIES";

// Token Interface Frames
    case SL_ZIGBEE_EZSP_GET_TOKEN_COUNT: return "SL_ZIGBEE_EZSP_GET_TOKEN_COUNT";
    case SL_ZIGBEE_EZSP_GET_TOKEN_INFO: return "SL_ZIGBEE_EZSP_GET_TOKEN_INFO";
    case SL_ZIGBEE_EZSP_GET_TOKEN_DATA: return "SL_ZIGBEE_EZSP_GET_TOKEN_DATA";
    case SL_ZIGBEE_EZSP_SET_TOKEN_DATA: return "SL_ZIGBEE_EZSP_SET_TOKEN_DATA";
    case SL_ZIGBEE_EZSP_RESET_NODE: return "SL_ZIGBEE_EZSP_RESET_NODE";
    case SL_ZIGBEE_EZSP_GP_SECURITY_TEST_VECTORS: return "SL_ZIGBEE_EZSP_GP_SECURITY_TEST_VECTORS";
    case SL_ZIGBEE_EZSP_TOKEN_FACTORY_RESET: return "SL_ZIGBEE_EZSP_TOKEN_FACTORY_RESET";
  }
  return "*** Not enumerated. ***";
}
