/***************************************************************************//**
 * @file
 * @brief Multi PAN token definitions used by the stack.
 *******************************************************************************
 * # License
 * <b>Copyright 2020 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc. Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement. This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

#include "sl_token_manager_defines.h"

// Noted: Our current multi-network feature is restricted to have 2 networks,
// check the definition of SL_ZIGBEE_SUPPORTED_NETWORKS. So here we only define
// one more set of tokens for child tables. In the future, if we supports more
// networks we could add more sets of tokens here.
// In addition, the max array size of indexed tokens is 127 and the max child
// table size is 64, so we cannot simply use 1 indexed token for 2 child tables.

// MULTI-PAN CREATORS
#define CREATOR_MULTI_PAN_STACK_CHILD_TABLE                  0xE550
#define CREATOR_MULTI_PAN_STACK_ADDITIONAL_CHILD_DATA        0xE551

// MULTI-PAN KEYS
// This key is used for an indexed token and the subsequent 0x7F keys are also reserved.
#define NVM3KEY_MULTI_PAN_STACK_CHILD_TABLE                (NVM3KEY_DOMAIN_ZIGBEE | 0x0800)
#define COMMON_TOKEN_MULTI_PAN_STACK_CHILD_TABLE           SL_TOKEN_GET_DYNAMIC_TOKEN((SL_TOKEN_NVM3_REGION_ZIGBEE | 0x0800), 0)
// This key is used for an indexed token and the subsequent 0x7F keys are also reserved.
#define NVM3KEY_MULTI_PAN_STACK_ADDITIONAL_CHILD_DATA      (NVM3KEY_DOMAIN_ZIGBEE | 0x0880)
#define COMMON_TOKEN_MULTI_PAN_STACK_ADDITIONAL_CHILD_DATA SL_TOKEN_GET_DYNAMIC_TOKEN((SL_TOKEN_NVM3_REGION_ZIGBEE | 0x0880), 0)

#define TOKEN_MULTI_PAN_STACK_CHILD_TABLE_DEFAULT { 0, }
#define TOKEN_MULTI_PAN_STACK_ADDITIONAL_CHILD_DATA_DEFAULT { 0x0F, }

// We only reserve token space for multi PAN child table
// when multiple ZC and ZR devices devices are present.
#if (SL_ZIGBEE_ZC_AND_ZR_DEVICE_COUNT > 1)
  #define SL_ZIGBEE_MULTI_PAN_CHILD_TABLE_TOKEN_SIZE SL_ZIGBEE_CHILD_TABLE_SIZE
#else
  #define SL_ZIGBEE_MULTI_PAN_CHILD_TABLE_TOKEN_SIZE 0
#endif

#ifdef DEFINETOKENS
DEFINE_INDEXED_TOKEN(MULTI_PAN_STACK_CHILD_TABLE,
                     tokTypeStackChildTable,
                     SL_ZIGBEE_MULTI_PAN_CHILD_TABLE_TOKEN_SIZE,
                     TOKEN_MULTI_PAN_STACK_CHILD_TABLE_DEFAULT)
DEFINE_INDEXED_TOKEN(MULTI_PAN_STACK_ADDITIONAL_CHILD_DATA,
                     tokTypeStackAdditionalChildData,
                     SL_ZIGBEE_MULTI_PAN_CHILD_TABLE_TOKEN_SIZE,
                     TOKEN_MULTI_PAN_STACK_ADDITIONAL_CHILD_DATA_DEFAULT)
#endif //DEFINETOKENS
