/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.adapter;

import com.silabs.pti.adapter.AsciiFramer;
import com.silabs.pti.adapter.ConnectivityStats;
import com.silabs.pti.adapter.IConnectionEnabler;
import com.silabs.pti.adapter.IConnectionListener;
import com.silabs.pti.adapter.IConnectionProblemListener;
import com.silabs.pti.adapter.IConnectivityLogger;
import com.silabs.pti.adapter.IDebugConnection;
import com.silabs.pti.adapter.IFramer;
import com.silabs.pti.log.PtiLog;
import com.silabs.pti.log.PtiSeverity;
import com.silabs.pti.util.ICharacterListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

abstract class BaseConnection
implements IDebugConnection {
    protected final String host;
    protected final int port;
    protected final IConnectivityLogger logger;
    protected final List<ICharacterListener> characterListeners = new ArrayList<ICharacterListener>();
    protected final List<IConnectionListener> connectionListeners = new ArrayList<IConnectionListener>();
    protected IFramer incomingFramer = new AsciiFramer();
    protected IFramer outgoingFramer = new AsciiFramer();
    protected boolean frameOutgoing = true;
    protected IConnectionProblemListener problemListener;
    protected IConnectionEnabler connectionEnabler;
    private long resumeTime = -1L;
    private final ConnectivityStats stats;

    protected BaseConnection(String host, int port, IConnectivityLogger logger) {
        this.host = host;
        this.port = port;
        this.logger = logger;
        this.stats = new ConnectivityStats(logger, host + ":" + port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addCharacterListener(ICharacterListener listener) {
        List<ICharacterListener> list = this.characterListeners;
        synchronized (list) {
            if (!this.characterListeners.contains(listener)) {
                this.characterListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeCharacterListener(ICharacterListener listener) {
        List<ICharacterListener> list = this.characterListeners;
        synchronized (list) {
            this.characterListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addConnectionListener(IConnectionListener listener) {
        List<IConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            if (!this.connectionListeners.contains(listener)) {
                this.connectionListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeConnectionListener(IConnectionListener listener) {
        List<IConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            this.connectionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void informListenersOfState(boolean state) {
        List<IConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            for (IConnectionListener l : this.connectionListeners) {
                try {
                    l.connectionStateChanged(state);
                }
                catch (Exception e) {
                    PtiLog.warning("Connection listener error", e);
                }
            }
        }
    }

    @Override
    public final void setOutgoingFramingEnabled(boolean on) {
        this.frameOutgoing = on;
    }

    @Override
    public final void setConnectionProblemListener(IConnectionProblemListener l) {
        this.problemListener = l;
    }

    @Override
    public final IFramer incomingFramer() {
        return this.incomingFramer;
    }

    @Override
    public final IFramer outgoingFramer() {
        return this.outgoingFramer;
    }

    @Override
    public final void setConnectionEnabler(IConnectionEnabler enabler) {
        this.connectionEnabler = enabler;
    }

    @Override
    public final void pauseFor(int milliseconds) {
        this.resumeTime = System.currentTimeMillis() + (long)milliseconds;
    }

    @Override
    public final void setFramers(IFramer incomingFramer, IFramer outgoingFramer) {
        this.incomingFramer = incomingFramer;
        this.outgoingFramer = outgoingFramer;
    }

    protected final void logInfo(String message) {
        this.logger.log(PtiSeverity.INFO, this.host + ":" + this.port + " =>> " + message, null);
    }

    protected final void logError(String message, Throwable t) {
        this.logger.log(PtiSeverity.ERROR, this.host + ":" + this.port + " =>> " + message, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void processMessage(long pcTime, byte[] messageBytes) {
        if (messageBytes == null) {
            return;
        }
        if (this.resumeTime != -1L) {
            if (pcTime > this.resumeTime) {
                this.resumeTime = -1L;
            } else {
                return;
            }
        }
        List<IConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            for (IConnectionListener l : this.connectionListeners) {
                try {
                    l.messageReceived(messageBytes, pcTime);
                }
                catch (Exception e) {
                    PtiLog.warning("Connection listener error", e);
                }
            }
        }
    }

    protected final void reportProblem(String msg, Exception e) {
        if (this.problemListener != null) {
            this.problemListener.reportProblem(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void processIncomingData(long readTime, int readCount, byte[] readBytes) {
        this.stats.recordData(readTime, readCount);
        List<ICharacterListener> list = this.characterListeners;
        synchronized (list) {
            for (ICharacterListener l : this.characterListeners) {
                l.received(readBytes, 0, readCount);
            }
        }
        try {
            for (int i = 0; i < readCount; ++i) {
                byte[] messageBytes = this.incomingFramer.assembleMessage(readBytes[i]);
                if (messageBytes == null) continue;
                this.processMessage(readTime, messageBytes);
            }
        }
        catch (Exception e) {
            this.logError("Framing error.", e);
            this.reportProblem("Error assembling data.", e);
        }
    }

    @Override
    public final void send(String message) throws IOException {
        if (!this.isConnected()) {
            return;
        }
        if (message == null) {
            return;
        }
        this.logInfo("Sending '" + message + "'");
        this.send(this.outgoingFramer.toBytes(message));
    }

    @Override
    public void repair() throws IOException {
    }
}

