/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.debugchannel;

import com.silabs.na.pcap.util.ByteArrayUtil;
import com.silabs.pti.debugchannel.DebugMessageType;

public class DebugMessage {
    private String originatorId;
    private long pcTime;
    private Version version;
    private long networkTime;
    private int debugType;
    private int seqNumber = -1;
    private int flags = 0;
    private byte[] contents;

    private DebugMessage() {
    }

    public DebugMessage(long networkTime, int debugType, byte[] contents) {
        this.networkTime = networkTime;
        this.debugType = debugType;
        this.contents = contents;
    }

    public static String getTypeName(int typeValue) {
        return DebugMessageType.get(typeValue).description();
    }

    public Version version() {
        return this.version;
    }

    public int seqNumber() {
        return this.seqNumber;
    }

    public String originatorId() {
        return this.originatorId;
    }

    public byte[] contents() {
        return this.contents;
    }

    public byte[] eventContents() {
        byte[] eventContents;
        int dt = this.debugType();
        DebugMessageType dmt = DebugMessageType.get(dt);
        if (dmt == DebugMessageType.INVALID) {
            byte[] c = this.contents();
            eventContents = new byte[c.length + 2];
            eventContents[0] = (byte)(0xFF & dt >> 8);
            eventContents[1] = (byte)(0xFF & dt);
            System.arraycopy(c, 0, this.contents, 2, c.length);
        } else {
            eventContents = this.contents();
        }
        return eventContents;
    }

    public int contentLength() {
        return this.contents.length;
    }

    public int debugType() {
        return this.debugType;
    }

    public long networkTime() {
        return this.networkTime;
    }

    public long pcTime() {
        return this.pcTime;
    }

    public byte contents(int i) {
        return this.contents[i];
    }

    public int flags() {
        return this.flags;
    }

    public void setNetworkTime(long t) {
        this.networkTime = t;
    }

    public static DebugMessage makeVersion1(String originatorId, byte[] raw, long pcTime) {
        if (raw.length < 5) {
            return null;
        }
        DebugMessage debug = new DebugMessage();
        debug.originatorId = originatorId;
        debug.pcTime = pcTime;
        debug.networkTime = DebugMessage.bytesToLong(raw, 0, 4);
        debug.debugType = raw[4] & 0xFF;
        debug.contents = new byte[raw.length - 5];
        if (debug.contents.length > 0) {
            System.arraycopy(raw, 5, debug.contents, 0, debug.contents.length);
        }
        return debug;
    }

    public static DebugMessage make(String originatorId, byte[] raw, long pcTime) {
        if (raw.length < 2) {
            return null;
        }
        DebugMessage debug = new DebugMessage();
        debug.originatorId = originatorId;
        debug.pcTime = pcTime;
        debug.version = Version.resolve((int)DebugMessage.bytesToLong(raw, 0, 2));
        if (debug.version == Version.V3) {
            if (raw.length < 18) {
                return null;
            }
            debug.networkTime = DebugMessage.bytesToLong(raw, 2, 8) / 1000L;
            debug.debugType = (int)DebugMessage.bytesToLong(raw, 10, 2);
            debug.flags = (int)DebugMessage.bytesToLong(raw, 12, 4);
            debug.seqNumber = (int)DebugMessage.bytesToLong(raw, 16, 2);
            debug.contents = new byte[raw.length - 18];
            if (debug.contents.length > 0) {
                System.arraycopy(raw, 18, debug.contents, 0, debug.contents.length);
            }
        } else {
            if (raw.length < 11) {
                return null;
            }
            debug.networkTime = DebugMessage.bytesToLong(raw, 2, 6);
            debug.debugType = (int)DebugMessage.bytesToLong(raw, 8, 2);
            debug.seqNumber = raw[10] & 0xFF;
            debug.contents = new byte[raw.length - 11];
            if (debug.contents.length > 0) {
                System.arraycopy(raw, 11, debug.contents, 0, debug.contents.length);
            }
        }
        return debug;
    }

    private static long bytesToLong(byte[] raw, int startIndex, int length) {
        return ByteArrayUtil.byteArrayToLong((byte[])raw, (int)startIndex, (int)length, (boolean)false);
    }

    public String toString() {
        byte[] raw = this.contents;
        return "[" + this.originatorId + " " + this.networkTime + " " + DebugMessage.getTypeName(this.debugType) + "] [" + ByteArrayUtil.formatByteArray((byte[])raw, (boolean)true) + "]";
    }

    public static enum Version {
        UNKNOWN(-1, -1, -1),
        V1(1, 1, 1),
        V2(2, 1, 2),
        V3(3, 2, 2);

        private final int id;
        private final int sequenceLength;
        private final int sizeLength;

        private Version(int id, int sequenceLengthInBytes, int sizeLength) {
            this.id = id;
            this.sequenceLength = sequenceLengthInBytes;
            this.sizeLength = sizeLength;
        }

        public int id() {
            return this.id;
        }

        public int sequenceLength() {
            return this.sequenceLength;
        }

        public int sizeLength() {
            return this.sizeLength;
        }

        public static Version resolve(int id) {
            switch (id) {
                case 1: {
                    return V1;
                }
                case 2: {
                    return V2;
                }
                case 3: {
                    return V3;
                }
            }
            return UNKNOWN;
        }
    }
}

