/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.debugchannel;

import com.silabs.pti.debugchannel.DebugMessageType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventType
implements Comparable<EventType> {
    private int value = 0;
    private static short nextGroupSubtype = 0;
    private static final int MAX_NAME_LENGTH = 10;
    private final String name;
    private final String description;
    private static Map<String, EventType> storage = Collections.synchronizedMap(new HashMap());
    private static List<EventType> groups = Collections.synchronizedList(new ArrayList());
    private static final int MASK_NONE = 0;
    private static final int MASK_PACKET = 0x1000000;
    private static final int MASK_DONTSAVE = 0x2000000;
    private static final int MASK_GENERIC = 0x4000000;
    private static final int MASK_AEM = 0x8000000;
    private static final byte CATEGORY_GROUP = 1;
    private static final byte CATEGORY_BACKCHANNEL = 2;
    private static final byte CATEGORY_SIMULATED = 3;
    private static final byte CATEGORY_FROM_OLD_LOG = 4;
    private static final byte CATEGORY_SYNTHETIC_USER = 5;
    private static final byte CATEGORY_SYNTHETIC_SYSTEM = 6;
    private static final byte CATEGORY_PACKET_SOURCE = 7;
    private static final byte CATEGORY_IMPORTED = 8;
    private static final byte CATEGORY_INSTRUMENTATION = 9;
    private static final byte CATEGORY_UNKNOWN = -1;
    private static EventType[] debugMessageEventTypes = new EventType[DebugMessageType.values().length];
    public static final EventType UNKNOWN_DEBUG_MESSAGE;
    public static final EventType UNKNOWN_TYPE;
    public static final EventType RESET_INFO;
    public static final EventType TIME_SYNC;
    public static final EventType CPU_USAGE;
    public static final EventType PRINTF;
    public static final EventType API_TRACE;
    public static final EventType ASSERT;
    public static final EventType EZSP;
    public static final EventType INFO_RESPONSE;
    public static final EventType SNIFFER_PACKET;
    public static final EventType RX_2420;
    public static final EventType TX_2420;
    public static final EventType RX_250;
    public static final EventType TX_250;
    public static final EventType RX_350;
    public static final EventType TX_350;
    public static final EventType RX_PRO2P;
    public static final EventType TX_PRO2P;
    public static final EventType OTHER_PRO2P;
    public static final EventType RX_EFR;
    public static final EventType TX_EFR;
    public static final EventType OTHER_EFR;
    public static final EventType TX_GENERIC;
    public static final EventType RX_GENERIC;
    public static final EventType TX_PRO2;
    public static final EventType RX_PRO2;
    public static final EventType TX_OWL;
    public static final EventType RX_OWL;
    public static final EventType SIMULATED_AEM_SAMPLE;
    public static final EventType SIMULATED_AEM_COUNTER;
    public static final EventType IMPORTED_COM_PROBE;
    public static final EventType HCI_UNENC;
    public static final EventType HCI_UART;
    public static final EventType HCI_BSCP;
    public static final EventType HCI_SERIAL;
    public static final EventType IMPORTED_BT_SNOOP;
    public static final EventType IMPORTED_PCAP;
    public static final EventType IMPORTED_ZNIFFER;
    public static final EventType IMPORTED_ZBOSS;
    public static final EventType DEBUG;
    public static final EventType SIMULATED_LOCATION;
    public static final EventType SIMULATED_TX;
    public static final EventType SIMULATED_RX;
    public static final EventType GROUP_GENERIC;
    public static final EventType GROUP_MAC;
    public static final EventType GROUP_UNICAST;
    public static final EventType GROUP_BROADCAST;
    public static final EventType GROUP_TRANSPORT_DGRAM;
    public static final EventType GROUP_APS;
    public static final EventType GROUP_ASSOCIATION;
    public static final EventType GROUP_ROUTE_DISCOVERY;
    public static final EventType GROUP_EMBER_NETWORK;
    public static final EventType GROUP_BOOTLOAD;
    public static final EventType GROUP_BOOTLOAD_QUERY;
    public static final EventType GROUP_BOOTLOAD_REQUEST;
    public static final EventType GROUP_BOOTLOAD_XMODEM;
    public static final EventType GROUP_NETWORK_REJOIN;
    public static final EventType GROUP_ZIGBEE_UNICAST_COMMAND;
    public static final EventType GROUP_SKKE;
    public static final EventType GROUP_ENTITY_AUTHENTICATION;
    public static final EventType GROUP_ALARM;
    public static final EventType GROUP_LEAVE;
    public static final EventType GROUP_ZIGBEE_BROADCAST_COMMAND;
    public static final EventType GROUP_IP;
    public static final EventType GROUP_FRAGMENT;
    public static final EventType GROUP_TCP;
    public static final EventType GROUP_UDP;
    public static final EventType GROUP_ZLL_COMMISSIONING;
    public static final EventType GROUP_PANA;
    public static final EventType GROUP_ICMP;
    public static final EventType GROUP_DNS;
    public static final EventType GROUP_MUSTANG;
    public static final EventType GROUP_RF4CE_DISCOVERY;
    public static final EventType GROUP_RF4CE_PAIRING;
    public static final EventType GROUP_LATENCY;
    public static final EventType GROUP_OWL;
    public static final EventType GROUP_RF4CE_NETWORK;
    public static final EventType GROUP_RF4CE_GDP;
    public static final EventType GROUP_RF4CE_ZRC_1_X;
    public static final EventType GROUP_RF4CE_ZRC_2_X;
    public static final EventType GROUP_RF4CE_MSO;
    public static final EventType GROUP_CONNECT_NETWORK;
    public static final EventType GROUP_BLE_ATTRIBUTES;
    public static final EventType GROUP_BLE_ATTRIBUTE_COMMANDS;
    public static final EventType GROUP_BLE_ADVERTISEMENT;
    public static final EventType GROUP_BLE_ADVERTISEMENT_EXT;
    public static final EventType GROUP_BLE_LINKLAYER;
    public static final EventType GROUP_BLE_SMP;
    public static final EventType GROUP_BT_MESH_ADVERTISEMENT;
    public static final EventType GROUP_BT_MESH_RELAY;
    public static final EventType GROUP_BT_MESH_LINK_ESTABLISHMENT;
    public static final EventType GROUP_BT_MESH_PROVISIONING;
    public static final EventType GROUP_BT_MESH_ACCESS;
    public static final EventType GROUP_BT_MESH_SEGMENTATIONACK;
    public static final EventType CHANNEL_CHANGE;
    public static final EventType NETWORK_CHANGE;
    public static final EventType BOOKMARK_PACKET;
    public static final EventType BOOKMARK_GROUP;
    public static final EventType ADAPTER_INFO;
    public static final EventType GROUP_MARK;
    public static final EventType STREAM_STOP;
    public static final EventType TIME_SHIFT;
    public static final EventType DECRYPTOR_TYPE;
    public static final EventType TIMER_TICK;
    public static final EventType STACK_PROFILE;
    public static final EventType STREAM_CLEAR;
    public static final EventType CAPTURE_PROFILE;
    public static final EventType SEGMENT_START;
    public static final EventType OUT_OF_SEQUENCE;
    public static final EventType TIME_SET;
    public static final EventType LOG_PACKET_NO_LENGTH;
    public static final EventType LOG_PACKET_WITH_LENGTH;
    public static final EventType CAPTURE_PROBLEM;
    public static final EventType CAPTURE_INFO;

    public static final EventType fromDebugMessage(DebugMessageType t) {
        if (t == DebugMessageType.INVALID) {
            return UNKNOWN_DEBUG_MESSAGE;
        }
        EventType et = debugMessageEventTypes[t.ordinal()];
        if (et == null) {
            int mask = 0;
            if (t.name().startsWith("PACKET")) {
                mask = 0x1000000;
            } else if (t.name().startsWith("AEM")) {
                mask = 0x8000000;
            }
            String name = t.description();
            if (name.length() > 10) {
                name = name.substring(0, 10);
            }
            EventType.debugMessageEventTypes[t.ordinal()] = et = EventType.make(mask, (byte)2, (short)t.value(), name, t.longDescription());
        }
        return et;
    }

    private EventType(int value, String name, String description) {
        this.value = value;
        this.name = name;
        this.description = description;
    }

    private static EventType mkGrp(int mask, String name, String description) {
        short s = nextGroupSubtype;
        nextGroupSubtype = (short)(s + 1);
        return EventType.make(mask | 0x2000000, (byte)1, s, name, description);
    }

    private static EventType make(int mask, byte category, short subtype, String name, String description) {
        int value = EventType.makeValue(mask, category, subtype);
        String key = "" + value;
        EventType eventType = storage.get(key);
        if (eventType != null) {
            throw new IllegalArgumentException("Duplicate event type: " + name + "(" + mask + "/" + category + "/" + subtype + ")");
        }
        if (name == null) {
            throw new IllegalArgumentException("Event type name is null");
        }
        if (description == null) {
            throw new IllegalArgumentException("Event type description is null");
        }
        if (name.length() > 10) {
            throw new IllegalArgumentException("Event name " + name + " exceeds max length 10");
        }
        if (name.indexOf(32) != -1) {
            throw new IllegalArgumentException("No spaces in event name allowed");
        }
        eventType = new EventType(value, name, description);
        storage.put(key, eventType);
        if (eventType.isGroup()) {
            groups.add(eventType);
        }
        return eventType;
    }

    public static final EventType get(int value) {
        return storage.get("" + value);
    }

    public static final EventType[] getGroups() {
        return groups.toArray(new EventType[0]);
    }

    public static final EventType[] getAllTypes() {
        Object[] array = storage.values().toArray(new EventType[0]);
        Arrays.sort(array);
        return array;
    }

    public boolean isPacket() {
        return (this.value & 0x1000000) != 0;
    }

    public boolean isAem() {
        return (this.value & 0x8000000) != 0;
    }

    public boolean isAemSample() {
        return this.isAem() && (this == SIMULATED_AEM_SAMPLE || this == EventType.fromDebugMessage(DebugMessageType.AEM_SAMPLE));
    }

    public boolean isAemCounter() {
        return this.isAem() && (this == SIMULATED_AEM_COUNTER || this == EventType.fromDebugMessage(DebugMessageType.AEM_COUNTER));
    }

    public boolean isTx() {
        return this == TX_2420 || this == TX_250 || this == SIMULATED_TX || this == TX_350 || this == TX_GENERIC || this == TX_PRO2 || this == TX_PRO2P || this == TX_OWL || this == TX_EFR;
    }

    public boolean isRx() {
        return this == RX_2420 || this == RX_250 || this == SIMULATED_RX || this == RX_350 || this == RX_GENERIC || this == RX_PRO2 || this == RX_PRO2P || this == RX_OWL || this == RX_EFR;
    }

    public boolean doNotSave() {
        return (this.value & 0x2000000) != 0;
    }

    public boolean isGroup() {
        return 1 == this.category();
    }

    public boolean isGeneric() {
        return (this.value() & 0x4000000) != 0;
    }

    public boolean hasNoLengthByte() {
        return this == LOG_PACKET_NO_LENGTH || this == SNIFFER_PACKET || this == SIMULATED_TX || this == IMPORTED_PCAP || this == IMPORTED_ZBOSS;
    }

    public boolean isAlertOnAMap() {
        return this == debugMessageEventTypes[DebugMessageType.ASSERT.ordinal()] || this == debugMessageEventTypes[DebugMessageType.CORE_DUMP.ordinal()] || this == debugMessageEventTypes[DebugMessageType.ERROR.ordinal()];
    }

    public boolean isHci() {
        return this == HCI_BSCP || this == HCI_SERIAL || this == HCI_UART || this == HCI_UNENC;
    }

    public boolean isFromBackchannel() {
        return 2 == this.category();
    }

    public boolean isSimulatedRxTx() {
        return this == SIMULATED_RX || this == SIMULATED_TX;
    }

    public boolean isFrom2420() {
        return this == TX_2420 || this == RX_2420 || this == SNIFFER_PACKET;
    }

    public boolean isFromPro2() {
        return this == TX_PRO2 || this == TX_PRO2P || this == RX_PRO2 || this == RX_PRO2P;
    }

    public boolean isFromEfr() {
        return this == TX_EFR || this == RX_EFR || this == OTHER_EFR;
    }

    public boolean isFromOWL() {
        return this == TX_OWL || this == RX_OWL;
    }

    public boolean isSystemTransient() {
        return 6 == this.category();
    }

    public boolean isUserGenerated() {
        return 5 == this.category();
    }

    public boolean isBookmark() {
        return this == BOOKMARK_GROUP || this == BOOKMARK_PACKET;
    }

    public int value() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public DebugMessageType debugMessageType() {
        for (int i = 0; i < debugMessageEventTypes.length; ++i) {
            if (this != debugMessageEventTypes[i]) continue;
            return DebugMessageType.values()[i];
        }
        return null;
    }

    public boolean isDebugMessageType(DebugMessageType debugMessageType) {
        return this == EventType.fromDebugMessage(debugMessageType);
    }

    private byte category() {
        return (byte)(this.value >> 16 & 0xFF);
    }

    public short subtype() {
        return (short)(this.value & 0xFFFF);
    }

    private static int makeValue(int mask, byte category, short subtype) {
        int st = 0xFFFF & subtype;
        int ct = (0xFF & category) << 16;
        return ct | st | mask;
    }

    public static final EventType findByName(String name) {
        for (EventType et : EventType.getAllTypes()) {
            if (!et.name().equalsIgnoreCase(name)) continue;
            return et;
        }
        return null;
    }

    @Override
    public int compareTo(EventType o) {
        EventType et = o;
        return this.name.compareTo(et.name);
    }

    public String toString() {
        return this.name + " [" + this.value + "," + this.description + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventType other = (EventType)obj;
        return this.value == other.value;
    }

    static {
        for (DebugMessageType dmt : DebugMessageType.values()) {
            if (dmt == DebugMessageType.INVALID) continue;
            EventType.fromDebugMessage(dmt);
        }
        UNKNOWN_DEBUG_MESSAGE = EventType.make(0, (byte)-1, (short)0, "Unknown", "Unknown debug message event");
        UNKNOWN_TYPE = EventType.make(0, (byte)-1, (short)1, "Unknown", "Unknown event type");
        RESET_INFO = EventType.fromDebugMessage(DebugMessageType.RESET_INFO);
        TIME_SYNC = EventType.fromDebugMessage(DebugMessageType.TIME_SYNC);
        CPU_USAGE = EventType.fromDebugMessage(DebugMessageType.CPU_USAGE);
        PRINTF = EventType.fromDebugMessage(DebugMessageType.PRINTF);
        API_TRACE = EventType.fromDebugMessage(DebugMessageType.API_TRACE);
        ASSERT = EventType.fromDebugMessage(DebugMessageType.ASSERT);
        EZSP = EventType.fromDebugMessage(DebugMessageType.EZSP);
        INFO_RESPONSE = EventType.fromDebugMessage(DebugMessageType.INFO_RESPONSE);
        SNIFFER_PACKET = EventType.fromDebugMessage(DebugMessageType.PACKET_TRACE);
        RX_2420 = EventType.fromDebugMessage(DebugMessageType.PACKET_TRACE_EM2420_RX);
        TX_2420 = EventType.fromDebugMessage(DebugMessageType.PACKET_TRACE_EM2420_TX);
        RX_250 = EventType.fromDebugMessage(DebugMessageType.PACKET_TRACE_EM2XX_RX);
        TX_250 = EventType.fromDebugMessage(DebugMessageType.PACKET_TRACE_EM2XX_TX);
        RX_350 = EventType.fromDebugMessage(DebugMessageType.PACKET_TRACE_EM3XX_RX);
        TX_350 = EventType.fromDebugMessage(DebugMessageType.PACKET_TRACE_EM3XX_TX);
        RX_PRO2P = EventType.fromDebugMessage(DebugMessageType.PACKET_TRACE_PRO2P_RX);
        TX_PRO2P = EventType.fromDebugMessage(DebugMessageType.PACKET_TRACE_PRO2P_TX);
        OTHER_PRO2P = EventType.fromDebugMessage(DebugMessageType.PACKET_TRACE_PRO2P_OTHER);
        RX_EFR = EventType.fromDebugMessage(DebugMessageType.PACKET_TRACE_EFR_RX);
        TX_EFR = EventType.fromDebugMessage(DebugMessageType.PACKET_TRACE_EFR_TX);
        OTHER_EFR = EventType.fromDebugMessage(DebugMessageType.PACKET_TRACE_EFR_OTHER);
        TX_GENERIC = EventType.make(0x1000000, (byte)7, (short)0, "Tx", "Generic Tx packet");
        RX_GENERIC = EventType.make(0x1000000, (byte)7, (short)1, "Rx", "Generic Rx packet");
        TX_PRO2 = EventType.make(0x1000000, (byte)7, (short)2, "TxPro2", "Pro2 Tx packet");
        RX_PRO2 = EventType.make(0x1000000, (byte)7, (short)3, "RxPro2", "Pro2 Rx packet");
        TX_OWL = EventType.make(0x1000000, (byte)7, (short)4, "TxOWL", "OWL Tx packet");
        RX_OWL = EventType.make(0x1000000, (byte)7, (short)5, "RxOWL", "OWL Rx packet");
        SIMULATED_AEM_SAMPLE = EventType.make(0x8000000, (byte)3, (short)0, "AEMSample", "Energy Measurement Sample");
        SIMULATED_AEM_COUNTER = EventType.make(0x8000000, (byte)3, (short)1, "AEMCntr", "Energy Measurement Counters");
        IMPORTED_COM_PROBE = EventType.make(0x1000000, (byte)8, (short)0, "ComProbe", "ComProbe Protocol Analysis System");
        HCI_UNENC = EventType.make(0x1000000, (byte)8, (short)1, "HCIUnencap", "HCI Unencapsulated");
        HCI_UART = EventType.make(0x1000000, (byte)8, (short)2, "HCIUart", "HCI UART Datalink");
        HCI_BSCP = EventType.make(0x1000000, (byte)8, (short)3, "HCIBSCP", "HCI BSCP Datalink");
        HCI_SERIAL = EventType.make(0x1000000, (byte)8, (short)4, "HCISerial", "HCI Serial Datalink");
        IMPORTED_BT_SNOOP = EventType.make(0x1000000, (byte)8, (short)5, "BTSnoop", "BT Snoop Imported Packet");
        IMPORTED_PCAP = EventType.make(0x1000000, (byte)8, (short)6, "PCAP", "PCAP Imported Packet");
        IMPORTED_ZNIFFER = EventType.make(0x1000000, (byte)8, (short)7, "Zniffer", "Zniffer Imported Packet");
        IMPORTED_ZBOSS = EventType.make(0x1000000, (byte)8, (short)8, "ZBOSS", "Packet produced by ZBOSS dump");
        DEBUG = EventType.make(0, (byte)2, (short)-4081, "Unknown", "Unknown adapter event");
        SIMULATED_LOCATION = EventType.make(0x2000000, (byte)3, (short)1, "Location", "Node location information");
        SIMULATED_TX = EventType.make(0x1000000, (byte)3, (short)2, "Packet", "Simulated packet");
        SIMULATED_RX = EventType.make(0, (byte)3, (short)3, "Rx", "Simulated RX");
        GROUP_GENERIC = EventType.mkGrp(0x4000000, "Transactn", "Generic Transaction");
        GROUP_MAC = EventType.mkGrp(0x4000000, "Mac", "15.4 MAC transaction");
        GROUP_UNICAST = EventType.mkGrp(0, "Unicast", "ZigBee unicast transaction");
        GROUP_BROADCAST = EventType.mkGrp(0, "Broadcast", "ZigBee broadcast transaction");
        GROUP_TRANSPORT_DGRAM = EventType.mkGrp(0, "Datagram", "ZigBee transport datagram");
        GROUP_APS = EventType.mkGrp(0, "APS", "ZigBee APS transaction");
        GROUP_ASSOCIATION = EventType.mkGrp(0, "Associate", "ZigBee association transaction");
        GROUP_ROUTE_DISCOVERY = EventType.mkGrp(0, "Route", "Route discovery transaction");
        GROUP_EMBER_NETWORK = EventType.mkGrp(0, "EmberNet", "EmberNet network transaction");
        GROUP_BOOTLOAD = EventType.mkGrp(0, "Bootload", "OTA Bootload Transaction");
        GROUP_BOOTLOAD_QUERY = EventType.mkGrp(0, "BootQry", "OTA Bootload Query Transaction");
        GROUP_BOOTLOAD_REQUEST = EventType.mkGrp(0, "BootReq", "OTA Bootload Request Transaction");
        GROUP_BOOTLOAD_XMODEM = EventType.mkGrp(0, "BootXMod", "OTA Bootload XModem Transaction");
        GROUP_NETWORK_REJOIN = EventType.mkGrp(0, "Rejoin", "Network Rejoin transaction");
        GROUP_ZIGBEE_UNICAST_COMMAND = EventType.mkGrp(0, "CmdUnicast", "ZigBee Unicast Command");
        GROUP_SKKE = EventType.mkGrp(0, "SKKE", "SKKE Protocol Negotiation");
        GROUP_ENTITY_AUTHENTICATION = EventType.mkGrp(0, "EA", "Entity Authentication");
        GROUP_ALARM = EventType.mkGrp(0, "Alarm", "ZigBee APS Alarm");
        GROUP_LEAVE = EventType.mkGrp(0, "Leave", "Leave Transaction");
        GROUP_ZIGBEE_BROADCAST_COMMAND = EventType.mkGrp(0, "CmdBcast", "ZigBee Broadcast Command");
        GROUP_IP = EventType.mkGrp(0x4000000, "IP", "IP Message");
        GROUP_FRAGMENT = EventType.mkGrp(0x4000000, "Reassembly", "Reassembled Fragments");
        GROUP_TCP = EventType.mkGrp(0, "TCP", "TCP Message");
        GROUP_UDP = EventType.mkGrp(0, "UDP", "UDP Message");
        GROUP_ZLL_COMMISSIONING = EventType.mkGrp(0, "ZllComm", "ZllCommissioning");
        GROUP_PANA = EventType.mkGrp(0, "Pana", "PANA session");
        GROUP_ICMP = EventType.mkGrp(0, "ICMPv6", "ICMPv6 Message");
        GROUP_DNS = EventType.mkGrp(0, "DNS", "DNS Message");
        GROUP_MUSTANG = EventType.mkGrp(0, "Mustang", "Mustang");
        GROUP_RF4CE_DISCOVERY = EventType.mkGrp(0, "Discovery", "RF4CE Discovery");
        GROUP_RF4CE_PAIRING = EventType.mkGrp(0, "Pairing", "RF4CE Pairing");
        GROUP_LATENCY = EventType.mkGrp(0x4000000, "Latency", "Latency");
        GROUP_OWL = EventType.mkGrp(0, "OWL", "One Way Link");
        GROUP_RF4CE_NETWORK = EventType.mkGrp(0x4000000, "Network", "RF4CE Network");
        GROUP_RF4CE_GDP = EventType.mkGrp(0, "GDP", "RF4CE GDP");
        GROUP_RF4CE_ZRC_1_X = EventType.mkGrp(0, "ZRC1.x", "ZigBee Remote Control 1.x");
        GROUP_RF4CE_ZRC_2_X = EventType.mkGrp(0, "ZRC2.x", "ZigBee Remote Control 2.x");
        GROUP_RF4CE_MSO = EventType.mkGrp(0, "MSO", "RF4CE MSO");
        GROUP_CONNECT_NETWORK = EventType.mkGrp(0, "ConctNet", "Connect Network");
        GROUP_BLE_ATTRIBUTES = EventType.mkGrp(0, "BleAttr", "BLE Attributes Protocol");
        GROUP_BLE_ATTRIBUTE_COMMANDS = EventType.mkGrp(0, "BleAttrCmd", "BLE Attribute Command");
        GROUP_BLE_ADVERTISEMENT = EventType.mkGrp(0, "BleAdv", "BLE Advertisement");
        GROUP_BLE_ADVERTISEMENT_EXT = EventType.mkGrp(0, "BleAdvExt", "BLE Advertisement Extensions");
        GROUP_BLE_LINKLAYER = EventType.mkGrp(0, "BleLl", "BLE Link Layer Control");
        GROUP_BLE_SMP = EventType.mkGrp(0, "BleSmp", "BLE Pairing");
        GROUP_BT_MESH_ADVERTISEMENT = EventType.mkGrp(0, "BtMeshAdv", "BT Mesh Advertisement");
        GROUP_BT_MESH_RELAY = EventType.mkGrp(0, "BtMeshRel", "BT Mesh Relay");
        GROUP_BT_MESH_LINK_ESTABLISHMENT = EventType.mkGrp(0, "BtMeshLink", "BT Mesh Link Establishment");
        GROUP_BT_MESH_PROVISIONING = EventType.mkGrp(0, "BtMeshProv", "BT Mesh Provisioning");
        GROUP_BT_MESH_ACCESS = EventType.mkGrp(0, "BtMeshAcc", "BT Mesh Access Message Transactions");
        GROUP_BT_MESH_SEGMENTATIONACK = EventType.mkGrp(0, "BtMeshSeg", "BT Mesh Segmentation Acknowledgement");
        CHANNEL_CHANGE = EventType.make(0, (byte)5, (short)1, "ChChange", "Sniffer channel change notification");
        NETWORK_CHANGE = EventType.make(0, (byte)5, (short)3, "NetChange", "Sniffer network change notification");
        BOOKMARK_PACKET = EventType.make(0x2000000, (byte)5, (short)4, "Bookmark", "Packet annotation");
        BOOKMARK_GROUP = EventType.make(0x2000000, (byte)5, (short)5, "Bookmark", "Transaction annotation");
        ADAPTER_INFO = EventType.make(0, (byte)5, (short)6, "Adapter", "Adapter information from discovery");
        GROUP_MARK = EventType.make(0x2000000, (byte)6, (short)1, "GrpMark", "Group marker");
        STREAM_STOP = EventType.make(0x2000000, (byte)6, (short)2, "StopStream", "Stream stopped");
        TIME_SHIFT = EventType.make(0x2000000, (byte)6, (short)3, "TimeShift", "Time shift performed");
        DECRYPTOR_TYPE = EventType.make(0x2000000, (byte)6, (short)4, "Decryptor", "Decryptor type detected");
        TIMER_TICK = EventType.make(0x2000000, (byte)6, (short)5, "Tick", "Tick");
        STACK_PROFILE = EventType.make(0x2000000, (byte)6, (short)6, "StackPro", "Stack profile changed");
        STREAM_CLEAR = EventType.make(0x2000000, (byte)6, (short)7, "Clear", "Stream Clear");
        CAPTURE_PROFILE = EventType.make(0x2000000, (byte)6, (short)8, "CapturePro", "Capture Profile");
        SEGMENT_START = EventType.make(0x2000000, (byte)6, (short)9, "Segment", "Segment Start");
        OUT_OF_SEQUENCE = EventType.make(0x2000000, (byte)6, (short)10, "OutOfSeq", "Message out of Sequence");
        TIME_SET = EventType.make(0x2000000, (byte)6, (short)11, "TimeSet", "Time Set Notification");
        LOG_PACKET_NO_LENGTH = EventType.make(0x1000000, (byte)4, (short)0, "Packet", "Packet with no length byte");
        LOG_PACKET_WITH_LENGTH = EventType.make(0x1000000, (byte)4, (short)1, "Packet", "Packet with length byte");
        CAPTURE_PROBLEM = EventType.make(0, (byte)9, (short)0, "Error", "Capture Errors");
        CAPTURE_INFO = EventType.make(0, (byte)9, (short)1, "Diagnostic", "Capture Diagnostics");
    }
}

