/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.debugchannel;

import com.silabs.pti.debugchannel.DebugMessage;
import com.silabs.pti.debugchannel.DebugMessageType;
import com.silabs.pti.debugchannel.RadioConfiguration;
import com.silabs.pti.util.MiscUtil;

public class PtiUtilities {
    public static final String ISD_LOG_HEADER = "# (c) Ember - InSight Desktop";

    public static long[] startEndTime(DebugMessageType dmt, DebugMessage debugMessage, RadioConfiguration config) {
        long[] times = new long[2];
        long t = debugMessage.networkTime();
        switch (dmt) {
            case PACKET_TRACE: 
            case PACKET_TRACE_EM2420_RX: 
            case PACKET_TRACE_EM2420_TX: 
            case PACKET_TRACE_EM2XX_RX: 
            case PACKET_TRACE_EM2XX_TX: 
            case PACKET_TRACE_EM3XX_RX: 
            case PACKET_TRACE_EM3XX_TX: {
                times[0] = t - (long)config.microsecondDuration(debugMessage.contentLength());
                times[1] = t;
                break;
            }
            case PACKET_TRACE_EFR_RX: {
                times[0] = t - (long)config.microsecondDuration(0);
                times[1] = t + (long)config.microsecondDurationWithNoSyncAndPreamble(debugMessage.contentLength());
                break;
            }
            case PACKET_TRACE_EFR_TX: {
                times[0] = t;
                times[1] = t + (long)config.microsecondDuration(debugMessage.contentLength());
                break;
            }
            default: {
                times[0] = times[1] = t;
            }
        }
        return times;
    }

    public static int fifteenFourCrc(byte[] bytes) {
        int crc = 0;
        int polynomial = 4129;
        for (byte b : bytes) {
            b = MiscUtil.reverseBits(b);
            for (int i = 0; i < 8; ++i) {
                boolean bit = (b >> 7 - i & 1) == 1;
                boolean c15 = (crc >> 15 & 1) == 1;
                crc <<= 1;
                if (!(c15 ^ bit)) continue;
                crc ^= polynomial;
            }
        }
        crc = Integer.reverse(crc) >> 16 & 0xFFFF;
        return crc;
    }
}

