/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.extcap;

import com.silabs.na.pcap.IPcapOutput;
import com.silabs.pti.adapter.AdapterPort;
import com.silabs.pti.adapter.AdapterSocketConnector;
import com.silabs.pti.adapter.DebugChannelFramer;
import com.silabs.pti.adapter.IConnection;
import com.silabs.pti.adapter.IConnectionListener;
import com.silabs.pti.adapter.IConnectivityLogger;
import com.silabs.pti.extcap.IExtcapInterface;
import com.silabs.pti.format.IDebugChannelExportOutput;
import com.silabs.pti.format.PcapngFormat;
import com.silabs.pti.log.PtiSeverity;
import java.io.File;
import java.io.IOException;

public class ExtcapCapture
implements IConnectivityLogger,
IConnectionListener {
    private final String ifc;
    private final String fifo;
    private AdapterSocketConnector adapterConnector;
    private boolean isFinished = false;
    private int messageCount = 0;
    private IExtcapInterface ec;
    private final PcapngFormat pcapFormat = new PcapngFormat(PcapngFormat.Mode.DCH);
    private IDebugChannelExportOutput<IPcapOutput> output;

    public ExtcapCapture(String ifc, String fifo) {
        this.ifc = ifc;
        this.fifo = fifo;
    }

    public void capture(IExtcapInterface extcapInterface) throws IOException {
        this.ec = extcapInterface;
        this.ec.log("capture: start capturing on adapter '" + this.ifc + "'");
        this.adapterConnector = new AdapterSocketConnector();
        this.output = this.pcapFormat.createOutput(new File(this.fifo), false);
        this.pcapFormat.writeHeader(this.output.writer());
        IConnection c = this.adapterConnector.createConnection(this.ifc, AdapterPort.DEBUG.defaultPort(), this);
        DebugChannelFramer debugChannelFramer = new DebugChannelFramer(true);
        c.setFramers(debugChannelFramer, debugChannelFramer);
        c.connect();
        c.addConnectionListener(this);
        while (!this.isFinished) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ie) {
                // empty catch block
                break;
            }
        }
        this.ec.log("capture: stop capturing on adapter '" + this.ifc + "'");
    }

    @Override
    public int bpsRecordPeriodMs() {
        return 5000;
    }

    @Override
    public void connectionStateChanged(boolean isConnected) {
        if (!isConnected) {
            this.isFinished = true;
        }
    }

    @Override
    public int count() {
        return this.messageCount;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void log(PtiSeverity severity, String message, Throwable throwable) {
        this.ec.log("capture " + severity.name().toLowerCase() + ": " + message + (String)(throwable == null ? "" : " [" + throwable.getMessage() + "]"));
    }

    @Override
    public void messageReceived(byte[] message, long pcTime) {
        ++this.messageCount;
        try {
            this.pcapFormat.formatRawBytes(this.output.writer(), pcTime, message, 0, message.length);
        }
        catch (IOException ioe) {
            if (!this.isFinished) {
                this.ec.log("capture error: could not write PCAP file any more [" + ioe.getMessage() + "]");
            }
            this.isFinished = true;
        }
    }
}

