/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.filter;

import com.silabs.pti.debugchannel.DebugMessage;
import com.silabs.pti.debugchannel.DebugMessageType;
import com.silabs.pti.filter.IDebugMessageFilter;
import com.silabs.pti.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

class TypeInFilter
implements IDebugMessageFilter {
    private List<Integer> ints = new ArrayList<Integer>();
    private List<String> names = new ArrayList<String>();

    TypeInFilter(String types) {
        for (String s : types.split(Pattern.quote(","))) {
            s = s.toLowerCase();
            try {
                this.ints.add(MiscUtil.parseInt(s));
            }
            catch (NumberFormatException e) {
                this.names.add(s);
            }
        }
    }

    @Override
    public boolean isMessageKept(DebugMessage message) {
        int dt = message.debugType();
        for (Integer i : this.ints) {
            if (dt != i) continue;
            return true;
        }
        DebugMessageType dmt = DebugMessageType.get(dt);
        for (String s : this.names) {
            if (!dmt.description().toLowerCase().equals(s)) continue;
            return true;
        }
        return false;
    }
}

