/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.filter;

import com.silabs.pti.debugchannel.DebugMessage;
import com.silabs.pti.filter.IDebugMessageFilter;
import java.text.ParseException;
import java.util.regex.Pattern;

class WithinFilter
implements IDebugMessageFilter {
    public static final int SIZE = 0;
    public static final int TIME = 1;
    private int mode;
    private long lowerBound;
    private long upperBound;

    WithinFilter(int mode, String values) throws ParseException {
        this.mode = mode;
        String[] s = values.split(Pattern.quote(","));
        if (s.length != 2) {
            throw new ParseException("Two values required: " + values, 0);
        }
        try {
            this.lowerBound = Long.parseLong(s[0]);
            this.upperBound = Long.parseLong(s[1]);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Not a number: " + values, 0);
        }
    }

    @Override
    public boolean isMessageKept(DebugMessage message) {
        switch (this.mode) {
            case 0: {
                return (long)message.contentLength() >= this.lowerBound && (long)message.contentLength() <= this.upperBound;
            }
            case 1: {
                return message.networkTime() >= this.lowerBound && message.networkTime() <= this.upperBound;
            }
        }
        return false;
    }
}

