/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.format;

import com.silabs.na.pcap.util.ByteArrayUtil;
import com.silabs.pti.debugchannel.DebugMessage;
import com.silabs.pti.debugchannel.EventType;
import com.silabs.pti.debugchannel.RadioConfiguration;
import com.silabs.pti.format.IDebugChannelExportFormat;
import com.silabs.pti.format.IDebugChannelExportOutput;
import com.silabs.pti.format.PrintStreamOutput;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public class LogFileFormat
implements IDebugChannelExportFormat<PrintStream> {
    @Override
    public IDebugChannelExportOutput<PrintStream> createOutput(File f, boolean append) throws IOException {
        return new PrintStreamOutput(f, append);
    }

    @Override
    public IDebugChannelExportOutput<PrintStream> createStdoutOutput() {
        return new PrintStreamOutput(System.out);
    }

    @Override
    public void writeHeader(PrintStream out) throws IOException {
        out.println("# (c) Ember - InSight Desktop");
    }

    @Override
    public String description() {
        return "Parsed debug messages, written into a file that Network Analyzer can import.";
    }

    @Override
    public boolean isUsingRawBytes() {
        return false;
    }

    @Override
    public boolean isUsingDebugMessages() {
        return true;
    }

    @Override
    public boolean formatDebugMessage(PrintStream out, String originator, DebugMessage dm, EventType type) throws IOException {
        byte[] contents = dm.eventContents();
        String x = "[" + dm.networkTime() + " " + RadioConfiguration.FIFTEENFOUR.microsecondDuration(contents.length) + " " + type.value() + " " + type.name() + "] [" + originator + "] [" + ByteArrayUtil.formatByteArray((byte[])contents) + "]";
        out.println(x);
        return true;
    }

    @Override
    public boolean formatRawBytes(PrintStream out, long pcTimeMs, byte[] rawBytes, int offset, int length) {
        return false;
    }

    @Override
    public void writeRawUnframedData(PrintStream out, byte[] rawBytes, int offset, int length) throws IOException {
    }
}

