/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.format;

import com.silabs.na.pcap.util.ByteArrayUtil;
import com.silabs.pti.debugchannel.DebugMessage;
import com.silabs.pti.debugchannel.EventType;
import com.silabs.pti.format.IDebugChannelExportFormat;
import com.silabs.pti.format.IDebugChannelExportOutput;
import com.silabs.pti.format.PrintStreamOutput;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public class RawFileFormat
implements IDebugChannelExportFormat<PrintStream> {
    public static String RAW_PREFIX = "[ ";
    public static String RAW_SUFFIX = " ]";

    @Override
    public IDebugChannelExportOutput<PrintStream> createOutput(File f, boolean append) throws IOException {
        return new PrintStreamOutput(f, append);
    }

    @Override
    public IDebugChannelExportOutput<PrintStream> createStdoutOutput() {
        return new PrintStreamOutput(System.out);
    }

    @Override
    public void writeHeader(PrintStream out) {
    }

    @Override
    public String description() {
        return "Raw bytes of deframed debug messages, one message per line.";
    }

    @Override
    public boolean isUsingRawBytes() {
        return true;
    }

    @Override
    public boolean isUsingDebugMessages() {
        return true;
    }

    @Override
    public boolean formatDebugMessage(PrintStream out, String originator, DebugMessage dm, EventType type) {
        return false;
    }

    @Override
    public boolean formatRawBytes(PrintStream out, long pcTimeMs, byte[] rawBytes, int offset, int length) throws IOException {
        String x = RAW_PREFIX + ByteArrayUtil.formatByteArray((byte[])rawBytes, (int)offset, (int)length, (boolean)true, (boolean)true) + RAW_SUFFIX;
        out.println(x);
        return true;
    }

    @Override
    public void writeRawUnframedData(PrintStream out, byte[] rawBytes, int offset, int length) throws IOException {
    }
}

