/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.protocol;

import com.silabs.pti.debugchannel.EventType;
import com.silabs.pti.protocol.Protocol;
import com.silabs.pti.util.MiscUtil;

public class RadioInfoEfr32 {
    private RadioInfoEfr32() {
    }

    public static int determineRadioInfoLength(EventType type, byte[] payload, boolean hintBluetooth) {
        if (payload == null || payload.length < 2) {
            return 0;
        }
        byte endByte = payload[payload.length - 1];
        byte penultimateByte = payload[payload.length - 2];
        int len = RadioInfoEfr32.lengthFromLastByte(endByte);
        boolean isMissingPtiProtocol = RadioInfoEfr32.isMissingPtiProtocol(endByte, penultimateByte);
        if (isMissingPtiProtocol) {
            int length = hintBluetooth ? Protocol.crcLen(Protocol.BLE, payload) + 1 : 3;
            if (type.isRx()) {
                ++length;
            }
            return length;
        }
        int junkBytesLength = 0;
        Protocol p = RadioInfoEfr32.protocolFromPenultimateByte(penultimateByte);
        if (p.isUndetermined() && hintBluetooth) {
            p = Protocol.BLE;
        }
        if (p == Protocol.BLE && type.isRx() && RadioInfoEfr32.doesRxHaveRadioCfg(len)) {
            junkBytesLength = RadioInfoEfr32.junkBytesLength(payload);
        }
        return Protocol.crcLen(p, payload) + 4 + junkBytesLength + len;
    }

    public static boolean doesRxHaveRadioCfg(int len) {
        switch (len) {
            case 1: 
            case 5: {
                return false;
            }
            case 2: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static Protocol determineProtocol(byte[] payload) {
        if (payload == null || payload.length < 2) {
            return null;
        }
        byte penultimate = payload[payload.length - 2];
        if (!RadioInfoEfr32.isMissingPtiProtocol(payload[payload.length - 1], penultimate)) {
            return RadioInfoEfr32.protocolFromPenultimateByte(penultimate);
        }
        return null;
    }

    public static int junkBytesLength(byte[] payload) {
        int index = payload.length - 4;
        if (index >= 0) {
            byte radioConfig = payload[index];
            return RadioInfoEfr32.bleLengthFromRadioConfigByte(radioConfig);
        }
        return 0;
    }

    public static int bleLengthFromRadioConfigByte(byte value) {
        return (MiscUtil.unsignedByteToInt(value) & 0xF8) >> 3;
    }

    public static int versionFromLastByte(byte value) {
        return MiscUtil.unsignedByteToInt(value) & 7;
    }

    public static int lengthFromLastByte(byte value) {
        return (MiscUtil.unsignedByteToInt(value) & 0x38) >> 3;
    }

    public static boolean isMissingPtiProtocol(byte lastByte, byte penultimateByte) {
        int nibble1 = MiscUtil.unsignedByteToInt(lastByte) >> 4;
        int nibble2 = MiscUtil.unsignedByteToInt(penultimateByte) >> 4;
        return nibble1 == 15 || nibble2 == 15;
    }

    public static Protocol protocolFromPenultimateByte(byte value) {
        int n = MiscUtil.unsignedByteToInt(value) & 0xF;
        return Protocol.resolve(n);
    }

    public static int channel(byte[] payload) {
        if (payload.length < 2) {
            return -1;
        }
        if (RadioInfoEfr32.isMissingPtiProtocol(payload[payload.length - 1], payload[payload.length - 2])) {
            return -1;
        }
        return payload[payload.length - 3] & 0x3F;
    }
}

