/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class MiscUtil {
    private static long networkInterfaceRefreshInterval = 5000L;
    private static long nextNetworkInterfaceFetch = 0L;
    private static NetworkInterface[] lastNetworkInterfaces;

    private static NetworkInterface[] getRecentNetworkInterfaces() {
        long now = System.currentTimeMillis();
        if (now >= nextNetworkInterfaceFetch) {
            block4: {
                try {
                    ArrayList<NetworkInterface> list = new ArrayList<NetworkInterface>();
                    Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                    while (en.hasMoreElements()) {
                        list.add(en.nextElement());
                    }
                    lastNetworkInterfaces = list.toArray(new NetworkInterface[list.size()]);
                }
                catch (SocketException e) {
                    if (lastNetworkInterfaces != null) break block4;
                    lastNetworkInterfaces = new NetworkInterface[0];
                }
            }
            nextNetworkInterfaceFetch = now + networkInterfaceRefreshInterval;
        }
        return lastNetworkInterfaces;
    }

    public static List<InetAddress> getIpAddresses() {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        try {
            for (NetworkInterface ni : MiscUtil.getRecentNetworkInterfaces()) {
                if (!ni.isUp()) continue;
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress ia = addrs.nextElement();
                    if (ia.isLoopbackAddress() || addresses.contains(ia)) continue;
                    addresses.add(ia);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return addresses;
    }

    public static int hexDigitValue(char digit) {
        if ('0' <= digit && digit <= '9') {
            return digit - 48;
        }
        if ('A' <= digit && digit <= 'F') {
            return digit - 65 + 10;
        }
        if ('a' <= digit && digit <= 'f') {
            return digit - 97 + 10;
        }
        return -1;
    }

    public static int parseInt(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("Expecting number: " + s);
        }
        try {
            s = s.trim();
            if (s.startsWith("0x") || s.startsWith("0X")) {
                if ((s = s.substring(2)).length() == 8) {
                    char firstCh = s.charAt(0);
                    if (firstCh == '8' || firstCh == '9' || firstCh >= 'A' && firstCh <= 'F' || firstCh >= 'a' && firstCh <= 'f') {
                        long l = Long.parseLong(s, 16);
                        return (int)(l & 0xFFFFFFFFFFFFFFFFL);
                    }
                    return Integer.parseInt(s, 16);
                }
                return Integer.parseInt(s, 16);
            }
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            throw nfe;
        }
        catch (Exception e) {
            throw new NumberFormatException("Expecting number: " + s);
        }
    }

    public static byte reverseBits(byte b) {
        int x = 0 | b << 8;
        return (byte)(Integer.reverse(x) >> 16 & 0xFFFF);
    }

    public static byte[] reverseBytes(byte[] old) {
        byte[] result = new byte[old.length];
        for (int i = 0; i < old.length; ++i) {
            result[i] = old[old.length - i - 1];
        }
        return result;
    }

    public static Number byteArrayToFloat(byte[] raw, int offset, int length, boolean bigEndian) {
        ByteBuffer bb;
        if (bigEndian) {
            bb = ByteBuffer.wrap(raw, offset, length);
        } else {
            byte[] b = new byte[length];
            System.arraycopy(raw, offset, b, 0, length);
            b = MiscUtil.reverseBytes(b);
            bb = ByteBuffer.wrap(b);
        }
        switch (length) {
            case 4: {
                return Float.valueOf(bb.getFloat());
            }
            case 8: {
                return bb.getDouble();
            }
        }
        throw new IllegalArgumentException("Only floats of size 4 or 8 can be decoded.");
    }

    public static int unsignedByteToInt(byte b) {
        return 0xFF & b;
    }
}

