/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.jface.text.rules;

import com.silabs.jface.text.rules.IHeaderContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class StringContent
implements IHeaderContent<String> {
    private static final List<String> SortedDelimiters = Collections.unmodifiableList(Arrays.stream(new String[]{"\r", "\n", "\r\n"}).sorted((a, b) -> b.length() - a.length()).collect(Collectors.toList()));
    private final List<LineItem> lines;
    private final String origContent;

    public StringContent(String content) {
        this.origContent = content != null ? content : "";
        this.lines = StringContent.split(this.origContent);
    }

    @Override
    public int getLength() {
        int len = 0;
        for (LineItem line : this.lines) {
            len += line.getLength();
        }
        return len;
    }

    @Override
    public String[] getLegalLineDelimiters() {
        String[] delims = new String[SortedDelimiters.size()];
        SortedDelimiters.toArray(delims);
        return delims;
    }

    @Override
    public int getLineOfOffset(int offset) throws IHeaderContent.ContentException {
        if (offset < 0 || offset >= this.getLength()) {
            throw new IHeaderContent.ContentException("Invalid offset: " + offset);
        }
        LineItem searchItem = new LineItem(offset, null, null);
        LineItem[] items = this.lines.toArray(new LineItem[this.lines.size()]);
        int index = Arrays.binarySearch(items, searchItem, (o1, o2) -> o1.getOffset() - o2.getOffset());
        if (index < 0) {
            index = -1 - index;
            --index;
        }
        return index;
    }

    @Override
    public int getLineOffset(int line) throws IHeaderContent.ContentException {
        if (line < 0 || this.lines.size() <= line) {
            throw new IHeaderContent.ContentException("Invalid line index");
        }
        return this.lines.get(line).getOffset();
    }

    @Override
    public int getChar(int offset) throws IHeaderContent.ContentException {
        int line = this.getLineOfOffset(offset);
        LineItem item = this.lines.get(line);
        int index = offset - item.getOffset();
        char ch = item.getCompleteText().charAt(index);
        return ch;
    }

    @Override
    public String get(int offset, int length) throws IHeaderContent.ContentException {
        if (offset + length > this.getLength()) {
            throw new IHeaderContent.ContentException("request exceeds content size");
        }
        StringBuilder sb = new StringBuilder(length);
        int len = length;
        int off = offset;
        int line = this.getLineOfOffset(off);
        while (len > 0) {
            LineItem item = this.lines.get(line);
            ++line;
            int index = off - item.getOffset();
            int strLen = Math.min(item.getLength() - index, len);
            String str = item.getCompleteText().substring(index, index + strLen);
            sb.append(str);
            off += strLen;
            len -= strLen;
        }
        String text = sb.toString();
        return text;
    }

    @Override
    public void replace(int offset, int length, String text) throws IHeaderContent.ContentException {
        String replaceText;
        String string = replaceText = text == null ? "" : text;
        if (length == 0 && replaceText.length() == 0) {
            return;
        }
        if (offset == this.getLength() && length == 0) {
            this.replaceAtEnd(replaceText);
            return;
        }
        int startLine = this.getLineOfOffset(offset);
        int startIndex = offset - this.getLineOffset(startLine);
        int endLine = this.getLineOfOffset(offset + length);
        int endIndex = offset + length - this.getLineOffset(endLine);
        if (startLine == endLine) {
            if (!SortedDelimiters.stream().anyMatch(replaceText::contains)) {
                LineItem singleItem = this.lines.get(startLine);
                singleItem.replace(startIndex, length, replaceText);
                int diff = replaceText.length() - length;
                int i = startLine + 1;
                while (i < this.lines.size()) {
                    this.lines.get((int)i).offset += diff;
                    ++i;
                }
                return;
            }
        }
        LineItem firstItem = this.lines.get(startLine);
        LineItem lastItem = this.lines.get(endLine);
        String preStr = firstItem.getCompleteText().substring(0, startIndex);
        String postStr = lastItem.getCompleteText().substring(endIndex);
        int firstOffset = firstItem.getOffset();
        if (startLine != endLine) {
            int firstReplaceLen = Math.min(firstItem.getLength() - startIndex, length);
            firstItem.replace(startIndex, firstReplaceLen, "");
            int lastReplaceLen = Math.max(endIndex, length);
            lastItem.replace(0, lastReplaceLen, "");
        } else {
            int start = offset - firstItem.offset;
            int len = Math.min(length, firstItem.getLength());
            firstItem.replace(start, len, "");
        }
        int i = endLine;
        while (i >= startLine + 1) {
            this.lines.remove(i);
            --i;
        }
        this.lines.remove(startLine);
        List<LineItem> insertLines = StringContent.split(preStr + replaceText + postStr);
        int diff = replaceText.length() - length;
        this.extracted(startLine, firstOffset, insertLines, diff);
    }

    private void extracted(int startLine, int firstOffset, List<LineItem> insertLines, int diff) {
        int endLine = startLine + insertLines.size();
        int insertOffset = firstOffset;
        int i = 0;
        while (i < insertLines.size()) {
            LineItem line = insertLines.get(i);
            this.lines.add(startLine + i, line);
            line.offset = i == 0 ? firstOffset : (line.offset += insertOffset);
            ++i;
        }
        if (diff != 0) {
            i = endLine;
            while (i < this.lines.size()) {
                this.lines.get((int)i).offset += diff;
                ++i;
            }
        }
    }

    private void replaceAtEnd(String replaceText) {
        String preStr = "";
        int lastOffset = -1;
        if (this.lines.size() > 0) {
            int indexLast = this.lines.size() - 1;
            LineItem lastLine = this.lines.get(indexLast);
            lastOffset = lastLine.getOffset();
            if (lastLine.lineEnding.length() == 0) {
                preStr = lastLine.getText();
                this.lines.remove(indexLast);
            }
        }
        List<LineItem> appendLines = StringContent.split(preStr + replaceText);
        this.lines.addAll(appendLines);
        if (lastOffset > 0) {
            int off = lastOffset;
            appendLines.forEach(l -> {
                int n2 = l.offset = l.offset + off;
            });
        }
    }

    public String getOriginalContent() {
        return this.origContent;
    }

    @Override
    public String getContent() {
        StringBuilder sb = new StringBuilder(this.origContent.length());
        this.lines.forEach(l -> {
            StringBuilder stringBuilder2 = sb.append(l.getCompleteText());
        });
        return sb.toString();
    }

    private static List<LineItem> split(String origContent) {
        ArrayList<LineItem> lines = new ArrayList<LineItem>();
        int start = 0;
        int offset = 0;
        while (offset < origContent.length()) {
            String delim = StringContent.checkEOL(origContent, offset, SortedDelimiters);
            if (delim == null) {
                ++offset;
                continue;
            }
            int nextStart = offset + delim.length();
            String lineText = origContent.substring(start, nextStart - delim.length());
            lines.add(new LineItem(start, lineText, delim));
            offset = start = nextStart;
        }
        if (start < origContent.length()) {
            String lineText = origContent.substring(start);
            lines.add(new LineItem(start, lineText, ""));
        }
        return lines;
    }

    private static String checkEOL(String text, int offset, List<String> delims) {
        for (String delim : delims) {
            boolean found = StringContent.checkDelim(text, offset, delim);
            if (!found) continue;
            return delim;
        }
        return null;
    }

    private static boolean checkDelim(String text, int offset, String delim) {
        if (offset + delim.length() > text.length()) {
            return false;
        }
        int i = 0;
        while (i < delim.length()) {
            if (delim.charAt(i) != text.charAt(offset + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.origContent.length());
        sb.append("String content:\n").append("line count: " + this.lines.size()).append(" :: ");
        boolean first = true;
        for (LineItem l : this.lines) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(l.toString());
        }
        String content = this.getContent();
        if (!content.equals(this.origContent)) {
            sb.append("\n").append("Original content:\n").append(this.origContent);
        }
        return sb.toString();
    }

    private static class LineItem {
        private static final String EOF_ENDING = "";
        private int offset;
        private String lineText;
        private String lineEnding;

        public LineItem(int offset, String text, String ending) {
            this.offset = offset;
            this.lineText = text;
            this.lineEnding = ending;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.lineText.length() + this.lineEnding.length();
        }

        public String getText() {
            return this.lineText;
        }

        public String getCompleteText() {
            return this.lineText + this.lineEnding;
        }

        public int replace(int start, int len, String text) throws IHeaderContent.ContentException {
            if (start < 0) {
                throw new IHeaderContent.ContentException("Invalid negative start offset: " + start);
            }
            if (len < 0) {
                throw new IHeaderContent.ContentException("Invalid length: " + len);
            }
            if (text == null) {
                text = EOF_ENDING;
            }
            if (len == 0 && text.length() == 0) {
                return 0;
            }
            StringBuilder sb = new StringBuilder(this.getCompleteText());
            sb.replace(start, start + len, text);
            this.lineText = sb.toString();
            this.lineEnding = EOF_ENDING;
            for (String delim : SortedDelimiters) {
                if (!this.lineText.endsWith(delim)) continue;
                this.lineText = this.lineText.substring(0, this.lineText.length() - delim.length());
                this.lineEnding = delim;
                break;
            }
            int diff = text.length() - len;
            return diff;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(256);
            sb.append("[offset=").append(this.offset).append(", {").append(this.lineText).append("}, ").append(" EOL=");
            switch (this.lineEnding) {
                case "\r": {
                    sb.append("\\r");
                    break;
                }
                case "\n": {
                    sb.append("\\n");
                    break;
                }
                case "\r\n": {
                    sb.append("\\r\\n");
                    break;
                }
                case "": {
                    sb.append("<EOF>");
                    break;
                }
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

