/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.internal.part.core;

import com.silabs.java.utils.FrameUtil;
import com.silabs.ss.platform.api.apack.core.model.FunctionType;
import com.silabs.ss.platform.api.device.core.DeviceManager;
import com.silabs.ss.platform.api.device.core.IDevice;
import com.silabs.ss.support.mcu.api.part.core.MCUUtils;
import java.util.HashMap;
import java.util.Map;

public class FlashBytes {
    public static final FunctionType TYPE = FunctionType.make((String)"flash-bytes");
    public static final String ARG_SERIAL_NUMBER = "sn";
    public static final String ARG_ADDRESS = "addr";
    public static final String ARG_TIF = "tif";
    public static final String ARG_BASE_ADDR = "start";
    public static final String ARG_BYTES = "bytes";
    public static final String ARG_LENGTH = "length";
    public static final String ARG_RESET = "reset";
    public static final String ARG_RUN = "run";
    public static final String ARG_PART = "part";

    public static Map<String, Object> makeArguments(IDevice device, String part, long baseAddress, boolean reset, boolean run, byte[] bytes, int length) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (device.hardware().adapterIPAddress() != null) {
            args.put(ARG_ADDRESS, device.hardware().adapterIPAddress());
        } else {
            args.put(ARG_SERIAL_NUMBER, device.hardware().adapterSerialNumber());
        }
        args.put(ARG_TIF, MCUUtils.getTargetInterface(device));
        DeviceManager.applyConnectionOptions((IDevice)device, args);
        args.put(ARG_BASE_ADDR, "0x" + Integer.toHexString((int)baseAddress));
        args.put(ARG_BYTES, "0x" + FrameUtil.formatByteArray((byte[])bytes, (boolean)false));
        args.put(ARG_LENGTH, length);
        args.put(ARG_RESET, reset);
        args.put(ARG_RUN, run);
        args.put(ARG_PART, part);
        return args;
    }
}

