/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.toolchain.core;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.variables.EnvironmentVariableUtils;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDescriptor;
import com.silabs.ss.framework.project.api.toolchain.core.Toolchain;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.IWriteableDescriptor;
import com.silabs.ss.platform.api.descriptor.core.IWriteableVersionedDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.CoreHardwareProperties;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.rcp.core.IPathUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;

public class ToolchainUtils {
    public static final String DETECT_TOOLCHAIN_STUBS = "detectToolchainStubs";

    private ToolchainUtils() {
    }

    public static IToolchainDescriptor[] findToolchainStubs() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put(DETECT_TOOLCHAIN_STUBS, true);
        return (IToolchainDescriptor[])Toolchain.manager().detectDescriptors(false, params, null);
    }

    public static void scanFromEnvironmmentVariables(String javaVariable, String envVariable, Consumer<List<IPath>> cons) {
        String lookupLoc = System.getProperty(javaVariable);
        if (TextUtils.isEmpty((String)lookupLoc)) {
            lookupLoc = EnvironmentVariableUtils.getBuildsTestsValue((String)envVariable);
        }
        if (TextUtils.isEmpty((String)lookupLoc)) {
            return;
        }
        List tcDirs = TextUtils.splitByCharacterToList((String)lookupLoc, (char)';').stream().map(IPathUtils::createPath).filter(p -> p.toFile().isDirectory()).collect(Collectors.toList());
        cons.accept(tcDirs);
    }

    public static void setupHardwareProperties(IWriteableVersionedDescriptor toolchain, String tcName) {
        toolchain.setProperty(CoreHardwareProperties.NAME, (Object)tcName);
    }

    public static void registerCliToolchain(String tcType, String filePath) {
        if (TextUtils.isEmpty((String)filePath)) {
            IToolchainDescriptor tcDesc = ToolchainUtils.findCliToolchain(tcType);
            Toolchain.manager().removeDescriptor((IDescriptor)tcDesc);
        } else {
            IToolchainDescriptor tcDesc = (IToolchainDescriptor)Toolchain.manager().createDescriptor();
            ((IWriteableVersionedDescriptor)tcDesc).setUnversionedId(ToolchainUtils.getCliTcId(tcType));
            ((IWriteableDescriptor)tcDesc).setProperty(CoreProperties.HIDDEN, (Object)true);
            ((IWriteableDescriptor)tcDesc).setProperty(CoreProperties.INSTALLATION_PATH, (Object)new File(filePath).toURI());
            Toolchain.manager().registerDescriptor((IDescriptor)tcDesc);
        }
    }

    public static IToolchainDescriptor findCliToolchain(String tcType) {
        return (IToolchainDescriptor)Toolchain.manager().findCompatibleDescriptor(ToolchainUtils.getCliTcId(tcType));
    }

    private static String getCliTcId(String tcType) {
        return "cli." + tcType;
    }
}

