/*
 * Decompiled with CFR 0.152.
 */
package com.arm.cmsis.parser;

import com.arm.cmsis.parser.CommentRule;
import com.arm.cmsis.parser.MacroValueRule;
import com.arm.cmsis.parser.TagRule;
import com.silabs.jface.text.rules.IHeaderContent;
import com.silabs.jface.text.rules.IRule;
import com.silabs.jface.text.rules.IToken;
import com.silabs.jface.text.rules.RuleBasedScanner;
import com.silabs.jface.text.rules.SingleLineRule;
import com.silabs.jface.text.rules.Token;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;

public class ConfigWizardScanner
extends RuleBasedScanner {
    public static final String CONFIG_BLOCK_COMMENT_START = "__config_block_comment_start";
    public static final String CONFIG_BLOCK_COMMENT_END = "__config_block_comment_end";
    public static final String CONFIG_COMMENT = "__config_comment";
    public static final String CONFIG_TAG = "__config_tag";
    public static final String CONFIG_MARK = "__config_mark";
    public static final String CONFIG_NUMBER = "__config_number";
    public static final String CONFIG_STRING = "__config_string";
    public static final String CONFIG_MACROVALUE = "__config_macrovalue";
    public static final String CONFIG_DEFAULT = "__config_default";
    private int prevLine;
    private boolean startConfig;
    private boolean inBlockComment;
    private static final int mapSize = 7;
    private Map<Integer, Boolean> commentStarted = new LinkedHashMap<Integer, Boolean>(10, 0.7f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, Boolean> eldest) {
            return this.size() > 7;
        }
    };
    static Pattern ExtraWhitespacePattern = Pattern.compile("\\s+");
    static Pattern WhitespaceAndDelimitersPattern = Pattern.compile("[\\s<>]");

    public ConfigWizardScanner() {
        LinkedList<SingleLineRule> rules = new LinkedList<SingleLineRule>();
        rules.add(new CommentRule("//", (IToken)new Token((Object)CONFIG_COMMENT)));
        rules.add(new CommentRule("/*", (IToken)new Token((Object)CONFIG_BLOCK_COMMENT_START)));
        rules.add(new CommentRule("*/", (IToken)new Token((Object)CONFIG_BLOCK_COMMENT_END)));
        rules.add(new SingleLineRule("<<<", ">>>", (IToken)new Token((Object)CONFIG_MARK)));
        rules.add(new TagRule((IToken)new Token((Object)CONFIG_TAG)));
        rules.add(new MacroValueRule((IToken)new Token((Object)CONFIG_MACROVALUE)));
        this.setRules(rules.toArray(new IRule[rules.size()]));
        this.setDefaultReturnToken((IToken)new Token((Object)CONFIG_DEFAULT));
    }

    public void clear() {
        this.prevLine = 0;
        this.startConfig = false;
        this.inBlockComment = false;
        this.commentStarted.clear();
    }

    /*
     * Unable to fully structure code
     */
    public IToken nextToken() {
        token = super.nextToken();
        while (!this.startConfig && !token.isEOF()) {
            currLine = this.getCurrentLineNumber();
            if (this.getTokenType(token) == ETokenType.COMMENT) {
                this.commentStarted.put(currLine, true);
            }
            if (this.getTokenType(token) == ETokenType.START && this.commentStarted.containsKey(currLine) && this.commentStarted.get(currLine).booleanValue()) {
                this.startConfig = true;
                this.storeCurrentToken();
                return token;
            }
            token = super.nextToken();
        }
        if (!token.isEOF()) ** GOTO lbl17
        return token;
lbl-1000:
        // 1 sources

        {
            this.storeCurrentToken();
            token = super.nextToken();
lbl17:
            // 2 sources

            ** while (this.getTokenType((IToken)token) == ETokenType.DEFAULT)
        }
lbl18:
        // 1 sources

        currLine = this.getCurrentLineNumber();
        if (!this.commentStarted.containsKey(currLine)) {
            this.commentStarted.put(currLine, false);
        }
        if (this.getTokenType(token) == ETokenType.COMMENT) {
            this.commentStarted.put(currLine, true);
        }
        if (!(this.commentStarted.get(currLine).booleanValue() || this.inBlockComment || this.getTokenType(token) != ETokenType.NUMBER && this.getTokenType(token) != ETokenType.MACROVALUE)) {
            this.storeCurrentToken();
            return token;
        }
        token = this.processNextToken(token, currLine);
        return token;
    }

    private IToken processNextToken(IToken token, int currLine) {
        while (this.continueLoop(currLine, token)) {
            if (token.isEOF() || this.getTokenType(token) == ETokenType.EOC) {
                return token;
            }
            if (this.getTokenTag(token).equals(CONFIG_TAG) && this.commentStarted.get(currLine).booleanValue()) {
                this.storeCurrentToken();
                return token;
            }
            if (this.prevLine != currLine) {
                this.commentStarted.put(currLine, false);
                if (!(this.inBlockComment || this.getTokenType(token) != ETokenType.MACROVALUE && this.getTokenType(token) != ETokenType.NUMBER && this.getTokenType(token) != ETokenType.START)) {
                    this.storeCurrentToken();
                    return token;
                }
            }
            if (this.getTokenType(token) == ETokenType.COMMENT) {
                this.commentStarted.put(currLine, true);
            }
            if (this.getTokenType(token) != ETokenType.DEFAULT) {
                this.storeCurrentToken();
            }
            token = super.nextToken();
            currLine = this.getCurrentLineNumber();
        }
        return token;
    }

    public String getTokenTag(IToken token) {
        Object obj = token.getData();
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public String getTokenContent(IToken token) {
        if (token.isEOF()) {
            return "";
        }
        int offset = this.getTokenOffset();
        int length = this.getTokenLength();
        try {
            String text = this.fDocument.get(offset, length);
            if (CONFIG_STRING.equals(this.getTokenTag(token))) {
                return text;
            }
            if (CONFIG_MACROVALUE.equals(this.getTokenTag(token))) {
                return text;
            }
            if (CONFIG_MARK.equals(this.getTokenTag(token))) {
                return ConfigWizardScanner.usePattern(ExtraWhitespacePattern, text.trim(), " ");
            }
            return ConfigWizardScanner.usePattern(WhitespaceAndDelimitersPattern, text, "");
        }
        catch (IHeaderContent.ContentException contentException) {
            return null;
        }
    }

    static String usePattern(Pattern p, String str, String replacement) {
        return p.matcher(str).replaceAll(replacement);
    }

    public ETokenType getTokenType(IToken token) {
        if (token.isEOF()) {
            return ETokenType.EOC;
        }
        String tokenContent = this.getTokenContent(token);
        String tag = this.getTokenTag(token);
        if (tag.equals(CONFIG_DEFAULT)) {
            return ETokenType.DEFAULT;
        }
        if (tag.equals(CONFIG_MARK)) {
            return this.processConfigMark(tokenContent);
        }
        if (tag.equals(CONFIG_TAG)) {
            Assert.isTrue((tokenContent.length() > 0 ? 1 : 0) != 0);
            char type = Character.toLowerCase(tokenContent.charAt(0));
            if (Character.isDigit(type) || tokenContent.endsWith("=")) {
                type = tokenContent.charAt(tokenContent.length() - 1);
            }
            switch (type) {
                case 'h': {
                    return ETokenType.HEADING;
                }
                case 'e': {
                    return ETokenType.HEADING_ENABLE;
                }
                case 'c': {
                    return ETokenType.CODE_ENABLE;
                }
                case 'o': {
                    return ETokenType.OPTION;
                }
                case 'q': {
                    return ETokenType.OPTION_CHECK;
                }
                case 's': {
                    return ETokenType.OPTION_STRING;
                }
                case 'n': {
                    return ETokenType.NOTIFICATION;
                }
                case 'i': {
                    return ETokenType.TOOLTIP;
                }
                case '/': {
                    return this.getEndTokenType(tokenContent.charAt(1));
                }
                case '!': {
                    return this.getNextTokenChar(tokenContent.charAt(1));
                }
                case '=': {
                    return ETokenType.VALUE;
                }
                case 'a': {
                    return ETokenType.ARRAY;
                }
                case 'd': {
                    return ETokenType.DEFAULTVALUE;
                }
                case 'f': {
                    return ETokenType.FORMAT;
                }
            }
            return ETokenType.UNKNOWN;
        }
        if (tag.equals(CONFIG_BLOCK_COMMENT_START)) {
            this.inBlockComment = true;
            return ETokenType.BLOCK_COMMENT;
        }
        if (tag.equals(CONFIG_BLOCK_COMMENT_END)) {
            this.inBlockComment = false;
            return ETokenType.BLOCK_COMMENT;
        }
        if (tag.equals(CONFIG_COMMENT)) {
            return ETokenType.COMMENT;
        }
        if (tag.equals(CONFIG_NUMBER)) {
            return ETokenType.NUMBER;
        }
        if (tag.equals(CONFIG_STRING)) {
            return ETokenType.MACROVALUE;
        }
        if (tag.equals(CONFIG_MACROVALUE)) {
            return ETokenType.MACROVALUE;
        }
        return ETokenType.UNKNOWN;
    }

    private ETokenType processConfigMark(String tokenContent) {
        String[] startTokens = new String[]{"Use", "Configuration", "Wizard", "In", "Context", "Menu"};
        String[] endTokens = new String[]{"End", "Of", "Configuration", "Section"};
        String extStartToken = "ext:start";
        String extEndToken = "ext:end";
        if (this.tokenMatch(tokenContent, startTokens)) {
            return ETokenType.START;
        }
        if (this.tokenMatch(tokenContent, endTokens)) {
            return ETokenType.EOC;
        }
        String[] tokens = tokenContent.trim().split("<<<|>>>| ");
        List tokenList = Arrays.stream(tokens).filter(str -> str.trim().length() > 0).collect(Collectors.toList());
        if (!tokenList.isEmpty() && ((String)tokenList.get(0)).equals(extStartToken)) {
            return ETokenType.EXT_START;
        }
        if (!tokenList.isEmpty() && ((String)tokenList.get(0)).equals(extEndToken)) {
            return ETokenType.EXT_END;
        }
        return ETokenType.DEFAULT;
    }

    private boolean tokenMatch(String tokenContent, String[] correctTokens) {
        String[] tokens = tokenContent.trim().split("<<<|>>>| ");
        int j = 0;
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (!token.isEmpty()) {
                if (j == correctTokens.length) {
                    return false;
                }
                if (token.equalsIgnoreCase(correctTokens[j])) {
                    ++j;
                } else {
                    return false;
                }
            }
            ++n2;
        }
        return j == correctTokens.length;
    }

    private ETokenType getEndTokenType(char token) {
        switch (token) {
            case 'h': {
                return ETokenType.HEADING_END;
            }
            case 'e': {
                return ETokenType.HEADING_ENABLE_END;
            }
            case 'c': {
                return ETokenType.CODE_END;
            }
        }
        return ETokenType.UNKNOWN;
    }

    private ETokenType getNextTokenChar(char token) {
        switch (token) {
            case 'c': {
                return ETokenType.CODE_DISABLE;
            }
        }
        return ETokenType.UNKNOWN;
    }

    public String readString() {
        int c;
        StringBuilder sb = new StringBuilder();
        do {
            c = this.read();
            sb.append((char)c);
        } while (c != 60 && c != 10);
        if (c == 60) {
            this.unread();
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString().trim();
    }

    public String readLine() {
        int c;
        StringBuilder sb = new StringBuilder();
        do {
            c = this.read();
            sb.append((char)c);
        } while (c != 10);
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString().trim();
    }

    public int getCurrentLineNumber() {
        try {
            return this.fDocument.getLineOfOffset(this.getTokenOffset());
        }
        catch (IHeaderContent.ContentException contentException) {
            return -1;
        }
    }

    private void storeCurrentToken() {
        this.prevLine = this.getCurrentLineNumber();
    }

    private boolean continueLoop(int currLine, IToken token) {
        if (token.isEOF()) {
            return false;
        }
        if (this.prevLine != currLine || this.getTokenType(token) == ETokenType.DEFAULT || this.getTokenType(token) == ETokenType.COMMENT || this.getTokenType(token) == ETokenType.BLOCK_COMMENT) {
            return true;
        }
        if ((this.getTokenTag(token).equals(CONFIG_TAG) || this.getTokenTag(token).equals(CONFIG_MARK)) && !this.commentStarted.get(currLine).booleanValue()) {
            return true;
        }
        if (this.prevLine == currLine && this.commentStarted.get(currLine).booleanValue() && (this.getTokenType(token) == ETokenType.NUMBER || this.getTokenType(token) == ETokenType.MACROVALUE)) {
            return true;
        }
        return this.inBlockComment && (this.getTokenType(token) == ETokenType.NUMBER || this.getTokenType(token) == ETokenType.MACROVALUE);
    }

    static enum ETokenType {
        COMMENT,
        BLOCK_COMMENT,
        START,
        HEADING,
        HEADING_END,
        HEADING_ENABLE,
        HEADING_ENABLE_END,
        CODE_ENABLE,
        CODE_DISABLE,
        CODE_END,
        OPTION,
        OPTION_CHECK,
        OPTION_STRING,
        NOTIFICATION,
        TOOLTIP,
        EOC,
        VALUE,
        NUMBER,
        MACROVALUE,
        EXT_START,
        EXT_END,
        ARRAY,
        DEFAULTVALUE,
        FORMAT,
        DEFAULT,
        UNKNOWN;

        private static Set<ETokenType> secondaryTypes;

        static {
            secondaryTypes = Set.of(TOOLTIP, NUMBER, MACROVALUE, START, DEFAULTVALUE, FORMAT, VALUE);
        }

        public static boolean isSecondary(ETokenType type) {
            return secondaryTypes.contains((Object)type);
        }
    }
}

